Ext.define('RUMSnapshot.controller.RUMSnapshotController',{
	extend:'Ext.app.Controller',
 	refs:[
 		{selector:'newUtilities',ref:'newUtilities'},
 		{selector:'main',ref:'main'},
 		{selector:'nomeasurepanel',ref:'nomeasurepanel'},
 		{selector:'ReporterSettings',ref:'ReporterSettings'}
 	],
	searchTask: new Ext.util.DelayedTask(function(){
		appConstants.appObj.getController(appConstants.appController).doSearchFilter();
	}),
	foregroundJspUrl:'/final/reporter/RUMSnapshotJson.jsp',
	foregroundControllerUrl:'../servlet/com.eg.ErRUMSnapshotC',
	backgroundControllerUrl:'../servlet/com.eg.ErStartBackGroundReportC',
	isNewFav:false,
	init:function(){
		this.control({
			'main':{
				'afterrender':this.boxready
			},
			'mainform':{
 				'afterrender':this.loadForm
			},
			'newUtilities':{
				'render':this.loadTools
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'egcomponent button[id="compExpand"]':{
				'click': this.expandMe
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'mainform combo[id="er_site"]':
			{
			'select': this.onSelectSiteBy
			},
			'mainform combo[id="er_compType"]':
			{
			'select': this.onSelectCompTypeBy
			},
			'rumsnapshotsettings':{
 				'afterrender':this.loadSettings
			},
			'rumsnapshotsettings combo[name="reportGeneration"]':{
				'select': this.onChangeReportGeneration
			},
			'rumsnapshotsettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'rumsnapshotsettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'rumsnapshotform button[name="submit"]':{
				'click': this.submitReoprt
			},
			'resultpanel button[name="applyFilter"]':{
				'click': this.applyFilter
			},
			'resultpanel button[name="leftApplyFilter"]':{
				'click': this.showResult
			},
			'resultpanel button[name="cancelFilter"]':{
				'click': this.cancelFilter
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},	
			'resultpanel textfield[name="filterSearchBox"]':
			{
				change:this.typewatch
			},
		});
	},
	
	filterMultiselect: function (obj) 
	{
		obj.toggleTriggger();
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (obj.getId()=='compSearch')	
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.publicJsonData.combo.componentCombo);
	},
	expandMe:function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (btn.getId()=='compExpand')
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),componentsTxt,btn);
		}
 	},
	typewatch:function(field, event)
	{
		 this.searchTask.delay(500);
	},
	goTo: function (obj)
	{
 		if (appConstants.frmSchModify == "Yes")
			 this.saveSchedule(obj);
		else
 			this.saveFavorite(obj);
	},
	saveSchedule:function(obj)
	{
 		if(this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
				title: alert_text,
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var target="/final/reporter/ErSaveSchedule.jsp?isSubmit=true&"+this.getQueryString(true,true,true)+"&option=data&com.eg.CSRF_NONCE="+csrfToken;
 		if (obj.getId()=='save')
		{
			if(target!=undefined && target.indexOf("schedule_id")==-1)
				target+='&schedule_id='+appConstants.schedule_id;
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
 	},
	saveFavorite:function(obj)
	{
		var isValid = this.validateMainForm(false);
		/* if(this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any'){
			Ext.MessageBox.show({
				title: alert_text,
				msg: invalidTimelineTxt,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
 		} */
		var target="";
		
		//&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
		if (obj.getId()=='save')
		{
			this.isNewFav=false;
			target="/final/reporter/ErSaveFavorite.jsp?isSubmit=true&"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client&fromFavoriteModify=Yes"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			
			if(target!=undefined && target.indexOf("FavoriteId")==-1)
				target+='&FavoriteId='+appConstants.favorite_id;
			//document.location=target+'&showWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			this.isNewFav=true;
			target="../servlet/com.eg.ErFavoriteC?isSubmit=true&"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
 	},
	saveReportAsPDF:function()
	{
 		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString;
		if (Ext.isEmpty(appConstants.erUtils))
 			appConstants.erUtils = Ext.widget("erutils");

		 appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var s_qryString = appConstants.publicJsonData.urlFields.saveQueryString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="isSubmit=true&"+this.getQueryString(true,true,true)+"&option=data";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function()
	{
 		var s_qryString = "/final/reporter/RUMSnapshotPrint.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString+"&er_view=PRINT&pdfPrint=yes";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	loadReportData:function()
	{
		var resultContainerObj=Ext.getCmp('resultContainer');
		var backGroundPanel=Ext.getCmp('backGroundPanel');
 		var reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		this.hideResults();

		var tmpStartDate = Ext.getCmp('er_stdate').getValue();
		tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEndDate = Ext.getCmp('er_enddate').getValue();
		tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
		/*var result = checkDateTime(tmpStartDate, tmpEndDate);
		if (!result) {
			return;
		}*/
		var startdate = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
		var sthr = Ext.getCmp("er_sthr").getValue();
		var endhr = Ext.getCmp("er_endhr").getValue();
		var stmin = Ext.getCmp("er_stmin").getValue();
		var enmin = Ext.getCmp("er_endmin").getValue();
		if (startdate == enddate && sthr == endhr && stmin == enmin )
		{
			Ext.MessageBox.show({
				title: alert_text,
				msg: _invalidSameTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
 		if(reportGeneration == 'foreground')
		{
			if (appConstants.publicJsonData.hasOwnProperty('NO_DATA') && appConstants.fromRunBtn=='yes')
			{
				this.disableTools();
				this.getNomeasurepanel().show();
			}
			else if (appConstants.publicJsonData.hasOwnProperty('NO_DATA'))
			{
				this.disableTools();
				if(appConstants.publicJsonData.filterDetails!=undefined)
				{
					resultContainerObj.show();
					Ext.getCmp('appNoMespanel').show();
					Ext.getCmp('resultDataPanel').hide();
					this.loadFiterData(appConstants.publicJsonData.filterDetails,appConstants.publicJsonData.totalCheckedCount);
				}
				else
				{
					this.getNomeasurepanel().show();
				}
			}
			else
			{
				if(appConstants.fromRunBtn=='yes')
				{
					Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
				}

				var publicGridData=appConstants.publicJsonData.gridObj;
				var publicSummaryData=appConstants.publicJsonData.Summary;
				var otherInfo = appConstants.publicJsonData.OTHER_INFO;
				if (publicGridData != undefined)
				{
					var dataPageNo = parseInt(otherInfo['dataPageNo']);// current page no
					var isRangeNeed = otherInfo['isRangeNeed'];
					if(dataPageNo == 1)
					{
						this.loadSummaryData(publicSummaryData);
					}
					if(isRangeNeed != 'true' && dataPageNo == 1)
					{
						customPaging =false;
					}
					resultContainerObj.show();
					Ext.getCmp('appNoMespanel').hide();
					Ext.getCmp('resultDataPanel').show();
					this.loadFiterData(appConstants.publicJsonData.filterDetails,appConstants.publicJsonData.totalCheckedCount);
					this.loadGrid(publicGridData);
					this.loadOverAllPageNavigation(otherInfo);
					fromPerBtn = false;
				}
				this.enableTools();
			}	//end of else
		}
		else if(reportGeneration == 'background')
		{
			var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
			if(backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor.slice(0, -3);
				//backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
 			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else if(backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor.slice(0, -3);
			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else
			{
			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</a></div></td></tr></table></td></tr></table>');
			}
			backGroundPanel.show();
		}
		else if(reportGeneration == 'background-xls')
		{
			var backGroundPanel=Ext.getCmp('backGroundPanel');
			var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
			if(backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor.slice(0, -3);
 			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else if(backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor.slice(0, -3);
			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else
			{
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</a></div></td></tr></table></td></tr></table>');
			}
			backGroundPanel.show();
		}
		else if(reportGeneration=="background-csv")
		{
			var backGroundPanel=Ext.getCmp('backGroundPanel');
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
			var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
			if(backgroundReportStatus!= 'undefined')
			{
				if(backgroundReportStatus== 'success')
				{
					var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
					var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
					var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
					var sub = backgroundAnchor.slice(0, -3);
				
					backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
				}
				else if(backgroundReportStatus== 'duplicate')
				{
					var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
					var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
					var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
					var sub = backgroundAnchor.slice(0, -3);
				
					backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
				}
			}
			else
			{
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</a></div></td></tr></table></td></tr></table>');
			}
			backGroundPanel.show();
		}
		else
		{
			console.log('No data found for report generation in json');
		}
		keepResult = false;
	},
	loadSummaryData:function(summaryData)
	{
		if (summaryData!=undefined && !Ext.isEmpty(summaryData))
		{
			var totalHtmlStr = '';
			var userExpStr = '';
			var avgResponseStr = '';
			var uniqueTransStr = '';
			var avgExecutionTime = '';

			
			if(summaryData.TOTALCOUNT!=undefined)
			{
				totalHtmlStr = '<table><tbody><tr><td align="right"><img src="/final/images/spacer.gif" class="iconTransactionsCount"></td><td align="left" style="padding:5px"><span class="newFont_normal24">'+summaryData.TOTALCOUNT+'</span></td></tr><tr><td align="center" colspan="2" style="padding:0px 5px 10px 5px"><span class="font_normal12">'+TransactionsCountTxt+'</span></td></tr></tbody></table>'
			}
			if(summaryData.HEALTHY!=undefined)
			{
				userExpStr = '<div class="btmHeatmapDiv" style="border:0px solid red;margin:15px 5px 0px 0px">'
				var healthValCount = '', slowValCount = '', errorValCount = '';
				var healthValStr = '', slowValStr = '', errorValStr = '';
				var healthVal = summaryData.HEALTHY;
				var slowVal = summaryData.SLOW;
				var errorVal = summaryData.ERROR;
				if(healthVal.indexOf('#')>-1)
				{
					healthValCount = healthVal.substring(healthVal.indexOf('#')+1,healthVal.length);
					healthVal = healthVal.substring(0,healthVal.indexOf('#'));
					healthValStr = healthVal;
				}
				if(slowVal.indexOf('#')>-1)
				{
					slowValCount = slowVal.substring(slowVal.indexOf('#')+1,slowVal.length);
					slowVal = slowVal.substring(0,slowVal.indexOf('#'));
					slowValStr = slowVal;
				}
				if(errorVal.indexOf('#')>-1)
				{
					errorValCount = errorVal.substring(errorVal.indexOf('#')+1,errorVal.length);
					errorVal = errorVal.substring(0,errorVal.indexOf('#'));
					errorValStr = errorVal;
				}
				healthVal = Math.round(healthVal);
				slowVal = Math.round(slowVal);
				errorVal = Math.round(errorVal);
				var total = healthVal+slowVal+errorVal;
				var maxaVal = Math.max(healthVal,slowVal,errorVal);
				var tolerance = 0;

				if(total!=100)
				{
					tolerance = 100-total;
				}

				if(healthVal==maxaVal)
				{
					healthVal=healthVal+tolerance;
				}
				else if(slowVal==maxaVal)
				{
					slowVal=slowVal+tolerance;
				}
				else if (errorVal==maxaVal)
				{
					errorVal=errorVal+tolerance;
				}

				var mainDiv = Ext.select('.btmHeatmapDiv');

				for(var i=0; i<healthVal; i++)
				{
					userExpStr+='<div class="healthyDiv"></div>'
				}
				for(var i=0; i<slowVal; i++)
				{
					userExpStr+='<div class="slowDiv"></div>'
				}
				for(var i=0; i<errorVal; i++)
				{
					userExpStr+='<div class="errorDiv"></div>'
				}
			
				userExpStr += '</div>';


				userExpStr += '<div style="vertical-align:middle;">',
				userExpStr += '<div class="font_normal12" style="height:20px;display:flex;justify-content:left;align-items:center;"><div data-qtip="'+Math.round(healthValCount)+'" style="width:48px;float:left;text-align:right;padding-right:5px;padding-left:5px">'+healthValStr+'%</div><div style="float:left;"> '+HealthyTxt+'</div></div>';
				userExpStr += '<div class="font_normal12" style="height:20px;display:flex;justify-content:left;align-items:center;"><div data-qtip="'+Math.round(slowValCount)+'" style="width:48px;float:left;text-align:right;padding-right:5px;padding-left:5px">'+slowValStr+'%</div><div style="float:left"> '+SlowTxt+'</div></div>';
				userExpStr += '<div class="font_normal12" style="height:20px;display:flex;justify-content:left;align-items:center;"><div data-qtip="'+Math.round(errorValCount)+'" style="width:48px;float:left;text-align:right;padding-right:5px;padding-left:5px">'+errorValStr+'%</div><div style="float:left">'+ErrorTxt+'</div></div>';
				//userExpStr += '<div class="font_normal12" style="height:20px;display:flex;justify-content:left;align-items:center;"><div style="width:48px;float:left;text-align:right;padding-right:5px;padding-left:5px">&nbsp;</div><div style="float:left">&nbsp;</div></div>';
				userExpStr += '</div>';
			}
			if(summaryData.RESPONSETIME!=undefined)
			{
				avgResponseStr = '<table><tbody><tr><td align="right"><img src="/final/images/spacer.gif" class="iconTimeGray"></td><td align="left" style="padding:5px" class="newFont_normal24">'+summaryData.RESPONSETIME+'<span class="newFont_normal12">&nbsp;'+millSecTxt+'</span></td></tr><tr><td align="center" colspan="2" style="padding:0px 5px 10px 5px;line-height:12px"><span class="font_normal12">'+AverageTxt+' <br/> '+Response_TimeTxt+'</span></td></tr></tbody></table>'
			}
			if(summaryData.URLCOUNT!=undefined)
			{
				uniqueTransStr = '<table><tbody><tr><td align="right"><img src="/final/images/spacer.gif" class="iconUniqueTransaction"></td><td align="left" style="padding:5px" class="newFont_normal24">'+summaryData.URLCOUNT+'</td></tr><tr><td align="center" colspan="2" style="padding:0px 5px 10px 5px"><span class="font_normal12">'+Unique_BusinessTxt+'<br/>'+TransactionTxt+'</span></td></tr></tbody></table>'
			}

			var summaryPanel = Ext.getCmp('summaryPanel');
			summaryPanel.removeAll();
			summaryPanel.add({
				xtype:'container',
				columnWidth:0.22,
				cls:'summaryChild',
				html:totalHtmlStr,
			},
			{
				xtype:'container',
				columnWidth:0.34,
				cls:'summaryChild',
				html:userExpStr,
			},
			{
				xtype:'container',
				columnWidth:0.22,
				cls:'summaryChild',
				html:avgResponseStr,
			},
			{
				xtype:'container',
				columnWidth:0.22,
				cls:'summaryChild',
				html:uniqueTransStr,
			});
		}
	},
	loadGrid:function(jsondata)
	{
		activePage=1;
		var me=this;
		var needSort = true;
		if(customPaging)
			needSort = false;
		if (!Ext.isEmpty(jsondata))
		{
			var mainColArray=new Array();
			var fieldsToStore=new Array();

			var col = jsondata.gridCol;
			var gridColUI = jsondata.gridColUI;
			var gridArray = jsondata.gridData;

			for (var key in col)
			{
				var align = 'center';
				var locked = false;
				if(key<4 )
				{
					align = 'left';
				}
				if(key==0)
				{
					locked = true;
				}
				var mainColumn = col[key];
				fieldsToStore.push(mainColumn);
				mainColArray.push({
					header: gridColUI[key],
					sortable:needSort,
					align:'left',
					width:120,
					dataIndex: mainColumn,
					//locked:locked,
					renderer :function(value, metaData, record, row, col, store, gridView)
					{
						if(value!=null && value.indexOf('#@#') >-1)
						{
							metaData.tdCls="iconColumn";
							var url = value.substring(0,value.indexOf('#@#'));
							var state = value.substring(value.indexOf('#@#')+3,value.length);
							var btnIcon = 'btm_rum_dd_icons_healthy';
							if(state=='slow')
							{
								btnIcon = 'btm_rum_dd_icons_slow';
								state = SlowTxt;
							}
							else if(state=='error')
							{
								btnIcon = 'btm_rum_dd_icons_error';
								state = ErrorTxt;
							}
							else
							{
								state = HealthyTxt;
							}
							return '<a onClick=\'javascript:loadPopup("'+url+'");\' href="javascript:void(0)" data-qtip="'+drillDownToolTip+'" data-qclass="yellowTip"> <table><tr><td style="width:25px;"><img src="/final/images/clear.png" class="'+btnIcon+'"/></td><td style="width:45px;padding-top:5px;"><span class="btmrum_status">'+state+'</span></td><td><img src="/final/images/clear.png" class="iconDiagnosis" style="vertical-align:middle;margin-left:5px;margin-top:2px;"/></td></tr></table></a>'
						}
						metaData.tdAttr = 'data-qclass="yellowTip" data-qtip="'+value.trim()+'"';
						value=me.getNumberFormat(value);
						return value;
					},
					doSort: function(state) 
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						var removeTimeZone = 'no';
						console.log(field);
						if(field=='Request Date')
						{
							removeTimeZone = 'yes';
						}
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1!=null && v1.indexOf('#@#') >-1)
								{
									v1 = v1.substring(v1.indexOf('#@#')+3,v1.length);
								}
								if(v2!=null && v2.indexOf('#@#') >-1)
								{
									v2 = v2.substring(v2.indexOf('#@#')+3,v2.length);
								}
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}
								if(removeTimeZone=='yes')
								{
									// here data will be <date> - <Time Zone>
									v1 = v1.substring(0,v1.lastIndexOf('-')-1);
									v2 = v2.substring(0,v2.lastIndexOf('-')-1);
								}
								if(!isNaN(v1) && !isNaN(v2))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;
										v2= isNaN(v2) ? 0 : v2;
									}
								}
								else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime(); 
									v1=new Date(v1).getTime(); 
								}
								// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				});
				if(mainColArray[mainColArray.length-1].dataIndex=='Server Machine')
				{
					mainColArray[mainColArray.length-1].width = 170;
					mainColArray[mainColArray.length-1].align = 'left';
				}
				if(mainColArray[mainColArray.length-1].dataIndex=='Business Context')
				{
					mainColArray[mainColArray.length-1].width = 170;
					mainColArray[mainColArray.length-1].align = 'left';
				}
				if(mainColArray[mainColArray.length-1].dataIndex=='Request Date')
				{
					mainColArray[mainColArray.length-1].width = 180;
				}
				if(mainColArray[mainColArray.length-1].dataIndex=='Business transaction')
				{
					mainColArray[mainColArray.length-1].width = 230;
					mainColArray[mainColArray.length-1].align = 'left';
				}
				if(key==0)
				{
					mainColArray[mainColArray.length-1].width = 150;
				}
				if(mainColArray[mainColArray.length-1].dataIndex=='URL')
				{
					mainColArray[mainColArray.length-1].width = 230;
				}
				if(mainColArray[mainColArray.length-1].dataIndex=='Pre Processor Time')
				{
					mainColArray[mainColArray.length-1].width = 150;
				}
			}

			var isPagingHidden;
			if (gridArray!=undefined && gridArray.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			
			if(customPaging)
				isPagingHidden = true;

			if(!keepResult)
			{
				Ext.getCmp('RUMgrid').removeAll();
			}
			var storeObj;
			if(customPaging)
			{
				storeObj=Ext.create('Ext.data.Store', {
					fields:fieldsToStore,
					proxy : 
					{
						type : 'pagingmemory',
						reader : 
						{
							type: 'array', root : 'data', totalProperty : 'total'
						}
					},
					pageSize:gridPageSize,
					data : gridArray,
					autoLoad : true,
				});
			}
			else
			{
				storeObj=Ext.create('Ext.data.Store', {
					fields:fieldsToStore,
					proxy : 
					{
						type : 'pagingmemory',
						reader : 
						{
							type: 'array', root : 'data', totalProperty : 'total'
						}
					},
					sorters: { property: fieldsToStore[2], direction : 'DESC' },
					pageSize:gridPageSize,
					data : gridArray,
					autoLoad : true,
				});
			}
			var gridChartAry = new Array();
			
			var gridpanel = Ext.widget('customgrid',{
				store:storeObj,
				columnWidth:1.0,
				ui:'newGridPanel',
				border:true,
				id:'vengat',
				margin:'0 10 0 10',
				columns:mainColArray,
				popUpData:'noToolTip',
				scroll:true,
				autoScroll:true,
				//needtoFixColumn:true,
				listeners:{
					sortchange:function(ct, column, e, t, eOpts ){
						this.getStore().loadPage(activePage);
					}
				},
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					id:'pageingTool',
					displayInfo: true,
					store: storeObj,
					hidden:isPagingHidden,
					//hidden:false,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
					listeners: {
						change : function(thisd, params)
						{  
							activePage = params.currentPage;
						}
					}
				}]
			});
			var RUMgrid = Ext.getCmp('RUMgrid');
			RUMgrid.removeAll();
			RUMgrid.add(gridpanel);
			var RUMdataGrid = Ext.getCmp('vengat');
			if(fromPerBtn)
			{
				activePage = Math.ceil(gridArray.length/gridPageSize);
				RUMdataGrid.getStore().loadPage(activePage);
			}
			else
				RUMdataGrid.getStore().loadPage(1);
		}
	},
	loadOverAllPageNavigation:function(other_Info)
	{
		var me = this;
		var resultObj = Ext.getCmp('RUMgrid');
		var isRangeNeed = other_Info['isRangeNeed'];
		var dataPageNo = parseInt(other_Info['dataPageNo']);// current page no
		var overAllRecCount = parseInt(other_Info['overAllRecCount']);
		var recordPerPage = parseInt(other_Info['recordPerPage']);
		
		var dataPageNo_disp = ((dataPageNo-1)*Math.ceil(recordPerPage/gridPageSize)) + 1; 
	
		if(fromPerBtn)
		{
			dataPageNo_disp = dataPageNo_disp+activePage-1
		}
		
		if(isRangeNeed != 'true' && dataPageNo == 1)
		{
			return;
		}
		else
		{
			var customPaging = Ext.getCmp('customPagingId');
			if(customPaging!=undefined)
			{
				resultObj.remove(customPaging);
			}
			var nextDisable = false;
			var perDisable = false;
			var totalPage = Math.ceil(overAllRecCount/gridPageSize);
			if(dataPageNo == 1 && dataPageNo_disp == 1)
				perDisable=true;
			if(dataPageNo_disp == totalPage)
				nextDisable=true;
			var labelText = '<div style="text-align:center">Page '+dataPageNo_disp+' of '+totalPage+'<div>';
			var totatLabelText = '<div style="text-align:right";">'+Total_RecordsTxt+': '+overAllRecCount+'</div>';
			appConstants.totalRec = overAllRecCount;
			resultObj.add(
			{
				xtype:'container',
				id:'customPagingId',
				cls:'paginationOuterContainerBorder',
				height:28,
				layout: 'column',
				margin: '0 10 0 10',
				padding:'5 0 10 0',
				items:[
				{
					xtype:'container',
					layout: 'hbox',
					columnWidth:.5,
					margin: '0 0 10 0',
					items:[
					{
						xtype:'container',
						width:48,
						margin: '0 0 10 5',
						items:[
						{
							xtype:'button',
							id:'firstPageBtn',
							tooltip: '<b>'+First_PageTxt+'</b>',
							iconCls: 'al_first_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							margin: '0 3 0 0',
							currentPage:dataPageNo,
							disabled:perDisable,
							listeners:
							{
								click:function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var last = pageingTool.store.currentPage - 1;
									if(last == 0 && dataPageNo == 1)
										return;
									infolabel.update('<div style="text-align:center">Page '+1+' of '+totalPage+'</div>');
									
									if(dataPageNo > 1)
									{
										appConstants.currentPage = 1;
										keepResult = true;
										me.showResult(Ext.getCmp('submit'));
									}
									else
									{
										Ext.getCmp('firstPageBtn').setDisabled(true);
										Ext.getCmp('customPer').setDisabled(true);
										Ext.getCmp('customNext').setDisabled(false);
										Ext.getCmp('lastPageBtn').setDisabled(false);
										if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
										{
											pageingTool.store.loadPage(1);
										}
									}
								}
							}
						},
						{
							xtype:'button',
							iconCls: 'al_previous_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							id:'customPer',
							tooltip: '<b>'+Previous_PageTxt+'</b>',
							currentPage:dataPageNo,
							disabled:perDisable,
							listeners:
							{
								click:function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var last = pageingTool.store.currentPage - 1;
									if(last == 0 && dataPageNo == 1)
										return;
									var temp = ((dataPageNo-1)*Math.ceil(recordPerPage/gridPageSize)) + last; 
									infolabel.update('<div style="text-align:center">Page '+temp+' of '+totalPage+'</div>');
									
									if(last == 0 && dataPageNo > 1)
									{
										fromPerBtn = true;
										appConstants.currentPage = this.currentPage-1;
										keepResult = true;
										me.showResult(Ext.getCmp('submit'));
									}
									else
									{
										if(temp == 1)
										{
											Ext.getCmp('customPer').setDisabled(true);
											Ext.getCmp('firstPageBtn').setDisabled(true);
										}
										Ext.getCmp('customNext').setDisabled(false);
										Ext.getCmp('lastPageBtn').setDisabled(false);
										if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
										{
											pageingTool.store.loadPage(last);
										}
									}
								}
							}
						}]
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'label',
						width:101,
						id:'infolabel',
						html :labelText
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'container',
						margin: '0 0 10 0',
						width:48,
						items:[
						{
							xtype:'button',
							iconCls: 'al_next_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							id:'customNext',
							tooltip: '<b>'+Next_PageTxt+'</b>',
							margin: '0 3 0 0',
							currentPage:dataPageNo,
							disabled:nextDisable,
							listeners:
							{
								'click':function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var next = pageingTool.store.currentPage + 1;
									var temp = ((dataPageNo-1)* Math.ceil(recordPerPage/gridPageSize)) + next; 
									if(temp > totalPage)
										return;
									infolabel.update('<div style="text-align:center">Page '+temp+' of '+totalPage+'</div>');
									
									if(next <= Math.ceil(recordPerPage/gridPageSize))
									{
										Ext.getCmp('customPer').setDisabled(false);
										Ext.getCmp('firstPageBtn').setDisabled(false);
										if(temp == totalPage)
										{
											Ext.getCmp('customNext').setDisabled(true);
											Ext.getCmp('lastPageBtn').setDisabled(true);
										}
										if (pageingTool.fireEvent('beforechange', pageingTool, next) !== false) 
										{
											pageingTool.store.nextPage();
										}
									}
									else
									{
										appConstants.currentPage = this.currentPage+1;
										keepResult = true;
										me.showResult(Ext.getCmp('submit'));
									}
								}
							}
						},
						{
							xtype:'button',
							iconCls: 'al_last_enabled',
							style: {
								background: 'none',
								border: '0px'
							}, 
							id:'lastPageBtn',
							tooltip: '<b>'+Last_PageTxt+'</b>',
							currentPage:dataPageNo,
							disabled:nextDisable,
							listeners:
							{
								'click':function()
								{
									fromPerBtn = true;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var next = Math.ceil(pageingTool.store.totalCount/gridPageSize);
									var temp = ((dataPageNo-1)* Math.ceil(recordPerPage/gridPageSize)) + next; 
									if(temp > totalPage)
										return;
									infolabel.update('<div style="text-align:center">Page '+totalPage+' of '+totalPage+'</div>');
									
									if(dataPageNo == Math.ceil(overAllRecCount/recordPerPage))
									{
										Ext.getCmp('customPer').setDisabled(false);
										Ext.getCmp('firstPageBtn').setDisabled(false);
										Ext.getCmp('customNext').setDisabled(true);
										Ext.getCmp('lastPageBtn').setDisabled(true);
										if (pageingTool.fireEvent('beforechange', pageingTool, next) !== false) 
										{
											pageingTool.store.loadPage(next);
										}
									}
									else
									{
										appConstants.currentPage = Math.ceil(overAllRecCount/recordPerPage);
										keepResult = true;
										me.showResult(Ext.getCmp('submit'));
									}
								}
							}
						}]
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'container',
						width:25,
						margin: '0 0 10 0',
						items:[
						{
							xtype:'button',
							iconCls: 'al_refresh_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							margin: '0 0 0 0',
							currentPage:dataPageNo,
							listeners:
							{
								click:function()
								{
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var last = pageingTool.store.currentPage ;
									if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
									{
										pageingTool.store.loadPage(last);
									}
								}
							}
						}]
					}]
				},
				{
					xtype:'container',
					margin: '0 0 0 0',
					columnWidth:.5,
					layout :
					{
						type : 'hbox',
						pack : 'end'
					},
					items:
					{
						xtype:'label',
						html :totatLabelText
					}
				}]
			});
		}
	},
	applyFilter:function()
	{
		var dataJson = appConstants.publicJsonData.filterDetails;
		for(var items in dataJson)
		{
			var itemObj = dataJson[items];
			var objId = itemObj.id;
			var groupHeadLeft = Ext.getCmp(objId+'_left');
			if(groupHeadLeft!=undefined && !Ext.isEmpty(groupHeadLeft))
			{
				var updatedList = groupHeadLeft.checkedList;
				itemObj.checkedList = updatedList;
				appConstants.publicJsonData.filterDetails[items] = itemObj;
			}
		}
		this.hideResults();
		this.showResult(Ext.getCmp('submit'));
	},
	cancelFilter:function()
	{
		Ext.getCmp('filterWithGridContainer').show();
		Ext.getCmp('filterAllContainer').hide();
	},
	submitReoprt:function(obj)
	{
		appConstants.fromRunBtn = 'yes';
		if(appConstants.publicJsonData.filterDetails!=undefined)
		{
			appConstants.publicJsonData.filterDetails = []
		}
		Ext.getCmp('er_timeline').fireEvent('forceSelect',Ext.getCmp('er_timeline'));
	},
	showResult:function(obj)
	{
		Ext.getCmp('filterWithGridContainer').show();
		Ext.getCmp('filterAllContainer').hide();
		var reportGeneration;
		if (isSettingsEnabled)
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
		else
			reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (reportGeneration == 'foreground' && this.validateMainForm(true)) {
			this.getAjaxDataForSubmit(this.foregroundControllerUrl,'isSubmit=true&'+this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background-csv'&& this.validateMainForm(true)){
			this.getAjaxDataForSubmit("../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV&isBackgroundCSV=Yes",this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background-xls'&& this.validateMainForm(true))
		{
			this.getAjaxDataForSubmit( "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=XLSX",this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background' && this.validateMainForm(true)){
			this.getAjaxDataForSubmit(this.backgroundControllerUrl,"isSubmit=true&"+this.getQueryString(true,true,true));
		}
	},
	/*onWeekendChange:function(obj)
	{
 		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(obj.getValue() == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicJsonData.labelFields.excludeDaysLabel);
		}
		else
			excludeDaysObj.hide();
	},*/
	disableTools: function()
	{
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		Ext.getCmp("csvTool").setDisabled(false);
	},
	hideResults:function()
	{
		Ext.getCmp('resultContainer').hide();
		Ext.getCmp('backGroundPanel').hide();
		this.getNomeasurepanel().hide();
	},
		
	onSelectAnalysisBy: function (obj) 
	{
		var er_option=obj.getValue();
		var params='er_option='+er_option; 
		var me = this;
		initLdgMask.show();
		Ext.Ajax.request(
		{
			url : me.foregroundJspUrl,
			params : params,
			scope:this,
			success: function(response)
			{
				initLdgMask.hide();
				me.hideResults();
				appConstants.publicJsonData=Ext.decode(response.responseText);
				if(appConstants.publicJsonData.combo.siteCombo!=undefined)
				{
					Ext.getCmp('er_site').show();
					me.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
				}
				else
				{
					Ext.getCmp('er_site').hide();
				}
				me.loadComboField('er_compType','compTypeCombo','compTypeComboLabel','selectedCompTypeCombo',appConstants.publicJsonData,false,null,true);
				me.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,false,null,true);
				//me.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',false);
			
			}
		});
	},
	onSelectSiteBy: function (obj) 
	{
		var me = this
		var er_site=obj.getValue();
		var params='er_option='+Ext.getCmp('er_option').getValue(); 
		params+='&er_site='+er_site; 
		initLdgMask.show();
		Ext.Ajax.request(
		{
			url : me.foregroundJspUrl,
			params : params,
			scope:this,
			success: function(response)
			{
				initLdgMask.hide();
				me.hideResults();
				appConstants.publicJsonData=Ext.decode(response.responseText);
				me.loadComboField('er_compType','compTypeCombo','compTypeComboLabel','selectedCompTypeCombo',appConstants.publicJsonData,false,null,true);
				me.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,false,null,true);
				//me.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',false);
			
			}
		});
	},
	onSelectCompTypeBy: function (obj) 
	{
		var er_compType=obj.getValue();
		var params='er_compType='+er_compType;
		params+='&er_site='+Ext.getCmp('er_site').getValue(); 
		params+='&er_option='+Ext.getCmp('er_option').getValue(); 
		var me = this;
		initLdgMask.show();
		Ext.Ajax.request(
		{
			url : me.foregroundJspUrl,
			params : params,
			scope:this,
			success: function(response)
			{
				initLdgMask.hide();
				me.hideResults();
				appConstants.publicJsonData=Ext.decode(response.responseText);
				me.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,false,null,true);
				//me.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',false);
			
			}
		});
	},
	onChangeReportGeneration:function(obj)
	{
		this.hideResults();
		this.disableTools();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
 		if(obj.getValue()== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('bgReportName').hide();
		}
	},
	getAjaxData:function(url,query){
		Ext.Ajax.request(
				{
					url : url,
					params : query,
					async:false,
					scope:this,
					success: function(response){
					appConstants.publicJsonData=Ext.decode(response.responseText);
					}
				});
	},
	getAjaxDataForSubmit:function(url,query)
	{
		var me=this;
		initLdgMask.show();
		Ext.Ajax.request(
		{
			url : url,
			params : query,
			scope:this,
			success: function(response)
			{
				initLdgMask.hide();
				appConstants.publicJsonData=Ext.decode(response.responseText);
				me.loadReportData();
				appConstants.fromRunBtn = 'no';
			}
		});
	},
	getQueryString:function(needFilter,isOthers,isSettings)
	{
		var queryString;
		var timefrom,minfrom,timeto,minto,er_excwe,reportGeneration,bg_reportname;
		
		if (isSettingsEnabled)
		{
			timefrom=Ext.getCmp('timefrom').getValue();
			minfrom=Ext.getCmp('minfrom').getValue();
			timeto=Ext.getCmp('timeto').getValue();
			minto=Ext.getCmp('minto').getValue();
			er_excwe=Ext.getCmp('er_excwe').getValue();
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
			bg_reportname = Ext.getCmp('bgReportName').getValue();
 		}
		else
		{
			var selectedFields=appConstants.publicJsonData.selectedFields;
			timefrom=selectedFields.selectedTimeFrom;
			minfrom=selectedFields.selectedMinsFrom;
			timeto=selectedFields.selectedTimeTo;
			minto=selectedFields.selectedMinsTo;
			er_excwe=selectedFields.excludeWeekendsSelected;
			reportGeneration=selectedFields.reportGenerationSelected;
			bg_reportname=selectedFields.reportNameSelected;
			//queryArray=selectedFields.userSelected;
 		}
		var er_option=Ext.getCmp('er_option').getValue();
		queryString='er_type=No';
		queryString+='&er_option='+er_option;
		if(er_option!=undefined && er_option!='Component')
		{
			queryString+='&er_site='+Ext.getCmp('er_site').getValue();
		}
		queryString+='&er_compType='+Ext.getCmp('er_compType').getValue();
		//var queryArray=new Array();
		var queryArray='';
		queryArray=Ext.getCmp('er_component').getValue();
		/*for (var key in queryArray)
		{
			queryString+="&er_component="+queryArray[key];
		}*/
		queryString+="&er_component="+queryArray;
		if (isSettings)
		{
 			//var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
			//var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
			var stHr=Ext.getCmp('er_sthr').dataArray;
			var startDateConverted = Ext.getCmp('er_stdate').dataArray;
			var endDateConverted = Ext.getCmp('er_enddate').dataArray;
			queryString+= "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + startDateConverted + "&enddate=" + endDateConverted + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
			
			queryString+="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;
			queryString+="&er_excwe="+er_excwe;
			var queryArray=new Array();
					
 			if (reportGeneration == 'foreground') 
			{
 				queryString+="&er_reportgenration="+reportGeneration+"&responseType=json";
			} 
			else
			{
				bg_reportname=checkFileName(bg_reportname);
				queryString+="&er_reportgenration="+reportGeneration+"&bg_reportname="+bg_reportname;
			}
		}
		if (isOthers)
		{
			if(appConstants.publicJsonData.hasOwnProperty('hiddenFields'))
			{
				var hiddenFields = appConstants.publicJsonData.hiddenFields;
				for (var hiddenField in hiddenFields)
				{
					if(this.isNewFav!=undefined && this.isNewFav)
					{
						if(hiddenField!=undefined && hiddenField=='ID')
						{
							continue;
						}
						if(hiddenField!=undefined && hiddenField=='FavoriteId')
						{
							continue;
						}
					}
					queryString+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}
			}
		}
		queryString+="&er_RmDispName="+appConstants.er_RmDispName;
		queryString+="&chartType="+appConstants.chartType;
		queryString+="&fromRunBtn="+appConstants.fromRunBtn;
		if(needFilter)
		{
			queryString+="&checkedFilterData="+this.getCheckedInfo();
			var durationStart = Ext.getCmp('durationStartId');
			var durationEnd = Ext.getCmp('durationEndId');
			var guidField = Ext.getCmp('guidFieldId');
			
			if(durationStart!=undefined && durationStart.getValue().length>0)
			{
				queryString+="&durationStart="+durationStart.getValue();
			}
			if(durationEnd!=undefined && durationEnd.getValue().length>0)
			{
				queryString+="&durationEnd="+durationEnd.getValue();
			}
			if(guidField!=undefined && guidField.getValue().length>0)
			{
				queryString+="&guidField="+guidField.getValue();
			}
		}
		if(keepResult)
			queryString +="&overAllRecCount="+appConstants.totalRec+"&dataPageNo="+appConstants.currentPage;
		else
		{
			appConstants.currentPage = 1;
			appConstants.totalRec = 0;
			customPaging = true;
		}

		return queryString;
	},
	boxready:function()
	{
  		var thisController = this;
		if(!appConstants.hideBackButton){
			Ext.getCmp('mainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		this.getMain().setTitle(appConstants.er_RmDispName);
		if(appConstants.frmFavModify!=undefined && appConstants.frmFavModify=='Yes')
		{
			return;
		}
		if(appConstants.frmSchModify!=undefined && appConstants.frmSchModify=='Yes')
		{
			return;
		}
		if (appConstants.isForceSubmit=="true" || appConstants.isSubmit=="true"){
			this.loadReportData(appConstants.publicjsonData);
		}
 	},
	onChangeReportGeneration:function(obj)
	{
		this.hideResults();
		this.disableTools();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
 		if(obj.getValue()== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-xls'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('bgReportName').hide();
		}
	},
	loadForm:function()
	{
		this.loadFormFields();
        var from_schedule = appConstants.frmSchModify;
		var fromFavoriteModify = appConstants.frmFavModify;
		if (from_schedule == "Yes" || fromFavoriteModify == "Yes") {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}
		else
		{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var date=appConstants.publicJsonData.selectedFields.startDateForDisplay;
		var component=Ext.getCmp('er_stdate');
		component.setValue(date);
		component.dataArray=date;
		date=appConstants.publicJsonData.selectedFields.endDateForDisplay;
		component=Ext.getCmp('er_enddate');
		component.setValue(date);
		component.dataArray=date;
	
		Ext.getCmp('er_sthr').setValue(appConstants.publicJsonData.selectedFields.startHourForDisplay);
		Ext.getCmp('er_endhr').setValue(appConstants.publicJsonData.selectedFields.endHourForDisplay);
		Ext.getCmp('er_sthr').dataArray=appConstants.publicJsonData.selectedFields.startHour;
		Ext.getCmp('er_endhr').dataArray=appConstants.publicJsonData.selectedFields.endHour;
		stmin = appConstants.publicJsonData.selectedFields.startMinForDisplay;
		enmin = appConstants.publicJsonData.selectedFields.endMinForDisplay;
		mgr_stmin=appConstants.publicJsonData.selectedFields.startmin;
		mgr_enmin=appConstants.publicJsonData.selectedFields.endmin;
		Ext.getCmp('er_stmin').setValue(stmin);
		Ext.getCmp('er_endmin').setValue(enmin);
 	},
	toggleChildTables:function(id)
	{
		var booleanCls=$('#'+id+'_img').hasClass('iconTreeExpand');
 		if (booleanCls)
		{
			if(id=='durationContainerId')
			{
				Ext.getCmp('durationContainerId').show();
				$('#'+id+'_img').removeClass("iconTreeExpand");
				$('#'+id+'_img').addClass("iconTreeCollapse");
			}
			else
			{
				//$('#'+id).removeClass("closed");
				//document.getElementById(id).style.display='';
				$('#'+id).fadeIn("slow",function(){
					$('#'+id+'_img').removeClass("iconTreeExpand");
					$('#'+id+'_img').addClass("iconTreeCollapse");
					Ext.getCmp('filterContainerId').doLayout()
					//Ext.getCmp('filterContainerId').doComponentLayout();
				});
			}
		}
		else
		{
			if(id=='durationContainerId')
			{
				Ext.getCmp('durationContainerId').hide();
				$('#'+id+'_img').removeClass("iconTreeCollapse");
				$('#'+id+'_img').addClass("iconTreeExpand");
			}
			else
			{
				//$('#'+id).addClass("closed");
				//document.getElementById(id).style.display='none';
				$('#'+id).fadeOut("slow",function(){
					$('#'+id+'_img').removeClass("iconTreeCollapse");
					$('#'+id+'_img').addClass("iconTreeExpand");
					Ext.getCmp('filterContainerId').doLayout();
					//Ext.getCmp('filterContainerId').doComponentLayout();
				});
			}
		}
		/*Ext.Function.defer(function(){
			Ext.getCmp('filterContainerId').doLayout();
			//Ext.getCmp('filterContainerId').doComponentLayout();
		}, 100);*/
	},
	loadFiterData:function(dataJson,totalCheckedCount)
	{
		if(dataJson!=undefined)
		{
			var filterContainerId = Ext.getCmp('filterContainerId');
			filterContainerId.removeAll();
			var viewCheckBoxDataSample = new Ext.XTemplate(
				'<div class="">',
					//'<div style="clear:both;padding-bottom:10px;" class="font_bold14">Refine by</div>',
					'<tpl for=".">',
						'<div class="checkGroups" style="padding:0px">',
							'<div class="checkGroupHead"><img id="{id}_img"style="position:relative;top:4px;left:-1px" src="../images/spacer.gif" class="iconTreeCollapse"  onclick=\'javascript:toggleChildTables("{id}");\'/>{groupHead}&nbsp;',
								//'<tpl if="maxView == \'yes\'">',
									//'<img src="../images/spacer.gif" class="iconMaxView checkGroupHeadImg" onclick=\'javascript:alternateViewFunction("{groupHead}","{id}");\'>',
									'<div class="checkGroupClear" style="width:45px;cursor:pointer;float:right;margin-top:5px;text-align:right;" onclick=\'javascript:clearByGroup("{groupHead}","{id}");\'>',
										'<tpl if="clear == \'yes\'">',
											'<span style="text-decoration-line:underline;font-weight:400">'+ClearTxt+'</span>',
										'</tpl>',
									'</div>',
								//'</tpl>',
							'</div>',
							'<div id="{id}"  class="btmSlideOut">',
								/*'<div class="checkGroupClear" style="width:45px;cursor:pointer;" onclick=\'javascript:clearByGroup("{groupHead}","{id}");\'>',
									'<tpl if="clear == \'yes\'">',
										'<img src="../images/spacer.gif" class="iconClearLeftArrow checkGroupClearImg" > <span style="text-decoration-line:underline;font-weight:400">'+ClearTxt+'</span>',
									'</tpl>',
								'</div>',*/
								'<form>',
									'<tpl for="child">',
									'<div style="padding:3px 2px 3px 1px;width:200px;white-space:nowrap;overflow:hidden; text-overflow:ellipsis;">',
										'<label class="checkLabel"><input class="htmlCheckbox12" type="checkbox"  id="{parent.id}_{[xindex-1]}" name="input" onclick=\'javascript:filterEventsChange("{value}","{parent.id}",false);\' <tpl if="isChecked">checked</tpl> value="{value}"/><span data-qclass="yellowTip" data-qtip="{value}">{name} </span></label>',
									'</div>',
									'</tpl>',
								'</form>',
								'<div class="checkGroupClear" style="width:45px;cursor:pointer;float:right;text-align:right;" onclick=\'javascript:alternateViewFunction("{groupHead}","{id}");\'>',
									'<tpl if="maxView == \'yes\'">',
										'<span style="text-decoration-line:underline;">more</span>',
									'</tpl>',
								'</div>',
							'</div>',
						'</div>',
					'</tpl>',
				'</div>',
				'<div style="both:clear"></div>'
			);
			
			filterContainerId.add({
				xtype:'container',
				hidden:true,
				html:'<div class="checkGroupHead" style="font-weight:500"><img id="radioGrp_img"style="position:relative;top:4px" src="../images/spacer.gif" class="iconTreeCollapse"  onclick=\'javascript:toggleChildTables("radioGrp");\'/>Show by</div>'
			});
			filterContainerId.add({
				xtype:'dataview',
				store:Ext.data.Store({
					model:checkBoxDataModel,
					data:dataJson,
				}),
				tpl:viewCheckBoxDataSample
			});
			filterContainerId.add({
				xtype:'container',
				//hidden:true,
				html:'<div class="checkGroupHead" style="font-weight:500"><img id="durationContainerId_img"style="position:relative;top:4px" src="../images/spacer.gif" class="iconTreeCollapse"  onclick=\'javascript:toggleChildTables("durationContainerId");\'/>Page Load Time (ms)</div>'
			});
			filterContainerId.add({
				xtype:'container',
				id:'durationContainerId',
				layout:'hbox',
				//hidden:true,
				defaults:
				{
					labelSeparator:'',
				},
				items:[{
					xtype:'textfield',
					width:100,
					cls: 'textbox',
					fieldLabel: 'From',
					id:'durationStartId',
					labelWidth:30,
					value:appConstants.publicJsonData.durationStart,
					margin:'5 3 5 5'
				},
				{
					xtype:'textfield',
					cls: 'textbox',
					fieldLabel: ' To ',
					id:'durationEndId',
					width:100,
					labelWidth:20,
					value:appConstants.publicJsonData.durationEnd,
					margin:'5 5 5 0'
				}]
			});
			filterContainerId.add({
				xtype:'container',
				margin:'5 10 0 0',
				//hidden:true,
				html:'<div class="checkGroupHead" style="font-weight:500"><img id="guidFieldId_img"style="position:relative;top:4px" src="../images/spacer.gif" class="iconTreeCollapse"  onclick=\'javascript:toggleChildTables("guidFieldId");\'/>Search by GUID</div>',
			});
			filterContainerId.add({
				xtype:'textfield',
				cls: 'textbox',
				id:'guidFieldId',
				value:appConstants.publicJsonData.guidField,
				labelAlign:'top',
				labelSeparator:'',
				width:200,
				//hidden:true,
				margin:'10 10 0 0'
			});

			var selectedCheckValueIdObj = Ext.getCmp('selectedCheckValueId');
			selectedCheckValueIdObj.removeAll();
			if(totalCheckedCount>0)
			{
				var maxVal = totalCheckedCount;
				if(maxVal>15)
				{
					maxVal = 15;
				}
				selectedCheckValueIdObj.show();
				var viewCheckBoxDataSample = new Ext.XTemplate(
					//'<div style="padding:2px 20px 2px 2px;float:left" class="resultForFont">1 - '+maxVal+' of '+totalCheckedCount+' results for</div>',
					'<div style="min-height:24px;max-height:46px;height:auto;overflow:auto">',
					'<div style="padding:2px 0px 2px 2px;float:left" class="resultForFont">'+Filtered_ByTxt+':&nbsp;</div>',
					'<tpl for=".">',
						'<form>',
							'<tpl for="checkedList">',
								'<tpl>',
									'<div class="checkValueBg" value="{.}" data-qclass="yellowTip" data-qtip="{.}" onclick=\'javascript:filterEventsChange("{.}","{parent.id}",true);event.stopPropagation();\'><img src="../images/spacer.gif" class="iconClose12" style="vertical-align:text-bottom;position:relative;top:0px">&nbsp;{.}</div>',
								'</tpl>',
							'</tpl>',
						'</form>',
					'</tpl>',
					'<div style="clear:both;padding:0px;line-height:1px;"></div>',
					'</div>'
				);
				var durationEnd = Ext.getCmp('durationEndId').getValue();
				var durationStart = Ext.getCmp('durationStartId').getValue();
				var durationTxt = '';
				if(durationEnd!=undefined && durationStart!=undefined && durationStart!='' && durationEnd!='')
				{
					durationTxt = 'Page Load Time From '+durationStart+' to '+durationEnd;
				}
				else if(durationStart!=undefined && durationStart!='')
				{
					durationTxt = 'Page Load Time From '+durationStart;
				}
				else if(durationEnd!=undefined && durationEnd!='')
				{
					durationTxt = 'Page Load Time Upto '+durationEnd;
				}
				var updatedDataJson = new Array();
				if(durationTxt!='')
				{
					console.log('dataJson  ',dataJson);
					for(var index in dataJson)
					{
						updatedDataJson.push(dataJson[index]);						
					}
					var durationObj = new Object(); 
					durationObj.id='Page_load_time';
					var checkedList = new Array();
					checkedList.push(durationTxt);
					durationObj.checkedList = checkedList;
					updatedDataJson.push(durationObj);
				}
				else
				{
					updatedDataJson = dataJson;
				}
				selectedCheckValueIdObj.add({
					xtype:'dataview',
					store:Ext.data.Store({
						model:checkBoxDataModel,
						data:updatedDataJson,
					}),
					tpl:viewCheckBoxDataSample
				});
			}
			else
			{
				selectedCheckValueIdObj.show();
				var durationEnd = Ext.getCmp('durationEndId').getValue();
				var durationStart = Ext.getCmp('durationStartId').getValue();
				var durationTxt = '';
				if(durationEnd!=undefined && durationStart!=undefined && durationStart!='' && durationEnd!='')
				{
					durationTxt = 'Page Load Time From '+durationStart+' to '+durationEnd;
				}
				else if(durationStart!=undefined && durationStart!='')
				{
					durationTxt = 'Page Load Time From '+durationStart;
				}
				else if(durationEnd!=undefined && durationEnd!='')
				{
					durationTxt = 'Page Load Time Upto '+durationEnd;
				}
				else
				{
					selectedCheckValueIdObj.hide();
				}
				if(durationTxt!='')
				{
					selectedCheckValueIdObj.add({
						xtype:'container',
						html:'<div class="checkValueBg" style="max-width:200px" value="'+durationTxt+'" data-qclass="yellowTip" data-qtip="'+durationTxt+'" onclick=\'javascript:filterEventsChange("'+durationTxt+'","Page_load_time",true);event.stopPropagation();\'><img src="../images/spacer.gif" class="iconClose12" style="vertical-align:text-bottom;position:relative;top:0px">&nbsp;'+durationTxt+'</div>'
					});
				}
			}
		}
	},
	filterEventsChange:function(chkbxVal,filterId,needSubmit)
	{
		var dataJson = appConstants.publicJsonData.filterDetails;
		if(dataJson!=undefined && filterId!='Page_load_time')
		{
			for(var indx in dataJson)
			{
				var filterObj = dataJson[indx];
				if(filterObj.id == filterId )
				{
					var checkedList = filterObj.checkedList;
					if(checkedList.indexOf(chkbxVal)>-1)
					{
						checkedList.splice(checkedList.indexOf(chkbxVal),1);
					}
					else
					{
						checkedList.push(chkbxVal);
					}
					filterObj.checkedList = checkedList;
					dataJson[indx] = filterObj;
				}
			}
			appConstants.publicJsonData.filterDetails = dataJson;
		}
		else if(filterId=='Page_load_time')
		{
			Ext.getCmp('durationStartId').setValue('');
			Ext.getCmp('durationEndId').setValue('');
		}
		if(needSubmit)
		{
			this.showResult(Ext.getCmp('submit'));
		}
	},
	MaxViewfilterEventsChange:function(chkbxVal,filterId)
	{
		var checkedList = Ext.getCmp(filterId+'_left').checkedList;
		var checkList = new Array();
		for(var i in checkedList)
		{
			var obj = checkedList[i];
			checkList.push(obj);
		}
		if(checkList!=undefined)
		{
			if(checkList.indexOf(chkbxVal)>-1)
			{
				checkList.splice(checkList.indexOf(chkbxVal),1);
			}
			else
			{
				checkList.push(chkbxVal);
			}
			Ext.getCmp(filterId+'_left').checkedList = checkList;
			if(checkList.length>0)
			{
				Ext.getCmp(filterId+'_chkBtn').setValue(true);
			}
			else
			{
				Ext.getCmp(filterId+'_chkBtn').setValue(false);
			}

			for(var cnt in appConstants.dummyArray)
			{
				if(appConstants.dummyArray[cnt].value==chkbxVal)
				{
					if(appConstants.dummyArray[cnt].isChecked)
					{
						appConstants.dummyArray[cnt].isChecked = false;
					}
					else
					{
						appConstants.dummyArray[cnt].isChecked = true;
					}
					break;
				}
			}
		}
	},
	clearByGroup:function(chkbxVal,filterId)
	{
		var dataJson = appConstants.publicJsonData.filterDetails;
		if(dataJson!=undefined)
		{
			var haveChecked = false;
			for(var indx in dataJson)
			{
				var filterObj = dataJson[indx];
				if(filterObj.id == filterId && filterObj.checkedList.length>0 )
				{
					filterObj.checkedList = [];
					var clearChild = filterObj.child;
					for(var i in clearChild)
					{
						document.getElementById(filterId+'_'+i).checked = false;
					}
					dataJson[indx] = filterObj;
					haveChecked = true;
					break;
				}
			}
			if(haveChecked)
			{
				appConstants.publicJsonData.filterDetails = dataJson;
				//this.showResult(Ext.getCmp('submit'));
			}
		}
	},
	alternateViewFunction:function(groupHead,id)
	{
		Ext.getCmp('filterWithGridContainer').hide();
		Ext.getCmp('filterAllContainer').show();
		Ext.getCmp('filterSearchBox').setValue('');
		this.loadMaxFilterAllContainer(id);
	},
	loadMaxFilterAllContainer:function(id)
	{
		var groupHeadLeft = Ext.getCmp('groupHeadLeft');
		var me = this;
		groupHeadLeft.removeAll();
		groupHeadLeft.add(Ext.create('Ext.container.Container',{
			html:'<div style="clear:both;margin-bottom:5px;margin-left:10px;" class="font_bold14">'+Refine_byTxt+'</div>'})
		);
		var dataJson = appConstants.publicJsonData.filterDetails;
		if(dataJson!=undefined && dataJson!='undefined')
		{
			for(var i=0;i<dataJson.length;i++)
			{
				var filterObj = dataJson[i];
				/*if(filterObj.id=='User_Experience')
				{
					continue;
				}*/
				var checkBoxButtonPressed = '';
				var isChecked = false;
				var haveDeactiveCls = '';
				if(filterObj.id==id)
				{
					checkBoxButtonPressed = ' checkBoxButtonPressed';
					appConstants.pressedSection = id;
				}
				if(filterObj.checkedList!=undefined && filterObj.checkedList.length>0)
				{
					isChecked = true;
					if(filterObj.id!=id)
					{
						haveDeactiveCls = ' deactivated';
					}
				}
				groupHeadLeft.add({
					xtype:'container',
					layout:'hbox',
					height:30,
					width:204,
					id:filterObj.id+'_container',
					cls:'checkBoxButtonNotPressed'+checkBoxButtonPressed,
					margin:'0 0 0 5',
					padding:'5 0 0 3',
					items:[{
						xtype: 'checkbox',
						cls:'checkbox12'+haveDeactiveCls,
						margin:'0 5 0 0',
						id:filterObj.id+'_chkBtn',
						checked:isChecked,
						listeners:
						{
							'change':function(obj)
							{
								var id = obj.id
								id = id.replace('_chkBtn','');
								if(!obj.checked)
								{
									var clickedLabel = Ext.getCmp(id+'_left');
									if(obj.hasCls('deactivated'))
									{
										obj.removeCls('deactivated');
									}
									if(appConstants.pressedSection == id && clickedLabel.checkedList.length>0)
									{
										var newChild = appConstants.dummyArray;
										for(var cnt in newChild)
										{
											newChild[cnt].isChecked=false
										}
										var allFilterContainerData = Ext.getCmp('allFilterContainerData');
										var dummyArray = allFilterContainerData.dummyArray;
										dummyArray[0].child = newChild;
										dummyArray[0].checkedList = [];
										allFilterContainerData.getStore().loadRawData(dummyArray);
									}
									clickedLabel.checkedList = [];
								}
								else
								{
									if(appConstants.pressedSection!=id)
									{
										obj.addCls('deactivated');
									}
								}
							}
						}
					},
					{
						xtype:'label',
						width:170,
						style:
						{
							'cursor':'pointer'
						},
						id:filterObj.id+'_left',
						checkedList:filterObj.checkedList,
						text:filterObj.groupHead,
						listeners:
						{
							render: function(c)
							{
								c.getEl().on('click', function()
								{
									var id = c.id
									id = id.replace('_left','');
									if(appConstants.pressedSection == id)
									{
										return;
									}
									else
									{
										if(Ext.getCmp(id+'_chkBtn').hasCls('deactivated'))
										{
											Ext.getCmp(id+'_chkBtn').removeCls('deactivated');
										}
										if(Ext.getCmp(appConstants.pressedSection+'_chkBtn').checked)
										{
											Ext.getCmp(appConstants.pressedSection+'_chkBtn').addCls('deactivated');
										}
										Ext.getCmp(appConstants.pressedSection+'_container').removeCls('checkBoxButtonPressed');
										Ext.getCmp(id+'_container').addCls('checkBoxButtonPressed');
									}
									me.loadAllFilterContainer(id,true,c.checkedList);
									appConstants.pressedSection = id;

								}, c);
							}
						}
					}]
				});
			}
			this.loadAllFilterContainer(id,false,null);
		}
		else
		{
			Ext.getCmp('filterWithGridContainer').show();
			Ext.getCmp('filterAllContainer').hide();
		}
	
	},
	loadAllFilterContainer:function(id,isTemp,checkedList)
	{
		var filterInfoParam = '';
		if(isTemp)
		{
			filterInfoParam = this.getQueryString(false,true,true);
		}
		else
		{
			filterInfoParam = this.getQueryString(true,true,true);
		}
		if(isTemp)
		{
			filterInfoParam+='&checkedFilterData='+this.getMaxViewCheckedInfo(id,checkedList);;
		}
		filterInfoParam+='&forUniqueData=yes&columnName='+id;
		var me = this;
		var allFilterContainerData = Ext.getCmp('allFilterContainerData');
		allFilterContainerData.hide();
		initLdgMask.show();
		Ext.Ajax.request(
		{
			url : me.foregroundControllerUrl,
			params : filterInfoParam,
			scope:this,
			success: function(response)
			{
				initLdgMask.hide();
				var jsonData =Ext.decode(response.responseText);
				var dataJson = jsonData.filterDetails;
				var dummyArray = jsonData.filterDetailsDummy;
				if(dataJson!=undefined)
				{
					allFilterContainerData.show();
					allFilterContainerData.getStore().loadRawData(dataJson);
					allFilterContainerData.dummyArray = dataJson;
					appConstants.dummyArray = dummyArray[0].child;
				}
			}
		});
	},
	loadFormFields:function()
	{
		this.loadComboField('er_option','analysisByCombo','analysisComboLabel','selectedAnalysisByCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_timeline','timelineCombo','timelineComboLabel','selectedTimeline',appConstants.publicJsonData,false,null,false);
		if(appConstants.publicJsonData.combo.siteCombo!=undefined)
		{
			Ext.getCmp('er_site').show();
			this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
		}
		this.loadComboField('er_compType','compTypeCombo','compTypeComboLabel','selectedCompTypeCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,false,null,true);
		//this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',false);
	
	},
	loadSettings:function()
	{
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
		var FavoriteId =hiddenFields["FavoriteId"];
		if(!Ext.isEmpty(FavoriteId)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp('moreOptionCloseId').show();
 		this.loadComboField('er_excwe','excludeWeekendsCombo','excludeWeekendsLabel','excludeWeekendsSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('reportGeneration','reportGenerationCombo','reportGenerationLabel','reportGenerationSelected',appConstants.publicJsonData,false,null,true);
		
		var selectedFields=appConstants.publicJsonData.selectedFields;
		Ext.getCmp('timefrom').setValue(selectedFields.selectedTimeFrom);
 		Ext.getCmp('minfrom').setValue(selectedFields.selectedMinsFrom);
 		Ext.getCmp('timeto').setValue(selectedFields.selectedTimeTo);
 		Ext.getCmp('minto').setValue(selectedFields.selectedMinsTo);
		if(selectedFields.hasOwnProperty('reportNameSelected'))
 			Ext.getCmp('bgReportName').setValue(selectedFields.reportNameSelected);
		selectedFields =null;delete selectedFields;
	},
	showConfigDropdown:function(){
		Ext.widget('configform');
		isSettingsEnabled = true;
 		var thisController = this;
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndCloseSettings();
 		});
 	},
	validateAndCloseSettings:function()
	{
		if(this.validateSettings())
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectPaneId,isSetLabel)
	{
		 var component = Ext.ComponentManager.get(comboId);
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
 				var rawData = parentJsonProperty.combo[comboProperty];
				component.getStore().clearFilter(true); 
 				component.getStore().loadRawData(rawData);
			 
				if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
				{
					component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
				}
 				else
				{
					component.setValue(rawData[0].valueField);
				}
				if (isSetLabel)
				{
					 if(parentJsonProperty.labelFields.hasOwnProperty(comboLabelProperty))
					 {
						if(!isMultiSelect)
							component.setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
 						else
							Ext.ComponentManager.get(multiSelectPaneId).setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
					 }
				}
				if(!isMultiSelect)
				{
					if(component.isHidden())
					component.show();
				}
				else
				{
					var m=Ext.ComponentManager.get(multiSelectPaneId);
					if(m.isHidden())
					m.show();
				}
 		 }
		 else
		 {
			if(!isMultiSelect)
			{
				if(!component.isHidden())
				component.hide();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectPaneId);
				if(!m.isHidden())
				m.hide();
			}
		 }
 	},
	loadTools : function(){
 		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false, true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
 	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getMessageBox:function(title,msg)
	{
	  	 Ext.MessageBox.show({
				title: title,
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
		});
		return false;
	},
	validateMainForm:function(flag)
	{
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var er_usertimeline = hiddenFields.userTimeline;

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: alert_text,
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		obj=Ext.getCmp('er_option');
		if(obj.getValue()== '-1'){
			this.getMessageBox(alert_text,reportTypeMsg);
			return false;
		}
		obj=Ext.getCmp('er_site');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden())){
			this.getMessageBox(alert_text,pleaseChooseTxt+' '+obj.getFieldLabel());
			return false;
		}
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden())){
			this.getMessageBox(alert_text,pleaseChooseTxt+' '+obj.getFieldLabel());
			return false;
		}
		obj=Ext.getCmp('er_component');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden()))
		{
			this.getMessageBox(alert_text,componentMsg);
			return false;
		}
		/*var objAry = obj.getValue();
		if(objAry.length>1 && objAry.indexOf('All')>-1)
		{
			this.getMessageBox(alert_text,all_singleErrTxt);
			return false;
		}*/
		if (reportgen == 'foreground')
		{
			if(flag)
			{
				var limitforbg = hiddenFields.limitforbg;
				if(!Ext.isEmpty(limitforbg))
				{
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate))
					{
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						return false;
					}
				}
			}
		}
		else
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}
		return true;
	},
	validateMainFormForFavAndSch:function()
	{
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var er_usertimeline = hiddenFields.userTimeline;

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: alert_text,
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var obj=Ext.getCmp('select_farm');
		if(obj.getValue()== '-1'){
				this.getMessageBox(alert_text,obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '-1'){
				this.getMessageBox(alert_text,compTypeMsg);
				return false;
		}
		obj=Ext.getCmp('er_component');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden()))
		{
				this.getMessageBox(alert_text,componentMsg);
				return false;
		}
		/*var objAry = obj.getValue();
		if(objAry.length>1 && objAry.indexOf('All')>-1)
		{
			this.getMessageBox(alert_text,all_singleErrTxt);
			return false;
		}*/
		return true;
	},
	showConfirmResult : function(btn)
	{
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				this.getAjaxDataForSubmit(this.foregroundControllerUrl,'isSubmit=true&'+this.getQueryString(true,true,true));
			//this.doUpdate(true,false);
		}			
		else{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			return false;
		}
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-xls' || reportgen == 'background-csv' )){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	getNumberFormat:function(value)
	{
		if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		return value;
	},
	getCheckedInfo:function()
	{
		var checkStr = '';
		var dataJson = appConstants.publicJsonData.filterDetails;
		if(dataJson!=undefined && !Ext.isEmpty(dataJson))
		{
			for(var indx in dataJson)
			{
				var filterObj = dataJson[indx];
				var checkedList = filterObj.checkedList;
				var valStr = '';
				for(var cnt in checkedList)
				{
					valStr+=checkedList[cnt]+',';
				}
				if(valStr.length>0)
				{
					checkStr+= filterObj.id+'#'+valStr.substring(0,valStr.length-1)+'|';
				}
			}
		}
		if(checkStr.length>0)
		{
			checkStr = checkStr.substring(0,checkStr.length-1)
			checkStr = Ext.widget("erutils").specialCharEncode(checkStr);
		}
		return checkStr;
	},
	getMaxViewCheckedInfo:function(id,checkedList)
	{
		var checkStr = '';
		if(checkedList!=undefined && checkedList.length>0)
		{
			var valStr = '';
			for(var cnt in checkedList)
			{
				valStr+=checkedList[cnt]+',';
			}
			if(valStr.length>0)
			{
				checkStr+= id+'#'+valStr.substring(0,valStr.length-1)+'|';
			}
		}
		if(checkStr.length>0)
		{
			checkStr = checkStr.substring(0,checkStr.length-1)
			checkStr = Ext.widget("erutils").specialCharEncode(checkStr);
		}
		return checkStr;
	},
	doSearchFilter:function()
	{
		var field=Ext.getCmp('filterSearchBox');
		var allFilterContainerData = Ext.getCmp('allFilterContainerData');
		var dummyArray = Ext.getCmp('allFilterContainerData').dummyArray;
		var listViewData = new Array();
		if(dummyArray!=null && dummyArray!=undefined && dummyArray.length>0)
		{
			if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
			{
				var regex = RegExp(field.value, 'i');

				for(var key in appConstants.dummyArray)
				{
					var obj=appConstants.dummyArray[key];
					if(obj!=undefined)
					{
						var match = false;
						var valueStr = obj.value;
						match = match || regex.test(String(valueStr));
						if(match)
							listViewData.push(obj);
					}
				}
				dummyArray[0].child = listViewData;
			}
			else
			{
				for(var key in appConstants.dummyArray)
				{
					var obj=appConstants.dummyArray[key];
					if(obj!=undefined)
					{
						listViewData.push(obj);
					}
				}
				dummyArray[0].child = listViewData;
			}
			allFilterContainerData.getStore().removeAll();
			allFilterContainerData.getStore().loadRawData(dummyArray);
			field.focus();
		}
	}
});
