Ext.define('ReportBuilder.controller.BuilderController', {
extend: 'Ext.app.Controller',	
views: ['Main'],
method:null,
init: function () {
	this.control({ 
	});
},
invokeSettings:function(obj)
{	
	isSettingsEnabled=true;
	var me = this;
	var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
	Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'355px'}
			},
			{
				xtype:'container',
				html:tpl.apply(),
				cls:'containerHeader',
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype:'buildersettings' 
			}
		],
		onRender:function(){

			me.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("csvTool").setDisabled(true);			
			Ext.get('closeSettings').on('click', function () {
				me.validateAndCloseSettings();
			});
			if(appConstants.fromFavouriteModify=="Yes" || appConstants.fromScheduleModify=="Yes")
				Ext.getCmp("reportGeneration").setDisabled(true);
		},
		renderTo:'main'
	});
},
validateAndCloseSettings:function()
{
    if(this.validateSettings())
	{
  		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	}
},
closeSettingAndSubmit:function()
{
	if(this.validateAndCloseSettings())
	{
		this.beforeSubmit(Ext.getCmp('submit'));
	}
},
validateSettings :function(){
	var isSettingsOk = true;
	var reportgen=Ext.getCmp('reportGeneration').getValue();
	var timefrom = Ext.getCmp('timefrom').getValue();
	var minfrom = Ext.getCmp('minfrom').getValue();
	var timeto = Ext.getCmp('timeto').getValue();
	var minto = Ext.getCmp('minto').getValue();
	var tmpStDate = Ext.getCmp('er_stdate').getValue();
	if(tmpStDate != null)
	{
		tmpStDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEnDate = Ext.getCmp('er_enddate').getValue();
		if(tmpEnDate != null)
			tmpEnDate.setHours(Ext.getCmp('er_endhr').getValue());
		var result = checkDateTime(tmpStDate, tmpEnDate);
		if (!result) 
		{
			return;
		}
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		var rangeSettingsItemsId= Ext.getCmp('rangeSettingsItemsId');
		if(!rangeSettingsItemsId.isHidden() && rangeSettingsItemsId.items!=undefined)
		{
			for(var i=0;i<rangeSettingsItemsId.items.length;i++)
			{
				var valueOfCombo=Ext.getCmp('dynamicRangeCombo_'+i).getValue();
				if(valueOfCombo!='None')
				{
					if(Ext.getCmp('disp_MeasureName'+i).getValue()==''||Ext.getCmp('disp_MeasureName'+i).getValue()=='.'){
						 Ext.Msg.show({
							title: "Alert",
							msg: _checkempty,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING
						});
						return false;
					}
				}
			}
		}
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv')){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
	}
	return isSettingsOk;
},
callAjax:function(url,param,isAsync,widgetCountStatus,fullMargin)
{
	param+='&tempDesc='+appConstants.tempDesc;
	if(this.method=='submit')
	timelineurl='/final/reporter/ErReportBuilderDrillDown.jsp?'+param+'&isSubmit=true';
	distributedPieUrl=this.getQueryString(false);
	var me=this;
	Ext.Ajax.request({
			url:url,
			params:param,
			async:isAsync, 
			scope:this,
			success : function(response){
				if(response.responseText.length>0)
				{
					appConstants.builderJson=Ext.decode(response.responseText);
					me.onAjaxSuccess(widgetCountStatus,fullMargin);
				}
			},
			failure:function(err){
				Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
			}
		});
},

getForeGroundDataPanel:function(content){
	var me=this;
	  if (Ext.get('lblTool')==null) {
			//this.getToolLabel();
		}
	  var dataContainer = new Ext.panel.Panel({
		id: 'tableCont',
		padding: 0,
		margin: 10,
		//title:appConstants.publicJsonData.data.dataTitle,
		scroll: true,
		autoScroll: true,
		border: false,
		frame:false,
		html: content,
		listeners: {
		/*'afterRender': function()
{
				if (Ext.get('tierWiseTable')!=null)
				  me.getTROddEvenBG('tierWiseTable');

				if (Ext.get('serverWiseTable')!=null)
				  me.getTROddEvenBG('serverWiseTable');

				var el = Ext.get('tableCont');
				el.on('click', function(event, target, options)
				{


					me.getPopUpRequest(target.id);
			},
				this,
				{
					delegate: 'td'
				});

			}*/
				}
		});
	return dataContainer;
},
getheatMapInHTml:function(chartInfo)
{
	var content;
	content = '<div class="newTable" style="border:0px solid red;height:100%">';
	content += '<table border="0" id="heatMaphtml" align="center" width="100%" valign="top">';
	content +='<thead>';
	content +='<tr>';
	content += '<th  align="center" >'+''+'</th>';
	for(var i=0;i<chartInfo.xAxisLabel.length;i++)
{
		content += '<th  align="center" >'+chartInfo.xAxisLabel[i]+'</th>';
	}

	content +='</tr>';
	content +='</thead>';
	content +='<tbody>';

	for(var j=0;j<chartInfo.DataSet.length;j++)
	{
		var eachObj=chartInfo.DataSet[j];
		content +='<tr>';
			content +='<td>'+eachObj.name;
			content +='</td>';
			var colorr='green';
			for(var k=0;k<eachObj.data.length;k++)
			{
				var data=eachObj.data[k];
				if(data.indexOf("$$")>-1)
				{
					colorr=data.substring(data.indexOf("$$")+2);
					data=data.substring(0,data.indexOf("$$"));
			}
				content +='<td  align="center" style="background-color:'+colorr+'" >';
				content += '<span  class="font_bold11">'+data+'</span>';
				content += '</td>';
			}
		content +='</tr>';
	}
	content +='</tbody>';
	content +='</table>';
	content +='</div>';
	return content;
},

loadWidgetData:function(panelid,chartCollectionVal,widgetIdInfo,chartType,widgetWidth,widgetHeight)
{
	if(chartType=='heatMap')
	{
		widgetHeight=widgetHeight-70;
		var content;
		if(chartCollectionVal.DataSet=="" || chartCollectionVal.DataSet==undefined || chartCollectionVal.DataSet=='null')
		{
			content='<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>';

		}
		else
		{
			content=appConstants.appObj.getController(appConstants.appController).getheatMapInHTml(chartCollectionVal);
		}
		
		var foreGroundDataPanel=this.getForeGroundDataPanel(content);
		return foreGroundDataPanel;
	}
	appConstants.chartType='highchart';
	var doms = [];
	var box ={};
	//if(neeedEditableHeader=='no')
	//	widgetHeight=widgetHeight+20;
	if(chartType=='table'||chartType=='topn')		
	{
		if(chartCollectionVal != undefined && chartCollectionVal.gridData.length>0)
		{
			if(chartCollectionVal.gridColums instanceof Array)
			{
					box=this.getGrid(panelid,chartCollectionVal,chartCollectionVal.title,widgetWidth,widgetHeight,chartCollectionVal.enableSymbolImageTd,chartCollectionVal.enableCursorTd,chartCollectionVal.needtoFixColumn);				
			}
			else
			{
					var multisort=Ext.getCmp('multisort');
					if(appConstants.gridMultiSortEnable != undefined && appConstants.gridMultiSortEnable == 'yes' && multisort != undefined && multisort.getValue() == true)
					{					
						box=this.getMutlSortGrid1(panelid,chartCollectionVal,chartCollectionVal.title,widgetWidth,widgetHeight,chartCollectionVal.enableSymbolImageTd,chartCollectionVal.enableCursorTd);
					}
					else if(chartCollectionVal != undefined && chartCollectionVal.rowExpander != undefined && chartCollectionVal.rowExpander=='yes')
						box=this.getGridWithRowExpander(panelid,chartCollectionVal,chartCollectionVal.title,widgetWidth,widgetHeight,chartCollectionVal.enableSymbolImageTd,chartCollectionVal.enableCursorTd);
					else
						box=this.getGridWithSubCol(panelid,chartCollectionVal,chartCollectionVal.title,widgetWidth,widgetHeight,chartCollectionVal.enableSymbolImageTd,chartCollectionVal.enableCursorTd);
			}
		}
		else
		{ 
			box=this.getNoMeasureWithoutBorder();
		}
		
	}
	else
	{
		if(chartType!='timeline' && chartType!='line')
		{
			if(chartType=='bar')
			{
				var chartHeight=chartCollectionVal.chartHeight;
				if(chartHeight != undefined)
				{
					var dataSet=chartCollectionVal.DataSet;
					if(dataSet != undefined && dataSet.length>0 && chartHeight>300)
					{
						widgetHeight=chartHeight;
						Ext.getCmp(panelid).setAutoScroll(true);
					}
				}
			}
			widgetHeight=widgetHeight-40;  //for header
			box =
			{
				xtype:'container',
				data:chartCollectionVal,
				sortable: true,
				margin:10,
				padding: 0,
				//autoScroll:false,//..
				scroll:true,
				autoScroll:true,//..
				height:widgetHeight,
				closeAction:'destroy',
				html:'<div id="'+panelid+'_chart" style="height:'+widgetHeight+'px;"> </div>',//278-55=223
				listeners:
				{
					'boxready':function(c){
						try
						{
							var datte=chartCollectionVal;
							if(chartType=='distpie')
							{
								highChartPieHeight = widgetHeight-80;
								appConstants.erUtils.updateDistributedPieChart(widgetIdInfo,0,appConstants.chartType,datte,'pieColors','urlLinks','pieLabels','',datte.XML,datte.swfpath,datte,this);			
							}
							else if(chartType=='pie')
							{
								
								highChartPieHeight = widgetHeight-25;
								if(highChartPieHeight > 270)
									highChartPieHeight=270;
								appConstants.erUtils.updatePieChart_builder(appConstants.chartType,datte,'pieColors','urlLinks','pieLabels','',datte.XML,datte.swfpath,datte,this);
							}
							else if(this.data.chartType=='combinedChart' && this.data.multiAxis != undefined && this.data.multiAxis)
							{
								if (chartType=='bar')
								{
									if(datte.chartHeight>widgetHeight)
										widgetHeight=datte.chartHeight;
								}
								var lineChart = {};			
								lineChart = jQuery.extend(true, {}, getHighChartsBarInstance_combine(panelid+'_chart',widgetHeight,datte.chartWidth), lineChart);
								lineChart.setData(datte,'<%=currentDateFormat%>','');
								lineChart.drawChart();
								//appConstants.erUtils.updateCombineBarChart(appConstants.chartType,'',datte.XML,datte.swfpath,datte,widgetHeight,datte.chartWidth,this);//..
							}
							else
							{
								var lineChart = {};
								//lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id,datte,'',''), lineChart);
								lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(panelid+'_chart',datte,'',''), lineChart);
								lineChart.setData(datte,'<%=currentDateFormat%>','');
								lineChart.drawChart();
								
							}		
						}
						catch (e)
						{
							//console.log("e::"+e);
						}

					}

				}
			}
		}
		else
		{
			widgetHeight=widgetHeight-40;	//for header	
			var widgetHeightGraphPanel=widgetHeight-75;//for legend
			var heightForSharepoint = chartCollectionVal['isSharePointContentReport'];
			if(heightForSharepoint != undefined || heightForSharepoint != 'undefind' && heightForSharepoint == 'true')
			{
				widgetHeightGraphPanel = widgetHeightGraphPanel+65;
			}
			var heightForLoadEvaluator = chartCollectionVal['isLoadEvaluatorReport'];
			if(heightForLoadEvaluator!=undefined || heightForLoadEvaluator!='undefined' && heightForLoadEvaluator =='true')
			{
				widgetHeightGraphPanel = widgetHeightGraphPanel+75;
			}

			box =
			{
				xtype:'container',
				layout: {
					type: 'vbox',
					align:'stretch'
				},
				height:widgetHeight,//358-80=278
				padding:'0 0 10 0',
				items:[{
					xtype:'container',
					data:chartCollectionVal,
					sortable: true,
					margin:'0 10 0 10',
					padding: 0,
					autoScroll:false,//..
					id:panelid+'_chart_GraphPanel',
					//html:'<div id="'+panelid+'_chart" style="height:230px"> </div>',
					html:'<div id="'+panelid+'_chart" style="height:'+widgetHeightGraphPanel+'px"> </div>',//278-55=223
					closeAction:'destroy',
					height:widgetHeightGraphPanel,
					listeners:
					{
						'boxready':function(c){
							try
							{
								var datte=chartCollectionVal;
								if (chartType=='timeline' && this.data.hasMonthOrWeekGroup=='yes')//..
								{	
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsInstance(panelid+'_chart',"",""), lineChart);
									lineChart.setData(datte,'MMM dd, yyyy','');
									lineChart.drawChart();
								}
								else
								{
									if (chartType=='bar')
									{
										if(datte.chartHeight>widgetHeight)
											widgetHeight=datte.chartHeight-20;
									}				
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(panelid+'_chart',datte,'',''), lineChart);
									lineChart.setData(datte,'<%=currentDateFormat%>','');
									lineChart.drawChart();
								}		
							}
							catch (e)
							{
								console.log("e::"+e);
							}

						}
										
					}
				},
				{
					xtype:'container',
					margin:'5 0 5 0',
					id:panelid+'_chart_legendPanel',
					height:55,
					style:
					{
						'overflow': 'hidden',
						'padding-top':'2px',
						'padding-right':'10px',
						'padding-bottom':'2px',
					}
				}
			]
											
			}
		}
	}
	return box;
},
	loadOverAllPageNavigation:function(paginationToolId,other_Info,customPageinationId)
	{
		var me = this;
		var resultObj = Ext.getCmp(customPageinationId);
		var isRangeNeed = other_Info['isRangeNeed'];
		var dataPageNo = parseInt(other_Info['dataPageNo']);// current page no
		var overAllRecCount = parseInt(other_Info['overAllRecCount']);
		var recordPerPage = parseInt(other_Info['recordPerPage']);
		
		var dataPageNo_disp = ((dataPageNo-1)*Math.ceil(recordPerPage/gridPageSize)) + 1; 

		if(fromPerBtn)
		{
			dataPageNo_disp = dataPageNo_disp+activePage-1
		}
		if(isRangeNeed != 'true' && dataPageNo == 1)
	{
			return;
		}
		else
		{
			var nextDisable = false;
			var perDisable = false;
			var totalPage = Math.ceil(overAllRecCount/gridPageSize);
			if(dataPageNo == 1 && dataPageNo_disp == 1)
				perDisable=true;
			if(dataPageNo_disp == totalPage)
				nextDisable=true;
			var labelText = '<div style="text-align:center;font-size:10px;">Page &nbsp;<input type="text" onkeypress="return event.charCode >= 48 && event.charCode <= 57" name="'+dataPageNo_disp+'" value="'+dataPageNo_disp+'" size="1" style="width:25px;height:15px;text-align:center;font-size:10px"/> &nbsp; of '+totalPage+'<div>';
			var totatLabelText = '<div style="text-align:right;font-size:10px;">Total Records: '+overAllRecCount+'</div>';
			appConstants.totalRec = overAllRecCount;
			resultObj.add(
			{
				xtype:'container',
				style:
				{
					'border':'1px solid #C5C4C5',
					'border-top':'0px !important'
				},
				height:28,
				layout: 'column',
				margin: '0 20 10 20',
				padding:'5 0 10 0',
				items:[
				{
					xtype:'container',
					layout: 'hbox',
					columnWidth:.5,
					margin: '0 0 10 0',
					items:[
					{
						xtype:'container',
						width:48,
						margin: '0 0 10 5',
						items:[
						{
							xtype:'button',
							id:'firstPageBtn'+paginationToolId,
							tooltip: '<b>First Page</b>',
							iconCls: 'al_first_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							margin: '0 3 0 0',
							currentPage:dataPageNo,
							disabled:perDisable,
							listeners:
							{
								click:function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp(paginationToolId);
									var infolabel = Ext.getCmp('infolabel'+paginationToolId);
									var last = pageingTool.store.currentPage - 1;
									if(last == 0 && dataPageNo == 1)
										return;
									infolabel.update('<div style="text-align:center;font-size:10px;">Page &nbsp;<input type="text" onkeypress="return event.charCode >= 48 && event.charCode <= 57" name="'+1+'" value="'+1+'" size="1" style="width:25px;height:15px;text-align:center;font-size:10px"/> &nbsp; of '+totalPage+'<div>');
									if(dataPageNo > 1)
									{
										Ext.getCmp('main').show();
										//Ext.getCmp('selectionDetails').hide(); 
										appConstants.currentPage = 1;
										keepResult = true;
										appConstants.appObj.getController(appConstants.appController).gridCustomPaging(resultObj.up('panel'));
	}
									else
									{
										Ext.getCmp('firstPageBtn'+paginationToolId).setDisabled(true);
										Ext.getCmp('customPer'+paginationToolId).setDisabled(true);
										Ext.getCmp('customNext'+paginationToolId).setDisabled(false);
										Ext.getCmp('lastPageBtn'+paginationToolId).setDisabled(false);
										if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
										{
											pageingTool.store.loadPage(1);
	}
									}
								}
							}
						},
						{
							xtype:'button',
							iconCls: 'al_previous_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							id:'customPer'+paginationToolId,
							tooltip: '<b>Previous Page</b>',
							currentPage:dataPageNo,
							disabled:perDisable,
							listeners:
							{
								click:function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp(paginationToolId);
									var infolabel = Ext.getCmp('infolabel'+paginationToolId);
									var last = pageingTool.store.currentPage - 1;
									if(last == 0 && dataPageNo == 1)
										return;
									var temp = ((dataPageNo-1)*Math.ceil(recordPerPage/gridPageSize)) + last; 
									infolabel.update('<div style="text-align:center;font-size:10px;">Page &nbsp;<input type="text" onkeypress="return event.charCode >= 48 && event.charCode <= 57" name="'+temp+'" value="'+temp+'" size="1" style="width:25px;height:15px;text-align:center;font-size:10px"/> &nbsp; of '+totalPage+'<div>');
									if(last == 0 && dataPageNo > 1)
		{
										Ext.getCmp('main').show();
										//Ext.getCmp('selectionDetails').hide(); 
										fromPerBtn = true;
										appConstants.currentPage = this.currentPage-1;
										keepResult = true;
										appConstants.appObj.getController(appConstants.appController).gridCustomPaging(resultObj.up('panel'))
									}
									else
									{
										if(temp == 1)
										{
											Ext.getCmp('customPer'+paginationToolId).setDisabled(true);
											Ext.getCmp('firstPageBtn'+paginationToolId).setDisabled(true);
										}
										Ext.getCmp('customNext'+paginationToolId).setDisabled(false);
										Ext.getCmp('lastPageBtn'+paginationToolId).setDisabled(false);
										if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
										{
											pageingTool.store.loadPage(last);
										}
									}
								}
							}
						}]
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'label',
						width:101,
						id:'infolabel'+paginationToolId,
						html :labelText
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'container',
						margin: '0 0 10 0',
						width:48,
						items:[
						{
							xtype:'button',
							iconCls: 'al_next_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							id:'customNext'+paginationToolId,
							tooltip: '<b>Next Page</b>',
							margin: '0 3 0 0',
							currentPage:dataPageNo,
							disabled:nextDisable,
							listeners:
							{
								'click':function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp(paginationToolId);
									var infolabel = Ext.getCmp('infolabel'+paginationToolId);
									var next = pageingTool.store.currentPage + 1;
									var temp = ((dataPageNo-1)* Math.ceil(recordPerPage/gridPageSize)) + next; 
									if(temp > totalPage)
										return;
									infolabel.update('<div style="text-align:center;font-size:10px;">Page &nbsp;<input type="text" onkeypress="return event.charCode >= 48 && event.charCode <= 57" name="'+temp+'" value="'+temp+'" size="1" style="width:25px;height:15px;text-align:center;font-size:10px"/> &nbsp; of '+totalPage+'<div>');
									if(next <= Math.ceil(recordPerPage/gridPageSize))
									{
										Ext.getCmp('customPer'+paginationToolId).setDisabled(false);
										Ext.getCmp('firstPageBtn'+paginationToolId).setDisabled(false);
										if(temp == totalPage)
										{
											Ext.getCmp('customNext'+paginationToolId).setDisabled(true);
											Ext.getCmp('lastPageBtn'+paginationToolId).setDisabled(true);
						}
										if (pageingTool.fireEvent('beforechange', pageingTool, next) !== false) 
										{
											pageingTool.store.nextPage();
										}
									}
						else 
						{
										Ext.getCmp('main').show();
										//Ext.getCmp('selectionDetails').show();
										appConstants.currentPage = this.currentPage+1;
										keepResult = true;
										appConstants.appObj.getController(appConstants.appController).gridCustomPaging(resultObj.up('panel'))
						}		
					}
					}
						},
						{
							xtype:'button',
							iconCls: 'al_last_enabled',
							style: {
								background: 'none',
								border: '0px'
							}, 
							id:'lastPageBtn'+paginationToolId,
							tooltip: '<b>Last Page</b>',
							currentPage:dataPageNo,
							disabled:nextDisable,
							listeners:
							{
								'click':function()
								{
									fromPerBtn = true;
									var pageingTool = Ext.getCmp(paginationToolId);
									var infolabel = Ext.getCmp('infolabel'+paginationToolId);
									var next = Math.ceil(pageingTool.store.totalCount/gridPageSize);
									var temp = ((dataPageNo-1)* Math.ceil(recordPerPage/gridPageSize)) + next; 
									if(temp > totalPage)
										return;
									infolabel.update('<div style="text-align:center;font-size:10px;">Page &nbsp;<input type="text" onkeypress="return event.charCode >= 48 && event.charCode <= 57" name="'+totalPage+'" value="'+totalPage+'" size="1" style="width:25px;height:15px;text-align:center;font-size:10px"/> &nbsp; of '+totalPage+'<div>');
					
									if(dataPageNo == Math.ceil(overAllRecCount/recordPerPage))
									{
										Ext.getCmp('customPer'+paginationToolId).setDisabled(false);
										Ext.getCmp('firstPageBtn'+paginationToolId).setDisabled(false);
										Ext.getCmp('customNext'+paginationToolId).setDisabled(true);
										Ext.getCmp('lastPageBtn'+paginationToolId).setDisabled(true);
										if (pageingTool.fireEvent('beforechange', pageingTool, next) !== false) 
										{
											pageingTool.store.loadPage(next);
										}
									}
									else
									{
										Ext.getCmp('main').show();
										//Ext.getCmp('selectionDetails').hide();
										appConstants.currentPage = Math.ceil(overAllRecCount/recordPerPage);
										keepResult = true;
										appConstants.appObj.getController(appConstants.appController).gridCustomPaging(resultObj.up('panel'))
									}
								}
							}
						}]
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'container',
						width:25,
						margin: '0 0 10 0',
						items:[
						{
							xtype:'button',
							//iconCls: 'al_refresh_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							margin: '0 0 0 0',
							currentPage:dataPageNo,
							listeners:
							{
								click:function()
								{
									var pageingTool = Ext.getCmp(paginationToolId);
									var infolabel = Ext.getCmp('infolabel'+paginationToolId);
									var last = pageingTool.store.currentPage ;
									if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
									{
										pageingTool.store.loadPage(last);
									}
								}
							}
						}]
					}]
				},
				{
					xtype:'container',
					margin: '0 0 0 0',
					columnWidth:.5,
					layout :
					{
						type : 'hbox',
						pack : 'end'
					},
					items:
					{
						xtype:'label',
						html :totatLabelText
					}
				}]
			});
		}
	},

	getMutlSortGrid1:function(panelid,chartCollectionVal,title,gridPanelWidth,widgetHeight,enableSymbolImageTd,enableCursorTd)
	{	
	
		var mainIndex=0;
		var subIndex=0;
		var f=0;		
		var gridColumn=chartCollectionVal.gridColums
		var data=chartCollectionVal.gridData
		var customWidthAry = chartCollectionVal.customWidth;
		var fieldsToStore=new Array();
		var mainColArray=new Array();	 
		var mainColArray = new Array();
		var count=0;
		var me=this;
		var temp1 = 10;
		for (var key in gridColumn)
		{
			var mainColumn = key;
			var subColArrJson=gridColumn[key];
			var customWidth;
			if(customWidthAry!=undefined && customWidthAry[count]!='')
				customWidth = parseFloat(customWidthAry[count]);
			else
				customWidth='';		
			if (subColArrJson.length>0)
			{
				var subColArray = new Array();
				for (var subKey in subColArrJson)
				{ 					
					var	subcol = subColArrJson[subKey];
					var dataind=subcol+(count++);
					fieldsToStore.push({name: dataind,type:'float'});
						subColArray.push({ 
						header: subcol,
						align:'left',
						//align:'center',
						dataIndex: dataind,
						sortable: false,
						//autoScroll:true,
						renderer :function(value, metaData, record, row, col, store, gridView)
						{
							value=''+value;
							if(value.indexOf('~DD')>-1)
							{
								var text = value.substring( 0, value.indexOf('~DD') );
								var url = value.substring( value.indexOf('~DD') + 3 );
								value = '<span class="decimal-align"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:window.open(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a></span>';
								return value;
							}
							var symbolClass='';
							var enableSymbol='no';
							var colourr='';
							if(enableSymbolImageTd)
							{
								if(value.indexOf("@@") != -1)
								{
									symbolClass=value.substring(value.indexOf("@@")+2);
									value=value.substring(0,value.indexOf("@@"));
									enableSymbol='yes';
								}
								if(value.indexOf("$$")!=-1)
								{
									colourr=value.substring(value.indexOf("$$")+2);
									value=value.substring(0,value.indexOf("$$"));
								}
							}							
							if(value.indexOf("%")>-1)
							{
								metaData.tdAttr = '';
							}
							else
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
							}							
							var strDecimal='';
							var str='';
							if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
							{
								if(value!=null && value.indexOf(".")>-1)
								{
									strDecimal = value.substring(value.indexOf("."));
									str = value.substring(0,value.indexOf("."));
									if(enableSymbol=='yes' && enableSymbolImageTd)
									{										
										value='<table><tr><td class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;</td><td><span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span></td></tr></table>';
									}
									else if(enableSymbolImageTd)
										value='<span class="decimal-align" style="background:'+colourr+'">'+str+'</span><span class="decimal-align2" style="background:'+colourr+'">'+strDecimal+'</span>';
									else
										value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
								}
								else
								{
									if(enableSymbol=='yes' && enableSymbolImageTd)
									{										
										value='<table><tr><td class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;</td><td><span class="decimal-align">'+value+'</span></td></tr></table>';
									}
									else if(enableSymbolImageTd)
										value='<span class="decimal-align" style="background:'+colourr+'">'+value+'</span>';
									else
										value='<span class="decimal-align">'+value+'</span>';
								}
							}
							return value;
						},							
						listeners: {
							 headerclick: function(header, column, e, t,eOpts){
									var sortCombo=Ext.getCmp('er_sortingColumn');
									if(sortCombo != undefined){
									var selectedHeader=column.text;								
									 if(!Ext.isEmpty(sortCombo.getStore()) && !Ext.isEmpty(sortCombo))
									 {
										 if(selectedHeader != undefined && selectedHeader=='Error')
										 {
											  selectedHeader+=' (%)';
										 }
										 var getValueOfSelectedHeader = sortCombo.getStore().findExact('displayField', selectedHeader, 0);
										 if (getValueOfSelectedHeader != undefined && getValueOfSelectedHeader != -1) {
											var getModel = sortCombo.getStore().getAt(getValueOfSelectedHeader);
											var getFirstValueField = getModel.get('valueField');
											 if(sortCombo.getValue() != undefined && sortCombo.getValue() != getFirstValueField)
											 {												
												sortCombo.setValue(getFirstValueField);							
												if(!keepResult)
												{
													appConstants.totalRec=0;
													appConstants.currentPage=1;
												}
												Ext.getCmp('main').show();
												appConstants.appObj.getController(appConstants.appController).gridCustomPaging(this.up('panel'));											
											}
										 }									 
									 }
								 }
							}
						}
					});
				}
				mainColArray.push({ 
					header: key,				
					dataIndex: key,
					sortable: false,
					columns:subColArray,
				})
			}
			else
			{
				var c=0;				
				var dataind=key+(count++);
				if(count==1)
				{					
					fieldsToStore.push({name: dataind});
				}
				else
					fieldsToStore.push({name: dataind,type:'float'});
				var setAlign='left';
				mainColArray.push({ 
					header: key, 		
					sortable: false,
					align:setAlign,
					dataIndex: dataind,
					customWidth:customWidth,					
					renderer :function(value, metaData, record, row, col, store, gridView)
					{						
						value=''+value;
						var delegateClass='';			
						if(gridView.ownerCt.columns[col] != undefined && gridView.ownerCt.columns[col].dataIndex.indexOf('Components')==0 && enableCursorTd)
						{
							metaData.style = 'cursor: pointer;';//..
							delegateClass='forCursorSymbol';
						}									
						if(value.indexOf("%")>-1)
						{
							metaData.tdAttr = '';
						}
						else if(value.indexOf(' week')>-1)
						{
							value = me.getDataForWeekGroup(value);
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
						}
						else
						{
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
						}					
						var symbolClass='';
						var enableSymbol='no';
						var colourr='';
						if(enableSymbolImageTd)
						{
							if(value.indexOf("@@") != -1)
							{
								symbolClass=value.substring(value.indexOf("@@")+2);
								value=value.substring(0,value.indexOf("@@"));
								enableSymbol='yes';
							}
							if(value.indexOf("$$")!=-1)
							{
								colourr=value.substring(value.indexOf("$$")+2);
								value=value.substring(0,value.indexOf("$$"));
							}
						}
						var strDecimal='';
						var str='';
						if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
							{
								if(value!=null && value.indexOf(".")>-1)
								{
									strDecimal = value.substring(value.indexOf("."));
									str = value.substring(0,value.indexOf("."));									
									if(enableSymbol=='yes' && enableSymbolImageTd)
									{										
										value='<table><tr><td class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;</td><td><span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span></td></tr></table>';
									}
									else if(enableSymbolImageTd)
										value='<span class="decimal-align" style="background:'+colourr+'">'+str+'</span><span class="decimal-align2" style="background:'+colourr+'">'+strDecimal+'</span>';
									else
										value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
								}
								else
								{
									if(enableSymbol=='yes' && enableSymbolImageTd)
									{										
										value='<table><tr><td class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;</td><td><span class="decimal-align">'+value+'</span></td></tr></table>';
									}
									else if(enableSymbolImageTd)
										value='<span class="decimal-align" style="background:'+colourr+'">'+value+'</span>';
									else
										value='<span class="decimal-align">'+value+'</span>';
								}
						}
						if(enableCursorTd)
							value='<div class="'+delegateClass+'">'+value+'</div>';
						return value;
					},  				
					listeners: 
					{
						 headerclick: function(header, column, e, t,eOpts)
						 {
							var sortCombo=Ext.getCmp('er_sortingColumn');
							if(sortCombo != undefined)
							{
								var selectedHeader=column.text;								
								if(!Ext.isEmpty(sortCombo.getStore()) && !Ext.isEmpty(sortCombo))
								{
									var getValueOfSelectedHeader = sortCombo.getStore().findExact('displayField', selectedHeader, 0);
									if (getValueOfSelectedHeader != undefined && getValueOfSelectedHeader != -1)
									{
										var getModel = sortCombo.getStore().getAt(getValueOfSelectedHeader);
										var getFirstValueField = getModel.get('valueField');
										if(sortCombo.getValue() != undefined && sortCombo.getValue() != getFirstValueField)
										{
											 sortCombo.setValue(getFirstValueField);						
											if(!keepResult)
											{
												appConstants.totalRec=0;
												appConstants.currentPage=1;
											}
											Ext.getCmp('main').show();
											appConstants.appObj.getController(appConstants.appController).gridCustomPaging(this.up('panel'));											
											c++;
										}
									}
								}
							}
						}
					}
				});
			}
			f++;
		}
		var reorderer = Ext.create('Ext.ux.BoxReorderer', {
			listeners: {
				scope: this,
				Drop: function(r, c, button) { //update sort direction when button is dropped											
					if(tbar.items != undefined)
					{
						var tbarItems=tbar.items.items;
						for(var t=0;t<tbarItems.length;t++)
						{
							var eachSortData=tbarItems[t];								
							if(eachSortData.sortData != undefined)
							{							
								if(t==1)
								{
									var sortCombo=Ext.getCmp('er_sortingColumn');
									if(!Ext.isEmpty(sortCombo.getStore()) && !Ext.isEmpty(sortCombo))
									{
										var selectedHeader=eachSortData.text;
										var getValueOfSelectedHeader = sortCombo.getStore().findExact('displayField', selectedHeader, 0);
										if (getValueOfSelectedHeader != undefined && getValueOfSelectedHeader != -1)
										{
											var getModel = sortCombo.getStore().getAt(getValueOfSelectedHeader);
											var getFirstValueField = getModel.get('valueField');
											if(sortCombo.getValue() != undefined && sortCombo.getValue() != getFirstValueField)
											{
												sortCombo.setValue(getFirstValueField);						
												appConstants.er_sortingColumnState=eachSortData.sortData.direction;												
												appConstants.er_primaryIconCls=eachSortData.iconCls;												
											}
										} 								
									}
								}
								if(t==2)
								{
									var sortCombo=Ext.getCmp('er_secondaryColSort');
									if(!Ext.isEmpty(sortCombo.getStore()) && !Ext.isEmpty(sortCombo))
									{
										var selectedHeader=eachSortData.text;
										var getValueOfSelectedHeader = sortCombo.getStore().findExact('displayField', selectedHeader, 0);
										if (getValueOfSelectedHeader != undefined && getValueOfSelectedHeader != -1)
										{
											var getModel = sortCombo.getStore().getAt(getValueOfSelectedHeader);
											var getFirstValueField = getModel.get('valueField');
											if(sortCombo.getValue() != undefined && sortCombo.getValue() != getFirstValueField)
											{
												sortCombo.setValue(getFirstValueField);						
												appConstants.er_secondaryColSortState=eachSortData.sortData.direction;										
												appConstants.er_secondaryIconCls=eachSortData.iconCls;							
											}
										} 								
									}										
								}																				
							}
						}
					}	
				
					if(!keepResult)
					{
						appConstants.totalRec=0;
						appConstants.currentPage=1;
					}
					var paneInfo=tbar.up('panel');
					var paneInfoId = paneInfo.id;
					var thispanel = Ext.getCmp(paneInfoId);
					var initMask = new Ext.LoadMask(thispanel.getEl(),{msg : "Loading ..."});
					initMask.show();
					var url='/final/reporter/ReportBuilderController.jsp';
					var widgetId  = paneInfoId.substring(0,paneInfoId.indexOf("_"));
					if(widgetId.indexOf('customgridId') != -1)
						widgetId=widgetId.substring(widgetId.indexOf('customgridId')+12);
					keepResult = true;
					var paramVal= me.ajaxQueryMaker(Ext.getCmp('submit'));
					paramVal+='&widget='+widgetId;
					paramVal+='&tempDesc='+appConstants.tempDesc;				
					document.getElementById('resultcontainer-innerCt').innerHTML='';					
					me.callAjax(url,paramVal+'&widget='+widgetId,false,false,true);
					initMask.hide();								
				},				
			}
		});
		var droppable = Ext.create('Ext.ux.ToolbarDroppable', {
	   });
		gridPageSize=temp1;
		var store = Ext.create('Ext.data.ArrayStore', {
			 fields:fieldsToStore,
			 proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'array'
				}
			}, 
			pageSize:gridPageSize,
			remoteSort:true,
			sortable: false,
			autoLoad : true, 
			data : data,
		});
		var col1=Ext.getCmp('er_sortingColumn').getValue();
		var col1DispText=Ext.getCmp('er_sortingColumn').getRawValue();
		if(col1 != undefined && col1.indexOf("$") != -1)
		{
			var index=col1.substring(col1.indexOf("$")+1);
			col1=col1DispText+index;
		}
		var col2=Ext.getCmp('er_secondaryColSort').getValue();
		var col2DispText=Ext.getCmp('er_secondaryColSort').getRawValue();
		if(col2 != undefined && col2.indexOf("$") != -1)
		{
			var index=col2.substring(col2.indexOf("$")+1);
			col2=col2DispText+index;
		}
	
		//create the toolbar with the 2 plugins
		var tbar = Ext.create('Ext.toolbar.Toolbar', {
			items  : [{
				xtype: 'tbtext',
				text: 'Sorting order:',
				reorderable: false
			},
			{
				xtype: 'button',
				text: col1DispText,
				sortData: {
					property: col1,
					direction: appConstants.er_sortingColumnState
				},
				iconCls: appConstants.er_primaryIconCls,
				reorderable: true,
				listeners: {
					click: function(button, e) {						
						 var sortData = button.sortData,
						 iconCls  = button.iconCls;					
						if (sortData) {							
							var selectedHeader=button.text;								
							if(!keepResult)
							{
								appConstants.totalRec=0;
								appConstants.currentPage=1;
							}								
							appConstants.er_sortingColumnState=Ext.String.toggle(button.sortData.direction, "ASC", "DESC");
							appConstants.er_primaryIconCls=Ext.String.toggle(iconCls, "sort-asc", "sort-desc")
								//alert("==appConstants.er_sortingColumnState==33>>"+appConstants.er_sortingColumnState);
							if(tbar.items != undefined)
							{
								var tbarItems=tbar.items.items;
								for(var t=0;t<tbarItems.length;t++)
								{
									var eachSortData=tbarItems[t];
									if(eachSortData.sortData != undefined && eachSortData.text != selectedHeader)
									{
										appConstants.er_secondaryColSortState=eachSortData.sortData.direction;														
									}
								}
							}
							Ext.getCmp('main').show();							
							appConstants.appObj.getController(appConstants.appController).gridCustomPaging(this.up('panel')); 							
						}
					}
				}
			},
			{
				xtype: 'button',
				text: col2DispText,
				sortData: {
					property: col2,
					direction: appConstants.er_secondaryColSortState
				},
				iconCls: appConstants.er_secondaryIconCls,
				reorderable: true,
				listeners: {
					click: function(button, e) {						
						 var sortData = button.sortData,
						 iconCls  = button.iconCls;						
						if (sortData) {	
							var selectedHeader=button.text;						
							if(!keepResult)
							{
								appConstants.totalRec=0;
								appConstants.currentPage=1;
							}								
							appConstants.er_secondaryColSortState=Ext.String.toggle(button.sortData.direction, "ASC", "DESC");
							appConstants.er_secondaryIconCls=Ext.String.toggle(iconCls, "sort-asc", "sort-desc")
							if(tbar.items != undefined)
							{
								var tbarItems=tbar.items.items;
								for(var t=0;t<tbarItems.length;t++)
								{
									var eachSortData=tbarItems[t];
									if(eachSortData.sortData != undefined && eachSortData.text != selectedHeader)
									{
										appConstants.er_sortingColumnState=eachSortData.sortData.direction;														
									}
								}
							}
							Ext.getCmp('main').show();
							appConstants.appObj.getController(appConstants.appController).gridCustomPaging(this.up('panel'));																			
						}
					}
				}
			},
			{
				xtype:'button',
				id:'multisortNew',
				cls:'iconMoreOptions',
				listeners:{
					afterrender:function(){
						Ext.create("Ext.tip.ToolTip",{
							target: this.id,
							anchor: "top",
							cls: "yellowTip",
							trackMouse: true,
							html:'Multi Sort'	
						});
					},
					click:function()
					{
						//alert("==multisort column");
						var primayCol=Ext.getCmp('er_sortingColumn');
						var secondCol=Ext.getCmp('er_secondaryColSort');
						var allColumnArray=[];
						if(appConstants.builderJson.combo != undefined)
						{
							var allColumnsAry=appConstants.builderJson.combo.sortingColumnCombo;
							if(allColumnsAry != undefined)
							{
								for(var c=0;c<allColumnsAry.length;c++)
								{
									var eachColObj=allColumnsAry[c];
									//alert("==eachObj==>>"+JSON.stringify(eachColObj));
									var displyField=eachColObj.displayField;
									var valueField=eachColObj.valueField;									
									var checkedField=false;
									if(valueField == primayCol.getValue() || valueField == secondCol.getValue())
										checkedField=true;	
									allColumnArray.push(
										{
											xtype:'checkbox',
											cls:'checkbt',
											boxLabel:displyField,
											name:displyField,
											inputValue:valueField,
											checked:checkedField,											
										}
									);
								}
							}
						}
						Ext.create('Ext.window.Window',{
								title:'Multi Sorting Column',
								width:400,
								border:false,
								frame:false,
								modal: true,
								ghost: false,
								height:280,
							//	padding:'0 10 5 10',
								listeners: {
									show: function (win) {
										//alert("==this.modal==>>"+this.modal);
										if (this.modal) {
											var dom = Ext.dom.Query.select('.x-mask');
											for (var y = 0; y < dom.length; y++) {
												var el = Ext.fly(dom[y]);
												 el.addCls('windowModal');
											}										
										}
									},
									hide: function (win) {
										var dom = Ext.dom.Query.select('.x-mask');
										if (this.modal) {
											var el = Ext.fly(dom[0]);
											el.removeCls('windowModal');
										}
									},
									afterrender: function () {
										Ext.EventManager.onWindowResize(function () {
											var me = this;
											me.center();
										}, this);
									}
							},
							items:[
								{
									xtype:'panel',						
									autoScroll:true,
									scroll:true,		
									height:270,									
									autoHeight: true,
									style:{'overflow-x':'hidden'},
									id:'chekboxAllCol',
									items:[
										{
											xtype:'checkboxgroup',
											columns:2,											
											vertical:true,
											width:'100%',
											margin:'10px',
											id:'multiColchkboxgroup',
											items:allColumnArray,
											listeners:{											
												change:function(ckbox,checked)
												{
													//alert("==newValue==>>"+JSON.stringify(newValue));
													if(Object.keys(checked).length > 2)
													{
														var i=1;
														//alert("==checked==s111>>>>>"+JSON.stringify(checked));
														for (var property in checked) {
															if (checked.hasOwnProperty(property)) {
																// do stuff
																var myobj=Ext.ComponentQuery.query('[name='+property+']');
																if(i==1)
																{
																	var selID=myobj[0].id;
																	var selObj=Ext.getCmp(selID);																
																	selObj.setValue(false);
																}
																i++;
															}
														}
													}
												}												
											}
										}
									]
								}
							],
							buttonAlign:'center',
							buttons:[
								{
									text:'Update',
									id:'multisortSelectId',
									cls:'quickMenuWhiteButton',
									handler: function(buttonObj)
									{
										var selectedCols=Ext.getCmp('multiColchkboxgroup').getChecked();
										var multisort=Ext.getCmp('multisort');
										if(selectedCols.length>1)
										{
											appConstants.gridMultiSortEnable='yes';											
											multisort.setValue(true);
										}
										else
										{
											appConstants.gridMultiSortEnable='no';
											multisort.setValue(false);
										}
										Ext.each(selectedCols,function(obj,index){
											//alert("==index==>>"+index+"==sellect==>>>>>"+obj.getSubmitValue());
											if(index==0)
												primayCol.setValue(obj.getSubmitValue());
											else if(index==1)
												secondCol.setValue(obj.getSubmitValue());
										});
										if(!keepResult)
										{
											appConstants.totalRec=0;
											appConstants.currentPage=1;
										}
										Ext.getCmp('main').show();
										appConstants.appObj.getController(appConstants.appController).gridCustomPaging(tbar.up('panel'));	
										this.up('window').destroy();
									}
								}
							],
						}).show();
					}
				},
			}
			],
		    plugins: [reorderer,droppable]
		});
		var isPagingHidden=true;		
		var forceFitColsCount=8;
		if(gridPanelWidth > 1000)
		{
			var remainingWidth=gridPanelWidth-1000;
			var roundOffValue=Ext.util.Format.round((remainingWidth/100), 0);
			forceFitColsCount=forceFitColsCount+roundOffValue;
		}	
		var forceFit = true;
		if(forceFitColsCount < fieldsToStore.length)
			forceFit=false;
		if(gridPageSize<data.length)
			isPagingHidden=false; 	
		if(customPaging)
		{
			isPagingHidden = true;			
		}
		if(fromPerBtn)
		{
			activePage = Math.ceil(data.length/gridPageSize);
		}
		var resultArry=[];
		resultArry.push({
				xtype:'customgrid_builder',
				tbar : tbar,
				store: store,
				columns: mainColArray,
				id:'customgridId'+panelid,
				padding:0,
				margin: 10,
				frame:false,
				autoScroll:true,
				stripeRows: true,
				needtoFixColumn:true,
				popUpData:'noToolTip',
				scroll:false, 
				//cls:'newGridSkin horizontal-scroll',
				ui:'newGridPanel',
				border:true,
				layout : {
					type : 'vbox',
					align:'stretch'
				},
				flex:1,
				//forceFit:forceFit,
				//layout:'fit',
				//align:'stretch',
				listeners: {
					scope: this,
					single: true,					
					afterlayout: function(grid) {
					   var sorters = [];
					   if(tbar.items != undefined)
						{
							var tbarItems=tbar.items.items;
							for(var t=0;t<tbarItems.length;t++)
							{
								var eachSortData=tbarItems[t];
								if(eachSortData.sortData != undefined)
									sorters.push(eachSortData.sortData);
							}
						}
						store.sort(sorters);
					},					
				},
			dockedItems:[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				store: store,
				id:'pageingTool'+panelid,
				hidden:isPagingHidden,
				//hidden:true,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No Data to display",
				listeners: {
					change : function(thisd, params)
					{  
						//activePage = params.currentPage;
					}
			}
		}],	
			});
		resultArry.push(
			{
				xtype:'container',
				id:'customPageinationId'+panelid,
				//padding:'10px',			
				margin:'0 -10 0 -10',
				layout : {
					type : 'vbox',
					align:'stretch'
				},
				flex:1,
			}
		);
		return {
			xtype:'container',
			id:'containerr'+panelid,
			layout : {
					type : 'vbox',
					align:'stretch'
				},
				flex:1,
			items:resultArry
		};
	},
getGridWithRowExpander:function(panelid,chartCollectionVal,title,gridPanelWidth,widgetHeight,enableSymbolImageTd,enableCursorTd)
	{
	var sortIndex=chartCollectionVal.sortIndex
	var sortOrderStatus="DESC";
	if(chartCollectionVal.sortOrderStatus != undefined)
	sortOrderStatus=chartCollectionVal.sortOrderStatus
	var data=chartCollectionVal.gridData;
	var temp1 = 10;
	if(widgetHeight>120)
	{
		// 120 for header footer height and 70 for page nagation height
		//temp1 = widgetHeight-120-75;
		temp1 = widgetHeight-60-75;
		temp1 = temp1/24;
		temp1 = Ext.util.Format.round(temp1, 0);		
	}
	gridPageSize=temp1;
	var headings = new Array();
	var expanderHeadings = new Array();
	var expanderColm = new Array();
	
	if (!Ext.isEmpty(chartCollectionVal.gridColums) && chartCollectionVal.gridColums!=undefined)
	{	
		var s=0;
		for(var key in chartCollectionVal.gridColums)
		{
			headings[s] = key;
			s++;
		}
	}
	var expandData=new Array();
	var expanderStoreArry=new Array();
	var isExpanderContentGrid=false;
	if(data != undefined && data[0] != undefined && data[0].subColumnDatas != undefined && data[0].subColumnHeader != undefined){
		//..
		/*var e=0;
		var subHeadrArr=data[0].subColumnHeader;
		for(var eachIndex in subHeadrArr)
		{
			var expanderHeadingsTemp=subHeadrArr[eachIndex];
			var tempCustomWidth;
			if(expanderHeadingsTemp != undefined && expanderHeadingsTemp.indexOf("~") != -1)
			{
				tempCustomWidth = parseFloat(expanderHeadingsTemp.substring(expanderHeadingsTemp.indexOf("~")+1));
				expanderHeadingsTemp=expanderHeadingsTemp.substring(0,expanderHeadingsTemp.indexOf("~"));
			}
			else
				tempCustomWidth='';
			expanderHeadings[e]=expanderHeadingsTemp;
			expanderColm.push({
				header: expanderHeadingsTemp,
				sortable: true,
				dataIndex: expanderHeadingsTemp,
				align:'left',
				customWidth:tempCustomWidth,
				//width:200,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					if(value.indexOf('~DDLink')>-1)
					{
						var text = value.substring( 0, value.indexOf('~DDLink') );
						var url = value.substring( value.indexOf('~DDLink') + 7 );
						value = '<a class="anchorLink" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a>';
						return value;
					}
					else if(value.indexOf('~DD')>-1)
					{
						var text = value.substring( 0, value.indexOf('~DD') );
						var url = value.substring( value.indexOf('~DD') + 3 );
						value = '<a class="anchorLink" href="javascript:void(0);" onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');" >'+text+'</a>';
						return value;
					}
					return value;
				}
			});
			e++;
		}		
		for(var dataIndx in data){
			var tmpData=data[dataIndx];
			if(tmpData != undefined && tmpData.subColumnDatas != undefined && tmpData.subColumnHeader != undefined){
			{
				var subDataArr=tmpData.subColumnDatas;
				expandData=subDataArr;
			}			
			var expanderStore = Ext.create('Ext.data.Store', {
				fields: expanderHeadings,
				data: expandData,
				pageSize:10,
				autoLoad : true,
				remoteSort: true,
				proxy : {
				  type : 'pagingmemory'
				}
			});
			expanderStoreArry.push(expanderStore);
			}
		}*/
		//..
		for(var dataIndx in data){
		//	alert('==dataIndx>>>>>>>>>>'+dataIndx);
			var tmpData=data[dataIndx];
			if(tmpData != undefined && tmpData.subColumnDatas != undefined && tmpData.subColumnHeader != undefined){
				var subHeadrArr=tmpData.subColumnHeader;
				var dd='data'+panelid+dataIndx;
				//alert('dd==>>>'+dd);				
				var subDataValz='<div class="newTable"><table width="100%" id="'+dd+'"><thead><tr>'
				for (var indxx in subHeadrArr)
				{
					var subHeaderStr=subHeadrArr[indxx];
					var tdWidth;
					if(subHeaderStr != null && subHeaderStr.indexOf('~') != -1)
					{
						tdWidth=subHeaderStr.substring(subHeaderStr.indexOf('~')+1);
						tdWidth=parseFloat(tdWidth);
						subHeaderStr=subHeaderStr.substring(0,subHeaderStr.indexOf('~'));
					}
					subDataValz+='<th width='+tdWidth+'>'+subHeaderStr+'</th>';
				}
				subDataValz+='</tr></thead><tbody>';
				var subDataArr=tmpData.subColumnDatas;
				for(var indd in subDataArr){
					var tmpSubData=subDataArr[indd];
					subDataValz+='<tr>';
					for (var indxx in subHeadrArr)
					{
						var hdrVal=subHeadrArr[indxx];
						var tdWidth;
						if(hdrVal != undefined && hdrVal.indexOf('~') != -1)
						{
							tdWidth=hdrVal.substring(hdrVal.indexOf('~')+1);
							tdWidth=parseFloat(tdWidth);
							hdrVal=hdrVal.substring(0,hdrVal.indexOf('~'));							
						}
						var tSubDataVal=tmpSubData[hdrVal];
						if(tSubDataVal != undefined && tSubDataVal.indexOf("~DDLink")>-1)
						{
							var text = tSubDataVal.substring( 0, tSubDataVal.indexOf('~DDLink') );
							var url = tSubDataVal.substring( tSubDataVal.indexOf('~DDLink') + 7 );							
							//tSubDataVal = '<a class="anchorLink" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a>';
							tSubDataVal = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:window.open(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a>';
						}
						else if(tSubDataVal != undefined && tSubDataVal.indexOf("~DD")>-1)
						{
							var text = tSubDataVal.substring( 0, tSubDataVal.indexOf('~DD') );
							var url = tSubDataVal.substring( tSubDataVal.indexOf('~DD') + 3 );							
							//tSubDataVal = '<a class="anchorLink" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a>';
							tSubDataVal = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');" >'+text+'</a>';
						}
						subDataValz+='<td style="max-width:450px;word-break: break-all;" width='+tdWidth+'>'+tSubDataVal+'</td>';
					}
					subDataValz+='</tr>';
				}
				subDataValz+='</tbody></table></div>';
				//console.log(console.log('initializing>>>>>>'+dd););
				data[dataIndx]['userDetailList']=subDataValz;
			}
		}
		//isExpanderContentGrid=true;
	}
	else
	{
		//isExpanderContentGrid=false;
	}
	headings[s] = 'userDetailList';
	
	var store = Ext.create('Ext.data.Store', {
		fields: headings,
		data: data,
		pageSize:gridPageSize,
		autoLoad : true,
		remoteSort: true,
		proxy : {
		  type : 'pagingmemory'
		}
	});
	var colm = new Array();
	for(var keys in chartCollectionVal.gridColums)
	{
		var tmpCol=chartCollectionVal.gridColLanguageObj[keys];
		var customWidth;
		//alert("tmpCol============>>>>"+tmpCol);
		if(tmpCol!=undefined && tmpCol.indexOf("~") != -1)
		{
			customWidth = parseFloat(tmpCol.substring(tmpCol.indexOf("~")+1));
			//alert('==customWidth===>>'+customWidth);
			tmpCol=tmpCol.substring(0,tmpCol.indexOf("~"));
		}
		else
			customWidth=200;
		//customWidth=600;
		//alert("tmpCol============>>>>"+tmpCol+"====>>>customWidth>>>>>>"+customWidth);
		colm.push({
			header: tmpCol,
			sortable: true,
			dataIndex: keys,
			align:'left',
			//width:200,
			//width:customWidth,
		//	minWidth:customWidth,
			customWidth:customWidth,
			flex:1,
			renderer :function(value, metaData, record, row, col, store, gridView)
			{
				if(value.indexOf('~DDLink')>-1)
				{
					var text = value.substring( 0, value.indexOf('~DDLink') );
					var url = value.substring( value.indexOf('~DDLink') + 7 );
					value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a>';
					return value;
				}
				else if(value.indexOf('~DD')>-1)
				{
					var text = value.substring( 0, value.indexOf('~DD') );
					var url = value.substring( value.indexOf('~DD') + 3 );
					value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');" >'+text+'</a>';
					return value;
				}
				return value;
			},
			doSort: function(state) 
				{
				var ds = this.up('grid').store;
				var field = this.getSortParam();
				ds.sort({
					property: field,
					direction: state,
					sorterFn: function(v1, v2){
						v1 = v1.get(field);
						v2 = v2.get(field);	
						if(v1.indexOf("~DD") != -1)
							v1=v1.substring(0,v1.indexOf("~DD"));
						if(v2.indexOf("~DD") != -1)
							v2=v2.substring(0,v2.indexOf("~DD"));

						if(!isNaN(v1) && !isNaN(v2))
						{
							v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
							v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
							if (state=='ASC')
							{
								v1= isNaN(v1) ? 999999 : v1;
								v2= isNaN(v2) ? 999999 : v2;
							}
							else if(!isNaN(v1) && !isNaN(v2))
							{
								v1=v1;
								v2=v2;
							}
							else
							{
								v1= isNaN(v1) ? 0 : v1;
								v2= isNaN(v2) ? 0 : v2;
							}
						}
						else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
						{
							v2=new Date(v2).getTime(); 
							v1=new Date(v1).getTime(); 
						}
						return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
					}
				});
			}
		});
		/*if(tmpCol != undefined && tmpCol == 'Segment')
		{
			colm[colm.length-1].minWidth=400;
			colm[colm.length-1].flex=0.5;
			colm[colm.length-1].align='center';
		}*/
		if(tmpCol != undefined && tmpCol == 'Occurrences')
		{
			colm[colm.length-1].width=110;
			colm[colm.length-1].flex=0.5;
			colm[colm.length-1].align='center';
		}
		if(tmpCol != undefined && tmpCol == 'Dump Sources causing the dump')
		{
			colm[colm.length-1].minWidth=210;
			colm[colm.length-1].flex=0.5;
			colm[colm.length-1].align='center';
		}
		if(tmpCol != undefined && tmpCol == 'Programs  causing the dump')
		{
			colm[colm.length-1].minWidth=190;
			colm[colm.length-1].flex=0.5;
			colm[colm.length-1].align='center';
		}
		if(tmpCol != undefined && tmpCol == 'Hosts impacted')
		{
			colm[colm.length-1].width=120;
			colm[colm.length-1].flex=0.5;
			colm[colm.length-1].align='center';
		}
		if(tmpCol != undefined && tmpCol == 'User Accounts Impacted')
		{
			colm[colm.length-1].minWidth=180;
			colm[colm.length-1].flex=0.5;
			colm[colm.length-1].align='center';
		}
		if(tmpCol != undefined && tmpCol == 'Dump type')
		{
			colm[colm.length-1].minWidth=170;
			colm[colm.length-1].flex=0.5;
		}
	}	
	var isPagingHidden=true;
	var conExpandDetail = '';
	conExpandDetail=[{
			ptype: 'rowexpander',
			selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
			expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
			expandOnEnter : false,
			collapsible: true,
			animCollapse: false,
			//rowBodyTpl: ['<div style="padding:10px 20px 10px 10px;" >{userDetailList}</div>']
			rowBodyTpl: ['<div style="padding:10px 5px 10px 0px;" >{userDetailList}</div>']
		}];
	var forceFitColsCount=8;
	if(gridPanelWidth > 1000)
	{
		var remainingWidth=gridPanelWidth-1000;
		var roundOffValue=Ext.util.Format.round((remainingWidth/100), 0);
		forceFitColsCount=forceFitColsCount+roundOffValue;
	}
	var activePageCon=1;
	var forceFit = true;
	if(forceFitColsCount < headings.length)
		forceFit=false;
	if(gridPageSize<data.length)
		isPagingHidden=false; 
		if(customPaging)
		{
			isPagingHidden = true;
		}
		if(fromPerBtn)
		{
			activePage = Math.ceil(data.length/gridPageSize);
		}
		var resultArry=[];
		resultArry.push({	
		xtype:'customgrid_builder',
		sortableColumns: true,
		needtoFixColumn:true,
		ui:'newGridPanel',
		id:'customgridId'+panelid,
		margin:'0 10 10 10',
		padding:0,
		border:true,
		scroll: false,
		autoScroll:true,
		layout : {
			type : 'vbox',
			align:'stretch'
		},
		flex:1,
		forceFit:true,
		//maxHeight:300,
		//minHeight:250,
		store: store,
		columns: colm,
		plugins: conExpandDetail,
		/*plugins:[{
				ptype:'cmprowexpander',
				selectRowOnExpand : true,
				expandOnDblClick: false,
				expandOnEnter : false,
				collapsible: true,
				animCollapse: false,
				createComponent: function(view,record,htmlnode,index) {
				  var isExpandPagingHidden=true;
				  var expandRowData=expanderStoreArry[index];
				  if(expandRowData != undefined && expandRowData.data !=undefined && 10<=expandRowData.data.length)
					isExpandPagingHidden=false;
				  var hideHeaders=false;
				  if(data != undefined && data[index] != undefined && data[index].userDetailList!= undefined)
				  {
						hideHeaders=true;
				  }				 
				  if(!isExpanderContentGrid)
				  {
					  return Ext.create('Ext.container.Container',{
						  margin:'10 10 10 10',
						  html:data[index].userDetailList,
					  });
				  }
				  else
				  {
					  return Ext.create('Ext.container.Container',{
						items:[{
							xtype:'customgrid_builder',
							sortableColumns: true,
							ui:'newGridPanel',
							id:'customgridId'+panelid+index,
							margin:'10 10 10 10',
							border:true,
							scroll: true,
							autoScroll:true,																					
							//forceFit:true,
							store: expandRowData,
							columns: expanderColm,
							hideHeaders:hideHeaders,
							dockedItems:[
							{xtype:'pagingtoolbar',
								cls:'pagingtoolbar',
								dock: 'bottom',
								displayInfo: true,
								cls:'pagingtoolbar',
								store: expandRowData,
								id:'pageingTool'+panelid+index,
								hidden:isExpandPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying topics {0} - {1} of {2}',
								emptyMsg: "No Data to display",
								listeners: {
									change : function(thisd, params)
									{  
									}
								}
							}],
						}]					
					  });
					}					
				}
		  }],*/
		viewConfig:
		{
			stripeRows: true,
			getRowClass: function (record, rowIndex, rowParams, store)
			{
				if (record.raw.dataDetail =='')
				{
					return 'hidePlus';
				}
				else
				{
					return;
				}
			},
			listeners: 
			{
				sortchange:function(ct, column, e, t, eOpts ){
					me.gridColIndexParam=column.getIndex();
					me.gridColStateParam=column.sortState;
					this.getStore().loadPage(activePageCon);
				}
			}
		},
		sortableColumns: true,
		listeners:{
			render:function(obj){
				Ext.defer(function() {
				for(var i in colm)
				{
					//obj.columns[sortIndex].setSortState(sortOrderStatus,true,true);
					}
				},100);
			},					
		},
		dockedItems:[
			{xtype:'pagingtoolbar',
				cls:'pagingtoolbar',
				dock: 'bottom',
				displayInfo: true,
				cls:'pagingtoolbar',
				store: store,
				id:'pageingTool'+panelid,
				hidden:isPagingHidden,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No Data to display",
				listeners: {
					change : function(thisd, params)
					{  
					}
				}
			}],	
		});
		resultArry.push(
			{
				xtype:'container',
				id:'customPageinationId'+panelid,
				margin:'0 -10 0 -10',
	}
		);
		return {
			xtype:'container',
			id:'containerr'+panelid,
			layout: {
				type: 'vbox',
				align:'stretch'
			},
			flex:1,
			items:resultArry
		};	
},
getGridWithSubCol:function(panelid,chartCollectionVal,title,gridPanelWidth,widgetHeight,enableSymbolImageTd,enableCursorTd)
{
	var mainIndex=0;
	var subIndex=0;
	var f=0;
	var sortIndex=chartCollectionVal.sortIndex
	var sortOrderStatus="DESC";
	if(chartCollectionVal.sortOrderStatus != undefined)
		sortOrderStatus=chartCollectionVal.sortOrderStatus;
	var gridColumn=chartCollectionVal.gridColums;
	var gridColLanguageObj=chartCollectionVal.gridColLanguageObj;
	var data=chartCollectionVal.gridData;
	var customWidthAry = chartCollectionVal.customWidth;
	var subColHeaderAlign='left';
	if(chartCollectionVal.subColAlign != undefined)
		subColHeaderAlign = chartCollectionVal.subColAlign;
	var fieldsToStore=new Array();
	var mainColArray=new Array();	 
//	var mainColArray = new Array();
	var count=0;
	var me=this;
	//120
	var temp1 = 10;
	if(widgetHeight>120)
	{
		// 120 for header footer height and 70 for page nagation height
		//temp1 = widgetHeight-120-75;
		//temp1 = widgetHeight-60-75;
		temp1 = widgetHeight-90-75;
		temp1 = temp1/24;
		temp1 = Ext.util.Format.round(temp1, 0);
	}
	for (var key in gridColumn)
	{
		var mainColumn = key;
		var mainHeaderCol=key;
		if(gridColLanguageObj != undefined && gridColLanguageObj[mainHeaderCol] != undefined)
		{
			mainHeaderCol=gridColLanguageObj[mainHeaderCol];
		}
		var subColArrJson=gridColumn[key];
			var customWidth;
			if(customWidthAry!=undefined && customWidthAry[count] != undefined && customWidthAry[count]!='')
			{
				customWidth = parseFloat(customWidthAry[count]);
			}
			else
				customWidth='';		
		if (subColArrJson.length>0)
		{
			
			var subColArray = new Array();
			for (var subKey in subColArrJson)
			{ 
				if(sortIndex==count)
				{
					mainIndex=f;
					subIndex=subKey;
				}
				/* subcol = subColArrJson[subKey]+" (" + units[mainColumn]+ ")"; */
				var	subcol = subColArrJson[subKey];		
				var subColLangHeader=subcol;
				if(gridColLanguageObj != undefined && gridColLanguageObj[subColLangHeader] != undefined)
				{
					subColLangHeader=gridColLanguageObj[subColLangHeader];
				}
				if(subColArrJson.length < 3)
					subColHeaderAlign='center';
				
				if(customWidthAry!=undefined && customWidthAry[count] != undefined && customWidthAry[count]!='')
				{
					customWidth = parseFloat(customWidthAry[count]);
				}
				else
					customWidth='';
				var dataind=subcol+(count++);		
				
				fieldsToStore.push({name: dataind});				
					subColArray.push({ 
					header: subColLangHeader,
					align:subColHeaderAlign,
					dataIndex: dataind,
					sortable: true,
					customWidth:customWidth,
					flex:1,
					renderer :function(value, metaData, record, row, col, store, gridView)
					{
						if(value.indexOf('~DDLink')>-1)
						{
							var text = value.substring( 0, value.indexOf('~DDLink') );
							var url = value.substring( value.indexOf('~DDLink') + 7 );
							if(!isNaN(text) && !isNaN(parseFloat(text)))
								value = '<span class="decimal-align"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a></span>';
							else
								value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a>';
							return value;
						}
						if(value.indexOf('~DD')>-1)
						{
							var text = value.substring( 0, value.indexOf('~DD') );
							var url = value.substring( value.indexOf('~DD') + 3 );
							//value = '<span class="decimal-align"><a class="anchorLink" href="javascript:void(0);" onClick="javascript:window.open(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a></span>';
							value = '<span class="decimal-align"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');" >'+text+'</a></span>';
							return value;
						}
						var symbolClass='';
						var enableSymbol='no';
						var colourr='';
						if(enableSymbolImageTd)
						{
							if(value.indexOf("@@") != -1)
							{
								symbolClass=value.substring(value.indexOf("@@")+2);
								value=value.substring(0,value.indexOf("@@"));
								enableSymbol='yes';
							}
							if(value.indexOf("$$")!=-1)
							{
								colourr=value.substring(value.indexOf("$$")+2);
								value=value.substring(0,value.indexOf("$$"));
							}
						}
						if(value.indexOf("%")>-1)
						{
							//valueAry.push('<div style="background:#00ff00 ;width:'+precentage+'%!important">'+dataInfo+'</div>');
							//value='<div style="height:18px; background:#8399b0 ;width:'+value+'!important"> </div>'
							metaData.tdAttr = '';
						}
						else
						{
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
						}
						var strDecimal='';
						var str='';
						if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
						{
							if(value!=null && value.indexOf(".")>-1)
							{
								strDecimal = value.substring(value.indexOf("."));
								str = value.substring(0,value.indexOf("."));
								//value='<div class="state_transition_GOOD"><span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span></div>';
								if(enableSymbol=='yes' && enableSymbolImageTd)
								{
									//value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span><span class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
									value='<table><tr><td class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;</td><td><span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span></td></tr></table>';
								}
								else if(enableSymbolImageTd)
									value='<span class="decimal-align" style="background:'+colourr+'">'+str+'</span><span class="decimal-align2" style="background:'+colourr+'">'+strDecimal+'</span>';
								else
									value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
							}
							else
							{
								if(enableSymbol=='yes' && enableSymbolImageTd)
								{
									//value='<span class="decimal-align">'+value+'</span><span class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
									value='<table><tr><td class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;</td><td><span class="decimal-align">'+value+'</span></td></tr></table>';
								}
								else if(enableSymbolImageTd)
									value='<span class="decimal-align" style="background:'+colourr+'">'+value+'</span>';
								else
									value='<span class="decimal-align">'+value+'</span>';
							}
						}
						return value;
					},
					doSort: function(state)
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2){
								v1 = v1.get(field);
								v2 = v2.get(field);
									if(v1.indexOf("~DD") != -1)
										v1=v1.substring(0,v1.indexOf("~DD"));
									if(v2.indexOf("~DD") != -1)
										v2=v2.substring(0,v2.indexOf("~DD"));
								if(!isNaN(v1) && !isNaN(v2))
								{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10); 
										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										if (state=='ASC')
										{
											v1= isNaN(v1) ? 999999 : v1;
											v2= isNaN(v2) ? 999999 : v2;
										}
										else
										{
											v1= isNaN(v1) ? 0 : v1;

											v2= isNaN(v2) ? 0 : v2;
										}
									}
									else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
									{
										v2=new Date(v2).getTime(); 
										v1=new Date(v1).getTime(); 
									}
									// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
						},
						listeners: {
							 headerclick: function(header, column, e, t,eOpts){
									var sortCombo=Ext.getCmp('er_sortingColumn');
									if(sortCombo != undefined){
									var selectedHeader=column.text;
									if(selectedHeader != undefined && selectedHeader=='Error')
									 {
										  selectedHeader+=' (%)';
									 }		
									 var headerClickRequest=true;
									 if(wildcardSearch)
								     {
										var wildCardSearch=Ext.getCmp('wildcardSearch').getValue()
										if(wildCardSearch != undefined && wildCardSearch.trim().length>0 && wildCardSearch!='*')
											headerClickRequest=false;
									 }							 
									 
									 if(!Ext.isEmpty(sortCombo.getStore()) && !Ext.isEmpty(sortCombo) && headerClickRequest)
									 {
										 var getValueOfSelectedHeader = sortCombo.getStore().findExact('displayField', selectedHeader, 0);
										 if (getValueOfSelectedHeader != undefined && getValueOfSelectedHeader != -1) {
											var getModel = sortCombo.getStore().getAt(getValueOfSelectedHeader);
											var getFirstValueField = getModel.get('valueField');
											 if(sortCombo.getValue() != undefined && sortCombo.getValue() != getFirstValueField)
											 {
												 sortCombo.setValue(getFirstValueField);							
												if(!keepResult)
												{
													appConstants.totalRec=0;
													appConstants.currentPage=1;
												}
												Ext.getCmp('main').show();
												appConstants.appObj.getController(appConstants.appController).gridCustomPaging(this.up('panel'));											
											}
										 }									 
									 }
								 }
							}
					}
				});
			}
			mainColArray.push({ 
				header: mainHeaderCol,
				dataIndex: key,
				flex:1,
				sortable: true,
				columns:subColArray,
			})
			
		}
		else
		{
			var c=0;
			if(sortIndex==count)
			{
				mainIndex=f;
				subIndex=null;
			}
			var dataind=key+(count++);
			fieldsToStore.push({name: dataind});
			var setAlign='left';			
			if(mainColumn != undefined && mainColumn.indexOf("$") != -1)
			{
				var colAlign=mainColumn.substring(mainColumn.indexOf("$")+1);		
				if(colAlign != undefined && colAlign.trim()=='center')
				{
					setAlign='center';
				}
			}
			mainColArray.push({ 
				header: mainHeaderCol,
				sortable: true,
				align:setAlign,
				dataIndex: dataind,
				flex:1,
				customWidth:customWidth,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					if(value.indexOf('~DDLink')>-1)
					{
						var text = value.substring( 0, value.indexOf('~DDLink') );
						var url = value.substring( value.indexOf('~DDLink') + 7 );
						if(!isNaN(text) && !isNaN(parseFloat(text)) && col != 0)
							value = '<span class="decimal-align"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a></span>';
						else
							value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a>';
						return value;
					}
					if(value.indexOf('~DD')>-1)
					{
						var text = value.substring( 0, value.indexOf('~DD') );
						var url = value.substring( value.indexOf('~DD') + 3 );
						if(!isNaN(text) && !isNaN(parseFloat(text)))
						{
							//value = '<span class="decimal-align"><a class="anchorLink" href="javascript:void(0);" onClick="javascript:window.open(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a></span>';
							value='<span class="decimal-align"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');" >'+text+'</a></span>';
						}
						else
						{
							value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');" >'+text+'</a>';
						}
						return value;
					}					
					var delegateClass='';			
					if(gridView.ownerCt.columns[col] != undefined && gridView.ownerCt.columns[col].dataIndex.indexOf('Components')==0 && enableCursorTd)
					{
						metaData.style = 'cursor: pointer;';//..
						delegateClass='forCursorSymbol';
					}
					if(value.indexOf("%")>-1)
					{
						metaData.tdAttr = '';
					}
					else if(value.indexOf(' week')>-1)
					{
						value = me.getDataForWeekGroup(value);
						metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
					}
					else
					{
						metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
					}
						var symbolClass='';
						var enableSymbol='no';
						var colourr='';
						if(enableSymbolImageTd)
						{
							if(value.indexOf("@@") != -1)
							{
								symbolClass=value.substring(value.indexOf("@@")+2);
								value=value.substring(0,value.indexOf("@@"));
								enableSymbol='yes';
							}
							if(value.indexOf("$$")!=-1)
							{
								colourr=value.substring(value.indexOf("$$")+2);
								value=value.substring(0,value.indexOf("$$"));
							}
						}
						var strDecimal='';
						var str='';
						if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
						{
							if(value!=null && value.indexOf(".")>-1)
							{
								strDecimal = value.substring(value.indexOf("."));
								str = value.substring(0,value.indexOf("."));
								//value='<div class="state_transition_GOOD"><span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span></div>';
								if(enableSymbol=='yes' && enableSymbolImageTd)
								{
									//value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span><span class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
									value='<table><tr><td class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;</td><td><span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span></td></tr></table>';
								}
								else if(enableSymbolImageTd)
									value='<span class="decimal-align" style="background:'+colourr+'">'+str+'</span><span class="decimal-align2" style="background:'+colourr+'">'+strDecimal+'</span>';
								else
									value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
							}
							else
							{
								if(enableSymbol=='yes' && enableSymbolImageTd)
								{
									//value='<span class="decimal-align">'+value+'</span><span class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
									value='<table><tr><td class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;</td><td><span class="decimal-align">'+value+'</span></td></tr></table>';
								}
								else if(enableSymbolImageTd)
									value='<span class="decimal-align" style="background:'+colourr+'">'+value+'</span>';
								else
									value='<span class="decimal-align">'+value+'</span>';
							}
					}
					if(enableCursorTd)
						value='<div class="'+delegateClass+'">'+value+'</div>';
					return value;
				},
				doSort: function(state) {
					var ds = this.up('grid').store;
					var field = this.getSortParam();
					ds.sort({
						property: field,
						direction: state,
						//sorters: [{ property: 'Trgt_host', direction : 'ASC' }],//
						//sorters: { property: field, direction : state },//
						sorterFn: function(v1, v2){
							v1 = v1.get(field);
							v2 = v2.get(field);
								if(v1.indexOf("~DD") != -1)
									v1=v1.substring(0,v1.indexOf("~DD"));
								if(v2.indexOf("~DD") != -1)
									v2=v2.substring(0,v2.indexOf("~DD"));
								if(!isNaN(v1) && !isNaN(v2))
							{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10); 
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
							}
									else if(!isNaN(v1) && !isNaN(v2))
							{
										v1=v1;
										v2=v2;
									}
									else
									{
								v1= isNaN(v1) ? 0 : v1;

								v2= isNaN(v2) ? 0 : v2;
										//v1=v1.toLowerCase();
										//v2=v2.toLowerCase();
							}
								}
								else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
							{
									v2=new Date(v2).getTime(); 
									v1=new Date(v1).getTime(); 
							}
								// transform v1 and v2 here
							return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
						}
					});
					},
					listeners: 
					{
						 headerclick: function(header, column, e, t,eOpts)
						 {
							var sortCombo=Ext.getCmp('er_sortingColumn');
							if(sortCombo != undefined)
							{
								var selectedHeader=column.text;
								 var headerClickRequest=true;
								 if(wildcardSearch)
								 {
									var wildCardSearch=Ext.getCmp('wildcardSearch').getValue()
									if(wildCardSearch != undefined && wildCardSearch.trim().length>0 && wildCardSearch!='*')
										headerClickRequest=false;
								 }	
								if(!Ext.isEmpty(sortCombo.getStore()) && !Ext.isEmpty(sortCombo) && headerClickRequest)
								{
									var getValueOfSelectedHeader = sortCombo.getStore().findExact('displayField', selectedHeader, 0);
									if (getValueOfSelectedHeader != undefined && getValueOfSelectedHeader != -1)
									{
										var getModel = sortCombo.getStore().getAt(getValueOfSelectedHeader);
										var getFirstValueField = getModel.get('valueField');
										if(sortCombo.getValue() != undefined && sortCombo.getValue() != getFirstValueField)
										{
											 sortCombo.setValue(getFirstValueField);						
											
											if(!keepResult)
											{
												appConstants.totalRec=0;
												appConstants.currentPage=1;
											}
											Ext.getCmp('main').show();
											appConstants.appObj.getController(appConstants.appController).gridCustomPaging(this.up('panel'));											
											c++;
										}
									}
								}
							}
						}
					}
			});
		}
		f++;
	}
	var tbar='';
	if(appConstants.isSoringColEnable && appConstants.gridMultiSortEnable != undefined && appConstants.gridMultiSortEnable == 'yes')
	{
		tbar=Ext.create('Ext.toolbar.Toolbar',{
			items:[
				{
					xtype: 'tbtext',
					text: 'Multi Soring :  ',
					reorderable: false
				},
				{
					xtype:'button',
					id:'multisortNew',
					cls:'iconMoreOptions',
					listeners:{
						afterrender:function(){
							Ext.create("Ext.tip.ToolTip",{
								target: this.id,
								anchor: "top",
								cls: "yellowTip",
								trackMouse: true,
								html:'Multi Sort'	
							});
						},
						click:function()
						{
							//alert("==multisort column");
							var primayCol=Ext.getCmp('er_sortingColumn');
							var secondCol=Ext.getCmp('er_secondaryColSort');
							var allColumnArray=[];
							if(appConstants.builderJson.combo != undefined)
							{
								var allColumnsAry=appConstants.builderJson.combo.sortingColumnCombo;
								if(allColumnsAry != undefined)
								{
									for(var c=0;c<allColumnsAry.length;c++)
									{
										var eachColObj=allColumnsAry[c];
										//alert("==eachObj==>>"+JSON.stringify(eachColObj));
										var displyField=eachColObj.displayField;
										var valueField=eachColObj.valueField;									
										var checkedField=false;
										if(valueField == primayCol.getValue() || valueField == secondCol.getValue())
											checkedField=true;	
										allColumnArray.push(
											{
												xtype:'checkbox',
												cls:'checkbt',
												boxLabel:displyField,
												name:displyField,
												inputValue:valueField,
												checked:checkedField,
											}
										);
									}
								}
							}
							Ext.create('Ext.window.Window',{
									title:'Multi Sorting Column',
									width:400,
									border:false,
									frame:false,
									modal: true,
									ghost: false,
									height:280,
									listeners: {
										show: function (win) {										
											if (this.modal) {									
												var dom = Ext.dom.Query.select('.x-mask');
												for (var y = 0; y < dom.length; y++) {
													var el = Ext.fly(dom[y]);
													el.addCls('windowModal');
												}
											}
										},
										hide: function (win) {									
											var dom = Ext.dom.Query.select('.x-mask');
											if (this.modal) {
												var el = Ext.fly(dom[0]);
												el.removeCls('windowModal');
											}
										},
										afterrender: function () {
											Ext.EventManager.onWindowResize(function () {
												var me = this;
												me.center();
											}, this);
										}
								},
								items:[
									{
										xtype:'panel',						
										autoScroll:true,
										scroll:true,		
										height:270,									
										autoHeight: true,
										style:{'overflow-x':'hidden'},
										id:'chekboxAllCol',
										items:[
											{
												xtype:'checkboxgroup',
												columns:2,											
												vertical:true,
												width:'100%',
												margin:'10px',
												id:'multiColchkboxgroup',
												items:allColumnArray,
												listeners:{											
													change:function(ckbox,checked)
													{												
														if(Object.keys(checked).length > 2)
														{
															var i=1;														
															for (var property in checked) {
																if (checked.hasOwnProperty(property)) {
																	// do stuff
																	var myobj=Ext.ComponentQuery.query('[name='+property+']');
																	if(i==1)
																	{
																		var selID=myobj[0].id;
																		var selObj=Ext.getCmp(selID);																
																		selObj.setValue(false);
																	}
																	i++;
																}
															}
														}
													}												
												}
											}
										]
									}
								],
								buttonAlign:'center',
								buttons:[
									{
										text:'Update',
										id:'multisortSelectId',
										cls:'quickMenuWhiteButton',
										handler: function(buttonObj)
										{
											var selectedCols=Ext.getCmp('multiColchkboxgroup').getChecked();
											var multisort=Ext.getCmp('multisort');
											if(selectedCols.length>1)
											{
												appConstants.gridMultiSortEnable='yes';											
												multisort.setValue(true);
											}
											else
											{
												appConstants.gridMultiSortEnable='no';
												multisort.setValue(false);
											}
											Ext.each(selectedCols,function(obj,index){
												if(index==0)
													primayCol.setValue(obj.getSubmitValue());
												else if(index==1)
													secondCol.setValue(obj.getSubmitValue());
											});
											if(!keepResult)
											{
												appConstants.totalRec=0;
												appConstants.currentPage=1;
											}
											Ext.getCmp('main').show();
											appConstants.appObj.getController(appConstants.appController).gridCustomPaging(tbar.up('panel'));	
											this.up('window').destroy();
										}
									}
								],
							}).show();
						}
					},
				}
			]
		});
	}	
	gridPageSize=temp1;
	var store = Ext.create('Ext.data.ArrayStore', {
		 fields:fieldsToStore,
		 proxy : {
			type : 'pagingmemory',
			reader : {
				type : 'array'
			}
		}, 
		pageSize:gridPageSize,
		sortable: true,
		remoteSort:true,
		autoLoad : true, 
		data : data,
		
	});
	var isPagingHidden=true;
	//vengat
	var forceFitColsCount=8;
	if(gridPanelWidth > 1000)
	{
		var remainingWidth=gridPanelWidth-1000;
		var roundOffValue=Ext.util.Format.round((remainingWidth/100), 0);
		forceFitColsCount=forceFitColsCount+roundOffValue;
	}
	//end
	var forceFit = true;
	if(forceFitColsCount < fieldsToStore.length)
		forceFit=false;
	if(gridPageSize<data.length)
		isPagingHidden=false; 
		if(customPaging)
		{
			isPagingHidden = true;
		}
		if(fromPerBtn)
		{
			activePage = Math.ceil(data.length/gridPageSize);
		}
		var resultArry=[];
		resultArry.push({	
		xtype:'customgrid_builder',
		tbar:tbar,
		store:store,
		columns:mainColArray,
		id:'customgridId'+panelid,
		frame:false,
		padding:0,
		margin:'0 10 10 10',
		autoScroll:true,
		// to enable horizontal scroll
		needtoFixColumn:true,
		popUpData:'noToolTip',
		scroll:true, 
		ui:'newGridPanel',
		layout: {
			type: 'vbox',
			align: 'stretch'
		},
		flex:1,
		border:true,
		//forceFit:forceFit,
		//layout:'fit',
		//align:'stretch',
		sortableColumns: true,
		listeners:
		{			
			sortchange:function(ct, column, e, t, eOpts )
			{
				this.getStore().load();
			},			 
			render:function(obj)
			{
				Ext.defer(function() {
					if(subIndex==null)
					{
						obj.columns[mainIndex].setSortState(sortOrderStatus,true,false);
					}
					else
						obj.columns[mainIndex].items.items[subIndex].setSortState(sortOrderStatus,true,false);
				},100);
			}


		},
		dockedItems:[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				store: store,
				id:'pageingTool'+panelid,
				hidden:isPagingHidden,
				//hidden:true,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No Data to display",
				listeners: {
					change : function(thisd, params)
					{  
						//activePage = params.currentPage;
					}
				}
		}],	
		});
		resultArry.push(
			{
				xtype:'container',
				id:'customPageinationId'+panelid,
				margin:'0 -10 0 -10',
	}
		);
		return {
			xtype:'container',
			id:'containerr'+panelid,
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			flex:1,
			items:resultArry
		};	
	
},
getGrid:function(panelid,chartCollectionVal,title,gridPanelWidth,widgetHeight,enableSymbolImageTd,enableCursorTd,needtoFixColumn)
{

	var fieldsArr=new Array();
	var columnsArr=new Array();
		var sortOrderStatus="DESC";
		if(chartCollectionVal.sortOrderStatus != undefined)
			sortOrderStatus=chartCollectionVal.sortOrderStatus;
		var sortIndex=0;
		if(chartCollectionVal.sortIndex != undefined)
			sortIndex=chartCollectionVal.sortIndex;
		var columns=chartCollectionVal.gridColums;
		var gridColLanguageObj=chartCollectionVal.gridColLanguageObj;
		var data=chartCollectionVal.gridData;
		var customWidthAry = chartCollectionVal.customWidth;
		var gridHeaderWrap = chartCollectionVal.gridHeaderWrap;
		var gridUi='newGridPanel';
		if(gridHeaderWrap != undefined && gridHeaderWrap=='yes')
			gridUi='newGridPanel headerTextWrap';
		gridPageSize=10;
		if(widgetHeight>120)
		{
			// 120 for header footer height and 70 for page nagation height
			//temp1 = widgetHeight-120-75;
			temp1 = widgetHeight-60-75;
			temp1 = temp1/24;
			temp1 = Ext.util.Format.round(temp1, 0);
		}
		gridPageSize=temp1;
		//if(chartCollectionVal.gridPageSize != undefined && chartCollectionVal.gridPageSize != null)
		//	gridPageSize=chartCollectionVal.gridPageSize;
	var columnAlign;
	for (var k in columns)
	{
		var customWidth;
		columnAlign='left';
		if(customWidthAry!=undefined && customWidthAry[k] != undefined && customWidthAry[k]!='')
			customWidth = parseFloat(customWidthAry[k]);
		else
			customWidth='';
		var col=columns[k];
		if (Ext.isEmpty(col))
		{
			col='qwe';
		}
		var headerCol=col;
		if(gridColLanguageObj != undefined && gridColLanguageObj[headerCol] != undefined)
		{
			headerCol=gridColLanguageObj[headerCol];
		}
		var colStyle={};
		if(col != undefined && col.indexOf("$") > -1)//.for table header alignmet(left or center)
		{
			var colAlign=col.substring(col.indexOf("$")+1);
			if(colAlign.indexOf("(") > -1)
			{
				colAlign=colAlign.substring(0,colAlign.indexOf("("));
			}
			var paddingLeft='20px';
			if(colAlign.indexOf("$") > -1)
			{
				paddingLeft=colAlign.substring(colAlign.indexOf("$")+1)
				colAlign=colAlign.substring(0,colAlign.indexOf("$"));
			}
			if(colAlign != undefined && colAlign != null && colAlign.trim() == 'center')
			{
				colStyle['padding-left']=paddingLeft;
				//colStyle['text-align']='center';
				columnAlign='center';
			}
				//colStyle="{'padding-left':'40px'}";
			col=col.substring(0,col.indexOf("$"));
		}
		fieldsArr.push(col);
		if(headerCol != undefined && headerCol.indexOf("(") != -1)
		{
			columnAlign='center';
		}
		if(headerCol != undefined && headerCol.indexOf("~") != -1)
			headerCol=headerCol.substring(0,headerCol.indexOf("~"));
		columnsArr.push({
			header:headerCol,
			align:columnAlign,
			dataIndex:col,
			sortable: true,
			//style:colStyle,
			//width:k==columns.length-1?500:100,
			customWidth:customWidth,// vengat
			flex:1,
			//autoScroll:true,
			//renderer:function(value, meta, record, rowIndex, colIndex, store){
			renderer:function(value, meta, record, rowIndex, colIndex, store,view){
				//if((value.indexOf(".0")>-1 || value.indexOf(".00")>-1))
					//value=Math.round(value); 
				// vengat 
				// toFixed() is doing similar function like round() with decimal point
				//return view.ownerCt.columns[colIndex].getWidth();
				if(value != undefined && value.indexOf('~DDLink')>-1)
				{
					var text = value.substring( 0, value.indexOf('~DDLink') );
					var url = value.substring( value.indexOf('~DDLink') + 7 );
					/*if(!isNaN(text) && !isNaN(parseFloat(text)))
						value = '<span class="decimal-align"><a class="anchorLink" class="anchorLink" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a></span>';
					else*/
						value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url+'\',\'DDWindow\',\'width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable\');" >'+text+'</a>';
					return value;
				}
				if(value != undefined && value.indexOf('~DD')>-1)
				{
					var text = value.substring( 0, value.indexOf('~DD') );
					var url = value.substring( value.indexOf('~DD') + 3 );
					/*if(!isNaN(text) && !isNaN(parseFloat(text)))
						value = '<span class="decimal-align"><a class="anchorLink" class="anchorLink" href="javascript:void(0);" onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');" >'+text+'</a></span>';
					else*/
						value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'\',\'Detail\');" >'+text+'</a>';
					return value;
				}
				var symbolClass='';
				var enableSymbol='no';
				var colourr='';
				if(enableSymbolImageTd)
				{
					if(value.indexOf("@@") != -1)
					{
						symbolClass=value.substring(value.indexOf("@@")+2);
						value=value.substring(0,value.indexOf("@@"));
						enableSymbol='yes';
					}
					if(value.indexOf("$$")!=-1)
					{
						colourr=value.substring(value.indexOf("$$")+2);
						value=value.substring(0,value.indexOf("$$"));
					}
				}
				/*var colourr='green';
				if(value.indexOf("$$")!=-1)
				{
					colourr=value.substring(value.indexOf("$$")+2);
					value=value.substring(0,value.indexOf("$$"));
				}

				if(!isNaN(parseFloat(value)))
					meta.style = 'background:'+colourr+';cursor: pointer;';//..
				else
					meta.style = 'cursor: pointer;';//..*/
				//meta.style = 'cursor: pointer;';//..
				var uname='';
				var anchorLink = '';
				if(enableCursorTd)
					anchorLink = 'anchorLinkDefault';
				if(value != undefined && value.indexOf("$") != -1)
				{
					uname=value.substring(value.lastIndexOf("$")+1);
					value=value.substring(0,value.indexOf("$"));
				}
				var num=value;
				var delegateClass='';
			
		
				
				if(enableCursorTd)
				{
					meta.style = 'cursor: pointer;';//..
					delegateClass='forCursorSymbol';
				}
				if(num.indexOf("%")>-1 && num.indexOf("~")>-1)
				{
					var valueAry=num.split('~');
					var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
					barStr += '<tr>';
					barStr += '<td align="left" width="100%" height="8" >';
					barStr += '<table width="' + valueAry[2] + '" height="8"  cellpadding="0" cellspacing="0" border="0">';
					barStr += '<tr>';
					barStr += '<td class="reporterProgressBar" width="100%" style="background:'+valueAry[1]+'"> </td>';
					barStr += '</tr>';
					barStr += '</table>';
					barStr += '</td>';
					barStr += '</tr>';
					barStr += '</table>';
					num = "<table width='100%' cellpadding='0' cellspacing='0' ><tr><td style='width:100px;padding:6px' class='font_normal11'><span class='"+anchorLink+"'>" + valueAry[0]+ "</span></td><td style='padding:3px'>" + barStr + "</td></tr></table>";
					//num='<div style="background:'+valueAry[1]+' ;width:'+valueAry[2]+'!important">'+valueAry[0]+' </div>';
					meta.tdAttr = valueAry[0];
					meta.style="padding:2px 10px 2px 10px"; 
				}
				else
				{
					meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
				}
				
				/*if(!isNaN(value) && !isNaN(parseFloat(value))&& value.indexOf("%")==-1)
				{
					if(value!=null && value.indexOf(".")>-1)
					{
						strDecimal = value.substring(value.indexOf("."));
						str = value.substring(0,value.indexOf("."));
						if(enableSymbol=='yes' && enableSymbolImageTd)
							num='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span><span class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
						else if(enableSymbolImageTd)
							num='<span class="decimal-align" style="background:'+colourr+'">'+str+'</span><span class="decimal-align2" style="background:'+colourr+'">'+strDecimal+'</span>';
						else
							num='<span class="decimal-align"><span class="'+anchorLink+'">'+str+'</span></span><span class="decimal-align2"><span class="'+anchorLink+'">'+strDecimal+'</span></span>';
					}
					else
					{
						if(enableSymbol=='yes' && enableSymbolImageTd)
							num='<span class="decimal-align">'+value+'</span><span class="'+symbolClass+'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
						else if(enableSymbolImageTd)
							num='<span class="decimal-align" style="background:'+colourr+'">'+value+'</span>';
						else
							num='<span class="decimal-align"><span class="'+anchorLink+'">'+value+'</span></span>';
					}
				}
				else if(value=='-')
					num='<span class="decimal-align">'+value+'</span>';*/
				if(enableCursorTd)
				{					
					num='<div class="'+delegateClass+'"><span class="'+anchorLink+'">'+num+'</span><span id="myspan" style="width: 0px; display: none;">$'+uname+'</span></div>';
				}
				if(value!=null && (value=='iconUserHighIdleTime16' || value=='noSymbol'))
				{
					if(value=='iconUserHighIdleTime16')
						num='<div class="iconUserHighIdleTime16">&nbsp;&nbsp;&nbsp;</div>';
					else
						num='<div class="">&nbsp;&nbsp;&nbsp;</div>';
					meta.tdCls="iconColumn";

				}
				return  num;
			},
				doSort: function(state) 
				{
				var ds = this.up('grid').store;
				var field = this.getSortParam();
				ds.sort({
					property: field,
					direction: state,
					sorterFn: function(v1, v2){
						v1 = v1.get(field);
						v2 = v2.get(field);	
						v1=v1.indexOf("$dateLongSort$") != -1?v1.substring(v1.indexOf("$dateLongSort$")+"$dateLongSort$".length,v1.lastIndexOf("$")):v1.indexOf("~") != -1 ? v1.substring(0,v1.indexOf("~")) : v1.indexOf("$") != -1 ? v1.substring(0,v1.indexOf("$")) :v1;
						v2=v2.indexOf("$dateLongSort$") != -1?v2.substring(v2.indexOf("$dateLongSort$")+"$dateLongSort$".length,v2.lastIndexOf("$")):v2.indexOf("~") != -1 ? v2.substring(0,v2.indexOf("~")) : v2.indexOf("$") != -1 ? v2.substring(0,v2.indexOf("$")) :v2;
						if(!isNaN(v1) && !isNaN(v2))
						{
							v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);

							v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
								if (state=='ASC')
								{
									v1= isNaN(v1) ? 999999 : v1;
									v2= isNaN(v2) ? 999999 : v2;
						}
								else if(!isNaN(v1) && !isNaN(v2))
								{
									v1=v1;
									v2=v2;
								}
								else
								{
									v1= isNaN(v1) ? 0 : v1;
									v2= isNaN(v2) ? 0 : v2;									
								}
							}
							else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
							{
								v2=new Date(v2).getTime(); 
								v1=new Date(v1).getTime(); 
							}
						return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
					}
				});
			},
		});
	}

		//gridPageSize=5;
	var store = Ext.create('Ext.data.ArrayStore', {
		fields:fieldsArr,
		proxy : {
			type : 'pagingmemory',
			reader : {
				type : 'array'
			}
		},
		pageSize:gridPageSize,
		remoteSort: true,
		sortable: true,
		autoLoad : true,
		data : data,
	});
	//var activePage=1;
	var isPagingHidden=true;
	var forceFitColsCount=8;
	if(gridPanelWidth > 1000)
				{
		var remainingWidth=gridPanelWidth-1000;
		var roundOffValue=Ext.util.Format.round((remainingWidth/100), 0);
		forceFitColsCount=forceFitColsCount+roundOffValue;
				}
	var forceFit = true;
	if(forceFitColsCount < fieldsArr.length)
		forceFit=false;
	if(gridPageSize<data.length)
		isPagingHidden=false;
		if(customPaging)
		{
			isPagingHidden = true;
			//customgridId='customgridId';
		}
		if(fromPerBtn)
		{
			activePage = Math.ceil(data.length/gridPageSize);
		}
		var resultArry=[];
		resultArry.push({	
		xtype:'customgrid_builder',
		columns:columnsArr,
		store:store,
		frame:false,
		autoScroll:true,		
		//needtoFixColumn:needtoFixColumn,		
		needtoFixColumn:true,		
		autoScroll:true, 
		popUpData:'noToolTip',
		padding:0,
		margin:'0 10 10 10',
		//cls:'newGridSkin horizontal-scroll',
		ui:gridUi,
		scroll:true,
		id:'customgridId'+panelid,
		border:true,
		//style:{'border':'1px solid inherit'},
		//forceFit:forceFit,
		layout:'fit',
	/*	layout: {
			type: 'vbox',
			align: 'stretch'
		},
		flex:1,*/
		align:'stretch',
		sortableColumns: true,			
		listeners:{
			render:function(obj){
				Ext.defer(function()
				{
			for(var i in columnsArr)
			{
				//obj.columns[sortIndex].setSortState("DESC",true,false);
					obj.columns[sortIndex].setSortState(sortOrderStatus,true,false);
					}
				},100);
			},					
		},
		dockedItems:[{
			xtype:'pagingtoolbar',
			cls:'newPagination',
			dock: 'bottom',
			displayInfo: true,
			store: store,
			id:'pageingTool'+panelid,
			hidden:isPagingHidden,
				//hidden:true,
			displayInfo: true,
		//	displayMsg: 'Displaying topics {0} - {1} of {2}',
			displayMsg: 'Total Records : {2}',
			emptyMsg: "No Data to display",
			listeners: {
				change : function(thisd, params)
				{
						//activePage = params.currentPage;
				},
				afterrender: function() {
					this.down('#refresh').hide();
				}
			}
		}],
		});
				
		resultArry.push({
				xtype:'container',
				id:'customPageinationId'+panelid,
				//padding:'10px',
			//	margin:'5 -10 0 -10',
				margin:'0 -10 0 -10',
			}
		);
		return {
			xtype:'container',
			
		/*	layout : {
					type : 'vbox',
					align:'stretch'
				},
				flex:1,*/
			items:resultArry
		};	
},
getNoMeasure:function()
{
	return {
				xtype:'container',
				cls:'containerShadow',
				margin:10,
		html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
	}
},
getNoMeasureWithoutBorder:function()
{
	return {
		xtype:'container',
		//cls:'containerShadow',
		margin:10,
		html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
	}
},
getNoMeasureWithoutBorderNew:function()
{
	return {
		xtype:'container',
		//cls:'containerShadow',
		//margin:'90 0 0 400',
		margin:10,
		html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
			}
},
getMessageBox:function(title,msg)
{
	 Ext.MessageBox.show({
			title: title,
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
	});	
	return false;
 },
loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectContainerId,isSetLabel)
{
	 var component = Ext.ComponentManager.get(comboId);  
	 if(parentJsonProperty.combo!=undefined)
	 {
	 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
	 {	
	
		 var rawData = parentJsonProperty.combo[comboProperty];	
			if(comboId=='er_component')
			{
			appConstants.compRawData=rawData; //..for component search
		 }
			if(comboId=='er_info')
			{
			appConstants.infoRawData=rawData; //.. for info search
		 }
			if(comboId=='er_mutiSelComp')
			{
				appConstants.compTypeRawData=rawData; //.. for info search
		 }
		 if(component!= undefined && rawData!= undefined)
			component.getStore().loadRawData(rawData);
		
		if(parentJsonProperty.selectedFields != undefined && parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty) && parentJsonProperty.selectedFields[comboSelectedProperty] != null)
		 {
				component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
		 }
		 else
		 {
			component.setValue(rawData[0].valueField);
		 }

		 if (isSetLabel)
		 {
			 if(parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
			 {
				if(!isMultiSelect)
					component.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
				else
					Ext.ComponentManager.get(multiSelectContainerId).setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
			 }
		 }

		if(!isMultiSelect)
		{  	
			if(component.isHidden() &&( comboId!="er_showBy"&& comboId!="er_test"&& comboId!="er_measure"&& comboId!="er_info"))
				component.show();
		
		}
		else
		{
			var m=Ext.ComponentManager.get(multiSelectContainerId);
			if(m!=undefined && m.isHidden() && multiSelectContainerId!="er_showBy"&& multiSelectContainerId!="er_test"&& multiSelectContainerId!="er_measure"&& multiSelectContainerId!="er_info"&& multiSelectContainerId!="measmultipane" && multiSelectContainerId!="infomultipane")
			m.show();
		}
	 }
	 else
	 {
			if(!isMultiSelect)
			{  
				if(!component.isHidden())
				component.hide();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectContainerId);
				if(m!=undefined && !m.isHidden())
				m.hide();
			}
	 }
	 }
	 if (appConstants.hasOwnProperty('isCustomLayout'))
	 {
		 if (appConstants.isCustomLayout=='yes')
		 {
			 var  pbar=Ext.getCmp('pbarcont');
			 if (!Ext.isEmpty(pbar))
			 {
				 pbar.hide();
			 } 
		 }
	 } 

},
getDataForWeekGroup:function(inVal)
{
	var value=inVal;
	inVal=inVal.substring(0,inVal.indexOf('.'));
	switch(inVal)
	{
		case '01':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Jan-'+value;
			break;
		case '02':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Feb-'+value;
			break;
		case '03':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Mar-'+value;
			break;
		case '04':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Apr-'+value;
			break;
		case '05':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='May-'+value;
			break;
		case '06':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Jun-'+value;
			break;
		case '07':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Jul-'+value;
			break;
		case '08':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Aug-'+value;
			break;
		case '09':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Sep-'+value;
			break;
		case '10':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Oct-'+value;
			break;
		case '11':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Nov-'+value;
			break;
		case '12':
			value=value.substring(value.indexOf('.')+1,value.length);
			value='Dec-'+value;
			break;
	}
	return value;
},
	hideComboField:function ()
	{
		Ext.getCmp("iconReportSelectionHide").hide();
		Ext.getCmp("templateform").hide();
		Ext.getCmp("er_mutiSelComp").hide();
		Ext.getCmp("er_compType").hide();
		Ext.getCmp("compmultipane").hide();
		Ext.getCmp("compTypeMultiPane").hide();
}
});
