Ext.define('ReportBuilder.controller.ReportBuilderController', {
	extend: 'ReportBuilder.controller.BuilderController',
	refs: [
		{selector:'main', ref:'main'},
		{selector:'buildersettings', ref:'buildersettings'},
		{selector:'templateformalias', ref:'templateformalias'},
		{selector:'templateformitemsalias', ref:'templateformitemsalias'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'gridster', ref:'gridster'},
		{selector:'#widgetLayoutPane', ref:'widgetLayoutPane'},
		{selector:'timeline',ref:'timeline'},
	],
	method:appConstants.method,
	reqFromCompChange:'no', 
	init: function () {
		this.control({
			'templateformalias': {
				'render': this.invokeSettings,
				'afterrender': this.onAjaxSuccess
			},
			'templateformalias combo[id=er_option]': {
				'select': this.ajaxQueryMaker
			},
			'templateformalias combo[id=er_site]': {
				'select': this.ajaxQueryMaker
			},
			'templateformalias combo[id=er_compType]': {
				'select': this.ajaxQueryMaker
			},
			'egcomponent multiselectfield[id=er_component]': {
				'change': this.ajaxQueryMaker
			},
			'egcomponenttype multiselectfield[id=er_mutiSelComp]': {
				'change': this.ajaxQueryMaker
			},
			'templateformalias combo[id=er_test]': {
				'select': this.ajaxQueryMaker
			},
			'templateformalias combo[id=er_measure]': {
				'select': this.ajaxQueryMaker
			},
			'templateformalias multiselectfield[id=er_measure]': {
				//'change': this.ajaxQueryMaker//..
			},
			'templateformalias multiselectfield[id=er_groupBy]': {
				'select': this.ajaxQueryMaker
			},
			'templateformalias button[id=submit]': {
				'click': this.beforeSubmit
			},
			'templateformalias button[id=saveReport]': {
				'click': this.goTo
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button': {
				'click': this.saveFile
			},
			'newUtilities > #csvTool > button': {
				'click': this.getCsv
			},
			'newUtilities > #favoriteTool > button':
			{
				'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
				'click':this.saveSchedule
			},
			'newUtilities > #mailTool > button':{
				'click':this.sendMail
			},
			'timeline combo[id=er_timeline]':{
				'select':this.ajaxQueryMaker
			},
			'buildersettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			/* 'buildersettings combo[id="er_excwe"]':{
				 'select': this.excludeWeekendsChange
			},*/
			'buildersettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'buildersettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'templateformitemsalias button[id="panelinsidetoggle"]': {
                'click': this.toggleForm
            },
			'egcomponent button[id="expandSelectorComponent"]':
			{
				'click': this.expandMe
			},'eginfo button[id="expandSelectorInfo"]':
			{
				'click': this.expandMe
			},
			'egcomponent trigger[id="compSearch"]': {
				'change': this.filterMultiselect
			},
			'egcomponenttype trigger[id="compTypeSearch"]': {
				'change': this.filterMultiselect
			},
			'egcomponenttype button[id="expandSelectorCompType"]':
			{
				'click': this.expandMe
			},
			'eginfo trigger[id="infoSearch"]': {
				'change': this.filterMultiselect
			},
		});
	},
	filterMultiselect: function (obj) {
		var compStore=null,compName=null;
		var compId = obj.getId();
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		if(compId=='compSearch'){
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp("er_component"),appConstants.compRawData);
		}
		else if(compId=='infoSearch'){
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp("er_info"),appConstants.infoRawData);
		}
		else if(compId=='compTypeSearch')
		{
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp("er_mutiSelComp"),appConstants.compTypeRawData);
		}
	},
	saveFile: function () {
		if(customPaging || appConstants.blockPdfRelatedOptions == 'yes')
		{
			this.exportDataAlert();
			return '';
		}
		var qryString=this.getQueryString(false);
		var titleDisp=appConstants.tempName;
		if(titleDisp != undefined && titleDisp!=null && (titleDisp=='Site+Traffic+Analysis' || titleDisp=='Site Traffic Analysis'))
		{
			Qstring+="pageWidthProces=1100&";
		}
		qryString = "/final/reporter/ErHtmlToSavePdf.jsp?"+qryString+"&savereport=save&isSubmit=true&drilldownReport=no&titleDisp="+titleDisp;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(qryString);
	},
	bookletQuery: function(obj)
	{
		if(customPaging  || appConstants.blockPdfRelatedOptions == 'yes')
		{
			this.exportDataAlert();
			return '';
		}
		var qryString=this.getQueryString(false);
		qryString += "&savereport=save&titleDisp="+appConstants.tempName;
		return qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		if(customPaging || appConstants.blockPdfRelatedOptions == 'yes')
		{
			this.exportDataAlert();
			return '';
		}
		var bookletquery=this.getQueryString(true)+'&pdfprint=yes&recordInfo='+appConstants.recordInfo+'&titleDisp='+appConstants.tempName;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	getCsv: function(){
		if(customPaging  || appConstants.blockPdfRelatedOptions == 'yes')
		{
			this.exportDataAlert();
			return ;
		}
		var widgetIdInfo='widget';
		var csvInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+this.getQueryString(false)+"&graphIndex=0&widgetIdInfo="+widgetIdInfo+"&option=mainCsv&titleDisp="+appConstants.tempName;
		window.location=csvInfoUrl;
	},
	expandMe:function(btn)
	{
		var idName="";
		var lblId="";
		var id=btn.getItemId();
		if(id=="expandSelectorComponent")
		{
			idName="er_component";
			lblId="compmultipane";
		}
		else if(id=="expandSelectorInfo")
		{
			idName="er_info";
			lblId="infomultipane";
		}
		else if(id=="expandSelectorCompType")
		{
			idName="er_mutiSelComp";
			lblId="compTypeMultiPane";
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp(idName),Ext.getCmp(lblId).fieldLabel,btn);
	},
	toggleForm:function(obj)
	{
		if(obj==undefined ||  !obj.getId()=='iconReportSelectionHide')
		{
			var btn = Ext.getCmp('iconReportSelectionHide');
			btn.removeCls('x-btn-pressed');
			btn.addCls('iconReportSelectionHide');
			btn.pressed==true;
			btn.tip.update('Show');
		}
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('templateFormItms');
		if (ornt.isHidden())
		{
			ornt.show();
			if(appConstants.tempDesc == '')
				Ext.getCmp('selectionDetails').hide();
			else
				Ext.getCmp('templateDesc').hide();
		}
		else
		{
			ornt.hide();
			if(appConstants.tempDesc == '')
			{
				Ext.getCmp('upbutton').show()
				Ext.getCmp('templateDesc').hide();
				Ext.getCmp('selectionDetails').show();
			}
			else
			{
				document.getElementById("tempDescContent").innerHTML=appConstants.tempDesc;
				Ext.getCmp('templateDesc').show();
			}
		}
	},
	reportGenChange:function(){
		Ext.getCmp('resultcontainer').hide();
		this.enableDisableTools(true);
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background' || reportGenType== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
		//prakash
	/* excludeWeekendsChange:function()
	{
		var excWeek=Ext.getCmp('er_excwe');
		var excDays=Ext.getCmp('excludeDays');
		if(excWeek.getValue()=="Yes")
		{
			excDays.update("Excludes Saturday,Sunday");
			excDays.show();
		}
		else
		{
			excDays.hide();
		}
	},*/
	sendMail:function(){
		if(customPaging || appConstants.blockPdfRelatedOptions == 'yes')
		{
			this.exportDataAlert();
			return;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	goTo: function (btn) {
		if(customPaging  || appConstants.blockPdfRelatedOptions == 'yes')
		{
			this.exportDataAlert();
			return;
		}
		appConstants.formButtonId = btn.getId();
		var from_schedule = appConstants.fromScheduleModify;
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}
		else
		{
			this.saveFavorite();
		}
	},
	saveSchedule :function(btn)
	{
		if(appConstants.blockPdfRelatedOptions == 'yes')
		{
			this.exportDataAlert();
			return;
		}
		appConstants.totalRec=0;
		appConstants.currentPage=1;	
		var qryString=this.getQueryString(true);
		qryString = "/final/reporter/ErSaveSchedule.jsp?"+qryString+'&pdfPrint=yes&pdfprint=yes&recordInfo='+appConstants.recordInfo+'&titleDisp='+appConstants.tempName+'&com.eg.CSRF_NONCE='+csrfToken;
		var favorite_id ="";
		if (appConstants.formButtonId=='saveReport')
		{
			qryString+='&showSchWindow=no';
			var urlNw=qryString.substr(0,qryString.indexOf("?"));
			var queryString=qryString.substr(qryString.indexOf("?")+1,qryString.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(qryString);
	},
	saveFavorite :function(btn)
	{
		if(customPaging || appConstants.blockPdfRelatedOptions == 'yes')
		{
			this.exportDataAlert();
			return '';
		}
		var qryString=this.getQueryString(true);
		qryString = "/final/reporter/ErSaveFavorite.jsp?"+qryString+'&pdfPrint=yes&pdfprint=yes&recordInfo='+appConstants.recordInfo+'&deleteTemplate=no&com.eg.CSRF_NONCE='+csrfToken;
		var qryString1 = "/final/servlet/com.eg.ErFavoriteC?"+qryString+'&pdfPrint=yes&pdfprint=yes&recordInfo='+appConstants.recordInfo+'&deleteTemplate=no';
		var favorite_id =appConstants.FavoriteId;	
		if (appConstants.formButtonId=='saveReport')
		{
			//document.location=qryString1+'&showWindow=no'+"&FavoriteId="+favorite_id;
			qryString1+='&showWindow=no'+"&FavoriteId="+favorite_id;
			var urlNw=qryString1.substr(0,qryString1.indexOf("?"));
			var queryString=qryString1.substr(qryString1.indexOf("?")+1,qryString1.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.favouriteWindowFn(qryString);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	printReport :function()
	{
		if(customPaging || appConstants.blockPdfRelatedOptions == 'yes')
		{
			this.exportDataAlert();
			return '';
		}
		var qryString=this.getQueryString(false);
		if(appConstants.isCustomLayout=="yes")
			qryString = "/final/reporter/ErPrintCustomReportBuilder.jsp?"+qryString+'&pdfPrint=yes&pdfprint=yes&titleDisp='+appConstants.tempName;
		else
			qryString = "/final/reporter/ErPrintReportBuilder.jsp?"+qryString+'&pdfPrint=yes&pdfprint=yes&titleDisp='+appConstants.tempName;
		parent.printWindowFn(qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	beforeSubmit:function(obj)
	{
		var me=this;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		appConstants.blockPdfRelatedOptions='no';
		
		if(!keepResult)
		{
			appConstants.totalRec=0;
			appConstants.currentPage=1;
		}
		Ext.getCmp('backgroundresults').hide();
		if(me.validateReportForm())
		{
			var url="/final/reporter/ReportBuilderController.jsp";
			var param;
			param='method=clearSessionData';
			param+='&isCustomLayout='+appConstants.isCustomLayout+'&reportGenType='+reportgen;
			param+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
			param+='&templateName='+appConstants.templateName;
			param+='&fromReportBuilder='+appConstants.fromReportBuilder;
			Ext.Ajax.request({
				url:url,
				params:param,
				success : function(response)
				{
					if(response.responseText.length>0)
					{
						appConstants.perLoaderJson=Ext.decode(response.responseText);
					}
					var comp=Ext.getCmp('resultcontainer');
					if (!Ext.isEmpty(me.getWidgetLayoutPane()))
					{
						me.getWidgetLayoutPane().removeAllWidget();
					}
					comp.removeAll();
					comp.show();
					if (appConstants.isCustomLayout=='yes')
					{
						widgetCount=1;
						var er_searchGroupBy=Ext.getCmp('er_searchGroupBy');
						if(wildcardSearch && wildcardSearchCondition && er_searchGroupBy != undefined && er_searchGroupBy.getValue()!='none')
						{
							Ext.getCmp('reportGeneration').setValue('background');
							var d = new Date();
							var currentTimeMS = d.getTime();
							var tName=appConstants.tempName;
							tName=tName.replace("/"," ");
							Ext.getCmp('bgReportName').show();
							Ext.getCmp('bgReportName').setValue(tName+'_'+currentTimeMS);
							/*var dlg = Ext.MessageBox.prompt('Alert', 'You Can Change The Background Report Title', 
							  function(btn, text){	
								if (btn == 'ok'){
									Ext.getCmp('bgReportName').setValue(text);									
								}
								me.ajaxQueryMaker(obj);
								
							},null,null,Ext.getCmp('bgReportName').getValue()
							);	*/	
							Ext.MessageBox.show({
							   title: 'Alert',
							   msg: 'This Report Generated By Background Report.You Can Change The Background Report Name Below.',
							   width:400,
							 //  buttons: Ext.MessageBox.OKCANCEL,
							   buttons: Ext.MessageBox.OK,
							   icon: 'iconInformation',
							   multiline: true,
                               				   defaultTextHeight:25,
							   fn: function (button,text){
								  if (button == 'ok'){
									Ext.getCmp('bgReportName').setValue(text);									
								}
								me.ajaxQueryMaker(obj);
								
							   },
							   value:Ext.getCmp('bgReportName').getValue(),
							   buttonText: { 
									ok: "OK"
							   }
						   });
						}
						else
						{
							if (reportgen!=null && (reportgen == 'background' || reportgen=='background-csv') )
							{
								if(appConstants.blockPdfRelatedOptions == 'yes')
								{
									this.exportDataAlert();
									return;
								}
								me.ajaxQueryMaker(obj);
							}
							else
							{
								if(appConstants.perLoaderJson.preLoadWidgetInfo!=undefined && appConstants.perLoaderJson.preLoadWidgetInfo!='undefined')
								{
									me.ajaxQueryMaker(obj);
								}
								else
								{
									var i=0.01;
									Ext.getCmp('pbar').updateProgress(i, Math.round(100 * i) + '% completed...');
									var task = new Ext.util.DelayedTask(function(arguments){
									{
										me.ajaxQueryMaker(obj);
									}
									});
									task.delay(20);
								}
							}
						}
					}
					else
					{
						me.ajaxQueryMaker(obj);
					}
				},
			});
		}
	},
	validateReportForm:function()
	{
		var infomultipane = Ext.getCmp("er_info").getValue();

		var compTypeArry=Ext.getCmp(appConstants.erCompType).getValue();
		var webAppArray_2=new Array();
		if(Ext.getCmp("er_webAppCombo") != undefined) //..
		webAppArray_2 = (Ext.getCmp("er_webAppCombo").getValue()).split(",");
		if(compTypeArry.length==0)
		{
			this.getMessageBox('Alert','Please choose Component Type');
			return false;
		}
		if(compTypeArry=='-' || compTypeArry=='-1')
		{
			this.getMessageBox('Alert','Please choose valid Component Type');
			return false;
		}		
		if(Ext.Array.contains(compTypeArry,'All') && compTypeArry.length>1 && appConstants.erCompType == 'er_mutiSelComp')
		{
			this.getMessageBox('Alert','All Components Types and Individual selection cannot be selected simultaneously!');
			return false;
		}
		if(Ext.Array.contains(webAppArray_2,'All') && webAppArray_2.length>1 && appConstants.isMultiInfo == 'infomultipane')
		{
			this.getMessageBox('Alert','All Web Application and Individual selection cannot be selected simultaneously!');
			return false;
		}
		if ((appConstants.isMultiInfo=='true' || appConstants.isMultiInfo == 'infomultipane') && infomultipane=='-1')
		{
			this.getMessageBox('Alert','Not Applicable');
			return false;
		}
		var arr=new Array();
		arr=Ext.getCmp('er_component').getValue();
		if(Ext.Array.contains(arr,'All') && arr.length>1)
		{
			this.getMessageBox('Alert','All Components and Individual selection cannot be selected simultaneously!');
			return false;
		}
		if(arr.length==0)
		{
				this.getMessageBox('Alert','Please choose Components');
				return false;
		}
		if(arr=='-' || arr=='-1')
		{
			this.getMessageBox('Alert','Please choose valid Components');
			return false;
		}
		return true;
	},
	getQueryString:function(needComponent)
	{
		var params='method=submit';
		params+='&er_option='+Ext.getCmp('er_option').getValue();
		var obj=Ext.getCmp('er_site');
		if (!obj.isHidden())
		{
			params+='&er_site='+obj.getValue();

			if (Ext.getCmp('er_option').getValue()=='Zone')
			{
				params+='&er_site='+Ext.getCmp('er_subZone').getValue();
			}
		}

		params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
		if(appConstants.isSoringColEnable)
		{
			params+='&er_sortingColumn='+Ext.getCmp('er_sortingColumn').getValue();
			params+='&er_sortingColumnState='+appConstants.er_sortingColumnState;	
		}
		
		if(wildcardSearch)
		{
			params+='&clientVersionn='+Ext.getCmp('wildcardSearch').getValue();
			if(wildcardSearchCondition)
				params+='&er_searchGroupBy='+Ext.getCmp('er_searchGroupBy').getValue();
		}
		if(appConstants.gridMultiSortEnable != undefined && appConstants.gridMultiSortEnable == 'yes')
		{
			params+='&er_secondaryColSort='+Ext.getCmp('er_secondaryColSort').getValue();
			params+='&er_secondaryColSortState='+appConstants.er_secondaryColSortState;	
			var multisort=Ext.getCmp('multisort');
			params+='&multisort='+multisort.getValue();
		} 
		if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
		{
			params+='&showLegendsEnable='+Ext.getCmp('showLegend').getValue();
		}
		if(needComponent)
		{
			var arr=new Array();
			arr=Ext.getCmp('er_component').getValue();
			for (var key in arr )
			{
				params+='&er_component='+arr[key];
			}
		}
		if(Ext.getCmp('er_headerCombo') != undefined)
		{
			var er_headerCombo=Ext.getCmp('er_headerCombo').getValue();
			params +='&er_headerCombo='+er_headerCombo;
		}
		else
			params +='&er_headerCombo='+appConstants.er_headerCombo;
		params+='&er_test='+Ext.getCmp('er_test').getValue();
		if(appConstants.isMultiMeasureSupport=='yes')
		{
			var arr=new Array();
			arr=Ext.getCmp('er_measure').getValue();
			for (var key in arr )
			{
				var measure=arr[key];
				measure=measure.replace("(","EGOPENBRACE");
				measure=measure.replace(")","EGCLOSEBRACE");
				params+='&er_measure='+measure;
			}
		}
		else
		{
			var measure=Ext.getCmp('er_measure').getValue();
			measure=measure.replace("(","EGOPENBRACE");
			measure=measure.replace(")","EGCLOSEBRACE");
			params+='&er_measure='+measure;
		}
		/*if(fromOverviewReport)
		{
			params+='&fromOverviewReport='+fromOverviewReport;
			params+='&dateInMillisecs='+appConstants.dateInMillisecs;
		}*/
		params +="&serverAggregate="+Ext.getCmp('serverAggregate').getValue();
		params +="&enableEntryNode="+Ext.getCmp('enableEntryNode').getValue();
		if(Ext.getCmp(appConstants.erInfo).getValue() != undefined)
			params+='&er_info='+Ext.getCmp(appConstants.erInfo).getValue();
		params+='&er_timeline='+Ext.getCmp('er_timeline').getValue();
		params+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
		params+='&startdate='+Ext.getCmp('er_stdate').dataArray;
		params+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
		params+='&enddate='+Ext.getCmp('er_enddate').dataArray;
		params+='&er_sthr='+Ext.getCmp('er_sthr').dataArray;
		params+='&starthr='+Ext.getCmp('er_sthr').dataArray;
		params+='&er_endhr='+Ext.getCmp('er_endhr').dataArray;
		params+='&endhr='+Ext.getCmp('er_endhr').dataArray;		
		params+='&timefrom='+Ext.getCmp('timefrom').getValue();
		params+='&timeto='+Ext.getCmp('timeto').getValue();
		params+='&minfrom='+Ext.getCmp('minfrom').getValue();
		params+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		params+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;
		params+='&minto='+Ext.getCmp('minto').getValue();
		params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue();
		params+='&er_excwe='+Ext.getCmp('er_excwe').getValue();
		params+='&er_timeInterval='+Ext.getCmp('er_timeInterval').getValue();
		if(isEnableChartTypeCombo)
			params+='&er_chartType='+Ext.getCmp('er_chartType').getValue();
		if(isEnableUiMeasureCombo)
			params+='&er_uiMeasure='+Ext.getCmp('er_uiMeasure').getValue();
		params+='&pct_idle='+Ext.getCmp('pct_idle').getValue();
		params+='&sorted_col='+Ext.getCmp('groupBy_list').getValue();//.. for sorted measure
		params+='&aggregate_server='+Ext.getCmp('aggregate_server').getValue();
		params+='&infoBy='+Ext.getCmp('infoBy').getValue();//for load evaluator report
		params+='&er_showBy='+Ext.getCmp('er_showBy').getValue();
		params+='&timeline_showBy='+Ext.getCmp('timeline_showBy').getValue();//...
		params+='&bar_showBy='+Ext.getCmp('bar_showBy').getValue();//...
		params+='&dynamicRangesInfo='+this.getDynamicRangesInfo();
		params+='&dynamicColorInfo='+this.getDynamicColorInfo();
		params+='&fromReportBuilder='+appConstants.fromReportBuilder;
		params+="&overAllRecCount="+appConstants.totalRec+"&dataPageNo="+appConstants.currentPage;
		var webAppArray=new Array();
		webAppArray = (Ext.getCmp("er_webAppCombo").getValue()).split(",");
		for(var k=0;webAppArray.length>k;k++)
		{
			params+="&er_webAppCombo="+webAppArray[k];
		}
		params+='&lastInfoAccessFromWeAppCombo='+appConstants.lastInfoAccessFromWeAppCombo;

		if (appConstants.isCustomLayout=='yes')
		{
			params+='&er_top='+Ext.getCmp('er_top').getValue();
		}
		else
		{
			params+='&chartInfo='+appConstants.chartInfo;
			params+='&er_top='+Ext.getCmp('er_top').getValue();
		}
		params+='&isCustomLayout='+appConstants.isCustomLayout;
		if(!Ext.isEmpty(appConstants.builderJson))
		{
			if(!Ext.isEmpty(appConstants.builderJson.hiddenFields))
			{
				for(var key in appConstants.builderJson.hiddenFields)
				{
					var val=appConstants.builderJson.hiddenFields[key];
					if(key=='cmd' && appConstants.formButtonId=='saveReport')
						params+='&'+key+"=client";
					else
						params+='&'+key+"="+val;
				}
			}
		}
		params+='&tempDesc='+appConstants.tempDesc;
		return params;
	},
	enableDisableTools:function(flag)
	{
		Ext.getCmp("bookletTool").setDisabled(flag);
		Ext.getCmp("printTool").setDisabled(flag);
		Ext.getCmp("favoriteTool").setDisabled(flag);
		Ext.getCmp("scheduleTool").setDisabled(flag);
		Ext.getCmp("mailTool").setDisabled(flag);
		Ext.getCmp("saveTool").setDisabled(flag);

		var enableCsv=appConstants.enableCsv;
		if(flag)
			Ext.getCmp("csvTool").setDisabled(flag);
		else if(enableCsv == true || enableCsv == 'true')
		{
			Ext.getCmp("csvTool").setDisabled(false);
		}
		else
			Ext.getCmp("csvTool").setDisabled(true);
	},
	validateMainForm :function()
	{
		var isValid = true;
		if(isSettingsEnabled)
		{
			isValid=this.validateSettings();
		}
		return isValid;
	},
	ajaxQueryMaker:function(obj)
	{
		if(appConstants.isSubmit != undefined && appConstants.isSubmit == 'true')
		{
			return;
		}
		if(appConstants.isDescFilter != undefined && appConstants.isDescFilter == 'no' && obj.getId() != undefined && obj.getId()=='er_component')
		{
			return;
		}
		var me=this;
		this.reqFromCompChange='no';
		if(obj.getId() != undefined && obj.getId() == 'er_timeline' && appConstants.isTimeInterval == 'yes')
		{
			var param='method=timelineChange&er_timeline='+obj.getValue();
			param+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
			param+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
			param+='&er_sthr='+Ext.getCmp('er_sthr').dataArray;
			param+='&er_endhr='+Ext.getCmp('er_endhr').dataArray;
			param+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;	
			Ext.Ajax.request({
				url:'/final/reporter/ReportBuilderController.jsp',
				params:param,
				scope:this,
				method:'POST',
				success:function(response)
				{
					var jsontext=response.responseText;
					var jsonData=Ext.decode(jsontext);
					if(!Ext.isEmpty(jsonData))
					{
						me.loadComboField('er_timeInterval','timeInterValCombo',null,'selectedTimeInterval',jsonData,false,null,false);
					}
				}
			});
			return;
		}		
		if(!isSettingsEnabled)
		{
			this.invokeSettings();
		}
		if(this.validateMainForm())
		{
			var oid=obj.getId();
			var url='/final/reporter/ReportBuilderController.jsp';

			var params;
			if(oid=='er_option')
			{
				appConstants.method='optionchange';
				appConstants.lastInfoAccessFromWeAppCombo='false';
				params='method='+appConstants.method+'&er_option='+Ext.getCmp('er_option').getValue();
				params+='&er_compType=-1';//..opt change...
				params+='&recordInfo='+appConstants.recordInfo+'&templateName='+appConstants.templateName;
				params+='&user_dispName='+appConstants.tempName;
				params+='&fromReportBuilder='+appConstants.fromReportBuilder;

			}
			else if(oid=='er_site')
			{
				appConstants.method='sitechange';
				appConstants.lastInfoAccessFromWeAppCombo='false';
				params='method='+appConstants.method+'&er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+Ext.getCmp('er_site').getValue()+'&er_subZone='+Ext.getCmp('er_subZone').getValue();
					params+='&er_compType=-1';//..opt change...
				params+='&recordInfo='+appConstants.recordInfo+'&templateName='+appConstants.templateName;
				params+='&user_dispName='+appConstants.tempName;
				params+='&fromReportBuilder='+appConstants.fromReportBuilder;
			}
			else if(oid=='er_mutiSelComp' || oid=='er_compType' || oid=='er_component')
			{
				appConstants.method='comptypechange';
				appConstants.lastInfoAccessFromWeAppCombo='false';
				params='method='+appConstants.method;
				params+='&er_option='+Ext.getCmp('er_option').getValue();
				var obj=Ext.getCmp('er_site');
				if (!obj.isHidden())
				{
					params+='&er_site='+obj.getValue();
				}
				params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
				params+='&recordInfo='+appConstants.recordInfo+'&templateName='+appConstants.templateName;
				params+='&user_dispName='+appConstants.tempName;
				params+='&fromReportBuilder='+appConstants.fromReportBuilder;
				if(oid=='er_component')
				{
					this.reqFromCompChange='yes';
					var arr=new Array();
					arr=Ext.getCmp('er_component').getValue();
					for (var key in arr )
					{
						params+='&er_component='+arr[key];
					}
				}
			}
			else if(oid=='er_test')
			{
				appConstants.method='testchange';

				params='method='+appConstants.method;
				params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();

				var arr=new Array();
				arr=Ext.getCmp('er_component').getValue();
				for (var key in arr )
				{
					params+='&er_component='+arr[key];
				}
				params+='&er_test='+Ext.getCmp('er_test').getValue();

			}
			else if(oid=='er_measure')
			{
				appConstants.method='measurechange';

				params='method='+appConstants.method;
				params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();

				params+='&er_test='+Ext.getCmp('er_test').getValue();
				var arr=new Array();
				arr=Ext.getCmp('er_component').getValue();
				for (var key in arr )
				{
					params+='&er_component='+arr[key];
				}
				if(appConstants.isMultiMeasureSupport=='yes')
				{
					arr=new Array();
					arr=Ext.getCmp('er_measure').getValue();
					for (var key in arr )
					{
						var measure=arr[key];
						measure=measure.replace("(","EGOPENBRACE");
						measure=measure.replace(")","EGCLOSEBRACE");
						params+='&er_measure='+measure;
					}
				}
				else
				{
					var measure=Ext.getCmp('er_measure').getValue();
					measure=measure.replace("(","EGOPENBRACE");
					measure=measure.replace(")","EGCLOSEBRACE");
					params+='&er_measure='+measure;
				}
				if (appConstants.isCustomLayout!='yes')
				{
					appConstants.isCustomLayout='no';
				}
				params+='&isCustomLayout='+appConstants.isCustomLayout;
			}
			else if(oid=='submit')
			{
				var reportgen=Ext.getCmp('reportGeneration').getValue();
				appConstants.method='submit';

				params='method='+appConstants.method;
				params+='&er_option='+Ext.getCmp('er_option').getValue();
				var obj=Ext.getCmp('er_site');
				if (!obj.isHidden())
				{
					params+='&er_site='+obj.getValue();

					if (Ext.getCmp('er_option').getValue()=='Zone')
					{
						params+='&er_site='+Ext.getCmp('er_subZone').getValue();
					}
				}
				params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
				if(appConstants.isSoringColEnable)
				{
					params+='&er_sortingColumn='+Ext.getCmp('er_sortingColumn').getValue();
					params+='&er_sortingColumnState='+appConstants.er_sortingColumnState;	
				}
				if(appConstants.gridMultiSortEnable != undefined && appConstants.gridMultiSortEnable == 'yes')
				{
					params+='&er_secondaryColSort='+Ext.getCmp('er_secondaryColSort').getValue();
					params+='&er_secondaryColSortState='+appConstants.er_secondaryColSortState;	
					var multisort=Ext.getCmp('multisort');
					params+='&multisort='+multisort.getValue();
				}
				if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
				{
					params+='&showLegendsEnable='+Ext.getCmp('showLegend').getValue();
				}
				var arr=new Array();
				arr=Ext.getCmp('er_component').getValue();
				for (var key in arr )
				{
					params+='&er_component='+arr[key];
				}

				params+='&er_test='+Ext.getCmp('er_test').getValue();
				if (reportgen==null || (reportgen != null && (reportgen != 'background' || reportgen!= 'background-csv')) )
				{
					params+="&overAllRecCount="+appConstants.totalRec+"&dataPageNo="+appConstants.currentPage;
				}
				if(appConstants.isMultiMeasureSupport=='yes')
				{
					var arr=new Array();
					arr=Ext.getCmp('er_measure').getValue();
					for (var key in arr )
					{
						var measure=arr[key];
						measure=measure.replace("(","EGOPENBRACE");
						measure=measure.replace(")","EGCLOSEBRACE");
						params+='&er_measure='+measure;
					}
				}
				else
				{
					var measure=Ext.getCmp('er_measure').getValue();
					measure=measure.replace("(","EGOPENBRACE");
					measure=measure.replace(")","EGCLOSEBRACE");
					params+='&er_measure='+measure;
				}
				if(Ext.getCmp(appConstants.erInfo).getValue() != undefined)
					params+='&er_info='+Ext.getCmp(appConstants.erInfo).getValue();

				params+='&er_timeline='+Ext.getCmp('er_timeline').getValue();
				params+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
				params+='&startdate='+Ext.getCmp('er_stdate').dataArray;


				params+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
				params+='&enddate='+Ext.getCmp('er_enddate').dataArray;

				params+='&er_sthr='+Ext.getCmp('er_sthr').dataArray;
				params+='&starthr='+Ext.getCmp('er_sthr').dataArray;

				params+='&er_endhr='+Ext.getCmp('er_endhr').dataArray;
				params+='&endhr='+Ext.getCmp('er_endhr').dataArray;

				params+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";

				params+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;

				params+='&timefrom='+Ext.getCmp('timefrom').getValue();
				params+='&timeto='+Ext.getCmp('timeto').getValue();
				params+='&minfrom='+Ext.getCmp('minfrom').getValue();
				params+='&minto='+Ext.getCmp('minto').getValue();
				params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue();
				params+='&er_excwe='+Ext.getCmp('er_excwe').getValue();
				params+='&er_timeInterval='+Ext.getCmp('er_timeInterval').getValue();
				if(isEnableChartTypeCombo)
					params+='&er_chartType='+Ext.getCmp('er_chartType').getValue();
				if(isEnableUiMeasureCombo)
					params+='&er_uiMeasure='+Ext.getCmp('er_uiMeasure').getValue();
				params+='&pct_idle='+Ext.getCmp('pct_idle').getValue();
				params+='&sorted_col='+Ext.getCmp('groupBy_list').getValue();//..for sorted measure
				params+='&aggregate_server='+Ext.getCmp('aggregate_server').getValue();
				params+='&infoBy='+Ext.getCmp('infoBy').getValue();//for load evaluator report
				params+='&er_showBy='+Ext.getCmp('er_showBy').getValue();
				params+='&timeline_showBy='+Ext.getCmp('timeline_showBy').getValue();//...
				params+='&bar_showBy='+Ext.getCmp('bar_showBy').getValue();//...
				params+='&dynamicRangesInfo='+this.getDynamicRangesInfo();
				params+='&dynamicColorInfo='+this.getDynamicColorInfo();

				if (appConstants.isCustomLayout=='yes')
				{
					params+='&er_top='+Ext.getCmp('er_top').getValue();
				}
				else
				{
					params+='&chartInfo='+appConstants.chartInfo;
					params+='&er_top='+Ext.getCmp('er_top').getValue();
				}
				params+='&recordInfo='+appConstants.recordInfo+'&templateName='+appConstants.templateName;
				params+='&user_dispName='+appConstants.tempName;
				params+='&fromReportBuilder='+appConstants.fromReportBuilder;
				if(Ext.getCmp('er_headerCombo') != undefined)
				{
					var er_headerCombo=Ext.getCmp('er_headerCombo').getValue();
					params +='&er_headerCombo='+er_headerCombo;
				}
				else
					params +='&er_headerCombo='+appConstants.er_headerCombo;
				var webAppArray=new Array();
				if(Ext.getCmp("er_webAppCombo") != undefined)
				webAppArray = (Ext.getCmp("er_webAppCombo").getValue()).split(",");
				for(var k=0;webAppArray.length>k;k++)
				{
					params+="&er_webAppCombo="+webAppArray[k];
				}
				params +="&serverAggregate="+Ext.getCmp('serverAggregate').getValue();
				params +="&enableEntryNode="+Ext.getCmp('enableEntryNode').getValue();
				if(wildcardSearch)
				{
					params+='&clientVersionn='+Ext.getCmp('wildcardSearch').getValue();
					if(wildcardSearchCondition)
						params+='&er_searchGroupBy='+Ext.getCmp('er_searchGroupBy').getValue();
				}
				/*if(fromOverviewReport)
				{
					params+='&fromOverviewReport='+fromOverviewReport;
					params+='&dateInMillisecs='+appConstants.dateInMillisecs;
				}*/
			}
			else
			{
				appConstants.method=null;
				return;
			}
			params+='&lastInfoAccessFromWeAppCombo='+appConstants.lastInfoAccessFromWeAppCombo;//..for share Point Site Traffic analysis
			params+='&isCustomLayout='+appConstants.isCustomLayout;
			if(!Ext.isEmpty(appConstants.builderJson))
			{
				if(!Ext.isEmpty(appConstants.builderJson.hiddenFields))
				{
					for(var key in appConstants.builderJson.hiddenFields)
					{
						var val=appConstants.builderJson.hiddenFields[key];
						params+='&'+key+"="+val;
					}
				}
			}
			//vengat
			if(keepResult)
			{
				keepResult = false;
				return params;
			}
			if(Ext.isEmpty(initLdgMask))
			{
				initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
			}
			if (reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv') )
			{
				if(appConstants.blockPdfRelatedOptions == 'yes')
				{
					this.exportDataAlert();
					return;
				}
				url='/final/servlet/com.eg.ErStartBackGroundReportC';
				//var backgroundresultsObj=Ext.getCmp('resultcontainer');
				var backgroundResultObj = Ext.getCmp('backgroundresults');
				var comp=Ext.getCmp('resultcontainer');
				var backgroundHeightSet = (Ext.getCmp('main').body.dom.offsetHeight)-(Ext.getCmp('templateFormItms').body.dom.offsetHeight+34);
				comp.removeAll();
				var bg_reportname=Ext.getCmp('bgReportName').getValue();
				var totalwidget=1;
				if (appConstants.isCustomLayout=='yes')
				{
					var	comptype=Ext.getCmp(appConstants.erCompType).getValue();
					appConstants.widgetList=appConstants.selectedCompTypeWidgets[comptype];
					if(Ext.isEmpty(appConstants.widgetList))
						appConstants.widgetList=appConstants.selectedCompTypeWidgets["all"];
					totalwidget=appConstants.widgetList.length;
				}
				params+='&tempDesc='+appConstants.tempDesc+'&titleDisp='+appConstants.tempName;
				if(reportgen == 'background-csv')
					params+='&SaveFormat=CSV';
				initLdgMask.show();
				Ext.Ajax.request({
					url : url,
					params : params+"&bg_reportname="+encodeURIComponent(bg_reportname)+"&totalwidget="+totalwidget,
					scope : this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						jsonData=jsonData.combo;
						var htmlStr= '';
						var backgroundReportStatus=jsonData.backgroundReportStatus;
						if(!Ext.isEmpty(backgroundReportStatus) && backgroundReportStatus!= 'undefined')
						{
							if(backgroundReportStatus== 'success'){
								var bgroundResponseTxt=jsonData.bgroundResponseTxt;
								var bgroundReportsURL=jsonData.bgroundReportsURL;
								var backgroundAnchor=jsonData.backgroundAnchor;
								//backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+backgroundAnchor+'</a></div></div></center>');
								backgroundResultObj.update('<table border="0px" width="100%" height="'+backgroundHeightSet+'px"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
							}
							else if(backgroundReportStatus== 'duplicate'){
								var bgroundResponseTxt=jsonData.bgroundResponseTxt;
								var bgroundReportsURL=jsonData.bgroundReportsURL;
								var backgroundAnchor=jsonData.backgroundAnchor;
								//backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+backgroundAnchor+'</a></div></div></center>');
								backgroundResultObj.update('<table border="0px" width="100%" height="'+backgroundHeightSet+'px"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
							}
						}else
						{
							backgroundResultObj.update('<span>Error In BackGround Generation</span>');
						}
						backgroundResultObj.show();
						me.enableDisableTools(true);
						initLdgMask.hide();
					},
					Error: function(){
						alert('error in back ground')
					}
				});

			}
			else
			{
				var comp=Ext.getCmp('resultcontainer');
				comp.removeAll();

				initLdgMask.show();
				if (appConstants.isCustomLayout=='yes' && oid=='submit')
				{
					var comptype=Ext.getCmp(appConstants.erCompType).getValue();
					appConstants.widgetList=appConstants.selectedCompTypeWidgets[comptype];
					if(Ext.isEmpty(appConstants.widgetList))
						appConstants.widgetList=appConstants.selectedCompTypeWidgets["all"];

					var beingWatched={};
					if(appConstants.widgetList != undefined)
						beingWatched.widgetCount=appConstants.widgetList.length;

					var me=this;
					var pbar = Ext.getCmp('pbar');
					var i=0;
					widgetCount=1;
					var widgetXPos=0;
					var fullMargin = false;
					var task = new Ext.util.DelayedTask(function(arguments){
						{
							var eachWidget=arguments;
							if(eachWidget.indexOf("$") != -1)
							{
								var xPos=parseInt(eachWidget.substring(eachWidget.indexOf("$")+1));
								eachWidget=eachWidget.substring(0,eachWidget.indexOf("$"));
								widgetXPos = widgetXPos + xPos;
								var yIndex = parseInt(eachWidget.y)
								if((yIndex-1)+xPos==12)
								{
									widgetXPos=0;
									fullMargin = true;
								}
								else
									fullMargin = false;
							}
							me.callAjax(url,params+'&widget='+eachWidget,false,false,fullMargin);
							beingWatched.ajaxCount++;
						}
					});
					var initialTask = new Ext.util.DelayedTask(function(arguments){
						{
							var eachWidget=arguments;							
							if(eachWidget.indexOf("$") != -1)
							{
								var xPos=parseInt(eachWidget.substring(eachWidget.indexOf("$")+1));
								eachWidget=eachWidget.substring(0,eachWidget.indexOf("$"));
								widgetXPos = widgetXPos + xPos;
								var yIndex = parseInt(eachWidget.y)
								if((yIndex-1)+xPos==12)
								{
									widgetXPos=0;
									fullMargin=true;
								}
								else
									fullMargin = false;
							}
							me.callAjax(url,params+'&widget='+eachWidget,false,true,fullMargin);
							beingWatched.ajaxCount++;
						}
					});
					if(appConstants.perLoaderJson.preLoadWidgetInfo!=undefined && appConstants.perLoaderJson.preLoadWidgetInfo!='undefined')
					{
						initLdgMask.hide();
						comp.show();
						var count = 0;
						if(appConstants.perLoaderJson.preLoadWidgetInfo instanceof Array)
						{
							for(var k in appConstants.perLoaderJson.preLoadWidgetInfo)
							{
								var eachWidgetObj = appConstants.perLoaderJson.preLoadWidgetInfo[k];
								if(eachWidgetObj.length > 1)
								{
									var formSave = Ext.create('Ext.form.Panel',{
										layout:'column',
										columnWidth:1.0,
										margin:'0 2 10 0',
										padding:'0 0 0 0',
										closeAction:'destroy',
										//ui:'newPanelWidget',
									});
									var loop = 0;
									for(var widgetInfoObj in eachWidgetObj)
									{
										var eachWidgetData = eachWidgetObj[widgetInfoObj];
										for(var widgetInfo in eachWidgetData)
										{
											var eachWidget = eachWidgetData[widgetInfo];
											var xPos=parseInt(eachWidget.size_x);
											widgetXPos = widgetXPos + xPos;
											var yIndex = parseInt(eachWidget.y)
											if((yIndex-1)+xPos==12)
											{
												widgetXPos=0;
												fullMargin=true;
											}
											else
												fullMargin = false;
											var widgetCountStatus = false;
											if(count==0)
												widgetCountStatus = true;
											count++;
											if(loop==0)											
												this.perLoadWidget(eachWidget,widgetInfo,fullMargin,params,widgetCountStatus,formSave,true);
											else
												this.perLoadWidget(eachWidget,widgetInfo,fullMargin,params,widgetCountStatus,formSave,false);
											loop++;
										}
									}
									comp.add(formSave);
								}
								else
								{
									for(var widgetInfoObj in eachWidgetObj)
									{
										var eachWidgetData = eachWidgetObj[widgetInfoObj];
										for(var widgetInfo in eachWidgetData)
										{
											var eachWidget = eachWidgetData[widgetInfo];
											var xPos=parseInt(eachWidget.size_x);
											widgetXPos = widgetXPos + xPos;
											var yIndex = parseInt(eachWidget.y)
											if((yIndex-1)+xPos==12)
											{
												widgetXPos=0;
												fullMargin=true;
											}
											else
												fullMargin = false;
											var widgetCountStatus = false;
											if(count==0)
												widgetCountStatus = true;
											count++;
											this.perLoadWidget(eachWidget,widgetInfo,fullMargin,params,widgetCountStatus,comp,true);
										}
									}
								}
							}
						}
						else
						{
							
							if(needGridStackUI)
							{
								if (Ext.isEmpty(Ext.getCmp('gridsterstackpanel')))
								{
									Ext.getCmp('resultcontainer').add({xtype:'gridsterstackpanel',columnWidth:1.0});
								}
								Ext.getCmp('resultcontainer').show();
								if (!Ext.isEmpty(Ext.getCmp('gridsterstackpanel')))
								{
									if (!Ext.isEmpty(Ext.getCmp('reportergridstackpanel')))
									{
										Ext.getCmp('reportergridstackpanel')._removeAllWidget();
									}
									Ext.getCmp('gridsterstackpanel').show();
								}
								var gridstackdata = Ext.getCmp('reportergridstackpanel')._serialization();
							}
							for(var widgetInfo in appConstants.perLoaderJson.preLoadWidgetInfo )
							{
								var eachWidget = appConstants.perLoaderJson.preLoadWidgetInfo[widgetInfo];
								var xPos=parseInt(eachWidget.size_x);
								widgetXPos = widgetXPos + xPos;
								var yIndex = parseInt(eachWidget.y)
								if((yIndex-1)+xPos==12)
								{
									widgetXPos=0;
									fullMargin=true;
								}
								else
									fullMargin = false;
								var widgetCountStatus = false;
								if(count==0)
									widgetCountStatus = true;
								count++;
								if(!needGridStackUI)
								{
									this.perLoadWidget(eachWidget,widgetInfo,fullMargin,params,widgetCountStatus,comp,true);
								}
								else
								{
									var noResize = true;
									var wid = {
										x: eachWidget.y-1,
										y: eachWidget.x-1,
										width: eachWidget.size_x,
										height: eachWidget.size_y,
										//fixedHeight:eachWidget.fixedHeight,
										autoPosition: true,
										minWidth: undefined,
										maxWidth: undefined,
										minHeight: undefined,
										widgetType: eachWidget.headerDescription,
										maxHeight: undefined,
										eachWidget:eachWidget,
										params:params,
										widgetCountStatus:widgetCountStatus,
										panelHeaderStatus:true,
										id: widgetInfo+'_panel',
										padding:10,
										widgetInfo: widgetInfo,
										method:appConstants.method,
										noResize: noResize
									}
									Ext.getCmp('reportergridstackpanel').addWidget(wid);
								}							
							}
							Ext.getCmp('resultcontainer').doComponentLayout();
							Ext.getCmp('resultcontainer').doLayout();
						}
						this.enableDisableTools(false);
					}
					else
					{
							Object.defineProperty(beingWatched, 'ajaxCount', {
							get: function()
							{
								return this.value;
							},
							set: function(newValue)
							{
								this.value = newValue;
								i=this.value/beingWatched.widgetCount;
								pbar.updateProgress(i, Math.round(100 * i) + '% completed...');

								if (0==this.value)
								{
									initialTask.delay(0, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);

								}
								else if(beingWatched.widgetCount != this.value)
								{
									task.delay(500, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
								}
								else
								{
									initLdgMask.hide();
									if (comp.items.items.length<=0)
									{

										me.enableDisableTools(true);
									}
									else
									{
										me.enableDisableTools(false);
									}
									comp.doComponentLayout();
									comp.doLayout();
									Ext.getCmp("pbarcont").hide();
									pbar.hide();
								}
							 }
						});
						if (appConstants.widgetList != undefined && appConstants.widgetList.length>0)
						{
							beingWatched.ajaxCount=0;
						}
					}
				}
				else
				{
					this.callAjax(url,params,true,true,true);
				}

			}
		}
	},
	ajaxQueryMaker11:function()
	{
		if(appConstants.fromFavouriteModify=="Yes" || appConstants.fromScheduleModify=="Yes")
			return;
		var oid='';
		if(appConstants.isSubmit!=null && appConstants.isSubmit=='true'){
			oid='submit';
		}
		var url='/final/reporter/ReportBuilderController.jsp';
		var params;
		if(appConstants.isSubmit!=null && appConstants.isSubmit=='true')
		{
			appConstants.method='submit';
			params='method='+appConstants.method;
			params+='&er_option='+Ext.getCmp('er_option').getValue();
			var obj=Ext.getCmp('er_site');
			if (!obj.isHidden())
			{
				params+='&er_site='+obj.getValue();

				if (Ext.getCmp('er_option').getValue()=='Zone')
				{
					params+='&er_site='+Ext.getCmp('er_subZone').getValue();
				}
			}
			if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
				{
					params+='&showLegendsEnable='+Ext.getCmp('showLegend').getValue();
				}

			params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
			if(appConstants.isSoringColEnable)
				params+='&er_sortingColumn='+Ext.getCmp('er_sortingColumn').getValue();
			if(appConstants.gridMultiSortEnable != undefined && appConstants.gridMultiSortEnable == 'yes')
			{
				params+='&er_secondaryColSort='+Ext.getCmp('er_secondaryColSort').getValue();
				params+='&er_secondaryColSortState='+appConstants.er_secondaryColSortState;	
				var multisort=Ext.getCmp('multisort');
				params+='&multisort='+multisort.getValue();
			}
			var arr=new Array();
			arr=Ext.getCmp('er_component').getValue();
			for (var key in arr )
			{
				params+='&er_component='+arr[key];
			}

			params+='&er_test='+Ext.getCmp('er_test').getValue();
			if(appConstants.isMultiMeasureSupport=='yes')
			{
				var arr=new Array();
				arr=Ext.getCmp('er_measure').getValue();
				for (var key in arr )
				{
					var measure=arr[key];
					measure=measure.replace("(","EGOPENBRACE");
					measure=measure.replace(")","EGCLOSEBRACE");
					params+='&er_measure='+measure;
				}
			}
			else
			{
				var measure=Ext.getCmp('er_measure').getValue();
				measure=measure.replace("(","EGOPENBRACE");
				measure=measure.replace(")","EGCLOSEBRACE");
				params+='&er_measure='+measure;
			}
			if(Ext.getCmp(appConstants.erInfo).getValue() != undefined)
				params+='&er_info='+Ext.getCmp(appConstants.erInfo).getValue();

			params+='&er_timeline='+Ext.getCmp('er_timeline').getValue();
			params+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
			params+='&startdate='+Ext.getCmp('er_stdate').dataArray;


			params+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
			params+='&enddate='+Ext.getCmp('er_enddate').dataArray;

			params+='&er_sthr='+Ext.getCmp('er_sthr').dataArray;
			params+='&starthr='+Ext.getCmp('er_sthr').dataArray;

			params+='&er_endhr='+Ext.getCmp('er_endhr').dataArray;
			params+='&endhr='+Ext.getCmp('er_endhr').dataArray;
			params+='&er_sthr='+Ext.getCmp('er_sthr').dataArray;
			params+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
			params+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;
			params+='&timefrom='+Ext.getCmp('timefrom').getValue();
			params+='&timeto='+Ext.getCmp('timeto').getValue();
			params+='&minfrom='+Ext.getCmp('minfrom').getValue();
			params+='&minto='+Ext.getCmp('minto').getValue();
			params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue();
			params+='&er_excwe='+Ext.getCmp('er_excwe').getValue();
			params+='&er_timeInterval='+Ext.getCmp('er_timeInterval').getValue();
			if(isEnableChartTypeCombo)
				params+='&er_chartType='+Ext.getCmp('er_chartType').getValue();
			if(isEnableUiMeasureCombo)
				params+='&er_uiMeasure='+Ext.getCmp('er_uiMeasure').getValue();
			params+='&pct_idle='+Ext.getCmp('pct_idle').getValue();
			params+='&aggregate_server='+Ext.getCmp('aggregate_server').getValue();
			params+='&infoBy='+Ext.getCmp('infoBy').getValue();//for load evaluator report
			params+='&er_showBy='+Ext.getCmp('er_showBy').getValue();
			params+='&timeline_showBy='+Ext.getCmp('timeline_showBy').getValue();
			params+='&bar_showBy='+Ext.getCmp('bar_showBy').getValue();
			params+='&dynamicRangesInfo='+this.getDynamicRangesInfo();
			params+='&dynamicColorInfo='+this.getDynamicColorInfo();
			params+='&sorted_col='+Ext.getCmp('groupBy_list').getValue();
			params+="&overAllRecCount="+appConstants.totalRec+"&dataPageNo="+appConstants.currentPage;

			if (appConstants.isCustomLayout=='yes')
			{
				params+='&er_top='+Ext.getCmp('er_top').getValue();
			}
			else
			{
				params+='&chartInfo='+appConstants.chartInfo;
				params+='&er_top='+Ext.getCmp('er_top').getValue();
			}
			params+='&recordInfo='+appConstants.recordInfo+'&templateName='+appConstants.templateName+'&user_dispName='+appConstants.tempName;
			params+='&fromReportBuilder='+appConstants.fromReportBuilder;
		}
		else
		{
			appConstants.method=null;
			return;
		}
		params+='&isCustomLayout='+appConstants.isCustomLayout;
		if(!Ext.isEmpty(appConstants.builderJson))
		{
			if(!Ext.isEmpty(appConstants.builderJson.hiddenFields))
			{
				for(var key in appConstants.builderJson.hiddenFields)
				{
					var val=appConstants.builderJson.hiddenFields[key];
					params+='&'+key+"="+val;
				}
			}
		}
		var comp=Ext.getCmp('resultcontainer');
		comp.removeAll();
		if(Ext.isEmpty(initLdgMask))
		{
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		}
		initLdgMask.show();
		if (appConstants.isCustomLayout=='yes' && oid=='submit')
		{
			var comptype=Ext.getCmp(appConstants.erCompType).getValue();
			appConstants.widgetList=appConstants.selectedCompTypeWidgets[comptype];
			if(Ext.isEmpty(appConstants.widgetList))
				appConstants.widgetList=appConstants.selectedCompTypeWidgets["all"];
			var beingWatched={};
			beingWatched.widgetCount=appConstants.widgetList.length;
			var me=this;
			var pbar = Ext.getCmp('pbar');
			var i=0;
			widgetCount=1;
			var widgetXPos=0;
			var fullMargin = false;

			var task = new Ext.util.DelayedTask(function(arguments){
				{
					var eachWidget=arguments;							
					if(eachWidget.indexOf("$") != -1)
					{
						var xPos=parseInt(eachWidget.substring(eachWidget.indexOf("$")+1));
						eachWidget=eachWidget.substring(0,eachWidget.indexOf("$"));
						widgetXPos = widgetXPos + xPos;
					var yIndex = parseInt(eachWidget.y)
					if((yIndex-1)+xPos==12)
						{
							widgetXPos=0;
							fullMargin = true;
						}
						else
							fullMargin = false;
					}
					me.callAjax(url,params+'&widget='+eachWidget,false,false,fullMargin);
					beingWatched.ajaxCount++;
				}
			});
			var initialTask = new Ext.util.DelayedTask(function(arguments){
			{
				var eachWidget=arguments;							
				if(eachWidget.indexOf("$") != -1)
				{
					var xPos=parseInt(eachWidget.substring(eachWidget.indexOf("$")+1));
					eachWidget=eachWidget.substring(0,eachWidget.indexOf("$"));
					widgetXPos = widgetXPos + xPos;
					var yIndex = parseInt(eachWidget.y)
					if((yIndex-1)+xPos==12)
					{
						widgetXPos=0;
						fullMargin=true;
					}
					else
						fullMargin = false;
				}
				me.callAjax(url,params+'&widget='+eachWidget,false,true,fullMargin);
					beingWatched.ajaxCount++;
				}
			});


			Object.defineProperty(beingWatched, 'ajaxCount', {
				get: function()
				{
					return this.value;
				},
				set: function(newValue)
				{
					this.value = newValue;
					i=this.value/beingWatched.widgetCount;
					if(pbar != undefined)
						pbar.updateProgress(i, Math.round(100 * i) + '% completed...');

					if (0==this.value)
					{
						initialTask.delay(0, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);

					}
					else if(beingWatched.widgetCount != this.value)
					{
						task.delay(500, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
					}
					else
					{
						initLdgMask.hide();
						if (comp.items.items.length<=0)
						{
							// temp command for Gridster
							me.enableDisableTools(true);
						}else
						{
							me.enableDisableTools(false);
						}
						comp.doComponentLayout();
						comp.doLayout();
						if(Ext.getCmp('pbarcont') != undefined)
							Ext.getCmp("pbarcont").hide();
						if(pbar != undefined)
							pbar.hide();
					}
				 }

			});
			if (appConstants.widgetList.length>0)
			{
				beingWatched.ajaxCount=0;
			}

		}
		else
		{
			comp.removeAll();
			this.callAjax(url,params,true,true,true);
		}
	},
	sleep:function(milliseconds) {
	  var start = new Date().getTime();
	  for (var i = 0; i < 1e7; i++) {
		if ((new Date().getTime() - start) > milliseconds){
		  break;
		}
	  }
	},
	onAjaxSuccess:function(widgetCountStatus,fullMargin)
	{
		Ext.getCmp('moreOptionCloseId').show();
		if(appConstants.isMultiCompType=='true')
		{
			Ext.getCmp('er_compType').hide();
			Ext.getCmp('compTypeMultiPane').show();
			Ext.getCmp('er_mutiSelComp').show();
		}
		else
		{
			Ext.getCmp('compTypeMultiPane').hide();
			Ext.getCmp('er_mutiSelComp').hide();
			Ext.getCmp('er_compType').show();
		}
		if(appConstants.isDescFilter != undefined && appConstants.isDescFilter == 'yes')
		{
			if(appConstants.isMultiInfo=='true')
			{
				Ext.getCmp('er_infoSingleSelect').hide();
				Ext.getCmp('infomultipane').show();
				Ext.getCmp('er_info').show();
			}
			else
			{
				Ext.getCmp('infomultipane').hide();
				Ext.getCmp('er_info').hide();
				Ext.getCmp('er_infoSingleSelect').show();
			}
		}
		if(Ext.isEmpty(initLdgMask))
		{
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		}
		if (appConstants.isCustomLayout=='yes')
		{
			if (appConstants.builderJson.hasOwnProperty("selectedFields"))
			{
				if (appConstants.builderJson.selectedFields.hasOwnProperty("selectedCompTypeWidgets"))
				{
					appConstants.selectedCompTypeWidgets=appConstants.builderJson.selectedFields.selectedCompTypeWidgets;// contains all widgets configured for selected component type
				}
			}
		}
		if (appConstants.method=='init'|| (appConstants.isSubmit!=null && appConstants.isSubmit=='true'))
		{
			var chartInfo='';
			if (appConstants.isCustomLayout != undefined && appConstants.isCustomLayout!='yes')
			{
				chartInfo=JSON.parse(decodeURIComponent (appConstants.chartInfo));
				if(chartInfo["chartType"] == "timeline" || chartInfo["chartType"] == "area")
					Ext.getCmp('showLegend').show();
			}
			if(appConstants.builderJson.isHeaderFooterUpdate!=undefined&&appConstants.builderJson.isHeaderFooterUpdate=='yes')
			{
				return;
			}
			var templateNameDisp = appConstants.tempName;
			if(templateNameDisp.indexOf('.')>-1)
			{
				templateNameDisp = templateNameDisp.substring(templateNameDisp.indexOf('.')+1);
			}
			this.getMain().setTitle('<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold15">'+templateNameDisp+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRename+'"></td></tr></table>');
			this.loadComboField('er_option','analysisByCombo','labelAnalysisByCombo','selectedAnalysisByCombo',appConstants.builderJson,false,null,true);
			this.loadComboField('er_site','siteCombo','labelSiteCombo','selectedSiteCombo',appConstants.builderJson,false,null,true);
			this.loadComboField('er_subZone','subZoneCombo','labelSubZoneCombo','selectedSubZoneCombo',appConstants.builderJson,false,null,true);
		
			if(appConstants.isMultiCompType=='true')
				this.loadComboField(appConstants.erCompType,'componentTypeCombo','labelComponentTypeCombo','selectedComponentTypeCombo',appConstants.builderJson,true,'compTypeMultiPane',true);
			else
				this.loadComboField(appConstants.erCompType,'componentTypeCombo','labelComponentTypeCombo','selectedComponentTypeCombo',appConstants.builderJson,false,null,true);
			if(appConstants.isSoringColEnable)
				this.loadComboField('er_sortingColumn','sortingColumnCombo','labelSortingColumnCombo','selectedSortingColCombo',appConstants.builderJson,false,null,true);
			if(appConstants.gridMultiSortEnable != undefined && appConstants.gridMultiSortEnable == 'yes')
			{
				this.loadComboField('er_secondaryColSort','sortingColumnCombo','labelSecSortingColumnCombo','selectedSecondSortColCombo',appConstants.builderJson,false,null,true);
				Ext.getCmp('er_secondaryColSort').hide();
			}
			this.loadComboField('er_component','componentCombo','labelComponentCombo','selectedComponentCombo',appConstants.builderJson,true,'compmultipane',true);
			this.loadComboField('er_test','testCombo',null,'selectedTestCombo',appConstants.builderJson,false,null,false);
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isMultiInfo=='true')
			{
				var infoStrCombo='infoCombo';
				if(appConstants.lastInfoAccessFromWeAppCombo != undefined && appConstants.lastInfoAccessFromWeAppCombo =='true')
					infoStrCombo='totalCustomInfo';
				this.loadComboField(appConstants.erInfo,infoStrCombo,null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false);
			}
			else
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_timeline','timelineCombo',null,'selectedTimelineCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isTimeInterval=='yes')
				this.loadComboField('er_timeInterval','timeInterValCombo','labelTimeInterValCombo','selectedTimeInterval',appConstants.builderJson,false,null,true);
			if(isEnableChartTypeCombo)
				this.loadComboField('er_chartType','chartTypeCombo','labelChartType','selectedChartType',appConstants.builderJson,false,null,true);
			if(isEnableUiMeasureCombo)
				this.loadComboField('er_uiMeasure','uiMeasureCombo','labelUiMeasure','selectedUiMeasure',appConstants.builderJson,false,null,true);
			if(wildcardSearch)
			{
				if(appConstants.builderJson.selectedFields.selectedClientVersionn != undefined)
				{
					Ext.getCmp('wildcardSearch').setValue(appConstants.builderJson.selectedFields.selectedClientVersionn);
					if(wildcardSearchCondition)
						Ext.getCmp('er_searchGroupBy').setValue(appConstants.builderJson.selectedFields.selectedSearchGroupByVal);
				}
				else
				{
					if(wildcardSearchCondition)
					{
						Ext.getCmp('wildcardSearch').setValue('');
						Ext.getCmp('er_searchGroupBy').setValue('none');
					}
					else
						Ext.getCmp('wildcardSearch').setValue('*');
				}
				if(wildcardSearchCondition)
				{
					if( Ext.getCmp('er_searchGroupBy').getValue()== 'none')
					{
						Ext.getCmp('wildcardSearch').setDisabled(true);
					}
					else
					{
						Ext.getCmp('wildcardSearch').setDisabled(false);
					}
				}
			}
			if(appConstants.builderJson.selectedFields.enableAggreagation=="true")
			{
				Ext.getCmp("aggregate_server").show();
				this.loadComboField('aggregate_server','aggregateServerCombo',null,'selectedAggregateValue',appConstants.builderJson,false,null,false);
			}
			else
				Ext.getCmp("aggregate_server").hide();
			if(appConstants.builderJson.selectedFields.enableInfoBy=="true")
			{
				this.loadComboField('infoBy','infoByCombo',null,'selectedInfoBy',appConstants.builderJson,false,null,false);
			}
			else
			{
				Ext.getCmp("infoBy").hide();
			}
			if(appConstants.builderJson.selectedFields.enableSortedBy==true)
			{
				this.loadComboField('groupBy_list','groupByCombo',null,'selectTableCol',appConstants.builderJson,false,null,false);//.. for getting sort by value
				Ext.getCmp("groupBy_list").show();
			}
			else
				Ext.getCmp("groupBy_list").hide();

			this.loadComboField('er_excwe','excludeWeekendsCombo',null,'selectedExcludeWeekendsCombo',appConstants.builderJson,false,null,false);
			if(appConstants.builderJson.selectedFields['selectedPCTIdleTime'] != undefined)
				Ext.getCmp('pct_idle').setValue(appConstants.builderJson.selectedFields['selectedPCTIdleTime']);
			else
				Ext.getCmp('pct_idle').hide();
			this.loadComboField('er_showBy','showByCombo',null,'selectedShowByCombo',appConstants.builderJson,false,null,false);
			if(appConstants.builderJson.selectedFields.selectedtimeShowByCombo != undefined && appConstants.isCustomLayout!='yes')
			{
				this.loadComboField('timeline_showBy','timelineShowByCombo',null,'selectedtimeShowByCombo',appConstants.builderJson,false,null,false);
				Ext.getCmp("timeline_showBy").show();
			}
			else
				Ext.getCmp("timeline_showBy").hide();

			if(appConstants.builderJson.selectedFields.selectedbarShowByCombo != undefined && appConstants.isCustomLayout!='yes')
			{
				this.loadComboField('bar_showBy','barShowByCombo',null,'selectedbarShowByCombo',appConstants.builderJson,false,null,false);
				Ext.getCmp("bar_showBy").show();
			}
			else
				Ext.getCmp("bar_showBy").hide();

			if((appConstants.isCustomLayout=='no' && chartInfo["enableTopN"]=='yes') || appConstants.isCustomTopN=='yes')
			this.loadComboField('er_top','topCombo',null,'selectedTopCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isCustomLayout=='yes' || chartInfo["enableTopN"]=='no')
				Ext.getCmp("er_top").hide();
			if(appConstants.isCustomTopN=='yes')
				Ext.getCmp("er_top").show();
			if(appConstants.isTimeInterval=='yes')
				Ext.getCmp('er_timeInterval').show();
			else
				Ext.getCmp('er_timeInterval').hide();
			this.loadComboField('reportGeneration','reportGenerationCombo',null,'selectedReportGenerationCombo',appConstants.builderJson,false,null,false);
			if(appConstants.builderJson.combo.webAppCombo != undefined){
				Ext.getCmp('customTextField').show();
				webAppCombo = appConstants.builderJson.combo.webAppCombo;
				Ext.getCmp("er_webAppCombo").setValue(appConstants.builderJson.selectedFields.selectedWebAppCombo);
			}
			if(appConstants.builderJson.combo.displayColourMeasList!=undefined && Object.keys(appConstants.builderJson.combo.displayColourMeasList).length > 0)
			{
				var tolDispMeas=appConstants.builderJson.combo.displayColourMeasList;
				Ext.getCmp('colourSettingsItemsId').collapse();
				Ext.getCmp('colourSettingsItemsId').expand();
				Ext.getCmp('colourSettingsSplitter').show();
				Ext.getCmp('colourSettingsItemsId').show();
				var colourComp=Ext.getCmp('colourSettingsItemsId');
				var fId=0;
				for (var key in tolDispMeas) {
				  if (tolDispMeas.hasOwnProperty(key)) {
					var val=tolDispMeas[key];
					var measureStatusArry=new Array();
					var array_keys=new Array();
					var newVal=new Array();
					newVal=val;
					var showValue='enableImage';
					for(var k in val)
					{
						 if (k=='colorInfo') {
							newVal=val[k];
						 }
						 if(k=='showValue')
							showValue=val[k];
					}
					for (var c=0;c<newVal.length;c++) {
						array_keys.push(newVal[c]);
					}
					var dispName=key;
					measureStatusArry.push({xtype: 'label',text: dispName,value:key});

					for(var v=0;v<array_keys.length;v++)
					{
						val=array_keys[v];
						var measStatus='';
						var measColour='';
						var measVal='';
						var symbolClass='';
						if(val.indexOf('*') != -1)
						{
							measStatus=val.substring(0,val.indexOf('*'));
							measColour=val.substring(val.indexOf('*')+1,val.lastIndexOf('*'));
							measVal=val.substring(val.lastIndexOf('*')+1);
							if(measStatus.indexOf('$') != -1 && showValue=='enableSymbol')
							{
								symbolClass=measStatus.substring(0,measStatus.indexOf('$'));
								measStatus=measStatus.substring(measStatus.indexOf('$')+1);
							}
						}
						var colorCls=measColour;
						var labelWidth=45;
						if(symbolClass != '' && showValue=='enableSymbol')
						{
							colorCls='';
							labelWidth=-5;
							measureStatusArry.push({
								xtype:'image',
								cls:symbolClass,
							});
						}
						measureStatusArry.push({
								fieldLabel: measStatus,
								fieldLabelValue: measColour,
								id:measStatus+fId,
								xtype: 'numberfield',
								allowNegative: false,
								labelAlign: 'right',
								 minValue: 1,
								 hideTrigger: true,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								labelSeparator: '',
								margin: '2px 0px 0px 2px',
								labelWidth: labelWidth,
								cls: 'textbox',

								name: 'upperCritical',
								width: 100,
								style: {
									'background-color':colorCls ,

								},
								value: measVal,
								listeners:
								{
									'render': function(p) {
										var ii=Ext.getCmp(p.id);
									}
								},
						});

						fId++;

					}

					colourComp.add({
						xtype:'fieldcontainer',
						id:key,
						value:key,
						layout:{
							type: 'vbox',
							align:'stretch'
							},
						flex:1,
						defaults:{
							labelSeparator : '',
							labelAlign: 'top',
							margin:'0 5 5 0',
							columnWidth:0.5,
						},
						items:measureStatusArry,
					});

					}
				}

			}


			//create random scroll combo for Range setting start
			if(appConstants.builderJson.combo.dynamicRangeField!=undefined && appConstants.builderJson.combo.dynamicRangeField.length>0)
			{
				Ext.getCmp('rangeSettingsItemsId').collapse();
				Ext.getCmp('rangeSettingsItemsId').expand();
				Ext.getCmp('rangeSettingsSplitter').show();
				Ext.getCmp('rangeSettingsItemsId').show();
				var rangeComp=Ext.getCmp('rangeSettingsItemsId');
				var showOnlyFirstRangeField=false;
				for(var i=0;i<appConstants.builderJson.combo.dynamicRangeField.length;i++)
				{
					var fieldVal=appConstants.builderJson.combo.dynamicRangeField[i];
					if(fieldVal.indexOf("(")>-1)
						fieldVal=fieldVal.substring(0,fieldVal.indexOf("("));
					if(appConstants.templateName != undefined && appConstants.templateName == 'Logon Overview' && i>0)
						showOnlyFirstRangeField=true;
					rangeComp.add({
						xtype:'fieldcontainer',
						id:appConstants.builderJson.combo.dynamicRangeField[i],
						hidden:showOnlyFirstRangeField,
						layout:{
							type: 'column',
							align:'stretch'
							},
						flex:1,
						defaults:{
							labelSeparator : '',
							labelAlign: 'top',
							margin:'0 5 5 0',
							columnWidth:0.5,
						},
						items:[
							{
								xtype:'scrollcombo',
								store: new Ext.data.Store({
									fields: ['displayField', 'valueField'],
									data: appConstants.builderJson.combo.dynamicRangeValue
									}),
								displayField: 'displayField',
								value:appConstants.builderJson.combo.dynamicRangeComboValue[i],
								valueField: 'valueField',
								fieldLabel:fieldVal,
								fieldLabelValue: appConstants.builderJson.combo.dynamicRangeField[i],
								id: 'dynamicRangeCombo_'+i,
								name: 'dynamicRangeCombo_'+i,
								txtFieldId:'disp_MeasureName'+i,
								listeners:
								{
									select:function( field, value, eOpts )
									{
										if(this.getValue()!='None')
											Ext.getCmp(this.txtFieldId).show();
										else
										{
											Ext.getCmp(this.txtFieldId).hide();
											Ext.getCmp(this.txtFieldId).setValue('');
										}
									}
								}
							},
							{
								xtype: 'textfield',
								fieldLabel: 'Range value',
								cls: 'textbox',
								maskRe: /[0-9 .]/,
								width:200,
								value:appConstants.builderJson.combo.dynamicRangeFieldValue[i],
								id: 'disp_MeasureName'+i,
								name:'disp_MeasureName'+i,
							},
						]
					});
				}
			}

			var component = Ext.ComponentManager.get('er_stdate');
			component.setValue(appConstants.builderJson.selectedFields.selectedStartDateDisp);
			component.dataArray =  appConstants.builderJson.selectedFields.selectedStartDateVal;
			component = Ext.ComponentManager.get('er_enddate');
			component.setValue(appConstants.builderJson.selectedFields.selectedEndDateDisp);
			component.dataArray =  appConstants.builderJson.selectedFields.selectedEndDateVal;
			component = Ext.ComponentManager.get('er_sthr');
			component.setValue(appConstants.builderJson.selectedFields.selectedStartHourDisp);
			component.dataArray =  appConstants.builderJson.selectedFields.selectedStartHour
			component = Ext.ComponentManager.get('er_endhr');
			component.setValue(appConstants.builderJson.selectedFields.selectedEndHourDisp);
			component.dataArray =  appConstants.builderJson.selectedFields.selectedEndHour
			Ext.ComponentManager.get('timefrom').setValue(appConstants.builderJson.selectedFields.selectedTimefrom);
			Ext.ComponentManager.get('timeto').setValue(appConstants.builderJson.selectedFields.selectedTimeto);
			Ext.ComponentManager.get('minfrom').setValue(appConstants.builderJson.selectedFields.selectedMinfrom);
			Ext.ComponentManager.get('minto').setValue(appConstants.builderJson.selectedFields.selectedMinto);
			mgr_stmin=appConstants.builderJson.selectedFields.selectedStartMin;
			mgr_enmin=appConstants.builderJson.selectedFields.selectedEndMin;

			if (Ext.isEmpty(appConstants.erUtils))
				appConstants.erUtils = Ext.widget("erutils");
			if(!hideBackButton){
				var backUrl = appConstants.builderJson.combo['ID'];
				var backUrlAry = backUrl.split('&');
				var backUrls = '';
				for(var i in backUrlAry)
				{
					var keyVal = backUrlAry[i];
					if(keyVal.trim().length>0 && keyVal.indexOf('=')>-1)
					{
						if(backUrls.length>0)
						{
							backUrls+='&';
						}
						var hiddenname = keyVal.substring(0,keyVal.indexOf('='));
						var hiddenvalue = keyVal.substring(keyVal.indexOf('=')+1);
						backUrls+=hiddenname+'='+decodeURIComponent(hiddenvalue);
					}
				}
				Ext.getCmp('templateform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: backUrls
				});
			}

		}
		else if(appConstants.method=='optionchange')
		{
			this.loadComboField('er_site','siteCombo','labelSiteCombo','selectedSiteCombo',appConstants.builderJson,false,null,true);
			this.loadComboField('er_subZone','subZoneCombo','labelSubZoneCombo','selectedSubZoneCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_component','componentCombo','labelComponentCombo','selectedComponentCombo',appConstants.builderJson,true,'compmultipane',true);
			this.loadComboField('er_test','testCombo',null,'selectedTestCombo',appConstants.builderJson,false,null,false);
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isMultiCompType=='true')
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,true,'compTypeMultiPane',false);
			else
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isMultiInfo=='true')
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false);
			else
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,false,null,false);
		}
		else if(appConstants.method=='comptypechange')
		{
			if(this.reqFromCompChange=='no')
				this.loadComboField('er_component','componentCombo','labelComponentCombo','selectedComponentCombo',appConstants.builderJson,true,'compmultipane',true);
			this.loadComboField('er_test','testCombo',null,'selectedTestCombo',appConstants.builderJson,false,null,false);
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isMultiInfo=='true')
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false);
			else
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,false,null,false);
			if(appConstants.builderJson.selectedFields.enableInfoBy=="true")
			{
				this.loadComboField('infoBy','infoByCombo',null,'selectedInfoBy',appConstants.builderJson,false,null,false);
			}
			else
			{
				Ext.getCmp("infoBy").hide();
			}
			this.loadComboField('groupBy_list','groupByCombo',null,'',appConstants.builderJson,true,null,false);//.. for getting sort by value
		}
		else if(appConstants.method=='testchange')
		{
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isMultiInfo=='true')
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false);
			else
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,false,null,false);
		}
		else if(appConstants.method=='measurechange')
		{
			if(appConstants.isMultiInfo=='true')
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false);
			else
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,false,null,false);
		}
		else if(appConstants.method=='sitechange')
		{
			this.loadComboField('er_component','componentCombo','labelComponentCombo','selectedComponentCombo',appConstants.builderJson,true,'compmultipane',true);
			this.loadComboField('er_test','testCombo',null,'selectedTestCombo',appConstants.builderJson,false,null,false);
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isMultiCompType=='true')
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,true,'compTypeMultiPane',false);
			else
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isMultiInfo=='true')
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false);
			else
				this.loadComboField(appConstants.erInfo,'infoCombo',null,'selectedInfoCombo',appConstants.builderJson,false,null,false);

		}
		else if(appConstants.method=='submit')
		{

			if (appConstants.isCustomLayout=='yes')
			{
				//this.executeWidgetLayout(widgetCountStatus,fullMargin);
			}
			else
			{
				this.executeSingleLayout(); //.. it is used for load evaluator index report under citrix connection brokering.
			}
		}
		else
		{
		}
		if(appConstants.isSoringColEnable)
		{
			Ext.getCmp('er_sortingColumn').show();
		}
		else
		{
			Ext.getCmp('er_sortingColumn').hide();
			}				

		if(appConstants.isSubmit!=null && appConstants.isSubmit=='true'){
			appConstants.isSubmit='false';
			this.beforeSubmit(Ext.getCmp('submit'));//...vengat for per loading
		}
		initLdgMask.hide();
		if(appConstants.hideInputs=='true')
			this.hideComboField();//..for request for GPU overview template to GPU detail template
		if( Ext.getCmp('showLegend') != undefined){
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
				Ext.getCmp('showLegend').setValue(true);
		}
	},
	executeWidgetLayout:function(widgetCountStatus,fullMargin)
	{
		var isEnableEditor=false;
		if(neeedEditableHeader=='yes')
			isEnableEditor=true;
		var hideNotes = false;
		hideNotes=!isEnableEditor;
		var me=this;
		var comp=Ext.getCmp('resultcontainer');
		if (appConstants.builderJson.data.hasOwnProperty('widgetCollection'))
		{
			if(widgetCountStatus == true)
			{
				Ext.getCmp('templateFormItms').show();
				Ext.getCmp('panelinsidetoggle').show();
				Ext.getCmp('panelinsidetoggle').setDisabled(false);
			}
			var widgetCollection= appConstants.builderJson.data.widgetCollection;
			var needNoMeasure= appConstants.builderJson.needNoMeasure;//..
			if (!Ext.isEmpty(widgetCollection))
			{
				for (var widget in widgetCollection)
				{
					var widgetObject=widgetCollection[widget];
					var testCollection=widgetObject.testCollection;
					var measureObject;
					var widgetArray=new Array();
					var chartCollection=[];
					var chartType='';
					var widgetIdInfo = widgetObject.widgetId+'_detail'
					var drillDownUrl='',csvInfoUrl='',gridInfoUrl='';
					var drillDownUrlFlag=true , csvInfoUrlFlag=true,gridInfoUrlFlag=true;
					var noMeasWidget=false;
					var panelHeader=true;

					gridInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+this.getQueryString(false)+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&pdfPrint=yes&pdfprint=yes';

					csvInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+this.getQueryString(false)+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&option=csv';
					var mainDivWidth=document.getElementById("main").offsetWidth;
					var mainDivHeight=document.getElementById("main").offsetHeight;
					var calculatedBaseDimensionY=mainDivHeight*0.1500;
					var calculatedBaseDimensionX=((mainDivWidth)/12);
					calculatedBaseDimensionX=calculatedBaseDimensionX*widgetObject.size_x;
					var panelHeight=widgetObject.size_y*calculatedBaseDimensionY;
					panelHeight=Ext.util.Format.round(panelHeight, 0);

					var bodyPadding='5 20 0 10';
					var widgetMargin='0 0 10 0';
					if(widgetCount%2==0)
					{
						//widgetMargin='0 0 10 0';
					}
					widgetMargin = "0 10 10 0";
					if(fullMargin)
						widgetMargin = "0 2 10 0";
					else
						widgetMargin = "0 10 10 0";
					var panelLayout='fit';
					widgetCount=widgetCount+1;

					var lblId=  appConstants.templateName+"$~$"+widgetObject.widgetId+"$~$"+"footerDescription";
					var lblIdHeader=  appConstants.templateName+"$~$"+widgetObject.widgetId+"$~$"+"headerDescription";
					var haveMeasuee = false;
					var otherInfo='';

					for (var test in testCollection)
					{
						var testObject=testCollection[test];
						var measureCollection=testObject.measureCollection;
						if(measureCollection != undefined && measureCollection.length > 0)
						{
							for (var measure in measureCollection)
							{
								measureObject=measureCollection[measure];
								if(measureObject.hasOwnProperty('timelineChartCollection'))
								{
									drillDownUrlFlag=false;
									csvInfoUrlFlag=false;
									gridInfoUrlFlag=false;
									chartType='timeline';
									customPaging=false;

									chartCollection = measureObject.timelineChartCollection;
									if(chartCollection != undefined && chartCollection.length > 0)
									{
										if(chartCollection[0].needMaximize != undefined && chartCollection[0].needMaximize == 'no')
											drillDownUrlFlag=true;
										drillDownUrl=timelineurl+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+encodeURIComponent(chartCollection[0].dd_Url);
									}
									else
									{
										continue;
									}
								}
								else if(measureObject.hasOwnProperty('heatMapChartCollection'))
								{
									drillDownUrlFlag=false;
									chartType='heatMap';
									chartTypeCollection='heatMapChartCollection';
									customPaging=false;

									chartCollection = measureObject.heatMapChartCollection;
									if(chartCollection != undefined && chartCollection.length > 0)
									{
										if(chartCollection[0].needMaximize != undefined && chartCollection[0].needMaximize == 'no')
											drillDownUrlFlag=true;
										drillDownUrl=timelineurl+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+encodeURIComponent(chartCollection[0].dd_Url);//..
									}
									else
									{
										continue;
									}

								}
								else if (measureObject.hasOwnProperty('barChartCollection'))
								{
									drillDownUrlFlag=false;
									chartType='bar';
									customPaging=false;
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.barChartCollection;

									if(chartCollection != undefined && chartCollection.length > 0)
									{
										if(chartCollection[0].needMaximize != undefined && chartCollection[0].needMaximize == 'no')
											drillDownUrlFlag=true;
										drillDownUrl=timelineurl+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+encodeURIComponent(chartCollection[0].dd_Url);//..
									}
									else
									{
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('stackedBarChartCollection'))
								{
									drillDownUrlFlag=false;
									chartType='stackedbar';
									customPaging=false;
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.stackedBarChartCollection;
									if(chartCollection != undefined && chartCollection.length > 0)
									{
										if(chartCollection[0].needMaximize != undefined && chartCollection[0].needMaximize == 'no')
											drillDownUrlFlag=true;
										drillDownUrl=timelineurl+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+encodeURIComponent(chartCollection[0].dd_Url);
									}
									else
									{
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('distributedPieChartCollection'))
								{
									chartType='distpie';
									customPaging=false;
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.distributedPieChartCollection;
									if(chartCollection == undefined || chartCollection.length == 0)
									{

										continue;
									}
								}
								else if (measureObject.hasOwnProperty('distributionChartCollection'))
								{
									chartType='pie';
									customPaging=false;
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.distributionChartCollection;
									if(chartCollection == undefined || chartCollection.length == 0)
									{
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('gridCollection'))
								{
									chartType='table';
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.gridCollection;
									customPagingHeight=panelHeight;	
									if(chartCollection == undefined || chartCollection.length == 0)
									{
										continue;
									}
									if(chartCollection != undefined && chartCollection[0] != undefined)
									{
										if(chartCollection[0].gridData != undefined && chartCollection[0].gridData.length > 0)
											panelHeight='';
									}
									otherInfo=chartCollection[0].otherInfo;
									if(otherInfo != undefined)
									{
										var dataPageNo = parseInt(otherInfo['dataPageNo']);// current page no
										var isRangeNeed = otherInfo['isRangeNeed'];
										if(isRangeNeed != 'true' && dataPageNo == 1)
										{
											customPaging =false;
										}
										else
										{
											customPaging =true;
										}
									}
								}
								else if (measureObject.hasOwnProperty('topnCollection'))
								{
									chartType='topn';
									customPaging=false;
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.topnCollection;
									if(chartCollection == undefined || chartCollection.length == 0)
									{
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('digitalCollection'))
								{
									chartType='digital';
									customPaging=false;
									panelHeader=false;
									panelHeight=130;
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.digitalCollection;
									if(chartCollection == undefined || chartCollection.length == 0)
									{
										continue;
									}
								}
								if(chartType=='table'||chartType=='topn')
								{
									bodyPadding='10';
								}
								if(chartType=='digital')
								{
									bodyPadding='0';
								}

								if(chartType=='digital')
								{
									var digitalArry=new Array();
									for(var k in chartCollection)
									{
										var chartCollectionVal = chartCollection[k];
										var dispUnit=chartCollectionVal.unit==undefined?"":chartCollectionVal.unit;
											digitalArry.push({
													xtype:'container',
													align:'center',
													autoSize: true,
													layout: {
														type: 'table',
														columns:1,
														align:'center',
														tableAttrs: {
															style: {
																align:'center',
																margin:'auto auto'
															}
														},
														tdAttrs:{
															style:{
																textAlign:'center'
															}
														}
													},
													defaults: {
														bodyStyle: 'padding:5px',
														align:'center',
													},
													items: [{
														html: '<table align="center"><tr><td align="right" style="padding-right:5px"><div class="'+chartCollectionVal.imageCls+'" ></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold33" >'+chartCollectionVal.value+'<span class="newFont_normal13>'+dispUnit+'</span></td></tr></table>',
														width:'100%',
														style: {
															textAlign:'center',
															width:'50px'
														}
													},
													{
														//html:'<span class="newFont_normal13">'+chartCollectionVal.DisplayName+dispUnit+'</span>',
														html:'<span class="newFont_normal13">'+chartCollectionVal.DisplayName+'</span>',
													}]
									});
													haveMeasuee = true;
									}
									var dataTemp={
												xtype:'container',
												padding:'0 0 0 0',
												margin:0,
												scroll:false,
												autoScroll:true,
												flex:1,
												layout:{
													type:'hbox',
													align:'center'
												},
												defaults:{
													minWidth:180,
													margin:0,
													flex:1,
													layout:{
														type:'column',
														align:'center',
													},
												},
												items:digitalArry,
											};
											widgetArray.push(dataTemp);
											panelHeader=true;
								}
								else
								{
									widgetArray.push(this.loadWidgetData(widgetObject.widgetId+'_panel',chartCollection[0],widgetIdInfo,chartType,calculatedBaseDimensionX,panelHeight-5));
									haveMeasuee = true;
								}
							}
						}
					}
					if(haveMeasuee)
					{
						comp.add({
							xtype:'panel',
							id:widgetObject.widgetId+'_panel',
							closeAction:'destroy',
							ui:'newGraphPanel',
							title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+widgetObject.widgetHeader+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>',
							margin:widgetMargin,
							height:panelHeight,
							scroll:false,
							bodyPadding:bodyPadding,
							layout:panelLayout,
							align:'stretch',
							autoScroll:true,
							overflowX:'hidden',
							overflowY:'auto',
							columnWidth:calculatedBaseDimensionX/mainDivWidth,
							header:{
								hidden:!panelHeader,
							},
							tools:[
								this.addToolBarItems([
									{
										xtype: 'button',
										width:16,
										height:16,
										margin:'0 3 0 3',
										style:{'border':'0px'},
										cls: 'iconCsvWidget',
										hidden:csvInfoUrlFlag,
										handler:function(){
											window.location=csvInfoUrl;
										}
									},{
										xtype: 'button',
										cls:'iconDataWidget',
										style:{'border':'0px'},
										width:16,
										height:16,
										margin:'0 3 0 3',
										hidden:gridInfoUrlFlag,
										handler:function(){
											parent.printWindowFn(gridInfoUrl);
										}
									},
									{
										xtype: 'button',
										width:16,
										height:16,
										margin:'0 0 0 3',
										style:{'border':'0px'},
										cls:'iconMaximize',
										hidden:drillDownUrlFlag,
										handler:function(){
											parent.maximizeWindowLightBox(drillDownUrl);
										}
									}

								])
							],
							dockedItems:[{
								xtype:'toolbar',
								dock:'bottom',
								align:'stretch',
								overCls:'reporterTemplateWidgetToolbarOver',
								layout:'fit',
								hidden:hideNotes,
								cls:'reporterTemplateWidgetToolbar',
								height:42,
								items:[{
									xtype:'container',
									layout: {
										type: 'hbox',
										align: 'middle'
									},
									items:[
										{
											xtype: 'button',
											width:16,
											height:16,
											padding:0,
											margin:'8 4 8 10',
											id: 'widgetDescriptor'+widgetObject.widgetId,
											cls:'iconDescription',
											listeners: {
												afterrender: function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html:'Widget Descriptor'
													});
												}
											}
										},
										{
											xtype: 'label',
											id:lblId,
											text:widgetObject.widgetFooter,
											margin: '5 10 5 5',
											flex:1,
											cls:'handSymbol',
											listeners:{
												afterrender:function(obj){
													obj.el.on('click',this.onEdit,this);
													},
											},
											onEdit: function(event, element,obj)
											{
												var me = this;

												if(!me.editor) {
													me.editor = Ext.create('Ext.Editor', {
														updateEl: true,
														completeOnEnter: true,
														cancelOnEsc: true,
														floating: false,
														alignment: 'tl',
														autoSize: {
															width: 'boundEl', // Width from the field
															height: '21' // Height from the boundEl
														},
														hideEl: false,
														offsets: [0,-2],
														field: {
															xtype: 'textfield',
															cls: 'textbox',
														},
														listeners: {
															complete: {
																fn: function(self, value, startValue, opts) {
																	var url='/final/reporter/ReportBuilderController.jsp';
																	var controller=appConstants.appObj.getController(appConstants.appController);
																	var params='&widgetHeaderFooterInfo='+Ext.encode(value);
																	params+='&method=setWidgetHeaderFooter';
																	params+='&isCustomLayout='+appConstants.isCustomLayout;
																	params+='&templateName='+appConstants.templateName;
																	params+='&idDescription='+lblId;
																	controller.callAjax(url,params,false,true,true);
																},
																scope: me,
															}
														}
													});
												}
												me.editor.startEdit(element);
											}
										},
									]

								}]

							}
							],
							listeners:{
								boxready:function(obj)
								{
									if (!Ext.isEmpty(obj.header))
									{
										var el =Ext.get(obj.header.id+'_hd-textEl');
										if(isEnableEditor)
											Ext.get(obj.header.id).on('click', function(e,target){

											var edtrText=el.dom.innerText;

											var editor = new Ext.Editor({
												width: 150,
												alignment: 'tl',
												floating: false,
												shadow: false,
												updateEl: true,
												completeOnEnter: true,
												cancelOnEsc: true,
												offsets: [0,-3],
												field: {
													xtype: 'textfield',
													cls: 'textbox',
													maxLength:32,
													allowBlank:false,
													enforceMaxLength: true
												},
												listeners: {
													'complete': function (edtr, value, startValue, eOpts) {
														el.dom.innerHTML=value;
														el.dom.innerHTML='<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+value+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>';
														var url='/final/reporter/ReportBuilderController.jsp';
														var controller=appConstants.appObj.getController(appConstants.appController);
														var params='&widgetHeaderFooterInfo='+Ext.encode(value);
														params+='&method=setWidgetHeaderFooter';
														params+='&templateName='+appConstants.templateName;
														params+='&isCustomLayout='+appConstants.isCustomLayout;
														params+='&fromReportBuilder='+appConstants.fromReportBuilder;
														params+='&idDescription='+lblIdHeader;

														controller.callAjax(url,params,false,true,true);
													}
												}
											});
											editor.startEdit(el,edtrText);
										}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
									}
								},
								'afterRender': function(obj)
								{

									if(chartType != undefined && chartType=='table')
									{
										var el = Ext.get(widgetObject.widgetId+'_panel');
										el.on('click', function(event, target, options)
										{

																				
											var compVal=target.textContent;
											if(compVal != undefined && compVal.indexOf("$") != -1)
												compVal=compVal.substring(compVal.indexOf("$")+1);
											var url;
											var params='method=submit';								
											var obj=Ext.getCmp('er_site');
											var gpuTemplate='yes';
											if(appConstants.templateName != undefined && appConstants.templateName == 'GPU Overview')
											{
												url='/final/reporter/ReportBuilder.jsp?';
												params='method=submit&recordInfo='+encodeURIComponent('{"templateName":"GPU Details"}');
											params+='&isSubmit=true';
											if (!obj.isHidden())
											{
												params+='&er_site='+obj.getValue();
													if (Ext.getCmp('er_option').getValue()=='Zone')
													{
														params+='&er_subZone='+Ext.getCmp('er_subZone').getValue();
													}
												}
											}
											else if(appConstants.templateName != undefined && appConstants.templateName == 'User Idle Reports')
											{
												url='/final/reporter/ErThinClientUserReport.jsp?fromMenuBar=true&er_trgttype=User Session Report&';
												params+='&isForceSubmit=true';
												params+='&er_user='+encodeURIComponent(compVal);
												params+='&er_RmDispName='+encodeURIComponent('User Session Details');
												params+='&fromReportBuilder=yes';
												if (!obj.isHidden())
												{
													params+='&select_farm='+obj.getValue();
												if (Ext.getCmp('er_option').getValue()=='Zone')
												{
														params+='&er_subZone='+Ext.getCmp('er_subZone').getValue();
												}
												}	
												gpuTemplate='no';
											}
											params+='&hideInputs=false';
											params+='&er_option='+Ext.getCmp('er_option').getValue();
											params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();

											if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
											{
												params+='&showLegendsEnable='+Ext.getCmp('showLegend').getValue();
											}
											var arr=new Array();
											arr=Ext.getCmp('er_component').getValue();
											for (var key in arr )
											{
												if(gpuTemplate == 'yes')
												{
												if(arr[key].indexOf(compVal) != -1)
												{
													params+='&er_component='+arr[key];
												}
													
												if(arr[key]=='All')
												{
													if(compVal.indexOf(":") != -1)
													{
														params+='&er_component='+compVal+":"+Ext.getCmp(appConstants.erCompType).getValue();
													}
													else
													{
														params+='&er_component='+compVal+":NULL:"+Ext.getCmp(appConstants.erCompType).getValue();
														}
													}
												}
												else if(gpuTemplate == 'no')
												{
													params+='&er_componentserver='+arr[key];
													params+='&select_server1='+arr[key];
												}
											}

											params+='&er_test='+Ext.getCmp('er_test').getValue();
											if(appConstants.isMultiMeasureSupport=='yes')
											{
												var arr=new Array();
												arr=Ext.getCmp('er_measure').getValue();
												for (var key in arr )
												{
													var measure=arr[key];
													measure=measure.replace("(","EGOPENBRACE");
													measure=measure.replace(")","EGCLOSEBRACE");
													params+='&er_measure='+measure;
												}
											}
											else
											{
												var measure=Ext.getCmp('er_measure').getValue();
												measure=measure.replace("(","EGOPENBRACE");
												measure=measure.replace(")","EGCLOSEBRACE");
												params+='&er_measure='+measure;
											}
											if(Ext.getCmp(appConstants.erInfo).getValue() != undefined)
												params+='&er_info='+Ext.getCmp(appConstants.erInfo).getValue();

											params+='&er_timeline='+Ext.getCmp('er_timeline').getValue();
											params+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
											params+='&startdate='+Ext.getCmp('er_stdate').dataArray;


											params+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
											params+='&enddate='+Ext.getCmp('er_enddate').dataArray;

											params+='&er_sthr='+Ext.getCmp('er_sthr').dataArray;
											params+='&starthr='+Ext.getCmp('er_sthr').dataArray;

											params+='&er_endhr='+Ext.getCmp('er_endhr').dataArray;
											params+='&endhr='+Ext.getCmp('er_endhr').dataArray;
											params+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";

											params+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;

											params+='&timefrom='+Ext.getCmp('timefrom').getValue();
											params+='&timeto='+Ext.getCmp('timeto').getValue();
											params+='&minfrom='+Ext.getCmp('minfrom').getValue();
											params+='&minto='+Ext.getCmp('minto').getValue();
											params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue();
											params+='&er_excwe='+Ext.getCmp('er_excwe').getValue();
											params+='&pct_idle='+Ext.getCmp('pct_idle').getValue();
											params+='&sorted_col='+Ext.getCmp('groupBy_list').getValue();//..for sorted measure
											params+='&aggregate_server='+Ext.getCmp('aggregate_server').getValue();
											params+='&er_showBy='+Ext.getCmp('er_showBy').getValue();
											params+='&timeline_showBy='+Ext.getCmp('timeline_showBy').getValue();//...
											params+='&bar_showBy='+Ext.getCmp('bar_showBy').getValue();//...

											if (appConstants.isCustomLayout=='yes')
											{
												params+='&er_top='+Ext.getCmp('er_top').getValue();
											}
											else
											{
												params+='&chartInfo='+appConstants.chartInfo;
												params+='&er_top='+Ext.getCmp('er_top').getValue();
											}
											params+='&fromReportBuilder='+appConstants.fromReportBuilder;
											params+='&enableBack=true';
											linkURL(url+params);
										},
										this,
										{
											delegate: '.forCursorSymbol',
										});
									}

								}
							},
							items:widgetArray,
						});
						if(otherInfo != '' && otherInfo != undefined)
						{
							var customgridObj=Ext.getCmp('customgridId'+widgetObject.widgetId+'_panel');
							if(fromPerBtn)
								customgridObj.getStore().loadPage(activePage);
							this.loadOverAllPageNavigation('pageingTool'+widgetObject.widgetId+'_panel',otherInfo,'customPageinationId'+widgetObject.widgetId+'_panel');			
							fromPerBtn = false;
						}
					}
					else
					{
						if(needNoMeasure == 'no')
							continue;
						if(chartType != undefined && chartType == 'table')
							panelHeight=customPagingHeight;
					
						widgetArray.push({
							xtype:'container',
							margin:-10,
							html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'});
						comp.add({
							xtype:'panel',
							id:widgetObject.widgetId+'_panel',
							closeAction:'destroy',
							ui:'newGraphPanel',
							title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+widgetObject.widgetHeader+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>',
							margin:widgetMargin,
							height:panelHeight,
							scroll:false,
							bodyPadding:bodyPadding,
							layout:'fit',
							align:'stretch',
							columnWidth:calculatedBaseDimensionX/mainDivWidth,
							dockedItems:[{
								xtype:'toolbar',
								dock:'bottom',
								align:'stretch',
								hidden:hideNotes,
								layout:'fit',
								overCls:'reporterTemplateWidgetToolbarOver',
								cls:'reporterTemplateWidgetToolbar',
								height:42,
								items:[{
									xtype:'container',
									layout: {
										type: 'hbox',
										align: 'middle'
									},
									items:[
										{
											xtype: 'button',
											width:16,
											height:16,
											padding:0,
											margin:'8 4 8 10',
											id: 'widgetDescriptor'+widgetObject.widgetId,
											cls:'iconDescription',
											listeners: {
												afterrender: function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html:'Widget Descriptor'
													});
												}
											}
										},
										{
											xtype: 'label',
											id:lblId,
											text:widgetObject.widgetFooter,
											margin: '5 10 5 5',
											flex:1,
											cls:'handSymbol',
											listeners:{
												afterrender:function(obj){
													obj.el.on('click',this.onEdit,this);
													},
											},
											onEdit: function(event, element,obj)
											{
												var me = this;

												if(!me.editor) {
													me.editor = Ext.create('Ext.Editor', {
														updateEl: true,
														completeOnEnter: true,
														cancelOnEsc: true,
														floating: false,
														alignment: 'tl',
														autoSize: {
															width: 'boundEl', // Width from the field
															height: '21' // Height from the boundEl
														},
														hideEl: false,
														offsets: [0,-2],
														field: {
															xtype: 'textfield',
															cls: 'textbox',
														},
														listeners: {
															complete: {
																fn: function(self, value, startValue, opts) {
																	var url='/final/reporter/ReportBuilderController.jsp';
																	var controller=appConstants.appObj.getController(appConstants.appController);
																	var params='&widgetHeaderFooterInfo='+Ext.encode(value);
																	params+='&method=setWidgetHeaderFooter';
																	params+='&isCustomLayout='+appConstants.isCustomLayout;
																	params+='&templateName='+appConstants.templateName;
																	params+='&idDescription='+lblId;
																	controller.callAjax(url,params,false,true,true);
																},
																scope: me,
															}
														}
													});
												}
												me.editor.startEdit(element);
											}
										},
									]

								}]

								}
							],
							listeners:{
								boxready:function(obj)
								{
									if (!Ext.isEmpty(obj.header))
									{
										var el =Ext.get(obj.header.id+'_hd-textEl');
										if(isEnableEditor)
											Ext.get(obj.header.id).on('click', function(e,target){

											var edtrText=el.dom.innerText;

											var editor = new Ext.Editor({
												width: 150,
												alignment: 'tl',
												floating: false,
												shadow: false,
												updateEl: true,
												completeOnEnter: true,
												cancelOnEsc: true,
												offsets: [0,-3],
												field: {
													xtype: 'textfield',
													cls: 'textbox',
													maxLength:32,
													allowBlank:false,
													enforceMaxLength: true
												},
												listeners: {
													'complete': function (edtr, value, startValue, eOpts) {
														el.dom.innerHTML=value;
														el.dom.innerHTML='<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+value+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>';
														var url='/final/reporter/ReportBuilderController.jsp';
														var controller=appConstants.appObj.getController(appConstants.appController);
														var params='&widgetHeaderFooterInfo='+Ext.encode(value);
														params+='&method=setWidgetHeaderFooter';
														params+='&templateName='+appConstants.templateName;
														params+='&isCustomLayout='+appConstants.isCustomLayout;
														params+='&fromReportBuilder='+appConstants.fromReportBuilder;
														params+='&idDescription='+lblIdHeader;

														controller.callAjax(url,params,false,true,true);
													}
												}
											});
											editor.startEdit(el,edtrText);
										}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
									}
								}
							},
							items:widgetArray
						});
					}
				}
				if(widgetCountStatus == true)
				{
					Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.builderJson.selectionDetails);
				}
			}
			else
			{
				if(needNoMeasure != 'no')	
					comp.add(this.getNoMeasure());
			}
		}
		else
		{
			if(needNoMeasure != 'no')	
				comp.add(this.getNoMeasure());
		}
		comp.doLayout();
		comp.doComponentLayout();
	},
	executeWidgetLayout_gridster:function(widgetCountStatus)
	{
		if (Ext.isEmpty(this.getWidgetLayoutPane()))
		{
			this.getMain().add({xtype: 'gridster'});
		}
		if (appConstants.builderJson.data.hasOwnProperty('widgetCollection'))
		{
			var widgetCollection= appConstants.builderJson.data.widgetCollection;
			if (!Ext.isEmpty(widgetCollection))
			{
				for (var widget in widgetCollection)
				{
					var widgetObject=widgetCollection[widget];
					var testCollection=widgetObject.testCollection;
					for (var test in testCollection)
					{
						var testObject=testCollection[test];
						var measureCollection=testObject.measureCollection;
						for (var measure in measureCollection)
						{
							var measureObject=measureCollection[measure];

							Ext.getCmp('widgetLayoutPane').addWidget(widgetObject.widgetHeader,widgetObject.widgetFooter,widgetObject.size_x,widgetObject.size_y,widgetObject.x,widgetObject.y,measureObject,'iconConfigUser',widgetObject.widgetId+'_detail');

						}
					}

				}
			}
		}
		if(widgetCountStatus == true)
		{
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.builderJson.selectionDetails);
		}
	},
	executeSingleLayout:function()
	{
		var isEnableEditor=false;
		if(neeedEditableHeader=='yes')
			isEnableEditor=true;
		var comp=Ext.getCmp('resultcontainer');
		if (!Ext.isEmpty(appConstants.builderJson.data) && appConstants.builderJson.data.hasOwnProperty('measureCollection'))
		{
			comp.removeAll();
			var measureCollection= appConstants.builderJson.data.measureCollection;
			var headerDescription= appConstants.builderJson.data.headerDescription;
			var widgetHeader= appConstants.builderJson.data.widgetHeader;
			if (!Ext.isEmpty(measureCollection))
			{
				var colStatus="testWise";
				for (var measure in measureCollection)
				{
					var measureObject=measureCollection[measure];
					var widgetIdInfo = 'widget';
					var drillDownUrlFlag=true , csvInfoUrlFlag=true,gridInfoUrlFlag=true;
					var chartCollection;
					var chartType='';
					var chartTypeCollection='';
					if(measureObject.hasOwnProperty('timelineChartCollection'))
					{
						drillDownUrlFlag=false;
						csvInfoUrlFlag=false;
						gridInfoUrlFlag=false;
						chartType='timeline';
						chartTypeCollection='timelineChartCollection';

						chartCollection = measureObject.timelineChartCollection;


					}
					else if(measureObject.hasOwnProperty('heatMapChartCollection'))
					{
						drillDownUrlFlag=false;
						chartType='heatMap';
						chartTypeCollection='heatMapChartCollection';

						chartCollection = measureObject.heatMapChartCollection;


					}
					else if (measureObject.hasOwnProperty('barChartCollection'))
					{
						drillDownUrlFlag=false;
						chartType='bar';
						chartTypeCollection='barChartCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.barChartCollection;


					}
					else if (measureObject.hasOwnProperty('stackedBarChartCollection'))
					{
						drillDownUrlFlag=false;
						chartTypeCollection='stackedBarChartCollection';
						chartType='stackedbar';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.stackedBarChartCollection;

					}
					else if (measureObject.hasOwnProperty('distributedPieChartCollection'))
					{
						chartType='distpie';
						chartTypeCollection='distributedPieChartCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.distributedPieChartCollection;
					}
					else if (measureObject.hasOwnProperty('distributionChartCollection'))
					{
						chartType='pie';
						chartTypeCollection='distributionChartCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.distributionChartCollection;
					}
					else if (measureObject.hasOwnProperty('gridCollection'))
					{
						chartType='table';
						chartTypeCollection='gridCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.gridCollection;
					}
					else if (measureObject.hasOwnProperty('topnCollection'))
					{
						chartType='topn';
						chartTypeCollection='topnCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.topnCollection;
					}
					else if (measureObject.hasOwnProperty('digitalCollection'))
					{
						chartType='digital';
						chartTypeCollection='digitalCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.digitalCollection;
					}
					if(!appConstants.needToolOption)
					{
						drillDownUrlFlag=true;
						csvInfoUrlFlag=true;
						gridInfoUrlFlag=true;
					}
					this.enableDisableTools(false);
					if(chartCollection instanceof Array)
					{
						var panelColWidth=1.0;
						if(chartCollection.length>1)
							panelColWidth=0.5;
						widgetCount=1;
						if(!Ext.isEmpty(chartCollection))
						{
							var mainDivWidth=document.getElementById("main").offsetWidth;
							var mainDivHeight=document.getElementById("main").offsetHeight;
							var calculatedBaseDimensionY=mainDivHeight*0.1500;
							var calculatedBaseDimensionX=((mainDivWidth)/12);
							calculatedBaseDimensionX=Ext.util.Format.round(calculatedBaseDimensionX, 0);
							calculatedBaseDimensionX=calculatedBaseDimensionX*12;
							if(chartType=='digital')
							{
								var digitalArry = new Array();
								var digitalCollectionCnt=1;
								for(var k in chartCollection)
								{
									var chartCollectionVal = chartCollection[k];
									var borderVal='solid';
									if(digitalCollectionCnt%5 == 0 || chartCollection.length-1==k)
									{
										borderVal='0px';
									}
									digitalCollectionCnt++;
									var digtalChartHtml='<div style="height:100%;width:100%;display:table"><div style="text-align:center;margin-top:40px;vertical-align:middle;display:table-cell"><h1 style="line-height:90px;font-family:digital-7regular;font-size:70px;font-weight:normal;color:#35c8c2" class="count">'+chartCollectionVal.value+'</h1><div>'+chartCollectionVal.DisplayName+'</div><div>';
									if(chartCollectionVal.unit!=null && chartCollectionVal.unit!='')
									{
										digtalChartHtml=digtalChartHtml+chartCollectionVal.unit+'</div></div></div>';
									}
									else
									{
										digtalChartHtml=digtalChartHtml+'</div></div></div>';
									}
									digitalArry.push({
										xtype:'container',
										align:'center',
										autoSize: true,
										border:true,
										margin:'10 0 10 0',
										padding:10,
										columnWidth:.20,
										style:
										{
											'border-right':borderVal,
											'border-color':'#303030',
										},
										layout:'fit',
										items: [{
											html:digtalChartHtml
										}]
									});
								}
								comp.add({
									xtype:'panel',
									layout:'column',
									columnWidth:1,
									items:digitalArry,
								});
							}
							else
							{
								for(var k in chartCollection)
								{
									var chartCollectionVal = chartCollection[k];
									var panelHeight=3*calculatedBaseDimensionY;
									if(chartCollection.length==1)
									{
										panelHeight=4*calculatedBaseDimensionY;
									}
									panelHeight=Ext.util.Format.round(panelHeight, 0);
									var bodyPadding='5 20 0 10';
									if(chartType=='table'||chartType=='topn')
									{
										bodyPadding='10';
									}
									var widgetMargin='0 10 10 0';
									if(widgetCount%2==0)
									{
										widgetMargin='0 2 10 0';
									}
									
									if(chartType=='pie')
									{
										chartCollectionVal.title=chartCollectionVal.chartTitle;
									}
									var widgetArray=new Array();
									widgetArray.push(this.loadWidgetData(widgetIdInfo+k+'_panel',chartCollectionVal,widgetIdInfo,chartType,calculatedBaseDimensionX,panelHeight));
									var lblId = appConstants.templateName+"$~$widget$~$"+"footerDescription";
									if(chartCollectionVal.title == "" || chartCollectionVal.title == " " || chartCollectionVal.title == "title")
									{
										chartCollectionVal.title=widgetHeader;
									}
									panelHeight=panelHeight+20;
									if(chartType=='table')
									{
										panelHeight='';
									}
									//for load evaluator report
									if(chartCollectionVal.columnWidth != undefined && chartCollectionVal.columnWidth == 'full')
									{
										panelColWidth=1.0;
										widgetMargin='0 2 10 0';
										widgetCount=0;
									}
									else
									{
										if(chartCollection.length>1)
											panelColWidth=0.5;
									}
									comp.add({
										xtype:'panel',
										id:widgetIdInfo+k+'_panel',
										closeAction:'destroy',
										ui:'newGraphPanel',
										title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+chartCollectionVal.title+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>',
										margin:widgetMargin,
										height:panelHeight,
										scroll:false,
										bodyPadding:bodyPadding,
										layout:'fit',
										align:'stretch',
										autoScroll:true,
										overflowX:'hidden',
										overflowY:'auto',
										chartCollectionVal:chartCollectionVal,
										graphIndex:k,
										columnWidth:panelColWidth,
										chartType:chartType,
										chartTypeCollection:chartTypeCollection,
										tools:[
											this.addToolBarItems([
//												{
//													xtype: 'tbseparator',
//													padding:0,
//													height:26,
//													cls:'widgetHeaderSeparator',
//													width:2,
//													margin:'0 0 0 0',
//													hidden:csvInfoUrlFlag,
//												},
												{
													xtype: 'button',
													width:16,
													height:16,
													margin:'0 3 0 3',
													style:{'border':'0px'},
													cls: 'iconCsvWidget',
													hidden:csvInfoUrlFlag,
													handler:function(){
														var thisPanel=this.up('panel');
														var cntr=appConstants.appObj.getController(appConstants.appController);
														var csvInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+cntr.getQueryString(false)+"&graphIndex="+thisPanel.graphIndex+'&widgetIdInfo='+widgetIdInfo+'&option=csv';
														window.location=csvInfoUrl;
												}
											},
//											{
//												xtype: 'tbseparator',
//												padding:0,
//												height:26,
//												cls:'widgetHeaderSeparator',
//												width:2,
//												margin:'0 0 0 0',
//												hidden:gridInfoUrlFlag,
//											},
											{
												xtype: 'button',
												cls:'iconDataWidget',
												style:{'border':'0px'},
												width:16,
												height:16,
												margin:'0 3 0 3',
												hidden:gridInfoUrlFlag,
												handler:function(){
													var thisPanel=this.up('panel');
													var cntr=appConstants.appObj.getController(appConstants.appController);
													var gridInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+cntr.getQueryString(false)+"&graphIndex="+thisPanel.graphIndex+'&widgetIdInfo='+widgetIdInfo+'&pdfPrint=yes&pdfprint=yes';
													parent.printWindowFn(gridInfoUrl);
													}
												},
//												{
//													xtype: 'tbseparator',
//													padding:0,
//													height:26,
//													cls:'widgetHeaderSeparator',
//													width:2,
//													margin:'0 0 0 0',
//													hidden:drillDownUrlFlag,
//												},
												{
													xtype: 'button',
													width:16,
													height:16,
													margin:'0 0 0 3',
													style:{'border':'0px'},
													cls:'iconMaximizeWidget',
													hidden:drillDownUrlFlag,
													handler:function(){
														var thisPanel=this.up('panel');
														var drillDownUrl=timelineurl+"&graphIndex="+thisPanel.graphIndex+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+thisPanel.chartCollectionVal.isDDEnabled+'&dd_Url='+thisPanel.chartCollectionVal.dd_Url;
														parent.maximizeWindowLightBox(drillDownUrl);
													}
												}

											])
										],
										dockedItems:[{
											xtype:'toolbar',
											dock:'bottom',
											align:'stretch',
											layout:'fit',
											overCls:'reporterTemplateWidgetToolbarOver',
											cls:'reporterTemplateWidgetToolbar',
											hidden:!isEnableEditor,
											height:42,
											items:[{
												xtype:'container',
												layout: {
													type: 'hbox',
													align: 'middle'
												},
												items:[
													{
														xtype: 'button',
														width:16,
														height:16,
														padding:0,
														margin:'8 4 8 10',
														id: 'widgetDescriptor'+widgetIdInfo+k,
														cls:'iconDescription',
														listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:'Widget Descriptor'
																});
															}
														}
													},
													{
														xtype: 'label',
														id:lblId+k,
														text:appConstants.builderJson.data.widgetFooter,
														margin: '5 10 5 5',
														flex:1,
														cls:'handSymbol',
														listeners:{
															afterrender:function(obj){
																obj.el.on('click',this.onEdit,this);
																},
														},
														onEdit: function(event, element,obj)
														{
															var me = this;

															if(!me.editor) {
																me.editor = Ext.create('Ext.Editor', {
																	updateEl: true,
																	completeOnEnter: true,
																	cancelOnEsc: true,
																	floating: false,
																	alignment: 'tl',
																	autoSize: {
																		width: 'boundEl', // Width from the field
																		height: '21' // Height from the boundEl
																	},
																	hideEl: false,
																	offsets: [0,-2],
																	field: {
																		xtype: 'textfield',
																		cls: 'textbox',
																	},
																	listeners: {
																		complete: {
																			fn: function(self, value, startValue, opts) {
																				var url='/final/reporter/ReportBuilderController.jsp';
																				var controller=appConstants.appObj.getController(appConstants.appController);
																				var thisPanel=this.up('panel');
																				var params='&widgetHeaderFooterInfo='+Ext.encode(value);
																				params+='&isCustomLayout='+appConstants.isCustomLayout;
																				params+='&method=graphHeaderFooter';
																				params+='&templateName='+appConstants.templateName;
																				params+='&chartType='+thisPanel.chartType;
																				params+='&chartTypeCollection='+thisPanel.chartTypeCollection;
																				params+='&idDescription=footer$~$'+thisPanel.graphIndex;
																				controller.callAjax(url,params,false,true,true);
																			},
																			scope: me,
																		}
																	}
																});
															}
															me.editor.startEdit(element);
														}
													},
												]

											}]

										}
										],
										listeners:{
											boxready:function(obj)
											{
												if (!Ext.isEmpty(obj.header))
												{
													var el =Ext.get(obj.header.id+'_hd-textEl');
													if(isEnableEditor)
														Ext.get(obj.header.id).on('click', function(e,target){

														var edtrText=el.dom.innerText;

														var editor = new Ext.Editor({
															width: 150,
															alignment: 'tl',
															floating: false,
															shadow: false,
															updateEl: true,
															completeOnEnter: true,
															cancelOnEsc: true,
															hideEl: true,
															offsets: [0,-3],
															field: {
																xtype: 'textfield',
																cls: 'textbox',
																maxLength:32,
																allowBlank:false,
																enforceMaxLength: true
															},
															listeners: {
																'complete': function (edtr, value, startValue, eOpts) {
																	el.dom.innerHTML=value;
																	el.dom.innerHTML='<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+value+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>';
																	var url='/final/reporter/ReportBuilderController.jsp';
																	var controller=appConstants.appObj.getController(appConstants.appController);
																	var thisPanel=obj;
																	var params='&widgetHeaderFooterInfo='+Ext.encode(value);
																	params+='&isCustomLayout='+appConstants.isCustomLayout;
																	params+='&method=graphHeaderFooter';
																	params+='&templateName='+appConstants.templateName;
																	params+='&fromReportBuilder='+appConstants.fromReportBuilder;
																	params+='&idDescription=header$~$'+thisPanel.graphIndex;
																	params+='&chartType='+thisPanel.chartType;
																	params+='&chartTypeCollection='+thisPanel.chartTypeCollection;
																	controller.callAjax(url,params,false,true,true);
																}
															}
														});
														editor.startEdit(el,edtrText);
													}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
												}
											}
										},
										items:widgetArray

									});
									widgetCount=widgetCount+1;

								}
							}
						}
						else
						{

							comp.add(this.getNoMeasureWithoutBorderNew());
						}
					}
					else
					{
						colStatus='componentWise';

						for(var compName in chartCollection)
						{
							widgetCount=1;
							chartCollectionComp=chartCollection[compName];
							var compChartArray = new Array();
							if(chartCollectionComp instanceof Array)
							{
								var panelColWidth=1.0;
								if(chartCollectionComp.length>1)
									panelColWidth=0.5;
								for(var k in chartCollectionComp)
								{
									var chartCollectionCompVal = chartCollectionComp[k];
									var mainDivWidth=document.getElementById("main").offsetWidth;
									var mainDivHeight=document.getElementById("main").offsetHeight;
									var calculatedBaseDimensionY=mainDivHeight*0.1500;
									var calculatedBaseDimensionX=((mainDivWidth)/12);
									calculatedBaseDimensionX=Ext.util.Format.round(calculatedBaseDimensionX, 0);
									calculatedBaseDimensionX=calculatedBaseDimensionX*12;
									var panelHeight=3*calculatedBaseDimensionY;
									panelHeight=Ext.util.Format.round(panelHeight, 0);
									var bodyPadding='5 20 0 10';
									var widgetMargin='0 10 10 0';
									if(widgetCount%2==0)
									{
										widgetMargin='0 10 10 0';
									}
									widgetCount=widgetCount+1;
									var widgetArray=new Array();
									widgetArray.push(this.loadWidgetData(widgetIdInfo+compName+k+'_panel',chartCollectionCompVal,widgetIdInfo,chartType,calculatedBaseDimensionX,panelHeight));
									var lblId = appConstants.templateName+"$~$widget$~$"+"footerDescription";
									compChartArray.push({
										xtype:'panel',
										id:widgetIdInfo+compName+k+'_panel',
										closeAction:'destroy',
										//cls:'datapanel',
										//ui:'newPanelWidget',
										ui:'newGraphPanel',
										//title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+chartCollectionCompVal.title+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>',
										title: chartCollectionCompVal.title,
										margin:widgetMargin,
										height:panelHeight+20,
										scroll:false,
										bodyPadding:bodyPadding,
										layout:'fit',
										align:'stretch',
										autoScroll:true,
										overflowX:'hidden',
										overflowY:'auto',
										columnWidth:panelColWidth,
										chartCollectionCompVal:chartCollectionCompVal,
										graphIndex:k,
										compName:compName,
										chartType:chartType,
										chartTypeCollection:chartTypeCollection,
											
										tools:[
											this.addToolBarItems([
//												{
//													xtype: 'tbseparator',
//													padding:0,
//													height:26,
//													cls:'widgetHeaderSeparator',
//													width:2,
//													margin:'0 0 0 0',
//													hidden:csvInfoUrlFlag,
//												},
												{
													xtype: 'button',
													width:16,
													height:16,
													margin:'0 3 0 3',
													style:{'border':'0px'},
													cls: 'iconCsvWidget',
													hidden:csvInfoUrlFlag,
													handler:function(){
														var thisPanel=this.up('panel');
														var cntr=appConstants.appObj.getController(appConstants.appController);
														var csvInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+cntr.getQueryString(false)+"&graphIndex="+thisPanel.graphIndex+'&widgetIdInfo='+widgetIdInfo+'&option=csv&compName='+thisPanel.compName+'';

														window.location=csvInfoUrl;
													}
												},
//												{
//													xtype: 'tbseparator',
//													padding:0,
//													height:26,
//													cls:'widgetHeaderSeparator',
//													width:2,
//													margin:'0 0 0 0',
//													hidden:gridInfoUrlFlag,
//												},
												{
													xtype: 'button',
													cls:'iconDataWidget',
													style:{'border':'0px'},
													width:16,
													height:16,
													margin:'0 3 0 3',
													hidden:gridInfoUrlFlag,
													handler:function(){
														var thisPanel=this.up('panel');
														var cntr=appConstants.appObj.getController(appConstants.appController);
														var gridInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+cntr.getQueryString(false)+"&graphIndex="+thisPanel.graphIndex+'&widgetIdInfo='+widgetIdInfo+'&pdfPrint=yes&pdfprint=yes&compName='+thisPanel.compName+'';
														parent.printWindowFn(gridInfoUrl);
														window.location=csvInfoUrl;
													}
												},
//												{
//													xtype: 'tbseparator',
//													padding:0,
//													height:26,
//													cls:'widgetHeaderSeparator',
//													width:2,
//													margin:'0 0 0 0',
//													hidden:drillDownUrlFlag,
//												},
												{
													xtype: 'button',
													width:16,
													height:16,
													margin:'0 0 0 3',
													style:{'border':'0px'},
													cls:'iconMaximizeWidget',
													hidden:drillDownUrlFlag,
													handler:function(){
														var thisPanel=this.up('panel');
														var	drillDownUrl=timelineurl+"&graphIndex="+thisPanel.graphIndex+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+thisPanel.chartCollectionCompVal.isDDEnabled+'&dd_Url='+thisPanel.chartCollectionCompVal.dd_Url+'&compName='+thisPanel.compName+'';
														parent.maximizeWindowLightBox(drillDownUrl);
													}
												}

											])
										],
										dockedItems:[{
											xtype:'toolbar',
											dock:'bottom',
											align:'stretch',
											layout:'fit',
											overCls:'reporterTemplateWidgetToolbarOver',
											cls:'reporterTemplateWidgetToolbar',
											hidden:!isEnableEditor,
											height:42,
											items:[{
												xtype:'container',
												layout: {
													type: 'hbox',
													align: 'middle'
												},
												items:[
													{
														xtype: 'button',
														width:16,
														height:16,
														padding:0,
														margin:'8 4 8 10',
														id: 'widgetDescriptor'+widgetIdInfo+compName+k,
														cls:'iconDescription',
														listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:'Widget Descriptor'
																});
															}
														}
													},
													{
														xtype: 'label',
														id:lblId+compName+k,
														text:appConstants.builderJson.data.widgetFooter,
														margin: '5 10 5 5',
														flex:1,
														cls:'handSymbol',
														listeners:{
															afterrender:function(obj){
																obj.el.on('click',this.onEdit,this);
																},
														},
														onEdit: function(event, element,obj)
														{
															var me = this;
															if(!me.editor) {
																me.editor = Ext.create('Ext.Editor', {
																	updateEl: true,
																	completeOnEnter: true,
																	cancelOnEsc: true,
																	floating: false,
																	alignment: 'tl',
																	autoSize: {
																		width: 'boundEl', // Width from the field
																		height: '21' // Height from the boundEl
																	},
																	hideEl: false,
																	offsets: [0,-2],
																	field: {
																		xtype: 'textfield',
																		cls: 'textbox',
																	},
																	listeners: {
																		complete: {
																			fn: function(self, value, startValue, opts) {
																				var url='/final/reporter/ReportBuilderController.jsp';
																				var controller=appConstants.appObj.getController(appConstants.appController);
																				var thisPanel=this.up('panel');
																				var params='&widgetHeaderFooterInfo='+Ext.encode(value);
																				params+='&isCustomLayout='+appConstants.isCustomLayout;
																				params+='&method=graphHeaderFooter';
																				params+='&templateName='+appConstants.templateName;
																				params+='&compName='+thisPanel.compName;
																				params+='&idDescription=footer$~$'+thisPanel.graphIndex;
																				params+='&chartType='+thisPanel.chartType;
																				params+='&chartTypeCollection='+thisPanel.chartTypeCollection;
																				controller.callAjax(url,params,false,true,true);
																			},
																			scope: me,
																		}
																	}
																});
															}
															me.editor.startEdit(element);
														}
													},
												]

											}]
										}
										],
										listeners:{
											boxready:function(obj)
											{
												if (!Ext.isEmpty(obj.header))
												{
													var el =Ext.get(obj.header.id+'_hd-textEl');
													if(isEnableEditor)
														Ext.get(obj.header.id).on('click', function(e,target)
														{
															var edtrText=el.dom.innerText;
															var editor = new Ext.Editor({
															width: 150,
															alignment: 'tl',
															floating: false,
															shadow: false,
															updateEl: true,
															completeOnEnter: true,
															cancelOnEsc: true,
															offsets: [0,-3],
															field: {
																xtype: 'textfield',
																cls: 'textbox',
																maxLength:32,
																allowBlank:false,
																enforceMaxLength: true
															},
															listeners: {
																'complete': function (edtr, value, startValue, eOpts) {
																	el.dom.innerHTML=value;
																	el.dom.innerHTML='<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+value+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>';
																	var url='/final/reporter/ReportBuilderController.jsp';
																	var controller=appConstants.appObj.getController(appConstants.appController);
																	var thisPanel=obj;
																	var params='&widgetHeaderFooterInfo='+Ext.encode(value);
																	params+='&isCustomLayout='+appConstants.isCustomLayout;
																	params+='&method=graphHeaderFooter';
																	params+='&templateName='+appConstants.templateName;
																	params+='&fromReportBuilder='+appConstants.fromReportBuilder;
																	params+='&compName='+thisPanel.compName;
																	params+='&idDescription=header$~$'+thisPanel.graphIndex;
																	params+='&chartType='+thisPanel.chartType;
																	params+='&chartTypeCollection='+thisPanel.chartTypeCollection;
																	controller.callAjax(url,params,false,true,true);
																}
															}
														});
														editor.startEdit(el,edtrText);
													}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
												}
											}
										},
										items:widgetArray
									});
								}
							}
							var columns=1;
							if (compChartArray.length>1)
							{
								columns=2;
							}						
							if(compChartArray.length==0)
								compChartArray=this.getNoMeasureWithoutBorderNew();
							var bodyPaddings = '0 0 0 10';
							if(compName==undefined || compName=='')
							{
								bodyPaddings = '10 0 0 10';
							}
							comp.add({
								xtype:'panel',
								id:compName+'basepanel',
								closeAction:'destroy',
								ui:'multiGraphPanel',
								//ui:'newGraphPanel',
								bodyPadding:bodyPaddings,
								title:compName,
								columns:columns,
								margin: '0 5 10 5',
								sortable: true,
								autoScroll:true,
								layout: {
									type: 'table',
									columns: columns,
									tableAttrs: {
										style: {
											width: '100%',
											tableLayout: 'fixed'
										}
									}
								},
								items:compChartArray
							});
						}
					}
				}
				comp.doLayout();
				Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.builderJson.selectionDetails);
			}
			else
			{
				comp.add(this.getNoMeasureWithoutBorderNew());
				this.enableDisableTools(true);
			}
		}
		else
		{
			comp.add(this.getNoMeasureWithoutBorderNew());
			this.enableDisableTools(true);
		}
	},
	perLoadWidget:function(eachWidget,widgetId,fullMargin,paramVal,widgetCountStatus,comp,panelHeaderStatus)
	{
		var isEnableEditor=false;
		var currentY = eachWidget.y;
		var currentX = eachWidget.x;
		if(lastY == currentY && lastX != currentX && currentY!=1)
		{
			if(heightChangeId == '')
				heightChangeId = createdPanelAry[createdPanelAry.length-2];
			heightChangeCount = heightChangeCount+1;
		}
		else
		{
			heightChangeId = '';
		}
		if(heightChangeId != '' && heightChangeCount!=0)
		{
			var oldHeight = Ext.getCmp(heightChangeId+'_panel').height;
			Ext.getCmp(heightChangeId+'_panel').setHeight(oldHeight+(heightChangeCount*10));
			heightChangeCount = 0;
		}
		lastY = currentY;
		lastX = currentX;
		createdPanelAry.push(widgetId);
		if(neeedEditableHeader=='yes')
			isEnableEditor=true;
		var hideNotes = false;
		hideNotes=!isEnableEditor;
		var me=this;
		var chartType = eachWidget.chartType;
		var widgetIdInfo = widgetId+'_detail'
		var drillDownUrl='',csvInfoUrl='',gridInfoUrl='';
		var drillDownUrlFlag=true , csvInfoUrlFlag=true,gridInfoUrlFlag=true,noteFlag=false;
		var noMeasWidget=false;
		var panelHeader=true;
		gridInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+this.getQueryString(false)+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&pdfPrint=yes&pdfprint=yes&titleDisp='+appConstants.tempName;
		csvInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+this.getQueryString(false)+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&option=csv&titleDisp='+appConstants.tempName;
		var mainDivWidth=document.getElementById("main").offsetWidth;
		var mainDivHeight=document.getElementById("main").offsetHeight;
		var calculatedBaseDimensionY=mainDivHeight*0.1500;
		var calculatedBaseDimensionX=((mainDivWidth)/12);
		calculatedBaseDimensionX=calculatedBaseDimensionX*eachWidget.size_x;
		var panelHeight=eachWidget.size_y*calculatedBaseDimensionY;
		panelHeight=Ext.util.Format.round(panelHeight, 0);
		var per_footer = '';
		if(eachWidget.footerDescription!=undefined && eachWidget.footerDescription!='undefined')
			per_footer = eachWidget.footerDescription;
		var footerCls = 'iconNoCommentSmall';
		if(per_footer!='')
		{
			footerCls = 'iconCommentSmall';
		}
		var bodyPadding='5 20 0 10';
		var widgetMargin = "0 10 10 0";
		if(fullMargin)
			widgetMargin = "0 2 10 0";
		else
			widgetMargin = "0 10 10 0";
		var panelLayout='fit';
		if(chartType=='table'||chartType=='topn')
		{
			bodyPadding='10';
		}
		if(chartType == 'digital' || chartType == 'multiDigi')
		{
			bodyPadding='0';
		}
		panelHeader = panelHeaderStatus;
		if(comp.getId()!='resultcontainer')
		{
			bodyPadding='0';
			widgetMargin = "0 0 0 0";
			// here 44 is header height
			if(chartType=='table'||chartType=='topn')
			{
				bodyPadding='0 10 0 10';
			}
		}
		var lblId =  appConstants.templateName+"$~$"+widgetId+"$~$"+"footerDescription";
		var lblIdHeader =  appConstants.templateName+"$~$"+widgetId+"$~$"+"headerDescription";
		var autoScroll=true;
		var overflowY='auto';
		var defaultPadding='5 0 0 0';
		if(chartType == 'timeline' || chartType == 'area')
		{
			chartType = 'timeline'
			drillDownUrlFlag=false;
			csvInfoUrlFlag=false;
			gridInfoUrlFlag=false;
		}
		else if(chartType == 'heatMap')
		{
			drillDownUrlFlag=false;
		}
		else if (chartType == 'bar' || chartType == 'vertbar')
		{
			drillDownUrlFlag=false;
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
		}
		else if (chartType == 'stackedbar')
		{
			chartType = 'bar';
			drillDownUrlFlag=false;
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
		}
		else if (chartType == 'distributedPie')
		{
			chartType='distpie';
			noteFlag=true;
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
		}
		else if (chartType == 'pie')
		{
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			noteFlag=true;
		}
		else if (chartType == 'table')
		{			
			if(!isEnableEditor)
			{
				customPagingHeight=panelHeight;
				panelHeight='';
			}
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
		}
		else if (chartType == 'topn')
		{
			chartType='topn';
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
		}
		else if(chartType == 'digital' || chartType == 'multiDigi')
		{
			chartType='digital';
			panelHeight=130;
			if(eachWidget.digitalRow !=undefined)
			{
				panelHeight=221;
				panelHeader=false;
				autoScroll=false;
				overflowY='hidden';
				defaultPadding='0 0 0 0';
			}			
			hideNotes = true;
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			noteFlag=true;
		}
		hideNotes = true; //.. no need Notes
		var headerLine = ' graphHeaderBottomBorder';
		var headerPadding= '5px 10px 5px 10px'
		if(csvInfoUrlFlag && gridInfoUrlFlag && drillDownUrlFlag)
		{
			headerLine = '';
			headerPadding= '10px 0px 10px 15px'
		}
		var toolsArry=[];
		if(eachWidget.headerCombo != undefined && eachWidget.headerCombo=='yes')
		{
			toolsArry.push(
			{
				xtype: "scrollcombo",
				width: 285,
				cls: "dropdown",
				editable: false,
				margin:'0 4px 0 0',
				name: "er_headerCombo",
				id: "er_headerCombo",
				fieldLabel:eachWidget.headerDescription,
				labelAlign:'left',
				labelSeparator:'',
				labelStyle: 'white-space: nowrap;font-size: 14px;font-weight:500;',
				labelWidth:160,
				store: new Ext.data.Store({
					fields: ["displayField", "valueField"],
					data: [{"displayField":"Session Identifier","valueField":"SESSION_ID"},{"displayField":"User Name","valueField":"userName"}]
				}),

				displayField: "displayField",
				valueField: "valueField",
				queryMode: "local",	
				listeners: {
					boxready:function(obj){
						Ext.getCmp('er_headerCombo').setValue(appConstants.er_headerCombo);
					},
					change: function (e, d, a, b) {
						var params1 = me.getQueryString(true);
						params1+='&widget='+widgetId;
						params1+='&tempDesc='+appConstants.tempDesc;
						params1+='&recordInfo='+appConstants.recordInfo+'&templateName='+appConstants.templateName;
						params1+='&user_dispName='+appConstants.tempName;
						appConstants.er_headerCombo=d;
						var url='ReportBuilderController.jsp';	
						//var initMask = new Ext.LoadMask(me.getEl(),{msg : "Loading ..."});
						//initMask.show();
						Ext.Ajax.request({
							url:url,
							params:params1,
							scope:this,
							success:function(response){	
								if(response.responseText.length>0)
								{
									//initMask.hide();
									var preLoadJson = Ext.decode(response.responseText);
									me.preLoadAjaxSuccess(preLoadJson,widgetCountStatus,widgetId);
									if(customPaging)
									{
										appConstants.blockPdfRelatedOptions='yes';									
									}
								}
							},
							failure:function(err)
							{
								//Ext.MessageBox.alert("Error occured in ErCtxOverview.jsp page");
							}
						});	
					}
				}
			});
			eachWidget.headerDescription='';
		}
		var compItemObj={
			xtype:'panel',
			id:widgetId+'_panel',
			closeAction:'destroy',
			ui:'newGraphPanel'+headerLine,
			title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+eachWidget.headerDescription+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>',
			margin:widgetMargin,
			height:panelHeight,
			scroll:false,
			bodyPadding:bodyPadding,
			layout:panelLayout,
			padding:defaultPadding,
			align:'stretch',
			autoScroll:autoScroll,
			overflowX:'hidden',
			overflowY:overflowY,
			header:false,
			timelineLink:'',
			columnWidth:calculatedBaseDimensionX/mainDivWidth,
			header:{
				hidden:!panelHeader,
				style:{
					'padding':headerPadding
				},
				titlePosition:1,
				items:toolsArry
			},
			tools:[
				this.addToolBarItems([
					{
						xtype: 'button',
						scale: 'small',
						padding:0,
						border:false,
						iconCls: footerCls,
						margin:'2 7 0 3',
						style:{'border':'0px'},
						//cls: footerCls,
						id:widgetId+'_note',
						hidden:noteFlag,
						noteValue:per_footer,
						handler:function(){
							me.openSmallPopupWindow(this);
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 3 0 3',
						style:{'border':'0px'},
						cls: 'iconCsvWidget',
						id:widgetId+'_csv',
						hidden:csvInfoUrlFlag,
						handler:function(){
							window.location=csvInfoUrl;
						}
					},{
						xtype: 'button',
						cls:'iconDataWidget',
						style:{'border':'0px'},
						width:16,
						height:16,
						margin:'0 3 0 3',
						id:widgetId+'_data',
						hidden:gridInfoUrlFlag,
						handler:function(){
							parent.printWindowFn(gridInfoUrl);
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 0 0 3',
						style:{'border':'0px'},
						cls:'iconMaximize',
						id:widgetId+'_drill',
						hidden:drillDownUrlFlag,
						handler:function(){
							var preLoadWidget = Ext.getCmp(widgetId+'_panel');
							parent.maximizeWindowLightBox(preLoadWidget.timelineLink);
						}
					}
				])
			],
			dockedItems:[{
				xtype:'toolbar',
				dock:'bottom',
				align:'stretch',
				overCls:'reporterTemplateWidgetToolbarOver',
				layout:'fit',
				hidden:hideNotes,
				cls:'reporterTemplateWidgetToolbar',
				height:42,
				items:[{
					xtype:'container',
					layout: {
						type: 'hbox',
						align: 'middle'
					},
					items:[
						{
							xtype: 'button',
							width:16,
							height:16,
							padding:0,
							margin:'8 4 8 10',
							id: 'widgetDescriptor'+widgetId,
							cls:'iconDescription',
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html:'Widget Descriptor'
									});
								}
							}
						},
						{
							xtype: 'label',
							id:lblId,
							text:per_footer,
							margin: '5 10 5 5',
							flex:1,
							cls:'handSymbol',
							listeners:
							{
								afterrender:function(obj)
								{
									obj.el.on('click',this.onEdit,this);
								},
							},
							onEdit: function(event, element,obj)
							{
								var me = this;
								if(!me.editor) {
									me.editor = Ext.create('Ext.Editor', {
										updateEl: true,
										completeOnEnter: true,
										cancelOnEsc: true,
										floating: false,
										alignment: 'tl',
										autoSize: {
											width: 'boundEl', // Width from the field
											height: '21' // Height from the boundEl
										},
										hideEl: false,
										offsets: [0,-2],
										field: {
											xtype: 'textfield',
											cls: 'textbox',
										},
										listeners: {
											complete: 
											{
												fn: function(self, value, startValue, opts) 
												{
													var url='/final/reporter/ReportBuilderController.jsp';
													var controller=appConstants.appObj.getController(appConstants.appController);
													var params='&widgetHeaderFooterInfo='+encodeURIComponent(value);
													params+='&method=setWidgetHeaderFooter';
													params+='&isCustomLayout='+appConstants.isCustomLayout;
													params+='&templateName='+appConstants.templateName;
													params+='&idDescription='+lblId;
													controller.callAjax(url,params,false,true,true);
												},
												scope: me,
											}
										}
									});
								}
								me.editor.startEdit(element);
							}
						},
					]
				}]
			}],
			listeners:{
				boxready:function(obj)
				{
					if (!Ext.isEmpty(obj.header))
					{
						var el =Ext.get(obj.header.id+'_hd-textEl');						
						if(isEnableEditor)
							Ext.get(obj.header.id).on('click', function(e,target){
							var edtrText=el.dom.innerText;	
							var editor = new Ext.Editor({
								width: 150,
								alignment: 'tl',
								floating: false,
								shadow: false,
								updateEl: true,
								completeOnEnter: true,
								cancelOnEsc: true,
								offsets: [0,-3],
								field: {
									xtype: 'textfield',
									cls: 'textbox',
									maxLength:32,
									allowBlank:false,
									enforceMaxLength: true
								},
								listeners: {
									'complete': function (edtr, value, startValue, eOpts) {
										el.dom.innerHTML=value;
										el.dom.innerHTML='<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+value+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>';
										var url='/final/reporter/ReportBuilderController.jsp';
										var controller=appConstants.appObj.getController(appConstants.appController);
										var params='&widgetHeaderFooterInfo='+encodeURIComponent(value);
										params+='&method=setWidgetHeaderFooter';
										params+='&templateName='+appConstants.templateName;
										params+='&isCustomLayout='+appConstants.isCustomLayout;
										params+='&fromReportBuilder='+appConstants.fromReportBuilder;
										params+='&idDescription='+lblIdHeader;
										controller.callAjax(url,params,false,true,true);
									}
								}
							});
							editor.startEdit(el,edtrText);
						}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
					}
					var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
					initMask.show();
					var thispanel = this;
					var url='/final/reporter/ReportBuilderController.jsp';
					paramVal+='&widget='+widgetId
					paramVal+='&tempDesc='+appConstants.tempDesc;
					if(wildcardSearch)
					{
						paramVal+='&clientVersionn='+Ext.getCmp('wildcardSearch').getValue();
						if(wildcardSearchCondition)
							paramVal+='&er_searchGroupBy='+Ext.getCmp('er_searchGroupBy').getValue();
					}
					if(appConstants.method=='submit')
						thispanel.timelineLink='/final/reporter/ErReportBuilderDrillDown.jsp?'+paramVal+'&isSubmit=true';
					distributedPieUrl=me.getQueryString(true);
					Ext.Ajax.request({
						url:url,
						params:paramVal,
						scope:this,
						success : function(response){
							if(response.responseText.length>0)
							{
								initMask.hide();
								var preLoadJson = Ext.decode(response.responseText);
								me.preLoadAjaxSuccess(preLoadJson,widgetCountStatus,widgetId);
								if(customPaging)
								{
									appConstants.blockPdfRelatedOptions='yes';									
								}
							}
						},
						failure:function(err){
							Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
						}
					});	
				},
				'afterRender': function(obj)
				{
					if(chartType != undefined && chartType=='table')
					{
						var el = Ext.get(widgetId+'_panel');
						el.on('click', function(event, target, options)
						{	
							var compVal=target.textContent;
							if(compVal != undefined && compVal.indexOf("$") != -1)
								compVal=compVal.substring(compVal.indexOf("$")+1);
							var url;
							var params='method=submit';								
							var obj=Ext.getCmp('er_site');
							var gpuTemplate='yes';
							if(appConstants.templateName != undefined && appConstants.templateName == 'GPU Overview')
							{
								url='/final/reporter/ReportBuilder.jsp?';
								params='method=submit&recordInfo='+encodeURIComponent('{"templateName":"GPU Details"}');
							params+='&isSubmit=true';
							if (!obj.isHidden())
							{
								params+='&er_site='+obj.getValue();
									if (Ext.getCmp('er_option').getValue()=='Zone')
									{
										params+='&er_subZone='+Ext.getCmp('er_subZone').getValue();
									}
								}
							}
							else if(appConstants.templateName != undefined && appConstants.templateName == 'User Idle Reports')
							{
								url='/final/reporter/ErThinClientUserReport.jsp?fromMenuBar=true&er_trgttype=User Session Report&';
								params+='&isForceSubmit=true';
								params+='&er_user='+encodeURIComponent(compVal);
								params+='&er_RmDispName='+encodeURIComponent('User Session Details');
								params+='&fromReportBuilder=yes';
								if (!obj.isHidden())
								{
									params+='&select_farm='+obj.getValue();
								if (Ext.getCmp('er_option').getValue()=='Zone')
								{
										params+='&er_subZone='+Ext.getCmp('er_subZone').getValue();
								}
								}	
								gpuTemplate='no';
							}
							params+='&hideInputs=false';
							params+='&er_option='+Ext.getCmp('er_option').getValue();
							params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
							if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
							{
								params+='&showLegendsEnable='+Ext.getCmp('showLegend').getValue();
							}
							var arr=new Array();
							arr=Ext.getCmp('er_component').getValue();
							for (var key in arr )
							{
								if(gpuTemplate == 'yes')
								{
								if(arr[key].indexOf(compVal) != -1)
								{
									params+='&er_component='+arr[key];
								}
								if(arr[key]=='All')
								{
									if(compVal.indexOf(":") != -1)
									{
										params+='&er_component='+compVal+":"+Ext.getCmp(appConstants.erCompType).getValue();
									}
									else
									{
										params+='&er_component='+compVal+":NULL:"+Ext.getCmp(appConstants.erCompType).getValue();
										}
									}
								}
								else if(gpuTemplate == 'no')
								{
									params+='&er_componentserver='+arr[key];
									params+='&select_server1='+arr[key];
								}
							}
							params+='&er_test='+Ext.getCmp('er_test').getValue();
							if(appConstants.isMultiMeasureSupport=='yes')
							{
								var arr=new Array();
								arr=Ext.getCmp('er_measure').getValue();
								for (var key in arr )
								{
									var measure=arr[key];
									measure=measure.replace("(","EGOPENBRACE");
									measure=measure.replace(")","EGCLOSEBRACE");
									params+='&er_measure='+measure;
								}
							}
							else
							{
								var measure=Ext.getCmp('er_measure').getValue();
								measure=measure.replace("(","EGOPENBRACE");
								measure=measure.replace(")","EGCLOSEBRACE");
								params+='&er_measure='+measure;
							}
							if(Ext.getCmp(appConstants.erInfo).getValue() != undefined)
								params+='&er_info='+Ext.getCmp(appConstants.erInfo).getValue();
							params+='&er_timeline='+Ext.getCmp('er_timeline').getValue();
							params+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
							params+='&startdate='+Ext.getCmp('er_stdate').dataArray;
							params+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
							params+='&enddate='+Ext.getCmp('er_enddate').dataArray;
							params+='&er_sthr='+Ext.getCmp('er_sthr').dataArray;
							params+='&starthr='+Ext.getCmp('er_sthr').dataArray;
							params+='&er_endhr='+Ext.getCmp('er_endhr').dataArray;
							params+='&endhr='+Ext.getCmp('er_endhr').dataArray;
							params+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
							params+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;
							params+='&timefrom='+Ext.getCmp('timefrom').getValue();
							params+='&timeto='+Ext.getCmp('timeto').getValue();
							params+='&minfrom='+Ext.getCmp('minfrom').getValue();
							params+='&minto='+Ext.getCmp('minto').getValue();
							params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue();
							params+='&er_excwe='+Ext.getCmp('er_excwe').getValue();
							params+='&pct_idle='+Ext.getCmp('pct_idle').getValue();
							params+='&sorted_col='+Ext.getCmp('groupBy_list').getValue();//..for sorted measure
							params+='&aggregate_server='+Ext.getCmp('aggregate_server').getValue();
							params+='&er_showBy='+Ext.getCmp('er_showBy').getValue();
							params+='&timeline_showBy='+Ext.getCmp('timeline_showBy').getValue();//...
							params+='&bar_showBy='+Ext.getCmp('bar_showBy').getValue();//...
							if (appConstants.isCustomLayout=='yes')
							{
								params+='&er_top='+Ext.getCmp('er_top').getValue();
							}
							else
							{
								params+='&chartInfo='+appConstants.chartInfo;
								params+='&er_top='+Ext.getCmp('er_top').getValue();
							}
							params+='&fromReportBuilder='+appConstants.fromReportBuilder;
							params+='&enableBack=true';
							linkURL(url+params);
						},
						this,
						{
							delegate: '.forCursorSymbol',
						});
					}
				}
			},
		};
		if(eachWidget.digitalRow !=undefined)
		{
			var digitRowArry=new Array();
			digitRowArry.push(compItemObj);
			comp.add({
					xtype:'container',
					id:widgetId+'_digitalPanel',				
					columnWidth:calculatedBaseDimensionX/mainDivWidth,
					items:digitRowArry
			
			});		
		}
		else
			comp.add(compItemObj);
	},
	preLoadAjaxSuccess:function(preLoadJson,widgetCountStatus,widgetId)
	{
		if(appConstants.isMultiCompType=='true')
		{
			Ext.getCmp('er_compType').hide();
			Ext.getCmp('compTypeMultiPane').show();
			Ext.getCmp('er_mutiSelComp').show();
		}
		else
		{
			Ext.getCmp('compTypeMultiPane').hide();
			Ext.getCmp('er_mutiSelComp').hide();
			Ext.getCmp('er_compType').show();
		}
		if(appConstants.gridMultiSortEnable != undefined && appConstants.gridMultiSortEnable == 'yes')
		{
			Ext.getCmp('er_secondaryColSort').hide();
		}
		if (appConstants.isCustomLayout=='yes')
		{
			if (preLoadJson.hasOwnProperty("selectedFields"))
			{
				if (preLoadJson.selectedFields.hasOwnProperty("selectedCompTypeWidgets"))
				{
					appConstants.selectedCompTypeWidgets=preLoadJson.selectedFields.selectedCompTypeWidgets;// contains all widgets configured for selected component type
				}
			}
		}
		if(appConstants.method=='submit')
		{
			if (appConstants.isCustomLayout=='yes')
			{
				this.executePerLoadedWidget(preLoadJson,widgetCountStatus,widgetId);
			}
		}
		initLdgMask.hide();
		if(appConstants.hideInputs=='true')
			this.hideComboField();//..for request for GPU overview template to GPU detail template
	},
	executePerLoadedWidget:function(preLoadJson,widgetCountStatus,widgetId)
	{
		var preLoadWidget = Ext.getCmp(widgetId+'_panel');
		preLoadWidget.removeAll();
		customPaging=false;
		var isEnableEditor=false;
		if(neeedEditableHeader=='yes')
			isEnableEditor=true;
		if (preLoadJson.data.hasOwnProperty('widgetCollection'))
		{
			if(widgetCountStatus == true)
			{
				Ext.getCmp('templateFormItms').show();
				Ext.getCmp('panelinsidetoggle').show();
				Ext.getCmp('panelinsidetoggle').setDisabled(false);
			}
			var widgetCollection= preLoadJson.data.widgetCollection;
			if (!Ext.isEmpty(widgetCollection))
			{
				for (var widget in widgetCollection)
				{
					var widgetObject=widgetCollection[widget];
					var testCollection=widgetObject.testCollection;
					var haveMeasuee = false;
					var otherInfo='';
					var chartType = '';
					var chartCollection;
					var widgetIdInfo = widgetObject.widgetId+'_detail'
					var digiChartMinWidth=180;
					if(widgetObject.minWidth != undefined)
						digiChartMinWidth=widgetObject.minWidth;
					var trafficLoad='';
					var responseTime='';
					var error='';
					for (var test in testCollection)
					{
						var testObject=testCollection[test];
						var measureCollection=testObject.measureCollection;
						if(measureCollection != undefined && measureCollection.length > 0)
						{
							for (var measure in measureCollection)
							{
								measureObject=measureCollection[measure];
								if(measureObject.hasOwnProperty('timelineChartCollection'))
								{
									chartType='timeline';
									chartCollection = measureObject.timelineChartCollection;
									if(chartCollection != undefined && chartCollection.length > 0)
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+encodeURIComponent(chartCollection[0].dd_Url);
										chartCollection[0].popUpSeriesClickUrl=preLoadWidget.timelineLink;
									}
									else
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo
										continue;
									}
								}
								else if(measureObject.hasOwnProperty('heatMapChartCollection'))
								{
									chartType='heatMap';
									chartTypeCollection='heatMapChartCollection';
									chartCollection = measureObject.heatMapChartCollection;
									if(chartCollection != undefined && chartCollection.length > 0)
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+encodeURIComponent(chartCollection[0].dd_Url);
										chartCollection[0].popUpSeriesClickUrl=preLoadWidget.timelineLink;
									}
									else
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('barChartCollection'))
								{
									chartType='bar';
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.barChartCollection;
									if(chartCollection != undefined && chartCollection.length > 0)
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+encodeURIComponent(chartCollection[0].dd_Url);
										chartCollection[0].popUpSeriesClickUrl=preLoadWidget.timelineLink;
									}
									else
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('stackedBarChartCollection'))
								{
									chartType='stackedbar';
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.stackedBarChartCollection;
									if(chartCollection != undefined && chartCollection.length > 0)
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+encodeURIComponent(chartCollection[0].dd_Url);
										chartCollection[0].popUpSeriesClickUrl=preLoadWidget.timelineLink;
									}
									else
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('distributedPieChartCollection'))
								{
									chartType='distpie';
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.distributedPieChartCollection;
									if(chartCollection == undefined || chartCollection.length == 0)
									{
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('distributionChartCollection'))
								{
									chartType='pie';
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.distributionChartCollection;
									if(chartCollection != undefined && chartCollection.length > 0)
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+encodeURIComponent(chartCollection[0].dd_Url);
										chartCollection[0].popUpSeriesClickUrl=preLoadWidget.timelineLink;
									}
									else
									{
										preLoadWidget.timelineLink=preLoadWidget.timelineLink+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('gridCollection'))
								{
									chartType='table';
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.gridCollection;
									if(chartCollection == undefined || chartCollection.length == 0)
									{
										continue;
									}
									if(chartCollection != undefined && chartCollection[0] != undefined)
									{
										if(chartCollection[0].gridData != undefined && chartCollection[0].gridData.length < 1 && !isEnableEditor)
											preLoadWidget.setHeight(customPagingHeight);//..
									}
									otherInfo=chartCollection[0].otherInfo;
									if(otherInfo != undefined)
									{
										var dataPageNo = parseInt(otherInfo['dataPageNo']);// current page no
										var isRangeNeed = otherInfo['isRangeNeed'];
										if(isRangeNeed != 'true' && dataPageNo == 1)
										{
											customPaging =false;
										}
										else
										{
											if(!isEnableEditor)
												preLoadWidget.setHeight(customPagingHeight);//..
											customPaging =true;
										}
									}
								}
								else if (measureObject.hasOwnProperty('topnCollection'))
								{
									chartType='topn';
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.topnCollection;
									if(chartCollection == undefined || chartCollection.length == 0)
									{
										continue;
									}
								}
								else if (measureObject.hasOwnProperty('digitalCollection'))
								{
									chartType='digital';
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									}
									chartCollection = measureObject.digitalCollection;
									if(chartCollection == undefined || chartCollection.length == 0)
									{
										continue;
									}
								}
								haveMeasuee = true;
								if(chartType=='digital' && chartCollection!=undefined)
								{
									var digitalArry=[];
									//...digital change									
									if(measureObject.digitalRow != undefined && measureObject.digitalRow=='two')
									{
										var eachColArry=[];
										var s=1;
										for(var k in chartCollection)
										{
											var chartCollectionVal = chartCollection[k];
											var digitalTitle=chartCollectionVal.title==undefined?"":chartCollectionVal.title;
											var dispUnit=chartCollectionVal.unit==undefined?"":chartCollectionVal.unit;
											var digitalTempArry=[];
											var digitalHtm='<table align="center"><tr><td align="right" style="padding-right:5px"><div class="'+chartCollectionVal.imageCls+'" ></div></td>';
											if(chartCollectionVal.url != undefined)
												digitalHtm+='<td style="text-align:left;padding-left:5px;" class="newFont_bold33"><a class="anchorLink" href="javascript:void(0);" onClick="javascript:linkURL(\''+chartCollectionVal.url+'\');">'+chartCollectionVal.value+'<span class=newFont_normal13>'+dispUnit+'</span></a>';
											else
												digitalHtm+='<td style="text-align:left;padding-left:5px;" class="newFont_bold33">'+chartCollectionVal.value+'<span class=newFont_normal13>'+dispUnit+'</span>';
											digitalHtm+='</td></tr></table>';
											digitalTempArry.push({
													html:digitalHtm,
													xtype:'container',												
													width:'100%',
													style:{
														//border:'1px solid green',
														textAlign:'center',
														width:'50px'
													}
												});
											digitalTempArry.push({
												html:'<div class="newFont_normal13" style="margin-top:5px;">'+chartCollectionVal.DisplayName+'</div>',
											});
											if(s%2!=0)
											{
												digitalTempArry.push({
													html:'<div class="newPlainPanelBottomDivider" style="margin-top:10px;position:relative;width:170px"></div>'
												});
											}
											var tempObj={
												xtype:'container',
												align:'center',
												autoSize: true,
												margin:'5 0 5 0',
												layout: 
												{
													type: 'table',
													columns:1,
													align:'center',
													tableAttrs: 
													{
														style: 
														{
															align:'center',
															margin:'auto auto'
														}
													},
													tdAttrs:
													{
														style:
														{
															textAlign:'center'
														}
													}
												},
												defaults: {
													bodyStyle: 'padding:0px 0px 0px 0px',
													align:'center',
												},
												items: digitalTempArry
											};
											eachColArry.push(tempObj);
											if(s%2==0)
											{																	
												var lineUi='newGraphPanel noShadow';
												var bodyCls='newPlainPanelDivider';
												if(s==8)
													bodyCls='';												
												if(s==4)
													lineUi='newGraphPanel noShadow panelShadow';
												digitalArry.push({
													xtype:'panel',
													height:200,
													padding:'0 5 10 5',
													title:'<div class="f13-bold">'+digitalTitle+'&nbsp;</div>',
													layout:{
														type:'vbox',
														align:'stretch',
														//pack:'top',
													},
													ui:lineUi,
													bodyCls:bodyCls,
													items:eachColArry
												});
											}
											if(s%2==0)
											{
												eachColArry=[];
											}
											s++;
										}
										var dataTemp={
										xtype:'container',
										scroll:false,										
										autoScroll:false,
										padding:0,
										margin:0,
										height:200,
										//height:220,
										//height:330,
										flex:1,
										layout:{
											type:'column',
											align:'stretch',
											//align:'center'
										},
										defaults:{
											minWidth:180,
											margin:0,
											columnWidth:(1/4),
											layout:{
												type:'vbox',
												align:'center',
											},
											},
											items:digitalArry,
										};
								
										preLoadWidget.add(dataTemp)
									}
									else if(measureObject.digitalRow != undefined)
									{
										var firstColArry=[];
										var secondColArry=[];
										var thirdColArry=[];
										var forthColArry=[];
										for(var k in chartCollection)
										{
											var chartCollectionVal = chartCollection[k];
											var dispUnit=chartCollectionVal.unit==undefined?"":chartCollectionVal.unit;
											
											if(chartCollectionVal.needHeatMap != undefined && chartCollectionVal.needHeatMap=='yes')
											{
												var heatMapStr='<table cellpadding="0" cellspacing="0" border="0" style="margin:70px 20px 30px 20px;"><tr><td>';
												heatMapStr+='<div class="btmHeatmapDiv" style="border:0px solid red;margin:0px 20px 0px 0px">';
												var healthyCount=chartCollectionVal.healthyCount;
												var slowCount=chartCollectionVal.slowCount;
												var errorCount=chartCollectionVal.errorCount;
												var stalledCount=chartCollectionVal.stalledCount;
												var healthyPer=chartCollectionVal.healthyPer;
												var slowPer=chartCollectionVal.slowCountPer;
												var errorPer=chartCollectionVal.errorCountPer;
												var stalledPer=chartCollectionVal.stalledPer;
												healthyPer = Math.round(healthyPer);
												stalledPer = Math.round(stalledPer);
												slowPer = Math.round(slowPer);
												errorPer = Math.round(errorPer);
												var total = healthyPer+stalledPer+slowPer+errorPer;
												var maxaVal = Math.max(healthyPer,stalledPer,slowPer,errorPer);
												var tolerance = 0;

												if(total!=100)
												{
													tolerance = 100-total;
												}

												if(healthyPer==maxaVal)
												{
													healthyPer=healthyPer+tolerance;
												}
												else if(stalledPer==maxaVal)
												{
													stalledPer=stalledPer+tolerance;
												}
												else if(slowPer==maxaVal)
												{
													slowPer=slowPer+tolerance;
												}
												else if (errorPer==maxaVal)
												{
													errorPer=errorPer+tolerance;
												}

												for(var h=0;h<healthyPer;h++)
												{
													heatMapStr+='<div class="healthyDiv" style="background-color:#69c7b3;"></div>';
												}
												for(var h=0;h<slowPer;h++)
												{
													heatMapStr+='<div class="slowDiv" style="background-color:#f49242;"></div>';
												}												
												for(var h=0;h<stalledPer;h++)
												{
													heatMapStr+='<div class="stalledDiv" style="background-color:#8399b0;"></div>';
												}
												for(var h=0;h<errorPer;h++)
												{
													heatMapStr+='<div class="errorDiv" style="background-color:#ff0059;"></div>';
												}
												heatMapStr+='</div>';												
												heatMapStr+='</td><td><table cellpadding="0" cellspacing="0" border="0" style="margin-bottom:13px;">';
												heatMapStr+='<tbody>';
												heatMapStr+='<tr><td style="padding-left:3px"><div style="background-color:#69c7b3;width:6px;height:6px;border-radius:3px;">&nbsp;</div></td><td style="padding-left:9px;font-size:12px;">Healthy</td><td data-qtip="'+Math.round(healthyCount)+'" style="padding-left:10px;font-size:12px;" class="font_normal12">'+chartCollectionVal.healthyPer+'%</td></tr>';
												heatMapStr+='<tr><td style="padding-left:3px"><div style="background-color:#f49242;width:6px;height:6px;border-radius:3px;">&nbsp;</div></td><td style="padding-left:9px;font-size:12px;">Slow</td><td data-qtip="'+Math.round(slowCount)+'" style="padding-left:10px;font-size:12px;" class="font_normal12">'+chartCollectionVal.slowCountPer+'%</td></tr>';
												heatMapStr+='<tr><td style="padding-left:3px"><div style="background-color:#8399b0;width:6px;height:6px;border-radius:3px;">&nbsp;</div></td><td style="padding-left:9px;font-size:12px;">Stalled</td><td data-qtip="'+Math.round(stalledCount)+'" style="padding-left:10px;font-size:12px;" class="font_normal12">'+chartCollectionVal.stalledPer+'%</td></tr>';
												heatMapStr+='<tr><td style="padding-left:3px"><div style="background-color:#ff0059;width:6px;height:6px;border-radius:3px;">&nbsp;</div></td><td style="padding-left:9px;font-size:12px;">Error</td><td data-qtip="'+Math.round(errorCount)+'" style="padding-left:10px;font-size:12px;" class="font_normal12">'+chartCollectionVal.errorCountPer+'%</td></tr>';
												heatMapStr += '</tbody></table>';
												heatMapStr+='</td></tr></table>';
												secondColArry.push({
													xtype:'container',												
													cls:'summaryChild',
													align:'center',
													html:heatMapStr
												});
											}
											else
											{
												var bottomCls='';	
												var digitalTempArry=[];
												var digitalHtm='<table align="center"><tr><td align="right" style="padding-right:5px"><div class="'+chartCollectionVal.imageCls+'" ></div></td>';
												if(chartCollectionVal.url != undefined)
													digitalHtm+='<td style="text-align:left;padding-left:5px;" class="newFont_bold33"><a class="anchorLink" href="javascript:void(0);" onClick="javascript:linkURL(\''+chartCollectionVal.url+'\');">'+chartCollectionVal.value+'</a>';
												else
													digitalHtm+='<td style="text-align:left;padding-left:5px;" class="newFont_bold33">'+chartCollectionVal.value;
												digitalHtm+='</td></tr></table>';
												digitalTempArry.push({
														html:digitalHtm,
														xtype:'container',												
														width:'100%',
														style:{
															//border:'1px solid green',
															textAlign:'center',
															width:'50px'
														}
													});
												digitalTempArry.push({
													html:'<div class="newFont_normal13" style="margin-top:5px;">'+chartCollectionVal.DisplayName+dispUnit+'</div>',
												});
												if(k==0 || k==3 || k==2)
												{
													digitalTempArry.push({
														html:'<div class="newPlainPanelBottomDivider" style="margin-top:10px;position:relative;width:170px"></div>'
													});
												}
												var tempObj={
													xtype:'container',
													align:'center',
													autoSize: true,
													margin:'5 0 5 0',
													layout: 
													{
														type: 'table',
														columns:1,
														align:'center',
														tableAttrs: 
														{
															style: 
															{
																align:'center',
																margin:'auto auto'
															}
														},
														tdAttrs:
														{
															style:
															{
																textAlign:'center'
															}
														}
													},
													defaults: {
														bodyStyle: 'padding:0px 0px 0px 0px',
														align:'center',
													},
													items: digitalTempArry
												};
														
												if(k==0 || k==4)
												{
													firstColArry.push(tempObj);
													if(k==0)
														trafficLoad=chartCollectionVal.title;
												}
												else if(k==3 || k==6)
												{
													thirdColArry.push(tempObj);
													if(k==3)
														responseTime=chartCollectionVal.title;
												}
												else if(k==2 || k==5)
												{
													forthColArry.push(tempObj);
													if(k==2)
														error=chartCollectionVal.title;
												}
											}
										}
										var firstColObj={
											xtype:'panel',
											//title:'<spanclass="f13-bold" style="text-decoration: underline;">'+trafficLoad+'</span>',
											title:'<spanclass="f14-bold">'+trafficLoad+'</span>',
											margin:'0 0 0 0',
											padding:'2 0 0 5',
											ui:'newGraphPanel noShadow',
											bodyCls:'newPlainPanelDivider',
											//cls:'removePanelBg',
											//height:206,
											//height:176,
											layout:{
												type:'vbox',
												align:'stretch',
												pack:'top',
											},
											items:firstColArry,
										};
										var secondColObj={
											xtype:'panel',
											height:200,
											layout:{
												type:'vbox',
												align:'stretch',
												//pack:'top',
											},
											ui:'newGraphPanel noShadow panelShadow',
											items:secondColArry
										};
										var thirdColObj={
											xtype:'panel',
											margin:'0 0 0 0',
											padding:'0 0 0 5',
											height:200,
											//title:'<span class="f13-bold" style="text-decoration: underline;">'+responseTime+'</span>',
											title:'<span class="f13-bold">'+responseTime+'</span>',
											ui:'newGraphPanel noShadow panelShadow',
											//cls:'panelShadow removePanelBg',
											layout:{
												type:'vbox',
												align:'stretch',
												pack:'top',
											},
											items:thirdColArry
										};
										var forthColObj={
											xtype:'panel',
											margin:'0 0 0 0',
											padding:'0 0 0 5',
											//title:'<span class="f13-bold" style="text-decoration: underline;">'+error+'</span>',
											title:'<span class="f13-bold">'+error+'</span>',
											ui:'newGraphPanel noShadow',
											height:200,
											layout:{
												type:'vbox',
												align:'stretch',
												pack:'top',
											},
											items:forthColArry
										};
										
										digitalArry.push(firstColObj);
										digitalArry.push(secondColObj);
										digitalArry.push(thirdColObj);
										digitalArry.push(forthColObj);		
										var dataTemp={
											xtype:'container',
											scroll:false,										
											autoScroll:false,
											padding:0,
											margin:0,
											height:200,
											//height:220,
											//height:330,
											flex:1,
											layout:{
												type:'column',
												align:'stretch',
												//align:'center'
											},
											defaults:{
												minWidth:180,
												margin:0,
												columnWidth:(1/4),
												layout:{
													type:'vbox',
													align:'center',
												},
											},
											items:digitalArry,
										};
									
										preLoadWidget.add(dataTemp);
									}
									else
									{
										//var digitStyle={'border-right':'1px solid #d9d9d9'};
										var digitStyle='graphSeperatorLineRight';
										var digitSize=chartCollection.length-1;
										for(var k in chartCollection)
										{
										var chartCollectionVal = chartCollection[k];
										var dispUnit=chartCollectionVal.unit==undefined?"":chartCollectionVal.unit;
										var digitFont=chartCollectionVal.font==undefined?'newFont_bold33':chartCollectionVal.font;
										if(k==digitSize)
										{
											digitStyle='';
										}
										var digitalItemArry=[];
										var digitHtml='';
										if(chartCollectionVal.imageCls != undefined)
											digitHtml+='<div class="'+chartCollectionVal.imageCls+'" ></div>';
										digitHtml+='<div class="'+digitFont+'" style="padding:0 5px">'+chartCollectionVal.value+'<span class=newFont_normal13>'+dispUnit+'</span></div>';
										digitalItemArry.push({
												xtype:'container',
												cls:'egFlexCenterByRowWise',
												height:45,
												html:digitHtml,
												//html: '<table align="center" border="2px"><tr><td align="right" style="padding-right:5px"><div class="'+chartCollectionVal.imageCls+'" ></div></td><td style="text-align:left;padding-left:5px" class="'+digitFont+'" >'+chartCollectionVal.value+'<span class=newFont_normal13>'+dispUnit+'</span></td></tr></table>',
												width:'100%',
												// style: 
												// {
												// 	textAlign:'center',
												// 	width:'50px'
												// }
											});
										if(chartCollectionVal.DataSet != undefined && chartCollectionVal.value != undefined && chartCollectionVal.value != '-')
										{
											//var chartWidth=100;
											var chartHeight=15;
											digitalItemArry.push({
												xtype:'container',
												dataIndex:k,
												data:chartCollectionVal,
												height:chartHeight,
												html:'<div id="'+widgetId+'_digital'+k+'"></div>',
												listeners:
												{
													'boxready':function(c){
														try
														{
															var lineChart = {};
															jQuery.extend(true, {}, getHighChartsSparklineInstance(widgetId+'_digital'+this.dataIndex,this.data,this.height,this.width), lineChart);
														}
														catch (e)
														{
															console.log("e::>>>>"+e);
														}
													}
												}
											});
										}
										digitalItemArry.push({
												xtype:'container',
												html:'<span class="newFont_normal13">'+chartCollectionVal.DisplayName+'</span>',
											});
										digitalArry.push({
											xtype:'container',
											align:'center',
											autoSize: true,
										//	style:digitStyle,
											cls:digitStyle,
											layout: 
											{
												type: 'table',
												columns:1,
												align:'center',
												tableAttrs: 
												{
													style: 
													{
														align:'center',
														margin:'auto auto'
													}
												},
												tdAttrs:
												{
													style:
													{
														textAlign:'center'
													}
												}
											},
											defaults: {
												bodyStyle: 'padding:5px',
												align:'center',
											},
											items: digitalItemArry
										});
									}
									var dataTemp={
										xtype:'container',
										padding:'10 0 0 0',
										margin:0,
										//border:true,
										//style:{'border':'2px solid green'},
										scroll:false,
										autoScroll:true,
										flex:1,
										layout:{
											type:'hbox',
											align:'center'
										},
										defaults:{
											minWidth:digiChartMinWidth,
											margin:0,
											flex:1,
											layout:{
												type:'column',
												align:'center',
											},
										},
										items:digitalArry,
									};
									preLoadWidget.add(dataTemp);
									}
								}
								else if(chartCollection!=undefined)
								{
									var chartCollectionTemp=chartCollection[0];
									var chartDataSet=chartCollectionTemp.DataSet;
									if((chartDataSet != undefined && chartDataSet.length>0) || (chartCollectionTemp.gridData != undefined && chartCollectionTemp.gridData.length>0))
										preLoadWidget.add(this.loadWidgetData(widgetId+'_panel',chartCollection[0],widgetIdInfo,chartType,preLoadWidget.getWidth(),preLoadWidget.getHeight()-5));
									else
										haveMeasuee = false;
								}
								else
								{
									haveMeasuee = false;
								}
								if(otherInfo != '' && otherInfo != undefined)
								{
									var customgridObj=Ext.getCmp('customgridId'+widgetId+'_panel');
									if(fromPerBtn)
										customgridObj.getStore().loadPage(activePage);
									this.loadOverAllPageNavigation('pageingTool'+widgetObject.widgetId+'_panel',otherInfo,'customPageinationId'+widgetObject.widgetId+'_panel');			
									fromPerBtn = false;
								}
							}
							if(!haveMeasuee)
							{
								preLoadWidget.setAutoScroll(false);
								if((customPaging || (chartType != undefined && chartType == 'table')) && !isEnableEditor)
								{								
									preLoadWidget.setHeight(customPagingHeight);//..
								}
								var noMesureHei = preLoadWidget.getHeight()-50;
								if(noMesureHei > 105){
										preLoadWidget.add({
										xtype:'container',
										height:preLoadWidget.getHeight()-50,										
										html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
									});
								}else{
										preLoadWidget.add({
										xtype:'container',
										height:preLoadWidget.getHeight()-50,										
										html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom_small.png" /></td></tr></table>'
									});
								}
								
							}
						}
						else
						{
							preLoadWidget.setAutoScroll(false);
							if((customPaging || (widgetObject.chartType != undefined && widgetObject.chartType == 'table')) && !isEnableEditor)
							{
								preLoadWidget.setHeight(customPagingHeight);//..
							}
							if(testObject.noMeasureMessage != undefined)
							{
								var noMeasureHtml='<table width="100%" height="100%"><tr><td align="center" valign="middle" class="newFont_normal12">';
								if(testObject.noMeasureIcon != undefined)
									noMeasureHtml+='<div class="'+testObject.noMeasureIcon+'"></div>';
								noMeasureHtml+='<div>'+testObject.noMeasureMessage+'</div>';
								noMeasureHtml+='</td></tr></table>';
								preLoadWidget.add({
									xtype:'container',
									height:preLoadWidget.getHeight()-50,
									html:noMeasureHtml
								});
							}
							else
							{
								preLoadWidget.add({
									xtype:'container',
									height:preLoadWidget.getHeight()-50,
									//html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
									html:'<table width="100%" height="100%"><tr><td align="center" valign="middle" class="newFont_normal12"><div class="iconInformation"></div><div>No Measures Available!</div></td></tr></table>'
								});
							}
						}
					}
				}
				if(widgetCountStatus == true)
				{
					Ext.getCmp('selectionDetails').setSelectionDetailsData(preLoadJson.selectionDetails);
				}
			}
			else
			{				
				preLoadWidget.setAutoScroll(false);			
				if(customPaging && !isEnableEditor)
					preLoadWidget.setHeight(customPagingHeight);//..
				preLoadWidget.add({
					xtype:'container',
					height:preLoadWidget.getHeight()-50,
					html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
				});
			}
		}
	},
	gridCustomPaging:function(paneInfo)
	{
		var me  = this;
		var paneInfoId = paneInfo.id;
		var thispanel = Ext.getCmp(paneInfoId);
		var initMask = new Ext.LoadMask(thispanel.getEl(),{msg : "Loading ..."});
		initMask.show();
		var url='/final/reporter/ReportBuilderController.jsp';
		var widgetId  = paneInfoId.substring(0,paneInfoId.indexOf("_"));
		if(widgetId.indexOf('customgridId') != -1)
			widgetId=widgetId.substring(widgetId.indexOf('customgridId')+12);
		keepResult = true;
		var paramVal= me.ajaxQueryMaker(Ext.getCmp('submit'));
		paramVal+='&widget='+widgetId;
		paramVal+='&tempDesc='+appConstants.tempDesc;
		if(appConstants.method=='submit')
			thispanel.timelineLink='/final/reporter/ErReportBuilderDrillDown.jsp?'+paramVal+'&isSubmit=true';
		distributedPieUrl=me.getQueryString(true);
		Ext.Ajax.request({
			url:url,
			params:paramVal,
			async:false, 
			scope:this,
			success : function(response){
				if(response.responseText.length>0)
				{
					initMask.hide();
					var preLoadJson = Ext.decode(response.responseText);
					me.preLoadAjaxSuccess(preLoadJson,false,widgetId);
				}
			},
			failure:function(err){
				Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
			}
		});	
	},
	addToolBarItems:function(items)
	{
		if(Ext.isArray(items)){
			var toolbar = {
				xtype:'toolbar',
				padding:'6 0 3 0',
				bodypadding:0,
				margin:'0 0 0 0',
				border:false,
				items:items
			}
			return toolbar;
		}
		else
		{
			alert('error in  @param, use as array [{..},{..}]');
		}
	},
	getDynamicRangesInfo:function()
	{
		var rangeSettingArray = new Array();
		var rangeSettingsItemsId= Ext.getCmp('rangeSettingsItemsId');
		if(!rangeSettingsItemsId.isHidden() && rangeSettingsItemsId.items!=undefined)
		{
			for(var i=0;i<rangeSettingsItemsId.items.length;i++)
			{
				var addedStr=Ext.getCmp('dynamicRangeCombo_'+i).fieldLabelValue+'~'
				addedStr+=Ext.getCmp('dynamicRangeCombo_'+i).getValue()+'*';
				if(Ext.getCmp('dynamicRangeCombo_'+i).getValue()=='None')
					addedStr+='0';
				else
					addedStr+=Ext.getCmp('disp_MeasureName'+i).getValue();
				rangeSettingArray.push(addedStr);
			}
		}
			return rangeSettingArray;
	},
	getDynamicColorInfo:function()
	{
		var colourComp=Ext.getCmp('colourSettingsItemsId');
		var totalColorInfo=new Array();
		if(!colourComp.isHidden() && colourComp.items.items!=undefined)
		{
			for(var v=0;v<colourComp.items.items.length;v++)
			{
				var eachDispName='';
				var dispMeas='';
				var colorInfo='';
				var eachDisp=colourComp.items.items[v].items.items;
				var eachDispLength=eachDisp.length-1;
				for(var t=0;t<=eachDispLength;t++)
				{
					var eachObj=eachDisp[t];
					if(t==0)
						dispMeas=eachObj.value;
					else
					{
						if(eachObj.xtype == 'image')
							colorInfo+=eachObj.cls+'$';
						if(eachObj.xtype != 'image')
						{
							//colorInfo+=eachObj.fieldLabel+'*'+eachObj.fieldLabelValue+'*'+eachObj.value+'|';
							colorInfo+=eachObj.fieldLabel+'*'+eachObj.fieldLabelValue+'*'+eachObj.value;
							if(t!=eachDispLength)
								colorInfo+='|';
						}
					}
				}
				//if(colorInfo.endsWith("|"))
					//colorInfo=colorInfo.substring(0,colorInfo.lastIndexOf("|"));
				totalColorInfo.push(dispMeas+'~'+colorInfo);

			}
		}
		return totalColorInfo;
	},
	exportDataAlert:function()
	{
		Ext.MessageBox.show({
			title: 'Alert',
			msg: 'Exporting the report may take too long to complete. Choose the Background option to export this report',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	},
	openSmallPopupWindow:function(btn)
	{
		var me = this;
		if(Ext.isEmpty(Ext.getCmp('GenericWindowId')))
		{
			var me= this;
			var gWindow = Ext.create('Ext.tip.ToolTip', {
				anchor:'top',
				anchorToTarget:true,
				//anchorOffset:Ext.get(btn.id).getY() - (50),
				anchorOffset:252,
				target:btn.id,
				scroll: false,
				autoHide:false,
				padding: 0,
				header : {
					width: 30,
				},
				width:310,
				heigth:245,
				layout: {
					type : 'vbox',
					align: 'stretch'
				},
				flex:1,
				bodyPadding:0,
				border:false,
				id:'GenericWindowId',
				closeAction: 'destroy',
				closable:true,
				//ui:'newTooltipPopup',
				ui:'newTooltipCommentPopup',
				title:'Comments',
				tools:[
					me.addToolBarItems([
						{
							xtype: 'container',
							margin:'-2px 0 0 0',
							html:'<div class="checkGroupClear" style="width:46px;height:16px;cursor:pointer;float:right;text-align:center;"><span style="text-decoration:underline;font-size:11px;" class="clearCommentText">Clear</span></div>',
							id:'noteDelete',
							listeners:
							{
								'afterrender':function()
								{
									this.getEl().on('click', function(event, target, options)
									{
										Ext.getCmp('NotesTextAreaId').setValue('');
									});
								}
							}
						}
					])
				],
				listeners:{
					hide:function(){
						if(!Ext.isEmpty(Ext.getCmp('GenericWindowId'))){
							Ext.getCmp('GenericWindowId').doClose();
						}
					},
					el:{
						'mouseenter':function(){
							if(!Ext.isEmpty(Ext.getCmp('GenericWindowId'))){
								//Ext.getCmp('GenericWindowId').show();
							}
						},
						'mouseleave':function(){
							if(!Ext.isEmpty(Ext.getCmp('GenericWindowId'))){
								//Ext.getCmp('GenericWindowId').doClose();
							}
						}
					}
					
				},
				close:function()
				{
					var noteValue = Ext.getCmp('NotesTextAreaId').getValue();
					noteValue = noteValue.trim();
					var widgetId = btn.id;
					if(widgetId.indexOf('_')>-1)
					{
						widgetId = widgetId.substring(0,widgetId.lastIndexOf('_'));
					}
					if(noteValue.length==0)
					{
						if(btn.iconCls='iconCommentSmall')
						{
							btn.setIconCls('iconNoCommentSmall');
						}
						else if(btn.iconCls!='iconNoCommentSmall')
						{
							btn.setIconCls('iconNoCommentSmall');
						}
					}
					else
					{
						if(btn.iconCls='iconNoCommentSmall')
						{
							btn.setIconCls('iconCommentSmall');
						}
						else if(btn.iconCls!='iconCommentSmall')
						{
							btn.setIconCls('iconCommentSmall');
						}
					}
					btn.noteValue = noteValue;
					var url='/final/reporter/ReportBuilderController.jsp';
					var controller=appConstants.appObj.getController(appConstants.appController);
					var params='&widgetHeaderFooterInfo='+encodeURIComponent(noteValue);
					params+='&method=setWidgetHeaderFooter';
					params+='&isCustomLayout='+appConstants.isCustomLayout;
					params+='&templateName='+appConstants.templateName;
					params+='&idDescription='+appConstants.templateName+"$~$"+widgetId+"$~$"+"footerDescription";;
					controller.callAjax(url,params,false,true,true);
					this.doClose();
				},
				items:[
					{
						xtype:'textareafield',
						grow:false,
						padding: 0,
							bodyPadding:0,
						margin:'0 10 10 10',
						heigth:145,
						layout : {
							type :'vbox',
							align: 'stretch'
						},
						rows: 5,
						flex:1,
						
						//readOnly:true,
						width:310,
						cls:'textarea commentBox',
						name:'NotesTextAreaId',
						id:'NotesTextAreaId',
						fieldLabel: '',
						value:btn.noteValue
					}
				]
			}).showAt([Ext.get(event.target).getX() - 265,Ext.get(event.target).getY() + 28]);

		}
		Ext.getCmp('NotesTextAreaId').focus();
	}
});
