Ext.define('ReportBuilder.view.CustomTextField', {
	extend: 'Ext.form.FieldContainer',
	alias: 'widget.customTextField',
	fieldLabel:'Web Application(s)',
	layout: 'column',
	id:'customTextField',
	width:200,
	hidden:true,
	items:[
		{
			xtype: 'textfield',
			cls: 'textbox',
			columnWidth:.80,
			value:'',
			margin:'0 5 0 0',
			//maskRe: /[A-Za-z0-9 .,\]/,
			readOnly:true,
			id: 'er_webAppCombo',
			name:'er_webAppCombo'
		},
		{
			xtype: 'button',
			iconCls: 'iconMultiselectExpand',
			tooltip: '<b>Web Application(s)</b>',
			columnWidth:.20,
			style:
			{
				 background: 'none',
				 border: '0px'
			},
			handler:function(obj)
			{
				var ddTxtValue=Ext.getCmp('er_webAppCombo').getValue();
				Ext.create('Ext.window.Window',{
					//width:240,
					width:350,
					id:'WebAppSubWindow',
					border:false,
					frame:false,
					modal: true,
					ghost: false,
					header:false,
					id:'expandWindow',
					//height:250,
					style:{
						'background':'transparent !important'
					},
					bodyStyle:{
						'background':'transparent !important'
					},
					ui:'newPopupWindow',
					//padding:'0 10 5 10',
					buttonAlign:'center',
					listeners:
					{
						show: function (win) {
							if (this.modal) {
								var dom = Ext.dom.Query.select('.x-mask');
								for (var y = 0; y < dom.length; y++) {
									var el = Ext.fly(dom[y]);
								}
							el.addCls('windowModalNoBg');
							}
						},

						hide: function (win) {
							var dom = Ext.dom.Query.select('.x-mask');
							if (this.modal) {

								var el = Ext.fly(dom[0]);
								el.removeCls('windowModalNoBg');
							}
						},
						
						afterrender: function () {
							Ext.EventManager.onWindowResize(function () {
								var me = this;
								me.center();
							}, this);
						},
					},
					doClose: function() {
						var me = this;
						Ext.getCmp('expandWindow').setDisabled(false);
						// Being called as callback after going through the hide call below
						if (me.hidden) {
							me.fireEvent('close', me);
							if (me.closeAction == 'destroy') {
								this.destroy();
							}
						} else {
							// close after hiding
							me.hide(me.animateTarget, me.doClose, me);
						}
					},
					items:[
					{
						xtype: 'panel',
						title:'Web Application(s)',
						margin: 5,
						layout:{
							type:'vbox',
							pack:'center',
							align:'stretch'
						},
						buttonAlign:'center',
						ui:'newFormFieldsInPopup',
						items: [{
									xtype: 'container',
									width: 220,
									margin: '0px 10px 0px 10px',
									items: [{
										xype: 'container',
										cls:'multisearchlist',
										items: [
										{
											xtype: 'customtrigger',
											labelAlign: 'top',
											cls: 'whitedropdown_search',
											emptyText: 'Search Web Application(s)',
											id: 'WebAppSearch',
											listeners:
											{
												afterrender:function()
												{
													Ext.getCmp('WebAppSearch').setWidth(305);
												},
												change:function(obj)
												{
													obj.toggleTriggger();
													if (Ext.isEmpty(appConstants.erUtils))
														appConstants.erUtils = Ext.widget("erutils");
													//appConstants.erUtils.filterComboStore(obj,Ext.getCmp('componentsClone'),appConstants.publicJsonData.combo.webAppCombo);
												}
											}
										}],
									}]
								},
								{
									xtype: 'multiselect',
									width:'100%',
									height:237,
									margin:'0 10 0 10',
									layout: 'fit',
									border : 0,
									autoScroll:false,
									//maxSelections:1,
									scroll:false,
									labelAlign:'left',
									baseCls: 'egmultiselect',
									multiSelect: true,
									id: 'componentsClone',
									name: 'componentsClone',
									store: new Ext.data.Store({
										fields: ['displayField', 'valueField'],
										data: []
									}),
									value: [],
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local',
									listeners:
									{
										afterrender: function ()
										{
											this.getStore().loadRawData(webAppCombo);
											this.setValue(ddTxtValue);
										}
									}
								},
								{
									xtype:'container',
									layout:{
										type:'hbox',
										pack:'center'
									},
									items:[{
											xtype:'button',
											text: typeof selectTxt !== 'undefined' ? selectTxt:'Select',
											id: 'expand',
											margin:'10 10 10 10',
											ui:'newButtonSmall',
											name: 'expand',
											handler: function()
											{
												var selectedVal = Ext.getCmp('componentsClone').getValue();
												if(selectedVal.length==0)
												{
													 Ext.MessageBox.show({
														title: 'Alert',
														msg: 'Please Choose Web Application(s)',
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
													});
													return;
												}
												else if(selectedVal.length>1 && selectedVal.indexOf('All')>-1)
												{
													 Ext.MessageBox.show({
														title: 'Alert',
														msg: 'All Web App and Individual selection cannot be selected simultaneously!',
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
													});
													return;
												}
												if ( Ext.getCmp('componentsClone').getValue() != '')
												{
													var comboVal= Ext.getCmp('componentsClone').getValue();
													Ext.getCmp('er_webAppCombo').setValue(comboVal);
													appConstants.lastInfoAccessFromWeAppCombo='true';
													var param = 'isCustomLayout='+appConstants.isCustomLayout+'&method=getWebApp';
													for(var i = 0;i<selectedVal.length;i++)
													{
														param += '&er_webAppCombo='+selectedVal[i];
													}
													Ext.Ajax.request({
														url:'/final/reporter/ReportBuilderController.jsp',
														params:param,
														async:true, 
														scope:this,
														success : function(response){
															if(response.responseText.length>0)
															{
																var responseStr = Ext.decode(response.responseText);
																var er_infoComb=Ext.getCmp('er_info');
																er_infoComb.getStore().loadRawData(responseStr.combo);
																er_infoComb.setValue(responseStr.selectedFields.selectedCustomInfo);
																this.up('window').destroy();
															}
														},
														failure:function(err){
															Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
														}
													});
												}
											}
										}]
								}
							],
							tools:[
							{
								xtype:'button',
								iconCls: 'iconCloseNew',
								listeners: {
									afterrender: function () {
										Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: typeof close !== 'undefined' ? close:'Close'
										});
									},
									click:function(){
										Ext.getCmp('expandWindow').doClose();
									}
								},
								style: {
									background: 'none',
									border: '0px'
								}
							}],
						}],
			}).show();
			}
		}
	]
});

