Ext.define('ReportBuilder.view.EgComponentType', {
    extend: 'Ext.form.FieldContainer',
    alias: 'widget.egcomponenttype',
    layout: 'vbox',
    id: 'compTypeMultiPane',
	labelAlign:'top',
	labelSeparator:'',
	fieldLabel:'Component Type',
	hidden:true,
    margin: '10 0 0 0',
    items: [
		{
			xtype: 'container',
			layout: 'hbox',
			items: [
				{
					xtype: 'container',
					width: 220,
					//margin: '0px 0px 0px 0px',
					margin: '0px 0px 10px 0px',
					items: [
						{
							xype: 'container',
							cls: 'multisearchlist',
							items: [{
								xtype: 'trigger',
								labelAlign: 'top',
								id: 'compTypeSearch',
								name: 'compTypeSearch',
								enableKeyEvents: true,
								emptyText: 'Search Component Type',
								cls: 'whitedropdown_search',
								width: 205
							}]
						}, 
						{
							xtype: 'multiselectfield',
							width: 220,
							autoScroll: false,
							scroll: false,
							height: 90,
							labelAlign: 'left',
							//ddReorder: true,
							allowBlank: false,
							id: 'er_mutiSelComp',
							name: 'er_mutiSelComp',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local'
						}
					]
				}, 
				{
					xtype: 'container',
					margin: '10px 5px 0 5px',
					items: [
						{
							xtype: 'button',
							iconCls: 'iconMultiselectExpand',
							id: 'expandSelectorCompType',
							listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Component Type'
											});
										}
									},
							style: {
								background: 'none',
								border: '0px'
							}
						}
					 ]
				}
			]
		}
	]
 });