Ext.define('ReportBuilder.view.Gridster', {
	extend:'utilities.gridsterPanel',
	alias: 'widget.gridster',
	requires:['utilities.gridsterPanel'],
	id:'widgetLayoutPane',
	margin:'0 5',
	flex:1,
	count:0,
	closeAction:'destroy',
	items:[],
	layoutStyle:{
		"type":"linear",
		"min_cols":2,
		"max_cols":2,
		"widget_base_dimensions":[widget_baseWidth, widget_baseHeight],
		"resizeWidget":true,
		"dragWidget":true
	},//linear,tabular,relative,custom 
	//resizeWidget:true,
	frame:false,
	//scroll:true,
	//autoScroll:true,
	cls:'gridster',
	tpl: '<tpl for="."><div id="{id}" class="portlet gs-w x-container x-container-default" data-row="{row}" data-col="{col}" data-sizex="{size_x}" data-sizey="{size_y}" data-type="{widgetType}"  data-icon="{widgetIcon}"></div></tpl>',
	data:[],
	initComponent:function(){
		// TODO
		var gridsterPanel = this;
		/* gridsterPanel.data = [
			{id :"panel1",row:1,col:1,size_x:1,size_y:1,widgetType:"table",widgetIcon:"tableCls"},
			{id :"panel2",row:1,col:1,size_x:1,size_y:1,widgetType:"grid",widgetIcon:"girdCls"}
		] */
		gridsterPanel.renderPanel();
		var gridsterItems = gridsterPanel.items;
		var itemsLength = gridsterItems.length;
		if(itemsLength == 0){
			//console.log('NO ITEM FOUND')
		}
		else
		{
			gridsterPanel.on('resize', gridsterPanel.loadGridSter, gridsterPanel);
		}
		
		gridsterPanel.callParent();
		
	},
	/*
	* To get hold of the API object, 
	* use the jQuery data method like so
	*/
	getGridsterObj:function(){
		var gridster = $(".gridster").gridster().data('gridster');
		return gridster
	},
	/* 
	* Adding the toolbar dynamically in each widget
	*/
	addToolBarItems:function(items){
		var gridsterPanel = this;
		if(Ext.isArray(items)){
			var toolbar = {
				xtype:'toolbar',
				items:items
			}
			return toolbar;
		}else{
			alert('error in  @param, use as array [{..},{..}]');
		}
		

	},
	/**
	* Loading the gridster.js api
	* Return gridster object
	*/
	loadGridSter:function(){
				var gridsterPanel = this,min_cols,max_cols,widget_base_dimensions,config,result=[];	
				var gridsterObj = $(".gridster").gridster({
							widget_margins: [5, 5],
							//min_cols: gridsterPanel.layoutStyle.min_cols,
							//max_cols:gridsterPanel.layoutStyle.max_cols,
							//widget_base_dimensions:[gridsterPanel.up('panel').body.getWidth()*3,200],
							autogenerate_stylesheet:true,
							widget_base_dimensions:gridsterPanel.layoutStyle.widget_base_dimensions,
							draggable: 
								{
									enabled: true,
									scroll:true,
									start: function(e, ui, $widget) 
									{
									},
									drag: function(e, ui, $widget) 
									{
									},
									stop: function(e, ui, $widget) 
									{
									 
									   var newpos = this.serialize($widget)[0];
									   console.log("New col: " + newpos.col + " New row: " + newpos.row);
									}
							},
							resize: {
							enabled:gridsterPanel.layoutStyle.resizeWidget,
							start:function(e, ui, $widget){
								
							},
							resize:function(e, ui, $widget){
								 Ext.suspendLayouts();
								 Ext.getCmp($widget[0].getAttribute('id')+'_panel').setSize($widget.width(), $widget.height());
								 Ext.resumeLayouts(true);
							},
							stop: function(e, ui, $widget){
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').suspendEvents(true);
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').setSize($widget.width(), $widget.height());
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').resumeEvents( );
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').doComponentLayout();
							}	
						},
						widget_selector: "div.portlet",
						serialize_params: function($w, wgd) {
							//console.log(wgd);
								return {
									id: $w[0].id,
									col: wgd.col,
									row: wgd.row,
									size_x: wgd.size_x,
									size_y: wgd.size_y
								};
						}
						
				}).data(gridsterObj);
			// Drag method will be disabled if false
			if(gridsterPanel.layoutStyle.dragWidget == false){
				gridsterObj.gridster.disable();
			}

			gridsterPanel.doComponentLayout();
			return gridsterObj;

	},
	/**
	* Responsive panel when resize window
	*/
	beResponsive:function($widgets){
		var gridsterPanel = this;	
		if($widgets){
			$.each($widgets, $.proxy(function (index,element) {
				$($($widgets[index]).attr('id')).trigger('resize');
			}, $widgets));
		}

	},
	/**
	* Rendering the Ext panel in gridster widget
	* see @ addPanel() method
	*/
	renderPanel:function(){
		var gridsterPanel = this;
		console.log(gridsterPanel.data);
		Ext.each(gridsterPanel.data, function(obj){
				Ext.defer(function(){
					console.log(obj);
					gridsterPanel.addPanel(obj.id,Ext.fly(obj.id).getWidth(),Ext.fly(obj.id).getHeight(),obj.widgetType,obj.widgetIcon);
				},100);
		});
	},
	/**
	* Array of objects with representing the current 
	* position of the widgets who have changed position., 
	* ready to be encoded as a JSON string
	*/
	getGridSterChangedPositions:function(){
		var gridsterPanel = this;
		return gridsterPanel.loadGridSter().gridster.serialize_changed( );
	},
	/**
	* Array of objects with positions of all widgets, 
	* ready to be encoded as a JSON string
	*/
	gridsterSerialize:function(){
		var gridsterPanel = this;
		return gridsterPanel.loadGridSter().gridster.serialize();
	},
	/**
	* Load the data based on @parma {type}
	* Called in @addPanel method
	*/
	loadWidgetData:function(panlid,chartCollection,widgetIdInfo,height,chartType){
		appConstants.chartType='highchart';
		var gridsterPanel = this;
		var doms = [];
				
		/*var htmlContent='<div id="submitreport0_table" style="width:100%"><table width="100%" border="0" class="htmlTable"><col width="50%"><col width="50%"><tr><td style="padding:0px 0px 0px 0px"><div width="100%" class="mainDiv">'
				
		 if (chartCollection[0].hasMonthOrWeekGroup != undefined && chartCollection[0].hasMonthOrWeekGroup=='yes')//..
		{
			//alert("=========without groupby date=>>>>>>>");
			
			var dom='img_'+0+'_'+widgetIdInfo;
			doms.push(dom);
			htmlContent+='<div id="'+dom+'" style="height:'+height+'px;width:100%;" class="htmlTableBody">';
			htmlContent+='</div>';
			htmlContent+='</div></td></table></div>';
		}
		else
		{
			htmlContent+='</div></td></table></div>';
		} */
		var box ={};
		console.log(chartCollection)
		if(chartType=='table'||chartType=='topn')
		{
			box=this.getGrid(chartCollection[0].gridColums,chartCollection[0].gridData,chartCollection[0].title,chartCollection[0].sortIndex);
		}
		else
		{
			box = 
			{
				xtype:'container',
				cls:'containerShadow',
				data:chartCollection[0],
				sortable: true,
				autoScroll:true,//..
				//margin:5,
				id:panlid+'_chart',
				closeAction:'destroy',
				layout:{type:'hbox',align:'stretch',pack : 'center'},
				flex:1,
				listeners: 
				{
					'boxready':function(c){
						try
						{					
							var datte=chartCollection[0];							
							if(chartType=='distpie')
							{
								appConstants.erUtils.updateDistributedPieChart(widgetIdInfo,ip,appConstants.chartType,datte,'pieColors','urlLinks','pieLabels',datte.chartTitle,datte.XML,datte.swfpath,datte,this);
							}
							else if(chartType=='pie')
							{
								appConstants.erUtils.updatePieChart(appConstants.chartType,datte,'pieColors','urlLinks','pieLabels',datte.chartTitle,datte.XML,datte.swfpath,datte,this);
							}
							else if (chartType=='timeline' && this.data.hasMonthOrWeekGroup=='yes')//..
							{
								var lineChart = {};	
							
								lineChart = jQuery.extend(true, {}, getHighChartsInstance(c.id,"",""), lineChart);
								lineChart.setData(datte,'MMM dd, yyyy','');
								lineChart.drawChart();			
							}
							else 
							{
								appConstants.erUtils.updateBarChart(appConstants.chartType,datte.chartTitle,datte.XML,datte.swfpath,datte,datte.chartHeight-20,datte.chartWidth,this);//..
							}		
						}
						catch (e)
						{
							console.log("e::"+e);
						}
						
					}
				}
			}
		}
		return box;
	},
	/**
	* Creating the Ext.panel and returning the panel object 
	* This object is render into gridster widget 
	* see @ renderPanel() method
	*/
	addPanel:function(renderto_id,width,height,title,footer,icon,widgetObj,widgetIdInfo){
		var gridsterPanel = this;
		var chartCollection=[];
		var chartType='';
		var drillDownUrl='',csvInfoUrl='',gridInfoUrl='';
		var drillDownUrlFlag=true , csvInfoUrlFlag=true,gridInfoUrlFlag=true;
		
		if(widgetObj.hasOwnProperty('timelineChartCollection'))
		{
			drillDownUrlFlag=false; 
			csvInfoUrlFlag=false;
			gridInfoUrlFlag=false;
			chartType='timeline';
			
			chartCollection = widgetObj.timelineChartCollection;
			
			drillDownUrl=timelineurl+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+chartCollection[0].dd_Url;//..
			
		}
		else if (widgetObj.hasOwnProperty('barChartCollection'))
		{
			drillDownUrlFlag=false; 
			chartType='bar';
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			chartCollection = widgetObj.barChartCollection;
			
			drillDownUrl=timelineurl+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+chartCollection[0].dd_Url;//..
			
		}
		else if (widgetObj.hasOwnProperty('stackedBarChartCollection'))
		{
			drillDownUrlFlag=false; 
			chartType='stackedbar';
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			chartCollection = widgetObj.stackedBarChartCollection;
			drillDownUrl=timelineurl+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&isDDEnabled='+chartCollection[0].isDDEnabled+'&dd_Url='+chartCollection[0].dd_Url;
			
		}
		else if (widgetObj.hasOwnProperty('distributedPieChartCollection'))
		{
			chartType='distpie';
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			chartCollection = widgetObj.distributedPieChartCollection;
		}
		else if (widgetObj.hasOwnProperty('distributionChartCollection'))
		{
			chartType='pie';
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			chartCollection = widgetObj.distributionChartCollection;
		}
		else if (widgetObj.hasOwnProperty('gridCollection'))
		{
			chartType='table';
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			chartCollection = widgetObj.gridCollection;
		}else if (widgetObj.hasOwnProperty('topnCollection'))
		{
			chartType='topn';
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			chartCollection = widgetObj.topnCollection;
		}
		
		gridInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+appConstants.appObj.getController(appConstants.appController).getQueryString()+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&pdfPrint=yes&pdfprint=yes';
		
		csvInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+appConstants.appObj.getController(appConstants.appController).getQueryString()+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&option=csv';
	
		console.log(chartCollection)
		
		var panel = new Ext.create('Ext.panel.Panel',{
			closeAction:'destroy',
			cls:'datapanel',
			headerEditor:function(cmp){ 
			headerCmp = cmp.getHeader().titleCmp;
				var el = Ext.get(cmp.getHeader().id+'_hd-'+headerCmp.childEls[0]);
				el.on('click',function(){
				 var editor = new Ext.Editor({
					alignment:"tl",
					updateEl: true,
					field: {
						xtype: 'textfield'
					}
				});
				editor.startEdit(el);
			},cmp.getHeader()); 
			},
			layout:{type:'vbox',align:'stretch'},
			id:renderto_id+'_panel',
			title:title,
			items:[
				gridsterPanel.loadWidgetData(renderto_id+'_panel',chartCollection,widgetIdInfo,height,chartType)
			],
			dockedItems: 
			[{
				xtype: 'label',
				dock:'bottom',
				id:appConstants.templateName+"$~$"+widgetIdInfo+"$~$"+"footerDescription",
				style:{'font-size':'12px'},
				margin:10,
				text:footer,
				listeners: {
				afterrender:function(obj){
					obj.el.on('dblclick',this.onEdit,this);
					},				
				},				
				onEdit: function(event, element,obj) {
					var me = this;
					
					if(!me.editor) {
						me.editor = Ext.create('Ext.Editor', {
							updateEl: true,
							completeOnEnter: true,
							cancelOnEsc: true,
							autoSize: {
								// ref to doc http://docs.sencha.com/extjs/4.1.1/#!/api/Ext.Editor-cfg-autoSize
								//width: 'boundEl',
								height:150,
							},
							hideEl: false,
							offsets: [-5,0],
							field: {
								xtype: 'textfield',
								cls: 'headerTextEdit',
								maxLength:32,
								enforceMaxLength: true
							},
							listeners: {
								complete: {
									fn: function(self, value, startValue, opts) {												
										var url='/final/reporter/ReportBuilderController.jsp';
										var controller=appConstants.appObj.getController(appConstants.appController);
										var params='&widgetHeaderFooterInfo='+value;
										params+='&method=setWidgetHeaderFooter';
										params+='&templateName='+appConstants.templateName;
										params+='&idDescription='+appConstants.templateName+"$~$"+widgetIdInfo+"$~$"+"footerDescription";
										controller.callAjax(url,params,false,true);
									},
									scope: me,
								}
							}
						});
					}
					me.editor.startEdit(element);
				}
			}],
			tools:[
			gridsterPanel.addToolBarItems([	
				{
				//type: 'gear',
					xtype: 'button',
					cls:'iconData',
					style:{'border':'0px'},
					width:16,
					height:16,
					margin:'0 5 0 0',
					hidden:gridInfoUrlFlag,
					handler:function(){
						//appConstants.appObj.getController(appConstants.appController).getMessageBox('am ','testing');
						parent.printWindowFn(gridInfoUrl);
					}
				},
				{
					xtype: 'button',
					width:16,
					height:16,
					margin:'0 5 0 0',
					style:{'border':'0px'},
					cls: 'iconCsv',
					hidden:csvInfoUrlFlag,
					handler:function(){
						window.location=csvInfoUrl;
					}
				},
				{
					xtype: 'button',
					width:16,
					height:16,
					style:{'border':'0px'},
					cls: 'iconMaximize',
					hidden:drillDownUrlFlag,
					handler:function(){
						parent.maximizeWindowLightBox(drillDownUrl);
					}
				}
				
			])	
			],
			listeners:{
				'afterrender':function(cmp){
						cmp.headerEditor(cmp);
					},
				'beforeclose':function(panel) {
					if(panel.panelClose) {
						panel.panelClose = false;
						return true;
					}
					Ext.Msg.show({
						 title:'Close confirmation',
						 msg:'Really close?',
						 buttons:Ext.Msg.YESNO,
						 callback:function(btn) {
							if('yes' === btn) {
								panel.panelClose = true;
								// animation 
								panel.el.slideOut('t', {
								easing: 'back-in',
								duration: 100,
								callback: function(){
									// Execute my custom method after the animation
									Ext.destroy(panel);
									gridsterPanel.removeWidget(renderto_id);
								},
								scope: panel
								});
							}
						}
					});
					return false;
				}
			},
			width:width -2,
			height:height,
			renderTo:renderto_id
		});
		return panel;
	},
	/**
    * Adding widget to the layout
	* Getting the ID of the widget and rendering the Ext.panel 
	* See addPanel() method
	* Updating the data
    */
	addWidget:function(chartType,footer,sizeX,sizeY,row,col,widgetObj,iconCls,widgetIdInfo){
		var gridsterPanel = this;
		var dyId = 'widget'+gridsterPanel.count++;
		console.log(gridsterPanel.count ++);
		gridsterPanel.suspendEvents();
		//BASED OF LAYOUT type have to change the logic
		if(gridsterPanel.data){
			newData = {"id":dyId,"row":row,"col":col,"size_x":sizeX,"size_y":sizeY,"widgetType":chartType,"widgetIcon":iconCls};
			gridsterPanel.data.push(newData);	
		}

		gridsterPanel.loadGridSter().gridster.add_widget.apply(gridsterPanel.loadGridSter().gridster, 
		['<div id="'+dyId+'" class="portlet gs-w x-container x-container-default" data-type="'+newData.widgetType+'"  data-icon="'+newData.widgetIcon+'"></div>',
		newData.size_x,
		newData.size_y
		]);
		// TODO
		gridsterPanel.addPanel(dyId,Ext.fly(dyId).getWidth(),Ext.fly(dyId).getHeight(),newData.widgetType,footer,newData.widgetIcon,widgetObj,widgetIdInfo);

		//While adding widget be focus
		Ext.fly(dyId).scrollIntoView(Ext.get(gridsterPanel.up('panel').body.id),false,true);
		gridsterPanel.resumeEvents(true);
		gridsterPanel.doComponentLayout();
	},
	/**
	* Firing the event of panel 'beforeclose'
	* panel has inline listeners object 
	* see @ addPanel method
	*/
	onPortletClose: function(portlet,panel) {
		var gridsterPanel = this;
		panel.fireEvent('beforeclose',panel);
    },
	/**
    * Removing widget from the layout
    */
	removeWidget:function(id){
		var gridsterPanel = this;
		gridsterPanel.suspendEvents();
		gridsterPanel.loadGridSter().gridster.remove_widget($('#'+id));
		gridsterPanel.resumeEvents(true);
		gridsterPanel.doComponentLayout();
	},
	/**
    * Removing all widget from the layout
    */
	removeAllWidget:function(){
		var gridsterPanel = this;
		gridsterPanel.loadGridSter().gridster.remove_all_widgets();
	},
	/*
	* default postion to be reset
	* see @ revertWidgetPositions method
	*/
	getGridsterOrginPositions:function(){
		var gridsterPanel = this,data;
		if(gridsterPanel.data){
				data = gridsterPanel.data
		}
		return data;
	},
	/**
	* Reverting the widget position to original positions
	*/
	revertWidgetPositions:function(){
		var gridsterPanel = this;
		for (var i = 0; i < gridsterPanel.data.length; i++) {
					var element = $(".gridster div.portlet[id='"+gridsterPanel.data[i].id.toString()+"']");
					element.attr("data-row",gridsterPanel.data[i].row.toString());
                    element.attr("data-col",gridsterPanel.data[i].col.toString());
                    element.attr("data-sizey",gridsterPanel.data[i].size_x.toString());
                    element.attr("data-sizey",gridsterPanel.data[i].size_y.toString());
        }
        gridsterPanel.destroyGridster();     
	    gridsterPanel.loadGridSter();
        return false;
	},
	/**
	* Destroying the grdister
	*/
	destroyGridster:function(){
		alert(123)
		var gridsterPanel = this;
		gridsterPanel.getGridsterObj().destroy();
		var childNodes = document.getElementById(gridsterPanel.id).childNodes;
		for (var i = childNodes.length-1, cmp; i >= 0; i--) {
			cmp = Ext.getCmp(childNodes[i].id);
			if (cmp) {
				cmp.destroy();
			}
		}
	},
	getGrid:function(gridColumn,data,title,sortIndex)
	{
		var mainIndex=0;
		var subIndex=0;
		var f=0;
		var fieldsToStore=new Array();
		var mainColArray=new Array();	 
		var mainColArray = new Array();
		var count=0;
		//alert("===gridColumn==="+JSON.stringify(gridColumn));
		for (var key in gridColumn)
		{
			var mainColumn = key;
			var subColArrJson=gridColumn[key];
			//alert("====subColArrJson=======>>"+JSON.stringify(subColArrJson));
			if (subColArrJson.length>0)
			{
				
				var subColArray = new Array();
				for (var subKey in subColArrJson)
				{ 
					if(sortIndex==count)
					{
						mainIndex=f;
						subIndex=subKey;
						//alert("==========count=========if>>>>>"+count);
					}
					var	subcol = subColArrJson[subKey];
					var dataind=subcol+(count++);
					fieldsToStore.push({name: dataind});
						subColArray.push({ 
						header: subcol,
						align:'left',
						//align:'center',
						dataIndex: dataind,
						sortable: true,
						autoScroll:true,
						doSort: function(state) {
							var ds = this.up('grid').store;
							var field = this.getSortParam();
							ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2){
									v1 = v1.get(field);
									v2 = v2.get(field);

									if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
									{
										v2=new Date(v2).getTime(); 
										v1=new Date(v1).getTime(); 
										
									}else if(!isNaN(parseFloat(v1)) && !isNaN(parseFloat(v2)))
									{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v1= isNaN(v1) ? 0 : v1;

										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										v2= isNaN(v2) ? 0 : v2;
									}
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							});
						}
					});
				}
				mainColArray.push({ 
					header: key,
					sortable: true,
					columns:subColArray
				})
				
			}
			else
			{
				if(sortIndex==count)
				{
					mainIndex=f;
					subIndex=null;
					//alert("==========count=========if>>>>>"+count);
				}
				var dataind=key+(count++);
				fieldsToStore.push({name: dataind});
				var setAlign='left';
				mainColArray.push({ 
					header: key,
					sortable: true,
					autoScroll:true,
					align:setAlign,
					dataIndex: dataind,
					 renderer: function (value, metaData, record, row, col, store, gridView) {
						 
						return value;
					},
					doSort: function(state) {
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							//sorters: [{ property: 'Trgt_host', direction : 'ASC' }],//
							//sorters: { property: field, direction : state },//
							sorterFn: function(v1, v2){
								v1 = v1.get(field);
								v2 = v2.get(field);

								if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime(); 
									v1=new Date(v1).getTime(); 
									
								}else if(!isNaN(parseFloat(v1)) && !isNaN(parseFloat(v2)))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v1= isNaN(v1) ? 0 : v1;

									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									v2= isNaN(v2) ? 0 : v2;
								}
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				});
			}
			f++;
		}
		var store = Ext.create('Ext.data.ArrayStore', {
			 fields:fieldsToStore,
			 proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'array'
				}
			}, 
			pageSize:gridPageSize,
			sortable: true,
			autoLoad : true, 
			data : data,
			
		});
		var activePage=1;
		var isPagingHidden=true;
		var forceFitColsCount=9;
		var forceFit = true;
		if(forceFitColsCount <= fieldsToStore.length)
			forceFit=false;
		if(gridPageSize<data.length)
			isPagingHidden=false; 
		
			return{	
			xtype:'customgrid',
			store:store,
			columns:mainColArray,
			frame:false,
			margin:10,
			autoScroll:true,
			//stripeRows: false,
			// to enable horizontal scroll
			needtoFixColumn:true,
			//forceFitColsCount:9,
			scroll:true, 
			//style:{"-webkit-box-shadow":"none","box-shadow":"none"},
			//cls:'gridSkin horizontal-scroll',
			//cls:'newGridSkin horizontal-scroll',
			ui:'newGridPanel',
			border:true,
			forceFit:forceFit,
			sortableColumns: true,
			listeners:{
				render:function(obj){
					Ext.defer(function() {
		
						if(subIndex==null)
							obj.columns[mainIndex].setSortState("ASC",true,true);
						else
							obj.columns[mainIndex].items.items[subIndex].setSortState("ASC",true,true);
						//obj.columns[0].setSortState("ASC",true,true);
					},100);
				},
			},
			dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					displayInfo: true,
					store: store,
					hidden:isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No Data to display",
					listeners: {
						change : function(thisd, params)
						{  
							activePage = params.currentPage;
						}
					}
			}],	
		}
		
	}
});
