Ext.define('ReportBuilder.view.GridsterStackPanel', {
	extend:'Ext.panel.Panel',
	alias: 'widget.gridsterstackpanel',
	requires:['utilities.ReporterGridstackPanel'],
	id:'gridsterstackpanel',
	columnWidth:1.0,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	flex: 1,
	items:[{
		xtype: 'reportergridstackpanel',
		disableDrag:true,
		padding:'0 0 2 0',
		count:0,
		addWidget:function(obj, action, widgetTitle, imgIcon, imgIcon)
		{
			var me = this,
			gridstackobj = me.gridStackObjRef(),
			defaults = me.defaultConfigWidget;
			//console.log(me.defaultConfigWidget);
			var _arguments = Ext.applyIf(arguments[0], me.defaultConfigWidget);
			var ourtID = _arguments.id + '_outer';
			var innerID = _arguments.id + '_inner';
			//console.log('gridstackobj  ',gridstackobj);
			var el = $('<div class="grid-stack-item"><div class="grid-stack-item-content"  id="' + innerID +
				'"></div></div>');
			if (typeof _arguments.x != 'undefined') {
				el.attr('data-gs-x', _arguments.x);
			}
			if (typeof _arguments.y != 'undefined') {
				el.attr('data-gs-y', _arguments.y);
			}
			if (typeof _arguments.width != 'undefined') {
				el.attr('data-gs-width', _arguments.width);
			}
			if (typeof _arguments.height != 'undefined') {
				el.attr('data-gs-height', _arguments.height);
			}
			if (typeof _arguments.autoPosition != 'undefined') {
				el.attr('data-gs-auto-position', _arguments.autoPosition ? 'yes' : null);
			}
			if (typeof _arguments.minWidth != 'undefined') {
				el.attr('data-gs-min-width', _arguments.minWidth);
			}
			if (typeof _arguments.maxWidth != 'undefined') {
				el.attr('data-gs-max-width', _arguments.maxWidth);
			}
			if (typeof _arguments.minHeight != 'undefined') {
				el.attr('data-gs-min-height', _arguments.minHeight);
			}
			if (typeof _arguments.maxHeight != 'undefined') {
				el.attr('data-gs-max-height', _arguments.maxHeight);
			}
			if (_arguments.noResize) {
				el.attr('data-gs-no-resize', _arguments.noResize);
			}
			if (typeof _arguments.id != 'undefined') {
				el.attr('data-gs-id', ourtID);
			}
			if (typeof _arguments.id != 'undefined') {
				el.attr('id', ourtID);
			}
			if (typeof action != 'undefined') {
				el.attr('action', action);
			}
			if (typeof widgetTitle != 'undefined') {
				el.attr('widgetTitle', widgetTitle);
			}
			if (typeof imgIcon != 'undefined') {
				el.attr('imgIcon', imgIcon);
			}
			if (typeof _arguments.internalId != 'undefined') {
				el.attr('internalId', _arguments.internalId);
			}

			//pushing the data
			el.data("internalId", _arguments.internalId);
			me.widgetConfigObj[ourtID] = _arguments;
			gridstackobj.addWidget(el);
			me.gridStackData(_arguments);
			//me.portlet(_arguments,action,widgetTitle,imgIcon,imgIcon);

			//Ext.apply(me.portlet,{widgetDetails:_arguments });
		},
		portlet: function (obj, action, widgetTitle, imgIcon, imgIcon) 
		{
			var me = this;
			if ($('#noData')) {
				$('#noData').remove();
			}
			var portlet, objArray;
			//@ checking wheather its getting obj is array or array object 
			if (Ext.isArray(obj)) {
				objArray = obj;
			} else {
				objArray = [];
				objArray.push(obj);
			}
			_.each(objArray, function (node) {
				var blockID = node.id,
					renderToID = node.id + '_inner',
					width = Ext.get(renderToID).getWidth(),
					height = Ext.get(renderToID).getHeight();
				var eachWidget = node.eachWidget;
				var widgetId = node.widgetInfo;
				var paramVal = node.params;
				var widgetCountStatus = node.widgetCountStatus
				var panelHeaderStatus = node.panelHeaderStatus
				var isEnableEditor=false;
				if(neeedEditableHeader=='yes')
					isEnableEditor=true;
				var hideNotes = false;
				hideNotes=!isEnableEditor;
				var controller = appConstants.appObj.getController(appConstants.appController);
				var chartType = eachWidget.chartType;
				var chartHeight = eachWidget.chartHeight;//..
				var widgetIdInfo = widgetId+'_detail'
				var drillDownUrl='',csvInfoUrl='',gridInfoUrl='';
				var drillDownUrlFlag=true , csvInfoUrlFlag=true,gridInfoUrlFlag=true,noteFlag=false;
				var noMeasWidget=false;
				var panelHeader=true;
				gridInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+controller.getQueryString(false)+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&pdfPrint=yes&pdfprint=yes&titleDisp='+appConstants.tempName;
				csvInfoUrl="/final/reporter/ErPrintReportBuilder.jsp?"+controller.getQueryString(false)+"&graphIndex="+0+'&widgetIdInfo='+widgetIdInfo+'&option=csv&titleDisp='+appConstants.tempName;

				var per_footer = '';
				if(eachWidget.footerDescription!=undefined && eachWidget.footerDescription!='undefined')
					per_footer = eachWidget.footerDescription;
				var footerCls = 'iconNoCommentSmall';
				if(per_footer!='')
				{
					footerCls = 'iconCommentSmall';
				}
				panelHeader = panelHeaderStatus;
				var lblId =  appConstants.templateName+"$~$"+widgetId+"$~$"+"footerDescription";
				var lblIdHeader =  appConstants.templateName+"$~$"+widgetId+"$~$"+"headerDescription";
				if(chartType == 'timeline' || chartType == 'area')
				{
					chartType = 'timeline'
					drillDownUrlFlag=false;
					csvInfoUrlFlag=false;
					gridInfoUrlFlag=false;
				}
				else if(chartType == 'heatMap')
				{
					drillDownUrlFlag=false;
				}
				else if (chartType == 'bar' || chartType == 'vertbar')
				{
					drillDownUrlFlag=false;
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
				}
				else if (chartType == 'stackedbar')
				{
					chartType = 'bar';
					drillDownUrlFlag=false;
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
				}
				else if (chartType == 'distributedPie')
				{
					chartType='distpie';
					noteFlag=true;
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
				}
				else if (chartType == 'pie')
				{
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
					noteFlag=true;
				}
				else if (chartType == 'table')
				{
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
				}
				else if (chartType == 'topn')
				{
					chartType='topn';
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
				}
				else if(chartType == 'digital' || chartType == 'multiDigi')
				{
					chartType='digital';
					if(eachWidget.digitalRow !=undefined)
					{
						panelHeader=false;
					}			
					hideNotes = true;
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
					noteFlag=true;
				}
				hideNotes = true; //.. no need Notes
				var headerLine = ' graphHeaderBottomBorder';
				var headerPadding= '5px 10px 5px 10px'
				if(csvInfoUrlFlag && gridInfoUrlFlag && drillDownUrlFlag)
				{
					headerLine = '';
					headerPadding= '5px 10px 5px 10px'
				}
				var toolsArry=[];
				if(eachWidget.headerCombo != undefined && eachWidget.headerCombo=='yes')
				{
					toolsArry.push(
					{
						xtype: "scrollcombo",
						width: 285,
						cls: "dropdown",
						editable: false,
						margin:'0 4px 0 0',
						name: "er_headerCombo",
						id: "er_headerCombo",
						fieldLabel:eachWidget.headerDescription,
						labelAlign:'left',
						labelSeparator:'',
						labelStyle: 'white-space: nowrap;font-size: 14px;font-weight:500;',
						labelWidth:160,
						store: new Ext.data.Store({
							fields: ["displayField", "valueField"],
							data: [{"displayField":"Session Identifier","valueField":"SESSION_ID"},{"displayField":"User Name","valueField":"userName"}]
						}),

						displayField: "displayField",
						valueField: "valueField",
						queryMode: "local",	
						listeners: {
							boxready:function(obj){
								Ext.getCmp('er_headerCombo').setValue(appConstants.er_headerCombo);
							},
							change: function (e, d, a, b) {						
								var params1 = controller.getQueryString(true);
								params1+='&widget='+widgetId;
								params1+='&tempDesc='+appConstants.tempDesc;
								params1+='&recordInfo='+appConstants.recordInfo+'&templateName='+appConstants.templateName;
								params1+='&user_dispName='+appConstants.tempName;
								appConstants.er_headerCombo=d;
								var url='ReportBuilderController.jsp';	
								//var initMask = new Ext.LoadMask(me.getEl(),{msg : "Loading ..."});
								//initMask.show();
								Ext.Ajax.request({
									url:url,
									params:params1,
									scope:this,
									success:function(response){	
										if(response.responseText.length>0)
										{
											//initMask.hide();
											var preLoadJson = Ext.decode(response.responseText);
											controller.preLoadAjaxSuccess(preLoadJson,widgetCountStatus,widgetId);
											if(customPaging)
											{
												appConstants.blockPdfRelatedOptions='yes';									
											}
										}
									},
									failure:function(err)
									{
										//Ext.MessageBox.alert("Error occured in ErCtxOverview.jsp page");
									}
								});	
							}
						}
					});
					eachWidget.headerDescription='';
				}
				//Loading portlet toolbar items;
				//me.loadPortletToolbarItems(blockID,hideColorTool);
				portlet = Ext.create('Ext.panel.Panel', {
					closeAction: 'destroy',
					ui:'newGraphPanel noShadow'+headerLine,
					title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+eachWidget.headerDescription+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>',
					renderTo: renderToID,
					relationTo: node.id,
					id: blockID,
					width: width,
					height: height,
					autoScroll:false,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					padding:0,
					bodyPadding:0,
					margin:0,
					header:false,
					timelineLink:'',
					header:{
						hidden:!panelHeader,
						style:{
							'padding':headerPadding
						},
						titlePosition:1,
						items:toolsArry
					},
					tools:[
						appConstants.appObj.getController(appConstants.appController).addToolBarItems([
							{
								xtype: 'button',
								scale: 'small',
								padding:0,
								border:false,
								iconCls: footerCls,
								margin:'2 7 0 3',
								style:{'border':'0px'},
								id:widgetId+'_note',
								hidden:noteFlag,
								noteValue:per_footer,
								handler:function(){
									controller.openSmallPopupWindow(this);
								},
								 listeners: {
									afterrender: function () {
										Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: toolNotes
										});
									}
								}
							},
							{
								xtype: 'button',
								width:16,
								height:16,
								margin:'0 3 0 3',
								style:{'border':'0px'},
								cls: 'iconCsv',
								id:widgetId+'_csv',
								hidden:csvInfoUrlFlag,
								handler:function(){
									window.location=csvInfoUrl;
								},
								listeners:{
									afterrender: function(){
										Ext.create('Ext.tip.ToolTip',{
											target:this.id,
											anchor:'top',
											cls:'yellowTip',
											trackMouse:true,
											html:toolCSV
										});
									}
								}
							},{
								xtype: 'button',
								cls:'iconData',
								style:{'border':'0px'},
								width:16,
								height:16,
								margin:'0 3 0 3',
								id:widgetId+'_data',
								hidden:gridInfoUrlFlag,
								handler:function(){
									parent.printWindowFn(gridInfoUrl);
								},
								listeners:{
									afterrender:function(){
										Ext.create('Ext.tip.ToolTip',{
											target:this.id,
											anchor:'top',
											cls:'yellowTip',
											trackMouse:true,
											html:toolData
										});
									}
								}
							},
							{
								xtype: 'button',
								width:16,
								height:16,
								margin:'0 0 0 3',
								style:{'border':'0px'},
								cls:'iconMaximize',
								id:widgetId+'_drill',
								hidden:drillDownUrlFlag,
								handler:function(){
									var preLoadWidget = Ext.getCmp(widgetId+'_panel');
									parent.maximizeWindowLightBox(preLoadWidget.timelineLink);
								}
							}
						])
					],
					listeners:
					{
						boxready:function(obj)
						{
							if (!Ext.isEmpty(obj.header))
							{
								var el =Ext.get(obj.header.id+'_hd-textEl');						
								if(isEnableEditor)
								{
									Ext.get(obj.header.id).on('click', function(e,target){
										var edtrText=el.dom.innerText;	
										var editor = new Ext.Editor({
											width: 150,
											alignment: 'tl',
											floating: false,
											shadow: false,
											updateEl: true,
											completeOnEnter: true,
											cancelOnEsc: true,
											offsets: [0,-3],
											field: {
												xtype: 'textfield',
												cls: 'textbox',
												maxLength:32,
												allowBlank:false,
												enforceMaxLength: true
											},
											listeners: 
											{
												'complete': function (edtr, value, startValue, eOpts) 
												{
													el.dom.innerHTML=value;
													el.dom.innerHTML='<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">'+value+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>';
													var url='/final/reporter/ReportBuilderController.jsp';
													var controller=appConstants.appObj.getController(appConstants.appController);
													var params='&widgetHeaderFooterInfo='+encodeURIComponent(value);
													params+='&method=setWidgetHeaderFooter';
													params+='&templateName='+appConstants.templateName;
													params+='&isCustomLayout='+appConstants.isCustomLayout;
													params+='&fromReportBuilder='+appConstants.fromReportBuilder;
													params+='&idDescription='+lblIdHeader;
													controller.callAjax(url,params,false,true,true);
												}
											}
										});
										editor.startEdit(el,edtrText);
									}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
								}
							}
							var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
							initMask.show();
							var thispanel = this;
							var url='/final/reporter/ReportBuilderController.jsp';
							paramVal+='&widget='+widgetId
							paramVal+='&tempDesc='+appConstants.tempDesc;
							if(wildcardSearch)
							{
								paramVal+='&clientVersionn='+Ext.getCmp('wildcardSearch').getValue();
								if(wildcardSearchCondition)
									paramVal+='&er_searchGroupBy='+Ext.getCmp('er_searchGroupBy').getValue();
							}
							if(node.method=='submit')
								thispanel.timelineLink='/final/reporter/ErReportBuilderDrillDown.jsp?'+paramVal+'&isSubmit=true';
							distributedPieUrl=controller.getQueryString(true);
							Ext.Ajax.request({
								url:url,
								params:paramVal,
								scope:this,
								success : function(response){
									if(response.responseText.length>0)
									{
										initMask.hide();
										var preLoadJson = Ext.decode(response.responseText);
										controller.preLoadAjaxSuccess(preLoadJson,widgetCountStatus,widgetId);
										if(customPaging)
										{
											appConstants.blockPdfRelatedOptions='yes';
										}
									}
								},
								failure:function(err){
									Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
								}
							});	
						},
						'afterRender': function(obj)
						{
							if(chartType != undefined && chartType=='table')
							{
								var el = Ext.get(widgetId+'_panel');
								el.on('click', function(event, target, options)
								{	
									var compVal=target.textContent;
									if(compVal != undefined && compVal.indexOf("$") != -1)
										compVal=compVal.substring(compVal.indexOf("$")+1);
									var url;
									var params='method=submit';								
									var obj=Ext.getCmp('er_site');
									var gpuTemplate='yes';
									if(appConstants.templateName != undefined && appConstants.templateName == 'GPU Overview')
									{
										url='/final/reporter/ReportBuilder.jsp?';
										params='method=submit&recordInfo='+encodeURIComponent('{"templateName":"GPU Details"}');
									params+='&isSubmit=true';
									if (!obj.isHidden())
									{
										params+='&er_site='+obj.getValue();
											if (Ext.getCmp('er_option').getValue()=='Zone')
											{
												params+='&er_subZone='+Ext.getCmp('er_subZone').getValue();
											}
										}
									}
									else if(appConstants.templateName != undefined && appConstants.templateName == 'User Idle Reports')
									{
										url='/final/reporter/ErThinClientUserReport.jsp?fromMenuBar=true&er_trgttype=User Session Report&';
										params+='&isForceSubmit=true';
										params+='&er_user='+encodeURIComponent(compVal);
										params+='&er_RmDispName='+encodeURIComponent('User Session Details');
										params+='&fromReportBuilder=yes';
										if (!obj.isHidden())
										{
											params+='&select_farm='+obj.getValue();
										if (Ext.getCmp('er_option').getValue()=='Zone')
										{
												params+='&er_subZone='+Ext.getCmp('er_subZone').getValue();
										}
										}	
										gpuTemplate='no';
									}
									params+='&hideInputs=false';
									params+='&er_option='+Ext.getCmp('er_option').getValue();
									params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
									if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
									{
										params+='&showLegendsEnable='+Ext.getCmp('showLegend').getValue();
									}
									var arr=new Array();
									arr=Ext.getCmp('er_component').getValue();
									for (var key in arr )
									{
										if(gpuTemplate == 'yes')
										{
										if(arr[key].indexOf(compVal) != -1)
										{
											params+='&er_component='+arr[key];
										}
										if(arr[key]=='All')
										{
											if(compVal.indexOf(":") != -1)
											{
												params+='&er_component='+compVal+":"+Ext.getCmp(appConstants.erCompType).getValue();
											}
											else
											{
												params+='&er_component='+compVal+":NULL:"+Ext.getCmp(appConstants.erCompType).getValue();
												}
											}
										}
										else if(gpuTemplate == 'no')
										{
											params+='&er_componentserver='+arr[key];
											params+='&select_server1='+arr[key];
										}
									}
									params+='&er_test='+Ext.getCmp('er_test').getValue();
									if(appConstants.isMultiMeasureSupport=='yes')
									{
										var arr=new Array();
										arr=Ext.getCmp('er_measure').getValue();
										for (var key in arr )
										{
											var measure=arr[key];
											measure=measure.replace("(","EGOPENBRACE");
											measure=measure.replace(")","EGCLOSEBRACE");
											params+='&er_measure='+measure;
										}
									}
									else
									{
										var measure=Ext.getCmp('er_measure').getValue();
										measure=measure.replace("(","EGOPENBRACE");
										measure=measure.replace(")","EGCLOSEBRACE");
										params+='&er_measure='+measure;
									}
									if(Ext.getCmp(appConstants.erInfo).getValue() != undefined)
										params+='&er_info='+Ext.getCmp(appConstants.erInfo).getValue();
									params+='&er_timeline='+Ext.getCmp('er_timeline').getValue();
									params+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
									params+='&startdate='+Ext.getCmp('er_stdate').dataArray;
									params+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
									params+='&enddate='+Ext.getCmp('er_enddate').dataArray;
									params+='&er_sthr='+Ext.getCmp('er_sthr').dataArray;
									params+='&starthr='+Ext.getCmp('er_sthr').dataArray;
									params+='&er_endhr='+Ext.getCmp('er_endhr').dataArray;
									params+='&endhr='+Ext.getCmp('er_endhr').dataArray;
									params+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
									params+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;
									params+='&timefrom='+Ext.getCmp('timefrom').getValue();
									params+='&timeto='+Ext.getCmp('timeto').getValue();
									params+='&minfrom='+Ext.getCmp('minfrom').getValue();
									params+='&minto='+Ext.getCmp('minto').getValue();
									params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue();
									params+='&er_excwe='+Ext.getCmp('er_excwe').getValue();
									params+='&pct_idle='+Ext.getCmp('pct_idle').getValue();
									params+='&sorted_col='+Ext.getCmp('groupBy_list').getValue();//..for sorted measure
									params+='&aggregate_server='+Ext.getCmp('aggregate_server').getValue();
									params+='&er_showBy='+Ext.getCmp('er_showBy').getValue();
									params+='&timeline_showBy='+Ext.getCmp('timeline_showBy').getValue();//...
									params+='&bar_showBy='+Ext.getCmp('bar_showBy').getValue();//...
									if (appConstants.isCustomLayout=='yes')
									{
										params+='&er_top='+Ext.getCmp('er_top').getValue();
									}
									else
									{
										params+='&chartInfo='+appConstants.chartInfo;
										params+='&er_top='+Ext.getCmp('er_top').getValue();
									}
									params+='&fromReportBuilder='+appConstants.fromReportBuilder;
									params+='&enableBack=true';
									linkURL(url+params);
								},
								this,
								{
									delegate: '.forCursorSymbol',
								});
							}
						}
					},
				});
			});
			return portlet;
		},
		loadWidgetData:function(type,iconCls,chartIcon)
		{
			var message='Config Widget'
			if(iconCls!='iconConfigUser')
				message='Done! Widget Configuration'
			var gridsterPanel = this;
			var box;
			if(iconCls!='iconConfigUser')
			{
				chartIcon=chartIcon.replace("Gray","")
				//box =	app.appObj.getController(app.appController).getConfiguredMe(type);
				box =	{
					xtype:'container',
					closeAction:'destroy',
					layout:{type:'hbox',align:'stretch',pack : 'center'},
					flex:1,
					listeners: {
						'afterRender': function(obj)
						{
							 this.getEl().on('click', function(event, target, options)
							 {
									app.appObj.getController(app.appController).onClickWidgetModify(obj.up('panel'));
							 });
						}
					},
					items:[{
						xtype:'button',
						//text:type,
						height:100,
						ui:'plain',
						style:{'cursor':'default'},
						html:'<table width="100%" height="80px" style="margin:0% auto;"><tr><td align="center" valign="middle"><div class="'+chartIcon+'" style="position:relative"><div class="widgetIcon24_Tick"></div></div><div style="margin:10px auto" class="datapanelWidgetIconTextConfigured">Widget configuration done!</div></td></tr></table>',

					}]
				}
			}
			 else
			 {
				 box = {
					xtype:'container',
					closeAction:'destroy',
					layout:{type:'hbox',align:'stretch',pack:'center'},
					flex:1,
					listeners: {
						'afterRender': function(obj)
						{
							 this.getEl().on('click', function(event, target, options)
							 {
								 if(iconCls=='iconConfigUser')
									app.appObj.getController(app.appController).onClickConfigWidget(obj);
							 });
						}
					},
					items:[{
						xtype:'button',
						//text:type,
						height:100,
						ui:'plain',
						html:'<table width="100%" height="80px" style="margin:0% auto;"><tr><td align="center" valign="middle"><div class="'+chartIcon+'"></div><div style="margin:10px auto" class="datapanelWidgetIconText">'+message+'</div></td></tr></table>',

					}]
				}
			 }

			return box;
		},
		loadPortletToolbarItems: function (blockId,hideColorTool) 
		{
			var me = this;
			me.portlettoolbarItems = [
			{
				xtype : 'button',
				cls:'colorTool ',
				//cls:'dragTools',
				height:16,
				width:16,
				margin:'0 5 0 0',
				style:{'border':'0px'},
				tooltip : 'Change color palette',
				blockId:blockId,
				hidden:hideColorTool,
				handler : function()
				{
					this.selectedGraphPalette=this.up('panel').selectedGraphPalette;
					app.appObj.getController(app.appController).showPaletteWindow(this);

				}
			},
			{
				xtype: 'button',
				cls:'iconConfig',
				style:{'border':'0px'},
				width:16,
				height:16,
				margin:'0 5 0 0',
				handler:function(){
					if (this.up('panel').hasCls('configuredWidgetDummy'))
					{
						this.up('panel').removeCls('configuredWidget');
					}
					app.appObj.getController(app.appController).onClickWidgetModify(this.up('panel'));
				}
			},
			{
				xtype: 'button',
				width:16,
				height:16,
				margin:'0 5 0 0',
				style:{'border':'0px'},
				cls: 'iconClose3',
				handler:function(){
					needWidgetCloseAlert = true;
					this.up('panel').close();
				}
			}];
		},
	}]
});
