Ext.define('ReportBuilder.view.Main', {   
	extend : 'utilities.NewOuterPanel',
	requires:[
		'ReportBuilder.view.BuilderSettings',
		'ReportBuilder.view.BackgroundResults',
		'ReportBuilder.view.EgComponent',
		'ReportBuilder.view.EgComponentType',
		'ReportBuilder.view.TemplateFormItems',
		'ReportBuilder.view.TemplateForm',
		'ReportBuilder.view.EgInfo',
		'ReportBuilder.view.EgMeasure',
		'ReportBuilder.view.ResultPanel',
		'ReportBuilder.view.Gridster',
		'ReportBuilder.view.GridsterStackPanel',
		'ReportBuilder.view.RangeSettings',
		'ReportBuilder.view.ColourSettings',
		'ReportBuilder.view.CustomTextField',
		'utilities.ScrollCombo',
		'utilities.Multiselector',
		'utilities.CustomGrid_builder',
		'utilities.EmptyPanel',
		'utilities.SelectionDetails',
		'utilities.TimeLine',
		'utilities.ErUtils',
		'utilities.gridsterPanel',
		'utilities.ReporterGridstackPanel',
		'utilities.TimePeriod',
		'utilities.newUtilities',
		'utilities.SendMail',
		'utilities.ReporterSettings',
		'utilities.ReportGeneration',
		'utilities.CustomTrigger',
		'utilities.NewSettingsWindow',
		'Ext.ux.form.MultiSelect',
		'Ext.ux.RowExpander',
		'Ext.ux.form.ItemSelector',
		'Ext.ux.grid.FiltersFeature',
		'Ext.ux.data.PagingMemoryProxy'			
	],
	id:'main',
	alias : 'widget.main',
  	autoScroll : true,
 	title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold13">eG Report Template</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRename+'"></td></tr></table>',
	scroll : true,
	//cls:'newPanel',
	layout : {
		align : 'stretch',
		type : 'column'
 	},
	tools:[
		{
			xtype:'button',
			text:backText,
			cls:'backbutton',
			margin:'0 5 0 5',
			iconCls:'iconBack',
			id:'bckButton',
			hidden:hideBackButton,
			listeners:{
				'click':function(){
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
					appConstants.erUtils.firebackbuttonaction('../reporter/EgReporterback.jsp')
				}
			}
		},
		/*
		{
			xtype:'tbseparator',
			hidden:hideBackButton,
		},
		*/
		{
			xtype: 'button',
			width: 20,
			height:16,
			padding:0,
			margin:'0 3 0 3',
			enableToggle: true,
			id: 'iconReportSelectionHide',
			//id: 'panelinsidetoggle',//..
			name:'iconReportSelectionHide',
			cls: 'iconReportSelectionHide',
			style : {'border':'0px !important'},
			hidden:true,
			listeners: {
				render: function (btn) {
					btn.tip = new Ext.tip.ToolTip(
					{
						target: btn.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: 'Show'
					});
				}
			},
			toggleHandler:function(){
				var btn = Ext.getCmp('iconReportSelectionHide');
				//alert("==btn.pressed==>>>>>>>"+btn.pressed);
				if(btn.pressed==true){
					btn.tip.update('Hide');
				}else{
					btn.tip.update('Show');
				}
			}
		},
		//{xtype:'tbseparator'},
		{xtype: "ReporterSettings",margin: '0 3 0 3'},
		//{xtype:'tbseparator'},
		{xtype:'newUtilities'}
	],
	listeners:{
		boxready:function(obj){ //template title editing
			if (appConstants.isCustomLayout=='yes')
			{
				this.add({
					xtype:'container',
					id:'pbarcont',
					hidden:true,
					margin:10,
					style:"{z-index:9999;position: fixed;bottom: 0px;}", 
					html:'<div id="pbardiv" style="z-index:9999;width:100%;height:50px;position: fixed;bottom: 0px;"></div><div style="height:50px;z-index:9999;position: fixed;bottom: 0px;margin-left:10px;" class="status"><b>Status:</b> <span id="ptext"></span></div>'
				});
				new Ext.ProgressBar({
					text: 'Waiting on you...',
					id: 'pbar',
					height:50,
					margin:'0 50 0 0',
					hidden:true,
					textEl: 'ptext',
					cls: 'custom',
					renderTo: 'pbardiv'
				});
			}
			//....For template title editing.......///
			if (!Ext.isEmpty(obj.header))
			{
				var el =Ext.get(obj.header.id+'_hd-textEl');
				if(neeedEditableHeader=='yes')
					Ext.get(obj.header.id).on('click', function(e,target)
					{
						var edtrText=el.dom.innerText;
						var editor = new Ext.Editor({
						width: 150,
						alignment: 'tl',
						floating: false,
						shadow: false,
						updateEl: true,
						completeOnEnter: true,
						cancelOnEsc: true,
							offsets:[0,-3],
						field: {
							xtype: 'textfield',
								cls:'textbox',
							maxLength:32,
							enforceMaxLength: true
						},
						listeners: {
								'complete': function (edtr, value, startValue, eOpts) {
								el.dom.innerHTML='<table cellpadding="0" cellspacing="0" border="0"><tr><td class="font_bold13">'+value+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="iconRename"></td></tr></table>';
									var url='/final/reporter/ReportBuilderController.jsp';
									var controller=appConstants.appObj.getController(appConstants.appController);
									controller.method='setHeaderDescription';
									var params='templateTitle='+value;
									params+='&method=setTitleDescription';
									params+='&isCustomLayout='+appConstants.isCustomLayout;
									params+='&templateName='+appConstants.templateName;
									controller.callAjax(url,params,false);
								}
						}
					});
					editor.startEdit(el,edtrText);			
				}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
			}
		}
	},
	items:[
		{
			xtype:'templateformitemsalias',
			columnWidth:1.0,
		},
		{
			xtype: 'label',
			hidden:true,
			id:'templateDesc',
			columnWidth:1.0,
			html:'<table width="100%"><tr><td style="vertical-align:middle"><div class="descriptorLeftDesign"></div></td><td width="80%"><div class="descriptionForTemplates" id="tempDescContent"></div></td><td style="vertical-align:middle"><div class="descriptorRightDesign"></div></td></tr></table>',
			margin:'9 12 0 12',
			listeners:{
				afterrender:function(obj){
					obj.el.on('dblclick',this.onEdit,this);
					},
			},
			onEdit: function(event, element,obj)
			{
				var me = this;
				var descWidth = Ext.get('tempDescContent').getWidth()-40;
				var descHeight = Ext.get('tempDescContent').getHeight()-5;
				if(!me.editor) {
					me.editor = Ext.create('Ext.Editor', {
						updateEl: true,
						completeOnEnter: true,
						cancelOnEsc: true,
						floating: false,
						alignment: 'tl',
						padding:'0 0 0 20',
						autoSize: {							
							height: 'boundEl', // Height from the boundEl
						},
						hideEl: false,
						offsets: [0,1],
						field: {
							xtype: 'textfield',
							cls: 'textbox',
							width:descWidth,
						},
						listeners: {
							complete: {
								fn: function(self, value, startValue, opts) {
									Ext.getCmp('main').doLayout();
									appConstants.tempDesc=value;
								},
								scope: me,
							}
						}
					});
				}
				me.editor.startEdit(element);
			}
		},
		{
			xtype: 'selectiondetails',
			margin:'10 10 0 10',
			columnWidth:1.0,
			hidden: true

		},
		{
			xtype:'emptypanel',
			columnWidth:1.0,
			hidden: true
		},
		{
			xtype:'resultcontainer',
			columnWidth:1.0,
			margin:'0 5 0 5',
		},
		{
			xtype:'backgroundresults',
			columnWidth:1.0,
			hidden:true
		}
	]
 });