Ext.define('ReportBuilder.view.RangeSettings', {
	extend:'Ext.form.FieldSet',
	alias:'widget.rangeSettings',
	id:'rangeSettingsId',
	layout:{
		type:'column',
		align:'stretch',
	},
	flex:1,
	ui:'simple',
	cls: 'checkbt',
	title: 'Range Settings',
	checkboxToggle:false,
	collapsed: false,
	width:540,
	hidden:true,
	defaults:{
		labelSeparator : '',
		labelAlign: 'top',
		margin:'0 0 0 0',
		columnWidth:1,
	},
	id:'rangeSettingsItemsId',
	setExpanded: function(expanded) {
        var me = this,
            checkboxCmp = me.checkboxCmp,
            operation = expanded ? 'expand' : 'collapse';

        if (!me.rendered || me.fireEvent('before' + operation, me) !== false) {
            expanded = !!expanded;

            if (checkboxCmp) {
                checkboxCmp.setValue(expanded);
            }

            if (expanded) {
                me.removeCls(me.baseCls + '-collapsed');
            } else {
                me.addCls(me.baseCls + '-collapsed');
            }
            me.collapsed = !expanded;
            if (me.rendered) {
                me.updateLayout({ isRoot: true });
                me.fireEvent(operation, me);
            }
        }
        return me;
    }

});


