Ext.define('ReportBuilder.view.TemplateForm', {
	extend: 'Ext.form.Panel',
	layout:'column',
	padding:10,
	alias : 'widget.templateformalias',
	id:'templateform',
	defaults:{
		margin: '0 10 10 0',
		labelStyle: 'white-space: nowrap',
		labelAlign:'top',
		editable:false,
		labelSeparator:''
	},
	initComponent: function(){
		this.items = this.getTemplateItems();
        this.callParent();
	},
	getTemplateItems:function(){
		var templateItems =[];
		templateItems.push({
			xtype:'scrollcombo',
			fieldLabel:'Analysis By',
			style: {
				'font-size': '11px'
			},
			cls: 'dropdown',
			id: 'er_option',
			name: 'er_option',				
			store: Ext.data.Store
			(
				{
					fields: ['displayField','valueField'],
					data: []
				}
			),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		});
		templateItems.push({
			xtype:'customTextField'
		});
		templateItems.push({
			xtype:'scrollcombo',
			fieldLabel:'segserzone',
			cls: 'dropdown',
			id: 'er_site',
			name: 'er_site',				
			width:200,
			store: Ext.data.Store
			(
				{
					fields: ['displayField','valueField'],
					data: []
				}
			),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		});
		templateItems.push({
			xtype:'scrollcombo',
			fieldLabel:'Sub Zone',
			cls: 'dropdown',
			id: 'er_subZone',
			name: 'er_subZone',				
			width:200,
			store: Ext.data.Store
			(
				{
					fields: ['displayField','valueField'],
					data: []
				}
			),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		});
		templateItems.push({
			xtype:'scrollcombo',
			fieldLabel:'Component Type',
			editable : true,
			typeAhead:true,
			listConfig:{
				emptyText:noComponentTypeMatch
			},
			cls: 'dropdown',
			id: 'er_compType',
			name: 'er_compType',				
			hidden:true,
			width:200,
			store: Ext.data.Store
			(
				{
					fields: ['displayField','valueField'],
					data: []
				}
			),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		});
		templateItems.push({
			xtype:'scrollcombo',
			fieldLabel:'Sort By',
			editable : true,//..
			typeAhead:true,//..
			listConfig:{
				emptyText:noComponentTypeMatch//..
			},
			cls: 'dropdown',
			id: 'er_sortingColumn',
			name: 'er_sortingColumn',				
			hidden:true,
			width:200,
			store: Ext.data.Store
			(
				{
					fields: ['displayField','valueField'],
					data: []
				}
			),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		});
		templateItems.push({
			xtype:'scrollcombo',
			fieldLabel:'Secondary Sort Cloumn',
			editable : true,//..
			typeAhead:true,//..
			listConfig:{
				emptyText:noComponentTypeMatch//..
			},
			cls: 'dropdown',
			id: 'er_secondaryColSort',
			name: 'er_secondaryColSort',				
			hidden:true,
			width:200,
			store: Ext.data.Store
			(
				{
					fields: ['displayField','valueField'],
					data: []
				}
			),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		});
		templateItems.push({
			xtype:'scrollcombo',
			fieldLabel:appConstants.descriptorComboName,
			editable : true,//..
			typeAhead:true,//..
			listConfig:{
				emptyText:noComponentTypeMatch//..
			},
			cls:'dropdown',
			id: 'er_infoSingleSelect',
			name: 'er_infoSingleSelect',				
			hidden:true,
			width:200,
			store: Ext.data.Store
			(
				{
					fields: ['displayField','valueField'],
					data: []
				}
			),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		});
		if(!wildcardSearchCondition && wildcardSearch)
		{
			templateItems.push({
				xtype:'textfield',
				fieldLabel:appConstants.wildcardSearchLabel,
				cls: 'textbox',
				//style:{'display':'none'},
				id:'wildcardSearch',
				name:'wildcardSearch',
				width:150,
				hidden:!wildcardSearch
			});
		}
		templateItems.push({
			xtype:'scrollcombo',
			fieldLabel:'Test',
			cls: 'dropdown',
			id: 'er_test',
			name: 'er_test',				
			width:200,
			hidden:true,
			store: Ext.data.Store
			(
				{
					fields: ['displayField','valueField'],
					data: []
				}
			),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		});
		if(appConstants.isMultiMeasureSupport=='yes')
		{
			templateItems.push({
				xtype:'egmeasure',
				hidden:true,
			});
		}
		else
		{
			templateItems.push({
				xtype:'scrollcombo',
				fieldLabel:'Measure',
				cls: 'dropdown',
				id: 'er_measure',
				name: 'er_measure',
				hidden:true,
				width:200,
				store: Ext.data.Store
				(
					{
						fields: ['displayField','valueField'],
						data: []
					}
				),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			});
		}
		if(wildcardSearchCondition && wildcardSearch)
		{
			templateItems.push({
				xtype:'container',
				layout: 'hbox',
				width:430,	
				id:'wildcardSearchContainer',
				defaults:
				{
					labelAlign: 'left',
					labelSeparator: '',
					margin: '0 10 0 0',
					labelStyle: 'white-space: nowrap;font-weight:500',
					editable: false
				},
				items:[{
						xtype:'scrollcombo',
						width: 250,
						cls: "dropdown",
						id: 'er_searchGroupBy',
						name: 'er_searchGroupBy',
						fieldLabel:appConstants.wildcardSearchLabel,
						labelWidth:150,
						store: new Ext.data.Store({
							fields: ["displayField", "valueField"],
							data: [{"displayField":"None","valueField":"none"},{"displayField":"Contains","valueField":"contains"},{"displayField":"Equals","valueField":"equals"},{"displayField":"StartsWith","valueField":"startsWith"},{"displayField":"EndsWith","valueField":"endsWith"}]
						}),
						displayField: "displayField",
						valueField: "valueField",
						queryMode: "local",
						hidden:!wildcardSearch,	
						listeners:{
								select:function(combo,records,eOpts){
									var searchValue=combo.getValue();
									if(searchValue!= undefined && searchValue=='none')
									{
										//Ext.getCmp('wildcardSearch').setReadOnly(true);
										Ext.getCmp('wildcardSearch').setDisabled(true);
										Ext.getCmp('wildcardSearch').setValue('');
									}
									else
									{
										//Ext.getCmp('wildcardSearch').setReadOnly(false);
										Ext.getCmp('wildcardSearch').setDisabled(false);								
									}
								}
						}
					},
					{
						xtype:'textfield',
						cls: 'textbox',
						id:'wildcardSearch',
						name:'wildcardSearch',
						fieldLabel:'',
						width:150,
						labelWidth:20,
						hidden:!wildcardSearch	
					}
				],
				hidden:!wildcardSearch,
				listeners:{
					render:function(){
						Ext.EventManager.onWindowResize(function () {
							var wildcardSearchContainer=Ext.getCmp('wildcardSearchContainer');
							if(Ext.getBody().getViewSize().width>1100)
								wildcardSearchContainer.getEl().setStyle({margin: '20 10 10 0'});
							else
								wildcardSearchContainer.getEl().setStyle({margin: '0 10 10 0'});
							
						});
					}
				}
			});
		}
		templateItems.push({
			xtype:'timeline',
			hidden:timelineHidden,
		});			
		templateItems.push({
						xtype:'checkbox',
						cls: 'checkbt',
						margin:'21 10 0 0',
						boxLabel: 'Show Legends',
						inputValue: 'true',
						id: 'showLegend',
						hidden:true,
						checked: true,
					});
		 if(appConstants.fromFavouriteModify!="Yes" && appConstants.fromScheduleModify!="Yes")
		{
			templateItems.push({
				xtype:'button',
				text:submitValue,
				id:'submit',
				//cls: "button20",
				ui:'newButtonSmall',
				name:'submit',
				margin: "20 20 0 0"
			});
		}else		
		{
			templateItems.push({
				xtype:'button',
				text:saveTxt,
				id:'saveReport',
				//cls: "button20",
				ui:'newButtonSmall',
				name:'saveReport',
				margin: "20 20 0 0"
			});
		}
		return templateItems;
 	}
});
