Ext.define('ReportTemplate.controller.ReportTemplateController', {
	extend: 'Ext.app.Controller',
	views: ['ReportTemplate.view.Main'],
	refs: [
		{selector:'main', ref:'main'},
		{selector:'reportdataconfigwindow', ref:'reportdataconfigwindow'},
		{selector:'reportbuildergridalias', ref:'reportbuildergridalias'},
		{selector:'reportbuilderboxview', ref:'reportbuilderboxview'},
		{selector:'reportdataconfiguration', ref:'reportdataconfiguration'},
		{selector:'reportgroupalias', ref:'reportgroupalias'},
		{selector:'customwindow', ref:'customwindow'},
		{selector:'gridster', ref:'gridster'},
		{selector:'#widgetLayoutPane', ref:'widgetLayoutPane'},
		{selector:'graphpalettewindow',ref :'graphpalettewindow'},
	],
	 searchTask: new Ext.util.DelayedTask(function(){
		app.appObj.getController('ReportTemplateController').doFilter();
	}),
	 boxViweSearchTask: new Ext.util.DelayedTask(function(){
		app.appObj.getController('ReportTemplateController').boxViewFilter();
		 $('.textView').highlight(Ext.getCmp('reportlivesearchList').getValue());

	}),
	init: function () {

		this.control({

			'reportbuilderboxview textfield[name="reportlivesearchList"]':
			{
				change:this.typewatchBoxView
			},
			'reportbuildergridalias textfield[name="reportlivesearch"]':
			{
				change:this.typewatch
			},
			'reportbuildergridalias' : {
				'render' : this.onRenderReportBuilderGrid,
				'afterrender' : this.registerDeleteRecordEvent
			},

			'main button[name=addTemplate]' : {
				'click' : this.onClickAddTemplate
			},
			'main button[name=createTemplateButtonList]' : {
				'click' : this.onClickAddTemplate
			}
			,'main button[name=addMoreWidget]' : {
				'click' : this.addMoreWidget
			}
			,'main button[name=editTemplateDecs]' : {
				'click' : this.editTemplateDecs
			},
			'main button[name=templateBackId]' : {
				'click' : this.cancelCreation
			},
			'main button[name=cancelTemplate]' : {
				'click' : this.cancelCreation
			},
			'main button[id=createTemplate]' : {
				'click' : this.onClickTempCreate
			},
			'reportdescriptionalias': {
				'afterrender': this.loadAllUser
			},
			'reportdescriptionalias button[name=create]' : {
				'click' : this.onClickCreateBtn
			},
			'reportdescriptionalias button[name=saveEdit]' : {
				'click' : this.saveEditInfo
			},
			'reportdataconfiguration combo[name=er_compType]': {
				'select': this.ajaxQueryMaker
			},
			'reportdataconfiguration combo[name=er_testType]':
			{
				'select': this.ajaxQueryMaker,
			},
			'reportdataconfiguration combo[name=er_test]': {
				'select': this.ajaxQueryMaker,
			},
			'reportdataconfiguration combo[name=er_measure]': {
				'select': this.ajaxQueryMaker,
			},
			'reportdataconfiguration combo[name=er_function]': {
				'select': this.ajaxQueryMaker,
			},
			'reportdataconfiguration combo[name=glduration]': {
				'select': this.onDurationChange,
				'render': this.onRenderReportConfig
			},
			'reportdataconfiguration combo[name=er_descFilter]':
			{
				'select': this.onSelectDescFilter,
			},
			'reportdataconfigwindow radiogroup[id=layoutTypeid]' : {
				'change' : this.layoutTypeChange
			},
			'reportdataconfigwindow button[id=addwidget]' : {
				'click' : this.onClickAddWidget
			},
			'reportdataconfigwindow button[id=addWidgetDone]' : {
				'click' : this.addWidgetDone
			},
			'reportdataconfigwindow button[id=addTowidget]' : {
				'click' : this.addToWidget
			},
			'reportdataconfigwindow button[id=tempCreate]' : {
				'click' : this.onClickTempCreate
			},
			'reportgroupalias radiogroup[id=er_enableTopN]' : {
				'change' : this.onEnableTopNchange
			},
			'configdataalias': {
				'afterrender': this.registerDeleteRecordEvent
			},
			'reportbuilderboxview button[id="DeleteListOfTemplates"]': {
				'click': this.deletSelectedTemplateByListView
			},
			'graphpalettewindow button' :
			{
				'click' : this.setPalette
			}
		});
	},
	onAjaxSuccess:function(){
		console.log("==method==>>>"+app.method);
	//	console.log = function() {}; // this line is used to disable the console log
		app.isfreshTemplate='no';
		if (app.method=='init'||app.method=='loadTemplateInfo')
		{
			this.loadComboField('er_compType','componentTypeCombo',null,'selectedComponentTypeCombo',app.templateJson,false,null,false);
			this.loadComboField('er_descFilter','descFilterCombo',null,'',app.templateJson,false,null,false);
			if(app.method=='init'|| app.isCustomLayout=='no')
				this.loadTestMeasureInfos();
			this.loadComboField('er_function','functionCombo',null,'selectedFunctionCombo',app.templateJson,false,null,false);

			this.loadComboField('er_top','topNCombo',null,'selectedTopN',app.templateJson,false,null,false);
			var component = Ext.ComponentManager.get('disp_MeasureName');//..
			/*var firstMeasure=app.templateJson.combo['measureCombo'];
			if(!Ext.isEmpty(firstMeasure) && !Ext.isEmpty(firstMeasure[1]))
			{
				var displyName = firstMeasure[1].displayField;
				if(displyName != null && displyName.indexOf('(')>-1)
					displyName = displyName.substring(0,displyName.indexOf('('));
				if(component!=undefined && component!='undefined')
				{
					component.setValue(displyName);
				}
			}//................................................*/
			if(component != undefined)
			{
				var displyName = app.templateJson.selectedFields.selectedDispMeasureCombo;
				component.setValue(displyName);
			}
			if (!Ext.isEmpty(Ext.getCmp('er_top'))){
				if(curChartType!='topn')
					Ext.getCmp('er_top').hide();
			}
			if (app.method=='loadTemplateInfo')
			{
				if (app.templateJson.hasOwnProperty('templateInfo'))
				{
					var templateInfo=app.templateJson.templateInfo;
					app.isCustomLayout=templateInfo.isCustomLayout;
					if (templateInfo.isCustomLayout=='no')
					{
						if (templateInfo.hasOwnProperty('chartInfo'))
						{
							var chartInfo=templateInfo.chartInfo;
							chartInfo.isDescFilter=templateInfo.isDescFilter;
							Ext.getCmp('singleLayoutDesEditId').show();
							this.modifyAllConfig(chartInfo,templateInfo.configGridData,templateInfo.ddChkBoxData);
						}
						Ext.getCmp('tempCreate').setText('UPDATE TEMPLATE');

						app.updateTemplate=true;
					}
					else
					{
						var widgetArray=new Array();
						var isDataPersent=false;
						if (!Ext.isEmpty(this.getWidgetLayoutPane()))
						{
							this.getWidgetLayoutPane().removeAllWidget();
							this.getWidgetLayoutPane().show();
							//Ext.getCmp('widgetLayoutPane').setAutoScroll(true);
							this.getMain().setAutoScroll(true);
						}
						Ext.getCmp('reportbuildertop').hide();
						Ext.getCmp('listViewBtnId').hide();
						Ext.getCmp('gridViewBtnId').hide();
						for (var key in templateInfo.widgetList)
						{
							var widget=templateInfo.widgetList[key];
							var widgetObj=templateInfo[widget];
							widgetObj['wigId']=widget;
							if (!Ext.isEmpty(widgetObj))
							{
								if (Ext.isEmpty(this.getWidgetLayoutPane()))
								{
									//alert(123)
									this.getMain().add({xtype: 'gridster',hidden:false});
									this.getMain().setAutoScroll(true);
									//Ext.getCmp('widgetLayoutPane').setAutoScroll(true);
								}
								Ext.getCmp('widgetLayoutPane').addWidget(widgetObj.chartType,widgetObj.size_x,widgetObj.size_y,widgetObj.x,widgetObj.y,widgetObj,'iconRight','configuredWidgetDummy',widgetObj.headerDescription,widgetObj.selectedPaletteColor);
								isDataPersent=true;
							}
						}
						if (isDataPersent)
						{
							Ext.getCmp('editTemplateDecs').show();
							Ext.getCmp("createTemplate").setText("UPDATE TEMPLATE");
							Ext.getCmp('mainWindowHeader').update('<div class="font_bold13">'+mainWindowTitle+'</div>');
							app.updateTemplate=true;
							this.getMain().doComponentLayout();
							Ext.getCmp('widgetLayoutPane').doComponentLayout();
						}
					}
				}
				else
				{
					this.getMessageBox('eG Custom Reports','No template info data found to load ...');
				}
			}
			else
			{
				Ext.getCmp("er_measure").setFieldLabel("Measure");
				Ext.getCmp("ddGroupInfoId").hide();
				Ext.getCmp("ddGroupInfoTxtField").setValue('');
				Ext.getCmp("ddGroupInfoTxtField").fieldValues='';
			}
		}
		else if (app.method=='getTemplateInfo')
		{
			if (app.templateJson.status=='success')
			{
				this.onClickCreateBtn(Ext.getCmp('reportbuildergridid'));
			}
			else
			{
				this.getMessageBox('eG Custom Reports',app.templateJson.status);
			}
		}
		else if (app.method=='getini' || app.method=='deleteAndGetIni')
		{
			//console.log("===on success=builder type=="+app.builderType);
			//console.log(app.templateJson);
			if(app.templateJson.status=='success')
			{
				this.loadGridData();
			}
		}
		else if (app.method=='comptypechange')
		{
			Ext.getCmp('er_durationContainer').hide();//...............
			var componentType = Ext.getCmp('er_compType');//...............
			this.loadTestMeasureInfos();
			this.loadComboField('er_function','functionCombo',null,'selectedFunctionCombo',app.templateJson,false,null,false);

			Ext.getCmp('ComponentsTypeTxtField').setValue(componentType.getRawValue());
			Ext.getCmp('ComponentsTypeTxtField').fieldValues = componentType.getValue();

			var component = Ext.ComponentManager.get('disp_MeasureName');//..
			var displyName = app.templateJson.selectedFields.selectedDispMeasureCombo;
			/*var firstMeasure=app.templateJson.combo['measureCombo'];
			if(!Ext.isEmpty(firstMeasure) && !Ext.isEmpty(firstMeasure[1]))
			{
				var displyName=firstMeasure[1].displayField;
				if(displyName != null && displyName.indexOf('(')>-1)
					displyName = displyName.substring(0,displyName.indexOf('('));
				component.setValue(displyName);
			}*/
			component.setValue(displyName);
		}
		else if (app.method=='testchange')
		{
			Ext.getCmp('er_durationContainer').hide();//...............
			Ext.getCmp('glduration').setValue('None');
			this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',app.templateJson,false,null,false);

			if(app.templateJson.combo.hasOwnProperty('descriptorCombo'))
			{
				descriptorCombo=app.templateJson.combo.descriptorCombo;
				var descriptorTxtField=Ext.getCmp('descriptorTxtField');
				descriptorTxtField.setValue(app.templateJson.combo.descriptorCombo[0].valueField);
			}
			//this.loadComboField('er_info','descriptorCombo',null,'',app.templateJson,true,'descmultipane',false);
			var component = Ext.ComponentManager.get('disp_MeasureName');
			var displyName = app.templateJson.selectedFields.selectedDispMeasureCombo;
			if(displyName != null && displyName.indexOf('(')>-1)
				displyName = displyName.substring(0,displyName.indexOf('('));
			component.setValue(displyName);
			this.onSelectDescFilter(Ext.getCmp('er_descFilter'));
		}
		else if(app.method=='measureChange')
		{
			//..for info measure only
			this.loadComboField('er_function','functionCombo',null,'selectedFunctionCombo',app.templateJson,false,null,false);
		}
		else if (app.method=='onFunctionChange')
		{
			Ext.getCmp('er_durationContainer').hide();//...............
			this.loadComboField('glduration','gldurationCombo',null,'selectedglduration',app.templateJson,false,null,false);
		}
		else if (app.method=='infoChange')
		{
			if(app.templateJson.combo.hasOwnProperty('descriptorCombo'))
			{
				descriptorCombo=app.templateJson.combo.descriptorCombo;
				var descriptorTxtField=Ext.getCmp('descriptorTxtField');
				descriptorTxtField.setValue(app.templateJson.combo.descriptorCombo[0].valueField);
			}
			//this.loadComboField('er_info','descriptorCombo',null,'',app.templateJson,true,'descmultipane',false);
		}
		else if (app.method=='setini')
		{
			if (app.templateJson.status=='success')
			{
				Ext.getCmp("reportlivesearch").setValue("");//..
				//var message='Report template is created successfully! \n Do you want to Run the Report?';
				var message='Report template is created successfully! Do you want to generate the report now?';
				if(app.updateTemplate)
				{
					app.updateTemplate=false;
					//message='Report template is updated successfully! \n Do you want to Run the Report?'
					message='Report template is updated successfully! Do you want to generate the report now?'
				}
				//this.getCallbackMessageBox('eG Custom Reports',message,app.method);
				var me=this;
				Ext.Msg.show({
					title : 'eG custom report',
					msg : message,
					cls:'egMsgBox',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal)
					{
						if (buttonVal == "yes")
						{
							var tempParam=app.infoParams;
							me.generateFromListView(tempParam.substring(tempParam.indexOf('=')+1,tempParam.indexOf('&')));
						}
						else
						{
							Ext.getCmp('reportbuildertop').show();
							if(app.isCustomLayout=='no')
							{
								me.getReportdataconfigwindow().doClose();
							}
							else
							{
								me.getWidgetLayoutPane().removeAllWidget();
								me.getWidgetLayoutPane().hide();
								//me.getWidgetLayoutPane().destroy();
							}
							me.onRenderReportBuilderGrid();
							me.setLayoutchange('single');	//to load ini entries in report builder grid (Shows all templates details)
						}

					}
				});
			}
			else
				this.getMessageBox('eG Custom Reports',app.templateJson.msg);
		}
		else
		{
			console.log('No action done');
		}
	},
	callAjax:function(url,param)
	{
		if(Ext.isEmpty(initLdgMask))
		{
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		}
		initLdgMask.show();
		var me=this;
		Ext.Ajax.request({
			url:url,
			params:param,
			scope:this,
			async:false,
			success : function(response){
				initLdgMask.hide();
				app.templateJson=Ext.decode(response.responseText);
				if(!Ext.isEmpty(app.templateJson))
					me.onAjaxSuccess();
			},
			faliure:function(err){
				Ext.MessageBox.alert('Error occured in ReportTemplateController.jsp page');
			}
		});
		params=null;delete params;
	},
	ajaxQueryMaker:function(obj)
	{
		var url='/final/reporter/ReportTemplateController.jsp';
		var param;
		if (obj.getId()=='reportdataconfigwindowid')
		{
			app.method='init';
			param='method='+app.method+'&er_option=Component'+"&chartType="+curChartType;
		}
		else if (obj.getId()=='er_compType')
		{
			app.method='comptypechange';
			param='method='+app.method+'&er_compType='+Ext.getCmp('er_compType').getValue()+"&er_testType="+Ext.getCmp("er_testType").getValue()+"&chartType="+curChartType;
		}
		else  if (obj.getId()=='er_testType')
		{
			var val=Ext.getCmp("er_testType").getValue();
			if(val=="Details")
			{
				if(curChartType!='table')
					Ext.getCmp("ddGroupInfoId").show();
				Ext.getCmp("ddGroupInfoTxtField").setValue('');
				Ext.getCmp("ddGroupInfoTxtField").fieldValues='';
				Ext.getCmp("er_measure").setFieldLabel("DD Columns");

			}
			else
			{	Ext.getCmp("er_measure").setFieldLabel("Measure");

				Ext.getCmp("ddGroupInfoId").hide();
				Ext.getCmp("ddGroupInfoTxtField").setValue('');
				Ext.getCmp("ddGroupInfoTxtField").fieldValues='';
			}
			app.method='comptypechange';
			param='method='+app.method+'&er_compType='+Ext.getCmp('er_compType').getValue()+"&er_testType="+val+"&chartType="+curChartType;
		}
		else if (obj.getId()=='er_test')
		{
			app.method='testchange';
			Ext.getCmp("ddGroupInfoTxtField").setValue('');
			Ext.getCmp("ddGroupInfoTxtField").fieldValues='';
			var testType=Ext.getCmp('er_testType').getValue();
			param='method='+app.method+'&er_test='+Ext.getCmp('er_test').getValue()+"&chartType="+curChartType;

		}
		else if (obj.getId()=='er_measure') //..
		{
			var component = Ext.ComponentManager.get('disp_MeasureName');
			var displyName = Ext.getCmp('er_measure').getRawValue();
			if(displyName != null && displyName.indexOf('(')>-1)
				displyName = displyName.substring(0,displyName.indexOf('('));
			component.setValue(displyName);
			//return;
			app.method='measureChange';
			param='method='+app.method+'&er_measure='+Ext.getCmp('er_measure').getValue()+"&chartType="+curChartType+"&er_testType="+Ext.getCmp("er_testType").getValue();
		}
		else  if (obj.getId()=='er_function')
		{
			app.method='onFunctionChange';
			param='method='+app.method+'&er_compType='+Ext.getCmp('er_compType').getValue()+"&er_testType="+Ext.getCmp("er_testType").getValue()+"&chartType="+curChartType+'&er_function='+Ext.getCmp("er_function").getValue();
		}
		else if(obj.getId()=="er_descFilter")
		{
			//infoChange
			app.method='infoChange';
			var testType=Ext.getCmp('er_testType').getValue();
			param='method='+app.method+'&er_test='+Ext.getCmp('er_test').getValue()+"&chartType="+curChartType;
		}
		this.callAjax(url,param);
	},
	layoutTypeChange:function(obj)
	{
		var chartOption=Ext.getCmp('layoutTypeid').getChecked()[0].getGroupValue();

		this.setLayoutchange(chartOption);

		Ext.getCmp('reportdataconfigwindowid').doComponentLayout();
		this.getReportdataconfigwindow().center();
	},
	setLayoutchange:function(chartOption)
	{
		var winId = Ext.getCmp('reportdataconfigwindowid');
		if(chartOption=='custom')
		{
			app.isCustomLayout='yes';
			if(winId!=undefined && winId!='undefined')
			{
				if (winId.modal)
				{
					Ext.fly(winId.dom).removeCls('windowModal');
				}
			}

			/* if (!Ext.isEmpty(this.getWidgetLayoutPane()))
			{
				this.getWidgetLayoutPane().removeAllWidget();
			} */

			Ext.getCmp('reportbuildertop').hide();
			Ext.getCmp('reportdataconfigurationid').hide();
			Ext.getCmp('tempCreate').hide();
			Ext.getCmp('advancedOptionGrayButtonId').hide();
			Ext.getCmp('addwidget').show();
			Ext.getCmp('addWidgetDone').show();

			Ext.getCmp('listViewBtnId').hide();
			Ext.getCmp('gridViewBtnId').hide();


			Ext.getCmp('reportBuilderBoxViewPage').hide();
			Ext.getCmp('reportbuildergridid').hide();
			Ext.getCmp('reportgroupid').hide();

			if(Ext.getCmp('widgetLayoutPane')!=undefined)
				Ext.getCmp('widgetLayoutPane').show();
			Ext.get('reportconfigsliderId').addCls("reportconfigsliderMultiple");
			
			// make digital chart is enable
			Ext.getCmp('digital').setDisabled(false);
			Ext.getCmp('multiDigi').setDisabled(false);
			Ext.getCmp('heatMap').setDisabled(false);//..
			Ext.getCmp('mainWindowHeader').update('<div class="font_bold13">'+mainWindowTitle+'</div>');
		}
		else if(chartOption=='single')
		{
			if(curChartType=='digital' || curChartType=='multiDigi' || curChartType=='heatMap')
			{
				var barBtn = Ext.getCmp('bar');
				barBtn.handler(barBtn); 
			}
			if(winId!=undefined && winId!='undefined')
			{
				if (winId.modal)
				{
					Ext.fly(winId.dom).addCls('windowModal');
				}
			}
			if (!Ext.isEmpty(this.getWidgetLayoutPane()))
			{
				this.getWidgetLayoutPane().removeAllWidget();
			}
			app.isCustomLayout='no'
			Ext.getCmp('reportbuildertop').show();
			if(defaultView=='boxView'){
				Ext.getCmp('reportBuilderBoxViewPage').show();
				Ext.getCmp('reportbuildergridid').hide();
			}
			else{
				Ext.getCmp('reportBuilderBoxViewPage').hide();
				Ext.getCmp('reportbuildergridid').show();
			}
			var thisMain= Ext.getCmp('reportTemplateMain');
			thisMain.doLayout();
			thisMain.doComponentLayout();

			Ext.getCmp('listViewBtnId').show();
			Ext.getCmp('gridViewBtnId').show();

			if(!Ext.isEmpty(this.getReportdataconfigwindow()))
			{
				Ext.getCmp('reportdataconfigurationid').show();
				Ext.getCmp('tempCreate').show();
				Ext.getCmp('advancedOptionGrayButtonId').show();
				Ext.getCmp('addwidget').hide();
				Ext.getCmp('addWidgetDone').hide();
			}

			if(Ext.getCmp('widgetLayoutPane')!=undefined)
				Ext.getCmp('widgetLayoutPane').hide();
			Ext.get('reportconfigsliderId').removeCls("reportconfigsliderMultiple");
			
			// make digital chart is disable
			Ext.getCmp('digital').setDisabled(true);
			Ext.getCmp('multiDigi').setDisabled(true);
			Ext.getCmp('heatMap').setDisabled(true);
			Ext.getCmp('mainWindowHeader').update('<div class="font_bold13">eG Custom Reports</div>');
		}
	},
	onClickAddWidget:function(obj)
	{
		var chartOption=curChartType;

		if (!Ext.isEmpty(curChartType))
		{
			if(Ext.getCmp('widgetLayoutPane')!=undefined)
			{
				this.getMain().setAutoScroll(true);
				//Ext.getCmp('widgetLayoutPane').setAutoScroll(false);
			}
			if (Ext.isEmpty(this.getWidgetLayoutPane()))
			{
				//alert('new gridster')
				this.getMain().add({xtype: 'gridster'});
				this.getMain().setAutoScroll(true);

			/*if (Ext.isEmpty(this.getWidgetLayoutPane()))
			 {
				//gridster
				this.getMain().add(Ext.create('utilities.gridsterPanel', {id:'widgetLayoutPane'}));
			}
			Ext.getCmp('widgetLayoutPane').addWidget() */
			}

			var xpos=1;
			var ypos=1;
			var xlength=6;
			var ylength=3;
			if(curChartType=='digital')
			{
				xlength=3;
				ylength=3;
			}
			if(curChartType=='multiDigi')
			{
				xlength=12;
				ylength=2;
			}
			Ext.getCmp('widgetLayoutPane').addWidget(curChartType,xlength,ylength,xpos,ypos,'','iconConfigUser','','',null)
		}
	},
	onClickWidgetModify:function(widget)
	{
		app.currentWidget=widget;
		var widgetConfig=widget.widgetConfig;
		if (!Ext.isEmpty(widgetConfig))
		{
			curChartType=widget.chartType;
			if (!Ext.isEmpty(widgetConfig.chartConfigArray))
			{
				Ext.widget('reportdataconfigwindow');
				Ext.getCmp('configdataid').getStore().removeAll();
				this.getReportdataconfigwindow().show();
				// this.getReportdataconfigwindow().center();
				Ext.getCmp('tempCreate').hide();
				Ext.getCmp('addTowidget').show();
				Ext.getCmp('layoutTypeid').hide();
				Ext.getCmp('SearchChartType').hide();
				Ext.getCmp('reportconfigsliderId').hide();
				Ext.getCmp('reportdataconfigwindowid').doComponentLayout();
				app.method=null;
				this.resetReportGroup(curChartType,true);
				//if(app.updateTemplate)
				//{
					//console.log(app.currentWidget)
					configureWindowGraphCls=this.getGrayChartIconOrDefaultTitle(widgetConfig.chartType,'color');
					Ext.getCmp('multiLayoutDesEditId').show();
					Ext.getCmp('multiLayoutDesEditSepId').show();
					Ext.getCmp('userDefinedWidgetIcon').addCls(configureWindowGraphCls);
					//alert(Ext.get(widget.header.id+'_hd-textEl').dom.innerHTML);
					if(this.getGrayChartIconOrDefaultTitle(curChartType,'title')==Ext.get(widget.header.id+'_hd-textEl').dom.innerHTML)// true means get title
					{
						
						if(curChartType!='digital' && curChartType!='multiDigi')
						{
							Ext.getCmp('WidgetNametextField').setValue('');
							Ext.getCmp('WidgetNametextField').show();
							Ext.getCmp('userDefinedWidgetNameLbl').hide();
						}
						else
						{
							Ext.getCmp('WidgetNametextField').setValue(Ext.get(widget.header.id+'_hd-textEl').dom.innerHTML);
						}
					}
					else
					{
						Ext.getCmp('WidgetNametextField').setValue(Ext.get(widget.header.id+'_hd-textEl').dom.innerHTML);
					}
					Ext.getCmp('userDefinedWidgetNameLbl').setText(Ext.get(widget.header.id+'_hd-textEl').dom.innerHTML);
				//}
				this.modifyAllConfig(widgetConfig,widgetConfig.chartConfigArray,widgetConfig.ddChkBoxData);
			}
			else
			{
				this.onClickConfigWidget(widget);
			}
		}
		else
		{
			this.onClickConfigWidget(widget);
		}
	},
	onClickConfigWidget:function(obj)
	{
		var chartOption;
		var currentPannel;
		var fromEditButton=false;
		if (app.isCustomLayout=='yes')
		{
			chartOption=obj.chartType;
			fromEditButton=true;
			currentPannel=obj;

			// venagt..added for configure view while edit button is pressed
			if(chartOption==undefined||chartOption=='undefined')
			{
				fromEditButton=false;
				//console.log(obj.up('panel'))
				chartOption=obj.up('panel').chartType;
				currentPannel=obj.up('panel');
			}
			//end
		}
		else
		{

		}
		curChartType=chartOption;
		//alert(curChartType)
		Ext.widget('reportdataconfigwindow');

		Ext.getCmp('configdataid').getStore().removeAll();
		this.getReportdataconfigwindow().show();
		this.getReportdataconfigwindow().center();
		Ext.getCmp('tempCreate').hide();
		Ext.getCmp('addTowidget').show();
		Ext.getCmp('layoutTypeid').hide();
		Ext.getCmp('SearchChartType').hide();
		Ext.getCmp('reportconfigsliderId').hide();
		Ext.getCmp('reportdataconfigurationid').addCls('singleEdit');
		Ext.getCmp('reportdataconfigwindowid').doComponentLayout();
 		app.method=null;
		if(fromEditButton)
			app.currentWidget=obj;
		else
			app.currentWidget=obj.up('panel');

		this.resetReportGroup(curChartType,true);

		configureWindowGraphCls=this.getGrayChartIconOrDefaultTitle(curChartType,'color');
		Ext.getCmp('multiLayoutDesEditId').show();
		Ext.getCmp('multiLayoutDesEditSepId').show();
		Ext.getCmp('userDefinedWidgetIcon').addCls(configureWindowGraphCls);
		if(this.getGrayChartIconOrDefaultTitle(curChartType,'title')== Ext.get(currentPannel.header.id+'_hd-textEl').dom.innerHTML)
		{
			if(curChartType!='digital' && curChartType!='multiDigi')
			{
				Ext.getCmp('WidgetNametextField').setValue('');
				Ext.getCmp('WidgetNametextField').show();
				Ext.getCmp('userDefinedWidgetNameLbl').hide();
			}
			else
			{
				Ext.getCmp('WidgetNametextField').setValue(Ext.get(currentPannel.header.id+'_hd-textEl').dom.innerHTML);
			}
		}
		else
		{
			Ext.getCmp('WidgetNametextField').setValue(Ext.get(currentPannel.header.id+'_hd-textEl').dom.innerHTML);
		}
		Ext.getCmp('userDefinedWidgetNameLbl').setText(Ext.get(currentPannel.header.id+'_hd-textEl').dom.innerHTML);

		//this.ajaxQueryMaker(this.getReportdataconfigwindow());

	},
	loadBasedOnMeasureWithTop:function(chartInfo,configGridData)
	{
		//console.log(chartInfo)
		//console.log(configGridData)
		if (chartInfo.enableTopN=='yes')
		{
			Ext.getCmp('er_top').setValue(chartInfo.top);
		}
			var er_basedOnMeasure=Ext.getCmp('er_basedOnMeasure');
			var er_basedOnMeasureArray=new Array();
			er_basedOnMeasureArray.push({
				displayField:'Please choose test/measure',
				valueField:'-1'
			});

		for (var key in configGridData)
		{
			var record=configGridData[key];
			var configString=record.configString;
			var configStringSpl=configString.split("=");
			var configStringSpl2=configStringSpl[1].split("|");
			var basedMeas=record.testValue+'/'+record.measureValue+'$~$'+(record.displayName).trim()+'$~$'+record.glduration+'$~$'+record.er_duration;

			//console.log(basedMeas)
			er_basedOnMeasureArray.push({
				displayField:record.displayName,
				valueField:basedMeas
			});
		}
		er_basedOnMeasure.getStore().loadRawData(er_basedOnMeasureArray);

		if(chartInfo.chartType == 'table'&& chartInfo.enableTopN=='yes')
		{
			var basedOnTestMeas=chartInfo.basedOnTestMeasure;
			//console.log(basedOnTestMeas)
			basedOnTestMeas=basedOnTestMeas.replace(/\"/g, "");

			//console.log(basedOnTestMeas)
			er_basedOnMeasure.setValue(basedOnTestMeas);
		}
	},
	modifyAllConfig:function(chartInfo,configGridData,ddChkBoxData)
	{
		Ext.getCmp('reportdataconfigurationid').addCls('singleEdit');
		if(chartInfo.showMultipleCharts=="true")
		{
			Ext.getCmp("showMultipleCharts").setValue(true);
		}
		else
		{
			Ext.getCmp("showMultipleCharts").setValue(false);
		}

		if( chartInfo.chartType=="area" )
		{
			if(chartInfo.er_stackedArea==undefined || chartInfo.er_stackedArea=='undefined')
			{

			}
			else if(chartInfo.er_stackedArea=='true')
				Ext.getCmp("er_stackedArea").setValue(true);
			else
				Ext.getCmp("er_stackedArea").setValue(false);
		}
		else
		{
			Ext.getCmp('er_stackedArea').hide();
		}
		Ext.getCmp('primgroupbyComp').setValue(false);
		Ext.getCmp('requeredDispId').setValue({"reqDispCkbox":['']});
		/*Ext.getCmp('metricsCheckbox').setValue(false);
		Ext.getCmp('compCheckbox').setValue(false);
		Ext.getCmp('descCheckbox').setValue(false);*/
		Ext.getCmp('primgroupbyDesc').collapse();
		Ext.getCmp('groupByDateCB').collapse();
		for(var i=0;i<chartInfo.groupBy.length;i++)
		{
			var val=chartInfo.groupBy[i];
			if(val=="date" || val=="week" || val=="month")
			{
				Ext.getCmp('groupByDateCB').expand();
				Ext.getCmp('primGroupByDateId').setValue({"primgroupbybox":[val]});
				//break;
			}
			else if(val=="descriptors" )
			{
				Ext.getCmp('primgroupbyDesc').expand();
				if(chartInfo.descDisplayName!=undefined && chartInfo.descDisplayName!='undefined')
				{
					Ext.getCmp('descriptorTxtFieldId').setValue(chartInfo.descDisplayName);
					Ext.getCmp('descriptorLblId').setText(chartInfo.descDisplayName);
				}
			}
			else if(val=="component" )
			{
				Ext.getCmp('primgroupbyComp').setValue(true);
			}
		}
		//..Apply selected customize display name(Comp,Desc,Metrics)
		//alert("==cusDisplaname===>>>>>>>>>"+chartInfo.enableDispName);
		var enableDispName=chartInfo.enableDispName;
		if(enableDispName != undefined && enableDispName == 'yes')
		{
			//alert("===1===>>>>>>>");
			if(chartInfo.enableMetrics == 'yes')
				Ext.getCmp('metricsCheckbox').setValue(true);
			if(chartInfo.enableComp == 'yes')
				Ext.getCmp('compCheckbox').setValue(true);
			if(chartInfo.enableDesc == 'yes')
				Ext.getCmp('descCheckbox').setValue(true);
		}
		//..


		Ext.getCmp('er_enableTopN').setValue({'enableTopN':chartInfo.enableTopN});
		if(chartInfo.isDescFilter=='yes')
			Ext.getCmp('descFilterRadioGroup').setValue(true);
		else
			Ext.getCmp('descFilterRadioGroup').setValue(false);//..

		var ddGroupByBoxId=Ext.getCmp('ddGroupByBoxId');
		ddGroupByBoxId.removeAll();
		console.log('ddChkBoxData',ddChkBoxData)
		if(ddChkBoxData.length==0)
		{
		 for (var key in chartInfo.ddGroupBy)
			{
				var ddMeasure=chartInfo.ddGroupBy[key];
				var ddDispMeasure=ddMeasure;
				if(ddMeasure.indexOf('$~$') > -1)
				{
					ddDispMeasure=ddDispMeasure.substring(ddMeasure.indexOf('$~$')+3,ddMeasure.length);
					ddMeasure=ddMeasure.substring(0,ddMeasure.indexOf('$~$'));
				}
				ddMeasure=replaceAll(ddMeasure,"_"," ");
				//ddGroupByBoxId.add({ boxLabel: chartInfo.ddGroupBy[key],id:chartInfo.ddGroupBy[key]+'-group',name: 'ddgroupbybox', inputValue:chartInfo.ddGroupBy[key], checked: true });
				ddGroupByBoxId.add({ boxLabel: ddDispMeasure,id:ddDispMeasure+'-group',name: 'ddgroupbybox', inputValue:chartInfo.ddGroupBy[key], checked: true, readOnly: true });
			}
		}
		else
		{
			for (var key in ddChkBoxData)
			{
				//alert(1234)
				var ddMeasure=ddChkBoxData[key];
				console.log('ddMeasure',ddMeasure);
				ddGroupByBoxId.add({ boxLabel: ddMeasure.id,id:ddMeasure.id+'-group',name: 'ddgroupbybox', inputValue:ddMeasure.value, checked: true, readOnly: true });
			}
		}

		Ext.getCmp('configdataid').getStore().loadRawData(configGridData);
		this.loadBasedOnMeasureWithTop(chartInfo,configGridData);//..
		app.editSortby=chartInfo.sortByValue;
		this.loadSortByCombo(chartInfo.sortByValue);
	},
	loadSortByCombo:function(val)
	{
		//alert("=======val========>>>>>>>>>>"+val);
		var sortComboBx=Ext.getCmp("er_sortByCombo");
		sortComboBx.hide();
		if(curChartType=="table")
		{
			sortComboBx.show();
			var dataArr=[];
			var gridObj = Ext.getCmp('configdataid');
			var gridStore = gridObj.getStore();
			var hasVal=false;
			//..
			var jsonData = {};
			jsonData["displayField"] = 'Please select a Measure';
			jsonData["valueField"] = '-1';
			dataArr.push(jsonData);
			//..
			gridStore.each(function(record) {
				var jsonData = {};


				jsonData["displayField"] = record.raw.displayName.trim();

				jsonData["valueField"] = record.raw.displayName.trim();
				if(val==record.raw.displayName.trim())
				{
					hasVal=true;
					val=record.raw.displayName.trim();
				}
				dataArr.push(jsonData);
			});
			sortComboBx.getStore().loadRawData(dataArr);
			if(!hasVal && dataArr.length>0)
				val=dataArr[0].valueField;
			sortComboBx.setValue(val);
		}
	},
	cancelCreation:function(obj)
	{
		if (!Ext.isEmpty(this.getWidgetLayoutPane()))
		{
			this.getWidgetLayoutPane().removeAllWidget();
			this.getWidgetLayoutPane().hide();
			//this.getWidgetLayoutPane().destroy();
		}
		app.isCustomLayout='no';
		app.isfreshTemplate='no';
		Ext.getCmp('reportbuildertop').show();
		Ext.getCmp('listViewBtnId').show();
		Ext.getCmp('gridViewBtnId').show();
		if(defaultView=='boxView'){
			Ext.getCmp('reportBuilderBoxViewPage').show();
			Ext.getCmp('reportbuildergridid').hide();
		}
		else{
			Ext.getCmp('reportBuilderBoxViewPage').hide();
			Ext.getCmp('reportbuildergridid').show();
		}
		var thisMain= Ext.getCmp('reportTemplateMain');
		Ext.getCmp('mainWindowHeader').update('<div class="font_bold13">eG Custom Reports</div>');
		thisMain.setAutoScroll(false);
		thisMain.doLayout();
		thisMain.doComponentLayout();

	},
	editTemplateDecs:function(obj)
	{
		Ext.widget('customwindow');
		this.getCustomwindow().setTitle("Create New Template");
		this.getCustomwindow().add({xtype:'reportdescriptionalias'});
		this.getCustomwindow().show();
		Ext.getCmp("create").hide();
		Ext.getCmp("saveEdit").show();

	},
	saveEditInfo:function()
	{
		var templateName=Ext.getCmp('templateName').getValue();
		var templateDescription=Ext.getCmp('templateDescription').getValue();
		var sharing='';
		var userList;
		var user_List=[];
		if(Ext.getCmp('privateId2').pressed)
			sharing="Private";
		else if(Ext.getCmp('PublicId2').pressed)
			sharing="Public";
		else if(Ext.getCmp('shareId2').pressed)
		{
			sharing="Share";

			userList=Ext.getCmp('user_list');
			var selectedUser=userList.getSelectionModel().getSelection();
		}


		if(sharing=="Share")
		{
			if(selectedUser=="" || selectedUser.length==0)
			{
				this.getMessageBox('eG Custom Reports','Please Select User list');
				return;
			}
			else
			{
				for (var i=0;i<selectedUser.length;i++)
				{
					var row = userList.getSelectionModel().getSelection()[i];
					user_List.push(row.data.valueField)
				}
			}
		}

		if (!Ext.isEmpty(this.getCustomwindow()))
		{
			this.getCustomwindow().doClose();
		}

		app.infoParams='templateName='+templateName+'&templateDescription='+templateDescription+'&sharing='+sharing+'&userList='+user_List;
	},
	addMoreWidget:function(obj)
	{
		if(curChartType=='')
			curChartType='bar';
		Ext.widget('reportdataconfigwindow');
		Ext.getCmp('configdataid').getStore().removeAll();
		this.getReportdataconfigwindow().show();
		var radio = Ext.getCmp('custom');
        radio.setValue(true);
		Ext.getCmp('layoutTypeid').disable();

	},
	loadTestMeasureInfos:function(){
		this.loadComboField('er_test','testCombo',null,'selectedTestCombo',app.templateJson,false,null,false);
		if (app.method!='comptypechange')
			this.loadComboField('er_testType','testTypeCombo',null,'selectedTestTypeCombo',app.templateJson,false,null,false);
		this.loadComboField('glduration','gldurationCombo',null,'selectedglduration',app.templateJson,false,null,false);
		this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',app.templateJson,false,null,false);

		if(app.templateJson.combo.hasOwnProperty('descriptorCombo'))
		{
			descriptorCombo=app.templateJson.combo.descriptorCombo;
			var descriptorTxtField=Ext.getCmp('descriptorTxtField');
			descriptorTxtField.setValue(app.templateJson.combo.descriptorCombo[0].valueField);
		}
		this.onRenderReportConfig(Ext.getCmp('glduration'));
		this.onSelectDescFilter(Ext.getCmp('er_descFilter'));
	},
	onSelectDescFilter:function(obj)
	{
		if (!Ext.isEmpty(obj))
		{
			if (obj.getValue()=='all')
			{
				Ext.getCmp('descIncluderId').hide();
				Ext.getCmp('descriptorTxtField').hide();
			}
			else
			{
				Ext.getCmp('descIncluderId').show();
				Ext.getCmp('descriptorTxtField').show();
				console.log("===descfilter");//..
				this.ajaxQueryMaker(obj);
			}
		}
	},
	onRenderReportBuilderGrid:function(obj)
	{
		app.method='getini';
		var url='/final/reporter/ReportTemplateController.jsp';
		var param='method='+app.method+"&builderType="+app.builderType;
	//	console.log(param);
		this.callAjax(url,param);
	},
	loadGridData:function()
	{
		this.getMain().setAutoScroll(false);
		var dataArray=app.templateJson.gridData;
		var datArray=this.getReportbuildergridalias().dataArray;
		var dummyArray=this.getReportbuildergridalias().dummyArray;

		var dataViewIdObj=Ext.getCmp('dataViewId');
		var boxViewDummyArray=this.getReportbuilderboxview().dummyArray;
		dataViewIdObj.getStore().removeAll();
		boxViewDummyArray.splice(0, boxViewDummyArray.length);
		dataViewIdObj.getStore().loadRawData(app.templateJson.listViewData);
		for(var i=0;i<app.templateJson.listViewData.length;i++)
		{
			boxViewDummyArray.push(dataArray[i]);
		}

		//console.log(this.getReportbuilderboxview().dummyArray)

		this.getReportbuildergridalias().getStore().removeAll();

		datArray.splice(0, datArray.length);
		dummyArray.splice(0, dummyArray.length);
		tempTitleAry=[];//....

		//console.log("=======tempTitleAry=====after clear===="+tempTitleAry);
		//console.log("===dataArray==========>>>"+JSON.stringify(dataArray));
		for(var i=0;i<dataArray.length;i++)
		{
			tempTitleAry.push(dataArray[i].templateName.toLowerCase());
			datArray.push(dataArray[i]);
			dummyArray.push(dataArray[i]);
		}
		if(app.builderType == 'generate')
		{
			Ext.getCmp('reportbuildergridid').headerCt.child('gridcolumn[isCheckerHd]').hide();
			Ext.getCmp('reportbuildergridid').down('[dataIndex=sharing]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=createdDate]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=goColumn]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=modify]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=remove]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[id=addTemplate]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=sharedBy]').setVisible(true);
		}
		else
			Ext.getCmp('reportbuildergridid').down('[dataIndex=sharedBy]').setVisible(false);

		var curpage=this.getReportbuildergridalias().activePage;
		var totalCount=this.getReportbuildergridalias().getStore().totalCount;
		var pageSize=this.getReportbuildergridalias().getStore().pageSize;
		if(Math.round(totalCount/pageSize)<curpage)
		{
			this.getReportbuildergridalias().activePage=Math.round(totalCount/pageSize);
		}
		if(this.getReportbuildergridalias().activePage<=0)
			this.getReportbuildergridalias().activePage=1;
		this.getReportbuildergridalias().getStore().loadPage(this.getReportbuildergridalias().activePage);
	},
	typewatch:function(field, event){
		 this.searchTask.delay(500);
	},
	typewatchBoxView:function(field, event){
		 this.boxViweSearchTask.delay(500);

	},
	boxViewFilter:function()
	{
		var field=Ext.getCmp('reportlivesearchList');
		var dataViewIdObj=Ext.getCmp('dataViewId');
		var dummyArray=this.getReportbuilderboxview().dummyArray;
		var listViewData=[];
		dataViewIdObj.getStore().removeAll();
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			var regex = RegExp(field.value, 'i');
			listViewData.splice(0, listViewData.length);

			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				Ext.Object.each(obj, function (property, value) {
					if(property=="templateName" || property=="templateTitle" || property=="templateDescription")
						match =match || regex.test(String(value));
				});
				if(match)
					listViewData.push(obj);
			}
		}
		else
		{
			listViewData.splice(0, listViewData.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				listViewData.push(obj);
			}
		}
		dataViewIdObj.getStore().loadRawData(listViewData);
		field.focus();
	},
	doFilter:function( ){
		var me=this;
		var field=Ext.getCmp('reportlivesearch');
		var dataArray=this.getReportbuildergridalias().dataArray;
		var dummyArray=this.getReportbuildergridalias().dummyArray;
		this.getReportbuildergridalias().getStore().removeAll();
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			var regex = RegExp(field.value, 'i');
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				Ext.Object.each(obj, function (property, value) {
					if(property=="templateName" || property=="templateTitle" || property=="templateDescription")
						match =match || regex.test(String(value));
				});
				if(match)
					dataArray.push(obj);
			}
			this.getReportbuildergridalias().getStore().loadRawData(dataArray);
		}
		else
		{
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				dataArray.push(obj);
			}
			this.getReportbuildergridalias().getStore().loadRawData(dataArray);
			this.getReportbuildergridalias().getStore().loadPage(this.getReportbuildergridalias().activePage);
		}
		//this.getReportbuildergridalias().getStore().load();
		field.focus();
	},
	getTemplateInfo:function(templateName)
	{
		//alert("not yet configured")
		 var record = new Object();
		record.templateName=templateName;
		if(!Ext.isEmpty(Ext.getCmp("updateConfigBtn")))
			Ext.getCmp("updateConfigBtn").setText("Update to Widget");
		isEditTemplate=true;
		var url='/final/reporter/ReportTemplateController.jsp';
		app.method='getTemplateInfo';
		var param='method='+app.method+'&recordInfo='+Ext.encode(record);
		this.callAjax(url,param);
	},
	onClickAddTemplate:function(obj)
	{
		app.isfreshTemplate='yes';
		curChartType='bar';
		Ext.widget('customwindow');
		this.getCustomwindow().setTitle("Create New Template");
		this.getCustomwindow().add({xtype:'reportdescriptionalias'});
		this.getCustomwindow().show();
		Ext.getCmp("templateName").focus(false, 200);
	},
	loadAllUser:function()
	{
		var url="ReportTemplateController.jsp";
		app.method='getUsers';
		var param;
		param='method='+app.method;
		Ext.Ajax.request({
			url:url,
			params:param,
			//async:isAsync,
			success : function(response){
				app.builderJson=Ext.decode(response.responseText);
				var component = Ext.ComponentManager.get('user_list');
				var rawData = app.builderJson;
				if(component!=undefined&&component!='undefined')
				{
					component.getStore().removeAll();
					component.getStore().loadRawData(rawData['userArray']);
				}
				if(isEditTemplate && app.isCustomLayout=='yes')
				{
					var templateNameField= Ext.getCmp("templateName")
					templateNameField.readOnly=true;
					var entireArray = (app.infoParams).split('&');
					var templateName = entireArray[0].replace('templateName=','');
					var templateDescription = entireArray[1].replace('templateDescription=','');
					var sharing = entireArray[2].replace('sharing=','');
					var userList = entireArray[3].replace('userList=','');
					var user_List = userList.split(',');
					templateNameField.setValue(templateName);
					Ext.getCmp("templateDescription").setValue(templateDescription);
					Ext.getCmp("templateDescription").focus(false, 200);

					if(sharing=='Private')
					{
						Ext.getCmp('privateId2').toggle(true);
					}
					if(sharing=='Public')
					{
						Ext.getCmp('PublicId2').toggle(true);
					}
					if(sharing=='Share')
					{
						Ext.getCmp('shareId2').toggle(true);
						Ext.getCmp('sharedUsersObj2').el.setStyle('visibility','visible');
						for(var usrs in user_List)
						{
							var record1 = component.getStore().findRecord("valueField", user_List[usrs]);
							component.getSelectionModel().select(record1,true);
						}
					}
					//console.log(templateName+' '+templateDescription+' '+sharing+' '+userList);
				}
				else if(isEditTemplate && app.isCustomLayout=='no')
				{
					component = Ext.ComponentManager.get('user_list_edit');
					component.getStore().removeAll();
					component.getStore().loadRawData(rawData['userArray']);
					var entireArray = (app.infoParams).split('&');

					var sharing = entireArray[2].replace('sharing=','');
					var userList = entireArray[3].replace('userList=','');
					var user_List = userList.split(',');

					if(sharing=='Private')
					{
						Ext.getCmp('privateId_edit').toggle(true);
					}
					if(sharing=='Public')
					{
						Ext.getCmp('PublicId_edit').toggle(true);
					}
					if(sharing=='Share')
					{
						Ext.getCmp('shareId_edit').toggle(true);
						Ext.getCmp('sharedUsersObj_edit').el.setStyle('visibility','visible');
						for(var usrs in user_List)
						{
							var record1 = component.getStore().findRecord("valueField", user_List[usrs]);
							component.getSelectionModel().select(record1,true);
						}
					}

				}

			},
			failure:function(err){
				Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
			}
		});
	},
	onClickCreateBtn:function(obj)
	{
		//alert('app.isfreshTemplate==')
		if(app.isfreshTemplate=='yes')
		{
			app.isCustomLayout='no';
		}
		var templateName;
		var templateDescription;
		var sharing;
		var userList;
		var user_List=[];
		if (obj.getId()=='reportbuildergridid' && app.method=='getTemplateInfo')
		{
			templateName=app.templateJson.templateInfo.templateName;
			templateDescription=app.templateJson.templateInfo.templateDescription;
			sharing=app.templateJson.templateInfo.sharing;
			//userList=app.templateJson.templateInfo.userList;
			user_List=(app.templateJson.templateInfo.userList).split(',');

		}
		else if (obj.getId()=='create')
		{
			isEditTemplate=false;
			app.method=null;
			templateName=Ext.getCmp('templateName').getValue();
			//templateTitle=Ext.getCmp('templateTitle').getValue();
			templateDescription=Ext.getCmp('templateDescription').getValue();
			
			if(Ext.getCmp('privateId2').pressed)
				sharing="Private";
			else if(Ext.getCmp('PublicId2').pressed)
				sharing="Public";
			else if(Ext.getCmp('shareId2').pressed)
			{
				sharing="Share";

				userList=Ext.getCmp('user_list');
				var selectedUser=userList.getSelectionModel().getSelection();
			}


			if(templateName=="" || templateName.length==0)
			{
				this.getMessageBox('eG Custom Reports','Template name should not be empty');
				return;
			}

			 if(tempTitleAry.length>0 && tempTitleAry.indexOf(templateName.toLowerCase())>-1){
				this.getMessageBox('eG Custom Reports','Template name already exists.');
				return;
			}

			if(sharing=="Share")
			{
				if(selectedUser=="" || selectedUser.length==0)
				{
					this.getMessageBox('eG Custom Reports','Please Select User list');
					return;
				}
				else
				{
					for (var i=0;i<selectedUser.length;i++)
					{
						var row = userList.getSelectionModel().getSelection()[i];
						user_List.push(row.data.valueField)
					}
				}
			}
			mainWindowTitle = templateName;
		}

		if (!Ext.isEmpty(this.getCustomwindow()))
		{
			this.getCustomwindow().doClose();
		}

 		app.infoParams='templateName='+templateName+'&templateDescription='+templateDescription+'&sharing='+sharing+'&userList='+user_List;
		//console.log('app.infoParams  ',app.infoParams);
		if (app.method=='getTemplateInfo')
		{
			app.method='loadTemplateInfo';
			var templateInfo=app.templateJson.templateInfo;
			app.isCustomLayout=templateInfo.isCustomLayout;

			if (templateInfo.isCustomLayout=='no')
			{
				if (templateInfo.hasOwnProperty('chartInfo'))
				{
					curChartType=templateInfo.chartInfo.chartType;
				}
				Ext.widget('reportdataconfigwindow');

				Ext.getCmp('configdataid').getStore().removeAll();
				this.getReportdataconfigwindow().show();
				this.getReportdataconfigwindow().center();
				this.getReportdataconfigwindow().setTitle('Config Report Template - Edit mode');
				Ext.getCmp('tempCreate').show();
				Ext.getCmp('singleLayoutDesEditId').show();
				Ext.getCmp('addTowidget').hide();
				Ext.getCmp('layoutTypeid').hide();
				Ext.getCmp('SearchChartType').hide();
				Ext.getCmp('reportconfigsliderId').hide();
				Ext.getCmp('reportdataconfigwindowid').doComponentLayout();
				configureWindowGraphCls=this.getGrayChartIconOrDefaultTitle(curChartType,'color');
				Ext.getCmp('userDefinedTemplateIcon').addCls(configureWindowGraphCls);

				Ext.getCmp('editSharingId').show();
				Ext.getCmp('userDefinedTemplateNameLbl').setText(templateName);
				Ext.getCmp('descriptionId').setValue(templateDescription);
				this.loadAllUser();
				app.method='loadTemplateInfo';
				this.resetReportGroup(curChartType,false);
			}
			else
			{
				mainWindowTitle = templateName;
			}

			this.onAjaxSuccess();
		}
		else
		{
			Ext.widget('reportdataconfigwindow');

			Ext.getCmp('configdataid').getStore().removeAll();
			this.getReportdataconfigwindow().show();
			this.getReportdataconfigwindow().setTitle('Config Report Template ('+templateName+')');
			this.resetReportGroup(curChartType,true);
			//this.ajaxQueryMaker(this.getReportdataconfigwindow());
		}

		if(obj.getId()=='create')
		{
			//this.clearDataGridStore();
			if(!Ext.isEmpty(this.getWidgetLayoutPane())){
				//this.getWidgetLayoutPane().removeAll();
				this.getWidgetLayoutPane().removeAllWidget();
			}
		}

	},
	resetReportGroup:function(chartType,reloadRequried)
	{
		Ext.getCmp('showMultipleCharts').setValue(false);
		Ext.getCmp('primgroupbyComp').setValue(false);
		Ext.getCmp('primgroupbyDesc').collapse();
		Ext.getCmp('groupByDateCB').collapse();
		Ext.getCmp('advancedOptionGrayButtonId').show();
		if(chartType=='pie' || chartType=='distribution' || chartType=='distributedPie')
		{
			if(app.isCustomLayout=='yes')
				Ext.getCmp('primgroupbyComp').hide();
			else
				Ext.getCmp('primgroupbyComp').setValue(true);
		}
		else if(chartType!='digital' && chartType!='multiDigi')
		{
			Ext.getCmp('primgroupbyComp').setValue(true);
		}
		else
		{
			// coming if and only if digital and multiDigi chart
			Ext.getCmp('advancedOptionGrayButtonId').hide();
		}

		//Ext.getCmp("groupByDateCB").collapse();
		//..initial checked all
	//	Ext.getCmp('reqDispCkbox').setValue(true);
		Ext.getCmp('requeredDispId').setValue({"reqDispCkbox":['enableMetrics','enableComp','enableDesc']});
		/*Ext.getCmp('metricsCheckbox').setValue(true);
		Ext.getCmp('compCheckbox').setValue(true);
		Ext.getCmp('descCheckbox').setValue(true);*/
		//..

		var er_sortByCombo= Ext.getCmp("er_sortByCombo");
		er_sortByCombo.getStore().removeAll();
		var er_sortByComboAry=new Array();
		er_sortByComboAry.push({
			displayField:'Please choose test/measure',
			valueField:'-1'
		});
		er_sortByCombo.getStore().loadRawData(er_sortByComboAry);
		er_sortByCombo.setValue('-1');

		var er_stackedArea = Ext.getCmp("er_stackedArea");
		er_stackedArea.setValue(false);
		Ext.getCmp('ddGroupByBoxId').removeAll();
		Ext.getCmp('er_enableTopN').setValue({'enableTopN':'no'});
		Ext.getCmp('er_top').getStore().removeAll();
		Ext.getCmp('er_top').hide();
		var er_basedOnMeasure = Ext.getCmp('er_basedOnMeasure')
		er_basedOnMeasure.getStore().removeAll();
		tempGridMesaureAry=[];
		Ext.getCmp('er_basedOnMeasure').hide();
		var er_basedOnMeasureAry=new Array();
		er_basedOnMeasureAry.push({
			displayField:'Please choose test/measure',
			valueField:'-1'
		});
		er_basedOnMeasure.getStore().loadRawData(er_basedOnMeasureAry);
		er_basedOnMeasure.setValue('-1');


		Ext.getCmp('configdataid').getStore().removeAll();

		if(chartType=="timeline" || chartType=="heatMap" || chartType=="bar" || chartType=="area" || chartType=="vertbar")
		{
			Ext.getCmp('showMultipleCharts').show();
			if(app.isCustomLayout=='yes')
			{
				Ext.getCmp('showMultipleCharts').setValue(true);
				Ext.getCmp('showMultipleCharts').disable();
			}
		}
		else
		{
			Ext.getCmp('showMultipleCharts').hide();
		}

		if(chartType=="pie" || chartType=="distribution" || chartType=="distributedPie")
		{
			Ext.getCmp("groupByDateCB").hide();
		}
		else
		{
			Ext.getCmp("groupByDateCB").show();
		}
		if(chartType=="table")
		{
			er_sortByCombo.show();
		}
		else
		{
			er_sortByCombo.hide();
		}
		if( chartType=="area" )
		{
			er_stackedArea.show();
		}
		else
		{
			er_stackedArea.hide();
		}
		Ext.get("descFilterRadioGroup").hide();

		if(chartType=="topn")
		{
			Ext.getCmp('er_enableTopN').setValue({'enableTopN':'yes'});
			Ext.getCmp('er_enableTopN').setDisabled(true);
			Ext.getCmp('groupByDateCB').hide();
			Ext.get('er_top').show();
		}
		else
		{
			Ext.getCmp('er_enableTopN').setDisabled(false);
		}

		if(reloadRequried)
		{
			var url='/final/reporter/ReportTemplateController.jsp';
			var param;
			app.method='init';
			param='method='+app.method+'&er_option=Component'+"&chartType="+chartType;
			this.callAjax(url,param);
		}
	},
	processDescpFilter:function(checked)
	{
		if (checked)
		{
			var gridObj = Ext.getCmp('configdataid');
			var gridStore = gridObj.getStore();
			var noOfrecords = gridStore.getCount();
			var sameDescMethod=true;
			if(noOfrecords>1)
			{
				var hasAll=false;
				var hasSpec=false;
				gridStore.each(function(record) {
					if(record.get("descriptor")=="-")
						hasAll=true;
					else if(record.get("descriptor")!="-")
						hasSpec=true;
				});
				if(hasSpec && hasAll)
					sameDescMethod=false;
			}
			if(sameDescMethod && app.isCustomLayout=='no')
			{
				Ext.get('descFilterRadioGroup').show();
			}
			else
				Ext.get('descFilterRadioGroup').hide();
		}
		else
		{
			Ext.get('descFilterRadioGroup').hide();
		}
	},
	 onEnableTopNchange:function (btn)
	{
		//alert("======curChartType===>>>>>>>>"+curChartType);
		var value=btn.getValue().enableTopN;
		if(value=="yes")
		{
			Ext.get('er_top').show();
			if (app.isCustomLayout=='yes' && curChartType=="table")
			{
				Ext.get('er_basedOnMeasure').show();
			}
			else if(curChartType=="table")
			{
				Ext.get('er_basedOnMeasure').show();
				//this.FetchBasedOnMeasValue();
			}
			else
			{
				Ext.get('er_basedOnMeasure').hide();
			}
		}
		else
		{
			Ext.get('er_top').hide();
			Ext.get('er_basedOnMeasure').hide();
		}
		//Ext.getCmp('reportgroupid').doComponentLayout();
	},
	onRenderReportConfig:function(obj)
	{
		//var gldura=Ext.get('glduration').getValue();
		var val="None";
		if(obj != undefined)
			val=obj.getValue();

			console.log("===gldura=====>>>...>>>"+val);

			if(val=="None" || val=="none")
			{
				Ext.getCmp("er_durationContainer").hide();
			}
			else
			{
				Ext.getCmp("er_durationContainer").show();
			}
	},
	onDurationChange:function(obj)
	{
		var val=obj.getValue();
		Ext.getCmp('er_durationContainer').hide();
		if(val=="None" || val=="none")
		{
			Ext.getCmp("er_durationContainer").hide();
		}else
		{
			Ext.getCmp("er_durationContainer").show();
		}

	},
	isValidWindowForm:function(compValue,compRawValue){

		//var er_compType = Ext.getCmp('er_compType');
		var er_test = Ext.getCmp('er_test');
		var er_function = Ext.getCmp('er_function');
		var er_measure = Ext.getCmp('er_measure');
		var disp_MeasureName=Ext.getCmp("disp_MeasureName").getValue().trim();
		var glduration=Ext.getCmp("glduration").getValue();
		var er_duration=Ext.getCmp("er_duration").getValue();
		var er_testTypeVal=Ext.getCmp("er_testType").getValue();
		var gridObj = Ext.getCmp('configdataid');
		var gridStore = gridObj.getStore();
		var noOfrecords = gridStore.getCount();
		var er_functionVal = er_function.getValue().trim();
			if(er_functionVal.toUpperCase()=='AVERAGE')
				er_functionVal='Avg';
			else if(er_functionVal.toUpperCase()=='MAXIMUM'){
				er_functionVal='Max';
			}else if(er_functionVal.toUpperCase()=='MINIMUM'){
				er_functionVal='Min';
			}
		//alert(er_function.getValue().trim());
		if(glduration=="None" || glduration=="none")
		{
			er_duration="";
		}
		else if(glduration!="cnt" && glduration!="like")
		{
			if(er_duration=="")
			{
				this.getMessageBox('eG Custom Reports','Please enter filter data range value');
				return false;
			}
			if (isNaN(parseInt(er_duration)) || !isFinite(er_duration))
			{
				this.getMessageBox('eG Custom Reports','You can add only numeric vaues for certain duration');
				return false;
			}
			else
			{
				if(glduration!="le" && glduration!="lt" && parseInt(er_duration)<0)
				{
					this.getMessageBox('eG Custom Reports',"Range value can't be less than zero");
					return false;
				}
			}
		}
		if(disp_MeasureName=="")
		{
			this.getMessageBox('eG Custom Reports','Please enter display name to add selection');
			return false;
		}
		if(compValue=='-1')
		{
			this.getMessageBox('eG Custom Reports','Please choose component types');
		}
		else if(er_test.getValue()=='-1')
		{
			return this.getMessageBox('eG Custom Reports',er_test.getStore().getAt(0).get('displayField'));
		}
		else if(er_measure.getValue()=='-1')
		{
			return this.getMessageBox('eG Custom Reports',er_measure.getStore().getAt(0).get('displayField'));
		}
		else
		{
			var duplicateRecordFound=false;
			var duplicateServer=false;
			gridStore.each(function(record) {
			  if ((disp_MeasureName+' ('+er_functionVal+')')==record.get('displayName').trim() && (compRawValue==record.get('componentType')))
			   {
				   duplicateRecordFound=true;
			   }
			   if(app.isCustomLayout=='yes'&& (curChartType=="topn"||curChartType=="digital") &&(compRawValue==record.get('componentType')))
			   {
				   duplicateServer=true;
			   }
			});

			// For Piechart Grid Validations.... Begin...
			if(curChartType=="pie" || curChartType=="distribution" || curChartType=="distributedPie")
			{
				var measDispValue=er_measure.getRawValue();
				if(measDispValue.indexOf("(")>-1 && measDispValue.indexOf(")")>-1)
					measDispValue=measDispValue.substring(measDispValue.lastIndexOf("(")+1,measDispValue.lastIndexOf(")"));
				var diffMesRange=false;
				gridStore.each(function(record) {
					var mesVal=record.get("measure");
					if(mesVal.indexOf("(")>-1 && mesVal.indexOf(")")>-1)
					mesVal=mesVal.substring(mesVal.lastIndexOf("(")+1,mesVal.lastIndexOf(")"));
					if (measDispValue!=mesVal)
					{
						diffMesRange=true;
					}
				});
				if(diffMesRange)
				{
					this.getMessageBox('eG Custom Reports',"You can't add  different measure units");
					return false;
				}
				var functionFound=false;
				gridStore.each(function(record) {
					if (er_function.getRawValue()!=record.get('function'))
					{
					  functionFound=true;
					}
				});
				if(functionFound)
				{
					this.getMessageBox('eG Custom Reports',"You can't add Different value settings");
					return false;
				}
			}
			var diffTest=false;
			gridStore.each(function(record) {
				if(record.get('er_testType')!=er_testTypeVal)
					diffTest=true;
			});
			/*if(diffTest)
			{
				this.getMessageBox('Alert',"You can't add normal and details test in a single widget");
					return false;
			}*/
			// .....End.............
			if(duplicateServer)
			{
				this.getMessageBox('eG Custom Reports','Component type should be unique');
				return false;
			}
			if(duplicateRecordFound)
			{
				this.getMessageBox('eG Custom Reports','Display names should be unique');
				return false;
			}
			else
				return true;
		}
	},
	beforeAddToGrid:function(obj)
	{
		var ComponentsTypeVal=new Array();
		var ComponentsTypeRawVal=new Array();
		var ComponentsTypeTxtValue=Ext.getCmp('ComponentsTypeTxtField').fieldValues
		var ComponentsTypeRawValue=Ext.getCmp('ComponentsTypeTxtField').getValue();
		ComponentsTypeVal=ComponentsTypeTxtValue.split(",");
		ComponentsTypeRawVal=ComponentsTypeRawValue.split(",");
		if(app.isCustomLayout=='yes' && curChartType=='multiDigi')
		{
			// here validate for 5 measures
			var gridObj = Ext.getCmp('configdataid');
			var gridStore = gridObj.getStore();
			var noOfrecords = gridStore.getCount();
			if(noOfrecords>=5)
			{
				var measureArray = new Array();
				gridStore.each(function(record) {

				   if(measureArray.indexOf(record.get('displayName'))==-1)
				   {
					   measureArray.push(record.get('displayName'));
				   }
				});
				if(measureArray.length>=5)
				{
					this.getMessageBox('eG Custom Reports','Cannot add More than five measures');
					return false;
				}
			}
		}
		if(app.isCustomLayout=='yes' && curChartType=='digital')
		{
			var gridObj = Ext.getCmp('configdataid');
			var gridStore = gridObj.getStore();
			var noOfrecords = gridStore.getCount();
			if(noOfrecords>0)
			{
				this.getMessageBox('eG Custom Reports','Cannot add More measures');
				return false;
			}
		}
		if(ComponentsTypeRawValue.indexOf('All Component Types')!=-1)
		{
			//this.addToGrid(obj,'All','All Component Types')
			this.addToGrid(obj,'All','All')
		}
		else
		{
			if(ComponentsTypeVal.length!=1)
			{
				for(var i=0; i<ComponentsTypeVal.length; i++)
				{
					this.addToGrid(obj,ComponentsTypeVal[i],ComponentsTypeRawVal[i]);
				}
			}
			else
			{
				this.addToGrid(obj,ComponentsTypeVal[0],ComponentsTypeRawVal[0]);
			}
		}
	},
	addToGrid:function(obj,compValue,compRawValue)
	{
		if (this.isValidWindowForm(compValue,compRawValue))
		{
			var gridObj = Ext.getCmp('configdataid');
			var gridStore = gridObj.getStore();
			var noOfrecords = gridStore.getCount();
			//var er_compType=Ext.getCmp('er_compType');
			var er_test=Ext.getCmp('er_test');
			var er_testType=Ext.getCmp('er_testType');
			var ddGroupInfoTxtField=Ext.getCmp('ddGroupInfoTxtField');
			var er_measure=Ext.getCmp('er_measure');
			var disp_MeasureName=Ext.getCmp('disp_MeasureName');//..
			var descriptorTxtField=Ext.getCmp('descriptorTxtField');
			var er_testDispName=er_test.getRawValue();
			var er_function=Ext.getCmp('er_function');
			var er_option=Ext.getCmp('er_option');
			var er_component=Ext.getCmp('er_component');
			var glduration=Ext.getCmp('glduration').getValue();
			var er_duration=Ext.getCmp('er_duration');
			var er_durationValue=er_duration.getValue();
			var configString;
			var er_functionVal = er_function.getValue().trim();
			if(Ext.getCmp("er_dynamic").checked)
			{
				glduration='dynamic'+glduration;
			}
			if(er_functionVal.toUpperCase()=='AVERAGE')
				er_functionVal='Avg';
			else if(er_functionVal.toUpperCase()=='MAXIMUM'){
				er_functionVal='Max';
			}else if(er_functionVal.toUpperCase()=='MINIMUM'){
				er_functionVal='Min';
			}
			//er_functionVal.toUpperCase()
			var disp_MeasureNameVal=(disp_MeasureName.getValue()).trim()+' ('+er_functionVal+')';
			if(glduration.length>0 && glduration=="cnt")
			{
				glduration=replaceAll(glduration,",","~~")
			}
			if (er_function=='Raw' || er_function=='None')
			{
				//configString=er_compType.getValue()+'='+er_test.getValue()+'|'+er_measure.getValue()+'|';
				configString=compValue+'='+er_test.getValue()+'|'+er_measure.getValue()+'|';
			}
			else
			{
				//configString='comptypeid'+er_compType.getValue()+'='+er_test.getValue()+'|'+er_measure.getValue()+'$~$'+disp_MeasureNameVal+'$~$'+glduration+'$~$'+er_duration.getValue()+'|';
				configString='comptypeid'+compValue+'='+er_test.getValue()+'|'+er_measure.getValue()+'$~$'+disp_MeasureNameVal+'$~$'+glduration+'$~$'+er_durationValue+'|';
			}
			 //console.log(Ext.getCmp('er_descFilter').getValue())
			if (Ext.getCmp('er_descFilter').getValue()=='all')
			{
				configString+='-1';
			}
			else
			{
				var descArray=new Array();
				var desTxtValue=descriptorTxtField.getValue();
				descArray=desTxtValue.split(",")
				if (descArray.length>0)
				{
					for (var key in descArray )
					{
						var value=descArray[key];
						if (!Ext.isEmpty(value))
						{
							if (key==0)
								configString+=value;
							else
								configString+='$'+value;
						}
						else
							configString+='-1';
					}
				}
				else
					configString+='-1';
				var includeDesc=Ext.getCmp('actionOnDes').getValue();
				if (includeDesc=='exclude')
					configString+='$exclude';
			}
			configString+='|'+er_function.getValue();
			var duplicateRecordFound=false;
			gridStore.each(function(record) {
			   if (configString==record.get('configString'))
			   {
				   duplicateRecordFound=true;
			   }
			});

			if (duplicateRecordFound)
			{
				this.getMessageBox('eG Custom Reports','Configuration already exist');
			}
			else
			{
				var ddconfigString='';
				//var ddChkBoxId=new Array();
				var ddChkBoxValueAry='';
				if (er_test.getValue().indexOf("_DDD")>-1 && (ddGroupInfoTxtField.fieldValues!=''))
				{
					// comptypeidActiveDirectory_server=ADAcMgmtEvtTest_DDD|EvtType$~$EvtType123(Raw)$~$None$~$0|-1|Raw
					// comptypeidActiveDirectory_server=ADAcMgmtEvtTest_DDD|EvtType$~$EvtTypesd(Raw)$~$ge$~$11|123.ljj|Raw
					var ddconfigStringPrefix=configString.substring(configString.indexOf('|')+1);
					var ddConfigAry=ddconfigStringPrefix.split("$~$");
					var ddTxtValue=ddGroupInfoTxtField.fieldValues;
					var ddGroupInfoArray=ddTxtValue.split(",")
					for(var i=0;i<ddGroupInfoArray.length;i++)
					{
						//ddconfigString+='comptypeid'+er_compType.getValue()+'=';
						ddconfigString+='comptypeid'+compValue+'=';
						ddconfigString+=er_test.getValue()+'|';
						ddconfigString+=ddGroupInfoArray[i]+'$~$'
						ddconfigString+=disp_MeasureNameVal+ddGroupInfoArray[i]+'$~$'
						var tempStr=ddConfigAry[3].substring(0,ddConfigAry[3].lastIndexOf('|'));
						ddconfigString+=ddConfigAry[2]+'$~$'+tempStr+'|Raw';

						ddChkBoxValueAry+=ddGroupInfoArray[i]+'$~$'
						ddChkBoxValueAry+=disp_MeasureNameVal+ddGroupInfoArray[i];

						if(i<ddGroupInfoArray.length-1)
						{
							ddconfigString+='*'
							ddChkBoxValueAry+=','
						}
					}
					console.log(ddconfigString);

				}

				var desTxtValue=descriptorTxtField.getValue();
				var descArray=desTxtValue.split(",")
				if(Ext.getCmp('er_descFilter').getValue()=='all')
					descArray="-";
				var configObject={
					'componentType' :compRawValue,
					//'componentType' :er_compType.getRawValue(),
					//'component':er_component,
					'test' : er_testDispName,
					'testValue' : er_test.getValue(),
					'measure' : er_measure.getRawValue(),
					'measureValue' : er_measure.getValue(),
					'displayName' : disp_MeasureNameVal,
					'displayNameDummy':(disp_MeasureName.getValue()).trim(),
					//'descriptor' : er_info.getValue(),
					'descriptor' : descArray,//..
					//'displayName' : er_testDispName,
					'er_testType' : er_testType.getValue(),
					'function':er_function.getRawValue(),
					'glduration':glduration,
					'er_duration':er_duration.getRawValue(),
					'configString':configString,
					'ddconfigString':ddconfigString
				}
				gridStore.add([configObject]);
				configObject=null;
				delete configObject;
				var chartOption;
				//console.log(app.currentWidget)
				if (app.isCustomLayout=='yes')
				{
					chartOption=app.currentWidget.chartType;
				}
				else
				{
					chartOption=curChartType;
				}

				if (er_test.getValue().indexOf("_DDD")>-1 && (ddGroupInfoTxtField.fieldValues!=''||(chartOption=='table'&& (er_function.getValue()=='Raw' || er_function.getValue()=='None'))))
				{
					//console.log("==boxlabel=====>>"+er_measure.getRawValue());
					//console.log("===id====>>>>>"+er_measure.getRawValue()+'-group');
					//console.log("====input value====>>>>>>"+er_measure.getValue()+"$~$"+disp_MeasureNameVal);
					//Ext.getCmp('ddGroupByBoxId').show();
				/* 	for(var i=0;i<ddChkBoxId.length;i++)
					{
						Ext.getCmp('ddGroupByBoxId').add({ boxLabel: disp_MeasureNameVal,id:ddChkBoxId[i]+'-group',name: 'ddgroupbybox', inputValue: er_measure.getValue()+"$~$"+disp_MeasureNameVal, checked: true, readOnly:true });
					} */
					//alert(ddChkBoxValueAry)
					if(ddChkBoxValueAry=='')
						ddChkBoxValueAry=er_measure.getValue()+"$~$"+disp_MeasureNameVal;
					if(Ext.getCmp('disp_MeasureNameVal')==undefined || Ext.getCmp('disp_MeasureNameVal').isEmpty())
					{
						Ext.getCmp('ddGroupByBoxId').add({ boxLabel: disp_MeasureNameVal,id:disp_MeasureNameVal+'-group',name: 'ddgroupbybox', inputValue:ddChkBoxValueAry, checked: true, readOnly:true });//..
						//Ext.getCmp('ddGroupFieldSet').hide();
					}

				}

				var er_basedOnMeasure=Ext.getCmp('er_basedOnMeasure');
				var sortComboBx=Ext.getCmp("er_sortByCombo");
				/*er_basedOnMeasure.getStore().add({
					displayField:er_measure.getRawValue(),
					valueField:er_test.getValue()+"/"+er_measure.getValue()
				});	*/

				var basedMeas=er_test.getValue()+'/'+er_measure.getValue()+'$~$'+disp_MeasureNameVal+'$~$'+glduration+'$~$'+er_durationValue;

				if(tempGridMesaureAry.indexOf(disp_MeasureNameVal)==-1)
				{
					er_basedOnMeasure.getStore().add({
						displayField:disp_MeasureNameVal,
						valueField:basedMeas
					});
					sortComboBx.getStore().add({
							displayField:disp_MeasureNameVal,
							valueField:disp_MeasureNameVal,
					});
					tempGridMesaureAry.push(disp_MeasureNameVal);
				}
			}
		}
	},
	getGroupByArray:function()
	{
		var groupByArray=new Array();
		var addGrpByArry=true;

		// doesnot add groupby for For Timeline and bar
		//if(curChartType=="timeline" || curChartType=="bar" || curChartType=="area" || curChartType=="vertbar"|| curChartType=="topn")
		//{
		// if condition changed for new design...
	/* 	if(curChartType=="timeline" || curChartType=="area" )
		{
			if(Ext.getCmp("showMultipleCharts").checked)
				addGrpByArry=false;
		} */
		// End---------------
		if(addGrpByArry)
		{
			var compChkBtn = Ext.getCmp('primgroupbyComp');
			var dateChkBtn = Ext.getCmp('groupByDateCB');
			var desChkBtn = Ext.getCmp('primgroupbyDesc');

			if(compChkBtn.checked)
			{
				groupByArray.push("component");

			}
			if(!(desChkBtn.collapsed))
			{
				groupByArray.push("descriptors");
			}
			if(!(dateChkBtn.collapsed))
			{
				var grpInfo=Ext.getCmp('primGroupByDateId').getValue().primgroupbybox;
				groupByArray.push(grpInfo)

			}
		}
		//console.log('groupByArray',groupByArray)
		return groupByArray;
	},
	getDDGroupByArray:function()
	{
		var ddGroupByArray=new Array();
		var chartOption;
		if (app.isCustomLayout=='yes')
		{
			chartOption=app.currentWidget.chartType;
		}
		else
		{
			chartOption=curChartType;
		}
		/* if(chartOption=='table' || chartOption=='graph')
		{ */
			var groupByObject=Ext.getCmp('ddGroupByBoxId').getValue();

			if (groupByObject.hasOwnProperty('ddgroupbybox'))
			{
				var groupByRecord=groupByObject.ddgroupbybox;
				console.log('groupByRecord',groupByRecord);
				if (groupByRecord instanceof Array)
				{
					for(var i=0;i<groupByRecord.length;i++){
						var groupByRecordObj=groupByRecord[i];
						if(groupByRecordObj.indexOf(',')!=-1){
							var groupByRecordObjAry=groupByRecordObj.split(',');
							console.log(groupByRecordObjAry)
							for(var j=0;j<groupByRecordObjAry.length;j++)
								ddGroupByArray.push(groupByRecordObjAry[j]);
						}
						else
							ddGroupByArray.push(groupByRecordObj);
					}
				}
				else
				{
					if(groupByRecord.indexOf(',')!=-1)
					{
						var groupByRecordObjAry=groupByRecord.split(',');
						for(var j=0;j<groupByRecordObjAry.length;j++)
							ddGroupByArray.push(groupByRecordObjAry[j]);
					}
					else
					{
						ddGroupByArray.push(groupByRecord);
					}

					//ddGroupByArray.push(groupByRecord);
				}
			}
		//}
		console.log('ddGroupByArray',ddGroupByArray)
		return ddGroupByArray;
	},
	addWidgetDone:function()
	{
		this.getReportdataconfigwindow().doClose();
	},
	addToWidget:function()
	{
		if (app.isCustomLayout=='yes' && !Ext.isEmpty(app.currentWidget))
		{
			var gridStore = Ext.getCmp('configdataid').getStore();
			var descDisplayName = (Ext.getCmp('descriptorTxtFieldId').getValue()).trim();
			var ids=""
			if(!Ext.isEmpty(app.currentWidget.widgetConfig))
			{
				if(!Ext.isEmpty(app.currentWidget.widgetConfig.wigId))
				{
					ids=app.currentWidget.widgetConfig.wigId
				}
				else
				{
					ids='widgetInfo'+currWidget;
					currWidget++;
				}
			}
			else
			{
				ids='widgetInfo'+currWidget;
				currWidget++;
			}
			/* if (app.currentWidget.chartType=="bar" || app.currentWidget.chartType=="vertbar"|| app.currentWidget.chartType=="topn")
			{
				var noOfrecords = gridStore.getCount();
				if(noOfrecords==1)
					Ext.getCmp('showMultipleCharts').setValue(false);
				else
					Ext.getCmp('showMultipleCharts').setValue(true);
			} */
			//console.log(app.currentWidget.widgetConfig)
			//console.log('updateTemplate   ',app.currentWidget)

			// if(app.updateTemplate)
			if((Ext.getCmp('WidgetNametextField').getValue().trim()).length==0)
			{
				this.getCallbackMessageBox('eG Custom Reports','Please enter widget name','showConfigTab');
				return;
			}
			app.currentWidget.setTitle(Ext.getCmp('WidgetNametextField').getValue());
			app.currentWidget.widgetConfig=new Object();
			app.currentWidget.widgetConfig.chartType=app.currentWidget.chartType;
			app.currentWidget.widgetConfig.chartConfigArray=null;
			app.currentWidget.widgetConfig.ddChkBoxData=new Array();
			app.currentWidget.widgetConfig.wigId=ids;
			if (gridStore.getCount()>0)
			{
				app.currentWidget.widgetConfig.chartConfigArray=new Array();
				gridStore.each(function(record) {
					//console.log(1234)
					//console.log(record.data.ddconfigString)
					if(record.data.ddconfigString!=undefined && record.data.ddconfigString!='')
					{
						var ddConfigObj = new Object();
						ddConfigObj["id"]=record.data.displayName;
						ddConfigObj["value"]=Ext.getCmp(record.data.displayName+'-group').inputValue;
						//console.log(Ext.getCmp(record.data.displayName+'-group').inputValue);
						app.currentWidget.widgetConfig.ddChkBoxData.push(ddConfigObj);
					}
				   app.currentWidget.widgetConfig.chartConfigArray.push(record.data);
				});
				console.log(app.currentWidget.widgetConfig.ddChkBoxData);
				app.currentWidget.widgetConfig.groupBy=this.getGroupByArray();
				if(descDisplayName.length==0)
				{
					this.getCallbackMessageBox('eG Custom Reports','Please enter descriptior field','showConfigTab');
					return;
				}
				app.currentWidget.widgetConfig.descDisplayName=descDisplayName;
				//..
		
				var dispInfo=Ext.getCmp('requeredDispId').getValue().reqDispCkbox;
				//alert("===dispInfo==>>>>>>>>klkj>>>>>>>>>"+dispInfo.length);
			//	var dispArry=new Array();
				//dispArry.push(dispInfo);
			//	alert("===dispInfo.length ==>>>>fsdf>>>>>>>>>>>>"+dispInfo.length );
				if(dispInfo!=null && dispInfo.length > 0)
				{
					app.currentWidget.widgetConfig.enableDispName='yes';
					if(dispInfo.length < 4)
					{
						for(var i=0;i<dispInfo.length;i++ )
						{
							var selDisp=dispInfo[i];
							if(selDisp=='enableMetrics')
								app.currentWidget.widgetConfig.enableMetrics='yes';
							if(selDisp=='enableComp')
								app.currentWidget.widgetConfig.enableComp='yes';
							if(selDisp=='enableDesc')
								app.currentWidget.widgetConfig.enableDesc='yes';
							
						}
					}
					else
					{
						if(dispInfo=='enableMetrics')
							app.currentWidget.widgetConfig.enableMetrics='yes';
						if(dispInfo=='enableComp')
							app.currentWidget.widgetConfig.enableComp='yes';
						if(dispInfo=='enableDesc')
							app.currentWidget.widgetConfig.enableDesc='yes';
					}
					if(app.currentWidget.widgetConfig.enableMetrics==undefined)
						app.currentWidget.widgetConfig.enableMetrics='no';
					if(app.currentWidget.widgetConfig.enableComp==undefined)
						app.currentWidget.widgetConfig.enableComp='no';
					if(app.currentWidget.widgetConfig.enableDesc==undefined)
						app.currentWidget.widgetConfig.enableDesc='no';
				}
				//alert("==FS=========="+app.currentWidget.widgetConfig.enableMetrics);
				//alert("==FS=====DF====="+app.currentWidget.widgetConfig.enableComp);
				//..
				if(!Ext.isEmpty(Ext.getCmp("showMultipleCharts")) && Ext.getCmp("showMultipleCharts").checked)
					app.currentWidget.widgetConfig.showMultipleCharts="true";
				else
					app.currentWidget.widgetConfig.showMultipleCharts="false";

				//alert(app.currentWidget.chartType)
				if(!Ext.getCmp("showMultipleCharts").checked){
					if(app.currentWidget.chartType=="timeline" || app.currentWidget.chartType=="heatMap" || app.currentWidget.chartType=="bar" || app.currentWidget.chartType=="area" || app.currentWidget.chartType=="vertbar"|| app.currentWidget.chartType=="topn")
					{
						if((app.currentWidget.widgetConfig.groupBy).length==0)
						{
							this.getCallbackMessageBox('Alert','Please add configuration before updating to widget','showConfigTab');
							return;
						}
					}
				}

				if(!Ext.isEmpty(Ext.getCmp("er_stackedArea")) && Ext.getCmp("er_stackedArea").checked)
					app.currentWidget.widgetConfig.er_stackedArea="true";
				else
					app.currentWidget.widgetConfig.er_stackedArea="false";
				app.currentWidget.widgetConfig.ddGroupBy=this.getDDGroupByArray();
				var enableTopN= Ext.getCmp('er_enableTopN').getValue().enableTopN;
				app.currentWidget.widgetConfig.enableTopN=enableTopN;
				if (enableTopN=='yes')
				{
					app.currentWidget.widgetConfig.basedOnTestMeasure=Ext.getCmp('er_basedOnMeasure').getValue();
					app.currentWidget.widgetConfig.top=Ext.getCmp('er_top').getValue();
				}

				if(app.currentWidget.chartType=="table")
				{
					app.currentWidget.widgetConfig.sortByValue=Ext.getCmp("er_sortByCombo").getValue();
				}
				//alert(app.currentWidget.chartType)
				if(app.currentWidget.chartType=="vertbar")
				{
					app.currentWidget.widgetConfig.barAlignment = "Vertical";
				}
				else if(app.currentWidget.chartType=="bar")
				{
					app.currentWidget.widgetConfig.barAlignment = "Horizontal";
				}
			}
			else
			{
				this.getCallbackMessageBox('Alert','Please add configuration before updating to widget','showConfigTab');
			}

			if (app.currentWidget.widgetConfig.chartConfigArray!=null)
			{
				app.currentWidget.removeAll();
				app.currentWidget.add(this.getConfiguredMe(app.currentWidget.chartType));
/* 				if (app.currentWidget.hasCls('configuredWidget')){
					//alert("configured")
					app.currentWidget.addCls('configuredWidget');
				} */
				app.currentWidget.addCls('configuredWidget configuredWidgetDummy');
				//app.currentWidget.getHeader().show();
				Ext.get(app.currentWidget.getHeader().id).setStyle({'visibility':'visible'});
				var toolId=app.currentWidget.getHeader().tools[0].id;
				Ext.getCmp(toolId).hide();

				this.getReportdataconfigwindow().doClose();
			}
		}

	},
	getConfiguredMe : function(chartTypeIcon)
	{
		//alert("=2222");
		var chartIcon=this.getGrayChartIconOrDefaultTitle(chartTypeIcon,'color');
		return [{
				xtype:'container',
				closeAction:'destroy',
				layout:{type:'hbox',align:'stretch',pack : 'center'},
				flex:1,
				listeners: {
					'afterRender': function(obj)
					{
						 this.getEl().on('click', function(event, target, options)
						 {
							 app.appObj.getController(app.appController).onClickWidgetModify(obj.up('panel'));
						 });
					}
				},
				items:[{
					xtype:'button',
					//text:type,
					height:100,
					ui:'plain',
					style:{'cursor':'default'},
					html:'<table width="100%" height="80px" style="margin:0% auto;"><tr><td align="center" valign="middle"><div class="'+chartIcon+'" style="position:relative"><div class="widgetIcon24_Tick"></div></div><div style="margin:10px auto" class="datapanelWidgetIconTextConfigured">Widget configuration done!</div></td></tr></table>',

				}]
			}]

		/* return	[{
			xchartTypeIcon:'container',
			closeAction:'destroy',
			layout:{type:'hbox',align:'stretch',pack : 'center'},
			flex:1,
			items:[{
				xchartTypeIcon:'button',
				//text:type,
				width:50,
				height:80,
				style:{'border':'1px solid red'},
				ui:'plain',
				html:'<table width="100%" height="10px" style="margin:0% auto;border:1px solid green"><tr><td align="center" valign="middle"><div class="'+chartIcon+'"></div><div styel="font-size:12px; margin:10px auto">Done! Widget Configuration</div></td></tr></table>',
				}]
		}]; */
	},
	getIniParams:function()
	{
		app.method='setini';
		var iniParams=app.infoParams;
		if(app.isCustomLayout=='no')
		{
			if(app.updateTemplate)
			{
				var preFix=app.infoParams.substring(0,(app.infoParams).indexOf('&templateDescription='))
				iniParams=preFix+'&templateDescription='+Ext.getCmp('descriptionId').getValue();

				var sharing='';
				var userList;
				var user_List=[];
				if(Ext.getCmp('privateId_edit').pressed)
					sharing="Private";
				else if(Ext.getCmp('PublicId_edit').pressed)
					sharing="Public";
				else if(Ext.getCmp('shareId_edit').pressed)
				{
					sharing="Share";

					userList=Ext.getCmp('user_list_edit');
					var selectedUser=userList.getSelectionModel().getSelection();
				}
				if(sharing=="Share")
				{
					if(selectedUser=="" || selectedUser.length==0)
					{
						this.getMessageBox('eG Custom Reports','Please Select User list');
						return;
					}
					else
					{
						for (var i=0;i<selectedUser.length;i++)
						{
							var row = userList.getSelectionModel().getSelection()[i];
							user_List.push(row.data.valueField)
						}
					}
				}
				iniParams=iniParams+'&sharing='+sharing+'&userList='+user_List;
			}
		}
		if (app.isCustomLayout=='yes')
		{
			//getGridsterObj
			if (!Ext.isEmpty(this.getWidgetLayoutPane()))
			{
				//alert(1)
				var items=this.getWidgetLayoutPane().items.items;
				var gridster_items=Gridster.sort_by_row_and_col_asc(this.getWidgetLayoutPane().gridsterSerialize());
				//console.log(gridster_items)

				var widgetList=new Array();
				if (gridster_items.length>0)
				{
					//alert(2)
					/* for (var item in items)
					{ */
					for (var item in gridster_items)
					{
						//alert(3)
						var ddRawConfigString=new Array();
						var object=items[item];
						var gridster_obj=gridster_items[item];
						//console.log(gridster_obj);
						//console.log(gridster_obj.id+"_panel")
						var eachPanel=Ext.getCmp(gridster_obj.id+"_panel");
						//console.log(eachPanel)
						//console.log(eachPanel.widgetConfig)
						if(!Ext.isEmpty(eachPanel) && !Ext.isEmpty(eachPanel.widgetConfig))
						{
							var chartConfigArray=eachPanel.widgetConfig.chartConfigArray;
							//console.log('chartConfigArray	',chartConfigArray);
							if (!Ext.isEmpty(chartConfigArray))
							{
								var ddGrpByMes=new Object();
								for (var key in chartConfigArray)
								{
									var record=chartConfigArray[key];


									var ddconfigStrByMes=new Array();
									//console.log(record);
									var gridTestName=record.testValue;
									var ddconfigString=record.ddconfigString;
									if(gridTestName.indexOf("_DDD")>-1 && (ddconfigString!=''))
									{
										if(ddconfigString.indexOf('*')!=-1)
										{
											var ddconfigStringAry=ddconfigString.split('*');
											for(var ii=0;ii<ddconfigStringAry.length;ii++)
											{
												ddconfigStrByMes.push(ddconfigStringAry[ii].replace('comptypeid',''));
												//iniParams+='&widgetInfo'+item+'~'+ddconfigStringAry[ii];
												iniParams+='&widgetInfo'+item+'$'+ddconfigStringAry[ii];
												//iniParams+='&'+ddconfigStringAry[ii];
											}
										}
										else
										{
											ddconfigStrByMes.push(record.ddconfigString.replace('comptypeid',''));
											//iniParams+='&widgetInfo'+item+'~'+record.ddconfigString;
											iniParams+='&widgetInfo'+item+'$'+record.ddconfigString;
											//iniParams+='&'+record.ddconfigString;
										}
										ddGrpByMes[record.displayName]=ddconfigStrByMes;
									}


									if (record['function']!='Raw' || record['function']!='None')
									{
										//iniParams+='&widgetInfo'+item+'~'+record.configString;
										iniParams+='&widgetInfo'+item+'$'+record.configString;
									}
									else
										ddRawConfigString.push(record.configString);
								}

								var widgetInfo=new Object();
								//console.log(Ext.get(eachPanel.header.id+'_hd-textEl'))
								widgetInfo.headerDescription=Ext.get(eachPanel.header.id+'_hd-textEl').dom.innerHTML;

								if(eachPanel.widgetConfig.descDisplayName!=undefined && eachPanel.widgetConfig.descDisplayName!='undefined')
									widgetInfo.descDisplayName=eachPanel.widgetConfig.descDisplayName;
								//..
								
								if(eachPanel.widgetConfig.enableMetrics!=undefined && eachPanel.widgetConfig.enableMetrics!='undefined')
								{
									widgetInfo.enableMetrics=eachPanel.widgetConfig.enableMetrics;
								}
								if(eachPanel.widgetConfig.enableComp!=undefined && eachPanel.widgetConfig.enableComp!='undefined')
								{
									widgetInfo.enableComp=eachPanel.widgetConfig.enableComp;
								}
								if(eachPanel.widgetConfig.enableDesc!=undefined && eachPanel.widgetConfig.enableDesc!='undefined')
								{
									widgetInfo.enableDesc=eachPanel.widgetConfig.enableDesc;
								}
								if(eachPanel.widgetConfig.enableDispName!=undefined && eachPanel.widgetConfig.enableDispName!='undefined')
								{
									widgetInfo.enableDispName=eachPanel.widgetConfig.enableDispName;
								}
								//alert("===widgetInfo.enableDispName===>>>>>>>>ddfd>>>>>>>"+widgetInfo.enableDispName);
								//..

								if(eachPanel.selectedGraphPalette==null||eachPanel.selectedGraphPalette=='null')
									widgetInfo.selectedPaletteColor='';
								else
									widgetInfo.selectedPaletteColor=eachPanel.selectedGraphPalette;
								if(!Ext.isEmpty(eachPanel.getDockedItems()[1]))
								{
									textareafield=eachPanel.getDockedItems()[1].down('textareafield');
									if (!Ext.isEmpty(textareafield))
									{
										widgetInfo.footerDescription=textareafield.getValue();
									}
								}
								if(eachPanel.widgetConfig.chartType=="bar")
								{
									widgetInfo.barAlignment="Horizontal";
								}
								else if(eachPanel.widgetConfig.chartType=="vertbar")
								{
									widgetInfo.barAlignment="Vertical";
								}
								widgetInfo.chartType=eachPanel.widgetConfig.chartType;
								widgetInfo.x=gridster_obj.row;
								widgetInfo.y=gridster_obj.col;
								widgetInfo.size_x=gridster_obj.size_x;
								widgetInfo.size_y=gridster_obj.size_y;
								//widgetInfo.width=parseInt(widget_baseWidth)*gridster_obj.size_x;
								widgetInfo.width=Ext.util.Format.round((1000/12)*gridster_obj.size_x,0);
								widgetInfo.height=parseInt(widget_baseHeight)*gridster_obj.size_y;
								//widgetInfo.supportableComponentTypes=eachPanel.supportableComponentTypes;
								widgetInfo.groupBy=eachPanel.widgetConfig.groupBy;
								widgetInfo.ddGroupBy=eachPanel.widgetConfig.ddGroupBy;
								widgetInfo.enableTopN=eachPanel.widgetConfig.enableTopN;
								widgetInfo.showMultipleCharts=eachPanel.widgetConfig.showMultipleCharts;
								widgetInfo.er_stackedArea=eachPanel.widgetConfig.er_stackedArea;

								//console.log(widgetInfo)
								//console.log("===eachPanel.widgetConfig===bb>>>"+Ext.encode(eachPanel.widgetConfig));
								//console.log("===eachPanel.widgetConfig===top>>>"+eachPanel.widgetConfig.enableTopN);

								//alert(item)
								if (eachPanel.widgetConfig.enableTopN=='yes')
								{
									//widgetInfo.basedOnTestMeasure=eachPanel.widgetConfig.basedOnTestMeasure;
									//alert("========11=sdf====="+Ext.getCmp('er_basedOnMeasure').getValue() );
									//alert("========11======"+eachPanel.widgetConfig.basedOnTestMeasure );
									widgetInfo.basedOnTestMeasure=Ext.encode(eachPanel.widgetConfig.basedOnTestMeasure);
									widgetInfo.top=eachPanel.widgetConfig.top;
								}
								if(curChartType=="table")
								{
									widgetInfo.sortByValue=Ext.encode(eachPanel.widgetConfig.sortByValue)
								}

								widgetInfo.ddGroupByMeasure=ddGrpByMes;
								var wid='widgetInfo'+item;
								widgetList.push(wid);
								iniParams+='&'+wid+'='+Ext.encode(widgetInfo);
								iniParams+='&'+wid+'_ddRaw='+Ext.encode(ddRawConfigString);
							}
							else
							{
								this.getMessageBox('eG Custom Reports','Please configure all widgets');
								return;
							}
						}
						else
						{
							this.getMessageBox('eG Custom Reports','Please configure all widget(s)');
							return;
						}
					}
					iniParams+='&widgetList='+Ext.encode(widgetList);
				}
				else
				{
					this.getCallbackMessageBox('eG Custom Reports','Please add widgets to the template','showConfigWindow');
					return;
				}
			}
			else
			{
				this.getCallbackMessageBox('eG Custom Reports','Please add widget(s) to configure','showConfigWindow');
				return;
			}
			//console.log("===iniParams==from==method==>>>"+JSON.stringify(iniParams));
		}
		else
		{
			var gridObj = Ext.getCmp('configdataid');
			var gridStore = gridObj.getStore();
			var storecount = gridStore.getCount();
			var descDisplayName = (Ext.getCmp('descriptorTxtFieldId').getValue()).trim();
			var ddGrpByMes=new Object();
			if (storecount>0)
			{
				var ddRawConfigString=new Array();
				for (var i=0;i<storecount;i++)
				{
					var ddconfigStrByMes=new Array();
					//console.log(gridStore.getAt(i));
					var gridTestName=gridStore.getAt(i).get('testValue');
					var ddconfigString=gridStore.getAt(i).get('ddconfigString');
					if(gridTestName.indexOf("_DDD")>-1 && (ddconfigString!=''))
					{
						if(ddconfigString.indexOf('*')!=-1)
						{
							var ddconfigStringAry=ddconfigString.split('*');
							for(var ii=0;ii<ddconfigStringAry.length;ii++)
							{
								//	groupByRecordObj=groupByRecordObj.replace('comptypeid','');
								ddconfigStrByMes.push(ddconfigStringAry[ii].replace('comptypeid',''));
								iniParams+='&'+ddconfigStringAry[ii];
							}
						}
						else
						{
							ddconfigStrByMes.push(gridStore.getAt(i).get('ddconfigString').replace('comptypeid',''));
							iniParams+='&'+gridStore.getAt(i).get('ddconfigString');
						}
						ddGrpByMes[gridStore.getAt(i).get('displayName')]=ddconfigStrByMes;
					}
					if (gridStore.getAt(i).get('function')!='Raw' || gridStore.getAt(i).get('function')!='None' || gridStore.getAt(i).get('er_testType')=="Details")
					{
						iniParams+='&'+gridStore.getAt(i).get('configString');
					}
					else
					{
						ddRawConfigString.push(gridStore.getAt(i).get('configString'));
						iniParams+='&'+gridStore.getAt(i).get('configString');//..
					}
				}
			}
			else
			{
				this.getCallbackMessageBox('eG Custom Reports','Please define configuration','showConfigWindow');
				return;
			}

			var chartInfo=new Object();
			var chartOption=curChartType;
			var enableTopN=Ext.getCmp('er_enableTopN').getValue().enableTopN;
			chartInfo.enableTopN=enableTopN;

			if (Ext.getCmp('er_enableTopN').getValue().enableTopN=='yes')
			{
				chartInfo.basedOnTestMeasure=Ext.getCmp('er_basedOnMeasure').getValue();
				chartInfo.top=Ext.getCmp('er_top').getValue();
			}
			chartInfo.chartType=chartOption;
			//chartInfo.top=Ext.getCmp('er_top').getValue();
			//..
			var dispInfo=Ext.getCmp('requeredDispId').getValue().reqDispCkbox;
			if(dispInfo!=null && dispInfo.length > 0)
			{
				chartInfo.enableDispName='yes';
				if(dispInfo.length < 4)
				{
					for(var i=0;i<dispInfo.length;i++ )
					{
						var selDisp=dispInfo[i];
						if(selDisp=='enableMetrics')
							chartInfo.enableMetrics='yes';
						if(selDisp=='enableComp')
							chartInfo.enableComp='yes';
						if(selDisp=='enableDesc')
							chartInfo.enableDesc='yes';
						
					}
				}
				else
				{
					if(dispInfo=='enableMetrics')
						chartInfo.enableMetrics='yes';
					if(dispInfo=='enableComp')
						chartInfo.enableComp='yes';
					if(dispInfo=='enableDesc')
						chartInfo.enableDesc='yes';
				}
				if(chartInfo.enableMetrics==undefined)
					chartInfo.enableMetrics='no';
				if(chartInfo.enableComp==undefined)
					chartInfo.enableComp='no';
				if(chartInfo.enableDesc==undefined)
					chartInfo.enableDesc='no';
			}
			//..
			chartInfo.groupBy=this.getGroupByArray();
			if(descDisplayName.length==0)
			{
				this.getCallbackMessageBox('eG Custom Reports','Please enter descriptior field','showConfigTab');
				return;
			}
			chartInfo.descDisplayName=descDisplayName;

			if(!Ext.isEmpty(Ext.getCmp("showMultipleCharts")) && Ext.getCmp("showMultipleCharts").checked)
				chartInfo.showMultipleCharts="true";
			else
				chartInfo.showMultipleCharts="false";

			if(!Ext.isEmpty(Ext.getCmp("er_stackedArea")) && Ext.getCmp("er_stackedArea").checked)
				chartInfo.er_stackedArea="true";//..........
			else
				chartInfo.er_stackedArea="false";//..........

			if(curChartType=="table")
			{
				chartInfo.sortByValue=Ext.getCmp("er_sortByCombo").getValue();
			}
			chartInfo.ddGroupBy=this.getDDGroupByArray();
			if(chartOption=="vertbar")
			{
				chartInfo.barAlignment="Vertical";
			}
			else if(chartOption=="bar")
			{
				chartInfo.barAlignment="Horizontal";
			}
			chartInfo.ddGroupByMeasure=ddGrpByMes;

			iniParams+='&chartInfo='+Ext.encode(chartInfo);
			iniParams+='&ddRawConfigString='+Ext.encode(ddRawConfigString);
		}
		//iniParams+='&isDescFilter='+Ext.getCmp('descFilterRadioGroup').getValue().descFilterRadio;
		if(app.isCustomLayout=='no')
		{
			if(Ext.getCmp("primgroupbyDesc").isHidden())
				iniParams+='&isDescFilter=no';
			else
			{
				if(Ext.getCmp('descFilterRadioGroup').checked)
					iniParams+='&isDescFilter=yes';
				else
					iniParams+='&isDescFilter=no';
			}
		}
		else
		{
			iniParams+='&isDescFilter=no';
		}


		iniParams+='&isCustomLayout='+app.isCustomLayout;
		iniParams+='&method='+app.method;
		var multiMeasureSupport='no';
		if(!Ext.isEmpty(Ext.getCmp("multiMeasure")))
		{
			if (Ext.getCmp('multiMeasure').getValue()==true)
			{
				multiMeasureSupport='yes';
			}
		}
		else
		{
			multiMeasureSupport='yes';
		}
		iniParams+='&multiMeasureSupport='+multiMeasureSupport;
		iniParams+='&isEditTemplate='+isEditTemplate;
		//alert("===chartInfo.sortByValue====>>>>>>>"+chartInfo.sortByValue);
		return iniParams;
	},
	onClickTempCreate:function(obj)
	{
		//alert("=====create template========>>>>>>"+obj.getId());
		var url='/final/reporter/ReportTemplateController.jsp';
		var iniParams=this.getIniParams();
		if(iniParams!=undefined && iniParams!='undefined')
		{
			if( app.isCustomLayout=='no')
			{
				var gridObj = Ext.getCmp('configdataid');
				var gridStore = gridObj.getStore();
				var noOfrecords = gridStore.getCount();
				var hasDiffFunctions=false;
				var er_function="";
				gridStore.each(function(record) {
					if (er_function!="" && er_function!=record.get('function'))
					{
						hasDiffFunctions=true;
					}
					er_function=record.get('function');
				});
				var addGrpByArry=true;

				// doesnot add groupby for For Timeline and bar
				if(curChartType=="timeline" || curChartType=="heatMap" || curChartType=="bar" || curChartType=="area" || curChartType=="vertbar"|| curChartType=="topn")
				{
					if(Ext.isEmpty(Ext.getCmp("showMultipleCharts")) || Ext.getCmp("showMultipleCharts").checked)
						addGrpByArry=false;
				}
				// End---------------
				if(addGrpByArry)
				{
					if(this.getGroupByArray().length==0 && curChartType!="table"&& curChartType!="digital" && curChartType!="multiDigi" )
					{
						if(hasDiffFunctions)
						{
							this.getCallbackMessageBox('Alert',"You can't create template without any group functions");
							return;
						}
					}
				}
			}
			//console.log("=======iniParams=========sfds=>>>>>>>> "+(iniParams));
			this.callAjax(url,iniParams);
		}
	},
	registerDeleteRecordEvent:function(grid)
	{
		var removeIconId;
		 var me=this;
		 var msgInfo='Do you want to remove selected templates?';
		 var gridId=grid.getId();
		 if (gridId=='configdataid')
		 {
			removeIconId='#removeALL';
			msgInfo='Do you want to remove selected measures?';
		 }
		 else if (gridId=='reportbuildergridid')
			 removeIconId='#removeAllIni';
		 else
			 return;

		grid.mon(Ext.select(removeIconId), 'click', function() {
			var selectionArray = grid.getSelectionModel().getSelection();
			var totalData=grid.getStore().getCount();
			var selectionArrayLen=selectionArray.length;
			if (selectionArrayLen>0)
			{
				Ext.Msg.show({
					title : 'eG custom report',
					msg : msgInfo,
					cls:'egMsgBox',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal)
					{
						if (buttonVal == "yes")
						{
							if(removeIconId=='#removeALL')
							{
								var er_basedOnMeasureStore=Ext.getCmp('er_basedOnMeasure').getStore();
								var er_sortByComboeStore=Ext.getCmp('er_sortByCombo').getStore();
								var er_basedOnMeasure = Ext.getCmp('er_basedOnMeasure');
								var count=er_basedOnMeasureStore.getCount();
								if(totalData==selectionArrayLen)
								{
									for (var i=0;i<selectionArrayLen;i++)
									{
										var row = grid.getSelectionModel().getSelection()[i];


										for (var j=0;j<count;j++)
										{
											var rec=er_basedOnMeasureStore.getAt(j);
											var sortrec=er_sortByComboeStore.getAt(j);
											if (rec.data.displayField==row.data.displayName)
											{
												er_basedOnMeasureStore.remove(rec);
												er_sortByComboeStore.remove(sortrec);

												if (row.data.displayName==er_basedOnMeasure.getRawValue())
												{
													er_basedOnMeasure.setValue('-1');
													er_sortByCombo.setValue('-1');
												}
												break;
											}
										}

										if(row.data!=undefined && !Ext.isEmpty(Ext.getCmp(row.data.displayName+'-group')))
												Ext.getCmp(row.data.displayName+'-group').destroy();
									}
									grid.getSelectionModel().deselectAll();
									grid.getStore().removeAll();
									selectionArray=[];
								}
								else
								{
									for (var i=0;i<selectionArrayLen;i++)
									{
										var row = selectionArray[i];


										for (var j=0;j<count;j++)
										{
											var rec=er_basedOnMeasureStore.getAt(j);
											var sortrec=er_sortByComboeStore.getAt(j);
											if (rec.data.displayField==row.data.displayName)
											{
												er_basedOnMeasureStore.remove(rec);
												er_sortByComboeStore.remove(sortrec);

												if (row.data.displayName==er_basedOnMeasure.getRawValue())
												{
													er_basedOnMeasure.setValue('-1');
													er_sortByCombo.setValue('-1');
												}
												break;
											}
										}


										grid.getStore().remove(row);
										if(row!=undefined && row.data!=undefined && !Ext.isEmpty(Ext.getCmp(row.data.displayName+'-group')))
												Ext.getCmp(row.data.displayName+'-group').destroy();
									}
								}
							}
							else
							{
								var gridStore=grid.getStore();
								app.method='deleteAndGetIni';
								var paramsObject=new Object();
								var url='/final/reporter/ReportTemplateController.jsp';
								paramsObject.method=app.method;
								paramsObject.builderType=app.builderType;
								if(totalData==selectionArrayLen)
								{
									grid.getSelectionModel().deselectAll();

								}
								for (var i = 0; i < selectionArrayLen; i++)
								{
									console.log(selectionArray[i].data);
									var record = new Object();
									record.templateName=selectionArray[i].data.templateName;
									paramsObject.recordInfo=Ext.encode(record);
									me.callAjax(url,paramsObject);
								}
							}
						}
					}
				});
			}
			else
			{
				me.getMessageBox('eG Custom Reports','Please select a row to delete');
			}
		});
		//..
		//for up move
		grid.mon(Ext.select('#upMovement'), 'click', function() {
			var paramsObject=new Object();
			var url='/final/reporter/ReportTemplateController.jsp';
		//	this.callAjax(url,paramsObject);
			var selectionArray = grid.getSelectionModel().getSelection();
			var selectionArrayLen=selectionArray.length;
			if (selectionArrayLen>0)
			{
				var gridStore=grid.getStore();
				for (i = 0; i < selectionArrayLen; i++) {
					var index = gridStore.indexOf(selectionArray[i]);
					if(index != 0){
						gridStore.remove(selectionArray[i]);
						gridStore.insert(index-1, selectionArray[i]);
					}
				}
			}
			else
			{
				me.getMessageBox('eG Custom Reports','Please select a row to move up');
			}
		});
		//for down move
		grid.mon(Ext.select('#downMovement'), 'click', function() {
			var selectionArray = grid.getSelectionModel().getSelection();
			var selectionArrayLen=selectionArray.length;
			if (selectionArrayLen>0)
			{
				var gridStore=grid.getStore();
				for (i = 0; i < selectionArrayLen; i++) {
					var index = gridStore.indexOf(selectionArray[i]);
					var totRow = gridStore.getCount();
					if(index != totRow-1){
						gridStore.remove(selectionArray[i]);
						gridStore.insert(index+1, selectionArray[i]);
					}
				}
			}
			else
			{
				me.getMessageBox('eG Custom Reports','Please select a row to move down');
			}
		});
	},
	setSelectAllTemplates:function(isChecked)
	{
		var renderCheckBox = Ext.query('div.addCheckBox');
		if(isChecked)
		{
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var chkBoxObj=Ext.getCmp('cc_'+i);
				var isshared = chkBoxObj.SharedData;
				if(isshared == false)
				{
					chkBoxObj.setValue(true);
					chkBoxObj.show();
				}
			}
		}
		else
		{
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var chkBoxObj=Ext.getCmp('cc_'+i);
				chkBoxObj.setValue(false);
				chkBoxObj.hide();
			}
		}

	},
	deletSelectedTemplateByListView:function()
	{
		app.method='deleteAndGetIni';
		var me=this;
		var renderCheckBox = Ext.query('div.addCheckBox');
		if (renderCheckBox.length>0)
		{
			var paramsObject=new Object();
			var isTemplateChecked=false;
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var ccc = Ext.getCmp('cc_'+i);
				if(ccc.checked)
				{
					isTemplateChecked=true;
					var record = new Object();
					record.templateName=ccc.data;
					paramsObject['recordInfo'+i]=Ext.encode(record);
				}
			}
			if(isTemplateChecked)
			{
				Ext.Msg.show({
					title : 'eG custom report',
					msg : 'Do you want to delete selected template(s)?',
					cls:'egMsgBox',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal)
					{
						if (buttonVal == "yes")
						{
							var url='/final/reporter/ReportTemplateController.jsp';
							paramsObject.method=app.method;
							paramsObject.builderType=app.builderType;
							//console.log(paramsObject);
							me.callAjax(url,paramsObject);
						}
					}
				});
			}
			else
			{
				me.getMessageBox('eG Custom Reports','Please select a template(s) to delete');
			}

		}
		else
		{
			me.getMessageBox('eG Custom Reports','No template(s) to delete');
		}

	},
	deleteRecordsFromIni:function(grid,record)
	{
		app.method='deleteAndGetIni';
		var paramsObject=new Object();
		if(record=='All')
		{
			var store = grid.getStore();
			store.each(function(rec,idx){
				paramsObject['recordInfo'+idx]=Ext.encode(rec.data);
			});
			store=null;delete store;
		}
		else
		{
			paramsObject.recordInfo=Ext.encode(record.data);
		}
		var url='/final/reporter/ReportTemplateController.jsp';
		paramsObject.method=app.method;
		paramsObject.builderType=app.builderType;
		this.callAjax(url,paramsObject);
	},
	deleteRecordsFromIniByList:function(templateName)
	{
		var me=this;
		Ext.Msg.show({
			title : 'eG custom report',
			cls:'egMsgBox',
			msg : 'Do you want to remove the template?',
			buttons : Ext.Msg.YESNO,
			icon : Ext.Msg.QUESTION,
			fn : function(buttonVal)
			{
				if (buttonVal == "yes")
				{
					app.method='deleteAndGetIni';
					var paramsObject=new Object();
					var record = new Object();
					record.templateName=templateName;
					if(record=='All')
					{
						/* var store = grid.getStore();
						store.each(function(rec,idx){
							paramsObject['recordInfo'+idx]=Ext.encode(rec.data);
						});
						store=null;delete store; */
					}
					else
					{
						//paramsObject['recordInfo'+0]=Ext.encode(record);
						paramsObject.recordInfo=Ext.encode(record);
					}
					var url='/final/reporter/ReportTemplateController.jsp';
					paramsObject.method=app.method;
					paramsObject.builderType=app.builderType;
					me.callAjax(url,paramsObject);
				}
			}
		}
	);
	},
	generateFromListView:function(templateName){
		var record = new Object();
		record.templateName=templateName;
		window.location.href='/final/reporter/ReportBuilder.jsp?fromReportBuilder=false&method=init&recordInfo='+encodeURIComponent(JSON.stringify(record));
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectContainerId,isSetLabel)
	{
		console.log(comboId)
		if(parentJsonProperty.hasOwnProperty('combo'))
		{
			var component = Ext.ComponentManager.get(comboId);
			if(component!=undefined && component!='undefined')
			{
				if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
				{
					var rawData = parentJsonProperty.combo[comboProperty];
					//..
					if(comboId=='er_info'){
						app.infoRawData=rawData; // for info search
					}
					if(comboId=='er_measure')
					{
						app.ddGroupInfoData=rawData; // for DD Group search
						app.relevantCompTypeByTest=parentJsonProperty.combo['relevantCompTypeByTestCombo']; // for Revalent Compoment
					}
					component.getStore().loadRawData(rawData);

					 if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
						component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
					 else
						component.setValue(rawData[0].valueField);

					if(comboId=='er_compType')
					{
						Ext.getCmp('ComponentsTypeTxtField').setValue(component.getRawValue());
						Ext.getCmp('ComponentsTypeTxtField').fieldValues = component.getValue();
					}
					if(comboId=='er_test')
					{
						var component_type = Ext.ComponentManager.get('er_compType');
						Ext.getCmp('ComponentsTypeTxtField').setValue(component_type.getRawValue());
						Ext.getCmp('ComponentsTypeTxtField').fieldValues = component_type.getValue();
					}
					if (isSetLabel)
					{
						 if(parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
						{
							if(!isMultiSelect)
								component.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
							else
								Ext.ComponentManager.get(multiSelectContainerId).setFieldLabel(comboLabelProperty);
						}
					}
					if(!isMultiSelect)
					{
						if(component.isHidden())
						component.show();
					}
					else
					{
						var m=Ext.ComponentManager.get(multiSelectContainerId);
						if(m.isHidden())
						m.show();
					}
				}
				else
				{
					if(!isMultiSelect)
					{
						if(!component.isHidden())
						component.hide();
					}
					else
					{
						var m=Ext.ComponentManager.get(multiSelectContainerId);
						if(!m.isHidden())
						m.hide();
					}
				}
			}
		}
		else
		{
			this.getMessageBox('eG Custom Reports','No record found to load combo ...');
		}
	},
	getMessageBox:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
		return false;
	 },
	getCallbackMessageBox:function(title,msg,flag)
	{
		Ext.Msg.show({
			title:title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			scope:this,
			icon: Ext.MessageBox.WARNING,
			fn: function(val){
				//console.log(val)
				//val=='cancel'
				//if (val=='ok')
				//{
					if (flag=='setini')
					{
						Ext.getCmp('reportbuildertop').show();
						if(app.isCustomLayout=='no')
						{
							this.getReportdataconfigwindow().doClose();
						}
						else
						{
							this.getWidgetLayoutPane().removeAllWidget();
							this.getWidgetLayoutPane().hide();
							//this.getWidgetLayoutPane().destroy();
						}
						this.onRenderReportBuilderGrid();
						this.setLayoutchange('single');	//to load ini entries in report builder grid (Shows all templates details)
					}
					else if (flag=='showConfigWindow'&& val=='ok')
					{
						if (app.isCustomLayout=='yes')
						{
							Ext.getCmp('addMoreWidget').fireEvent('click');
						}
						else
						{
							
						}
					}
					else if (flag=='showConfigTab' && val=='ok')
					{
					
					}
			//	}
			//else
			//{
			//console.log('invalid input in processCallbackResult method');
			//}
			}
		});
	 },
	getGrayChartIconOrDefaultTitle:function(type,returnType)
	{
		var chartIcon='';
		var chartIconColor='';
		var title='';
				
		switch (type)
		{
			case 'bar':
				title='Horizontal Bar';
				chartIcon='widgetIconGray48_HorizontalBarChart';
				chartIconColor='widgetIcon48_HorizontalBarChart';
				break;
			case 'vertbar':
				title='Vertical Bar';
				chartIcon='widgetIconGray48_VerticalBarChart';
				chartIconColor='widgetIcon48_VerticalBarChart';
				break;
			case 'area':
				title='Area Chart';
				chartIcon='widgetIconGray48_AreaChart';
				chartIconColor='widgetIcon48_AreaChart';
				break;
			case 'distribution':
				title='Pie Chart';
				chartIcon='widgetIconGray48_PieChart';
				chartIconColor='widgetIcon48_PieChart';
				break;
			case 'timeline':
				title='Timeline';
				chartIcon='widgetIconGray48_TimelineChart';
				chartIconColor='widgetIcon48_TimelineChart';
				break;
			case 'distributedPie':
				title='Distributed Pie';
				chartIcon='widgetIconGray48_DistributedPieChart';
				chartIconColor='widgetIcon48_DistributedPieChart';
				break;
			case 'stackedbar':
				title='Stacked Bar';
				chartIcon='widgetIconGray48_StackedBarChart';
				chartIconColor='widgetIcon48_StackedBarChart';
				break;
			case 'table':
				title='Grid';
				chartIcon='widgetIconGray48_Table';
				chartIconColor='widgetIcon48_Table';
				break;
			case 'topn':
				title='Top N';
				chartIcon='widgetIconGray48_TopNChart';
				chartIconColor='widgetIcon48_TopNChart';
				break;
			case 'digital':
				title='Digital Chart';
				chartIcon='widgetIconGray48_DigitalChart';
				chartIconColor='widgetIcon48_DigitalChart';
				break;
			case 'multiDigi':
				title='Multi Digital';
				chartIcon='widgetIconGray48_MultiDigitalChart';
				chartIconColor='widgetIcon48_MultiDigitalChart';
				break;
			case 'heatMap':
				title='HeatMap';
				chartIcon='widgetIconGray48_Table';
				chartIconColor='widgetIcon48_Table';
				break;
			case 'verticalstackedbar':
				title='Vertical Stacked Bar';
				chartIcon='widgetIconGray48_StackedBarChart';
				chartIconColor='widgetIcon48_StackedBarChart';
			}
		if(returnType=='title')
			return title;
		else if(returnType=='gray')
			return chartIcon;
		else if(returnType=='color')
			return chartIconColor;
	},
	setPalette : function(c)
	{
		var blockId=this.getGraphpalettewindow().blockId;
		var configPanl=Ext.getCmp(blockId);
		configPanl.selectedGraphPalette=c.imageId;
		this.getGraphpalettewindow().hide();
	},
	showPaletteWindow : function(fWin)
	{
		var get_X = Ext.get(fWin.getEl().id).getX()-100;
		//var get_X = Ext.get(fWin.getEl().id).getX()-166
		var get_Y = Ext.get(fWin.getEl().id).getY()+20;

		//var graphpalettewindow=this.getGraphpalettewindow();
		//if (Ext.isEmpty(graphpalettewindow))
		//{
			var graphpalettewindow = Ext.widget('graphpalettewindow');
		//}

		graphpalettewindow.blockId=fWin.blockId;
		graphpalettewindow.selectedGraphPalette=fWin.selectedGraphPalette;
		graphpalettewindow.showAt([get_X,get_Y]);
		graphpalettewindow=null;
		delete graphpalettewindow;
	}
});