Ext.define('ReportTemplate.view.ConfigData', {
	requires : ['Ext.selection.CheckboxModel'],
	extend : 'Ext.grid.Panel',
	alias : 'widget.configdataalias',
	id : 'configdataid',
	maintainFlex:true,
	cls : 'gridSkin noShadow noShadowNoHeader',
	border:false,
	frame:false,
	autoScroll:'auto',
	//enableColumnResize : false,
	enableColumnMove : false,
	enableColumnHide : false,
	//sortableColumns : false,
	sortableColumns : true,//..
	selModel : new Ext.selection.CheckboxModel({
				checkOnly : true,
				headerWidth:28,
				injectCheckbox : 0
			}),
	height : 130,
	store : new Ext.data.Store({
 			fields : ['componentType','test','testValue','measure', 'measureValue','descriptor', 'displayName', 'displayNameDummy','function','glduration','er_duration','configString','ddconfigString']
 	}),
	viewConfig : {
		deferEmptyText : false,
		plugins:{
			ptype: 'gridviewdragdrop',
			dragText: 'Drag and drop to reorganize the configuration',
			onViewRender : function(view){
				var me = this, scrollEl;
				if (me.enableDrag) 
				{
					if (me.containerScroll) 
					{
							scrollEl = view.getEl();
                    }                   
                    me.dragZone = new Ext.view.DragZone({
						view: view,
						ddGroup: me.dragGroup || me.ddGroup,
						dragText: me.dragText,
						containerScroll: me.containerScroll,
						scrollEl: scrollEl,
						//to remember if the row was selected originally or not
						onBeforeDrag: function(data, e) {                            
							var me = this,
								view = data.view,
								selectionModel = view.getSelectionModel(),
								record = view.getRecord(data.item);
							if (!selectionModel.isSelected(record)) 
							{
								data.rowSelected = false;
							} 
							return true;
						},
						onInitDrag: function(x, y){
							var me = this,
								data = me.dragData,
								view = data.view,
								selectionModel = view.getSelectionModel(),
								record = view.getRecord(data.item);
							//for deselect the dragged record
							if (selectionModel.isSelected(record) && data.rowSelected == false) {
								selectionModel.deselect(record, true);                                
							}
							//added the original row so it will handle that in the drag drop
							data.records = [record];                            
							me.ddel.update(me.getDragText());
							me.proxy.update(me.ddel.dom);
							me.onStartDrag(x, y);
							return true;
						}
					});
				}
				if (me.enableDrop) {
					me.dropZone = new Ext.grid.ViewDropZone({
						view: view,
						ddGroup: me.dropGroup || me.ddGroup,
						//changed the selection at the end of this method
						handleNodeDrop : function(data, record, position) {
							var view = this.view,
								store = view.getStore(),
								index, records, i, len;
							if (data.copy)
							{
								records = data.records;
								data.records = [];
								for (i = 0, len = records.length; i < len; i++) {
								data.records.push(records[i].copy());
								}
							}
							else
							{                                
								data.view.store.remove(data.records, data.view === view);
							}                    
							if (record && position)
							{
								index = store.indexOf(record);
								if (position !== 'before') {
									index++;
								}
								store.insert(index, data.records);
							}                            
							else 
							{
								store.add(data.records);
							}
							if (view != data.view) {
								view.getSelectionModel().select(data.records);
							}                                                   
						}
                    });
                }
			}
		},
	}, 
	border : false,
	columns : [

			{
				text : 'Component Type',
				dataIndex : 'componentType',
				flex : 1.2
			}, /*
			{
				text : 'Component',
				dataIndex : 'component',
				flex : 1
			}, */
			{
				text : 'Test',
				dataIndex : 'test',
				flex : 1
			},
			{
				text : 'Measure',
				dataIndex : 'measure',
				flex : 1
			},
			{
				text : 'Descriptor',
				dataIndex : 'descriptor',
				flex : 1
			},
			{
				text : 'Display Name',
				dataIndex : 'displayName',
				flex : 1,
				hidden:true,
			},
			{
				text : 'Display Name',
				dataIndex : 'displayNameDummy',
				flex : 1
			},
			{
				//text : 'Function',
				text : 'Function',
				dataIndex : 'function',
				flex : 1
			},
			{
				text : 'glduration',
				dataIndex : 'glduration',
				hidden:true,
				flex : 1
			},

			{
				text : 'er_duration',
				dataIndex : 'er_duration',
				hidden:true,
				flex : 1
			},

			/*{
				xtype: 'actioncolumn',
				flex : 1,
				items: [
							{
								icon: 'app/resources/images/cog_edit.png',
								// Use a URL in the icon config
								tooltip: 'Edit',
								handler: function (grid, rowIndex, colIndex) {
									var rec = grid.getStore().getAt(rowIndex);
									alert("Edit " + rec.get('function'));
								}
							},
							{
								icon: 'app/resources/images/delete.png',
								tooltip: 'Delete',
								handler: function (grid, rowIndex, colIndex) {
									var rec = grid.getStore().getAt(rowIndex);
									alert("Terminate " + rec.get('function'));
								}
							}
						]
			 },*/

			{
 				header: 'Modify',
				xtype : 'actioncolumn',
				hidden:true,
				renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Modify" style="margin-top:2px"';
								return value;
							},
				width : 50,
				items : [
							{
								iconCls:'iconModify',
								handler : function(grid, htmlRow, index, columnIndex,mouseEvent, record)
								{
									
								}
							}
						]
			},
			{
 				header: '<div style="cursor:pointer" id="removeALL" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
				xtype : 'actioncolumn',
				renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Remove" style="padding-top:2px"';
								return value;
							},
				width : 40,
				items :
				[
					{
						iconCls:'iconDelete',
						handler : function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							var chartOption;
							if (app.isCustomLayout=='yes')
							{
								chartOption=app.currentWidget.chartType;
							}
							else
							{
								chartOption=curChartType;
							}

							if (chartOption=='table')
							{
								var displayField=record.data.displayName;
								var er_basedOnMeasure=Ext.getCmp('er_basedOnMeasure');
								var er_sortByCombo=Ext.getCmp('er_sortByCombo');
								var er_basedOnMeasureStore=Ext.getCmp('er_basedOnMeasure').getStore();
								var er_sortByComboeStore=Ext.getCmp('er_sortByCombo').getStore();

								var count=er_basedOnMeasureStore.getCount();
								//alert(count)
								for (var i=0;i<count;i++)
								{
									var rec=er_basedOnMeasureStore.getAt(i);
									var sortrec=er_sortByComboeStore.getAt(i);
									//console.log(rec);
									//console.log('displayField	'+rec.data.displayField);
									//alert(rec.data.displayField+'\n '+displayField)
									if (rec.data.displayField==displayField)
									{
										//alert("success");
										er_basedOnMeasureStore.remove(rec);
										er_sortByComboeStore.remove(sortrec);

										if (displayField==er_basedOnMeasure.getRawValue())
										{
											er_basedOnMeasure.setValue('-1');
											er_sortByCombo.setValue('-1');
										}
										break;
									}
								}
							}
							if(!Ext.isEmpty(Ext.getCmp(record.data.displayName+'-group')))
								Ext.getCmp(record.data.displayName+'-group').destroy();
							var ddGroupByBoxId = Ext.getCmp('ddGroupByBoxId');
							if(ddGroupByBoxId.items.length==0)
								ddGroupByBoxId.hide();
							grid.getStore().remove(record)
							grid.refresh();
							//grid.reload();
						}
					}
				]
			},
		]
});