Ext.define('ReportTemplate.view.ReportDataConfiguration',{
	extend:'Ext.form.Panel',
 	alias:'widget.reportdataconfiguration',
	//id:'reportdatadeckid',
 	id:'reportdataconfigurationid',
	margin:'0 10 0 24',
	//buttonAlign:'center',
	border:true,
	frame:false,
	width:836,
	layout:{
		type:'vbox',
		align:'stretch'
	},
	items:[
			{
				xtype:'fieldcontainer',
				flex:1,
				margin:'10 5 5 12',
				id:'multiLayoutDesEditId',
				hidden:true,
				layout:{
					type:'hbox',
					align:'stretch',
				},
				defaults:{
					labelAlign:'top',
					labelSeparator:''
				},
				items:[{
					xtype:'container',
					margin:'0 10 0 0',
					layout:{
						type : 'hbox',
						align : 'stretch'
					},
					items:[{
							xtype: 'container',
							id : 'userDefinedWidgetIcon',
							name : 'userDefinedWidgetIcon',
							margin : '0 10 5 0',
							width:48,
							height:48,
							html:'<div class="'+configureWindowGraphCls+'"></div>',

						},
						{
							xtype: 'fieldcontainer',
							margin : '2 5 5 5',
							layout:{
								type : 'vbox',
								align : 'stretch'
							},
							labelAlign:'top',
							labelSeparator:'',
							items: [
								{
									xtype: 'label',
									id:'WidgetNameItemIdLabel',
									html: '<div style="float:left;margin-top:3px" class="formLabelDivFont">Widget Name</div><div id ="WidgetNameEdit" style="float:left;margin-left:5px;margin-top:0px" class="iconRename"></div>',
									listeners:{
										afterrender:function(obj){
											obj.el.on('click',this.onEdit,this);
											},
									},
									onEdit: function(event, element,obj)
									{
										Ext.getCmp('WidgetNametextField').show();
										Ext.getCmp('userDefinedWidgetNameLbl').hide();
									},
								},
								{
									xtype:'textfield',
									cls: 'textbox',
									id:'WidgetNametextField',
									itemId:'WidgetNametextField',
									hidden:true,
									margin : '8 5 0 0',
								},
								{
									xtype: 'label',
									itemId : 'userDefinedWidgetNameLbl',
									id:'userDefinedWidgetNameLbl',
									hidden:false,
									text:'',
									margin : '10 5 0 0',
									cls:'editorNameField',
								},
							]
						}
					]
				}],
			},
			{
				xtype:'fieldcontainer',
				flex:1,
				margin:'10 5 5 12',
				id:'singleLayoutDesEditId',
				hidden:true,
				layout:{
					type:'hbox',
					align:'stretch',
				},
				defaults:{
					labelAlign:'top',
					labelSeparator:''
				},
				items:[{
					xtype:'container',
					margin:'0 10 0 0',
					//columnWidth:.35,
					layout:{
						type : 'hbox',
						align : 'stretch'
					},
					items:[{
							xtype: 'container',
							id : 'userDefinedTemplateIcon',
							name : 'userDefinedTemplateIcon',
							margin : '0 10 5 0',
							width:48,
							height:48,
							html:'<div class="'+configureWindowGraphCls+'"></div>',

						},{
							xtype: 'fieldcontainer',
							margin : '2 5 5 5',
							layout:{
								type : 'vbox',
								align : 'stretch'
							},
							labelAlign:'top',
							labelSeparator:'',
							items: [
								{
									xtype: 'label',
									id:'TemplateNameItemIdLabel',
									html: '<div style="float:left;margin-top:3px" class="formLabelDivFont">Template Name</div>',
								},
								{
									xtype: 'label',
									id:'userDefinedTemplateNameLbl',
									hidden:false,
									margin : '10 5 0 0',
									cls:'editorNameField',
								},
							]
						}
					]
				},{
					xtype: 'textfield',
					cls: 'textbox editorNameField',
					margin : '3 5 10 0',
					fieldLabel:'Description',
					id: 'descriptionId',
					name: 'descriptionId',
					//columnWidth:.65
					flex:1,
				}],
			},

			{
				 xtype: 'menuseparator',
				 margin:'0 10 0 10',
				 id:'multiLayoutDesEditSepId',
				 cls:'winSeparator',
				 hidden:true,
			},
			{
				xtype:'fieldcontainer',
				flex:1,
				margin:'10 10 0 0',
				layout:{
					type:'column',
					align:'stretch',
				},
				defaults:{
					margin:'0 10 10 10',
					labelAlign:'top',
					editable:false,
					labelSeparator:'',
					columnWidth:.25,
				},
				items:[
					{
						xtype:'scrollcombo',
						fieldLabel:'Report Source',
						cls: 'dropdown',
						id: 'er_testType',
						name: 'er_testType',
						store: Ext.data.Store
						(
							{
								fields: ['displayField','valueField'],
								data: []
							}
						),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype:'scrollcombo',
						fieldLabel:'Component Type',
						editable : true,//..
						typeAhead:true,//..
						listConfig:{
							emptyText:noComponentTypeMatch//..
						},
						cls: 'dropdown',
						id: 'er_compType',
						name: 'er_compType',
						store: Ext.data.Store
						(
							{
								fields: ['displayField','valueField'],
								data: []
							}
						),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable : true,//..
						typeAhead:true,//..
						listConfig:{
							emptyText:noComponentTypeMatch//..
						},
						fieldLabel: 'Test',
						name: 'er_test',
						id: 'er_test',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable : true,//..
						typeAhead:true,//..
						listConfig:{
							emptyText:noComponentTypeMatch//..
						},
						fieldLabel: 'Measure',
						name: 'er_measure',
						id: 'er_measure',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype: 'fieldcontainer',
						//fieldLabel:'DD Group Info',
						fieldLabel:'Summarize DD Data By',
						layout: 'column',
						id:'ddGroupInfoId',
						hidden:true,
						items:
						[
							{
								xtype: 'textfield',
								cls: 'textbox',
								width:155,
								columnWidth:.89,
								value:'',
								margin:'0 5 0 0',
								maskRe: /[A-Za-z0-9 .,]/,
								readOnly:true,
								id: 'ddGroupInfoTxtField',
								name:'ddGroupInfoTxtField',
								fieldValues:'',
							},
							{
								xtype: 'button',
								iconCls: 'iconOneClickMultiselectExpand',
								id: 'ddGroupInfoExpand',
								tooltip: '<b>DD Group</b>',
								columnWidth:.11,
								style: {
									 background: 'none',
									 border: '0px'
								 },
								 handler:function(obj){
									obj.setDisabled(true);
									var ddInfoArray=new Array();
									//var ddTxtValue=Ext.getCmp('ddGroupInfoTxtField').getValue();
									var ddTxtValue=Ext.getCmp('ddGroupInfoTxtField').fieldValues
									ddInfoArray=ddTxtValue.split(",");
									Ext.create('Ext.window.Window',{
											title:'DD Group',
											width:400,
											id:'builderSubWindow',
											border:false,
											frame:false,
											modal: true,
											ghost: false,
											height:300,
											padding:'0 10 5 10',
											listeners: {
												show: function (win) {
													if (this.modal)
													{
														var el ;
														var dom = Ext.dom.Query.select('.x-mask');
														for (var y = 0; y < dom.length; y++) {
															 el = Ext.fly(dom[y]);

														}
													 el.addCls('windowModal');
													}
												},
												hide: function (win) {
													var dom = Ext.dom.Query.select('.x-mask');
													if (this.modal) {

														var el = Ext.fly(dom[0]);
														el.removeCls('windowModal');
													}
												},
												afterrender: function () {
													Ext.EventManager.onWindowResize(function () {
														var me = this;
														me.center();
													}, this);
												}
											},
											doClose: function() {
												var me = this;
												obj.setDisabled(false);
												// Being called as callback after going through the hide call below
												if (me.hidden) {
													me.fireEvent('close', me);
													if (me.closeAction == 'destroy') {
														this.destroy();
													}
												} else {
													// close after hiding
													me.hide(me.animateTarget, me.doClose, me);
												}
											},
											buttonAlign:'center',
											items:[
													{
														xtype: 'multiselect',
														width:'100%',
														height:237,
														layout: 'fit',
														border : 0,
														autoScroll:false,
														scroll:false,
														labelAlign:'left',
														baseCls: 'egmultiselect',
														multiSelect: true,
														id: 'componentsClone',
														name: 'componentsClone',
														//store: cmpClone.getStore(),
														//value: cmpClone.getValue(),
														store: new Ext.data.Store({
															fields: ['displayField', 'valueField'],
															data: []
														}),
														value: [],
														displayField: 'displayField',
														valueField: 'valueField',
														queryMode: 'local',
														listeners:{
															//boxready
															afterrender: function () {
																this.getStore().loadRawData(app.ddGroupInfoData);
																this.getStore().removeAt(0);
																this.setValue(ddInfoArray);
															},
														},
													}
											],
											buttons:[
														{
															text:'Select',
															id: 'expand',
															cls:'quickMenuWhiteButton',
															name: 'expand',
															handler: function()
															{
																if ( Ext.getCmp('componentsClone').getValue() != '')
																{

																	var comboVal= Ext.getCmp('componentsClone').getValue();
																	var textFieldDisp='';
																	var valuesAry = new Array();
																	valuesAry=comboVal;
																	var comboValField= Ext.getCmp('componentsClone').getStore();
																	console.log(comboVal);
																	comboValField.each(function(r){
																		if(valuesAry.indexOf(r.data.valueField)>-1){
																			console.log(r.data.displayField);
																			textFieldDisp=textFieldDisp+r.data.displayField+','
																		}
																	});
																	textFieldDisp=textFieldDisp.substring(0,textFieldDisp.length-1);
																	Ext.getCmp('ddGroupInfoTxtField').setValue(textFieldDisp);
																	Ext.getCmp('ddGroupInfoTxtField').fieldValues=comboVal.toString();
																	obj.setDisabled(false);
																	this.up('window').destroy();
																}
																else
																{
																	Ext.getCmp('ddGroupInfoTxtField').setValue('');
																	Ext.getCmp('ddGroupInfoTxtField').fieldValues='';
																	obj.setDisabled(false);
																	this.up('window').destroy();
																			/* Ext.MessageBox.show({
																			title: 'Alert',
																			msg: 'Please Choose a DD Group',
																			buttons: Ext.MessageBox.OK,
																			icon: Ext.MessageBox.WARNING
																		});
																		return; */

																}
															}
														}
													]
									}).show();
								}
							 }
						 ]
					},
					{
						xtype: 'textfield',
						fieldLabel: 'Display Name',
						cls: 'textbox',
						maskRe: /[A-Za-z0-9 .,]/,
						id: 'disp_MeasureName',
						name:'disp_MeasureName'
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable : false,
						fieldLabel: 'Function',
						name: 'er_function',
						id: 'er_function',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable: false,
						//width: 200,
						fieldLabel: 'Filter Condition',
						name: 'glduration',
						id: 'glduration',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),

						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype: 'fieldcontainer',
						layout: 'column',
						hidden:false,
						id:'er_durationContainer',
						defaults:{
							labelSeparator:'',
						},
						items:[
							
							{
								xtype: 'textfield',
								fieldLabel: 'Default Value',
								id: 'er_duration',
								name: 'er_duration',
								//maskRe:/[0-9.-]/,
								maskRe:/[a-zA-Z0-9.-]+/,
								labelSeparator:'',
								maxLength :16,
								columnWidth:.5,
								enforceMaxLength :16,
								cls: 'textbox',
								labelAlign:'top',
								allowBlank:false,
								value: 0,
								editable:true,
							},
							{
								xtype:'checkbox',
								cls: 'checkbt',
								margin:'20 0 0 5',
								boxLabel: 'Dynamic?',
								inputValue: 'true',
								id: 'er_dynamic',
								name: 'er_dynamic',
								columnWidth:.5,
							},
						]
					},

					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable: false,
						fieldLabel: 'Descriptor Filter',
						name: 'er_descFilter',
						id: 'er_descFilter',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype: 'fieldcontainer',
						fieldLabel:'Action on descriptor',
						columnWidth:.4,
						layout: 'hbox',
						id:'descIncluderId',
						items: [{
							xtype: 'scrollcombo',
							cls: 'dropdown',
							editable: false,
							width:80,
							name: 'actionOnDes',
							id: 'actionOnDes',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: [{'displayField':'Include','valueField':'include'},{'displayField':'Exclude','valueField':'exclude'}]
							}),
							value:'include',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
						},
						{
							xtype: 'splitter'
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							value:'Not Applicable',
							maskRe: /[A-Za-z0-9 .,]/,
							readOnly:true,
							id: 'descriptorTxtField',
							name:'descriptorTxtField'
						},
						{
							xtype: 'splitter'
						},
						{
							 xtype: 'button',
							 iconCls: 'iconOneClickMultiSelectExpand',
							 id: 'expandComp',
							 tooltip: '<b>Descriptors</b>',
							 style: {
								 background: 'none',
								 border: '0px'
							 },
							 handler:function(obj){
								obj.setDisabled(true);
								var descArray=new Array();
								var desTxtValue=Ext.getCmp('descriptorTxtField').getValue();
								descArray=desTxtValue.split(",");
								Ext.create('Ext.window.Window',{
										title:'Descriptors',
										width:240,
										id:'builderSubWindow',
										border:false,
										frame:false,
										modal: true,
										ghost: false,
										cls:'expandWindowPopupShadow',
										height:300,
										header:{
											height:34,
											style:{'padding-bottom':'4px !important'},
										},
										padding:'0 10 5 10',
										listeners: {
											show: function (win) {
												if (this.modal)
												{
													var el ;
													var dom = Ext.dom.Query.select('.x-mask');
													for (var y = 0; y < dom.length; y++) {
														 el = Ext.fly(dom[y]);

													}
												 el.addCls('windowModal');
												}
											},
											hide: function (win) {
												var dom = Ext.dom.Query.select('.x-mask');
												if (this.modal) {

													var el = Ext.fly(dom[0]);
													el.removeCls('windowModal');
												}
											},
											afterrender: function () {
												Ext.EventManager.onWindowResize(function () {
													var me = this;
													me.center();
												}, this);
											}
										},
										doClose: function() {
											var me = this;
											obj.setDisabled(false);
											// Being called as callback after going through the hide call below
											if (me.hidden) {
												me.fireEvent('close', me);
												if (me.closeAction == 'destroy') {
													this.destroy();
												}
											} else {
												// close after hiding
												me.hide(me.animateTarget, me.doClose, me);
											}
										},
										buttonAlign:'center',
										items:[
										{
													xtype: 'container',
													width:220,
													layout:{
														type:'vbox',
														align:'stretch',
													},
													margin: 0,
													items: [
													{
														xype: 'container',
														cls: 'multisearchlist',
														style:{'top':'0px'},
														items: [{
															xtype: 'customtrigger',
															id: 'compSerch',
															listeners:{
																change:function()
																{
																	Ext.widget("erutils").filterComboStore(this,Ext.getCmp("componentsClone"),descriptorCombo);
																}
															}
														}]
													},
													{
														xtype: 'multiselect',
														width:'220',
														layout: 'fit',
														border : 0,
														autoScroll:true,
														scroll:false,
														labelAlign:'left',
														baseCls: 'egmultiselect',
														multiSelect: true,
														id: 'componentsClone',
														name: 'componentsClone',
														store: new Ext.data.Store({
															fields: ['displayField', 'valueField'],
															data: []
														}),
														value: [],
														displayField: 'displayField',
														valueField: 'valueField',
														queryMode: 'local',
														listeners:{
															afterrender: function () {
																this.getStore().loadRawData(descriptorCombo);
																this.setValue(descArray);
															}
														}
													}
												]
										}],
										dockedItems: [{
											xtype: 'toolbar',
											height:30,
											dock: 'bottom',
											items: [
											'->',
												{
													xtype: 'button',
													text:'SELECT',
													id: 'expand',
													cls:'buttonNew',
													padding:'0 4 0 4',
													name: 'expand',
													handler: function()
													{
														if ( Ext.getCmp('componentsClone').getValue() != '')
														{
															Ext.getCmp('descriptorTxtField').setValue(Ext.getCmp('componentsClone').getValue());
															obj.setDisabled(false);
															this.up('window').destroy();
														}
														else
														{
																	Ext.MessageBox.show({
																	title: 'Alert',
																	msg: 'Please Choose a Descriptors',
																	buttons: Ext.MessageBox.OK,
																	icon: Ext.MessageBox.WARNING
																});
																return;

														}
													}
												},
												'->'
											]}
										]
								}).show();
							}
						 }]
					},
					{
						xtype: 'fieldcontainer',
						fieldLabel:'Apply to Component Type',
						layout: 'column',
						id:'ComponentsTypeId',
						//hidden:true,
						items:
						[
							{
								xtype: 'textfield',
								cls: 'textbox',
								width:155,
								columnWidth:.89,
								value:'',
								margin:'0 5 0 0',
								maskRe: /[A-Za-z0-9 .,]/,
								readOnly:true,
								id: 'ComponentsTypeTxtField',
								name:'ComponentsTypeTxtField',
								fieldValues:'',
							},
							{
								xtype: 'button',
								iconCls: 'iconOneClickMultiselectExpand',
								id: 'ComponentsTypeExpand',
								tooltip: '<b>Component Type</b>',
								columnWidth:.11,
								style: {
									 background: 'none',
									 border: '0px'
								 },
								 handler:function(obj)
								 {
									obj.setDisabled(true);
									var ComponentsTypeArray=new Array();
									var ComponentsTypeTxtValue=Ext.getCmp('ComponentsTypeTxtField').fieldValues
									ComponentsTypeArray=ComponentsTypeTxtValue.split(",");
									Ext.create('Ext.window.Window',{
											title:'Component Types',
											width:400,
											id:'builderSubWindow',
											border:false,
											frame:false,
											modal: true,
											ghost: false,
											height:300,
											padding:'0 10 5 10',
											listeners: {
												afterrender: function (self) {
													Ext.EventManager.onWindowResize(function () {
														var me = this;
														me.center();
													}, this);

												}
											},
											doClose: function() {
												var me = this;
												obj.setDisabled(false);
												// Being called as callback after going through the hide call below
												if (me.hidden) {
													me.fireEvent('close', me);
													if (me.closeAction == 'destroy') {
														this.destroy();
													}
												} else {
													// close after hiding
													me.hide(me.animateTarget, me.doClose, me);
												}
											},
											buttonAlign:'center',
											items:[
													{
														xtype: 'multiselect',
														width:'100%',
														height:237,
														layout: 'fit',
														border : 0,
														autoScroll:false,
														scroll:false,
														labelAlign:'left',
														baseCls: 'egmultiselect',
														multiSelect: true,
														id: 'componentsClone',
														name: 'componentsClone',
														//store: cmpClone.getStore(),
														//value: cmpClone.getValue(),
														store: new Ext.data.Store({
															fields: ['displayField', 'valueField'],
															data: []
														}),
														value: [],
														displayField: 'displayField',
														valueField: 'valueField',
														queryMode: 'local',
														listeners:{
															//boxready
															afterrender: function () {
																this.getStore().loadRawData(app.relevantCompTypeByTest);
																//this.getStore().removeAt(0);
																this.setValue(ComponentsTypeArray);
															},
														},
													}
											],
											buttons:[
														{
															text:'Select',
															id: 'expand',
															cls:'quickMenuWhiteButton',
															name: 'expand',
															handler: function()
															{
																if ( Ext.getCmp('componentsClone').getValue() != '')
																{

																	var comboVal= Ext.getCmp('componentsClone').getValue();
																	var textFieldDisp='';
																	var valuesAry = new Array();
																	valuesAry=comboVal;
																	var comboValField= Ext.getCmp('componentsClone').getStore();
																	console.log(comboVal);
																	comboValField.each(function(r){
																		if(valuesAry.indexOf(r.data.valueField)>-1){
																			console.log(r.data.displayField);
																			textFieldDisp=textFieldDisp+r.data.displayField+','
																		}
																	});
																	textFieldDisp=textFieldDisp.substring(0,textFieldDisp.length-1);
																	Ext.getCmp('ComponentsTypeTxtField').setValue(textFieldDisp);
																	Ext.getCmp('ComponentsTypeTxtField').fieldValues=comboVal.toString();
																	obj.setDisabled(false);
																	this.up('window').destroy();
																}
																else
																{
																	Ext.MessageBox.show({
																			title: 'Alert',
																			msg: 'Please Choose a Component Type',
																			buttons: Ext.MessageBox.OK,
																			icon: Ext.MessageBox.WARNING
																		});
																		return;

																}
															}
														}
													]
									}).show();
								}
							 }
						 ]
					},
					{
						xtype: 'button',
						cls: 'buttonNewBig',
						name: 'addtogrid',
						margin:'14 10 5 10',
						columnWidth:.23,
						id: 'addtogrid',
						padding:'0 6 0 6',
						text: 'ADD CONFIGURATION',
						handler:function(){
							//app.appObj.getController(app.appController).addToGrid(this);
							app.appObj.getController(app.appController).beforeAddToGrid(this);
						}
					},

				]
			},
			{
				 xtype: 'menuseparator',
				 margin:'0 10 0 10',
				 cls:'winSeparator',
			},
			{
				xtype: 'configdataalias',
				margin:10,
				height:150,
			}
		],
	});