Ext.define('Reporter.controller.ReporterHome', {
    extend: 'Ext.app.Controller',
    requires: ['utilities.Print'],
    views: ['Main'],
    refs: [{
        selector: 'main',
        ref: 'main'
    }, {
        selector: 'newUtilities',
        ref: 'newUtilities'
    }, {
        selector: 'problemdistributionchart',
        ref: 'problemdistributionchart'
    }, {
        selector: 'serviceshealthchart',
        ref: 'serviceshealthchart'
    }, {
        selector: 'problemdurationanalysischart',
        ref: 'problemdurationanalysischart'
    }, {
        selector: 'componentglancechart',
        ref: 'componentglancechart'
    }, {
        selector: 'reporterhomesettings',
        ref: 'reporterhomesettings'
    }, {
        selector: 'print',
        ref: 'print'
    }, {
        selector: 'sendmail',
        ref: 'sendmail'
    }],
    init: function () {
        this.control({
            'main': {
                'boxready': this.infrastructureHealthRender
            },
            'newUtilities': {
                'afterrender': this.hideTools
            },
            'newUtilities > #saveTool > button': {
                'click': this.saveFileTool
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #printTool > button': {
                'click': this.printFile
            },
            'newUtilities > #scheduleTool > button': {
                'click': this.sendToschedule
            }
        });
    },
    sendToschedule: function () {
		var reportfor = Ext.getCmp('reportfor').getValue();
		var subreportfor = Ext.getCmp('subreportfor').getValue();
		var target = '/final/reporter/ErSaveSchedule.jsp?er_rtype=HomePage&er_timeline='+timeline+'&er_duration_state='+hduration+'&er_mode='+mode+'&startdate='+start_date+'&enddate='+last_date+'&er_gtype=HOMEPAGE&er_userid='+user_id+"&reportfor="+reportfor+"&subreportfor="+subreportfor;
parent.scheduleWindowFn(target); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

    },
    hideTools: function () {
		//console.log("Reporter Home  hide tools " + (new Date()).getSeconds());
        this.getNewUtilities().loadIcon(
            true, //save
            true, //print
            true, //mail
            false, //data
            false, //cvs
            false, // fav
            true, // schedule
            false, //daignosis
            false, //togglebutton
            false //close
        );
        Ext.getCmp("saveTool").setDisabled(false);
        Ext.getCmp("printTool").setDisabled(false);
        Ext.getCmp("mailTool").setDisabled(false);
        Ext.getCmp("scheduleTool").setDisabled(false);
		//console.log("Reporter Home  after hide tools " + (new Date()).getSeconds());
    },
    
    printFile: function () {
		var reportfor = Ext.getCmp('reportfor').getValue();
		var subreportfor = Ext.getCmp('subreportfor').getValue();
		var reportStr = "";
		if(reportfor != '-1')
		{
			reportStr = "&reportfor="+reportfor+"&subreportfor="+subreportfor+"&";
		}
		var s_qryString = "../servlet/com.eg.ErDashBoardControllerServlet?er_duration_state="+encodeURIComponent(hduration)+"&er_timeline="+encodeURIComponent(timeline)+"&er_views=print&startdate="+encodeURIComponent(start_date)+"&enddate="+encodeURIComponent(last_date)+""+"&er_mode="+encodeURIComponent(mode)+"&pdfPrint=yes"+reportStr;
        parent.printWindowFn(s_qryString);
       
    },
    infrastructureHealthRender: function () {
		//console.log('Reporter Home . box ready ' + (new Date()).getSeconds());

		if (er_RmDispName!= null && er_RmDispName!= 'null' && er_RmDispName!= 'undefined')
			this.getMain().setTitle(er_RmDispName);
		
        this.getMain().showConfigDropdown();

        if (!Ext.isEmpty(publicJsonData)) {
			var treeParam = publicJsonData['treeParam'];
			console.log('treeparam is ' + treeParam);
			var errorMsg = publicJsonData.screenLabels["errorMsg"];
			if(errorMsg!=null && errorMsg=="-")
			{
				 Ext.getCmp("saveTool").setDisabled(false);
		        Ext.getCmp("printTool").setDisabled(false);
			}else
			{
				Ext.getCmp("saveTool").setDisabled(true);
				Ext.getCmp("printTool").setDisabled(true);
			}

			if(treeParam!=null && treeParam == 'distduration')
			{
			    this.getProblemdistributionchart().loadChart(publicJsonData);
				this.getProblemdurationanalysischart().loadChart(publicJsonData);
				Ext.getCmp("Services_health").hide();
				Ext.getCmp("componentGlance").hide();
			
			    this.getReporterhomesettings().loadFields(publicJsonData);
			}
			else
			{
				this.getProblemdistributionchart().loadChart(publicJsonData);
				this.getProblemdurationanalysischart().loadChart(publicJsonData);
				this.getServiceshealthchart().loadChart(publicJsonData);
	            this.getComponentglancechart().loadChart(publicJsonData);
		        this.getReporterhomesettings().loadFields(publicJsonData);
            }
			this.loadField(publicJsonData);
        }

        Ext.EventManager.onWindowResize(function () {
            Ext.get('configMod').setStyle('left', '');
        });
		//console.log('Reporter Home after box ready ' + (new Date()).getSeconds());


    },
    saveFileTool: function () {
		var reportfor = Ext.getCmp('reportfor').getValue();
		var subreportfor = Ext.getCmp('subreportfor').getValue();
        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?er_duration_state=" + hduration + "&er_timeline=" + timeline + "&er_views=print&startdate=" + start_date + "&enddate=" + last_date + "&er_mode=" + mode + "&er_pgName=Home&reportfor="+reportfor+"&subreportfor="+subreportfor+"&";
        var erUtils = Ext.widget('erutils');
        erUtils.savePDF(s_qryString);
    },
    sendMail: function () {

        var windowMail = Ext.widget('sendmail');
        windowMail.show();
    },
    saveSchedule: function () {
        var windowSchedule = Ext.widget('saveschedule');
        windowSchedule.show();
    },
    loadField: function (jsonData) {
        Ext.getCmp("problemdurationstate").store.loadRawData(jsonData.problemStateComboJson);
        Ext.getCmp("problemdurationstate").suspendEvents(false);
	hduration = jsonData.problemState_value
        Ext.getCmp("problemdurationstate").setValue(hduration);
        Ext.getCmp("problemdurationstate").resumeEvents();

    }


});