Ext.define("Reporter.view.Main", {
    extend: "utilities.NewOuterPanel",
   // extend: "Ext.panel.Panel",
    alias: "widget.main",
    title: "Infrastructure Overview",
    requires: ["utilities.CommonPanel", "utilities.ReporterSettings", "utilities.newUtilities", "utilities.ErUtils", "utilities.SendMail", "Reporter.view.ProblemDistributionChart", "Reporter.view.ProblemDurationAnalysisChart", "Reporter.view.ServicesHealthChart", "Reporter.view.ComponentTypesAtGlanceChart", "Reporter.view.ReporterHomeSettings", "utilities.Print",'utilities.ScrollCombo'],
    id: "infrastrutureOverview",
    layout: {
        align: "stretch",
        type: "vbox",
        pack: "start"
    },
	margin:10,
	ui:'newOuterPanel',
    showConfigDropdown: function () {
        var a = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right"><div class="iconCloseNew" id="close"></div></div>');
        Ext.create("Ext.container.Container", {
            width: 360,
            //padding: 5,
            id: "configMod",
			ui:'settingsWindowContainer',
			// Dont write this syle in CSS, this is only for Home Page
			// If u write, it will affect all report pages
			style:
			{
				'right':'40px'
			},
            //html: a.apply(),
			layout:'auto',
            items: [
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'254px'}
			},
			{
				xtype:'container',
				html: a.apply(),
				cls:'containerHeader',
				style:{'top':'0px','margin':'0px'}
			},
			{
                xtype: "reporterhomesettings",
                parent: this

            }],
            renderTo: "infrastrutureOverview-body",
            listeners: {
                render: function () {
                    Ext.get("close").on("click", function () {
                        Ext.get("configMod").animate({
                            duration: 500,
                            to: {
                                y: -350
                            }
                        });
                    });
                }
            }
        }).hide();
    },
    tools: [
		{
			xtype:'button',
			text:backText,
			cls:'backbutton',
			iconCls:'iconBack',
			id:'bckButton',
			hidden: hideBackButton,
			listeners:{
				'click':function(){
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
					appConstants.erUtils.firebackbuttonaction('../reporter/EgReporterback.jsp');
				}
			}
		},{
        xtype: "ReporterSettings",
		margin: '0 3 0 3',
    },
	{
        xtype: "newUtilities"
    }],
    items: [{
        xtype: "panel",
        flex: 1,
		margin:'5 5 0 5',
        layout: {
            type: "hbox",
            align: "stretch",
            pack: "start"
        },
        items: [{
            xtype: "panel",
			flex:1,
			border:true,
			ui:'newGraphPanel',
			padding:0,
			margin:'6 6 6 6',
            title: "Problem Distribution",
            id: "Problem_distribution",
			scroll:true,
			autoScroll:true,
            items: [{
                xtype: "problemdistributionchart"
              }]
        }, {
            xtype: "panel",
			border:true,
			flex:1,
            title: "Problem Duration Analysis",
			ui:'newGraphPanel',
			scroll:true,
			autoScroll:true,
			padding:0,
			margin:'6 6 6 6',
            id: "Problem_duration",
            tools: [{
                xtype: "scrollcombo",
                cls: "dropdown",
                editable: false,
                width: 80,
				margin:'0 4px 0 0',
                name: "problemdurationstate",
                id: "problemdurationstate",
                displayField: "displayField",
                valueField: "valueField",
                queryMode: "local",
                store: new Ext.create("Ext.data.Store", {
                    fields: ["displayField", "valueField"],
                    data: []
                }),
                listeners: {
                    change: function (e, d, a, b) {
                        var c = Ext.getCmp("durations").getValue();
                        var f = Ext.getCmp("graphmode").getValue();
                        var reportfor = Ext.getCmp("reportfor").getValue();
                        var subReport = Ext.getCmp("subreportfor").getValue();
                        window.location.href = "/final/servlet/com.eg.ErDashBoardControllerServlet?er_duration_state=" + this.getValue() + "&er_timeline=" + c + "&er_mode=" + f+'&reportfor='+reportfor+"&subreportfor="+subReport;
                    }
                }
            }],
            items: [{
                xtype: "problemdurationanalysischart"
            }]
        }]
    }, {
        xtype: "panel",
		margin:'0 5 5 5',
        flex: 1,
        layout: {
            type: "hbox",
            align: "stretch",
            pack: "start"
        },
        items: [{
            xtype: "panel",
			flex:1,
			border:true,
			ui:'newGraphPanel',
            title: "Services Health",
	        //padding: "0 0 10 0",
            id: "Services_health",
			scroll:true,
			//autoScroll:true,
			overflowY: 'auto',
			margin:'6 6 6 6',
            items: [{
                xtype: "serviceshealthchart",
            }]
        }, {
            xtype: "panel",
			border:true,
			flex:1,
			ui:'newGraphPanel',
			margin:'6 6 6 6',
			padding:0,		
			scroll:false,
			autoScroll:false,
			title: "Component Types At-A-Glance",
			id: "componentGlance",
			//padding: "0 0 10 0",
	            items: [{
	                xtype: "componentglancechart"
	            }]
        }]
    }]
});