var reportName="";
Ext.define('reportermenudashboard.controller.ReporterController', {
    extend: 'Ext.app.Controller',
    views: ['reportermenudashboard.view.Main'],
    stores: ['reportermenudashboard.store.ReportComponentStore', 'reportermenudashboard.store.ReportSegmentStore', 'reportermenudashboard.store.ReportServiceStore', 'reportermenudashboard.store.ReportZoneStore', 'reportermenudashboard.store.ReportFunctionStore'],
    collapsiblePaneCount:0,	//this variable is used maintain unique id attribute in collapsible panel contents(i.e., td's and div that has iconComponentDelete class)
    refs: [
        {
            ref: 'myReportComponentPanel',
            selector: 'reportComponentPanel'
        },
        {
            ref: 'myReportSegmentPanel',
            selector: 'reportSegmentPanel'
        },
        {
            ref: 'myReportServicePanel',
            selector: 'reportServicePanel'
        },
        {
            ref: 'myReportZonePanel',
            selector: 'reportZonePanel'
        },
        {
            ref: 'myReportFunctionPanel',
            selector: 'reportFunctionPanel'
        }
    ],
    init: function() {
        this.control({
			'main':{
				'afterrender': this.mainAfterRender,
				//'beforerender': registerAjaxEvents	//this method is included in ErTracker.jsp
			},
            'listofmeasures': {
                'afterrender': this.afterAccordionRender,
                'boxready': this.accordionTreeExpand
             },
            'reportComponentPanel': {
                'load': this.componentTreeLoad,
                'collapse': this.componentPanelCollapse,
                'expand': this.componentPanelExpand,
                'itemexpand': this.componentPanelItemExpand,
                'itemclick': this.componentPanelItemClick
                //'itemmouseenter': this.applyTreeStyle,
               //'itemmouseleave': this.removeTreeStyle
            },
            'reportFunctionPanel': {
				'afterrender':this.afterFunctionRender,
				'load': this.functionTreeLoad,
                'collapse': this.functionPanelCollapse,
                'expand': this.functionPanelExpand,
                'itemclick': this.functionPanelItemClick,
                'beforeitemexpand': this.functionPanelBeforeExpand,
                'afteritemexpand': this.functionPanelAfterExpand,
                'beforeitemcollapse': this.functionPanelBeforeCollapse,
                'afteritemcollapse': this.functionPanelAfterCollapse
                //'itemmouseenter': this.applyTreeStyle,
                //'itemmouseleave': this.removeTreeStyle
            },
            'reportSegmentPanel': {
				'load': this.segmentTreeLoad,
                'collapse': this.segmentPanelCollapse,
                'expand': this.segmentPanelExpand,
                'itemexpand': this.segmentPanelItemExpand,
                'itemclick': this.segmentPanelItemClick
                //'itemmouseenter': this.applyTreeStyle,
                //'itemmouseleave': this.removeTreeStyle
            },
            'reportServicePanel': {
				'load': this.serviceTreeLoad,
                'collapse': this.servicePanelCollapse,
                'expand': this.servicePanelExpand,
                'itemexpand': this.servicePanelItemExpand,
                'itemclick': this.servicePanelItemClick
                //'itemmouseenter': this.applyTreeStyle,
                //'itemmouseleave': this.removeTreeStyle
            },
            'reportZonePanel': {
				'load': this.zoneTreeLoad,
                'collapse': this.zonePanelCollapse,
                'expand': this.zonePanelExpand,
                'itemexpand': this.zonePanelItemExpand,
                 'itemclick': this.zonePanelItemClick
                //'itemmouseenter': this.applyTreeStyle,
                //'itemmouseleave': this.removeTreeStyle
            },
            'timelinecomp combo[name="rmComponentType"]': {
                'select': this.rmComponentTypeOnchange
            },
	    'contentPanel trigger[id="filterReports"]':{
	    	'change': this.getFilteredData
	    },
        });	 //end this.control
    }, //end init
    accordionTreeExpand: function() {
		//accordion.items.get(2).expand();
		if (startUpPanel=='function')
		{
			this.getMyReportFunctionPanel().expand();
		}
		else if (startUpPanel=='component')
		{
			this.getMyReportComponentPanel().expand();
		}
		else if (startUpPanel=='zone')
		{
			this.getMyReportZonePanel().expand();
		}
		else if (startUpPanel=='segment')
		{
			this.getMyReportSegmentPanel().expand();
		}
		else if (startUpPanel=='service')
		{
			this.getMyReportServicePanel().expand();
		}
		else
		{
			this.getMyReportFunctionPanel().expand();
		}
    },
    componentPanelExpand: function() {
		this.setSessionItems('component',null,null,null,null);
    },
	functionPanelExpand: function() {
		this.setSessionItems('function',null,null,null,null);
		this.setTextForExpandCollpaseTool();
    },
	segmentPanelExpand: function() {
		this.setSessionItems('segment',null,null,null,null);
    },
	servicePanelExpand: function() {
		this.setSessionItems('service',null,null,null,null);
    },
	zonePanelExpand: function() {
		this.setSessionItems('zone',null,null,null,null);
    },
    componentPanelCollapse: function() {
        var myTree = this.getMyReportComponentPanel();
        //myTree.header.removeCls('accordionHighLight');
        myTree.collapseAll();
    },
    functionPanelCollapse: function() {
		this.setTextForExpandCollpaseTool();
        var myTree = this.getMyReportFunctionPanel();
        //myTree.header.removeCls('accordionHighLight');
        myTree.collapseAll();
		
    },
    segmentPanelCollapse: function() {
        var myTree = this.getMyReportSegmentPanel();
        //myTree.header.removeCls('accordionHighLight');
        myTree.collapseAll();
    },
    servicePanelCollapse: function() {
        var myTree = this.getMyReportServicePanel();
        //myTree.header.removeCls('accordionHighLight');
        myTree.collapseAll();
    },
    zonePanelCollapse: function() {
        var myTree = this.getMyReportZonePanel();
        //myTree.header.removeCls('accordionHighLight');
        myTree.collapseAll();
    },
    applyTreeStyle: function(node)
    {
        // window.status="show my status bar";
         //Ext.select('div.x-grid-cell-inner').on('click', this.nodeClicked);
    },
    removeTreeStyle: function()
    {
		//Ext.get(e.target).addCls("treenodeout");
    },
    nodeClicked: function(e)
    {
        // Ext.get(e.target).addCls("treenodeover");
    },
	removeMapKey:function(map,remKey,str)
	{
		if (map.containsKey(remKey))
		{
			var val=map.get(remKey);
			if (val.indexOf(str)>-1)
			{
				map.removeAtKey(remKey);
			}
		}
	},
	beforeSetFrameSource:function(sourceURL)
	{
		var map=this.parseQueryStringIntoHashMap(sourceURL);
		this.removeMapKey(map,'er_comptype','{Component');
		this.removeMapKey(map,'treeCompType','{Component');
		this.removeMapKey(map,'er_compType','{Component');
		this.removeMapKey(map,'rmComponentType','{Component');
		sourceURL=this.parseHashMapIntoQueryString(map);
		return sourceURL;
		//console.log(this.parseQueryStringIntoHashMap(sourceURL));
		//console.log(this.parseHashMapIntoQueryString(this.parseQueryStringIntoHashMap(sourceURL)));
 	},
	parseHashMapIntoQueryString:function(map){
		var mapParams='';
		var mapURL;
		if (map.containsKey('mapURL'))
		{
			mapURL=map.get('mapURL');
			map.removeAtKey('mapURL');
		}
		map.each(function(key, value, length){
			 mapParams+='&'+key+'='+value;
		});
		if (!Ext.isEmpty(mapURL))
		{
			mapParams = mapURL+mapParams.replace('&','?');
 		}
		else
		{
			mapParams = mapParams.substring(1);
		}
		return mapParams;
	},
	parseQueryStringIntoHashMap:function(queryString){
		var map = new Ext.util.HashMap();
		var qindex=queryString.indexOf('?');
		var uriParamsArray,paramsArray;
		if (qindex>-1)
		{
			uriParamsArray=queryString.split('?');
			queryString=uriParamsArray[1];
			map.add('mapURL', uriParamsArray[0]);
		} 
		var paramsArray=queryString.split('&');
		for (var key in paramsArray)
		{
				var splitIntoKeyValue=paramsArray[key].split('=');
				map.add(splitIntoKeyValue[0], splitIntoKeyValue[1]);
		}
		uriParamsArray=null;delete uriParamsArray;
		return map;
	},
	setFrameSource:function(sourceURL)
	{
		/*if (!Ext.isEmpty(sessionStorage.getItem("expanedPane")))
		{
			if (sessionStorage.getItem("expanedPane").toLowerCase()=='component')
			{
				//console.log('before sourceURL----'+sourceURL);
				sourceURL=this.beforeSetFrameSource(sourceURL);
			}
		}*/
		if (Ext.get('reportFrame')==null)
		{
			//console.log('reportframe not exist');
			var sourceURLIframe = sourceURL;
			if(sourceURL!=undefined && sourceURL.length>1024 && sourceURL.indexOf("ReportBuilder.jsp")==-1)
			{
				sourceURL = '/final/reporter/Preload.jsp?'
			}
			var iframeObj = {
				xtype: 'component',
				id: 'reportFrame',
				name: 'reportFrame',
				sourceURL:sourceURLIframe,
				autoEl: {
					tag: 'iframe',
					src: sourceURL
				},
				margin: '-12px',
			};
			Ext.getCmp('centerRegion').removeAll();
			Ext.getCmp('centerRegion').add(iframeObj);
		}
		else
		{
			//console.log('reportframe exist');
			document.getElementById('reportFrame').src=sourceURL;
		}




	},
	mainAfterRender:function()
	{
 		//console.log('borderCollapse----'+sessionStorage.getItem("borderCollapse"));
		var westRegion=Ext.getCmp('westRegion');
		if(isOnlyVMAssigned == 'true')
		{
				westRegion.hide();
		}
		if (Ext.get('westRegion-splitter-collapseEl')!=null)
		{
			Ext.get('westRegion-splitter-collapseEl').on('click',function(){

				if (westRegion.collapsed==true || westRegion.collapsed=='left')
				{
					//alert(westRegion.collapsed);
					sessionStorage.setItem("borderCollapse", true);
					//console.log('borderCollapse----'+sessionStorage.getItem("borderCollapse"));
				}
				else
				{
					//alert(westRegion.collapsed);
					sessionStorage.setItem("borderCollapse", false);
					//console.log('borderCollapse----'+sessionStorage.getItem("borderCollapse"));
				}
 			});
		}
	},
	afterAccordionRender:function()
	{
 		//alert('westRegion--'+Ext.getCmp('westRegion'));
		//Ext.getCmp('westRegion').collapse();
		//container.down('[region=north]').collapse();
 		if (lastAccessedURL == null || lastAccessedURL == 'null' || lastAccessedURL == '' || lastAccessedURL == undefined)
        {
            if (dashBoardHomeUrl == 'false')
            {
                 this.componentTreeLoad();//if dashboard home page is false then tree home content is loaded in center region
            }
            else
            {
                  this.setFrameSource(this.getLoadUrl());
            }
        }
        else
        {
            if (!Ext.isEmpty(loadKey) && loadKey != 'null')
            {
                this.setFrameSource(this.getLoadUrl());
            }
            else
            {
				var expanedPane=sessionStorage.getItem("expanedPane");
				var nodeId=sessionStorage.getItem("nodeId");
				var isLeafNode=sessionStorage.getItem("isLeafNode");
 				var nodeMode=sessionStorage.getItem("nodeMode");
				var lastAccessedNodeId=sessionStorage.getItem("lastAccessedNodeId");
 				var borderCollapse=sessionStorage.getItem("borderCollapse");


				/*console.log('---------session storage-----------');
				console.log('expanedPane----'+expanedPane);
				console.log('nodeId----'+nodeId);
				console.log('isLeafNode----'+isLeafNode);
				console.log('nodeMode----'+nodeMode);
				console.log('lastAccessedNodeId----'+lastAccessedNodeId);
				console.log('borderCollapse----'+borderCollapse);
				console.log('---------session storage-----------');*/


				if(expanedPane!=null)
				{
					if(expanedPane=='function')
					{
						if(isLeafNode=='true')
						{
							//alert('yes leafnode');
							this.setFrameSource(lastAccessedURL);
						}
						else
						{
							//alert('no leafnode so lastAccessedNodeId will become null so that loading lastAccessedURL');
							if(!Ext.isEmpty(lastAccessedNodeId) && lastAccessedNodeId!='null')
								this.refreshCenterRegion(lastAccessedNodeId);
							else
								this.setFrameSource(lastAccessedURL);
						}
					}
					else
					{
						//alert('lastAccessedNodeId------'+lastAccessedNodeId);
						if(!Ext.isEmpty(lastAccessedNodeId) && lastAccessedNodeId!='null')
							this.refreshCenterRegion(lastAccessedNodeId);
						else
							this.setFrameSource(lastAccessedURL);
					}
				}
				else
					this.setFrameSource(lastAccessedURL);
            }
        }

	},
	getFilteredData:function(obj){	
		obj.toggleTriggger();
		var searchStr = Ext.getCmp('filterReports').getValue();		
		Ext.get('configMod').animate({duration: 500, to: {y: -500}});
 		var url = treeNodeTraverse + "&er_search=" + searchStr;
 		var contentpane=Ext.getCmp('cpan');
		var me=this;
		initLdgMask.show();
 		Ext.Ajax.request
				({
					url: url,
					method: 'GET',
					scope: this,
					success: function(response)
					{
						me.fillSearchInContentPanel(response, contentpane);
						initLdgMask.hide();
 					},
					failure: function(err)
					{
						Ext.MessageBox.alert('Error occured in jsp page', 'Please try again!');
					}
				});
	},
    loadUpdatedTimeLineApp: function(anchorHref)
    {
        //add isForceSubmit=true for all the id's from Component,Segment,Service and Zone to force submitting while app is loading for first time
//        appConstants.isForceSubmit = 'true';
        if (anchorHref.indexOf('?') > -1)
        {
            anchorHref += '&isForceSubmit=' + appConstants.isForceSubmit;
        }
        else
        {
            anchorHref += '?isForceSubmit=' + appConstants.isForceSubmit;
        }
        if (anchorHref.indexOf('reportFor=CompareGraph') > -1)
        {
            anchorHref += '&callFromReport=false';
        }
		this.setFrameSource(anchorHref);
    },

   loadUpdatedTimeLineApp:function(anchorHref, anchorDispName)
    {
	     //add isForceSubmit=true for all the id's from Component,Segment,Service and Zone to force submitting while app is loading for first time
		if( anchorHref.indexOf('er_gtype=Compliance')>0 || (anchorHref.indexOf('ErCompareTest.jsp?')>0 && anchorHref.indexOf('er_RmSelections')==-1)){
			appConstants.isForceSubmit = 'false';
		}
		//else
		//	appConstants.isForceSubmit = 'true';
        if (anchorHref.indexOf('?') > -1)
        {
            anchorHref += '&isForceSubmit=' + appConstants.isForceSubmit + "&er_RmDispName=" + anchorDispName;
        }
        else
        {
            anchorHref += '?isForceSubmit=' + appConstants.isForceSubmit + "&er_RmDispName=" + anchorDispName;
        }
        if (anchorHref.indexOf('reportFor=CompareGraph') > -1)
        {
            anchorHref += '&callFromReport=false';
        }
		anchorHref+="&select_farm="+appConstants.rmDataFrom;
		anchorHref+="&er_userOption="+appConstants.rmDataFrom;
        //anchorHref+='&appConstants.isForceSubmit=true';
        //alert('loadUpdatedTimeLineApp---anchorHref---' + anchorHref);
		this.setFrameSource(anchorHref);

    },
	componentPanelItemExpand:function(node)
	{
			this.ajaxNodeUpdate(node);
			this.setSessionItems('component',node.get('id'),false,'expand',null);	
	},
    componentPanelItemClick: function(view, node) {
		this.collapsiblePaneCount=0;
        if (node.isLeaf()) {
            if (node.get('text').toLowerCase() == 'no component found')
            {
                return;
            }
            else
            {
                this.ajaxNodeUpdate(node);
				this.setSessionItems('component',node.get('id'),true,'expand',node.get('id'));
            }
        }
        else if (node.isExpanded()) {
            node.collapse();
			this.setSessionItems('component',node.get('id'),false,'collapse',null);
            //this.singleNodeUpdate_centerRegion(node);
        }
        else {
            node.expand();
			this.setSessionItems('component',node.get('id'),false,'expand',null);
             //this.singleNodeUpdate_centerRegion(node);
        }
    },
	servicePanelItemExpand:function(node)
	{
			this.ajaxNodeUpdate(node);
			this.setSessionItems('service',node.get('id'),false,'expand',node.get('id'));	
	},
    servicePanelItemClick: function(view, node) {
		this.collapsiblePaneCount=0;
        if (node.isLeaf()) {
            if (node.get('text').toLowerCase() == 'no service found')
            {
                return;
            }
            else
            {
                this.ajaxNodeUpdate(node);
				this.setSessionItems('service',node.get('id'),true,'expand',node.get('id'));
            }
        }
        else if (node.isExpanded()) {
            node.collapse();
            //this.singleNodeUpdate_centerRegion(node);
            this.ajaxNodeUpdate(node);
			this.setSessionItems('service',node.get('id'),false,'collapse',node.get('id'));
        }
        else {
            node.expand();
            //this.singleNodeUpdate_centerRegion(node);
            this.ajaxNodeUpdate(node);
			this.setSessionItems('service',node.get('id'),false,'expand',node.get('id'));
        }
    },
	segmentPanelItemExpand:function(node)
	{
			this.ajaxNodeUpdate(node);
			this.setSessionItems('segment',node.get('id'),false,'expand',node.get('id'));
		
	},
    segmentPanelItemClick: function(view, node) {
		this.collapsiblePaneCount=0;
        if (node.isLeaf()) {
            if (node.get('text').toLowerCase() == 'no segment found')
            {
                return;
            }
            else
            {
				this.ajaxNodeUpdate(node);
				this.setSessionItems('segment',node.get('id'),true,'expand',node.get('id'));
            }
        }
        else if (node.isExpanded()) {
            node.collapse();
            //this.singleNodeUpdate_centerRegion(node);
            this.ajaxNodeUpdate(node);
			this.setSessionItems('segment',node.get('id'),false,'collapse',node.get('id'));
        }
        else {
            node.expand();
            //this.singleNodeUpdate_centerRegion(node);
            this.ajaxNodeUpdate(node);
			this.setSessionItems('segment',node.get('id'),false,'expand',node.get('id'));
        }
    },
	zonePanelItemExpand:function(node)
	{
			this.ajaxNodeUpdate(node);
			this.setSessionItems('zone',node.get('id'),false,'expand',node.get('id'));	
	},
    zonePanelItemClick: function(view, node) {
		this.collapsiblePaneCount=0;
        if (node.isLeaf()) {
            if (node.get('text').toLowerCase() == 'no zone found')
            {
                return;
            }
            else
            {
                this.ajaxNodeUpdate(node);
				this.setSessionItems('zone',node.get('id'),true,'expand',node.get('id'));
            }
        }
        else if (node.isExpanded()) {
            node.collapse();
            //this.singleNodeUpdate_centerRegion(node);
            this.ajaxNodeUpdate(node);
			this.setSessionItems('zone',node.get('id'),false,'collapse',node.get('id'));
        }
        else {
			//alert('zone-node-expanded');
			//node.set('iconCls', 'zone-node-expanded');
            node.expand();
            //this.singleNodeUpdate_centerRegion(node);
            this.ajaxNodeUpdate(node);
			this.setSessionItems('zone',node.get('id'),false,'expand',node.get('id'));
        }
    },
    functionPanelItemClick: function(view, node) {
		//alert(this.getMyReportZonePanel().getStore().getNodeById(node.get('id')).get('id'));
        if (node.isLeaf()) {
            this.ajaxFunctionNodeUpdate(node);
			this.setSessionItems('function',node.get('id'),true,'expand',null);
			var node_title = node.get('text');
			//if(node_title != undefined && node_title.toLowerCase()=='citrix overview')
			if(collapseMenu != undefined && collapseMenu.toLowerCase()=='true')
			{
				var westPanel=Ext.getCmp('westRegion');
				westPanel.collapse();
				if (westPanel.collapsed==true || westPanel.collapsed=='left')
				{
					sessionStorage.setItem("borderCollapse", true);
				}
				else
				{
					sessionStorage.setItem("borderCollapse", false);
				}
			}
        }
        else if (node.isExpanded()) {
            node.collapse();
			this.setSessionItems('function',node.get('id'),false,'collapse',null);
			this.setTextForExpandCollpaseTool();
            // this.singleNode_FunctionUpdate(node);
            //this.ajaxNodeUpdate(node);
        }
        else {
            node.expand();
			this.setSessionItems('function',node.get('id'),false,'expand',null);
			this.setTextForExpandCollpaseTool();
			//document.getElementById('exx').innerHTML='Collapse all';
            // this.singleNode_FunctionUpdate(node);
            // this.ajaxNodeUpdate(node);
        }
	
    },
	functionPanelBeforeExpand:function(node){
		if (appConstants.detectIEVersion!=false)
		{
			if (appConstants.detectIEVersion>9)
			{
				node.set('cls', 'x-grid-tree-node-expanded');
			}
		}
		this.getMyReportFunctionPanel().getEl().mask("Expanding...", 'x-mask-loading');
	},
	functionPanelAfterExpand:function(node){
		this.getMyReportFunctionPanel().getEl().unmask();
	},
	functionPanelBeforeCollapse:function(node){
		this.getMyReportFunctionPanel().getEl().mask("Collapsing...", 'x-mask-loading');
	},
	functionPanelAfterCollapse:function(node){
		var me= this;
		if (appConstants.detectIEVersion!=false)
		{
			if (appConstants.detectIEVersion>9)
			{
				setTimeout(function(){
					node.set('cls', 'x-grid-tree-node-collpased');
					me.getMyReportFunctionPanel().getEl().unmask();
				},100);
			}
		}
		else
		{
			me.getMyReportFunctionPanel().getEl().unmask();
		}

	},
	setTextForExpandCollpaseTool:function(){
		var childNodes=this.getMyReportFunctionPanel().getRootNode().childNodes;
 		var allCollapseFlag=0;
		for (var key in childNodes)
		{
			if (childNodes[key].isExpanded())
			{
				allCollapseFlag++;
			}
		}
		childNodes=null; delete childNodes;
 		if (allCollapseFlag>2)
		{
			document.getElementById('exx').innerHTML='Collapse all';
		}
		else
		{
			document.getElementById('exx').innerHTML='Expand all';
		}
	},
	setSessionItems:function(expanedPane,nodeId,isLeafNode,nodeMode,lastAccessedNodeId)
	{
 		sessionStorage.setItem("expanedPane", expanedPane);
 		sessionStorage.setItem("nodeId", nodeId);
		sessionStorage.setItem("isLeafNode", isLeafNode);
		sessionStorage.setItem("nodeMode", nodeMode);
		if(!Ext.isEmpty(lastAccessedNodeId))
		sessionStorage.setItem("lastAccessedNodeId", lastAccessedNodeId);
	},
    ajaxFunctionNodeUpdate: function(node)
    {

		var isBaseNode = false;
		var unparsedId = node.get('id');
		var node_title = node.get('text');
		var parent_node = node.parentNode;
		if(parent_node!=null && parent_node!='undefined'){
			var baseNode = parent_node.parentNode;
			if (!Ext.isEmpty(baseNode))
			{
				if(baseNode.parentNode ==null || baseNode.get('text')=='ReportFunction')
					isBaseNode = true;
			} 
		}

        var parentNode_title = parent_node.get('text');
        var parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
        if (parsedId == "" || parsedId == null)
        {
            return;
        }
        if (isBaseNode==false && parentNode_title != null && parentNode_title !="undefined" && parentNode_title!='ReportFunction')
        {
			/*if (parentNode_title.toLowerCase()=='virtual desktop insight')
			  node_title = parentNode_title+" - "+node_title;
 			else if (parentNode_title.toLowerCase()!='datastores')
              node_title = parentNode_title+" "+node_title;*/

				if (parentNode_title.toLowerCase()=='executive summary')
					node_title = parentNode_title+"  "+node_title;
			   else if (parentNode_title.toLowerCase()=='system capacity analysis')
					node_title = parentNode_title+"  "+node_title;
			   else if (parentNode_title.toLowerCase()!='datastores')
					node_title = parentNode_title+" - "+node_title;
        }
		if (node_title != null && node_title !="undefined")
		{
			if (node_title.toLowerCase()=='kpi metrics')
			{
				node_title = 'Comparison Reports - '+node_title;
			}
			else if (node_title.toLowerCase()=='components')
			{
				node_title='Comparison Reports - Components';
			}
			else if (node_title.toLowerCase()=='tests')
			{
				node_title='Comparison Reports - Tests';
			}
			else if (node_title=='Event Log Analysis')
			{
				node_title='Consolidated '+node_title;
			}
		} 
        if (parsedId.indexOf('?') > -1)
        {
            parsedId += '&er_RmDispName=' + node_title;
        }
        else
        {
            parsedId += '?er_RmDispName=' + node_title;
        }
				 //console.log('parsedId from function node before  ---->' + parsedId);
		initLdgMask.show();
        Ext.Ajax.request(
		{
			url: '/final/reporter/TimeLineSave.jsp?method=checkLegend',
			scope: this,
			async: false,
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				//console.log("jsontext  -466 in rep cntrller--->"+jsontext);
				if ((!Ext.isEmpty(jsonData)))
				{

					if (jsonData.hasOwnProperty('failure'))
					{
						alert(jsonData.failure);
					}
					else
					{
						if (jsonData.hasOwnProperty('isLegendEnabled'))
						{
							if (parsedId.indexOf('?')>-1)
							{
								parsedId += "&isLegendEnabled=" + jsonData.isLegendEnabled;
							}
							else
							{
								parsedId += "?isLegendEnabled=" + jsonData.isLegendEnabled;
							}
						}
					}
                }
				initLdgMask.hide();
			},
			failure: function(err)
			{
				console.log('Error occured in TimeLineSave.jsp page');
			}
		});

		 //console.log('parsedId from function node' + parsedId);
		sessionStorage.setItem("settingsCollapse", true);
		this.setFrameSource(parsedId);

     },
    loadComboField: function(comboProperty, comoboId, comboLabelProperty, comboSelectedProperty, parentJsonProperty) {

        var obj = Ext.getCmp(comoboId);
        if (parentJsonProperty.combo.hasOwnProperty(comboProperty))
        {
            var rawData = parentJsonProperty.combo[comboProperty];
            obj.getStore().loadRawData(rawData);
            if (parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
            {
                var selection = parentJsonProperty.selectedFields[comboSelectedProperty];
                obj.setValue(selection);
            }
            else
            {
                obj.setValue(rawData[0].valueField);
            }

            if (parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
            {
                if (comoboId == 'rmComponent')
                {
                    var componentLabelObj = Ext.getCmp('rmComponentLabel');
                    var multiSelectComboObj = Ext.getCmp('multiSelectPanel');
                    componentLabelObj.setText(parentJsonProperty.displayFields[comboLabelProperty]);
                    multiSelectComboObj.show();
                }
                else
                {
                    obj.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
                    obj.show();
                }
            }
        }
        else
        {
            if (comoboId == 'rmComponent')
            {
                var multiSelectComboObj = Ext.getCmp('multiSelectPanel');
                multiSelectComboObj.hide();
            }
            else
            {
                obj.hide();
            }
        }
    },
    loadDefaultTimeLine: function()
    {	// alert('loadDefaultTimeLine');
        var store = Ext.StoreMgr.lookup('defaultTimeLineStore');
        Ext.getCmp('er_timeline').setValue(store.getAt(0).get('defaultTimeLine'));
        Ext.getCmp('er_sthr').setValue(store.getAt(0).get('defaultStartHour'));
        Ext.getCmp('er_endhr').setValue(store.getAt(0).get('defaultEndHour'));
        Ext.getCmp('er_stdate').setValue(new Date());
        Ext.getCmp('er_enddate').setValue(new Date(new Date().getTime() + 24 * 60 * 60 * 1000));
        appConstants.rmTimelineMinFrom = store.getAt(0).get('defaultStartMin');
        appConstants.rmTimelineMinTo = store.getAt(0).get('defaultEndMin');
        //alert("defaultStartMin"+appConstants.rmTimelineMinFrom);
        //alert("defaultEndMin"+appConstants.rmTimelineMinTo);

    },
    loadSessionTimeLine: function(jsonData)
    {	  //alert('loadSessionTimeLine');
        Ext.getCmp('er_timeline').setValue(jsonData.rmTimeline);
        Ext.getCmp('er_sthr').setValue(jsonData.rmTimelineHrFrom);
        Ext.getCmp('er_endhr').setValue(jsonData.rmTimelineHRTO);
        Ext.getCmp('er_stdate').setValue(jsonData.rmTimelineStartDate);
        Ext.getCmp('er_enddate').setValue(jsonData.rmTimelineEndDate);
        appConstants.rmTimelineMinFrom = jsonData.rmTimelineMinFrom;
        appConstants.rmTimelineMinTo = jsonData.rmTimelineMinTo;
    },
    updateTimeLineFields: function(isCompTypeEnable)
    {
        //updating component,componenttype,timeline in report menu settings
		var ajaxDataConnection = getAjaxDataConnection();//this method is implemented in timelinesave.js under utilities
        if (!Ext.isEmpty(appConstants.rmComponentType))
        {
            var param = 'method=get&rmComponentType=' + appConstants.rmComponentType;

            //alert("updateTimeLineFieldsparam----"+param);
            ajaxDataConnection.request
                    ({
                        url: '/final/reporter/TimeLineSave.jsp',
                        params: param,
                        method: 'GET',
                        scope: this,
                        success: function(response)
                        {

                            var jsontext = response.responseText;
                            var jsonData = Ext.decode(jsontext);
                            if ((!Ext.isEmpty(jsonData)))
                            {
                                if (isCompTypeEnable == true)
                                {
                                    Ext.getCmp('rmComponentType').hide();
                                }

                                this.loadComboField('componentCombo', 'rmComponent', 'componentComboLabel', 'selectedComponentCombo', jsonData);
                                rmComponentJson=jsonData.combo.componentCombo;
								if (jsonData.hasOwnProperty('mapFound'))
                                {
                                    //alert('mapFound for '+jsonData.rmComponentType);
                                    var mapFound = jsonData.mapFound;
                                    this.loadSessionTimeLine(mapFound);
                                }
                                if (jsonData.hasOwnProperty('noMapFound'))
                                {
                                    console.log(jsonData.noMapFound);
                                    this.loadDefaultTimeLine();
                                }
                                if (jsonData.hasOwnProperty('failure'))
                                {
                                    alert(jsonData.failure);
                                }
                            }
                        },
                        failure: function(err)
                        {
                            console.log('Error occured in TimeLineSave.jsp page');
                        }
                    });
        }
        else
        {	 //send old href id to load app
            //this.updatedTimeLineAjax(anchorHref);
            //alert('no comp type');
            var param = 'method=getCompType&rmOption=' + rmOption + '&rmSite=' + rmSite;

            //alert("updateTimeLineFieldsparam----"+param);
            ajaxDataConnection.request
                    ({
                        url: '/final/reporter/TimeLineSave.jsp',
                        params: param,
                        method: 'GET',
                        scope: this,
                        success: function(response)
                        {

                            var jsontext = response.responseText;
                            var jsonData = Ext.decode(jsontext);
                            if ((!Ext.isEmpty(jsonData)))
                            {
                                if (jsonData.hasOwnProperty('combo'))
                                {
                                    this.loadComboField('componentTypeCombo', 'rmComponentType', 'componentTypeComboLabel', '', jsonData);
                                    this.loadComboField('componentCombo', 'rmComponent', 'componentComboLabel', 'selectedComponentCombo', jsonData);
								    this.loadDefaultTimeLine();
 									rmComponentJson=jsonData.combo.componentCombo;
								}
                            }

                        },
                        failure: function(err)
                        {
                           console.log('Error occured in TimeLineSave.jsp page');
                        }
                    });
        }
    },
    updateRMTimeLine: function(anchorHref)
    {
        //update rmtimeline and rmcomponenttype in each url app (contentPanel id's)

       // alert("before---updateRMTimeLine------" + anchorHref);
        var gCompIndex;
        var gCompStr;
        var tCompIndex = anchorHref.indexOf('treeCompType');
        var erCompIndex = anchorHref.indexOf('er_comptype');
        if (tCompIndex > 0)
        {
            gCompIndex = tCompIndex;
            gCompStr = 'treeCompType';
        }
        else if (erCompIndex > 0)
        {
            gCompIndex = erCompIndex;
            gCompStr = 'er_comptype';
        }
        else
        {
            gCompIndex = -1; //or can keep -1
        }
        if (gCompIndex > -1)
        {
            //alert('>0');
            appConstants.rmComponentType = anchorHref.substring(gCompIndex + gCompStr.length + 1, anchorHref.length);

            var param = 'method=get&rmComponentType=' + appConstants.rmComponentType;
            if (Ext.get('rmComponent') != null)
            {
                var compArray = Ext.getCmp("rmComponent").getValue();
                for (var k = 0; compArray.length > k; k++)
                {
                    param += "&rmComponent=" + compArray[k];
                }
            }

            //alert("contenpanel param----" + param);
            //alert("redirecting to TimeLineSave.jsp");
            this.sendRequestFOrUpdateRMTimeLine(param, anchorHref);
        }
        else
        {	 //send old href id to load app
            //alert('old');
            var rmct = Ext.getCmp('rmComponentType').getValue();
            var rmc = Ext.getCmp('rmComponent').getValue();
            if (rmct != '-1' && rmc != '-1')
            {
                //load updated RMtimeline app
                var param = 'method=get&rmComponentType=' + rmct;
                for (var k = 0; rmc.length > k; k++)
                {
                    param += "&rmComponent=" + rmc[k];
                }
                //alert("component & component type selected for "+rmOption+" in "+rmSite);
                //alert("contenpanel param for "+rmOption+" in "+rmSite+"----"+param);
                //alert("redirecting to TimeLineSave.jsp");
                this.sendRequestFOrUpdateRMTimeLine(param, anchorHref);

            }
            else
            {
                //load default app
                // alert("no component type so redirecting to app with default timeline");
                this.loadUpdatedTimeLineApp(anchorHref);
            }

        }
    },
    updateRMTimeLine:function(anchorHref, anchorDispName)
    {
		initLdgMask.show();
        Ext.Ajax.request(
		{
			url: '/final/reporter/TimeLineSave.jsp?method=checkLegend&reportName='+reportName,
			scope: this,
			async: false,
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if ((!Ext.isEmpty(jsonData)))
				{

					if (jsonData.hasOwnProperty('failure'))
					{
						alert(jsonData.failure);
					}
					else
					{
						if (jsonData.hasOwnProperty('isLegendEnabled'))
						{
							if (anchorHref.indexOf('?')>-1)
							{
								anchorHref += "&isLegendEnabled=" + jsonData.isLegendEnabled;
							}
							else
							{
								anchorHref += "?isLegendEnabled=" + jsonData.isLegendEnabled;
							}
						}
						if (jsonData.hasOwnProperty('isSubmitOnLoadEnabled'))
						{
							 appConstants.isForceSubmit = jsonData.isSubmitOnLoadEnabled;
						}
					}
               			}
				initLdgMask.hide();
			},
			failure: function(err)
			{
				console.log('Error occured in TimeLineSave.jsp page');
			}
		});

        //update rmtimeline and rmcomponenttype in each url app (contentPanel id's)

        //alert("before---2nd funtion------" + anchorHref);
        //alert("before---2nd funtion------" + anchorDispName);
        var gCompIndex;
        var gCompStr;
        var tCompIndex = anchorHref.indexOf('treeCompType');
        var erCompIndex = anchorHref.indexOf('er_comptype');
        var cmprCompIndex = anchorHref.indexOf('compareCompType');
	isCompareReport = false;
		if( anchorHref.indexOf('er_RmSelections')>0 && (anchorHref.indexOf('ErCompareTest.jsp?')>0 || anchorHref.indexOf('reportFor=CompareGraph')>0)){
			isCompareReport = true;
		}
        if (tCompIndex > 0)
        {
            gCompIndex = tCompIndex;
            gCompStr = 'treeCompType';
        }
        else if (erCompIndex > 0)
        {
            gCompIndex = erCompIndex;
            gCompStr = 'er_comptype';
        }
        else if (cmprCompIndex > 0)
        {
            gCompIndex = cmprCompIndex;
            gCompStr = 'compareCompType';
        }
        else
        {
            gCompIndex = -1; //or can keep -1
        }
        if (gCompIndex > -1)
        {
            appConstants.rmComponentType = anchorHref.substring(gCompIndex + gCompStr.length + 1, anchorHref.length);

            var param = 'method=get&rmComponentType=' + appConstants.rmComponentType;
            if (Ext.get('rmComponent') != null)
            {
                var compArray = new Array();
				compArray=Ext.getCmp("rmComponent").getValue();
                for (var k = 0; compArray.length > k; k++)
                {
                    param += "&rmComponent=" + compArray[k];
                }
            }
	    if(isCompareReport == 'true' || isCompareReport==true){
		param += "&isCompareReport=" + isCompareReport;
		if(anchorHref.indexOf('er_RmSelections')>0){
			var rmSelections = anchorHref.substring(anchorHref.indexOf('er_RmSelections') + 'er_RmSelections'.length + 1);
			param += "&rm_content=" + rmSelections;
		}
	    }
            //alert("contenpanel param----" + param);
            //alert("redirecting to TimeLineSave.jsp");
            this.sendRequestFOrUpdateRMTimeLine(param, anchorHref, anchorDispName);
        }
        else
        {	 //send old href id to load app

            var rmct = Ext.getCmp('rmComponentType').getValue();
            var rmc = Ext.getCmp('rmComponent').getValue();
            if (rmct != '-1' && rmc != '-1')
            {
                //load updated RMtimeline app
                var param = 'method=get&rmComponentType=' + rmct;
                for (var k = 0; rmc.length > k; k++)
                {
                    param += "&rmComponent=" + rmc[k];
                }
                //alert("component & component type selected for "+rmOption+" in "+rmSite);
			if(isCompareReport == 'true' || isCompareReport==true){
				param += "&isCompareReport=" + isCompareReport;
				if(anchorHref.indexOf('er_RmSelections')>0){
					var rmSelections = anchorHref.substring(anchorHref.indexOf('er_RmSelections') + 'er_RmSelections'.length + 1);
					param += "&rm_content=" + rmSelections;
				}
			}
                //alert("contenpanel param for " + rmOption + " in " + rmSite + "----" + param);
                //alert("redirecting to TimeLineSave.jsp");
                this.sendRequestFOrUpdateRMTimeLine(param, anchorHref, anchorDispName);

            }
            else
            {
                //load default app
                // alert("no component type so redirecting to app with default timeline");
                //alert("it calls --loadUpdatedTimeLineApp->" + anchorDispName);
                this.loadUpdatedTimeLineApp(anchorHref, anchorDispName);
            }

        }
    },
    sendRequestFOrUpdateRMTimeLine: function(param, anchorHref, anchorDispName)
    {
		 	//issue in thissssssssssssssssssssssssssssssssssssss
		initLdgMask.show();
        Ext.Ajax.request
                ({
                    url: '/final/reporter/TimeLineSave.jsp',
                    params: param,
                    method: 'GET',
                    scope: this,
                    success: function(response)
                    {

                        var jsontext = response.responseText;
                        var jsonData = Ext.decode(jsontext);
                        if ((!Ext.isEmpty(jsonData)))
                        {

                            if (jsonData.hasOwnProperty('failure'))
                            {
                                alert(jsonData.failure);
                            }
                            else
                            {
                                if (jsonData.hasOwnProperty('selectedFields'))
                                {
                                   	if (anchorHref.indexOf('?')>-1)
									{
										anchorHref += "&rmComponentType=" + jsonData.rmComponentType;
									}
									else
									{
										anchorHref += "?rmComponentType=" + jsonData.rmComponentType;
									}
									//alert('rmComponentType found for '+jsonData.rmComponentType);

                                }
                                if (jsonData.hasOwnProperty('selectedFields'))
                                {
                                    //alert('selectedFields found for '+jsonData.selectedFields.selectedComponentCombo);
                                   	if (anchorHref.indexOf('?')>-1)
									{
										anchorHref += "&rmComponent=" + jsonData.selectedFields.selectedComponentCombo;
									}
									else
									{
									   anchorHref += "?rmComponent=" + jsonData.selectedFields.selectedComponentCombo;
									}

                                }
                                if (jsonData.hasOwnProperty('mapFound'))
                                {
                                    //alert('timeline mapFound for '+jsonData.rmComponentType);
                                    var mapFound = jsonData.mapFound;
                                    for (var key in mapFound) {
										if (anchorHref.indexOf('?')>-1)
										{
											anchorHref += "&" + key + "=" + mapFound[key];
										}
										else
										{
											anchorHref += "?" + key + "=" + mapFound[key];
										}
                                    }
                                }
                                if (jsonData.hasOwnProperty('noMapFound'))
                                {
                                    console.log(jsonData.noMapFound);
                                }
                                if (jsonData.hasOwnProperty('urlParamsForCompare'))
                                {
					anchorHref += jsonData.urlParamsForCompare;
                                }
                                this.loadUpdatedTimeLineApp(anchorHref, anchorDispName);
                            }
                        }
						initLdgMask.hide();
                    },
                    failure: function(err)
                    {
                        console.log('Error occured in TimeLineSave.jsp page');
                    }
                });
    },
    rmComponentTypeOnchange: function()
    {

        appConstants.rmComponentType = Ext.getCmp('rmComponentType').getValue();
        //alert("rmComponentType updated--------------"+appConstants.rmComponentType);
        this.updateTimeLineFields(false);

    },
    updatePublicComponentType: function(nodeId, node)
    {
        //alert("nodeId----"+nodeId);
        var gCompIndex;
        var gCompStr;
        var compIndex = nodeId.indexOf('compType');
        if (compIndex > 0)
        {
            gCompIndex = compIndex;
            gCompStr = 'compType';
        }
        /*else if(erCompIndex>0)
         {
         gCompIndex=erCompIndex;
         gCompStr='er_comptype';
         } */
        else
        {
            gCompIndex = 0; //or can keep -1
        }
        if (gCompIndex > 0)
        {
            rmOption = '';
            rmSite = '';
            appConstants.rmComponentType = nodeId.substring(gCompIndex + gCompStr.length + 1, nodeId.length);
            // alert("appConstants.rmComponentType found--------------"+appConstants.rmComponentType);
        }
        else
        {
            appConstants.rmComponentType = '';
            //alert('no appConstants.rmComponentType found -- so updating rmOption and rmSite ');
            if ((nodeId.indexOf('SegmentTemplate') > -1) && (nodeId.indexOf('er_segment') > -1))
            {
                rmOption = 'segment';
                rmSite = node.get('text');
            }
            else if ((nodeId.indexOf('ServiceTemplate') > -1) && (nodeId.indexOf('er_service') > -1))
            {
                rmOption = 'service';
                rmSite = node.get('text');
            }
            else if ((nodeId.indexOf('ZoneTemplate') > -1) && (nodeId.indexOf('er_zone') > -1))
            {
                rmOption = 'zone';
                rmSite = node.get('text');
            }
            else
            {
                rmOption = '';
                rmSite = '';
            }
			appConstants.rmDataFrom=rmSite;
        }
    },
    ajaxNodeUpdate: function(node)
    {
        var self = this;
        appConstants.isForceSubmit = '';
        var unparsedId = node.get('id');
        var parsedId;
        if (unparsedId.indexOf("Mylink_") > -1)
        {
            parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
        }
        else
        {
            parsedId = unparsedId;
        }
        if (parsedId == "" || parsedId == null)
        {
            return;
        }
        //alert('parsedId----'+parsedId);
		sessionStorage.setItem("settingsCollapse", true);
        self.updatePublicComponentType(parsedId, node);
		initLdgMask.show();
        Ext.Ajax.request({
            url: parsedId,
            method: 'GET',
            scope: self,
            success: function(response)
            {
                self.fillCollapsiblePanel(response, parsedId);
				initLdgMask.hide();
            },
            failure: function(err)
            {
                Ext.MessageBox.alert('Error occured in jsp page', 'Please try again!');
            }
        });
    },
    getItemTreeClick: function(view, node) {
		var self = this;
        if (node.isLeaf()) {
            Ext.Msg.alert('Clicked on a Tree Node',
                    'Node id: ' + node.get('id') + '\n' +
                    'Node Text: ' + node.get('text') + '\n' +
                    'Parent Node id: ' + node.get('parentId') + '\n' +
                    'Is it a leaf?: ' + node.get('leaf') + '\n' +
                    'No of Children: ' + node.childNodes.length + '\n' +
                    'Path of Node:' + node.getPath() + '\n'
                    );
			initLdgMask.show();
            Ext.Ajax.request({
                url: node.get('id'),
                method: 'GET',
                scope: self,
                success: function(response)
                {
                    self.fillCollapsiblePanel(response, node.get('id'));
					initLdgMask.hide();
                },
                failure: function(err)
                {
                    Ext.MessageBox.alert('Error occured in jsp page', 'Please try again!');
                }

            });
        } else if (node.isExpanded()) {
            node.collapse();
            Ext.Msg.alert('Clicked on a Tree Node',
                    'Node id: ' + node.get('id') + '\n' +
                    'Node Text: ' + node.get('text') + '\n' +
                    'Parent Node id: ' + node.get('parentId') + '\n' +
                    'Is it a leaf?: ' + node.get('leaf') + '\n' +
                    'No of Children: ' + node.childNodes.length + '\n' +
                    'Path of Node:' + node.getPath()
                    );
            this.singleNodeUpdate_centerRegion(node);

        } else {
            node.expand();
            Ext.Msg.alert('Clicked on a Tree Node',
                    'Node id: ' + node.get('id') + '\n' +
                    'Node Text: ' + node.get('text') + '\n' +
                    'Parent Node id: ' + node.get('parentId') + '\n' +
                    'Is it a leaf?: ' + node.get('leaf') + '\n' +
                    'No of Children: ' + node.childNodes.length + '\n' +
                    'Path of Node:' + node.getPath()
                    );
            this.singleNodeUpdate_centerRegion(node);
        }
    },
    fillCollapsiblePanel: function(response, nodeId)
    {
		Ext.getCmp('centerRegion').removeAll();
		if(!Ext.isEmpty(Ext.getCmp('cpan'))){
			Ext.getCmp('cpan').removeAll();
		}
		this.collapsiblePaneCount=0;
        treeNodeTraverse = nodeId;
        var count = 0;
        var rootJsonText = response.responseText;
        var rootJsonObject = Ext.decode(rootJsonText);
        var collapsiblepanel_array = new Array();
		//for setting icon classes in collapsible panels
		var eventsAlertsCls='iconAlarm';
		var systemReportsCls='iconSystemReport';
		var capacityPlanningCls='iconCapacityPlanning';
		var componentCls='iconApplicationReport';
		var performanceCls='iconApplicationReport';
		var setClass;
		var setMargin;

        if (rootJsonObject.hasOwnProperty('favourites'))
        {
            count++;
            var sval=sessionStorage.getItem('collapsiblePanelMode');
 			var svalBool;
			if(sval== undefined || sval==null)
			{
				svalBool=true;

			}else
			{
				svalBool= eval(sval);

			}
            var favhtml = this.getTableNew(rootJsonObject.favourites);
            collapsiblepanel_array.push(
                    {
                        xtype: 'panel',
                        layout: 'fit',
                        title: 'Favorites',
                        collapsible: true,
                        collapsed: true,
                        border: false,
						cls:'reporterContentPanelBody',
                        iconCls: 'iconFavorite',
                        html: favhtml,
                        listeners: {
                            afterrender: function(panel)
                            {
								panel.header.el.setStyle('cursor','pointer');
								panel.header.el.on('click', function()
                                {
                                    if (panel.collapsed) {
                                        panel.expand();
                                    }
                                    else {
                                        panel.collapse();
                                    }
                                });
                            }
                        }
                    });
        }
        for (var i = 0; i < rootJsonObject.panel_title.length; i++)
        {
            if (rootJsonObject.hasOwnProperty(rootJsonObject.panel_title[i].text))
            {
                count++;
                var cotentHtml = this.getTableNew(rootJsonObject[rootJsonObject.panel_title[i].text]);
                if (rootJsonObject.panel_title[i].text.toLowerCase().indexOf('events') > -1 && rootJsonObject.panel_title[i].text.toLowerCase().indexOf('alerts') > -1)
                {
                    setClass = eventsAlertsCls;
                }
                else if (rootJsonObject.panel_title[i].text.toLowerCase().indexOf('system') > -1)
                {
                    setClass = systemReportsCls;
                }
                else if (rootJsonObject.panel_title[i].text.toLowerCase().indexOf('capacity') > -1)
                {
                    setClass = capacityPlanningCls;
                }
                else if (rootJsonObject.panel_title[i].text.toLowerCase().indexOf('performance') > -1)
                {
                    setClass = performanceCls;
                }
                else //rootJsonObject.panel_title[i].text.toLowerCase().indexOf('windows')>-1
                {
                    setClass = componentCls;
                }
            }
            else
            {
                continue;
            }

			var xpandId=3;
			if(rootJsonObject.panel_title.length<4)
				xpandId=rootJsonObject.panel_title.length-1;
			
            if (i == rootJsonObject.panel_title.length - 1)
                setMargin = '0 10 6 10';
            else
                setMargin = '0 10 6 10';
			var sval=sessionStorage.getItem('collapsiblePanelMode');

			var svalBool;


		  if (i == xpandId)
		  {
				if(sval== undefined || sval==null)
				{
					svalBool=false;

				}else
				{
					svalBool= eval(sval);

				}
                collapsiblepanel_array.push(
                        {
                            xtype: 'panel',
                            layout: 'fit',
                            title: rootJsonObject.panel_title[i].text,
                            collapsible: true,
							cls:'reporterContentPanelBody',
							collapsed:false,
                              border: false,
                            iconCls: setClass,
                            html: cotentHtml,
                            listeners: {
                                afterrender: function(panel)
                                {
                                    panel.header.el.setStyle('cursor', 'pointer');
                                    panel.header.el.on('click', function()
                                    {
                                        if (panel.collapsed) {
                                            panel.expand();
                                        }
                                        else {
                                            panel.collapse();
                                        }
                                    });
                                }
                            }
                        });
            }
            else
            {
			if(sval== undefined || sval==null)
			{
 				svalBool=true;

			}
			else
			{
					svalBool=eval(sval);

			}
                collapsiblepanel_array.push(
                        {
                            xtype: 'panel',
                            layout: 'fit',
                            title: rootJsonObject.panel_title[i].text,
                            id: 'collapsePan' + i,
                            collapsible: true,
							cls:'reporterContentPanelBody',
                            border: false,
                            collapsed: true,
                            iconCls: setClass,
                            html: cotentHtml,
                            listeners: {
                                afterrender: function(panel)
                                {
                                    panel.header.el.setStyle('cursor', 'pointer');
                                    panel.header.el.on('click', function()
                                    {
                                        if (panel.collapsed) {
                                            panel.expand();
                                        }
                                        else {
                                            panel.collapse();
                                        }
                                    });
                                }
                            }

                        });
            }
        }
       // var contentpanel = Ext.widget('contentpanel');
		reportName=rootJsonObject.report_type;
		var contentpanel = new reportermenudashboard.view.ContentPanel();
		if(rootJsonObject.report_for!=null && rootJsonObject.report_for.indexOf("Common")>-1)
		{
			contentpanel.setTitle(rootJsonObject.report_for);
		}
		else
			contentpanel.setTitle(ReportsFor+' ' + rootJsonObject.report_for);
        if (count > 0)
        {
            contentpanel.add(collapsiblepanel_array);
        }
        else
        {
            contentpanel.update('<p align="center">No match found</p>');
        }
		//contentpanel.doLayout();
		
        
		Ext.defer(function(){ Ext.getCmp('centerRegion').add(contentpanel);},500);
       
		
        Ext.getCmp('centerRegion').doComponentLayout();
    },
	fillSearchInContentPanel: function(response, parentObj)
	{
		//var controller = appConstants.appObj.getController('ReporterController');
		var count = 0;
		var rootJsonText = response.responseText;
		var rootJsonObject = Ext.decode(rootJsonText);
		var collapsiblepanel_array = new Array();
		//for setting icon classes in collapsible panels
		var eventsAlertsCls='iconAlarm';
		var systemReportsCls='iconSystemReport';
		var capacityPlanningCls='iconCapacityPlanning';
		var componentCls='iconApplicationReport';
		var performanceCls='iconApplicationReport';
		var setClass;
		var setMargin;
		var cotentHtml;
		var c=0;
		for (var i = 0; i < rootJsonObject.panel_title.length; i++)
		{
			if (rootJsonObject.hasOwnProperty(rootJsonObject.panel_title[i].text))
			{
				//find the original panel count
				 c++;
			}
		}
		if (rootJsonObject.hasOwnProperty('favourites'))
		{
			if(c==0)
				 setMargin = '0 10 6 10';
			else
				setMargin = '0 10 6 10';

			count++;
			var div_id = 'rowl';
			var favhtml = this.getTableNew(rootJsonObject.favourites);
			collapsiblepanel_array.push(
					{
						xtype: 'panel',
						layout: 'fit',
						title: 'Favorites',
						collapsible: true,
						collapsed: false,
						cls:'reporterContentPanelBody',
						border: false,
						iconCls: 'iconFavorite',
						html: favhtml,
						listeners: {
							afterrender: function(panel)
							{
								panel.header.el.on('click', function()
								{
									if (panel.collapsed) {
										panel.expand();
									}
									else {
										panel.collapse();
									}
								});
							}
						}
					});
		}

		for (var i = 0; i < rootJsonObject.panel_title.length; i++)
		{
			if (rootJsonObject.hasOwnProperty(rootJsonObject.panel_title[i].text))
			{
				count++;
				cotentHtml = this.getTableNew(rootJsonObject[rootJsonObject.panel_title[i].text]);
				if(rootJsonObject.panel_title[i].text.toLowerCase().indexOf('events')>-1 && rootJsonObject.panel_title[i].text.toLowerCase().indexOf('alerts')>-1)
				{
					setClass=eventsAlertsCls;
				}
				else if(rootJsonObject.panel_title[i].text.toLowerCase().indexOf('system')>-1)
				{
					setClass=systemReportsCls;
				}
				else if(rootJsonObject.panel_title[i].text.toLowerCase().indexOf('capacity')>-1)
				{
					setClass=capacityPlanningCls;
				}
				else if(rootJsonObject.panel_title[i].text.toLowerCase().indexOf('performance')>-1)
				{
					setClass=performanceCls;
				}
				else //rootJsonObject.panel_title[i].text.toLowerCase().indexOf('windows')>-1
				{
					 setClass=componentCls;	   //default class
				}
			}
			else
			{
				continue;
			}
			//alert("i=="+i+"c=="+c);

			if (i == 2)
			{
				collapsiblepanel_array.push(
						{
							xtype: 'panel',
							layout: 'fit',
							title: rootJsonObject.panel_title[i].text,
							collapsible: true,
							collapsed: false,
							cls:'reporterContentPanelBody',
							border: false,
							iconCls:setClass,
							html: cotentHtml,
							listeners: {
								afterrender: function(panel)
								{
									panel.header.el.setStyle('cursor','pointer');
									panel.header.el.on('click', function()
									{
										if (panel.collapsed) {
											panel.expand();
										}
										else {
											panel.collapse();
										}
									});
								}
							}
						});
			}
			else
			{
				collapsiblepanel_array.push(
						{
							xtype: 'panel',
							layout: 'fit',
							title: rootJsonObject.panel_title[i].text,
							id: 'collapsePan' + i,
							collapsible: true,
							cls:'reporterContentPanelBody',
							border: false,
							collapsed: false,
							iconCls:setClass,
							html: cotentHtml,
							listeners: {
								afterrender: function(panel)
								{
									panel.header.el.setStyle('cursor','pointer');
									panel.header.el.on('click', function()
									{
										if (panel.collapsed) {
											panel.expand();
										}
										else {
											panel.collapse();
										}
									});
								}
							}
						});
			}
		}
		parentObj.removeAll();
		if (count > 0)
		{
			parentObj.add(collapsiblepanel_array);
		}
		else
		{
			parentObj.add(this.getNoRecordsPanel('','No match found for the current search'));
		}
	},
    getTableNew: function(jsonArray)
    {
		var cpc=this.collapsiblePaneCount;
        var j = 0;
		var isChildExist;
		var parenthtml = '';
		if (Ext.isEmpty(jsonArray[j].children))
		{
			parenthtml +='<div class="reporterAccordionDiv">';
			parenthtml += '<table  style="cursor:pointer;" class="reporterAccordionTable"><col width="50%"><col width="50%">';
      	}
		else
		{
			isChildExist=true;	// if immediate child exist at first node itself
		}

		while (j < jsonArray.length)
        {
             if (jsonArray[j].children == null && jsonArray[j + 1] == null)
            {
 				isChildExist=false;
                parenthtml += '<tr>';
				parenthtml += '<td id="td_'+cpc+'_'+j+'" colspan="2" >';
                parenthtml += '<div class="reporterTreeLink">';
				parenthtml += '<div class="iconBgReport iconPadding" style="float:left;"></div>';
				parenthtml += '<div style="margin-left:20px;" class="textPadding"><a href="javascript:void(0)" id="' + jsonArray[j].id + '">' + jsonArray[j].text + '</a></div>';
				parenthtml += '<div class="iconComponentDelete" id="div_'+cpc+'_'+j+'" style="float:left;margin-left:20px;display:none;"></div>';
                parenthtml += '</div>';
                parenthtml += '</td>';
                parenthtml += '</tr>';
                j++;
            }
            else if (jsonArray[j].children == null && jsonArray[j + 1].children == null)
            {
 				isChildExist=false;
                parenthtml += '<tr>';
				parenthtml += '<td id="td_'+cpc+'_'+j+'" >';
                parenthtml += '<div class="reporterTreeLink">';
                parenthtml += '<div class="iconBgReport iconPadding" style="float:left;"></div>';
				parenthtml += '<div style="margin-left:20px;" class="textPadding"> <a href="javascript:void(0)" id="' + jsonArray[j].id + '">' + jsonArray[j].text + '</a></div>';
				parenthtml += '<div class="iconComponentDelete" id="div_'+cpc+'_'+j+'" style="float:left;margin-left:20px;display:none;"></div>';
                parenthtml += '</div>';
                parenthtml += '</td>';
				parenthtml += '<td id="td_'+cpc+'_'+(j+1)+'" >';
                parenthtml += '<div class="reporterTreeLink">';
				parenthtml += '<div class="iconBgReport iconPadding" style="float:left;"></div>';
				parenthtml += '<div style="margin-left:20px;" class="textPadding"><a href="javascript:void(0)" id="' + jsonArray[j + 1].id + '">' + jsonArray[j + 1].text + '</a></div>';
				parenthtml += '<div class="iconComponentDelete" id="div_'+cpc+'_'+(j+1)+'" style="float:left;margin-left:20px;display:none;"></div>';
                parenthtml += '</div>';
                parenthtml += '</td>';
                parenthtml += '</tr>';
                j += 2;
            }
            else if (jsonArray[j].children == null)
            {
 				isChildExist=false;
                parenthtml += '<tr >';
				parenthtml += '<td id="td_'+cpc+'_'+j+'" colspan="2" >';
                parenthtml += '<div class="reporterTreeLink">';
			    parenthtml += '<div class="iconBgReport iconPadding" style="float:left;"></div>';
				parenthtml += '<div style="margin-left:20px;" class="textPadding"><a href="javascript:void(0)" id="' + jsonArray[j].id + '">' + jsonArray[j].text + '</a></div>';
				parenthtml += '<div class="iconComponentDelete" id="div_'+cpc+'_'+j+'" style="float:left;margin-left:20px;display:none;"></div>';
                parenthtml += '</div>';
                parenthtml += '</td>';
                parenthtml += '</tr>';
                j++;
            }
            else
            {
				if (!isChildExist)
				{
					parenthtml += '</table>' + '</div>';
				}
				isChildExist=true;
 				if (jsonArray[j].children.length>0)
				{
 					var k = 0;
					parenthtml += '<div class="reporterAccordionDiv">';
					parenthtml += '<table style="cursor:pointer;" class="reporterAccordionTable"><col width="50%"><col width="50%">';

					parenthtml += '<tr style="cursor:default;">';
					parenthtml += '<td colspan="2" id="td_'+cpc+'_'+j+'_sub" class="innerSubHead" >';
					parenthtml += '<div class="innerTdHeaderText" >';	 //margin:0 40 0 40
					parenthtml += '<div style="float:left;">'+jsonArray[j].children[0].title+'</div>';
					parenthtml += '<div class="iconComponentDelete" id="div_'+cpc+'_'+j+'_sub" style="cursor:pointer;float:left;margin-left:20px;display:none;"></div>';
					parenthtml += '</div>';
					parenthtml += '</td>';
					parenthtml += '</tr>';
					while (k < jsonArray[j].children.length)
					{
						if ((jsonArray[j].children[k].children == null && jsonArray[j].children[k + 1] == null))
						{
							parenthtml += '<tr >';
							parenthtml += '<td id="td_'+cpc+'_'+j+'_'+k+'" colspan="2">';	//style="padding-left:40px;padding-right:40px;"
							parenthtml += '<div class="reporterTreeLink">';
							parenthtml += '<div class="iconBgReport iconPadding" style="float:left;;"></div>';
							parenthtml += '<div style="margin-left:20px;" class="textPadding"><a href="javascript:void(0)" id="' + jsonArray[j].children[k].id + '">' + jsonArray[j].children[k].text + '</a></div>';
							parenthtml += '<div class="iconComponentDelete" id="div_'+cpc+'_'+j+'_'+k+'" style="float:left;margin-left:20px;display:none;"></div>';
							parenthtml += '</div>';
							parenthtml += '</td>';
							parenthtml += '</tr>';
							k++;
						}
						else
						{
							parenthtml += '<tr >';
							parenthtml += '<td id="td_'+cpc+'_'+j+'_'+k+'" >';	  //style="padding-left:40px;"
							parenthtml += '<div class="reporterTreeLink" >';
							parenthtml += '<div class="iconBgReport iconPadding" style="float:left;"></div>';
							parenthtml += '<div style="margin-left:20px;" class="textPadding"><a href="javascript:void(0)" id="' + jsonArray[j].children[k].id + '">' + jsonArray[j].children[k].text + '</a></div>';
							parenthtml += '<div class="iconComponentDelete" id="div_'+cpc+'_'+j+'_'+k+'" style="float:left;margin-left:20px;display:none;"></div>';
							parenthtml += '</div>';
							parenthtml += '</td>';
							parenthtml += '<td id="td_'+cpc+'_'+j+'_'+(k+1)+'" class="x-grid-cell x-grid-cell-first">';	  //style="padding-right:40px;"
							parenthtml += '<div class="reporterTreeLink">';
							parenthtml += '<div class="iconBgReport iconPadding" style="float:left;"></div>';
							parenthtml += '<div style="margin-left:20px;" class="textPadding"><a href="javascript:void(0)" id="' + jsonArray[j].children[k + 1].id + '">' + jsonArray[j].children[k + 1].text + '</a></div>';
							parenthtml += '<div class="iconComponentDelete" id="div_'+cpc+'_'+j+'_'+(k+1)+'" style="float:left;margin-left:20px;display:none;"></div>';
							parenthtml += '</div>';
							parenthtml += '</td>';
							parenthtml += '</tr>';
							k += 2;
						}
					}

					parenthtml += '</table>';
					parenthtml += '</div>';
				}
                j++;
            }
        }
		if (!isChildExist)
		{
			parenthtml += '</tbody>' + '</table>' + '</div>';
        }
		this.collapsiblePaneCount++;
        return parenthtml;
    },
    getLoadUrl: function()
    {
        var loadUrl;
        if (loadKey == 'configureSchedules')
        {
            loadUrl = '/final/reporter/ErViewSchedule.jsp?cmd=View&fromNavLink=true';
        }
        else if (loadKey == 'viewSchedules')
        {
            loadUrl = '/final/servlet/com.eg.ErSavedScheduleReportC?forwardto=ErSavedScheduleReports&er_reportDate=All&er_reportType=All&op=view';
        }
        else if (loadKey == 'viewFavourites')
        {
            loadUrl = '/final/servlet/com.eg.ErFavoriteC?cmd=View&fromNavLink=true';
        }
        else if (loadKey == 'viewBackground')
        {
            loadUrl = '/final/servlet/com.eg.ErStartBackGroundReportC?fromNavLink=true&savereport=all_report&er_bgreportfrom=All Report Types&forwardto=ErBackGoundProcess&er_filterby=Report_Name';
        }
        else if (loadKey == 'home')
        {
            loadUrl = '/final/servlet/com.eg.ErControllerServlet?er_rtype=HOMEPAGE';
			if(defaultLink!=null && defaultLink!='null' && defaultLink!='')
				loadUrl = defaultLink;
        }
		else if (loadKey == 'historyofalarms' && (isOnlyVMAssigned == 'true'))
        {
            loadUrl = '/final/reporter/ErAlarmHistory.jsp?compTypeList=All&er_rtype=AlarmHistory&reporttype=operation&er_timeline=1 day&unknownState=KNOWN';
        }
		else if (loadKey == 'historyofunknowns'&& (isOnlyVMAssigned == 'true'))
        {
            loadUrl = '/final/reporter/ErAlarmHistory.jsp?compTypeList=All&er_rtype=UnknownHistory&reporttype=operation&er_timeline=1 day&unknownState=UNKNOWN';
        }
		else if (loadKey == 'uservms'&& (isOnlyVMAssigned == 'true'))
        {
            loadUrl = '/final/reporter/ErEsxGuestReport.jsp?er_timeline=1 day&er_type=Yes&ervm_disp=No&isVmReport=Yes&isUserVmReport=yes';
        }
        else if (loadKey == 'null')
        {
            loadUrl = '/final/servlet/com.eg.ErControllerServlet?er_rtype=HOMEPAGE'; //default url
			if(defaultLink!=null && defaultLink!='null' && defaultLink!='')
				loadUrl = defaultLink;
        }
	else if(loadKey == 'booklet')
	{
			loadUrl = '/final/reporter/ErShowBookletPDFList.jsp';
        }
        else
        {
            loadUrl = '';
        }
         return loadUrl;
    },
    showCenterRegion_loadDashBoard: function(loadUrl)
    {
		this.setFrameSource(loadUrl);
    },
	refreshCenterRegion:function(unparsedId)
	{
		appConstants.isForceSubmit = '';
        var parsedId;
        if (unparsedId.indexOf("Mylink_") > -1)
        {
            parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
        }
        else
        {
            parsedId = unparsedId;
        }
        if (parsedId == "" || parsedId == null)
        {
            return;
        }
        // this.updatePublicComponentType(parsedId, node);
		initLdgMask.show();
        Ext.Ajax.request({
            url: parsedId,
            method: 'GET',
            scope: this,
            success: function(response)
            {
                this.fillCollapsiblePanel(response, parsedId);
				initLdgMask.hide();
            },
            failure: function(err)
            {
                Ext.MessageBox.alert('Error occured in jsp page', 'Please try again!');
            }
        });
	},
    afterFunctionRender: function()
    {
         var myController=this;
		 Ext.get('ex').on('click', function(event, target, options)
         {
			//alert(document.getElementById('exx').innerHTML);
			var myTree = myController.getMyReportFunctionPanel();
            var node = myTree.getRootNode();
            var toolText = document.getElementById('exx').innerHTML;

            if (toolText.toLowerCase() == 'expand all')
            {
                document.getElementById('exx').innerHTML='Collapse all';
                myTree.expandAll();
            }
            else
            {
                document.getElementById('exx').innerHTML='Expand all';
                myTree.collapseAll();
            }
        });
    },
    loadTree: function(response, myTree)
    {
        var myJsonObj = Ext.decode(response.responseText);
        var myTreeStore = myTree.getStore();
        myTreeStore.load(myJsonObj);
    },
    componentTreeLoad: function(treestore, node, records, successful, eOpts)
    {
 		if (successful)
		{
			var treepanel = this.getMyReportComponentPanel();
			this.addNoRecordFoundNode(treepanel,'No component found');
			this.refreshTreeNodes('component',treestore,treepanel);
		}
		else
		{
			console.log('Error!... Reports By Component Treestore is not loaded');
		}

		//myTree.header.addCls('block1 x-panel-header accordionHighLight');
		//this.updateCenterRegion(myTree);
    },
    serviceTreeLoad: function(treestore, node, records, successful, eOpts)
    {
 		if (successful)
		{
			var treepanel = this.getMyReportServicePanel();
			this.addNoRecordFoundNode(treepanel,'No service found');
			this.refreshTreeNodes('service',treestore,treepanel);
		}
		else
		{
			console.log('Error!... Reports By Service Treestore is not loaded');
		}

		//myTree.header.addCls('block1 x-panel-header accordionHighLight');
		//this.getGrid_seg_serv_zone(myTree);
     },
    segmentTreeLoad: function(treestore, node, records, successful, eOpts)
    {
 		if (successful)
		{
			var treepanel = this.getMyReportSegmentPanel();
			this.addNoRecordFoundNode(treepanel,'No segment found');
			this.refreshTreeNodes('segment',treestore,treepanel);
		}
		else
		{
			console.log('Error!... Reports By Segment Treestore is not loaded');
		}

   		//Ext.get('reportSegmentPanel-1017_header').addCls('block1 x-panel-header accordionHighLight');
        //this.getGrid_seg_serv_zone(myTree);
     },
    zoneTreeLoad: function(treestore, node, records, successful, eOpts)
    {
		if (successful)
		{
			var treepanel = this.getMyReportZonePanel();
			this.addNoRecordFoundNode(treepanel,'No zone found');
			this.refreshTreeNodes('zone',treestore,treepanel);
		}
		else
		{
			console.log('Error!... Reports By Zone Treestore is not loaded');
		}

		//myTree.header.el.setStyle('background','url("../images/datapanel-header.png") repeat-x');
        //myTree.header.el.setStyle('background-repeat','repeat-x');
		//myTree.header.addCls('block1 x-panel-header accordionHighLight');
		//this.getGrid_seg_serv_zone(myTree);
    },
    functionTreeLoad: function(treestore, node, records, successful, eOpts)
    {
 		if (successful)
		{			
			var treepanel = this.getMyReportFunctionPanel();
			this.addNoRecordFoundNode(treepanel,'No function found');
			this.refreshTreeNodes('function',treestore,treepanel);
			this.setTextForExpandCollpaseTool();
		}
		else
		{
			console.log('Error!... Reports By Function Treestore is not loaded');
		}

		//myTree.header.addCls('block1 x-panel-header accordionHighLight');
        //this.function_updateCenterRegion(myTree);
    },
	refreshTreeNodes:function(expandedPanel,treestore,treepanel)
	{
		var sessionPane=sessionStorage.getItem("expanedPane");
		var nodeId=sessionStorage.getItem("nodeId");		
 		if(nodeId!=null  && nodeId!='null' && loadKey == 'null' && sessionPane==expandedPanel)
		{
			var root=treepanel.getRootNode();
			//alert('entered for tab cause nodeid loadkey are null');
			var isLeafNode=sessionStorage.getItem("isLeafNode");
			var nodeMode=sessionStorage.getItem("nodeMode");
			nodeId = nodeId.substring(nodeId.indexOf("Mylink_")+7,nodeId.length);
			//console.log('nodeid------------'+nodeId);
			var nodePath=nodeId.split('|');
			var idKey="";
			//console.log('nodePath------------'+nodePath);
 			for(var key in nodePath)
			{
				//alert('entered for loop');
				var path=parseInt(nodePath[key]);
				if(idKey!="")
					idKey+="|"+path;
				else
					idKey+=path;
				var currentNode;
				for(var i=0;i<root.childNodes.length;i++)
				{
					var nde=root.childNodes[i];
					var id=nde.id;
					var idVal=id.substring(id.lastIndexOf("_")+1);
					if(idVal==idKey)
					{
						currentNode=nde;
						break;
					}
				}
			//	if(root.childNodes.length<=path)
				//	path=root.childNodes.length-1;
			//	var currentNode=root.childNodes[path];
				if (isLeafNode=='true')
				{
					//alert('if --'+nodePath[key]);
					if(key!=nodePath.length-1)
					{
						//alert('node '+nodePath[key]+'  expanding');
						currentNode.expand();
					}
					else
					{
  						//alert('node '+nodePath[key]+'  not expanding cause it is leaf and selecting this node');
 						treepanel.getSelectionModel().select(currentNode);//select node using getSelectionModel class of tree panel
						//var currentNode=treestore.getNodeById(nid); //get cuurent node
						//treepanel.fireEvent("click", currentNode); //explicitly fire click event on current node

					}
				}
				else
				{
					//alert('else--'+nodePath[key]);
					if(key!=nodePath.length-1)
					{
						//alert('node '+nodePath[key]+'  expanding');
						currentNode.expand();
					}
					else
					{
						if (nodeMode=='expand')
						{
							//alert('node '+nodePath[key]+'  expanding cause node mode is expand');
							currentNode.expand();
							treepanel.getSelectionModel().select(currentNode);
						}
						else
						{
							//alert('node '+nodePath[key]+'  collapsing cause node mode is collapse');
							currentNode.collapse();
						}
					}
				}

				root=currentNode;
			}
			 //myTree.getRootNode().findChild("text","Physical Servers",true).expand();
		}
	},
	addNoRecordFoundNode:function(treepanel,nodeText)
	{
		//this method is meant for to add no record found node to segment,service,component,zone & function panel in accordion (west region) if there is no childnodes found
		var rootNode=treepanel.getRootNode();
		if (rootNode.childNodes.length < 1)
        {
			rootNode.appendChild({text: nodeText, iconCls: 'iconInfo', leaf: true});
		}
	},
    getGrid_seg_serv_zone: function(myTree)
    {
        //this method is meant for to get grid for segment service zone when the corresponding variable or panel is clicked or expanded to load the first default report
        var rootNode = myTree.getRootNode();
        var dataArray = new Array();
        var innerTitlePane, outerTitlePane, treeVariable;
        var rootNodeText = rootNode.get('text');
		var contentClass;
        var myController = this;
		var bodyContent;
        if (rootNodeText.indexOf("Segment") > -1)
        {
            treeVariable = rootNodeText.substring(rootNodeText.indexOf("Segment"), rootNodeText.length);//+'s';
        	contentClass='segment20_GRAY';
		}
        else if (rootNodeText.indexOf("Zone") > -1)
        {
            treeVariable = rootNodeText.substring(rootNodeText.indexOf("Zone"), rootNodeText.length);//+'s';
			contentClass='zone20_GRAY';
		}
        else
        {
            treeVariable = rootNodeText.substring(rootNodeText.indexOf("Service"), rootNodeText.length);//+'s';
			contentClass='service20_GRAY';
		}

        if (rootNode.childNodes.length > 0)
        {
           	var firstEmptyNode=rootNode.childNodes[0].get('text').toLowerCase();
			if(firstEmptyNode=='no segment found' || firstEmptyNode=='no service found' || firstEmptyNode=='no zone found')
			{
				 outerTitlePane = 'No reports available for ' + treeVariable.toLowerCase();
				 innerTitlePane = 'No '+treeVariable.toLowerCase()+' found';
				 //innerTitleChildPane='';
				 //rootNode.appendChild({ text: innerTitlePane, iconCls: 'iconInfo', leaf: true });
				 bodyContent=this.getNoRecordsPanel(outerTitlePane,innerTitlePane);
			}
			else
			{
				// innerTitlePane = 'Reports available for the following ' + treeVariable.toLowerCase();
				//outerTitlePane = 'List of ' + treeVariable.toLowerCase() + ' - ';
				outerTitlePane = 'Reports By ' + treeVariable;
				innerTitlePane = 'List of ' + treeVariable.toLowerCase() + 's';
				innerTitleChildPane = 'Select a ' + treeVariable.toLowerCase() + ' to view its reports';

				for (var i = 0; i < rootNode.childNodes.length; i++)
				{
					var unparsedId = rootNode.childNodes[i].get('id');
					var parsedId;
					if (unparsedId.indexOf("Mylink_") > -1)
					{
						parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
					}
					else
					{
						parsedId = unparsedId;
					}

					var dataObj = {};
					dataObj.id = parsedId;
					dataObj.text = rootNode.childNodes[i].get('text');
					dataArray.push(dataObj);
				}
				 bodyContent = this.getGridPanel(dataArray, myController, outerTitlePane,innerTitlePane,innerTitleChildPane,contentClass);

			}

		}
        else
        {
             outerTitlePane = 'No reports available for ' + treeVariable.toLowerCase();
             innerTitlePane = 'No '+treeVariable.toLowerCase()+' found';
        	 //innerTitleChildPane='';
			 rootNode.appendChild({ text: innerTitlePane, iconCls: 'iconInfo', leaf: true });
			 bodyContent=this.getNoRecordsPanel(outerTitlePane,innerTitlePane);
		}
		Ext.getCmp('centerRegion').removeAll();
		Ext.getCmp('centerRegion').add(bodyContent);
		//Ext.getCmp('centerRegion').doLayout();

    },
    getNoRecordsPanel: function(outerTitlePane, innerTitlePane)
    {
		var noRecordPanel = {
			xtype:'container',
			flex:1,
			html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">'+innerTitlePane+'</div></td></tr></table>'
		}
        return noRecordPanel;
    },
    singleNodeUpdate_centerRegion: function(node)
    {
        var myController = this;
        Ext.getCmp('centerRegion').removeAll();
        var content;
        if (node.childNodes.length > 0)
        {
            content = '<div">';
            for (var i = 0; i < node.childNodes.length; i++)
            {
                content += '<div class="treenodeover" style="margin-top:5px;padding:4px;">';
                content += '<div class="iconComponent" style="float:left;"></div>&nbsp;&nbsp;&nbsp;';
                content += '<a href="javascript:void(0)" id=' + encodeURI(node.childNodes[i].get('id')) + '>';
                content += node.childNodes[i].get('text');
                content += '</a>';
                content += '</div>';

                if (node.childNodes[i].childNodes.length > 0)
                {
                    content += '<div style="margin-left:30px;margin-top:5px;">';
                    for (var j = 0; j < node.childNodes[i].childNodes.length; j++)
                    {
                        content += '<div class="treenodeover" style="padding:4px;">';
                        content += '<div class="iconComponent" style="float:left;"></div>&nbsp;&nbsp;&nbsp;';
                        content += '<a href="javascript:void(0)" id=' + encodeURI(node.childNodes[i].childNodes[j].get('id')) + '>';
                        content += node.childNodes[i].childNodes[j].get('text');
                        content += '</a>';
                        content += '</div>';
                    }
                    content += '</div>';
                }
            }
            content += '</div>';
        }
        var innerpanel =  {
			xtype: 'outerPanel',
            id: 'innerpanel',
            title: node.get('text'),
            scroll: true,
            margin: '20px',
            bodyPadding: '5 5 5 5',
            border: true,
            html: content,
            //cls: 'block1',
            layout: 'fit',
            listeners: {
                'afterRender': function()
                {
                    var el = Ext.get('innerpanel');
                    el.on('click', function(event, target, options)
                    {
                        var unparsedId = target.id;
                        var parsedId;
                        if (unparsedId.indexOf("Mylink_") > -1)
                        {
                            parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
                        }
                        else
                        {
                            parsedId = unparsedId;
                        }
                        if (parsedId == "" || parsedId == null)
                        {
                             return;
                        }
						initLdgMask.show();
                        Ext.Ajax.request({
                            url: parsedId,
                            method: 'GET',
                            scope: this,
                            success: function(response)
                            {
                                myController.fillCollapsiblePanel(response, parsedId);
								initLdgMask.hide();
                            },
                            failure: function(err)
                            {
                                Ext.MessageBox.alert('Error occured in jsp page', 'Please try again!');
                            }

                        });
                    },
					this,
					{
						delegate: 'a'
					});
                }
            }
        };
        Ext.getCmp('centerRegion').add(innerpanel);
        //Ext.getCmp('centerRegion').doLayout();
    },
    singleNode_FunctionUpdate: function(node)
    {
        Ext.getCmp('centerRegion').removeAll();
        var content;
        if (node.childNodes.length > 0)
        {
            content = '<div>';
            for (var i = 0; i < node.childNodes.length; i++)
            {
                content += '<div class="treenodeover" style="margin-top:5px;padding:4px;">';
                content += '<div class="iconfunction" style="float:left;"></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
				content += '<a href="javascript:void(0)" id=' + encodeURI(node.childNodes[i].get('id')) + '>';
                content += node.childNodes[i].get('text');
                content += '</a>';
                content += '</div>';

                if (node.childNodes[i].childNodes.length > 0)
                {
                    content += '<div style="margin-left:30px;margin-top:5px;">';
                    for (var j = 0; j < node.childNodes[i].childNodes.length; j++)
                    {
                        content += '<div class="treenodeover" style="padding:4px;">';
                        content += '<div class="iconfunction" style="float:left;"></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
						content += '&nbsp;&nbsp;&nbsp;<a href="javascript:void(0)" id=' + encodeURI(node.childNodes[i].childNodes[j].get('id')) + '>';
                        content += node.childNodes[i].childNodes[j].get('text');
                        content += '</a>';
                        content += '</div>';

                        if (node.childNodes[i].childNodes[j].childNodes.length > 0)
                        {
                            content += '<div style="margin-left:60px;margin-top:5px;">';
                            for (var m = 0; m < node.childNodes[i].childNodes[j].childNodes.length; m++)
                            {
                                content += '<div class="treenodeover" style="padding:4px;">';
                                content += '<div class="iconfunction" style="float:left;"></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
								content += '<a href="javascript:void(0)" id=' + encodeURI(node.childNodes[i].childNodes[j].childNodes[m].get('id')) + '>';
                                content += node.childNodes[i].childNodes[j].childNodes[m].get('text');
                                content += '</a>';
                                content += '</div>';
                            }
                            content += '</div>';
                        }
                    }
                    content += '</div>';
                }
            }
            content += '</div>';
        }

        var innerpanel =  {
			xtype: 'outerPanel',
            id: 'innerpanel',
            title: node.get('text'),
            scroll: true,
            margin: '20px',
            bodyPadding: '5 5 5 5',
            border: true,
            html: content,
            cls: 'block1',
            layout: 'fit',
            listeners: {
                'afterRender': function()
                {
                    var el = Ext.get('innerpanel');
                    el.on('click', function(event, target, options)
                    {
                        var unparsedId = target.id;
                        var parsedId;
                        if (unparsedId.indexOf("Mylink_") > -1)
                        {
                            parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
                        }
                        else
                        {
                            parsedId = unparsedId;
                        }
                        if (parsedId == "" || parsedId == null)
                        {
                            return;
                        }
						this.setFrameSource(parsedId);
                    },
					this,
					{
						delegate: 'a'
					});
                }
            }
        };
        Ext.getCmp('centerRegion').add(innerpanel);
        //Ext.getCmp('centerRegion').doLayout();
    },
    updateCenterRegion: function(myTree)
    {
        var myController = this;
        var count = 0;
        var flag;//to check child exist or not for rootnode
        var componentArray = new Array();
        Ext.getCmp('centerRegion').removeAll();
		var outerTitlePane,innerTitlePane;
        var rootnode = myTree.getStore().getRootNode();
        var setClass;

		if(rootnode.childNodes.length>0)
		{

			var firstEmptyNode=rootnode.childNodes[0].get('text').toLowerCase();
			if(firstEmptyNode=='no component found')
			{
				 outerTitlePane = 'No reports available for component';
				 innerTitlePane = 'No component found';
				 //innerTitleChildPane='';
				 //rootNode.appendChild({ text: innerTitlePane, iconCls: 'iconInfo', leaf: true });
				 bodyContent=this.getNoRecordsPanel(outerTitlePane,innerTitlePane);
			}
			else
			{
				if (myTree.getRootNode().get('text') == 'ReportComponent')
				{
					setClass = 'iconComponent';
				}
				else if (myTree.getRootNode().get('text') == 'ReportService')
				{
					setClass = 'service20_GRAY';
				}
				else if (myTree.getRootNode().get('text') == 'ReportSegment')
				{
					setClass = 'segment20_GRAY';
				}
				else
				{
					setClass = 'zone20_GRAY';
				}

				var innerpanelColumn1, innerpanelColumn2;
				var newContainer = new Array();
				for (var i = 0; i < rootnode.childNodes.length; i++)
				{
					var content;
					if (rootnode.childNodes[i].childNodes.length > 0)
					{
						flag = true;
						content = '<div>';
						for (var j = 0; j < rootnode.childNodes[i].childNodes.length; j++)
						{
							content += '<div class="treenodeover" style=margin-top:5px;>';
							content += '<div style="float:left;padding:4px;" class="' + setClass + '"></div>&nbsp;&nbsp;&nbsp;';
							content += '<a href="javascript:void(0)" id=' + encodeURI(rootnode.childNodes[i].childNodes[j].get('id')) + '>';
							content += rootnode.childNodes[i].childNodes[j].get('text');
							content += '</a>';
							content += '</div>';

							if (rootnode.childNodes[i].childNodes[j].childNodes.length > 0)
							{
								content += '<div style=margin-left:30px;margin-top:5px;>';
								for (var k = 0; k < rootnode.childNodes[i].childNodes[j].childNodes.length; k++)
								{
									content += '<class="treenodeover">';
									content += '<div style="float:left;padding:4px;" class="' + setClass + '"></div>&nbsp;&nbsp;&nbsp;';
									content += '<a href="javascript:void(0)" id=' + encodeURI(rootnode.childNodes[i].childNodes[j].get('id')) + '>';
									content += rootnode.childNodes[i].childNodes[j].childNodes[k].get('text');
									content += '</a>';
									content += '</div>';
								}
								content += '</div>';
							}
						}
						content += '</div>';
		//-------------------------
						if (i % 2 == 0)
						{
							innerpanelColumn1 = {
								xtype: 'outerPanel',
								title: rootnode.childNodes[i].get('text'),
								//cls: 'block1',
								autoScroll: true,
								margin: '0 5 0 0',
								bodyPadding: '5 5 5 5',
								height: 240,
								flex: 1,
								layout: 'fit',
								html: content
							};

							if (rootnode.childNodes.length % 2 != 0)
							{
								if (i == rootnode.childNodes.length - 1)
								{
									var m = '-10 20 20 20';
									newContainer.push({
										xtype: 'container',
										layout: {
											type: 'hbox'
										},
										margin: m,
										items: [
											{
												xtype: innerpanelColumn1
											},
											{
												xtype: 'box',
												layout: 'fit',
												flex: 1,
												border: false,
												html: ''
											}
										]
									});
								}
							}
						}
						if (i % 2 != 0)
						{
							innerpanelColumn2 = {
								xtype: 'outerPanel',
								title: rootnode.childNodes[i].get('text'),
								//cls: 'block1',
								autoScroll: true,
								margin: '0 0 0 5',
								bodyPadding: '5 5 5 5',
								height: 240,
								flex: 1,
								layout: 'fit',
								html: content
							};

							if (i == 1)
							{
								var m = '20 20 20 20';
							}
							else
							{
								var m = '-10 20 20 20';
							}

							newContainer.push({
								xtype: 'container',
								layout: {
									type: 'hbox'
								},
								margin: m,
								items: [
									{
										xtype: innerpanelColumn1
									},
									{
										xtype: innerpanelColumn2
									}

								]
							});
						}
		//-------------------------
					}
					else
					{
						flag = false;
						var componentObj = {};
						componentObj.id = rootnode.childNodes[i].get('id');
						componentObj.text = rootnode.childNodes[i].get('text');
						componentArray.push(componentObj);
					}//close if else

				}//close for
				var bodyContent;
			   // var innerTitlePane = 'Reports available for the following components';
			   // var outerTitlePane = 'List of Components - ';
					var outerTitlePane = 'Reports By Component';
					var innerTitlePane = 'List of managed component types';
					var innerTitleChildPane = 'Select a component type to view its reports';

				if (flag)
				{
					bodyContent = this.getPanels(newContainer, myController);
				}
				else
				{
					bodyContent = this.getGridPanel(componentArray, myController, outerTitlePane,innerTitlePane,innerTitleChildPane,setClass);
				}
			}
		}
		else
		{
				 outerTitlePane = 'No reports available for components';
				 innerTitlePane = 'No component found';
				//innerTitleChildPane='';
				 //rootnode.appendChild({ text: innerTitlePane, iconCls: 'iconInfo', leaf: true });
				 bodyContent=this.getNoRecordsPanel(outerTitlePane,innerTitlePane);
		}

        Ext.getCmp('centerRegion').add(bodyContent);
        //Ext.getCmp('centerRegion').doLayout();
    },
    getGridPanel: function(componentArray, myController, outerTitlePane,innerTitlePane,innerTitleChildPane,contentClass)
    {
        var contentTable = myController.getGrid(componentArray,innerTitleChildPane,contentClass);
        var ParentContainer = {
            xtype: 'outerPanel',
            title: outerTitlePane,// + componentArray.length,
            id: 'innerContainer',
			layout:{
				type:'vbox',
				align: 'stretch'
			},
            border: true,
            bodyPadding: '0',
            //cls: 'block1',
            margin: '0',
            items: [
                {
                    xtype: 'panel',
                    title: innerTitlePane,
                    id: 'tableCont',
					//cls: 'block1',
                    layout: 'fit',
                    margin: '10 2 0 2',
                    html: contentTable,
                    tools: [
                        {
                            xtype: 'trigger',
                            cls: "whitedropdown_search_index",
                            fieldLabel: 'Search:',
                            emptyText: 'Type here',
                            id: 'livesearch',
                            name: 'livesearch',
                            labelWidth: 60,
                            padding: '0',
                            width: 250,
                            enableKeyEvents: true,
                            listeners: {
                                keyup: {
                                    fn: function(editor, element)
                                    {
                                        var input = editor.getValue();
                                        var searchArray = new Array();
                                        var unMatch = 0;
                                        for (var i = 0; i < componentArray.length; i++)
                                        {
                                            if (componentArray[i].text.toLowerCase().indexOf(input.toLowerCase()) > -1)
                                            {
                                                var searchObj = {};
                                                searchObj.text = componentArray[i].text;
                                                searchObj.id = componentArray[i].id;
                                                searchArray.push(searchObj);
                                            }
                                            else
                                            {
                                                unMatch++;
                                            }
                                        }

                                        if (unMatch == componentArray.length)
                                        {
                                            Ext.getCmp('tableCont').update('<br><br><p align="center"><b>No match found</b></p><br><br>');
                                        }
                                        else
                                        {
                                            var table = myController.getGrid(searchArray,innerTitleChildPane,contentClass);
                                            Ext.getCmp('tableCont').update(' ');
                                            Ext.getCmp('tableCont').update(table);
                                            Ext.getCmp('innerContainer').doLayout();
                                        }

                                    }
                                }
                            }
                        }
                    ]
                }
            ],
            listeners: {
                'afterRender': function()
                {
                    var el = Ext.get('tableCont');
                    el.on('click', function(event, target, options)
                    {
                        var unparsedId = target.id;
                        var parsedId;
						if(unparsedId=='livesearch-inputCell'||unparsedId=='livesearch-labelCell'||unparsedId.indexOf('ext-gen')>-1)
						{
							return;
						}
                        if (unparsedId.indexOf("Mylink_") > -1)
                        {
                            parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
                        }
                        else
                        {
                            parsedId = unparsedId;
                        }
                        if (parsedId == "" || parsedId == null)
                        {
                            return;
                        }
                        myController.updatePublicComponentType(parsedId);
						initLdgMask.show();
                        Ext.Ajax.request({
                            url: parsedId,
                            method: 'GET',
                            scope: this,
                            success: function(response)
                            {
                                myController.fillCollapsiblePanel(response, parsedId);
								initLdgMask.hide();
                            },
                            failure: function(err)
                            {
                                Ext.MessageBox.alert('Error occured in jsp page', 'Please try again!');
                            }

                        });
                    },
                            this,
                            {
                                delegate: 'a',
								delegate: 'td'
                            });
                }
            }
        };

        return ParentContainer;

    },
    getGrid: function(componentArray,innerTitleChildPane,contentClass)
    {
        var i = 0;
        var contentTable = '<div class="x-table" style="padding:5px;cursor:pointer;">';
        contentTable += '<table cellpadding="10" border="0" class="x-grid-table x-grid-table-resizer">';
        contentTable += '<tbody>';
		contentTable += '<tr class="x-grid-row" style="cursor:default;">';
		contentTable += '<td colspan="2" class="x-grid-cell x-grid-cell-first">';
		contentTable += '<div class="font_bold11" style="padding:4px;">';
		contentTable += innerTitleChildPane;
		contentTable += '</div>';
		contentTable += '</td>';
		contentTable += '</tr>';

        while (i < componentArray.length)
        {
            if (componentArray[i] != null && componentArray[i + 1] == null)
            {
                contentTable += '<tr class="x-grid-row">';
                contentTable += '<td colspan="2" id="' + componentArray[i].id +'" class="x-grid-cell x-grid-cell-first">';
				contentTable += '<div class="." style="padding:4px">';
                contentTable += '<div class='+contentClass+' style="float:left;padding:4px;"></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                contentTable += '<a href="javascript:void(0)" id="' + componentArray[i].id + '">' + componentArray[i].text + '</a>';
                contentTable += '</div>';
                contentTable += '</td>';
				contentTable += '</tr>';
                i++;
            }
            else
            {
                contentTable += '<tr class="x-grid-row">';
                contentTable += '<td id="' + componentArray[i].id + '" class="x-grid-cell x-grid-cell-first">';
                contentTable += '<div class="." style="padding:4px">';
				contentTable += '<div class='+contentClass+' style="float:left;padding:4px;"></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                contentTable += '<a href="javascript:void(0)" id="' + componentArray[i].id + '">' + componentArray[i].text + '</a>';
                contentTable += '</div>';
                contentTable += '</td>';
                contentTable += '<td id="' + componentArray[i + 1].id + '" class="x-grid-cell x-grid-cell-first">';
                contentTable += '<div class="." style="padding:4px">';
				contentTable += '<div class='+contentClass+' style="float:left;padding:4px;"></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                contentTable += '<a href="javascript:void(0)" id="' + componentArray[i + 1].id + '">' + componentArray[i + 1].text + '</a>';
                contentTable += '</div>';
                contentTable += '</td>';
                contentTable += '</tr>';
                i += 2;
            }
        }
        contentTable += '</tbody>';
        contentTable += '</table>';
        contentTable += '</div>';

        return contentTable;
    },
    getPanels: function(newContainer, myController)
    {
        var ParentContainer = new Ext.container.Container({
            //layout: 'fit',
            id: 'innerContainer',
            border: true,
            items: newContainer,
            listeners: {
                'afterRender': function()
                {
                    var el = Ext.get('innerContainer');
                    el.on('click', function(event, target, options)
                    {
                        var unparsedId = target.id;
                        var parsedId;
                        if (unparsedId.indexOf("Mylink_") > -1)
                        {
                            parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
                        }
                        else
                        {
                            parsedId = unparsedId;
                        }
                        if (parsedId == "" || parsedId == null)
                        {
                            return;
                        }
						initLdgMask.show();
                        Ext.Ajax.request({
                            url: parsedId,
                            method: 'GET',
                            scope: this,
                            success: function(response)
                            {
                                myController.fillCollapsiblePanel(response, parsedId);
								initLdgMask.hide();
                            },
                            failure: function(err)
                            {
                                Ext.MessageBox.alert('Error occured in jsp page', 'Please try again!');
                            }

                        });
                    },
                            this,
                            {
                                delegate: 'a'
                            });
                }
            }
        });

        return ParentContainer;
    },
    function_updateCenterRegion: function(myTree)
    {
        Ext.getCmp('centerRegion').removeAll();
        var rootnode = myTree.getStore().getRootNode();
        var innerpanelColumn1, innerpanelColumn2;
        var newContainer = new Array();
        for (var i = 0; i < rootnode.childNodes.length; i++)
        {
            var content;
            if (rootnode.childNodes[i].childNodes.length > 0)
            {
                content = '<div>';
                for (var j = 0; j < rootnode.childNodes[i].childNodes.length; j++)
                {
                    content += '<div class="treenodeover" style="margin-top:5px;padding:4px;" >';
                    content += '<div class="iconfunction" style="float:left;"></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    content += '<a href="javascript:void(0)" id=' + encodeURI(rootnode.childNodes[i].childNodes[j].get('id')) + '>';
                    content += rootnode.childNodes[i].childNodes[j].get('text');
                    content += '</a>';
                    content += '</div>';

                    if (rootnode.childNodes[i].childNodes[j].childNodes.length > 0)
                    {
                        content += '<div style=margin-left:30px;margin-top:5px;>';
                        for (var k = 0; k < rootnode.childNodes[i].childNodes[j].childNodes.length; k++)
                        {
                            content += '<div class="treenodeover" style="padding:4px;">';
                            content += '<div class="iconfunction" style="float:left;"></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                            content += '<a href="javascript:void(0)" id=' + encodeURI(rootnode.childNodes[i].childNodes[j].childNodes[k].get('id')) + '>';
                            content += rootnode.childNodes[i].childNodes[j].childNodes[k].get('text');
                            content += '</a>';
                            content += '</div>';

                            if (rootnode.childNodes[i].childNodes[j].childNodes[k].childNodes.length > 0)
                            {
                                content += '<div style=margin-left:60px;margin-top:5px;>';
                                for (var m = 0; m < rootnode.childNodes[i].childNodes[j].childNodes[k].childNodes.length; m++)
                                {
                                    content += '<div class="treenodeover" style="padding:4px;">';
                                    content += '<div class="iconfunction" style="float:left;"></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                                    content += '<a href="javascript:void(0)" id=' + encodeURI(rootnode.childNodes[i].childNodes[j].childNodes[k].childNodes[m].get('id')) + '>';
                                    content += rootnode.childNodes[i].childNodes[j].childNodes[k].childNodes[m].get('text');
                                    content += '</a>';
                                    content += '</div>';
                                }
                                content += '</div>';
                            }
                        }
                        content += '</div>';
                    }
                }
                content += '</div>';
                //------------------
                if (i % 2 == 0)
                {
                    innerpanelColumn1 = {
                        xtype: 'outerPanel',
                        title: rootnode.childNodes[i].get('text'),
                       // cls: 'block1',
						collapsed:true,
						collapsible:true,
						hideCollapseTool: true,
                        margin: '0 5 0 0',
                        bodyPadding: '5 5 5 5',
                        height: 240,
                        flex: 1,
                        layout: 'fit',
                        html: content,
						listeners:{
							'afterRender':function(panel)
							 {
 								//var PopUpWindow=new reportermenudashboard.view.PopUpWindow();
 							  	/*panel.header.el.on('mouseover', function()
								{
									if (panel.collapsed) {
										panel.expand();
									}
									else {
										panel.collapse();
									}
								});	  */
								panel.header.el.on('mouseover', function(event){
									panel.expand();
								});
								 panel.body.on('mouseleave', function(event){
									panel.collapse();
								});

							 }
						}
                    };
                    if (rootnode.childNodes.length % 2 != 0)
                    {
                        if (i == rootnode.childNodes.length - 1)
                        {
                            var m = '-10 20 20 20';
                            newContainer.push({
                                xtype: 'container',
                                layout: {
                                    type: 'hbox'
                                },

                                margin: m,
                                items: [
                                    {
                                        xtype: innerpanelColumn1
                                    },
                                    {
                                        xtype: 'box',
                                        layout: 'fit',
                                        flex: 1,
                                        border: false,
                                        html: ''
                                    }
                                ]
                            });
                        }
                    }
                }
                if (i % 2 != 0)
                {
                    innerpanelColumn2 = {
                        xtype: 'outerPanel',
                        title: rootnode.childNodes[i].get('text'),
                       // cls: 'block1',
						collapsed:true,
						collapsible:true,
						hideCollapseTool: true,
                        margin: '0 0 0 5',
                        bodyPadding: '5 5 5 5',
                        height: 240,
                        flex: 1,
                        layout: 'fit',
                        html: content,
						listeners:{
							'afterRender':function(panel)
							 {
								/*panel.header.el.on('mouseover', function()
								{
									var popUpInnerPanel=Ext.getCmp('popUpInnerPanel');
									popUpInnerPanel.update(' ');
									popUpInnerPanel.setTitle(panel.title);
									popUpInnerPanel.update(panel.body.dom.innerHTML);
									Ext.getCmp('popUpWin').show();
									if (popUpInnerPanel.getHeight() > 300) {
											popUpInnerPanel.setHeight(300);
									}

								});*/
								panel.header.el.on('mouseover', function(event){
									panel.expand();
								});
								 panel.body.on('mouseleave', function(event){
									panel.collapse();
								});
							}
						}
                    };
                    if (i == 1)
                    {
                        var m = '5 20 20 20';
                    }
                    else
                    {
                        var m = '-10 20 20 20';
                    }

                    newContainer.push({
                        xtype: 'container',
                        layout: {
                            type: 'hbox'
                        },
                        margin: m,
                        items: [
                            {
                                xtype: innerpanelColumn1
                            },
                            {
                                xtype: innerpanelColumn2
                            }

                        ]
                    });
                }
                //------------------
            }
        }
       /* var ParentContainer = new Ext.container.Container({
            // layout: 'fit',
            id: 'innerContainer',
            border: true,
            layout: {
                type: 'vbox',
                align: 'stretch'
            },
            items: newContainer,
            listeners: {
                'afterRender': function()
                {
                    var el = Ext.get('innerContainer');
                    el.on('click', function(event, target, options)
                    {
                        var unparsedId = target.id;
                        var parsedId;
                        if (unparsedId.indexOf("Mylink_") > -1)
                        {
                            parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
                        }
                        else
                        {
                            parsedId = unparsedId;
                        }
                        if (parsedId == "" || parsedId == null)
                        {
                            return;
                        }
                        var iframeObj = {
                            xtype: 'container',
                            height: 600,
                            layout: 'fit',
                            items: [{
                                    xtype: 'component',
                                    autoEl: {
                                        tag: 'iframe',
                                        src: parsedId
                                    }
                                }]
                        };
                        Ext.getCmp('centerRegion').removeAll();
                        Ext.getCmp('centerRegion').add(iframeObj);
                    },
                            this,
                            {
                                delegate: 'a'
                            });
                }
            }
        });	 */

		 var ParentContainer = {
            xtype: 'outerPanel',
            title: 'Reports by Function',
            id: 'parentContainer',
			layout:{
				type:'vbox',
				align: 'stretch'
			},
            border: true,
            bodyPadding: '0',
            //cls: 'block1',
            margin: '0',
            items: [
					{
						xtype: 'panel',
						//title: 'List of functional reports',
						id: 'tableCont',
						//cls: 'block1',
						border: true,
						layout:{
							type:'vbox',
							align: 'stretch'
						},
						margin: '10 2 0 2',
						items: newContainer/*,
						tbar:[
								{
									xtype:'label',
									html:'<div style="padding:4px;text-decoration:none;font-weight:bold;">&nbsp;&nbsp;Select a report to view its function</div>'
								}
							]  */
					}
			    ],
				listeners: {
                'afterRender': function()
                {
                    var el = Ext.get('tableCont');
                    el.on('click', function(event, target, options)
                    {
                        var unparsedId = target.id;
                        var parsedId;
                        if (unparsedId.indexOf("Mylink_") > -1)
                        {
                            parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
                        }
                        else
                        {
                            parsedId = unparsedId;
                        }
                        if (parsedId == "" || parsedId == null)
                        {
                            return;
                        }
                       this.setFrameSource(parsedId);
                    },
					this,
					{
						delegate: 'a'
					});
                }
            }
		 };
        Ext.getCmp('centerRegion').add(ParentContainer);
        //Ext.getCmp('centerRegion').doLayout();
    },
	homeFireBack: function(unparsedId)
		{
			var parsedId;
			if (unparsedId.indexOf("Mylink_") > -1)
				parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
			else
				parsedId = unparsedId;
			if (parsedId == "" || parsedId == null)
				return;
			initLdgMask.show();
			Ext.Ajax.request({
				url: parsedId,
				method: 'GET',
				scope: this,
				success: function(response)
				{
				   this.fillCollapsiblePanel(response, parsedId);
				  sessionStorage.setItem('lastAccessedNodeId',sessionStorage.getItem('nodeId'));
				  initLdgMask.hide();
				},
				failure: function(err)
				{
					Ext.MessageBox.alert('Error occured in jsp page', 'Please try again!');
				}
			});
	},
	loadMoreDataToTree:function(treeSection)
	{
		var me = this;
		//this.getMyReportFunctionPanel().getEl().mask("Expanding...", 'x-mask-loading');
		var currentSize = treeSection.getStore().lastOptions.node.childNodes.length;
		var maxSize = currentSize+treeDataSize;
		var urls = '';
		if(treeSection.id == 'reportZonePanel')
		{
			urls = '/final/reporter/ErReporterMenuDashboard_Json.jsp?choosenTab=zone&minList='+currentSize+'&maxList='+maxSize;
		}
		if(urls.length>0)
		{
			var initMasks = new Ext.LoadMask(Ext.getCmp('reportZonePanel').getEl(),{msg : "Loading..."});
			initMasks.show();
			Ext.Ajax.request({
				url: urls,
				method: 'POST',
				scope: this,
				success: function(response)
				{
					initMasks.hide();
					var requestJson = Ext.decode(response.responseText);
					if(requestJson.length>0)
					{
						var node = treeSection.getStore().getRootNode();
						for(var index in requestJson)
						{
							node.appendChild(requestJson[index]);
						}
					}
					else
					{
						treeSection.fullyLoaded = true;
					}
				},
				failure: function(err)
				{
					Ext.MessageBox.alert('Error occured in jsp page', 'Please try again!');
				}
			});
		}
	}
});//end controller