Ext.define('ReporterTemplate.view.ConfigWidgetWindow',{
	extend:'Ext.window.Window',
	alias:'widget.configWidgetWindow',
	requires:['ReporterTemplate.view.WidgetListGrid'],
	id:'configWidgetWindowId',
	margin:10,
	title:'Widget Configuration',
	//width:configWindowWidth,
	width:1020,
	height:560,
	ghost:false,
	ui:'newPopupWindow newplainHeader_border',
	frame:false,
	padding:0,
	border:false,
	closable:true,
	draggable:false,
	resizable:false,
    layout: 'fit',
	modal: true,
    closeAction: 'destroy',
	scroll:false,
	autoScroll:false,
	buttonAlign :'center',
	doClose: function()
	{
		this.destroy();
	},
	dockedItems: [
	{
		xtype:'toolbar',
		dock:'top',
		flex:1,
		height:32,
		items:[
		{
			xtype:'label',
			margin:'0 0 0 10',
			cls:'font_bold12',
			text:'LIST OF CONFIGURED WIDGETS',
		},
		{xtype:'tbfill'},
		{
			xtype:'button',
			text:backText,
			cls:'backbutton',
			iconCls:'iconBack',
			id: 'wigetBackId',
			name:'wigetBackId',
			margin:'0 10 0 0',
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html:backText
					});
				},
			},
			handler : function()
			{
				Ext.getCmp('configWidgetWindowId').doClose()
			}
		}]
	}],
	items:[
	{
		xtype:'widgetListGrid',
		
	}],
	listeners:{
		show: function(win) {
			if (this.modal) {
				var doms = Ext.dom.Query.select('.x-mask');
				for (var key in doms)
				{
					this.dom=doms[key];
					if (!Ext.isEmpty(this.dom.offsetParent))
					{
						if (this.dom.offsetParent.tagName=='BODY')
						{
							Ext.fly(this.dom).addCls('windowModal');
						}
					}
				}
			}
		},
		hide:  function(win) {
			if (this.modal) {
				var doms = Ext.dom.Query.select('.x-mask');
				for (var key in doms)
				{
					this.dom=doms[key];
					if (!Ext.isEmpty(this.dom.offsetParent))
					{
						if (this.dom.offsetParent.tagName=='BODY')
						{
							Ext.fly(this.dom).removeCls("windowModal");
						}
					}
				}
			}
		},
		close: function(win) {
			app.currentWidget = null;
			if (this.modal) {
				var doms = Ext.dom.Query.select('.x-mask');
				for (var key in doms)
				{
					this.dom=doms[key];
					if (!Ext.isEmpty(this.dom.offsetParent))
					{
						if (this.dom.offsetParent.tagName=='BODY')
						{
							Ext.fly(this.dom).removeCls("windowModal");
						}
					}
				}
			}
		},
		afterrender:function(){
			Ext.EventManager.onWindowResize(function(){
			var me = this;
			me.center();
			},this);
		}
	},
});