Ext.define('ReporterTemplate.view.GraphPaletteWindow',{
	extend:'Ext.container.Container',
	alias:'widget.graphpalettewindow',
	cls:'graphpalettewindow',
	bodyStyle: {
        //'background': '#535353'
    },
    defaults: {
        cls: 'dragTools'
    },
	floating:true,
	modal:false,
	header:false,
	resizable:false,
	shadow:false,
	id:'graphpalettewindowId',
	width:155,
	//width:211,
	height : 128,
	html:'<div class="colorPalletNodgeReporter"></div>',
	//layout:{ type : 'vbox',align : 'stretch'},
	closeAction : 'hide',
	padding:'8 0',
	border:true,
	dashBoardAction : '',
	profileName : '',
	blockId : '',
	selectedGraphPalette : null,
	listeners : {
		'beforeshow' : function(win)
		{

			if(win.selectedGraphPalette!=null && win.selectedGraphPalette!="" &&win.selectedGraphPalette!='null')
			{
				 var butObj=Ext.getCmp(win.selectedGraphPalette+"_Btn");
				if(!Ext.isEmpty(butObj))
				{
					 butObj.toggle(true);
				}
			}
		},
		'afterrender':function(win)
		{
			this.mon(win.el, 'mouseenter', function (event, html, eOpts)
			{
				if(win.blockId!=undefined && win.blockId!='')
				{
					var configPanl=Ext.getCmp(win.blockId);
					Ext.get(configPanl.getHeader().id).setStyle({'visibility':'visible'});
				}
			});
		
		},
		/* 'show':function(win)
		{
			var configPanl=Ext.getCmp(win.blockId);
			Ext.get(configPanl.getHeader().id).setStyle({'visibility':'visible'});
		}, */
		'render' : function(win)
		{
			var winDOM = win.getEl();
			win.mon(winDOM, {
				mouseleave: function() {
					win.hide();
				},
				mouseenter:function(){
					win.show();
				}
			});
			var meWind=this;
			var url="ReportTemplateController.jsp";
			var param;
			param='method=getGraphPalettes';
			Ext.Ajax.request({
				url:url,
				params:param,
				//async:isAsync,
				success : function(response){

						var jsonText=response.responseText;
						if(jsonText!=null && jsonText!='')
						{
							var jsonData=Ext.decode(jsonText);
							var bgArr=[];
							var palettes=jsonData['palettes'];

							if(!Ext.isEmpty(palettes))
							{

								for(var palette in palettes)
								{
									var paletteColors=palettes[palette];
									var paletteDiv='';
									for(var col in paletteColors)
									{
										paletteDiv=paletteDiv+'<div style="float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:'+paletteColors[col]+'"></div>';
									}
									var isPaletteSelected=false;
									if(meWind.selectedGraphPalette!=null && meWind.selectedGraphPalette==palette)
									{
										isPaletteSelected=true;
									}

									bgArr.push({
										xtype : 'button',
										overCls : 'labelOver',
										cls:'labelNormal',
										enableToggle:true,
										pressedCls:'labelSelect',
										toggleGroup:'selectName',
										imageId : palette,
										pressed : isPaletteSelected,
										id:palette+ '_Btn',
										width : 153,
										//width : 209,
										html : paletteDiv,
										//html : paletteDiv+"<div style='float:right;font-size:12px;' class='paletteName'>"+palette+"</div>",
										listeners : {
											/*  'render' : function(c)
											{
												c.getEl().on('click', function(){ this.fireEvent('click', c);

												}, c);
											}  */

										}

									});
								}
								meWind.add(bgArr);
							}
						}
					},
				failure : function(response, opts) {

				}
			});
		}
	}
});