Ext.define('ReporterTemplate.view.Gridster', {
	extend:'utilities.gridsterPanel',
	alias: 'widget.gridster',
	requires:['utilities.gridsterPanel'],
	id:'widgetLayoutPane',
	//margin:0,
	margin:'5 10 0 5',
	flex:1,
	count:0,
	layout:'fit',
	scroll:false,
	autoScroll:false,
	closeAction:'destroy',
	items:[],
	layoutStyle:{
		"type":"linear",
		"min_cols":2,
		"max_cols":2,
		"widget_base_dimensions":[widget_baseWidth, widget_baseHeight],
		"resizeWidget":true,
		"dragWidget":true
	},//linear,tabular,relative,custom
	//resizeWidget:true,
	frame:false,
	//scroll:true,
	//autoScroll:true,
	cls:'gridster',
	tpl: '<tpl for="."><div id="{id}" class="portlet gs-w x-container x-container-default" data-row="{row}" data-col="{col}" data-sizex="{size_x}" data-sizey="{size_y}" data-type="{widgetType}"  data-icon="{widgetIcon}"></div></tpl>',
	data:[],
	initComponent:function(){
		// TODO
		var gridsterPanel = this;

		gridsterPanel.renderPanel();
		var gridsterItems = gridsterPanel.items;
		var itemsLength = gridsterItems.length;

		var x=document.getElementById("reportTemplateMain").offsetWidth
		var y=document.getElementById("reportTemplateMain").offsetHeight


		var calculatedBaseDimensionX=x*0.10485;
		var calculatedBaseDimensionY=y*0.1500;//3732;

		calculatedBaseDimensionX=((x)/12)-10;

		calculatedBaseDimensionX=Ext.util.Format.round(calculatedBaseDimensionX, 0);
		calculatedBaseDimensionY=Ext.util.Format.round(calculatedBaseDimensionY, 0);

		widget_baseWidth=calculatedBaseDimensionX;
		widget_baseHeight=calculatedBaseDimensionY;

		gridsterPanel.layoutStyle.widget_base_dimensions=[calculatedBaseDimensionX,calculatedBaseDimensionY];

		if(itemsLength == 0){
			//console.log('NO ITEM FOUND')
		}
		else
		{
			gridsterPanel.on('resize', gridsterPanel.loadGridSter, gridsterPanel);
		}
		gridsterPanel.callParent();

	},
	/*
	* To get hold of the API object,
	* use the jQuery data method like so
	*/
	getGridsterObj:function(){
		var gridster = $(".gridster").gridster().data('gridster');
		return gridster
	},
	/*
	* Adding the toolbar dynamically in each widget
	*/
	addToolBarItems:function(items,toolId){
		var gridsterPanel = this;
		if(Ext.isArray(items)){
			var toolbar = {
				xtype:'toolbar',
				id:toolId,
				items:items,
			}
			return toolbar;
		}else{
			alert('error in  @param, use as array [{..},{..}]');
		}


	},
	/**
	* Loading the gridster.js api
	* Return gridster object
	*/
	loadGridSter:function(){
				var gridsterPanel = this,min_cols,max_cols,widget_base_dimensions,config,result=[];
				var gridsterObj = $(".gridster").gridster({
							widget_margins: [4, 4],
							//min_cols: gridsterPanel.layoutStyle.min_cols,
							//max_cols:gridsterPanel.layoutStyle.max_cols,
							//widget_base_dimensions:[gridsterPanel.up('panel').body.getWidth()*3,200],
							autogenerate_stylesheet:true,
							widget_base_dimensions:gridsterPanel.layoutStyle.widget_base_dimensions,
							draggable:
								{
									enabled: true,
									scroll:true,
									start: function(e, ui, $widget)
									{
									},
									drag: function(e, ui, $widget)
									{
									},
									stop: function(e, ui, $widget)
									{

									   var newpos = this.serialize($widget)[0];
									   //console.log("New col: " + newpos.col + " New row: " + newpos.row);
									}
							},
							resize: {
							enabled:gridsterPanel.layoutStyle.resizeWidget,
							start:function(e, ui, $widget){

							},
							resize:function(e, ui, $widget){
								 Ext.suspendLayouts();
								 Ext.getCmp($widget[0].getAttribute('id')+'_panel').setSize($widget.width(), $widget.height());
								 Ext.resumeLayouts(true);
							},
							stop: function(e, ui, $widget){
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').suspendEvents(true);
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').setSize($widget.width(), $widget.height());
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').resumeEvents( );
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').doComponentLayout();
							}
						},
						widget_selector: "div.portlet",
						serialize_params: function($w, wgd) {
							//console.log(wgd);
								return {
									id: $w[0].id,
									col: wgd.col,
									row: wgd.row,
									size_x: wgd.size_x,
									size_y: wgd.size_y
								};
						}

				}).data(gridsterObj);
			// Drag method will be disabled if false
			if(gridsterPanel.layoutStyle.dragWidget == false){
				gridsterObj.gridster.disable();
			}

			gridsterPanel.doComponentLayout();
			return gridsterObj;

	},
	/**
	* Responsive panel when resize window
	*/
	beResponsive:function($widgets){
		var gridsterPanel = this;
		if($widgets){
			$.each($widgets, $.proxy(function (index,element) {
				$($($widgets[index]).attr('id')).trigger('resize');
			}, $widgets));
		}

	},
	/**
	* Rendering the Ext panel in gridster widget
	* see @ addPanel() method
	*/
	renderPanel:function(){
		var gridsterPanel = this;
		//console.log(gridsterPanel.data);
		Ext.each(gridsterPanel.data, function(obj){
				Ext.defer(function(){
					//console.log(obj);
					gridsterPanel.addPanel(obj.id,Ext.fly(obj.id).getWidth(),Ext.fly(obj.id).getHeight(),obj.widgetType,obj.widgetIcon);
				},100);
		});
	},
	/**
	* Array of objects with representing the current
	* position of the widgets who have changed position.,
	* ready to be encoded as a JSON string
	*/
	getGridSterChangedPositions:function(){
		var gridsterPanel = this;
		return gridsterPanel.loadGridSter().gridster.serialize_changed( );
	},
	/**
	* Array of objects with positions of all widgets,
	* ready to be encoded as a JSON string
	*/
	gridsterSerialize:function(){
		var gridsterPanel = this;
		return gridsterPanel.loadGridSter().gridster.serialize();
	},
	/**
	* Load the data based on @parma {type}
	* Called in @addPanel method
	*/
	loadWidgetData:function(type,iconCls,chartIcon){
		var message='Config Widget'
		if(iconCls!='iconConfigUser')
			message='Done! Widget Configuration'
		var gridsterPanel = this;
		var box;
		if(iconCls!='iconConfigUser')
		{
			chartIcon=chartIcon.replace("Gray","")
			//box =	app.appObj.getController(app.appController).getConfiguredMe(type);
			box =	{
				xtype:'container',
				closeAction:'destroy',
				layout:{type:'hbox',align:'stretch',pack : 'center'},
				flex:1,
				listeners: {
					'afterRender': function(obj)
					{
						 this.getEl().on('click', function(event, target, options)
						 {
								app.appObj.getController(app.appController).onClickWidgetModify(obj.up('panel'));
						 });
					}
				},
				items:[{
					xtype:'button',
					//text:type,
					height:100,
					ui:'plain',
					style:{'cursor':'default'},
					html:'<table width="100%" height="80px" style="margin:0% auto;"><tr><td align="center" valign="middle"><div class="'+chartIcon+'" style="position:relative"><div class="widgetIcon24_Tick"></div></div><div style="margin:10px auto" class="datapanelWidgetIconTextConfigured">Widget configuration done!</div></td></tr></table>',

				}]
			}
		}
		 else
		 {
			 box = {
				xtype:'container',
				closeAction:'destroy',
				layout:{type:'hbox',align:'stretch',pack:'center'},
				flex:1,
				listeners: {
					'afterRender': function(obj)
					{
						 this.getEl().on('click', function(event, target, options)
						 {
							 if(iconCls=='iconConfigUser')
								app.appObj.getController(app.appController).onClickConfigWidget(obj);
						 });
					}
				},
				items:[{
					xtype:'button',
					//text:type,
					height:100,
					ui:'plain',
					html:'<table width="100%" height="80px" style="margin:0% auto;"><tr><td align="center" valign="middle"><div class="'+chartIcon+'"></div><div style="margin:10px auto" class="datapanelWidgetIconText">'+message+'</div></td></tr></table>',

				}]
			}
		 }

		return box;
	},
	/**
	* Creating the Ext.panel and returning the panel object
	* This object is render into gridster widget
	* see @ renderPanel() method
	*/
	addPanel:function(renderto_id,width,height,type,icon,widgetObj,configuredClsForEditWidget,userTitle,selectedPaletteColor,editableObj){
		console.log('widgetObj==',widgetObj)
		var gridsterPanel = this;
		var title='Title';
		var chartIcon='';
		title=app.appObj.getController(app.appController).getGrayChartIconOrDefaultTitle(type,'title');
		chartIcon=app.appObj.getController(app.appController).getGrayChartIconOrDefaultTitle(type,'gray');
	
		var hideColorTool=false;
		 if(type=='topn'||type=='digital'||type=='multiDigi'||type=='table'){
			hideColorTool = true;
		}
		if(userTitle!='')
			title=userTitle;
		if(selectedPaletteColor=='')
			selectedPaletteColor=null;
		var panel = new Ext.create('Ext.panel.Panel',{
			closeAction:'destroy',
			ui:'newGraphPanel',
			cls:configuredClsForEditWidget,
			chartType:type,
			widgetConfig:widgetObj,
			editableObj:editableObj,
			layout:{type:'vbox',align:'stretch'},
			id:renderto_id+'_panel',
			title:title,
			frame:false,
			selectedGraphPalette:selectedPaletteColor,
			width:width -2,
			height:height,
			renderTo:renderto_id,
			headerEditor:function(cmp)
			{
				headerCmp = cmp.getHeader().titleCmp;
				var el = Ext.get(cmp.getHeader().id+'_hd-'+headerCmp.childEls[0]);
				el.on('mouseover',function(){
					//console.log(cmp);
				});
				el.on('dblclick',function(){
					var editor = new Ext.Editor({
						alignment:"tl",
						updateEl: true,
						offsets: [0,-2],
						field: {
							xtype:'textfield',
							cls:'textbox',
						}
					});
					editor.startEdit(el);
				},cmp.getHeader());
			},
			items:[
				gridsterPanel.loadWidgetData(type,icon,chartIcon)
			],
			tools:[
				// tool bar adding for report builder
				gridsterPanel.addToolBarItems([
					{
						xtype : 'button',
						cls:'colorTool ',
						//cls:'dragTools',
						height:16,
						width:16,
						margin:'0 5 0 0',
						style:{'border':'0px'},
						tooltip : 'Change color palette',
						blockId:renderto_id+'_panel',
						hidden:hideColorTool,
						handler : function()
						{
							this.selectedGraphPalette=this.up('panel').selectedGraphPalette;
							app.appObj.getController(app.appController).showPaletteWindow(this);

						}
					},
					{
						xtype: 'button',
						cls:'iconConfig',
						style:{'border':'0px'},
						width:16,
						height:16,
						margin:'0 5 0 0',
						handler:function(){
							//console.log('gridsterPanel---',gridsterPanel);
							if (this.up('panel').hasCls('configuredWidgetDummy'))
							{
								this.up('panel').removeCls('configuredWidget');
							}
							app.appObj.getController(app.appController).onClickWidgetModify(this.up('panel'));
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 5 0 0',
						style:{'border':'0px'},
						cls: 'iconClose3',
						handler:function(){
							needWidgetCloseAlert = true;
							Ext.bind(gridsterPanel.onPortletClose(renderto_id,panel), gridsterPanel);
						}
					}
				],renderto_id+'_tool')
			],
			listeners:{
				'afterrender':function(cmp){
					cmp.headerEditor(cmp);
					Ext.get(cmp.getHeader().id).setStyle({'visibility':'hidden'});
					var toolId=cmp.getHeader().tools[0].id;
					if (cmp.hasCls('configuredWidgetDummy'))
					{
						Ext.get(cmp.getHeader().id).setStyle({'visibility':'visible'});
						Ext.getCmp(toolId).hide();
					}
					this.mon(cmp.el, 'mouseover', function (event, html, eOpts) {
						haveGraphPalette=false;
						if (!cmp.hasCls('configuredWidgetDummy'))
							cmp.addCls('defaultWidgetHover');
						Ext.get(cmp.getHeader().id).setStyle({'visibility':'visible'});
						if (cmp.hasCls('configuredWidgetDummy'))
						{
							Ext.getCmp(toolId).show();
						}
					});
					this.mon(cmp.el, 'mouseout', function (event, html, eOpts) {
						if (!haveGraphPalette)
						{
							/* if (!Ext.isEmpty(Ext.getCmp('graphpalettewindowId'))&& Ext.getCmp('graphpalettewindowId').isVisible())
							{
								Ext.getCmp('graphpalettewindowId').hide();
							}  */
							if (!cmp.hasCls('configuredWidgetDummy'))
								cmp.removeCls('defaultWidgetHover');
							if (!cmp.hasCls('configuredWidgetDummy'))
							{
								//cmp.getHeader().hide();
								Ext.get(cmp.getHeader().id).setStyle({'visibility':'hidden'});
							}
							if (cmp.hasCls('configuredWidgetDummy'))
							{
								var graphPaletteWindow = Ext.getCmp('graphpalettewindowId');
								if ( graphPaletteWindow != undefined && !Ext.isEmpty(graphPaletteWindow))
								{
									if(!graphPaletteWindow.isVisible())
										Ext.getCmp(toolId).hide();
								}
								else
								{
									Ext.getCmp(toolId).hide();
								}
							}
						}
					});
				},
				'beforeclose':function(panel) {
					if(panel.panelClose) {
						panel.panelClose = false;
						return true;
					}
					if(needWidgetCloseAlert)
					{
						Ext.Msg.show({
							 title:'eG Custom Reports',
							 msg:'Remove widget?',
							 buttons:Ext.Msg.YESNO,
							 icon: Ext.MessageBox.WARNING,
							 callback:function(btn) {
								if('yes' === btn) {
									panel.panelClose = true;
									// animation
									panel.el.slideOut('t', {
										easing: 'back-in',
										duration: 0,
										callback: function(){
											// Execute my custom method after the animation
											Ext.destroy(panel);
											gridsterPanel.removeWidget(renderto_id);
										},
										scope: panel
									});
								}
							}
						});
					}
					else
					{
						panel.panelClose = true;
						// animation
						panel.el.slideOut('t', {
							easing: 'back-in',
							duration: 0,
							callback: function(){
								// Execute my custom method after the animation
								Ext.destroy(panel);
								gridsterPanel.removeWidget(renderto_id);
							},
							scope: panel
						});
					}
					return false;
				}
			},
		});
		return panel;
	},
	/**
    * Adding widget to the layout
	* Getting the ID of the widget and rendering the Ext.panel
	* See addPanel() method
	* Updating the data
    */
	addWidget:function(chartType,sizeX,sizeY,row,col,widgetObj,iconCls,configuredCls,userTitle,selectedPaletteColor,editableObj){
		var gridsterPanel = this;
		var dyId = 'widget'+gridsterPanel.count++;
		//console.log(gridsterPanel.count ++);
		if(selectedPaletteColor==undefined || selectedPaletteColor=='undefined')
			selectedPaletteColor=null;
		gridsterPanel.suspendEvents();
		//BASED OF LAYOUT type have to change the logic
		if(gridsterPanel.data){
			newData = {"id":dyId,"row":row,"col":col,"size_x":sizeX,"size_y":sizeY,"widgetType":chartType,"widgetIcon":iconCls};
			gridsterPanel.data.push(newData);
		}
		//data-row="{row}" data-col="{col}"
		var noResizeClcs='';
		if(chartType=='digital' || chartType=='multiDigi')
			noResizeClcs=' no_resize';
		gridsterPanel.loadGridSter().gridster.add_widget.apply(gridsterPanel.loadGridSter().gridster,
		['<div id="'+dyId+'" class="portlet gs-w x-container x-container-default'+noResizeClcs+'" data-type="'+newData.widgetType+'"  data-icon="'+newData.widgetIcon+'"></div>',
		newData.size_x,
		newData.size_y
		]);
		// TODO
		gridsterPanel.addPanel(dyId,Ext.fly(dyId).getWidth(),Ext.fly(dyId).getHeight(),newData.widgetType,newData.widgetIcon,widgetObj,configuredCls,userTitle,selectedPaletteColor,editableObj);
		//While adding widget be focus
		Ext.fly(dyId).scrollIntoView(Ext.get(gridsterPanel.up('panel').body.id),false,true);
		gridsterPanel.resumeEvents(true);
		gridsterPanel.doComponentLayout();
	},
	/**
	* Firing the event of panel 'beforeclose'
	* panel has inline listeners object
	* see @ addPanel method
	*/
	onPortletClose: function(portlet,panel) {
		var gridsterPanel = this;
		panel.fireEvent('beforeclose',panel);
    },
	/**
    * Removing widget from the layout
    */
	removeWidget:function(id){
		var gridsterPanel = this;
		gridsterPanel.suspendEvents();
		gridsterPanel.loadGridSter().gridster.remove_widget($('#'+id));
		gridsterPanel.resumeEvents(true);
		gridsterPanel.doComponentLayout();
	},
	/**
    * Removing all widget from the layout
    */
	removeAllWidget:function(){
		var gridsterPanel = this;
		gridsterPanel.loadGridSter().gridster.remove_all_widgets();
	},
	/*
	* default postion to be reset
	* see @ revertWidgetPositions method
	*/
	getGridsterOrginPositions:function(){
		var gridsterPanel = this,data;
		if(gridsterPanel.data){
				data = gridsterPanel.data
		}
		return data;
	},
	/**
	* Reverting the widget position to original positions
	*/
	revertWidgetPositions:function(){
		var gridsterPanel = this;
		for (var i = 0; i < gridsterPanel.data.length; i++) {
					var element = $(".gridster div.portlet[id='"+gridsterPanel.data[i].id.toString()+"']");
					element.attr("data-row",gridsterPanel.data[i].row.toString());
                    element.attr("data-col",gridsterPanel.data[i].col.toString());
                    element.attr("data-sizey",gridsterPanel.data[i].size_x.toString());
                    element.attr("data-sizey",gridsterPanel.data[i].size_y.toString());
        }
        gridsterPanel.destroyGridster();
	    gridsterPanel.loadGridSter();
        return false;
	},
	/**
	* Destroying the grdister
	*/
	destroyGridster:function(){
		var gridsterPanel = this;
		gridsterPanel.getGridsterObj().destroy();
		var childNodes = document.getElementById(gridsterPanel.id).childNodes;
		for (var i = childNodes.length-1, cmp; i >= 0; i--) {
			cmp = Ext.getCmp(childNodes[i].id);
			if (cmp) {
				cmp.destroy();
			}
		}
	}
});
