Ext.define('ReporterTemplate.view.GridsterStackPanel', {
	extend:'Ext.panel.Panel',
	alias: 'widget.gridsterstackpanel',
	requires:['utilities.ReporterGridstackPanel'],
	id:'gridsterstackpanel',
	hidden:true,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	flex: 1,
	items:[{
		xtype: 'reportergridstackpanel',
		/*getDragPositions: function(gridStackPanel){

			console.log(this._serialization());
			console.log(this._serializationStr());
		},*/
		//getResizePositions: Ext.emptyFn,
		count:0,
		addWidget:function(obj, action, widgetTitle, imgIcon, imgIcon)
		{
			var me = this,
			gridstackobj = me.gridStackObjRef(),
			defaults = me.defaultConfigWidget;
			//console.log(me.defaultConfigWidget);
			var _arguments = Ext.applyIf(arguments[0], me.defaultConfigWidget);
			var ourtID = _arguments.id + '_outer';
			var innerID = _arguments.id + '_inner';
			console.log('gridstackobj  ',gridstackobj);
			var el = $('<div class="grid-stack-item"><div class="grid-stack-item-content"  id="' + innerID +
				'"></div></div>');
			if (typeof _arguments.x != 'undefined') {
				el.attr('data-gs-x', _arguments.x);
			}
			if (typeof _arguments.y != 'undefined') {
				el.attr('data-gs-y', _arguments.y);
			}
			if (typeof _arguments.width != 'undefined') {
				el.attr('data-gs-width', _arguments.width);
			}
			if (typeof _arguments.height != 'undefined') {
				el.attr('data-gs-height', _arguments.height);
			}
			if (typeof _arguments.autoPosition != 'undefined') {
				el.attr('data-gs-auto-position', _arguments.autoPosition ? 'yes' : null);
			}
			if (typeof _arguments.minWidth != 'undefined') {
				el.attr('data-gs-min-width', _arguments.minWidth);
			}
			if (typeof _arguments.maxWidth != 'undefined') {
				el.attr('data-gs-max-width', _arguments.maxWidth);
			}
			if (typeof _arguments.minHeight != 'undefined') {
				el.attr('data-gs-min-height', _arguments.minHeight);
			}
			if (typeof _arguments.maxHeight != 'undefined') {
				el.attr('data-gs-max-height', _arguments.maxHeight);
			}
			if (_arguments.noResize) {
				el.attr('data-gs-no-resize', _arguments.noResize);
			}
			if (typeof _arguments.id != 'undefined') {
				el.attr('data-gs-id', ourtID);
			}
			if (typeof _arguments.id != 'undefined') {
				el.attr('id', ourtID);
			}
			if (typeof action != 'undefined') {
				el.attr('action', action);
			}
			if (typeof widgetTitle != 'undefined') {
				el.attr('widgetTitle', widgetTitle);
			}
			if (typeof imgIcon != 'undefined') {
				el.attr('imgIcon', imgIcon);
			}
			if (typeof _arguments.internalId != 'undefined') {
				el.attr('internalId', _arguments.internalId);
			}


			//pushing the data
			el.data("internalId", _arguments.internalId);
			me.widgetConfigObj[ourtID] = _arguments;
			gridstackobj.addWidget(el);
			me.gridStackData(_arguments);
			//me.portlet(_arguments,action,widgetTitle,imgIcon,imgIcon);

			//Ext.apply(me.portlet,{widgetDetails:_arguments });
		},
		portlet: function (obj, action, widgetTitle, imgIcon, imgIcon) 
		{
			var me = this;
			if ($('#noData')) {
				$('#noData').remove();
			}
			var portlet, objArray;
			//@ checking wheather its getting obj is array or array object 
			if (Ext.isArray(obj)) {
				objArray = obj;
			} else {
				objArray = [];
				objArray.push(obj);
			}
			_.each(objArray, function (node) {
				console.log('node  ',node);
				var blockID = node.id,
					renderToID = node.id + '_inner',
					width = Ext.get(renderToID).getWidth(),
					height = Ext.get(renderToID).getHeight();				
				var title='Title';
				var chartIcon='';
				title=app.appObj.getController(app.appController).getGrayChartIconOrDefaultTitle(node.curChartType,'title');
				chartIcon=app.appObj.getController(app.appController).getGrayChartIconOrDefaultTitle(node.curChartType,'gray');
			
				var hideColorTool=false;
				if(node.curChartType=='topn'||node.curChartType=='digital'||node.curChartType=='multiDigi'||node.curChartType=='table')
				{
					hideColorTool = true;
				}
				if(node.widgetType!='')
					title=node.widgetType;
				if(node.selectedPaletteColor=='')
					node.selectedPaletteColor=null;
				//Loading portlet toolbar items;
				me.loadPortletToolbarItems(blockID,hideColorTool);
				portlet = Ext.create('Ext.panel.Panel', {
					closeAction: 'destroy',
					ui:'newGraphPanel toshadow',
					cls:node.configuredCls,
					chartType:node.curChartType,
					widgetConfig:node.widgetConfig,
					editableObj:node.editableObj,
					title: title,
					renderTo: renderToID,
					relationTo: node.id,
					id: blockID,
					width: width-2,
					height: height,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					headerEditor:function(cmp)
					{
						headerCmp = cmp.getHeader().titleCmp;
						var el = Ext.get(cmp.getHeader().id+'_hd-'+headerCmp.childEls[0]);
						el.on('mouseover',function(){
							//console.log(cmp);
						});
						el.on('dblclick',function(){
							var editor = new Ext.Editor({
								alignment:"tl",
								updateEl: true,
								offsets: [0,-2],
								field: {
									xtype:'textfield',
									cls:'textbox',
								}
							});
							editor.startEdit(el);
						},cmp.getHeader());
					},
					items:[
						me.loadWidgetData(node.curChartType,node.iconCls,chartIcon)
					],					
					tools: [{
							xtype: 'toolbar',
							margin: 0,
							padding: 0,
							id: blockID + '-toolbar',
							items: me.portlettoolbarItems
						}
					],
					listeners: 
					{
						'afterrender':function(cmp)
						{
							cmp.headerEditor(cmp);
							Ext.get(cmp.getHeader().id).setStyle({'visibility':'hidden'});
							var toolId=cmp.getHeader().tools[0].id;
							if (cmp.hasCls('configuredWidgetDummy'))
							{
								Ext.get(cmp.getHeader().id).setStyle({'visibility':'visible'});
								Ext.getCmp(toolId).hide();
							}
							this.mon(cmp.el, 'mouseover', function (event, html, eOpts) {
								haveGraphPalette=false;
								if (!cmp.hasCls('configuredWidgetDummy'))
									cmp.addCls('defaultWidgetHover');
								Ext.get(cmp.getHeader().id).setStyle({'visibility':'visible'});
								if (cmp.hasCls('configuredWidgetDummy'))
								{
									Ext.getCmp(toolId).show();
								}
							});
							this.mon(cmp.el, 'mouseout', function (event, html, eOpts) {
								if (!haveGraphPalette)
								{
									/* if (!Ext.isEmpty(Ext.getCmp('graphpalettewindowId'))&& Ext.getCmp('graphpalettewindowId').isVisible())
									{
										Ext.getCmp('graphpalettewindowId').hide();
									}  */
									if (!cmp.hasCls('configuredWidgetDummy'))
										cmp.removeCls('defaultWidgetHover');
									if (!cmp.hasCls('configuredWidgetDummy'))
									{
										//cmp.getHeader().hide();
										Ext.get(cmp.getHeader().id).setStyle({'visibility':'hidden'});
									}
									if (cmp.hasCls('configuredWidgetDummy'))
									{
										var graphPaletteWindow = Ext.getCmp('graphpalettewindowId');
										if ( graphPaletteWindow != undefined && !Ext.isEmpty(graphPaletteWindow))
										{
											if(!graphPaletteWindow.isVisible())
												Ext.getCmp(toolId).hide();
										}
										else
										{
											Ext.getCmp(toolId).hide();
										}
									}
								}
							});
						},
						'beforeclose': function (panel) 
						{
							if (panel.panelClose) {
								panel.panelClose = false;
								return true;
							}
							if(needWidgetCloseAlert)
							{
								Ext.Msg.show({
									title:'eG Custom Reports',
									 msg:'Remove widget?',
									 buttons:Ext.Msg.YESNO,
									 icon: Ext.MessageBox.WARNING,
									callback: function (btn) {
										if ('yes' === btn) {
											panel.panelClose = true;
											me._removeWidget(portlet.relationTo);
										}
									}
								});
							}
							else
							{
								
								panel.panelClose = true;
								me._removeWidget(portlet.relationTo);
							}
							return false;
						}
					}
				});
			});
			return portlet;
		},
		loadWidgetData:function(type,iconCls,chartIcon)
		{
			var message='Config Widget'
			if(iconCls!='iconConfigUser')
				message='Done! Widget Configuration'
			var gridsterPanel = this;
			var box;
			if(iconCls!='iconConfigUser')
			{
				chartIcon=chartIcon.replace("Gray","")
				//box =	app.appObj.getController(app.appController).getConfiguredMe(type);
				box =	{
					xtype:'container',
					closeAction:'destroy',
					layout:{type:'hbox',align:'stretch',pack : 'center'},
					flex:1,
					listeners: {
						'afterRender': function(obj)
						{
							 this.getEl().on('click', function(event, target, options)
							 {
									app.appObj.getController(app.appController).onClickWidgetModify(obj.up('panel'));
							 });
						}
					},
					items:[{
						xtype:'button',
						//text:type,
						height:100,
						ui:'plain',
						style:{'cursor':'default'},
						html:'<table width="100%" height="80px" style="margin:0% auto;"><tr><td align="center" valign="middle"><div class="'+chartIcon+'" style="position:relative"><div class="widgetIcon24_Tick"></div></div><div style="margin:10px auto" class="datapanelWidgetIconTextConfigured">Widget configuration done!</div></td></tr></table>',

					}]
				}
			}
			 else
			 {
				 box = {
					xtype:'container',
					closeAction:'destroy',
					layout:{type:'hbox',align:'stretch',pack:'center'},
					flex:1,
					listeners: {
						'afterRender': function(obj)
						{
							 this.getEl().on('click', function(event, target, options)
							 {
								 if(iconCls=='iconConfigUser')
									app.appObj.getController(app.appController).onClickConfigWidget(obj);
							 });
						}
					},
					items:[{
						xtype:'button',
						//text:type,
						height:100,
						ui:'plain',
						html:'<table width="100%" height="80px" style="margin:0% auto;"><tr><td align="center" valign="middle"><div class="'+chartIcon+'"></div><div style="margin:10px auto" class="datapanelWidgetIconText">'+message+'</div></td></tr></table>',

					}]
				}
			 }

			return box;
		},
		loadPortletToolbarItems: function (blockId,hideColorTool) 
		{
			var me = this;
			me.portlettoolbarItems = [
			{
				xtype : 'button',
				cls:'colorTool ',
				//cls:'dragTools',
				height:16,
				width:16,
				margin:'0 5 0 0',
				style:{'border':'0px'},
				tooltip : 'Change color palette',
				blockId:blockId,
				hidden:hideColorTool,
				handler : function()
				{
					this.selectedGraphPalette=this.up('panel').selectedGraphPalette;
					app.appObj.getController(app.appController).showPaletteWindow(this);

				}
			},
			{
				xtype: 'button',
				cls:'iconConfig',
				style:{'border':'0px'},
				width:16,
				height:16,
				margin:'0 5 0 0',
				handler:function(){
					//console.log('gridsterPanel---',gridsterPanel);
					if (this.up('panel').hasCls('configuredWidgetDummy'))
					{
						this.up('panel').removeCls('configuredWidget');
					}
					app.appObj.getController(app.appController).onClickWidgetModify(this.up('panel'));
				}
			},
			{
				xtype: 'button',
				width:16,
				height:16,
				margin:'0 5 0 0',
				style:{'border':'0px'},
				cls: 'iconClose3',
				handler:function(){
					needWidgetCloseAlert = true;
					this.up('panel').close();
				}
			}];
		},
	}]
});
