Ext.define('ReporterTemplate.view.IconLibrary', {
	alias: 'widget.iconLibrary',
	extend: 'Ext.window.Window',
	height: 330,
	width: 715,
	autoScroll: false,
	scroll: false,
	closeAction: 'destroy',
	resizable: false,

	ghost: false,
	//cls:'myDashboardwindow',
	cls: 'iconLibraryWindow',
	ui: 'newPopupWindow   newplainHeader_border',
	bodyPadding: 0,
	id: 'iconLibWindow',
	frame: false,
	padding: 0,
	bodyPadding: 0,
	margin: 0,
	border: 0,
	modal: true,
	//title: iconLLibraryLbl,
	title: 'Icon Library',
	from: '',
	windowId: '',
	custUploadPath: '',
	profileName: '',
	defaultClass: '',
	measureTabCountTemp:'',
	widgetID: '',
	widgetType: '',
	layout: {
		type: 'border',
		align: 'stretch'
	},
	initComponent: function () {

		var mee = this;
		var defaultIconSelectionSize = 32;
		if (mee.from != null && mee.from == 'digitialChartWidget') {
			defaultIconSelectionSize = 48;
		}
		if(mee.measureTabCount != undefined)
			mee.measureTabCountTemp=mee.measureTabCount;
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egMyDashboardController?action=loadIconLibData',
			method: 'GET',
			timeout: 60000,
			//params:{id:1},
			headers: {
				'Content-Type': 'application/json'
			},
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var Usericon2 = Ext.define('Usericon', {
					extend: 'Ext.data.Model',
					fields: [{
							name: "title",
							type: "string"
						},
						{
							name: "imageSrc",
							type: "string"
						},
						{
							name: "group",
							type: "string"
						},
						{
							name: "tag",
							type: "array"
						},
						{
							name: "size",
							type: "array"
						}
					]
				});

				var TemplateStore2 = Ext.create('Ext.data.Store', {
					model: Usericon2,
					data: jsonData.root[1].icons
				});

				var Treestore = Ext.create('Ext.data.TreeStore', {
					autoLoad: true,
					fields: [{
						name: 'text',
						type: 'string'
					}],
					root: {
						expanded: false,
						children: jsonData.root[0].children
					}
				})

				var updateData = {
					"size": defaultIconSelectionSize
				};

				function loadTemplte(updateData) {
					console.log('updateData--->',updateData);
					var imageTpl = new Ext.XTemplate(
						'<tpl for=".">',
						'<div style="float:left;margin:6px" class="iconLibraryImageBorder">',
						'<tpl for="size">',
						'<tpl if="this.returnSize(values,' + updateData.size + ')">',
						'<div class="{' + updateData.size + '}" data-qtip="{parent.title}"></div>',
						'</tpl>',
						'</tpl>',
						'<tpl if="this.returnIMG(imageSrc)">',
						'<img src="{imageSrc}" class="customImg" style="display:none" data-qtip="{title}" />',
						'</tpl>',
						'</div>',
						'</tpl><div style="clear:both"></div>', {
							disableFormats: true,
							returnIMG: function (imageSrc) {
								if (imageSrc == "none") {
									return false;
								} else {
									return imageSrc;
								}
							},
							returnSize: function (size, number) {
								if (size == "none") {
									return false;
								} else {
									for (var i in size) {
										if (number == i) {
											return size[i]
										}
									}
								}
							}
						}
					);
					return imageTpl;
				}
				mee.add([{
					region: 'west',
					//width:150,
					split: true,
					layout: 'fit',
					defaults: {
						margin: 0,
						cls: 'font_text'
					},
					items: [{
						width: 112,
						//height: 150,
						store: Treestore,
						rootVisible: false,
						activeItem: 1,
						xtype: 'treepanel',
						columnLines: false,
						useArrows: true,
						id: 'iconLibTree',
						cls: 'iconLibraryTreeDesign',
						listeners: {
							itemclick: function (tp, record, item, index, e, eOpts) {
								defaultCustomSelected = false;
								var dataString = record.data.text;
								//console.log('dataString--->',dataString);
								TemplateStore2.suspendEvents();
								TemplateStore2.clearFilter();
								TemplateStore2.resumeEvents();
								TemplateStore2.filterBy(function (rec) {
									if (rec.data.group === dataString || dataString === "ALL") {
										if (rec.data.imageSrc == "none") {
											return true;
										}
									}
								});
								// Custom images show and hide
								if (dataString === "custom") {
									Ext.getCmp('slider').disable(true);
									Ext.getCmp('searchIcon').disable(true);
									Ext.select('.customImg').show();
								} else {
									Ext.getCmp('slider').enable(true);
									Ext.getCmp('searchIcon').enable(true);
									Ext.select('.customImg').hide();
								}
								TemplateStore2.sort();
							}
						}
					}]
				}, {
					region: 'center',
					xtype: 'container',
					collapsible: true,
					layout: 'fit',
					scroll: false,
					border: false,
					autoScroll: false,
					margin: 0,
					items: [{
						xtype: 'dataview',
						store: TemplateStore2,
						id: 'iconViewContainer',
						scroll: false,
						autoScroll: true,
						itemSelector: 'div.iconLibraryImageBorder',
						clickEvent: function () {
							alert('calling');
						},
						tpl: loadTemplte(updateData),
						listeners: {
							refresh: function () {
								if (Ext.select('.iconLibraryImageBorder')) {
									Ext.select('.iconLibraryImageBorder').on({
										'click': function (event, target) {											
											var classname = target.getAttribute('Class');
											mee.defaultClass = classname;
										}
									})
								}
							}
						}
					}]
				}]);

				mee.addDocked({
					xtype: 'toolbar',
					dock: 'bottom',
					height: 55,
					padding: '10 10 10 15',
					items: ['->', {
						xtype: 'button',
						cls: 'buttonNewBig',
						id: 'selectIconBtn',						
						text: 'SELECT',
						padding: '0 10 0 10',
						handler: function (obj) {
							if(mee.defaultClass != undefined && mee.defaultClass.length==0)
							{
								Ext.getCmp('iconChartTypeChoose'+mee.measureTabCountTemp).removeCls('x-btn-pressedIcon');
								Ext.getCmp('iconNoImageChartType'+mee.measureTabCountTemp).addCls('x-btn-pressedIcon');
							}
							else
							{
								Ext.getCmp('iconNoImageChartType'+mee.measureTabCountTemp).removeCls('x-btn-pressedIcon');
								Ext.getCmp('iconChartTypeChoose'+mee.measureTabCountTemp).addCls('x-btn-pressedIcon');
							}
							Ext.getCmp('iconClass'+mee.measureTabCountTemp).setValue(mee.defaultClass);							
							this.up('window').close();
						}
					}, '->']
				});
			},
			failure: function (response) {
				Ext.Msg.alert('Status', 'Request Failed.');

			}
		});
		mee.callParent();
	}
});