Ext.define('ReporterTemplate.view.ReportBuilderGrid',{
	extend:'utilities.CustomGrid',
	requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy', 'utilities.CustomGrid'],
	alias:'widget.reportbuildergridalias',
	id:'reportbuildergridid',
	//cls:'gridSkin',
	ui:'newGridPanel withHeader withShade',
	border:true,
	autoScroll: false,
	scroll: false,
	screenLabels:null,
	dataArray : null,
	dummyArray : null,
	pageLimit:16,
	activePage:1,
	flex:1,
	padding:'0 10 10 10',
	margin:10,
	viewConfig: {
		emptyText : '<table width="100%" height="100%" align="center" valign="middle"><tr><td align="center" valign="middle"><div  class="iconExclamation"></div><div class="font_normal11">Templates not available</div></td></tr></table>'
	},
	initComponent:function(){

		var me=this;
		//this.addListener('viewready',this.showGridCellToolTip,this);
		this.selModel  = new Ext.selection.CheckboxModel(
			{
				checkOnly: true,
				//headerWidth:35,
				injectCheckbox: 'first',
				renderer : function(val, meta, record, rowIndex, colIndex, store,view){
					if(record.get('disbleStatus')=='true')
					{
						meta.tdCls = "noEllipsis";
						return '<img src="/final/images/spacer.gif" class="iconLock"  style="width:16px;height:16px;"/>';
					}
					else
					{
						meta.style="padding:2px 4px 2px 4px";
						meta.tdCls = "noEllipsis";
						return '<img src="/final/images/spacer.gif" class="' + Ext.baseCSSPrefix + 'grid-row-checker"/>';
					}
				}
			});

		if(Ext.isEmpty(this.dataArray))
			this.dataArray=[];
		this.dummyArray=this.dataArray.slice();

		this.store = Ext.create('Ext.data.Store', {
			/*  fields: ['templateName','templateDescription','templateTitle', 'sharing', 'createdDate', 'modifiedDate','builderConfigString','disbleStatus','sharedBy','CreatedBy'], */
			proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'json'
				}
			},
			pageSize:this.pageLimit,
			autoLoad : true,
			data : this.dataArray,
			sortOnLoad: true,
			fields: [{name:'templateName', sortType:Ext.data.SortTypes.asUCString},{name:'templateNameDisp', sortType:Ext.data.SortTypes.asUCString},{name:'templateDescription'},{name:'templateTitle'},{name:'sharing'},{name:'createdDate'},{name:'modifiedDate'},{name:'builderConfigString'},{name:'disbleStatus'},{name:'sharedBy'},{name:'CreatedBy'}],
			sorters: { property: 'templateNameDisp', direction : 'ASC' },
			/*sortType: function(value) {
			   switch (value.toLowerCase()) // native toLowerCase():
			   {
				  case 'first': return 1;
				  case 'second': return 2;
				  default: return 3;
			   }
			},*/
			// sortType: 'asNatural',

			// DESC for Descending order
			id: 'tmpStore'
		});
		this.on({
            cellClick: function(field, td, cellIndex, record, tr, rowIndex, e, eOpts) {
				if(app.builderType=="generate")
				{
					//app.appObj.getController(app.appController).generateFromListView(record.data.templateName);
					var records = new Object();
					records.templateName=record.data.templateName;
					window.location.href='/final/reporter/ReportBuilder.jsp?fromReportBuilder=false&method=init&recordInfo='+encodeURIComponent((Ext.encode(records)).toString());
				}
			},
        });
		this.columns = [
			{
				text : 'TEMPLATE NAME',
				dataIndex : 'templateNameDisp',
				flex : 1.2,
				sortable :true,
			//	renderer: this.formatURL,//..
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					if(app.builderType=="generate")
						metaData.style = 'cursor: pointer;';
					var dispVal = value;
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				},
			},
			{
				text : 'DESCRIPTION',
				dataIndex : 'templateDescription',
				flex : 1,
				sortable :true,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					if(app.builderType=="generate")
						metaData.style = 'cursor: pointer;';
					var dispVal = value;
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				},
			},
			{
				text : 'Shared By',
				dataIndex : 'sharedBy',
				flex : 1,
				sortable :true,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					if(app.builderType=="generate")
						metaData.style = 'cursor: pointer;';
					var dispVal = value;
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				},
			},
			{
				text : 'Created By',
				dataIndex : 'CreatedBy',
				hidden:true
			},
			/*{
				text : 'Template Title',
				dataIndex : 'templateTitle',
				flex : 1,
				sortable :true,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					var dispVal = value;
					var hrefUrl = record.get('favHrefUrl');
					if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
					{
						dispVal = '<a href="'+hrefUrl+'">'+value+'</a>';
					}
					return dispVal;
				}
			}, */
			{
				text : 'ACCESS TYPE',
				dataIndex : 'sharing',
				flex : 1,
				sortable :true,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					var dispVal = value;
					var hrefUrl = record.get('favHrefUrl');
					if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
					{
						dispVal = '<a href="'+hrefUrl+'">'+value+'</a>';
					}
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				}
			},
			{
				text : 'CREATED DATE',
				dataIndex :'createdDate',
				flex : 1,
				sortable :true,
				doSort: function(state) {
					var ds = me.store;
					var field = this.getSortParam();
					ds.sort({
						property: field,
						direction: state,
						sorterFn: function(v1, v2){
							v1 = v1.get(field);
							v2 = v2.get(field);
							 var oldDt = new Date(v1);
							 var newDt = new Date(v2);
							// var diffDays = oldDt.getDate() - newDt.getDate();

							// transform v1 and v2 here
							return oldDt.getTime() > newDt.getTime() ? 1 : (oldDt.getTime() < newDt.getTime() ? -1 : 0);
						}
					});
				},
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					var dispVal = value;
					var hrefUrl = record.get('favHrefUrl');
					if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
					{
						dispVal = '<a href="'+hrefUrl+'">'+value+'</a>';
					}
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				}
			},
			{
				text : 'Modified Date',
				hidden:true,
				dataIndex : 'modifiedDate',
				flex : 1
			},
			{
				//header: 'Go',
				xtype : 'actioncolumn',
				dataIndex : 'goColumn',
				width:35,
				renderer: function(value, metaData) {
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Generate Report"';
					return value;
				},
				items : [
					{
						iconCls:'iconGenerateGrid',
						handler : function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							app.appObj.getController(app.appController).generateFromListView(record.data.templateName);
						//	window.location.href='/final/reporter/ReportBuilder.jsp?method=init&recordInfo='+Ext.encode(record.data);
						}
					}
				]
			},
			{
				//header: 'Modify',
				xtype : 'actioncolumn',
				dataIndex : 'modify',//..
				width:35,
				renderer: function(value, metaData) {
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Modify"';
					return value;
				},
				items : [
					{
						iconCls:'iconSettingsReportTemplate',
						handler : function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							app.appObj.getController(app.appController).getTemplateInfo(record.data.templateName);
						}
					}
				]
			},
			{
				header: '<div style="cursor:pointer" id="removeAllIni" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
				xtype : 'actioncolumn',
				sortable :false,
				width:35,
				dataIndex : 'remove',//..
				renderer: function(value, metaData) {
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Remove"';
					return value;
				},
				items : [
					{
						iconCls:'iconDeleteReportTemplate',
						//iconCls:'iconDeleteDisabled',
						/*handler : function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							//alert("==========delete==="+record.get('disbleStatus'));
							if(record.get('disbleStatus')=='true'){
								return '<div class="iconDeleteDisabled"></div>';
							}
							app.appObj.getController(app.appController).deleteRecordsFromIni(grid,record);
							grid.getStore().load();
						}*/
						//renderer: function(value, metaData, record, row, col, store, gridView)
						getClass: function (value, meta, record, rowIndex, colIndex)
						{
							meta.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
							if (record.get('disbleStatus')=='true')
							{
								cls = 'iconDeleteReportTemplateDisabled';

							}
							else
							{
								cls = 'iconDeleteReportTemplate';

							}
							return cls;
						},
						handler : function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							if(record.get('disbleStatus')=='true'){
								return false;
							}

							Ext.Msg.show({
								title : 'eG custom report',
								msg : 'Do you want to remove the template?',
								cls:'egMsgBox',
								buttons : Ext.Msg.YESNO,
								icon : Ext.Msg.QUESTION,
								fn : function(buttonVal)
								{
									if (buttonVal == "yes")
									{
										app.appObj.getController(app.appController).deleteRecordsFromIni(grid,record);
										grid.getStore().load();
									}
								}
							});
						}

					}
				]
			}

		];
		var meGrid = this;
		this.dockedItems=[
		{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				id:'FavListPaging',
				name:'FavListPaging',
				pageSize:this.pageLimit,
				store: this.store,
				displayMsg: 'Displaying templates {0} - {1} of {2}',
				emptyMsg: "No templates to display",
				listeners: {
					change : function(thisd, params)
					{
						if(!Ext.isEmpty(params))
							meGrid.activePage = params.currentPage;
						else
							meGrid.activePage=0;
					}
				}
			},
			{
				xtype:'toolbar',
				cls:'toolbar',
				dock:'top',
				flex:1,
				height:38,
				items:[
					{
							xtype:'button',
							cls:'buttonNew',
							margin:'6 10 6 0',
							id:'addTemplate',
							name: 'addTemplate',
							iconCls:'iconAddDashboardPlus',
							text:'Create New Template',
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html: 'Create New Template'
									});
								}
							},
							action:'addNew'
						},
					{ xtype: 'tbfill' },
					/*
					{
						xtype:'textfield',
						fieldLabel:"Search",
						labelSeparator:'',
						id :'reportlivesearch',
						name: 'reportlivesearch',
						labelWidth:50,
						cls:'textbox',
						padding:'5 10 5 10',
						width:250,
						enableKeyEvents: true,
					},

					*/{
						xtype:'trigger',
						id : 'reportlivesearch',
						name : 'reportlivesearch',
						labelWidth:40,
						fieldLabel:'',
						cls: 'whitedropdown_search',
						emptyText:'Search template',
						enableKeyEvents: true,
						margin:'6 0 6 10',

						/*
						listeners: {
							change: function(trig,newVal,oldVal,eOpts) {
								Ext.getCmp('selectAllTemplates').setValue(false);
								trig.onTextFieldChange(trig,newVal,oldVal,eOpts);
							}
						},
						*/
					}
				]
			}
		]
		this.callParent();
	},
	listeners:{
		sortchange:function(ct, column, e, t, eOpts ){
			 this.getStore().loadPage(this.activePage);
		},
	}
});
