
/*
.widgetIcon24_HorizontalBarChart,
.widgetIcon24_VerticalBarChart,
.widgetIcon24_AreaChart,
.widgetIcon24_PieChart,
.widgetIcon24_TimelineChart,
.widgetIcon24_DistributedPieChart,
.widgetIcon24_StackedBarChart,
.widgetIcon24_HistogramChart,
.widgetIcon24_Table,
.widgetIcon24_GaugeMeter,
.widgetIcon24_TopNChart
.widgetIcon24_DigitalChart
.widgetIcon24_MultiDigitalChart
*/

var dta = [
	{displayField: 'Horizontal Bar Chart',valueField:'bar', imgClsName: 'widgetIcon24_HorizontalBarChart',chartCount:''},
	{displayField: 'Vertical Bar Chart', valueField:'vertbar', imgClsName: 'widgetIcon24_VerticalBarChart',chartCount:''},
	{displayField: 'Area Chart', valueField:'area', imgClsName: 'widgetIcon24_AreaChart',chartCount:''},
	{displayField: 'Pie Chart', valueField:'distribution', imgClsName: 'widgetIcon24_PieChart',chartCount:''},
	{displayField: 'Timeline Chart', valueField:'timeline', imgClsName: 'widgetIcon24_TimelineChart',chartCount:''},
	{displayField: 'Distributed Pie Chart', valueField:'distributedPie', imgClsName: 'widgetIcon24_DistributedPieChart',chartCount:''},
	{displayField: 'Horizontal Stacked Bar', valueField:'stackedbar', imgClsName: 'widgetIcon24_HorizontalStackedBarChart',chartCount:''},
	{displayField: 'Vertical Stacked Bar', valueField:'verticalstackedbar', imgClsName: 'widgetIcon24_StackedBarChart',chartCount:''},
	{displayField: 'Table', valueField:'table', imgClsName: 'widgetIcon24_Table',chartCount:''},
	{displayField: 'Top N', valueField:'topn', imgClsName: 'widgetIcon24_TopNChart',chartCount:''},
	{displayField: 'Digital Chart', valueField:'digital', imgClsName: 'widgetIcon24_DigitalChart',chartCount:''},
	//{displayField: 'Multi Digital', valueField:'multiDigi', imgClsName: 'widgetIcon24_MultiDigitalChart',chartCount:''},
	{displayField: 'KPI', valueField:'multiDigi', imgClsName: 'widgetIcon24_Kpi',chartCount:''},
	{displayField: 'HeatMap', valueField:'heatMap', imgClsName: 'widgetIcon24_Table',chartCount:''},
]

Ext.define('ReporterTemplate.view.ReportConfigSlider',{
	alias:'widget.reportconfigslider',
	extend:'Ext.panel.Panel',
	scroll:false,
	autoScroll:false,
	bodyPadding:0,
	frame:false,
	groupMe:false,
	showfilter:false,
	id:'reportconfigsliderId',
	group:{
		numberOfItems : 13
	},
	bodyStyle:{'position':'relative','overflow':'visible'},
	margin:0,
	ui:'plain',

	//itemToSet:8,
	//itemToSet:9,
	itemToSet:13,
	data:dta,
	orginalData : [],
	selectedItem : curChartType,
	height:84,
	//bodyCls:'iconChooseTempOuterReporter',
	//width:880,
	//width:881,
	width:1005,
	widthofDockedItems:44,
	effect:'easeIn',
	layout:{
		type:'hbox',
	},
	filterMe:function(data){
		var me = this;
		console.log("data ",data);
		me.removeAll();
		me.applyData(data);
		me.fireEvent('loadData',me);

	},

	setData:function(data){
		var me = this;
		if(data != null){
			me.applyData(data);
		}
	},

	getData:function(){
		var me = this;
		return me.data;
	},

	applyData:function(data){
		var me = this;
		me.data = data;
	},

	chunkData:function(arr, len){
		var chunk_data = [], i = 0,n = arr.length;
		while (i < n) {
			chunk_data.push(arr.slice(i, i += len));
		}
		return chunk_data;
	},

	onShow:function(){
		var me = this;
		me.fireEvent('loadData',me);
		me.callParent();
	},

	onRender:function(){
		var me = this;
		if(me.hidden == false){
			me.onShowData();
		}
		me.callParent();
	},
	changeGraphType:function(btn)
	{
		/* Ext.getCmp(curChartType).removeCls('x-btn-pressed');
		Ext.getCmp(btn.id).addCls('x-btn-pressed');

		var divtag = document.getElementById("chartCountId"+curChartType);
		divtag.className= "";
		divtag = document.getElementById("chartCountId"+btn.valueField);
		divtag.className= "iconGreenTick";
		me.selectedItem=btn.valueField;
		curChartType=btn.valueField;
		var reloadRequried=false;

		if(app.isCustomLayout=='no')
			reloadRequried=true;
		app.appObj.getController(app.appController).resetReportGroup(curChartType,reloadRequried); */
	},
	onShowData:function(){
		var me = this;
		var wrapper =[];
		me.buttonWidth = Math.round((me.width - me.widthofDockedItems) / me.itemToSet);
		me.incrementBy =  Math.round(me.buttonWidth * me.itemToSet);
		me.decrementBy = Math.round(me.buttonWidth * me.itemToSet);
		me.moveIt = 0;
		me.orgin =0;
		var gridsterPanel = Ext.getCmp('reportergridstackpanel');
		var barChartCount = 0;
		var vertBarChartCount = 0;
		var areaChartCount = 0;
		var pieChartCount = 0;
		var timelineChartCount = 0;
		var distPieChartCount = 0;
		var stkBarChartCount = 0;
		var vertStkbarChartCount = 0;
		var tableCount = 0;
		var topNChartCount = 0;
		var digitalChartCount = 0;
		var multiDigiChartCount = 0;
		var heatMapCount = 0;
		if (!Ext.isEmpty(gridsterPanel))
		{
			var gridstackdata = Ext.getCmp('reportergridstackpanel')._serialization();
			var gridster_items = GridStackUI.Utils.sort(gridstackdata);
			
			var widgetList=new Array();
			if (gridster_items.length>0)
			{
				document.getElementById('widgetCountHighlightId').innerHTML=gridster_items.length;
				for (var item in gridster_items)
				{
					var gridster_obj=gridster_items[item];
					var eachPanel=Ext.getCmp(gridster_obj.id);
					var gridsterChartType = eachPanel.widgetConfig.chartType;
					if(gridsterChartType=='bar')
						barChartCount = barChartCount+1;
					else if(gridsterChartType=='vertbar')
						vertBarChartCount = vertBarChartCount+1;
					else if(gridsterChartType=='area')
						areaChartCount = areaChartCount+1;
					else if(gridsterChartType=='distribution')
						pieChartCount = pieChartCount+1;
					else if(gridsterChartType=='timeline')
						timelineChartCount = timelineChartCount+1;
					else if(gridsterChartType=='distributedPie')
						distPieChartCount = distPieChartCount+1;
					else if(gridsterChartType=='stackedbar')
						stkBarChartCount = stkBarChartCount+1;
					else if(gridsterChartType=='verticalstackedbar')
						vertStkbarChartCount = vertStkbarChartCount+1;
					else if(gridsterChartType=='table')
						tableCount = tableCount+1;
					else if(gridsterChartType=='topn')
						topNChartCount = topNChartCount+1;
					else if(gridsterChartType=='digital')
						digitalChartCount = digitalChartCount+1;
					else if(gridsterChartType=='multiDigi')
						multiDigiChartCount = multiDigiChartCount+1;
					else if(gridsterChartType=='heatMap')
						heatMapCount = heatMapCount+1;
				}
			}
		}
		for(var v=0; v<me.data.length; v++)
		{
			me.data[v].chartCount = '';
			if(me.data[v].valueField == 'bar' && barChartCount>0)
				me.data[v].chartCount = barChartCount;
			else if(me.data[v].valueField=='vertbar' && vertBarChartCount>0)
				me.data[v].chartCount = vertBarChartCount;
			else if(me.data[v].valueField=='area' && areaChartCount>0)
				me.data[v].chartCount = areaChartCount;
			else if(me.data[v].valueField=='distribution' && pieChartCount>0)
				me.data[v].chartCount = pieChartCount;
			else if(me.data[v].valueField=='timeline' && timelineChartCount>0)
				me.data[v].chartCount = timelineChartCount;
			else if(me.data[v].valueField=='distributedPie' && distPieChartCount>0)
				me.data[v].chartCount = distPieChartCount;
			else if(me.data[v].valueField=='stackedbar' && stkBarChartCount>0)
				me.data[v].chartCount = stkBarChartCount;
			else if(me.data[v].valueField=='verticalstackedbar' && vertStkbarChartCount>0)
				me.data[v].chartCount = vertStkbarChartCount;
			else if(me.data[v].valueField=='table' && tableCount>0)
				me.data[v].chartCount = tableCount;
			else if(me.data[v].valueField=='topn' && topNChartCount>0)
				me.data[v].chartCount = topNChartCount;
			else if(me.data[v].valueField=='digital' && digitalChartCount>0)
				me.data[v].chartCount = digitalChartCount;
			else if(me.data[v].valueField=='multiDigi' && multiDigiChartCount>0)
				me.data[v].chartCount = multiDigiChartCount;
			else if(me.data[v].valueField=='heatMap' && heatMapCount>0)
				me.data[v].chartCount = heatMapCount;
		}
		//me.tools[0].hidden= true;
		if(me.groupMe == true){
			me.width=270;
			me.height=340;
			me.itemToSet=1;

			var chunked_data = me.chunkData(me.data,me.group.numberOfItems),
			no_wrapper = chunked_data.length;

			for (var warp in chunked_data)
			{
				if (chunked_data.hasOwnProperty(warp)){
					wrapper.push({
						xtype:'container',
						//flex:1,
						layout:'column',
						height:me.height,
						width:me.width - me.widthofDockedItems ,
						id:'container'+warp,
						data:chunked_data[warp],
						listeners:{
							render:function(container){
								container.data.forEach(function(data,i){
									container.add({
										xtype:'button',
										ui:'widgetConfigurationSliderButton',
										action : 'template_selection',
										width:74,
										toggleGroup:'groupsss',
										text:data.displayField,
										html:'<div style="padding-top:10px;"><div style="height:36px"><img src="/final/images/clear.png" class='+data.imgClsName+' width="32px" height="32px"></div></div>',
										handler:function(btn){
											me.selectedItem=btn.valueField;
										}
									});
								});
								me.doComponentLayout();
							}
						}
					});
				}
			}
		}
		else
		{
			me.width=1005;
			//me.itemToSet=9;
			me.itemToSet=13;
			//me.title='Choose Template';
			if(me.data != null){
				dataLength = me.getData().length;
				for (var t=0;t< dataLength;t++ )
				{
					var btnPressed=false;
					var chartCountStyle = 'style="display:none;"'
					var isDisable = false;
					if(me.data[t].valueField=='digital' || me.data[t].valueField=='multiDigi' || me.data[t].valueField=='heatMap')
					{
					//	isDisable = true;
					}
					//if(me.selectedItem!=null && me.selectedItem==me.data[t].valueField)
					//{
					//alert(curChartType)
					if(curChartType!=null && curChartType!=me.data[t].valueField && isEditTemplate)
					{
						isDisable = true;
					}
					if(me.data[t].chartCount!='' && me.data[t].chartCount!='0')
					{
						chartCountStyle = 'style="display:block;"';
					}
					if(curChartType!=null && curChartType==me.data[t].valueField)
					{
						btnPressed=true;
					}
					itemsBT ={
						xtype:'button',
						width:me.buttonWidth,
						//padding:0,
						ui:'widgetConfigurationSliderButton',
						enableToggle:true,
						tooltip: '<b>'+me.data[t].displayField+'</b>',
						id : me.data[t].valueField,
						valueField : me.data[t].valueField,
						chartCount : me.data[t].chartCount,
						pressed : btnPressed,
						//margin:0,
						disabled:isDisable,
						toggleGroup:'groupsss',
						html:'<div style="height:80px;"><div style="margin-top:10px;margin-left:-5px;height:32px"><img src="/final/images/clear.png" class='+me.data[t].imgClsName+' width="24px" height="24px"></div><div style="white-space:normal;margin:0px 5px 0px 0px">'+me.data[t].displayField+'</div><div id="chartCountId'+me.data[t].valueField+'" '+chartCountStyle+' class="reportBuilderWidgetCountBox">'+me.data[t].chartCount+'</div></div>',
						handler:function(btn){

							var gridObj = Ext.getCmp('configdataid');
							var totalTab = Ext.getCmp('reportertemplatetabid').items.length;
							console.log(btn.valueField+'  '+curChartType);
							if(btn.valueField==curChartType)
								return;
							if(totalTab > 1)
							{
								Ext.Msg.show({
									title : 'eG custom report',
									//msg : 'Do you want to remove the previous configurations?',
									msg : 'You will lose the configurations you have added so far, do you really want to proceed?',
									buttons : Ext.Msg.YESNO,
									cls:'egMsgBox',
									icon : Ext.Msg.QUESTION,
									fn : function(buttonVal)
									{
										if (buttonVal == "yes")
										{
											Ext.getCmp(curChartType).removeCls('x-btn-pressed');
											Ext.getCmp(btn.id).addCls('x-btn-pressed');
											me.selectedItem=btn.valueField;
											curChartType=btn.valueField;
											var reloadRequried=true;
											isEditTemplate=false;
											Ext.getCmp('measureTypeId').setValue({"measureType":['DDMeasure']});
											app.appObj.getController(app.appController).restTabPane();
											app.appObj.getController(app.appController).loadDummyGraph(Ext.getCmp('previewGraphPanelId'));
										}
										else
										{
											Ext.getCmp(btn.id).removeCls('x-btn-pressed');
											Ext.getCmp(curChartType).addCls('x-btn-pressed');
										}
									}
								});
							}
							else
							{
								Ext.getCmp(curChartType).removeCls('x-btn-pressed');
								Ext.getCmp(btn.id).addCls('x-btn-pressed');
								me.selectedItem=btn.valueField;
								curChartType=btn.valueField;
								var reloadRequried=true;
								isEditTemplate=false;
								Ext.getCmp('measureTypeId').setValue({"measureType":['DDMeasure']});
								app.appObj.getController(app.appController).restTabPane();
								app.appObj.getController(app.appController).loadDummyGraph(Ext.getCmp('previewGraphPanelId'));
							}
						}
					}
					wrapper.push(itemsBT);
				}
			}
		}

		me.suspendLayouts();
		me.add({
			xtype:'container',
			height:me.height-1,
			cls:'iconChooseTempContainerReporter',
			layout:{
				type:'hbox',
				align:'stretch'
			},
			items:wrapper
		});

		me.resumeLayouts();
		me.initToolbar();
		me.doLayout();

	},

	initEvents : function() {
		var me = this;
		me.callParent();
		me.on('loadData', me.onShowData, me);
	},

	initComponent:function(){
		var me = this;
		this.addEvents({
			"loadData" : true
		});
		me.callParent();
	},

	initToolbar:function(){

		var me = this;
		if(!Ext.isEmpty(me.data)){

			if(me.data.length <= me.itemToSet){
				Ext.ComponentQuery.query('button[itemId ="nextGen"]')[0].disable();
				Ext.ComponentQuery.query('button[itemId ="previousGen"]')[0].disable();
			}else{
				Ext.ComponentQuery.query('button[itemId ="nextGen"]')[0].enable();
			}
			if(me.data.length <= me.itemToSet){
				Ext.ComponentQuery.query('button[itemId ="previousGen"]')[0].disable();
			}else{
				Ext.ComponentQuery.query('button[itemId ="previousGen"]')[0].enable();
				Ext.ComponentQuery.query('button[itemId ="nextGen"]')[0].disable();
			}
		}
	},

	getBodyOffsetleft:function(){
		return this.body.dom.offsetLeft;
	},

	getBodyWidth:function(){
		return this.body.getWidth();
	},

	getSliderId:function(){
		return this.getComponent(0).id;
	},

	getSliderWidth:function(){
		return Ext.get(this.getSliderId()).getWidth();
	},

	getSliderOffsetLeft:function(){
		return Ext.get(this.getSliderId()).dom.offsetLeft;
	},

	getSliderOffsetWidth:function(){
		return Ext.get(this.getSliderId()).dom.offsetWidth;
	},

	animate:function(orgin,effect){
		effect = this.effect || effect;
		Ext.get(this.getSliderId()).animate({
			to: {
				marginLeft: orgin
			},
			easing: effect
		});
	},

	slideMovementGen:function(button){
		var me = this;
		var last_gap_be = me.getSliderWidth() % me.incrementBy;
		var last_gap_bes = me.getSliderWidth() % me.decrementBy;
		me.effect = 'easeIn';
		if(button.itemId == 'previousGen')
		{
			me.moveIt += me.incrementBy;
			me.orgin = - me.moveIt;
			Ext.ComponentQuery.query('button[itemId ="nextGen"]')[0].enable();
			condition = - me.getSliderOffsetWidth() + me.getBodyWidth() + last_gap_be;
			if(me.orgin <= condition){
				me.effect = 'backOut';
				me.orgin = me.getSliderOffsetLeft() - last_gap_be;
				button.disable();
			}
		}
		else
		{
			me.moveIt -= me.decrementBy;
			me.orgin = - me.moveIt;
			Ext.ComponentQuery.query('button[itemId ="previousGen"]')[0].enable();
			if(me.orgin >= 0){
				me.effect = 'backOut';
				me.orgin = 0;
				button.disable();
			}
		}
		me.animate(me.orgin,me.effect);
	},

	dockedItems: [{
		xtype: 'toolbar',
		height:30,
		dock: 'left',
		items: [
		'->',
		{
			xtype: 'button',
			itemId:'nextGen',
			//cls:'iconChooseTempNextBut',
			iconCls:'iconChooseTempLeftArrow',
			hidden:false,
			width:20,
			text: '',
			style:{
				//'background':'none',
				'display':'none',
				'border':'0px',
				'height':'20px !important'
			},
			height:24,
			getParent: function(){ return this.up('panel')},
			handler:function(btn,event){
				btn.getParent().slideMovementGen(btn);
			}
		},
		'->'
		]
	},{
		xtype: 'toolbar',
		height:30,
		dock: 'right',
		padding:0,
		items: [
		'->',
		{
			xtype: 'button',
			itemId:'previousGen',
			//cls:'iconChooseTempPreviousBut',
			iconCls:'iconChooseTempRightArrow',
			hidden:false,
			width:20,
			text: '',
			style:{
				//'background':'none',
				'display':'none',
				'border':'0px',
				'height':'20px !important'
			},
			height:24,
			getParent: function(){ return this.up('panel')},
			handler:function(btn,event){
				btn.getParent().slideMovementGen(btn);
			}
		},
		'->'
		]
	}]
});
