

Ext.define('ReporterTemplate.view.ReportDataConfigWindow',{
	extend:'Ext.window.Window',
	alias:'widget.reportdataconfigwindow',
	id:'reportdataconfigwindowid',
	requires:[
	'ReporterTemplate.view.ReportConfigSlider',
	//'ReporterTemplate.view.ReportDataConfiguration',
	],
	margin:0,
	title:'Config Report Template',
	//width:configWindowWidth,
	width:1020,
	ui:'newPopupWindow newplainHeader',
	ghost:false,
//	cls:'myDashboardwindow',
	frame:false,
	padding:0,
	border:false,
	modal:true,
	closable:true,
	draggable:true,
	resizable:false,
    layout: 'vbox',
	modal: true,
	//autoTile: true,
    closeAction: 'destroy',
	scroll:false,
	doClose: function()
	{
		app.currentWidget = null;
		if(!Ext.isEmpty(Ext.getCmp('builderSubWindow'))){
			Ext.getCmp('builderSubWindow').close();
		}
		this.destroy();
	},

	listeners:{
		show: function(win) {
			if (this.modal) {
				var doms = Ext.dom.Query.select('.x-mask');
				for (var key in doms)
				{
					this.dom=doms[key];
					if (!Ext.isEmpty(this.dom.offsetParent))
					{
						if (this.dom.offsetParent.tagName=='BODY')
						{
							Ext.fly(this.dom).addCls('windowModal');
						}
					}
				}
			}
			Ext.getCmp('cancelTemplate').hide();
			Ext.getCmp('createTemplate').hide();
		},
		hide:  function(win) {
			if (this.modal) {
				var doms = Ext.dom.Query.select('.x-mask');
				for (var key in doms)
				{
					this.dom=doms[key];
					if (!Ext.isEmpty(this.dom.offsetParent))
					{
						if (this.dom.offsetParent.tagName=='BODY')
						{
							Ext.fly(this.dom).removeCls("windowModal");
						}
					}
				}
			}
			Ext.getCmp('cancelTemplate').show();
			Ext.getCmp('createTemplate').show();
		},
		close: function(win) {
			app.currentWidget = null;
			if (this.modal) {
				var doms = Ext.dom.Query.select('.x-mask');
				for (var key in doms)
				{
					this.dom=doms[key];
					if (!Ext.isEmpty(this.dom.offsetParent))
					{
						if (this.dom.offsetParent.tagName=='BODY')
						{
							Ext.fly(this.dom).removeCls("windowModal");
						}
					}
				}
			}
		},
		afterrender:function(){
			Ext.EventManager.onWindowResize(function()
			{
				var me = this;
				me.center();
			},this);
		}
	},
	autoScroll:false,
	buttonAlign :'center',
	items: [
	{
		xtype:'container',
		id:'createTemplateMain',
		layout:{
			type:'hbox',
		},
		items:[
		{
			xtype:'container',
			layout:'vbox',
			id:'configWindowVbxId',
			align:'center',
			items:[
				{
					xtype:'toolbar',
					width:850,
					margin:'10 0 0 0',
					items:[
					{
						xtype: 'checkbox',
						fieldLabel: 'Enable Multi Measures',
						cls: 'checkbt',
						checked:true,
						margin:10,
						id:'multiMeasure',
						hidden:true,
					}]
				},
				{
					xtype:'reportconfigslider',
				},
				{
					xtype:'reportdataconfiguration'
				},
				{
					xtype:'toolbar',
					align:'stretch',
					width:1010,
					padding:10,
					items:[
						'->',
							{
								xtype: 'button',
								text:'CREATE TEMPLATE',
								disable:true,
								cls: 'buttonNewBig',
								id:'tempCreate',
								name:'tempCreate',
								margin:'0 5 0 5',
								hidden:true
							},
							{
								xtype: 'button',
								text:'Add widget',
								ui:'newButtonMediumBlue',
								scale:'medium',
								id:'addwidget',
								iconCls:'iconAddWidget',
								name:'addwidget',
								margin:'0 5 0 5'
							},
							{
								xtype: 'button',
								text:'UPDATE WIDGET',
								ui:'newButtonMediumBlue',
								id:'addTowidget',
								name:'addTowidget',
								scale:'medium',
								margin:'0 5 0 5',
								hidden:true,
							},
							{
								xtype: 'button',
								text:'Done',
								//ui:'newButtonMediumGray',
								ui:'newButtonMediumBlue',
								id:'addWidgetDone',
								scale:'medium',
								name:'addWidgetDone',
								margin:'0 5 0 5'
							},
						'->',
					]
				}
			]
		}]
	}

	],

});