Ext.define('AddButton', {
	alias: 'plugin.addbutton',
	constructor: function(config) {
		Ext.apply(this, config);
	},
	init: function(tabPanel) {
		var me = this;
		me.tabPanel = tabPanel;
		tabPanel.on({
			render: function() {
				me.tabBar = tabPanel.tabBar;
				me.layout = me.tabBar.layout;
				me.layout.overflowHandler.handleOverflow = Ext.Function.bind(me.showButton, me);
				me.layout.overflowHandler.clearOverflow = Ext.Function.createSequence(me.layout.overflowHandler.clearOverflow, me.hideButton, me);
			},
			single: true
		});
	},

	showButton: function() {
		var me = this,
			result = Ext.getClass(me.layout.overflowHandler).prototype.handleOverflow.apply(me.layout.overflowHandler, arguments);

		if (!me.menuButton) {
			me.menuButton = me.tabBar.body.createChild({
				cls: Ext.baseCSSPrefix + 'tab-tabmenu-right',
			},
			me.tabBar.body.child('.' + Ext.baseCSSPrefix + 'box-scroller-right'));
			me.menuButton.addClsOnOver(Ext.baseCSSPrefix + 'tab-tabmenu-over');
			me.menuButton.addClsOnOver(Ext.baseCSSPrefix + 'tab-tabadd-over');
			me.menuButton.setWidth(26);
			me.menuButton.setHeight(30);
			me.menuButton.setStyle({"float":"left","padding":"8px 4px 4px 4px","display":"block","position":"relative","margin":"0 0 0 5px","border":"0px solid blue"});
			me.menuButton.setHTML('<div class="iconAddTab" style="width:18px;height:18px;border:0px solid red"></div>');
			me.menuButton.on('click', me.addTabs, me);
		}
		me.menuButton.setVisibilityMode(Ext.dom.Element.DISPLAY);
		me.menuButton.show();
		result.reservedSpace += me.menuButton.getWidth()+5;
		return result;
	},
	hideButton: function() {
		var me = this;
		if (me.menuButton) {
			Ext.get('addMoreMes').setStyle({"visibility":"visible"});
			//Ext.get('addMoreMesCont').setStyle({"display":"block"});
			me.menuButton.hide();
		}
	},
});


Ext.define('ReporterTemplate.view.ReporterTemplateTabPane',{
	extend:'Ext.tab.Panel',
	alias:'widget.reportertemplatetabpane',
	id:'reportertemplatetabid',
	activeTab: 0,
	//ui:'newTabPanel staticWidth',
	ui:'newTabPanel',
	border:false,
	frame:false,
	margin:0,
	flex:1,
	scroll:false,
	autoScroll:false,
	widgetConfig:null,
	allTabData:null,
	autoDestroy:false,
	enableTabScroll:true,
	layoutOnTabChange: true,
	plugins: [{
		ptype: 'addbutton',
		addTabs:function(){
			app.appObj.getController(app.appController).addMoreTab();
		}
	}],
	height:330,
	tabBar:
	{
		items:[
		{
			xtype:'container',
			width:24,
			height:30,
			id:'addMoreMesCont',
			padding:'9 0 4 6',
			items:[{
				xtype:'button',
				iconCls: 'iconAddTab',
				id:'addMoreMes',
				name:'addMoreMes',
				dock:'left',
				padding:0,
				margin:'0 0 0 0',
				style:{
					'background':'transparent',
					'border':'0px none transparent',
					'display':'inline-block'
				},
				handler : function(f){
					var btnX = this.getPosition()[0];
					var calculateWidth = ((((Ext.getBody().getViewSize().width)-1020)/2)+612);

					//console.log('btnX----->',btnX);
					//console.log('calculateWidth----->',calculateWidth);
					var totalTab=Ext.getCmp('reportertemplatetabid').items.length;
					if(btnX >= calculateWidth || (totalTab>4 && curChartType != undefined && curChartType== 'multiDigi')){
						Ext.get('addMoreMes').setStyle({"visibility":"hidden"});
						//Ext.get('addMoreMesCont').setStyle({"display":"block"});
					}
				},

				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html:'Add More Measure'
						});
					}
				}
			}]
		}], 
	},

});