Ext.define('ReporterTemplate.view.WidgetListGrid',{
	extend:'utilities.CustomGrid',
	requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy', 'utilities.CustomGrid'],
	alias:'widget.widgetListGrid',
	id:'widgetListGridId',
	//cls:'gridSkin', // noShadow noShadowNoHeader
	ui:'newGridPanel',
	border:true,
	autoScroll: true,
	flex:1,
	frame:false,
	margin:'0 10 10 10',
	scroll: true,
	screenLabels:null,
	dataArray : null,
	dummyArray : null,
	pageLimit:16,
	activePage:1,
	plugins: [{
		ptype: 'rowexpander',
		selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
		expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
		expandOnEnter : false,
		collapsible: true,
		animCollapse: false,
		rowBodyTpl: [
			'<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%">{childInfo}</div>',	
		],
		 lastExpandedRowIdx: null,
		 expandOnlyOne: false,
		// Overwrite RowExpander.toggleRow(rowIdx,record)
		toggleRow: function(rowIdx,record) 
		{
			var row = Ext.get(this.view.getNode(rowIdx));
			if (row.hasCls(this.rowCollapsedCls)) 
			{
				if (this.lastExpandedRowIdx != null && this.expandOnlyOne == true)
				{
					this.collapseRow(this.lastExpandedRowIdx);
				}
				this.expandRow(rowIdx);
				this.lastExpandedRowIdx = rowIdx;
			} 
			else 
			{
				this.collapseRow(rowIdx);
				this.lastExpandedRowIdx = null;
			}
			
		},
		expandRow: function(rowIdx) 
		{
			var view = this.view,
				rowNode = view.getNode(rowIdx),
				row = Ext.get(rowNode),
				nextBd = Ext.get(row).down(this.rowBodyTrSelector),
				record = view.getRecord(rowNode);

			row.removeCls(this.rowCollapsedCls);
			nextBd.removeCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = true;
			view.refreshSize();
			record.set('iconInfo', 'expand');
			view.fireEvent('expandbody', rowNode, record, nextBd.dom);
		},

		collapseRow: function(rowIdx) 
		{
			var view = this.view,
				rowNode = view.getNode(rowIdx),
				row = Ext.get(rowNode),
				nextBd = Ext.get(row).down(this.rowBodyTrSelector),
				record = view.getRecord(rowNode);

			row.addCls(this.rowCollapsedCls);
			nextBd.addCls(this.rowBodyHiddenCls);
			this.recordsExpanded[record.internalId] = false;
			view.refreshSize();
			record.set('iconInfo', 'collapse');
			view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
		}

	}],
	viewConfig: 
	{
		emptyText : '<table width="100%" height="90%" align="center" valign="middle"><tr><td align="center" valign="middle"><div  class="iconExclamation"></div><div class="font_normal11">NO WIDGET CONFIGURED</div></td></tr></table>',
		stripeRows: true,
	},
	initComponent:function()
	{
		var me=this;
		this.selModel  = new Ext.selection.CheckboxModel(
		{
			checkOnly: true,
			injectCheckbox: 'first',
			});

		if(Ext.isEmpty(this.dataArray))
			this.dataArray=[];
		this.dummyArray=this.dataArray.slice();
		this.store = Ext.create('Ext.data.Store', 
		{
			proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'json'
				}
			},
			pageSize:this.pageLimit,
			autoLoad : true,
			data : this.dataArray,
			fields: [{name:'widgetName'},{name:'widgetSource'},{name:'chartType'},{name:'panelId'},{name:'childInfo'},{name:'iconInfo'}],
			id: 'tmpStore'
		});
		this.columns = [
			{
				text : 'WIDGET NAME',
				dataIndex : 'widgetName',
				flex : 1.2,
				sortable :false,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					metaData.style = 'cursor: pointer;';
					var dispVal = value;
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					if(record.data.iconInfo == 'expand')
					{
						dispVal = '<table cellpadding="0" cellspacing="0" border="0px"><tr><td style="float:left;margin-right:5px;margin-top:1px;" class="iconPanelDownArrow"></td><td class="font_normal11" style="padding-top:1px;">'+dispVal+'</td></tr></table>';
					}

					return dispVal;
				},
				listeners :
				{
					'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
					{
						Ext.getCmp('widgetListGridId').plugins[0].toggleRow(index);
						/*
							var rowExpander = grid.getPlugin( pluginId );
							var rowNode = grid.getView().getNode(rowIdx);
							var row = Ext.fly(rowNode, '_rowExpander');
							var isCollapsed = row.hasCls(rowExpander.rowCollapsedCls);
						*/
					}
				}
			},
			{
				text : 'WIDGET SOURCE',
				dataIndex : 'widgetSource',
				flex : 1,
				sortable :false,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					var dispVal = value;
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				},
			},
			{
				text : 'CHART TYPE',
				dataIndex : 'chartType',
				flex : 1,
				sortable :true,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					var dispVal = value;
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				},
			},
			{
				xtype : 'actioncolumn',
				dataIndex : 'modifyWidget',//..
				renderer: function(value, metaData) {
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Modify  Widget" ';
					return value;
				},
				width : 40,
				items : [
					{
						iconCls:'iconModify',
						handler : function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							if (!Ext.isEmpty(Ext.getCmp('reportdataconfigwindowid')))
								Ext.getCmp('reportdataconfigwindowid').doClose();
							app.appObj.getController(app.appController).onClickWidgetModify(Ext.getCmp(record.data.panelId) );
						}
					}
				]
			},
			{
				header: '<div style="margin-left: 5px;margin-top: 1px;cursor:pointer" id="removeAllWidget" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
				xtype : 'actioncolumn',
				sortable :false,
				dataIndex : 'removeWidget',//..
				renderer: function(value, metaData) {
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Remove Widget" ';
					return value;
				},
				width : 40,
				items : [
					{
						iconCls:'iconDeleteReportTemplate',
						handler : function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							Ext.Msg.show({
								title : 'eG custom report',
								msg : 'Do you want to remove the widget?',
								cls:'egMsgBox',
								buttons : Ext.Msg.YESNO,
								icon : Ext.Msg.QUESTION,
								fn : function(buttonVal)
								{
									if (buttonVal == "yes")
									{
										var panelId = record.data.panelId
										var renderto_id = panelId;
										needWidgetCloseAlert = false;
										console.log(Ext.getCmp(panelId))
										app.appObj.getController(app.appController).updateChartCountCircle(Ext.getCmp(panelId).chartType,false);
										Ext.getCmp(panelId).panelClose = true;
										Ext.getCmp('reportergridstackpanel')._removeWidget(panelId);
										grid.getStore().remove(record);
										if(isEditTemplate)
											app.appObj.getController(app.appController).addWidgetDone();
									}
								}
							});
						}

					}
				]
			}
		];
		var meGrid = this;
		this.dockedItems=[
		{
			xtype:'pagingtoolbar',
			//cls:'pagingtoolbar',
			cls:'newPagination',
			dock: 'bottom',
			displayInfo: true,
			id:'widgetListPaging',
			name:'widgetListPaging',
			pageSize:this.pageLimit,
			store: this.store,
			displayMsg: 'Displaying widget {0} - {1} of {2}',
			emptyMsg: "No widget to display",
			listeners: {
				change : function(thisd, params)
				{
					if(!Ext.isEmpty(params))
						meGrid.activePage = params.currentPage;
					else
						meGrid.activePage=0;
				}
			}
		}]
		this.callParent();
	},
	listeners:{
		sortchange:function(ct, column, e, t, eOpts ){
			 this.getStore().loadPage(this.activePage);
		},
		afterrender: function (grid) 
		{
			var columnId = this.plugins[0].getHeaderId();
			Ext.getCmp(columnId).hide();
		}
	}
});
