Ext.define('RumComparisonApp.controller.RumComparisonReportController',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'usertimeline',ref:'usertimeline'},
		{selector: 'RumComparisonReportsForm',ref: 'RumComparisonReportsForm'},
		{selector: 'egcomponent',ref: 'egcomponent'},
		{selector: 'mainform',ref: 'mainform'},
		{selector: 'RCReportsFormSettings',ref: 'RCReportsFormSettings'},
		{selector: 'reporterdata',ref:'reporterdata'},
 		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({
			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.afterMainRender,
				'boxready':this.refreshReportData
			},
           	'RCReportsFormSettings':{
				'afterrender':this.loadSettingsElements
            },
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'mainform combo[name="select_farm"]':{
				'select': this.zoneOnChange
			},
			'mainform combo[name="rep_genType"]':{
				'select': this.Changerep_genType
			},
			'mainform combo[name="er_type"]':{
				'select': this.reportTypeOnChange
			},
			'mainform combo[name="er_graphType"]':{
				'select': this.graphTypeOnChange
			},
			'mainform combo[name="er_server"]':{
				'select': this.serverOnChange
			},
			'mainform button[id="InfoexpandSelector"]': {
                'click': this.expandMe
            },
			'mainform button[id="expandSelector1"]': {
                'click': this.expandMe
            },
			'mainform button[id="expandSelector"]': {
                'click': this.expandMe
            },
			'mainform combo[name="er_compType"]':{
				'select': this.compTypeOnChange
			},
			'mainform combo[name="er_wrkrGrp"]':{
				'select': this.workerGroupOnChange
			},
			/* 'RCReportsFormSettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},*/
			'RumComparisonReportsForm combo[name="duration"]':{
				'select': this.RefreshEvent
			},
			'RCReportsFormSettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'RCReportsFormSettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndUpdateSettings
			},
			'RCReportsFormSettings button[id="submitViaSetting"]':{
				'click': this.closeAndUpdateSettings
			},
			'RumComparisonReportsForm button[itemId="submit"]':{
				'click': this.showResult
			},
			'mainform button[itemId="save"]': {
					"click": this.goTo
			},
			'mainform combo[name="er_organize"]':{
				'select': this.organizeOnChange
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'mainform trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'graphpopup': {
                'render': this.drilldownResize
            },
			 'graphpopup button[name="DrillDownsubmit"]': {
                'click': this.submitDrillDown
            },
			 'graphpopup combo[name="timeLineDrillDown"]': {
                'select': this.drillDownTimeOnchange
            },
			'drilldowntools button[id="print"]': {
                'click': this.drillDownPrint
            },		
			'drilldowntools > #dataTool > button': {
                'click': this.drillDownData
            },
			'drilldowntools > #saveToolDrill > button': {
                'click': this.drillDownSave
            },
			 'drilldowntools button[id="mail"]': {
                'click': this.drillDownMail
            },
			
		});
	},
	
	drilldownResize: function (panel) {
        Ext.EventManager.onWindowResize(function () {
            panel.doComponentLayout();
        });
    },
	updateDrillDownQueryString:function(){
		var queryStringWithoutDate=appConstants.DrillDownQueryStringGlobal;
		queryStringWithoutDate=queryStringWithoutDate.substring(queryStringWithoutDate.indexOf("?")+1);
		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('startdateDrillDown').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('enddateDrillDown').getValue(), mgrDateFormat);
		var timelineParams='&er_timeline='+Ext.getCmp('timeLineDrillDown').getValue()+'&startdate='+startDateConverted+'&enddate='+endDateConverted+'&starthr='+Ext.getCmp('startHourDrillDown').getValue()+'&endhr='+Ext.getCmp('endHourDrillDown').getValue();
		appConstants.DrillDownQueryStringGlobalWithDate=queryStringWithoutDate+timelineParams;		
	},
	 submitDrillDown: function () {
        this.updateDrillDownQueryString();
        var Qstring=appConstants.DrillDownQueryStringGlobalWithDate+'&drillDownSubmitButtonClick=yes';
        var timelineDrill = Ext.getCmp('timeLineDrillDown').getValue();
        if (timelineDrill == 'Any') {
            var stDateTime = Ext.getCmp('startdateDrillDown').getValue();
            var tmpStartHour = Ext.getCmp('startHourDrillDown').getValue();
            stDateTime.setHours(tmpStartHour);
            var enDateTime = Ext.getCmp('enddateDrillDown').getValue();
            var tmpEndHour = Ext.getCmp('endHourDrillDown').getValue();
            enDateTime.setHours(tmpEndHour);
            if (stDateTime > enDateTime) {
                Ext.MessageBox.show({
                    title: 'Rum Reports',
                    msg: dateValidateError,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
            }
        }
        Ext.Ajax.request({
            url: '/final/servlet/com.eg.ErRumComparisonServletC',
            params: Qstring,
            method: 'POST',
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.DrillDownPublicJsonData = jsonData;
				var chartData=appConstants.DrillDownPublicJsonData.Results.chartData;
				if(chartData != undefined)
				{
					reportForHighChart('drilldownChartDiv',chartData);			
				}
				else
				{
					Ext.get('drilldownChartDiv').update('<center> <table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table></center>');
				}                
            }
        });
    },
	drillDownTimeOnchange: function () {
		var startDateObj = Ext.getCmp('startdateDrillDown');
		var startHrObj = Ext.getCmp('startHourDrillDown');
		var endDateObj = Ext.getCmp('enddateDrillDown');
		var endHrObj = Ext.getCmp('endHourDrillDown');
		var timelineVal = Ext.getCmp('timeLineDrillDown').getValue();
		var drillDownQueryString=appConstants.DrillDownQueryStringGlobal;
		drillDownQueryString=drillDownQueryString.substring(drillDownQueryString.indexOf("?")+1);
		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('startdateDrillDown').getValue(), mgrDateFormat);
        var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('enddateDrillDown').getValue(), mgrDateFormat);
		var timelineParams='&er_timeline='+Ext.getCmp('timeLineDrillDown').getValue()+'&startdate='+startDateConverted+'&enddate='+endDateConverted+'&starthr='+Ext.getCmp('startHourDrillDown').getValue()+'&endhr='+Ext.getCmp('endHourDrillDown').getValue();
        var Qstring=drillDownQueryString+timelineParams+'&drillDownSubmitButtonClick=yes';	

		if (timelineVal == 'Any') {
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		} else {
			Ext.Ajax.request({
				url: '/final/reporter/ErRumComparisonReportJson.jsp',
				params: Qstring,
				method: 'POST',
				scope: this,
				success: function (response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.DrillDownPublicJsonData = jsonData;
					var start_hour = jsonData.startHourForDisplay;
					var end_hour = jsonData.endHourForDisplay;
					var start_date = jsonData.startDate;
					var end_date = jsonData.endDate;
					startDateObj.setDisabled(true);
					startHrObj.setDisabled(true);
					endDateObj.setDisabled(true);
					endHrObj.setDisabled(true);
					startDateObj.setValue(start_date);
					startHrObj.setValue(start_hour);
					endDateObj.setValue(end_date);
					endHrObj.setValue(end_hour);
				}
			});
		}
	},
	RefreshEvent:function()
	{
		var me=this;
		var urlForAjax="/final/reporter/ErRumComparisonReportJson.jsp";
		initLdgMask.show();
		this.updateQStringActivity();
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				appConstants.publicjsonDataActivity=jsonData;
				me.fillFormFieldsForActivity(jsonData);
				Ext.getCmp('resultPanel').hide();
				initLdgMask.hide();
			}
		});
	},
	Changerep_genType:function(obj)
	{
			appConstants.erGraphType=obj.getValue();
			if(!Ext.isEmpty(appConstants.publicjsonDataActivity))
				this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
	},
	goTo: function (btn) {
 		var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;		
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			this.saveFavorite(btn);
		}
	},
	changeEr_mode: function (combo) {
		var favorite_id= appConstants.publicjsonDataActivity['hiddens']["favorite_id"];
		var from_schModify=appConstants.publicjsonDataActivity['hiddens']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
            duration: 250,
            to: {
                y: -530
            }
        });
		this.showResult();
    },
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
	   appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_server'),appConstants.rawDataForComponents);
    },
	organizeOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
	},
	compTypeOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var urlForAjax="/final/reporter/ErRumComparisonReportJson.jsp";
		urlForAjax=urlForAjax+"?select_farm="+mainForm.findField("select_farm").getValue()+"&er_comptype="+mainForm.findField("er_compType").getValue();
		this.updateQStringActivity();
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				appConstants.publicjsonDataActivity=jsonData
				if(mainForm.findField('er_type').getValue() == 'No'){
					comboRawData=jsonData.serverCombo;
					selectedComboOption=jsonData.selectedServer;
					comboObject=Ext.getCmp('er_server');
					appConstants.rawDataForComponents = comboRawData;
					comboObject.getStore().clearFilter(true); 
					comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
						if(comboRawData[0].valueField!=-1)
							comboObject.setValue(comboRawData[0].valueField);
						else
							comboObject.setValue(comboRawData[1].valueField);
					}
				}else{
					if(!isSettingsEnabled)
						this.showConfigDropdown();
					var thinclientuserSettingsForm = this.getRCReportsFormSettings().getForm();
					var graphval=jsonData.selectedGraphType;
					comboRawData = jsonData.graphTypeArray;
					selectedComboOption = jsonData.selectedGraphType;
					comboObject = mainForm.findField("er_graphType");
					comboObject.setFieldLabel(screenLabels["reporter.thin.Graph Type"]);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.hide();
					if (graphval == "timeline") {
						comboRawData = jsonData.aggbasedOn;
						selectedComboOption = jsonData.selectedAgg;
						comboObject = thinclientuserSettingsForm.findField("er_perserver");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Aggregate across servers"]);
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();	
					}
				}
			}
		});
	},
	workerGroupOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var urlForAjax;
		
	},
	zoneOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var urlForAjax="/final/reporter/ErRumComparisonReportJson.jsp";		
		var QString="";		
		this.updateQStringActivity();
		QString=appConstants.queryStringActivity;
			var me=this;
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : QString,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				if(!Ext.isEmpty(jsonText))
				{
					var jsonData=Ext.decode(jsonText);
					me.fillFormFieldsForActivity(jsonData);			
				}
			}
		});		
		appConstants.isLoad=true;
	},
	 expandMe: function (btn) {
		
		var idName="";
		var lblId="";
		var id=btn.getItemId();
		
		if(id=="InfoexpandSelector")
		{
			idName="info_Val";
			lblId="infoLbl";
		}else if(id=="expandSelector1")
		{
			idName="select_farm";
			lblId="siteLbl";
		}
		else
		{
			idName="er_server";
			lblId="compLbl";
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp(idName),Ext.getCmp(lblId).text,btn);
	},
	serverOnChange:function(){
		
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var thinclientuserSettingsForm = this.getRCReportsFormSettings().getForm();
		var s_server=Ext.getCmp('er_server').getValue();
		var s_repType=mainForm.findField('er_type').getValue();
		var me=this;
		initLdgMask.show();
		this.updateQStringActivity();
		var url1="/final/reporter/ErRumComparisonReportJson.jsp";
		Ext.Ajax.request(
		{
			url : url1,
			params : appConstants.queryStringActivity+"&changeInfoVal=true",
			scope:this,
			method : 'POST',
			success: function(response){

				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				
				me.fillFormFieldsForActivity(jsonData);
				initLdgMask.hide();
			}
		});		
	},
	graphTypeOnChange:function(obj){
		var val=obj.getValue();		
		if(val=='timeline')
		{
			Ext.getCmp('showLegend').show();
		}
		else
		{
			Ext.getCmp('showLegend').show();
		}

		Ext.getCmp('resultPanel').hide();
		this.updateQStringActivity();
		var url1="/final/reporter/ErRumComparisonReportJson.jsp";
		
		Ext.Ajax.request(
		{
			url : url1,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				if(!isSettingsEnabled)
					this.showConfigDropdown();
				var mainForm =Ext.getCmp('mainform').getForm();
				var thinclientuserSettingsForm = this.getRCReportsFormSettings().getForm();
				Ext.getCmp('showLegend').hide();
				if(Ext.getCmp("er_perserver")!=undefined)
					Ext.getCmp('er_perserver').hide();
			}
		});
	},
	reportTypeOnChange:function(obj){
		initLdgMask.show();
		Ext.getCmp('resultPanel').hide();
		Ext.getCmp('showLegend').hide();
		var val=obj.getValue();
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm = this.getRCReportsFormSettings().getForm();
        this.updateQStringActivity();
		var urlStr="/final/reporter/ErRumComparisonReportJson.jsp";		
			
		var url = urlStr+"?er_type="+mainForm.findField("er_type").getValue();
		if(val == 'Yes'){	
			url+="&graphViewtype="+mainForm.findField('er_graphType').getValue();		
       	}else{	
			url += "&er_comptype=" + mainForm.findField('er_compType').getValue();
		}
		Ext.Ajax.request(
		{
			url : url,
      		params: appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				appConstants.publicjsonDataActivity=jsonData;
				
				if(val == 'No'){					
					mainForm.findField('er_mode').hide();
					mainForm.findField('er_graphType').hide();
					comboRawData=jsonData.serverCombo;
					selectedComboOption=jsonData.selectedServer;
					comboObject=Ext.getCmp('er_server');
					multiServerObject=Ext.getCmp('expandSelector');
					appConstants.rawDataForComponents = comboRawData;
					comboObject.getStore().clearFilter(true); 
//					comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					multiServerObject.show();
					comboObject.show();

					if(selectedComboOption !=null  && selectedComboOption.indexOf("All ")>-1)
						thinclientuserSettingsForm.findField('er_perserver').show();
					//if(!(val=="No"))
					{					
						comboRawData=jsonData.priorityCombo;
						selectedComboOption=jsonData.selectedPriority;
						comboObject=mainForm.findField('er_priority');
						comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[2].valueField);
						}						
						comboObject.hide();
					}					
				}
				else{
					//Ext.getCmp('serverMultiSelectLbl').hide();
					mainForm.findField('er_priority').show();
					thinclientuserSettingsForm.findField('er_perserver').hide();
					mainForm.findField('er_mode').hide();				
					var graphval=jsonData.selectedGraphType;
					comboRawData = jsonData.graphTypeArray;
					selectedComboOption = jsonData.selectedGraphType;
					comboObject = mainForm.findField("er_graphType");
					comboObject.setFieldLabel(screenLabels["reporter.thin.Graph Type"]);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}				
						
					//if(!(val=="No"))
					{						
						comboRawData=jsonData.priorityCombo;			
						selectedComboOption=jsonData.selectedPriority;
						comboObject=mainForm.findField('er_priority');
						comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
						if(!Ext.isEmpty(comboRawData))
						{
							comboObject.getStore().loadRawData(comboRawData);
							if ( !Ext.isEmpty(selectedComboOption) ){
								comboObject.setValue(selectedComboOption);
							}
							else{
								comboObject.setValue(comboRawData[0].valueField);
							}								
							comboObject.hide();
						}
					}

					if (graphval == "timeline") {
						comboRawData = jsonData.aggbasedOn;
						selectedComboOption = jsonData.selectedAgg;
						comboObject = thinclientuserSettingsForm.findField("er_perserver");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Aggregate across servers"]);
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}else{
						thinclientuserSettingsForm.findField('er_perserver').hide();
					}
				}
				initLdgMask.hide();
			}
		});
	},	
	saveReportAsPDF:function(){
		var saveQString;
		saveQString=appConstants.publicjsonDataActivity.saveQString;
		saveQString+="&printGraph=yes&opt=chart";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			saveQString+="&er_view=PRINT";		
		
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString;
		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		s_qryString=this.getGridColSortParam(s_qryString);
		appConstants.erUtils.savePDF(s_qryString);
	},
	drillDownSave: function () {
	  var s_qryString;		
		var saveQString=appConstants.DrillDownQueryStringGlobalWithDate;
		s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString;
		//if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			s_qryString+="&er_view=PRINT&drillSes=yes";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);

	},
	bookletQuery: function(obj)
	{
		var saveQString;
		saveQString=appConstants.publicjsonDataActivity.saveQString;
		saveQString+="&printGraph=yes&opt=chart";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			saveQString+="&er_view=PRINT";		
		var s_qryString = saveQString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryStringActivity;
		var rtype=Ext.getCmp('er_type').getValue();
		if(rtype == 'Yes'){
			s_qryString+="&er_perserver=Yes";
		}
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);

			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}
		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	printReport:function(){

		var s_qryString;
		
		var saveQString=appConstants.publicjsonDataActivity.saveQString;
		s_qryString = "../servlet/com.eg.ErRumComparisonServletC?"+saveQString+"&printGraph=yes&pdfPrint=yes";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			s_qryString+="&er_view=PRINT";
		s_qryString=this.getGridColSortParam(s_qryString);
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in 
	},	
	drillDownPrint: function () {
      var s_qryString;		
		var saveQString=appConstants.DrillDownQueryStringGlobalWithDate;
		s_qryString = "../servlet/com.eg.ErRumComparisonServletC?"+saveQString+"&pdfPrint=yes";
		s_qryString+="&er_view=PRINT";
		parent.printWindowFn(s_qryString);
    
    },		
	drillDownData: function () {
      var s_qryString;		
		var saveQString=appConstants.DrillDownQueryStringGlobalWithDate;
		s_qryString = "../servlet/com.eg.ErRumComparisonServletC?"+saveQString+"&pdfPrint=yes";
		s_qryString+="&er_view=PRINT&data=yes";
		parent.dataWindowFn(s_qryString);    
    },		
	sendMail:function(){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	
	 drillDownMail: function () {
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(btn){
		var isValid = this.validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'RUM Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}
		if(isValid){
			var s_qryString;
			
				this.updateQStringActivity();
				var rtype=Ext.getCmp('er_type').getValue();
				if(rtype == 'Yes'){
					s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;
					s_qryString+="&er_perserver=Yes";
				}
				else{
					s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;
				}		
			
			var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			if (btn.getItemId()=='save'){
				document.location=target+'&showSchWindow=no';
			}
			else{
				parent.scheduleWindowFn(target);
			}
		}		
	},
	saveFavorite:function(btn){
		var isValid = this.validateMainForm(false);
		var favorite_id ="";
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'RUM Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		if(isValid){
			var s_qryString;
		
				var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
				favorite_id = hiddenFields["favorite_id"];
				this.updateQStringActivity();
				var rtype=Ext.getCmp('er_type').getValue();
				if(rtype == 'Yes'){
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";

				}
				else{
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";
				}
			
			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//+"&FavoriteId="+favorite_id;
			if (btn.getItemId()=='save')
				document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
			else
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm =null;
		
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getRCReportsFormSettings().getForm();
		var zone=mainForm.findField('select_farm')
		var reportType=mainForm.findField('er_type').getValue();
			if(zone.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'RUM Report',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
			
			var server=Ext.getCmp('er_server');
			
			if( server.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'RUM Report',
				msg: server.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}			
				
				
		
		var isSettingsOk = true;

		var hiddenFields;
		hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;

		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen = this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var er_usertimeline = '';
		if ( !Ext.isEmpty(hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');


		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){

			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);

		if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'RUM Report settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = hiddenFields["limitforbg"];

				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else{
			var reportName = this.getSettingsFieldValue(thinclientuserSettingsForm,'bgReportName',isSettingsEnabled,'selectedMinsTo');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
        var starthr = mainForm.findField('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = mainForm.findField('er_enddate').getValue();
        var endhr = mainForm.findField('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var server=Ext.getCmp('er_server');
		var isValid = this.validateMainForm(true);

		
		if(isValid)
			this.submitReport();
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && reportgen == 'background' ) {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		if(Ext.getCmp('ApdexFieldId')!=undefined)
		{
			var upperminor = Ext.getCmp('upperminor').getValue();
			var uppermajor = Ext.getCmp('uppermajor').getValue();
			var upperCritical = Ext.getCmp('upperCritical').getValue();
					
			if(uppermajor < upperCritical || upperminor < upperCritical || uppermajor < upperCritical)
			{
				Ext.MessageBox.show({
					title: 'RUM Report',
					msg: 'Invalid Input',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
 			this.submitReport();
		}else{
			
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			
				Ext.get("configMod").animate({
					to: {
						"top": 45
					},
					listeners: {
						afteranimate: function () {
							Ext.get("configMod").setStyle("left", "");
						}
					}
				}).show();
			
			var thinclientuserSettingsForm = this.getRCReportsFormSettings().getForm();
			var reportGenType=thinclientuserSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientuserSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},	
	submitReport:function(){
		initLdgMask.show();
		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var thinclientuserSettingsForm = this.getRCReportsFormSettings().getForm();
 		var reportGeneration= this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var reportType='';
		var url;
		var backgroundUrl;
		var Qstring;
		var dataAvailable=false;
		var mainForm =Ext.getCmp('mainform').getForm();		
		var rtype=mainForm.findField('er_type').getValue();
		var graphType=mainForm.findField('er_graphType').getValue()
		
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		if(rtype == 'No'){					
			Ext.getCmp('showLegend').hide();				
		}
		this.updateQStringActivity();
		Qstring=appConstants.queryStringActivity;
		backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";		
		url="../servlet/com.eg.ErRumComparisonServletC"			
 		Qstring+= '&er_RmDispName='+appConstants.er_RmDispName+'&isSubmit=true&responseType=json';	
 		
 		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		resultPanelObj.removeAll();
	
		if(reportGeneration == 'foreground'){
 			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);		
						appConstants.publicjsonDataActivity=jsonData;					
						this.loadJsScriptReportData(jsonData);
				}
			});
		}
		else if(reportGeneration == 'background'){
			resultPanelObj.hide();
			var me=this;
 			var htmlStr = '';
			initLdgMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
 				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+backgroundAnchor+'</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+backgroundAnchor+'</a></div></td></tr></table></td></tr></table>';

						}
					}
					else
					{
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td>Error In BackGround Generation</td></tr></table></td></tr></table>';
					}
  					me.getBackGroundPanel().update(htmlStr);
 					me.getBackGroundPanel().show();
					initLdgMask.hide();
				}
			});
		}
	},
	loadJsScriptReportData:function(jsonData)
	{		
		var me=this;
		var resultPanelObj=Ext.getCmp('resultPanel');
		var itemsArray=new Array();
		var GridData=jsonData.Results;
		if ( !Ext.isEmpty( GridData ) ){
			var gridDataObj=GridData;
			var columnDetails=gridDataObj.gridColumns;
			var dataArraytoStore=gridDataObj.gridData;
			var noOfColumns=gridDataObj.TOTAL_COLUMN_COUNT;
			var singleColumnCount=gridDataObj.SINGLE_SUBCOLUMN_COUNT;
			var queryString=gridDataObj.queryString;
			var queryStringDrillDown=gridDataObj.queryStringDrillDown;
			var viewPortWidth=this.getMain().getWidth();
			var COLUMN_MIN_WIDTH=75;
			var SINGLE_COLUMN_WIDTH=80;
			var SERVER_MIN_WIDTH=120;
			var mutipleColumns=noOfColumns-singleColumnCount;
			var widthNeeded=150+(mutipleColumns*COLUMN_MIN_WIDTH)+(singleColumnCount*SINGLE_COLUMN_WIDTH);
			var eachColnIncreaseWidth=0
			var fieldstoStore =new Array();
			var cnt=0;
			
			var alignVal="left";
			var mainColumnsObjArray	=  new Array();
			var eachWidth=0;
			if(viewPortWidth>widthNeeded){
				eachWidth=(viewPortWidth+SERVER_MIN_WIDTH)/noOfColumns;
				eachColnIncreaseWidth=(SERVER_MIN_WIDTH+25)/(noOfColumns-1);
			}
			else{
				eachWidth=COLUMN_MIN_WIDTH;
			}
			var colLengths=columnDetails.length;
			var adjustWidth=eachWidth;
			for( var key in columnDetails ){
				
				var mainColumn=columnDetails[key];
				if(colLengths>8 && cnt==0)
				{	
					adjustWidth=200;
				}else if(colLengths>8 && cnt!=0)
				{
					alignVal="center";
					adjustWidth=120;
				}else if(cnt==0)
				{
					adjustWidth=eachWidth;
				} else
				{
					alignVal="center";
					adjustWidth=eachWidth-eachColnIncreaseWidth;
				}	
				var isLocked = false;
				if(key == 0)
					isLocked = true;
				mainColumnsObjArray.push({
					header: mainColumn,
					sortable:true,
					dataIndex: mainColumn,
					align:alignVal,
					locked:isLocked,
					width:adjustWidth,
					//flex:1,
					tdCls: 'wrap',	
					doSort: function(state) {
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2){
								v1 = v1.get(field);
								v2 = v2.get(field);
								v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
								v1= isNaN(v1) ? 0 : v1;
								v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
								v2= isNaN(v2) ? 0 : v2;
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					},
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						if(value.indexOf('~')>-1)
						{
							var text = value.substring( 0, value.indexOf('~') );
							var orgText = text;	
							
							var url = value.substring( value.indexOf('~') + 1 );
							value = '<div align="left"><a  class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:loadChartFunction(\''+text+'__'+url+'\')">'+text+'</a></div>';
						}						
						else if(value.indexOf('$')>-1)
						{
							var text = value.split('$');
							metaData.tdCls='iconColumn';
							var bgColr=text[1];
							var dateStr;
							var ddLink=false;
							if(bgColr.indexOf('_DDLink')>-1)
							{
								dateStr=bgColr.substring(bgColr.indexOf('_DDLink')+7);
								bgColr=bgColr.substring(0,bgColr.indexOf('_DDLink'));								
								ddLink=true;
							}
							if(ddLink)
							{
								//queryString+='&drillDownRum=yes&dateStr='+dateStr;
								value='<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:loadChartDrillDownFunction(\''+queryStringDrillDown+'&drillDownRum=yes&dateStr='+dateStr+'\',\''+queryString+'&drillDownRum=yes&dateStr='+dateStr+'\')">';
								value+="<div style='position:relative;margin:0px auto 0px auto !important; width:50px;height:16px;color:#ffffff;border-radius:2px;background:"+bgColr+";'>"+Ext.getCmp('gridId').getDecimalAlignFormat(text[0])+"<div/></a>";
							}
							else
								value="<div style='position:relative;margin:0px auto 0px auto !important; width:50px;height:16px;color:#ffffff;border-radius:2px;background:"+bgColr+";'>"+Ext.getCmp('gridId').getDecimalAlignFormat(text[0])+"<div/>";
							value = Ext.getCmp('gridId').getDecimalAlignFormat(value);							
						}
						else if(value.indexOf('_DDLink')>-1)
						{
							var text=value.substring(0,value.indexOf('_DDLink'));							
							//queryString+='&drillDownRum=yes&dateStr='+value.substring(value.indexOf('_DDLink')+7);
							var dateStr=value.substring(value.indexOf('_DDLink')+7);
							value='<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:loadChartDrillDownFunction(\''+queryStringDrillDown+'&drillDownRum=yes&dateStr='+dateStr+'\',\''+queryString+'&drillDownRum=yes&dateStr='+dateStr+'\')">'+Ext.getCmp('gridId').getDecimalAlignFormat(text)+'</a></div>';
						}
						
						value = Ext.getCmp('gridId').getDecimalAlignFormat(value);
						return value;
					}
				});
				cnt++;	
			}
			
			var rowspan=false;
			
 			if (isSettingsEnabled)
			{
				var er_perserverObj=Ext.getCmp('er_perserver');
				if(er_perserverObj.getValue()=='No')
					rowspan=true;
			}
			else
			{
					
			}

			var isPagingHidden;
			if (dataArraytoStore.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;			
		
			var storeObj = Ext.create('Ext.data.Store', {
				fields: columnDetails,
				proxy : {
						type : 'pagingmemory',
						reader : {
							type: 'json'
						}						
					},
				data:dataArraytoStore,
				pageSize:gridPageSize,	
				autoLoad : true,
			});
			resultPanelObj.setTitle(gridDataObj.gridTitle);
			var gridpanel = Ext.widget('customgrid',{
				store:storeObj,
				sortableColumns:true,
				//needtoFixColumn:true,
				//cls:'gridSkin horizontal-scroll',
				ui:'newGridPanel',
				border:true,
				id:'gridId',
				columns:mainColumnsObjArray,
				rowspan:rowspan,
				margin:'0 10 10 10',
				//title:'<span class="font_bold">'+gridDataObj.gridTitle+'</span>',
				listeners:{
					sortchange:function(ct, column, e, t, eOpts ){
						me.gridColIndexParam=column.getIndex();
						me.gridColStateParam=column.sortState;
					},
					render:function(obj){
						/*Ext.defer(function() {
							obj.columns[0].setSortState("ASC",true,true);
						},100);*/
					}					
				},
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					displayInfo: true,
					store: storeObj,
					hidden:isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
				}]
			});
			itemsArray.push(gridpanel);

		//	Ext.getCmp("csvTool").setDisabled(true);
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			
			Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
			
			resultPanelObj.removeAll();
			resultPanelObj.add(itemsArray);
			resultPanelObj.show();
			this.getNomeasurepanel().hide();
			
		}else
		{
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);			
			//Ext.getCmp("csvTool").setDisabled(true);
			
			this.disableTools();
			resultPanelObj.hide();
 			this.getNomeasurepanel().show();			
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
		}
		initLdgMask.hide();	
	},

	 showDrillDown: function (QueryStringWithoutDate,QueryString) {
		   appConstants.DrillDownQueryStringGlobal=QueryStringWithoutDate.substring(QueryStringWithoutDate.indexOf("?")+1);
            var drillDownURL = QueryString.substring(0,QueryString.indexOf("?"));
			QueryString=QueryString.substring(QueryString.indexOf("?")+1);
            var htmlstr1 = '<div id="drilldownChartDiv" style="overflow:auto;height:370px;padding:10px;align:center;valign:middle"></div>';
            Ext.Ajax.request({
                url: drillDownURL,
                params: QueryString,
                method: 'POST',
                async: false,
                success: function (response) {
                    var jsonText = response.responseText;
                    if (response.status == 200) {
                        appConstants.DrillDownPublicJsonData = Ext.decode(jsonText);
                    }
                },
                failure: function () {
                    alert('failure calling...');
                }
            });
			var otherInfo=appConstants.DrillDownPublicJsonData.Results.otherInfo;
			var chartData=appConstants.DrillDownPublicJsonData.Results.chartData;
			var isAnySelected = true;
			if (Ext.getCmp('er_timeline').getValue() == 'Any') {
				isAnySelected = false;
			}

			var graphpopup=Ext.widget('graphpopup');
			graphpopup.add({
				xtype: 'panel',
				ui:'newFormFieldsInPopup popupHeaderBottomBorder',
				margin:5,
				frame:false,
				closable:false,
				scroll:false,
				autoScroll:false,
				height:520,
				closeAction:'destroy',
				//title: appConstants.DrillDownPublicJsonData.reportTitle,
				title:otherInfo['title'],
				hidden: false,
				layout: {type:'vbox',align:'stretch'},
				tools: [{xtype: 'drilldowntools'}],
				items: [
							{
								xtype: 'form',
 								layout: 'column',
								//cls:'formOuter',
								ui:'newFormPanelForWindow',
								bodyPadding:10,
								margin: '5 10 0 10',
								defaults: {
									margin: '0 20 10 0',
									labelAlign: 'top'
								},
								items: [
									{
										fieldLabel: timelineLbl,
										xtype: 'scrollcombo',
										id: 'timeLineDrillDown',
										name: 'timeLineDrillDown',
										displayField: 'displayField',
										valueField: 'valueField',
										labelSeparator: '',
										queryMode: 'local',
										store: Ext.getCmp('er_timeline').getStore(),
										value:otherInfo['drillDownTimeline'],
										width: 90,
										cls: 'dropdown'
									}, {
										xtype: 'datepicker',
										id: 'startdateDrillDown',
										name: 'startdateDrillDown',
										format: mgrDateFormat,
										fieldLabel: fromLbl,
										cls: 'datepicker',
										value:otherInfo['userStartDate'],
										width: 100,
										labelSeparator: '',
										disabled: isAnySelected
									}, {
										xtype: 'scrollcombo',
										width: 45,
										id: 'startHourDrillDown',
										name: 'startHourDrillDown',
										store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
										value:otherInfo['userStHour'],
										queryMode: 'local',
										fieldLabel: hrLbl,
										cls: 'dropdown',
										labelSeparator: '',
										disabled: isAnySelected

									}, {
										xtype: 'datepicker',
										id: 'enddateDrillDown',
										name: 'enddateDrillDown',
										format: mgrDateFormat,
										fieldLabel: Tolbl,
										cls: 'datepicker',
										width: 100,
										labelSeparator: '',
										disabled: isAnySelected,
										value:otherInfo['userEndDate']
									}, {
										xtype: 'scrollcombo',
										width: 45,

										fieldLabel: hrLbl,
										cls: 'dropdown',
										id: 'endHourDrillDown',
										name: 'endHourDrillDown',
										labelSeparator: '',
										store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
										value:otherInfo['userEndHour'],
										queryMode: 'local',
										labelSeparator: '',
										disabled: isAnySelected
									},
									{
										xtype: 'button',
										text: submitValue,
										ui:'newButtonSmall',
										name: 'DrillDownsubmit',
										margin: '20 0 0 0'
									}
								]
							},							
							{
									xtype: 'panel',
									ui:'newGraphPanelForWindow',
									id: "drillDownResultPanel",								
									margin:'10 0 20 0',
									layout:'fit',
									//title:appConstants.DrillDownPublicJsonData.chartTitle,
									html: htmlstr1
							}
						],
						listeners:{
							'close':function(){			 
								var win =Ext.getCmp('graphpopup');
								if(win)win[win.closeAction]();
							},
							'hide':function(){
								var win =Ext.getCmp('graphpopup');
								if(win)win[win.closeAction]();
							}
						},
					});
			graphpopup.show();
			if(chartData != undefined)
			{
				reportForHighChart('drilldownChartDiv',chartData);			
			}
			else
			{
				Ext.get('drilldownChartDiv').update('<center> <table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table></center>');
			}
			this.updateDrillDownQueryString();
           
    },
	loadChartUrl:function(value)
	{
		var jsonData=appConstants.publicjsonDataActivity;
		var GridData=jsonData.Results;
		var qryString=GridData.queryString;
		var mesName="";
		var titleToDisp="";
		
		var resultPanel=Ext.getCmp('resultPanel');			
		
		var columnDetails=GridData.gridColumns;
		titleToDisp=value.substring(0,value.indexOf("__"));
		mesName=value.substring(value.indexOf("__")+2);
		var mesData=GridData[mesName+'_chart'];
		
		var content='<div width="100%"  class="mainDiv">';
		content+='<div class="htmlTableHeader"><div style="float:left;">';
		content+=titleToDisp;
		var measDispName=replaceAll(titleToDisp,"%","0egpercent0");
		if(measDispName != undefined && measDispName.indexOf("(") != -1)
		{
			measDispName=measDispName.replace("(","EGOPENBRACEEG");
			measDispName=measDispName.replace(")","EGCLOSEBRACEEG");
		}
		content+='</div>' +'<div style="margin:5px 5px 0px 5px;float:right;cursor:pointer;" class="iconMaximize" onclick="javascript:openInNewWin(\''+qryString+'&measName='+replaceAll(mesName,"%","0egpercent0")+'&opt=data&measDispName='+measDispName+'\');"></div>'+ '</div></div>';
		
		var urlForAjax='/final/servlet/com.eg.ErRumComparisonServletC?';
		if(qryString.indexOf(urlForAjax)>-1)
			urlForAjax = '';		
		var drillDownStr = urlForAjax+qryString+'&measName='+replaceAll(mesName,"%","0egpercent0")+'&measDispName='+measDispName+"&opt=chart";
		var itemsArray=new Array();
		var dataAvailable=false;
		var chartProperties=this.getXmlForUrl(drillDownStr);
		if (!Ext.isEmpty( chartProperties ) && chartProperties.hasOwnProperty('XML') ){
			dataAvailable=true;
			var margin;
			var flex;			
			margin='0 10 10 10';
			flex=0.65;			
			var chartbox={
				xtype:'panel',
				data: chartProperties,
				flex:flex, 
				autoScroll:true,
				margin:margin,
 				ui:'newGraphPanel',
				id: 'fusion'
			};
			itemsArray.push(chartbox);
		}
		var barChartObj=Ext.getCmp('barChart');
		if(dataAvailable)
		{			
			if(Ext.isEmpty(barChartObj))
			{
				resultPanel.add({
					xtype:'panel',
					title:content,
					margin:'5 10 10 10',
					ui:'multiGraphPanel',
					id:'barChart',
					layout:{type:'hbox',align:'stretch'},
					height:400,
					columnWidth:1.0,
					items:itemsArray
				});
			}else{
				barChartObj.removeAll();
				barChartObj.add(itemsArray);
				barChartObj.setTitle(content);
			}
			
			if (Ext.isEmpty(appConstants.erUtils))
				appConstants.erUtils = Ext.widget("erutils");
		 
				var containerObj=Ext.getCmp('fusion');
				var data = containerObj.data;
				if ( !Ext.isEmpty( data ) && data.hasOwnProperty('XML') )
				{
					var innerHtml=data.innerHtml;
					var chartFor =data.chartFor;
					var chartHight =data.chartHight;
					
					appConstants.erUtils.updateBarChart("highchart",data.chartTitle,data.XML,data.swfpath,data,data.chartHeight-20,data.chartWidth,containerObj);
														
				}else
				{
					containerObj.update('<div style="margin:5px 10px 10px 10px"><img src="/final/reporter/images/nographformeasure.gif" width="100%" /></div>');
				}
			
			
		}else{
			if(Ext.isEmpty(barChartObj))
			{
				resultPanel.add({
					xtype:'nomeasurepanel',
					title:content,
					margin:'5 10 10 10',
					ui:'multiGraphPanel',
					id:'barChart',
					//layout:{type:'vbox',align:'stretch'},
					height:331,
					columnWidth:1.0,
					
					//html:'<div style="margin:5px 10px 10px 10px"><img src="/final/reporter/images/nographformeasure.gif" width="100%" /></div>'
				});
				//this.getNomeasurepanel().show();
			}else{
				barChartObj.removeAll();
				//barChartObj.update('<div style="margin:5px 10px 10px 10px"><img src="/final/reporter/images/nographformeasure.gif" width="100%" /></div>');
				barChartObj.update('<center><img src="/final/images/nomeasures_custom.png" height="100%" width="100%" /></center>');
				barChartObj.setTitle(content);
			}
		}
		
	},
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					chartAttrib=Ext.decode(jsonText);
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	/*weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');

		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},*/
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
	//	Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQStringActivity:function(){
		var FormParams="";
		var hiddenfieldQString='';
		var apdexRangeValue='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm=null;		
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getRCReportsFormSettings().getForm();

		var reportType = mainForm.findField('er_type').getValue();
		var componentType = mainForm.findField('er_compType').getValue();
		
		var serverArray=new Array();
		
		var select_farmVal=Ext.getCmp('select_farm').getValue();				
		FormParams="&select_farm="+select_farmVal;		

		FormParams+="&er_comptype="+mainForm.findField('er_compType').getValue()+"&er_type=No&er_excwe="+this.getSettingsFieldValue(thinclientuserSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')+"&er_reportgenration="+this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		if(Ext.get('showLegend')!=null)
			FormParams=FormParams+"&showLegend="+mainForm.findField('showLegend').getValue();

		FormParams+="&er_priority="+mainForm.findField('er_priority').getValue();
					
		FormParams+="&group_by="+this.getSettingsFieldValue(thinclientuserSettingsForm,'sh_timeinuse',isSettingsEnabled,'weightedAvg');
			
			var er_serverVal=Ext.getCmp('er_server').getValue();
			FormParams+="&er_workgroupserver="+er_serverVal;
			FormParams+="&er_server="+er_serverVal;
					
				
			var infoValue=Ext.getCmp('info_Val').getValue();		
			FormParams+="&info_Val="+infoValue;					
				
		
		//FormParams+="&rep_genType="+Ext.getCmp("rep_genType").getValue();
		var s_timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var s_minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var s_timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var s_minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');
		var durationVal =Ext.getCmp("duration").getValue();

		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		var timperiodParams="&timefrom="+s_timefrom+"&minfrom="+s_minfrom+"&timeto="+s_timeto+"&minto="+s_minto;

		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields'))
		{
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}		
			
		if(appConstants.isreportsneedService!="null")
				FormParams+="&isreportsneedService="+appConstants.isreportsneedService;
		if(appConstants.componenttest!="null")
				FormParams+="&componenttest="+appConstants.componenttest;
		if(appConstants.er_rep!="null")
				FormParams+="&er_rep="+appConstants.er_rep;
		FormParams+="&ReportFrom=RUM_Report";
		FormParams+="&s_duration="+durationVal; 	
		if(Ext.getCmp('ApdexFieldId')!=undefined)
		{
			var upperminor = Ext.getCmp('upperminor').getValue();
			var uppermajor = Ext.getCmp('uppermajor').getValue();
			var upperCritical = Ext.getCmp('upperCritical').getValue();		
			
			apdexRangeValue="&minorValue="+upperminor+"&majorValue="+uppermajor+"&criticalValue="+upperCritical
		}
		appConstants.queryStringActivity=FormParams+timelineParams+hiddenfieldQString+timperiodParams+apdexRangeValue;
  	},
	
	afterMainRender:function(){
		var thisController = this;		
		if(appConstants.er_rep!="null")
		{
			var selectFarm=Ext.getCmp("select_farm");
		}		
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonDataActivity.reportTitle);
		this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
		if(!hideBackButton){
			Ext.getCmp('RumComparisonReportsForm').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicjsonDataActivity['ID']
			});				
		}
	},
	loadSettingsElements:function(){
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var thisController  =this;		
		this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);		
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndUpdateSettings();
		});
	},
	
	validateAndUpdateSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		if(isSettingsOk)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeAndUpdateSettings : function()
	{
		if(this.validateAndUpdateSettings())
		{
			this.showResult();
		}
	},
	refreshReportData:function(){
		var jsonData;
		jsonData=appConstants.publicjsonDataActivity;		
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
            initLdgMask.show();
			this.loadJsScriptReportData(jsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	fillFormFieldsForActivity:function(jsonData)
	{
		 appConstants.publicjsonDataActivity=jsonData;
		var rep_type="";
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var compSel="er_server";
		var serverSel="select_farm";
		
		Ext.getCmp('er_type').show();
		if(appConstants.isSubmit=="true")
			isSubmitted=appConstants.isSubmit;
		
		var mainForm =Ext.getCmp('mainform').getForm();
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.zoneCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedZone;
			comboObject=mainForm.findField(serverSel);			
			comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);	
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);
			
			
		}
		comboRawData=jsonData.infoValCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedInfoVal;
			comboObject=Ext.getCmp("info_Val");			
			comboObject.setFieldLabel(screenLabels['reporter.common.Infotext']);		
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);			
			else
				comboObject.setValue(comboRawData[0].valueField);	
			comboObject.hide();			
			//Ext.getCmp("infoLbl").setFieldLabel(screenLabels['reporter.common.Infotext']);
		}
		
		comboRawData=jsonData.compTypeCombo;
		if ( !Ext.isEmpty(comboRawData) ){
			selectedComboOption=jsonData.selectedCompType;
			comboObject=mainForm.findField('er_compType');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Component Type']);
			comboObject.getStore().loadRawData(comboRawData);

			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);			
			else
				comboObject.setValue(comboRawData[0].valueField);
		}
		
		comboRawData=jsonData.reportTypeCombo;
		if ( !Ext.isEmpty(comboRawData) ){
		
			selectedComboOption=jsonData.selectedreportType;
			comboObject=mainForm.findField('er_type');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Report Type']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);
			else
				comboObject.setValue(comboRawData[0].valueField);			
			comboObject.hide();
		}
		
		rep_type=comboObject.getValue();
		comboRawData=jsonData.serverCombo;
		if ( !Ext.isEmpty(comboRawData) ){			
			selectedComboOption=jsonData.selectedServer;
			comboObject=Ext.getCmp(compSel);
			appConstants.rawDataForComponents = comboRawData;
			comboObject.setFieldLabel(screenLabels['reporter.common.Component']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);			
			else
				comboObject.setValue(comboRawData[0].valueField);			
			comboObject.show();
		}
		
		comboRawData=jsonData.priorityCombo;		
		selectedComboOption=jsonData.selectedPriority;
		comboObject=mainForm.findField('er_priority');
		comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
		if(!Ext.isEmpty(comboRawData))
		{
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);			
			else
				comboObject.setValue(comboRawData[0].valueField);			
			comboObject.hide();
		}
	
		comboRawData=jsonData.durationCombo;
		if ( !Ext.isEmpty(comboRawData) ){
			
			selectedComboOption=jsonData.selectedDuration;
			comboObject=Ext.getCmp("duration");
			appConstants.rawDataForComponents = comboRawData;
			comboObject.setFieldLabel(screenLabels['reporter.common.Duration']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}

		if(rep_type == 'No'){			
			mainForm.findField('er_mode').hide();			
			if(selectedComboOption!=null && selectedComboOption.indexOf("All ")>-1){
				if(Ext.getCmp('er_perserver')!=undefined)
					Ext.getCmp('er_perserver').show();
			}
		}
		else{
			comboRawData=jsonData.graphTypeArray;
			if(!Ext.isEmpty(comboRawData))
			{
			selectedComboOption=jsonData.selectedGraphType;
			comboObject=mainForm.findField('er_graphType');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Graph Type']);
			
			comboObject.getStore().loadRawData(comboRawData);
			
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}			
			comboObject.hide();
			}
		}

		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}

        var start_hour = jsonData.startHour;
        var end_hour = jsonData.endHour;
        var start_date = jsonData.startDate;
        var end_date = jsonData.endDate;
        var startDateObj = mainForm.findField('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = start_date;
        var startHrObj = mainForm.findField('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = start_hour;
        var endDateObj = mainForm.findField('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = end_date;
        var endHrObj = mainForm.findField('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = end_hour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;

		 updatingAppSettings();		 
		
	},
	fillSettingFieldsForActivity:function(jsonData){
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var thinclientuserSettingsForm = this.getRCReportsFormSettings().getForm();
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.excludeWeekCombo;
		selectedComboOption=jsonData.excludeWeek;
		comboObject=thinclientuserSettingsForm.findField('er_excwe');		
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		var exludeWeekEndVal=selectedComboOption;
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			exludeWeekEndVal=comboRawData[0].valueField;
			comboObject.setValue(comboRawData[0].valueField);
		}
		
		/*if(exludeWeekEndVal=="Yes" || exludeWeekEndVal=="yes")
		{
			var excludeDaysObj=Ext.getCmp('excludeDays');
			excludeDaysObj.show();
			excludeDaysObj.update(jsonData.screenLabels['MappedExcludeDays']);
		}*/
		comboObject=thinclientuserSettingsForm.findField('sh_timeinuse');
		comboObject.hide();	

		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
		Ext.getCmp('ApdexFieldId').setFieldLabel(screenLabels['reporter.common.Apdex Health']);
		thinclientuserSettingsForm.findField('upperminor').setValue(jsonData.defaultValues.minorValue);
		thinclientuserSettingsForm.findField('uppermajor').setValue(jsonData.defaultValues.majorValue);
		thinclientuserSettingsForm.findField('upperCritical').setValue(jsonData.defaultValues.criticalValue);
	},
	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
	   // var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" class="settingsfont">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		Ext.create('Ext.container.Container',{
		width:569,
		//padding:5,
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'385px'}
			},
			{
				xtype:'container',
				cls:'containerHeader',
				html:tpl.apply(),
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'RCReportsFormSettings',
				parent:this
			}
		],
		renderTo:'thinclientuser'
		});

	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var publicJsonData=null;
		publicJsonData = appConstants.publicjsonDataActivity;
		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}
		return value;
	}
});

