
Ext.define('RumJSErrorApp.controller.RumReportsController',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'usertimeline',ref:'usertimeline'},
		{selector: 'RumReportsForm',ref: 'RumReportsForm'},
		{selector: 'egcomponent',ref: 'egcomponent'},
		{selector: 'mainform',ref: 'mainform'},
		{selector: 'RumReportsFormSettings',ref: 'RumReportsFormSettings'},
		{selector: 'reporterdata',ref:'reporterdata'},
 		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({

			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.afterMainRender,
				'boxready':this.refreshReportData
			},
           	'RumReportsFormSettings':{
				'afterrender':this.loadSettingsElements
            },
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'main button[id="excelToolBtn"]':{
					'click':this.saveExcel
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'mainform combo[name="eg_serverSel"]':{
				'select': this.zoneOnChange
			},
			
			'mainform combo[name="rep_genType"]':{
				'select': this.Changerep_genType
			},	
			'mainform button[id="expandSelector"]': {
                'click': this.expandMe
            },			
			'mainform button[id="expandSelector1"]': {
                'click': this.expandMe
            },
			'RumReportsFormSettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},			
			'RumReportsFormSettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'RumReportsFormSettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'RumReportsFormSettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'RumReportsForm button[itemId="submit"]':{
				'click': this.showResult
			},
			'mainform button[itemId="save"]': {
					"click": this.goTo
			},
		
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
		});
	},
		Changerep_genType:function(obj)
	{
			appConstants.erGraphType=obj.getValue();
			if(!Ext.isEmpty(appConstants.publicjsonDataActivity))
				this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
	},
	goTo: function (btn) {
 		var reportCat=Ext.getCmp('report_category').getValue();
		var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;
		
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveFavorite(btn);
		}
    },
	
	 changeEr_mode: function (combo) {
		var favorite_id='';
		var from_schModify='';
		var reportCat=Ext.getCmp('report_category').getValue();

		
			favorite_id = appConstants.publicjsonDataActivity['hiddens']["favorite_id"];
			from_schModify = appConstants.publicjsonDataActivity['hiddens']["fromScheduleModify"];
		

		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.showResult();
     },
	
	zoneOnChange:function(){
	
	
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportCat=mainForm.findField('report_category').getValue();
		var urlForAjax;
	
		if(targetType=="RUM")
			urlForAjax="/final/reporter/ErRumReportJson.jsp";
		else
			urlForAjax="/final/reporter/ErJsErrorReportJson.jsp";
		var QString="";
		
		
		this.updateQStringActivity();
		QString=appConstants.queryStringActivity;
		
		var me=this;
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : QString,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				if(!Ext.isEmpty(jsonText))
				{
					var jsonData=Ext.decode(jsonText);
					me.fillFormFieldsForActivity(jsonData);			
				}
			}
		});	
	},
	 expandMe: function (btn) {
		var idName="";
		var lblId="";
		var id=btn.getItemId();
		
		 if(id=="expandSelector1")
		{
			idName="select_farm";
			lblId="siteLbl";
		}
		else
		{
			idName="er_server";
			lblId="compLbl";
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp(idName),Ext.getCmp(lblId).text,btn);
	},
	
	reportCatChange:function(obj){
		initLdgMask.show();
		var value =obj.getValue();
		
		this.LoadFieldsForActivity();
		
		Ext.getCmp('resultPanel').hide();
	},
	LoadFieldsForActivity:function(){
	var url1="";
			if(targetType=="RUM")
				url1="/final/reporter/ErRumReportJson.jsp";
			else
				url1="/final/reporter/ErJsErrorReportJson.jsp";
		
		Ext.Ajax.request(
		{
			url : url1,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData;
				this.getMain().setTitle(jsonData.reportTitle);
				this.fillFormFieldsForActivity(jsonData);
				var mainForm =Ext.getCmp('mainform').getForm();
				mainForm.findField("er_type").show();
				mainForm.findField("er_compType").show();
				//Ext.getCmp("er_type").setValue("Yes");
				mainForm.findField("er_mode").show();
				if(Ext.getCmp("sh_timeinuse")!=undefined)
					Ext.getCmp("sh_timeinuse").hide();
				initLdgMask.hide();
			}
		});
	},
	
	
	saveReportAsPDF:function(){
		var saveQString;
		var reportFor = Ext.getCmp('report_category').getValue();		
			saveQString=appConstants.publicjsonDataActivity.saveQString;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				saveQString+="&er_view=PRINT";
		
		
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString;
		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}	  
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var reportFor = Ext.getCmp('report_category').getValue();		
		saveQString=appConstants.publicjsonDataActivity.saveQString;
		saveQString+="&printGraph=yes&opt=chart";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			saveQString+="&er_view=PRINT";
		var s_qryString = saveQString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryStringActivity;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	printReport:function(){

		var s_qryString;
		var reportFor = Ext.getCmp('report_category').getValue();
		
		var saveQString=appConstants.publicjsonDataActivity.saveQString;
		//this.updateQStringActivity();
		//	saveQString=appConstants.queryStringActivity;
		s_qryString = "../servlet/com.eg.ErCtxRumReportC?"+saveQString+"printGraph=yes&pdfPrint=yes";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			s_qryString+="&er_view=PRINT";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in 
	},
	sendMail:function(){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveExcel:function(){
		window.location="../servlet/com.eg.JavaScriptReportC?er_xlrequest=yes";
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(btn){
		var report_cat = Ext.getCmp('report_category').getValue();
		var isValid = this.validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Javsscript Error Report',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}

		if(isValid){
			var s_qryString;
			this.updateQStringActivity();
			var rtype=Ext.getCmp('er_type').getValue();

			s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;
						
			var target=s_qryString+"&CSVFileAsExcel=yes&com.eg.CSRF_NONCE="+csrfToken;
			if (btn.getItemId()=='save')
				document.location=target+'&showSchWindow=no';
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		
	},
	saveFavorite:function(btn){
		var isValid = this.validateMainForm(false);
		var favorite_id ="";
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Javsscript Error Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		if(isValid){
			var s_qryString;
			var report_cat = Ext.getCmp('report_category').getValue();

			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			favorite_id = hiddenFields["favorite_id"];
			this.updateQStringActivity();
			var rtype=Ext.getCmp('er_type').getValue();
			
			s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";

				
			
			
			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//+"&FavoriteId="+favorite_id;
			
			if (btn.getItemId()=='save')
				document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
			else
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm =null;
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getRumReportsFormSettings().getForm();
		var zone=mainForm.findField('select_farm')
		var reporFor=mainForm.findField('report_category').getValue();
		var reportType=mainForm.findField('er_type').getValue();
			if(zone.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Javsscript Error Report',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		
			var server=Ext.getCmp('er_compSel');			
			console.log(server.getValue());
			if( server.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Javsscript Error Report',
				msg: server.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		
		var isSettingsOk = true;

		var hiddenFields;
		hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;

		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen = this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var er_usertimeline = '';
		if ( !Ext.isEmpty(hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');


		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){

			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Javsscript Error Report settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = hiddenFields["limitforbg"];

				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						isSettingsOk = false;
					} 
				}
			}
		}
		else{
			var reportName = this.getSettingsFieldValue(thinclientuserSettingsForm,'bgReportName',isSettingsEnabled,'selectedMinsTo');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;

		/*if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}*/
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		
		var mainForm =Ext.getCmp('mainform').getForm();
		var hiddenFields;
		hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var er_usertimeline = '';
		if ( !Ext.isEmpty(hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}
		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var maxTimeLine = appConstants.publicjsonDataActivity.maxTimeLine;

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		
		if(!checkTimeLineForBgLimit(maxTimeLine,MaxDaysInMonth,stDate,enDate)){
			Ext.MessageBox.show({
				title: 'Javsscript Error Report',
				msg:  'Please Select Less than '+maxTimeLine+' timeline',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
						
		}else
		{
			var resultPanelObj=Ext.getCmp('resultPanel');
			resultPanelObj.removeAll();
			var startdate = mainForm.findField('er_stdate').getValue();
			var starthr = mainForm.findField('er_sthr').getValue();
			startdate.setHours(starthr);
			var enddate = mainForm.findField('er_enddate').getValue();
			var endhr = mainForm.findField('er_endhr').getValue();
			enddate.setHours(endhr);
			var result = checkDateTime(startdate, enddate);
			if (!result) {
				return;
			}
			
			var isValid = this.validateMainForm(true);

			if(isValid)
				this.submitReport();
		}
	},
	validateSettings :function(){
		var isSettingsOk = true;

		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && reportgen == 'background' ) {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
 			this.submitReport();
		}else{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			
			Ext.get("configMod").animate({
				to: {
					"top": 45
				},
				listeners: {
					afteranimate: function () {
						Ext.get("configMod").setStyle("left", "");
					}
				}
			}).show();
			
			var thinclientuserSettingsForm = this.getRumReportsFormSettings().getForm();
			var reportGenType=thinclientuserSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientuserSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					chartAttrib=Ext.decode(jsonText);
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	loadJsScriptReportData:function(jsonData)
	{
		appConstants.publicjsonDataActivity=jsonData;
		var dataAvailable=false;
		var resultPanelObj=Ext.getCmp('resultPanel');
		var rep_Type=jsonData.selectedreportType;
		var itemArray=new Array();
		var titleDisp="";
		var info_msg="";
		var titleToDispaly="";
		if(rep_Type!="No")
		{
			var chartUrls=jsonData.chartURLs;
			
		}else
		{
			var resultJson=jsonData.Results;
			
			
			if(!Ext.isEmpty(resultJson))
			{
				titleToDispaly=resultJson.title;
				var type=resultJson.rep_genType;
				//if(type=="Summary")
				{
					var tableHtml="";
					var rootjsonArr=resultJson[type];
					 titleDisp=resultJson["Summary_title"];
					 info_msg=resultJson["INFO_MSG"];
				
					if(!Ext.isEmpty(rootjsonArr) && rootjsonArr.length>0)
					{

						dataAvailable=true;						
						var column=resultJson["summary_columns"];					
						
						tableHtml+='<div class="newFont_bold14" style="margin-bottom:5px">'+titleDisp+'</div>';
						tableHtml+='<div id="anbu" style="border:0px !important" class="newTable">';
						//tableHtml+='<div id="anbu" style="border:0px !important" class="newTable">';
						tableHtml+='<table width="100%">';
						//tableHtml+='<table style="margin:10px;width:97%">';
						tableHtml+='<thead><tr>';
						for(var i=0;i<column.length;i++)
						{
							tableHtml+='<th style="text-align:center">';
							tableHtml+=column[i];
							tableHtml+='</th>';
						}
						tableHtml+='</tr></thead>';
						
						tableHtml+='<tbody><tr>';
						for(var i=0;i<rootjsonArr.length;i++)
						{
							var rootjson=rootjsonArr[i];
							tableHtml+='<tr>';
						
							for(var j=0;j<column.length;j++)
							{									
								tableHtml+='<td style="text-align:center;">';
								tableHtml+=this.getDecimalAlignFormat(rootjson[column[j]]);							
								tableHtml+='</td>';
							}
							tableHtml+='</tr>';						
						}
						tableHtml+='</tr></tbody>';
						tableHtml+='</table></div>';			
						
						
					}else					
						tableHtml+='<table width="100%" height="100%"><tr><td align="center" valign="middle"><img   width="100%" height="100%" src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>';
						
					if(type=="Summary")
					{	
						var chartbox={
								xtype:'container',	
								//ui:'newGraphPanel',
								margin: '10 10 10 10',
								bodyPadding:'0 10 10 10',
								//title:titleDisp,
								html:tableHtml,
						};
						itemArray.push(chartbox);
					}
					else
					{
						var chartbox={
							xtype:'container',
							layout:{
								type:'vbox',
								align: 'center'
							},
							items:[
								{
										xtype:'container',	
										width:600,
										//ui:'multiGraphPanel',
										margin: '10 10 10 10',
										bodyPadding:'0 10 10 10',
										//title:titleDisp,
										html:tableHtml
								}
							]
						};
						itemArray.push(chartbox);
					}
					
				}
				if(type!="Summary")
				{
					titleDisp=resultJson.Deatils_title

					tableHtml='<div class="newFont_bold14" style="margin-bottom:5px">'+titleDisp+'*</div>';
					tableHtml+='<div id="anbu" style="border:0px !important" class="newTable" >';
					tableHtml+='<table> <col width="3%"><col width="80%"><col width="30%">';
					//tableHtml='<div id="anbu" style="border:0px !important" class="newTable" >';
					var urls=resultJson.Urls;
					var Request_Count_Title=resultJson['Request Count_Title'];
					var Request_URL_Title=resultJson['Request URL_Title'];					
					var errorsDet;
					var columns=resultJson.Detailscolumns;
					if(!Ext.isEmpty(urls))
					{
						dataAvailable=true;					
						for(var i=0;i<urls.length;i++)
						{
							var url=urls[i];
							 errorsDet=resultJson[url+'_columns'];
							var count=resultJson[url+'_count'];
							
							//tableHtml+='<table class="newTable" style="margin:0px 5px 5px 5px"> <col width="3%"><col width="80%"><col width="30%">';
							
							if (i==0)
							{
								tableHtml+='<thead>';
								tableHtml+='<tr>';
								tableHtml+='<th></th><th>'+Request_URL_Title+'</th><th>'+Request_Count_Title+'</th>';
								tableHtml+='</tr>';
								tableHtml+='</thead>';
								tableHtml+='<tbody>';
							}
							
							
							tableHtml+='<tr>';
							tableHtml+='<td>';
							tableHtml+= '<div><div style="cursor:pointer;"><div class="iconTreeExpand" id="data_'+i+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-right:2px">';
							tableHtml+= '</div></div>';
							tableHtml+= '<div style="float:left;">';
							tableHtml+='</div></div>';
							tableHtml+='</td>';						
							tableHtml+='<td>'+url+'</td>';
							tableHtml+='<td  style="text-align:center">'+this.getDecimalAlignFormat(count)+'</td>';
							tableHtml+='</tr>';
													
							tableHtml+='<tr id="child_tr'+i+'_" style="display:none"><td></td><td colspan="2" >';
							tableHtml+='<div class="newTable" style="margin:10px;">';
							tableHtml+='<table ><col width="80%"><col width="20%">';
							tableHtml+='<thead>';
							tableHtml+='<tr>';
							for(var j=0;j<columns.length;j++)
							{
								//prakash
								var align='left';
								if(columns[j] == 'Count')
									align='center';
								
								//
								tableHtml+='<th style="text-align:'+align+'">'+columns[j]+'</th>';
							}						
							tableHtml+='</tr>';	
							tableHtml+='</thead>';	
							tableHtml+='<tbody>';
							for(var j=0;j<errorsDet.length;j++)
							{
								var strVal=errorsDet[j];
								strVal=replaceAll(strVal,"\"","");
								
								var countStr=resultJson[url+''+strVal+'_count'];	
								
								//if(strVal.startsWith("'"))
									strVal=strVal.substring(1);
								if(countStr!="0" && !Ext.isEmpty(countStr))
								{
									tableHtml+='<tr>';
									tableHtml+='<td><div style="WORD-BREAK:BREAK-ALL !important;">'+strVal+'</div></td>';
									tableHtml+='<td style="text-align:center">'+this.getDecimalAlignFormat(countStr)+'</td>';
									tableHtml+='</tr>';
								}
							}	
							tableHtml+='</tbody>';
							tableHtml+='</table>';
							tableHtml+='</div >';
							tableHtml+='</td></tr>';
						}
						
							tableHtml+='</tbody></table>';
						tableHtml+='</div>';						
						var chartbox={
							xtype:'container',	
							//title:titleDisp+"*",		
							margin: '5 10 10 10',
							bodyPadding:'0 10 10 10',
							//ui:'multiGraphPanel',
							html:tableHtml,
							
						};
						itemArray.push(chartbox);
					}
				}		
				if(!Ext.isEmpty(info_msg) && dataAvailable)
				{
					//tableHtml='<div class="x-table-tree" style="color:red;background-color:#E8E8E8 !important ">';
					tableHtml='<table>';
					tableHtml+='<tr><td style="width:10px;padding-left:5px;valign:top;font-weight:bold !important">*</td>';
					tableHtml+='<td style="word-wrap:break-word;white-space:wrap;padding:5px !important;font-size:11px;">'+info_msg;
					tableHtml+='</td></tr></table>';					
				//	tableHtml+='</div>';
					var chartbox={
						xtype:'panel',
						margin: '0 10 5 10',
						//ui:'newGraphPanel',
						html:tableHtml,
					};
					itemArray.push(chartbox);
				}
				
				if(dataAvailable)
				{
					
					resultPanelObj.removeAll();
					resultPanelObj.add({
						xtype:'panel',
						ui:'newGraphPanel',
						margin: '10 10 10 10',
						items:itemArray,
						/*items:[{
							xtype:'panel',
							cls:'newTable',
							margin:'10 10 10 10',
								
						}] */
					});
					resultPanelObj.show();
					resultPanelObj.doLayout();
					
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("excelTool").setDisabled(false);

				//	Ext.getCmp("csvTool").setDisabled(false);
					
				}else
				{
					this.disableTools();
					resultPanelObj.hide();
					this.getNomeasurepanel().show();
					
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
					Ext.getCmp("saveTool").setDisabled(true);
					Ext.getCmp("bookletTool").setDisabled(true);
					Ext.getCmp("printTool").setDisabled(true);
					Ext.getCmp("mailTool").setDisabled(true);
					//Ext.getCmp("csvTool").setDisabled(true);
				}
				
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);

			}else
			{
				this.enableNomeasures();				
			}
		}
		initLdgMask.hide();
	},
	enableNomeasures: function()
	{
		var resultPanelObj=Ext.getCmp('resultPanel');
		this.disableTools();
				resultPanelObj.hide();
				this.getNomeasurepanel().show();
				Ext.getCmp('panelinsidetoggle').setDisabled(true);
				Ext.getCmp("saveTool").setDisabled(true);
				Ext.getCmp("bookletTool").setDisabled(true);
				Ext.getCmp("printTool").setDisabled(true);
				Ext.getCmp("mailTool").setDisabled(true);
				Ext.getCmp('panelinsidetoggle').setDisabled(true);
				initLdgMask.hide();
	},
	toggleChildTables:function(id){
		var booleanCls=$('#'+id).hasClass('iconTreeExpand');
		
		
		
 		var str=id.split('_');
	
 		if (booleanCls)
		{
   			$('#'+id).removeClass("iconTreeExpand");
			$('#'+id).addClass("iconTreeCollapse");
		}
		else
		{
 			$('#'+id).removeClass("iconTreeCollapse");
			$('#'+id).addClass("iconTreeExpand");
		}
		if (str[0]=='data')
		{
 			var toggleid='child_tr'+str[1]+'_';
 			$("#anbu tr[id^="+toggleid+"]").each(function (i, el) {
				if (booleanCls)
				{					
 					el.style.display='table-row';
 				}
				else
				{
					el.style.display='none';
				}
			});
  		}
		else if(str[0]=='child')
		{

			if (booleanCls)
			{
				document.getElementById('subChild_tr_'+str[1]+'_'+str[2]).style.display='table-row';
			}
			else
			{
				document.getElementById('subChild_tr_'+str[1]+'_'+str[2]).style.display='none';
 			}
		}
		else
		{
			conosle.log('issue in toggling');
		}
		Ext.getCmp('resultPanel').doLayout();
	},
	submitReport:function(){
		initLdgMask.show();
		var url;
		var backgroundUrl;
		var Qstring;
		var me=this;
		var dataAvailable=false;
		var mainForm =Ext.getCmp('mainform').getForm();
			if(!isSettingsEnabled)
				this.showConfigDropdown();
		var thinclientuserSettingsForm = this.getRumReportsFormSettings().getForm();
		var reportFor = mainForm.findField('report_category').getValue();
		appConstants.report_for=reportFor;
		
			var rtype=mainForm.findField('er_type').getValue();
		
			if(rtype == 'No'){					
				Ext.getCmp('showLegend').hide();				
			}
			this.updateQStringActivity();
			Qstring=appConstants.queryStringActivity;
			backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";		
			url="../servlet/com.eg.ErCtxRumReportC?isSubmit=true&responseType=json"			
		
		

 		Qstring+= '&er_RmDispName='+appConstants.er_RmDispName;
		
 		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
 		var reportGeneration=Ext.getCmp('reportGeneration').getValue();
		var reportType='';
 		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		resultPanelObj.removeAll();
	
		if(reportGeneration == 'foreground'){
 			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData=Ext.decode(jsonText);					
						this.loadJsScriptReportData(jsonData);
					}else
						me.enableNomeasures();
				}
			});
		}
		else if(reportGeneration == 'background'){
			resultPanelObj.hide();
			var me=this;

 			var htmlStr = '';
			//myMask = new Ext.LoadMask(Ext.getBody(), {msg : "Background Report Generation is in Progress..."});
			//myMask.show();
			initLdgMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
 				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td>Error In BackGround Generation</td></tr></table></td></tr></table>';
					}
  					me.getBackGroundPanel().update(htmlStr);
 					me.getBackGroundPanel().show();
					initLdgMask.hide();
				}
			});
		}

	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	timeLineOnChange:function() {
		var mainForm =Ext.getCmp('mainform').getForm();
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var startDateObj=mainForm.findField('er_stdate');
		var startHrObj=mainForm.findField('er_sthr');
		var endDateObj=mainForm.findField('er_enddate');
		var endHrObj=mainForm.findField('er_endhr');
		var timelineObj=mainForm.findField('er_timeline');
		if(timelineObj.getValue() == 'Any'){
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else{
		timelineObj.suspendEvents(true);
		//this.loadHiddenFields(publicjsonData['hiddenfields']);
		this.updateQStringActivity();
		var url1="";
			if(targetType=="RUM")
				url1="/final/reporter/ErRumReportJson.jsp";
			else
				url1="/final/reporter/ErJsErrorReportJson.jsp";
		Ext.Ajax.request(
		{
			url : url1,
			params : appConstants.queryStringActivity,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData;
				var start_hour=jsonData.startHour;
				var end_hour=jsonData.endHour;
				var start_date=jsonData.startDate;
				var end_date=jsonData.endDate;
				startDateObj.setDisabled(true);
				startHrObj.setDisabled(true);
				endDateObj.setDisabled(true);
				endHrObj.setDisabled(true);
				startDateObj.setValue(start_date);
				startHrObj.setValue(start_hour);
				endDateObj.setValue(end_date);
				endHrObj.setValue(end_hour);
			}
		});
		timelineObj.resumeEvents();
		}
	},
	/*weekendOnChange:function(){
		var reportCat=Ext.getCmp('report_category').getValue();
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');


		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},*/
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
		//Ext.getCmp("csvTool").setDisabled(true);
		Ext.getCmp("excelTool").setDisabled(true);
	},
	updateQStringActivity:function(){
		var FormParams='';
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm=null;
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getRumReportsFormSettings().getForm();

		var reportType = mainForm.findField('er_type').getValue();
		var componentType = mainForm.findField('er_compType').getValue();

		if(appConstants.erGraphType!=null && appConstants.erGraphType=="Summary")
		{
		var serverArray=Ext.getCmp('select_farm').getValue();
				if(serverArray!=null && serverArray!='undefined' && serverArray.length>0){
					for(var k=0;serverArray.length>k;k++)
					{
						FormParams+="&select_farm="+serverArray[k];
					}
				}
		}else
		{
			FormParams+="&select_farm="+Ext.getCmp("eg_serverSel").getValue();
		}

		FormParams+="&er_comptype="+mainForm.findField('er_compType').getValue()
					+"&er_type="+reportType
					+"&er_excwe="+this.getSettingsFieldValue(thinclientuserSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')
					+"&er_reportgenration="+this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
				if(Ext.get('showLegend')!=null)
					FormParams=FormParams+"&showLegend="+mainForm.findField('showLegend').getValue();

			
		if(reportType == 'Yes')
		{
			
			FormParams+="&er_mode="+mainForm.findField('er_mode').getValue()
						+"&sh_timeinuse=No";
			
		}
		else
		{
			
			if(targetType=="RUM")
				FormParams+="&sh_timeinuse="+this.getSettingsFieldValue(thinclientuserSettingsForm,'sh_timeinuse',isSettingsEnabled,'weightedAvg');
			if(serverArray ==undefined || serverArray=="-1" ||(serverArray!=null && serverArray!=undefined && serverArray.length>1)){
				var er_perserver = this.getSettingsFieldValue(thinclientuserSettingsForm,'er_perserver',isSettingsEnabled,'selectedAggServer')
				if(er_perserver!=null)
					FormParams+="&er_perserver="+er_perserver;
			}
		}
		FormParams+="&targetType="+targetType;
			if(targetType!="RUM")
				FormParams+="&group_by="+this.getSettingsFieldValue(thinclientuserSettingsForm,'sh_timeinuse',isSettingsEnabled,'weightedAvg');
			FormParams+="&er_server="+Ext.getCmp("er_compSel").getValue();
		
	FormParams+="&rep_genType="+Ext.getCmp("rep_genType").getValue();
		var s_timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var s_minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var s_timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var s_minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		var timperiodParams="&timefrom="+s_timefrom+"&minfrom="+s_minfrom+"&timeto="+s_timeto+"&minto="+s_minto;

		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields')){
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}		
		
		
		if(appConstants.isreportsneedService!="null")
				FormParams+="&isreportsneedService="+appConstants.isreportsneedService;
		if(appConstants.componenttest!="null")
				FormParams+="&componenttest="+appConstants.componenttest;
		if(appConstants.er_rep!="null")
				FormParams+="&er_rep="+appConstants.er_rep;
		FormParams+="&ReportFrom=RUM_Report";
		 		
		appConstants.queryStringActivity=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
  	},
	
	afterMainRender:function(){
		var thisController = this;		
		if(appConstants.er_rep!="null")
		{
			var selectFarm=Ext.getCmp("select_farm");
			
		}			
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonDataActivity.reportTitle);
		
		this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
		if(!hideBackButton){
				Ext.getCmp('RumReportsForm').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonDataActivity['ID']
				});				
		}
	},
	loadSettingsElements:function(){
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp("sh_timeinuse").hide();
		var thisController  =this;
		
		this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
				thisController.validateAndCloseSettings();
		});
	},
	
	validateAndCloseSettings :function()
	{
	   var isSettingsOk = this.validateSettings();
			//isSettingsOk=true;
 			if(isSettingsOk)
			{
 				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				return true;
			}
			return false;
	},
	
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},

	refreshReportData:function(){
		var jsonData;
		
		
		jsonData=appConstants.publicjsonDataActivity;
		
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
            initLdgMask.show();
			this.loadJsScriptReportData(jsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	fillFormFieldsForActivity:function(jsonData)
	{
		var rep_type="";
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var compSel="";
		var serverSel="";
		
		Ext.getCmp('rep_genType').hide();
		if(appConstants.isSubmit=="true")
			isSubmitted=appConstants.isSubmit;
		if(appConstants.erGraphType!="null" && appConstants.erGraphType!="Summary")
		{
			serverSel="eg_serverSel";
			compSel="er_compSel";
			
			Ext.getCmp("eg_serverSel").show();
			Ext.getCmp("er_compSel").show();
			Ext.getCmp("EgServerMultiSelectLbl").hide();
			Ext.getCmp("serverMultiSelectLbl").hide();
		}
			
		var mainForm =Ext.getCmp('mainform').getForm();
		var screenLabels=jsonData.screenLabels;

		comboRawData=jsonData.zoneCombo;
			if ( !Ext.isEmpty(comboRawData) ){
			selectedComboOption=jsonData.selectedZone;
			comboObject=mainForm.findField(serverSel);
			if(appConstants.erGraphType!="null" && appConstants.erGraphType!="Summary")		
				comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);
			comboObject.getStore().clearFilter(true); 		
			comboObject.getStore().loadRawData(comboRawData);

			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		
		comboRawData=jsonData.compTypeCombo;
		if ( !Ext.isEmpty(comboRawData) ){
			selectedComboOption=jsonData.selectedCompType;
			comboObject=mainForm.findField('er_compType');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Component Type']);
			comboObject.getStore().loadRawData(comboRawData);

			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		comboRawData=jsonData.reportForCombo;
		if ( !Ext.isEmpty(comboRawData) ){
		
			selectedComboOption=jsonData.reportFor;
			comboObject=mainForm.findField('report_category');
			comboObject.setFieldLabel(screenLabels['reporter.common.Report For']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}	
		
		comboRawData=jsonData.rep_genType;
		if ( !Ext.isEmpty(comboRawData) ){
		
			selectedComboOption=jsonData.selected_genType;
			comboObject=mainForm.findField('rep_genType');
			comboObject.setFieldLabel(screenLabels['reporter.thin.rep_genType']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(appConstants.erGraphType) ){
				comboObject.setValue(appConstants.erGraphType);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.hide();
		}
		
		comboRawData=jsonData.reportTypeCombo;
		if ( !Ext.isEmpty(comboRawData) ){
		
			selectedComboOption=jsonData.selectedreportType;
			comboObject=mainForm.findField('er_type');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Report Type']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			} 
		}
		comboObject.hide();
		rep_type=comboObject.getValue();
		if(rep_type=="No" )
		{
			if(appConstants.isreportsneedService!="null")
			{				
				Ext.getCmp("er_compType").hide();
				
			}
		}else
		{			
			if(appConstants.isreportsneedService!="null")
			{				
				Ext.getCmp("er_compType").show();
				
			}
		}
		
		
		mainForm.findField('er_mode').hide();
		comboRawData=jsonData.serverCombo;
		if ( !Ext.isEmpty(comboRawData) ){
			selectedComboOption=jsonData.selectedServer;
			comboObject=Ext.getCmp(compSel);
			appConstants.rawDataForComponents = comboRawData;
			if(appConstants.erGraphType!="null" && appConstants.erGraphType!="Summary")		
				comboObject.setFieldLabel(screenLabels['reporter.common.Component']);
			comboObject.getStore().clearFilter(true); 		
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}			

		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}

        var start_hour = jsonData.startHour;
        var end_hour = jsonData.endHour;
        var start_date = jsonData.startDate;
        var end_date = jsonData.endDate;
        var startDateObj = mainForm.findField('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = start_date;
        var startHrObj = mainForm.findField('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = start_hour;
        var endDateObj = mainForm.findField('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = end_date;
        var endHrObj = mainForm.findField('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = end_hour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;

		 updatingAppSettings();
	},
	fillSettingFieldsForActivity:function(jsonData){
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var thinclientuserSettingsForm = this.getRumReportsFormSettings().getForm();
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.excludeWeekCombo;
		selectedComboOption=jsonData.excludeWeek;
		comboObject=thinclientuserSettingsForm.findField('er_excwe');
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		var exludeWeekEndVal=selectedComboOption;
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			exludeWeekEndVal=comboRawData[0].valueField;
			comboObject.setValue(comboRawData[0].valueField);
		}
		
		/*if(exludeWeekEndVal=="Yes" || exludeWeekEndVal=="yes")
		{
			var excludeDaysObj=Ext.getCmp('excludeDays');
			excludeDaysObj.show();
			excludeDaysObj.update(jsonData.screenLabels['MappedExcludeDays']);
		}*/		

		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
	},
	showConfigDropdown:function(){
			isSettingsEnabled = true;
		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:569,
			//padding:5,
			//layout:'vbox',
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'360px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'RumReportsFormSettings',
					parent:this
				}
			],
			renderTo:'thinclientuser'
			});

	},
	LoadDrillDownData:function( url){
		initLdgMask.show();
		var meController = this;
		var paramsForDrillDown = url.substring(url.indexOf("?")+1);
		var controller = url.substring(0,url.indexOf("?"));
		var resultPanelObj = Ext.getCmp('resultPanel');
		Ext.Ajax.request(
		{
			url : controller,
			params : paramsForDrillDown+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				if(jsonData.hasOwnProperty('drillDownData')){
					resultPanelObj.removeAll();
					var DrillDownData = jsonData['drillDownData'];
					for(var k in DrillDownData){
						var tableObj =DrillDownData[k];
						var columnDetails = tableObj['columns'];
						var dataArray = tableObj['data'];

						if(!Ext.isEmpty(dataArray))
						{

							var tabledata = '<div class="x-table" >'
							+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'
								+'<thead>'
									+'<tr class="x-grid-row">';
							for( var k in columnDetails){
										tabledata+='<th class=" x-grid-cell">'
											+'<div class="x-grid-cell-inner">'+columnDetails[k]+'</div>'
										+'</th>';
							}
							tabledata+='</tr>'
								+'</thead>'
							+'<tbody>'
							+'<tpl for=".">';
							for(var j in dataArray)
							{
								var realdata=dataArray[j];
								tabledata+='<tr class="x-grid-row">';
								for(var l in realdata){
									tabledata+='<td class=" x-grid-cell x-grid-cell-first">'
										+'<div class="x-grid-cell-inner" >'+realdata[l]+'</div>'
									+'</td>'
								}
								tabledata+='</tr>';
							}
							tabledata+='</tpl>'+'</tbody>'+'</table>' +'</div>';
							if (k == 1)
								resultPanelObj.add({
									xtype: 'panel',
									margin: '0 0 10 0',
									layout: {
										columns: 2,
										align: 'center'
									},
									cls: 'datapanel',
									tools: [{
										xtype: 'button',
										text:backText,
										cls: 'backbutton',
										iconCls: 'iconBack',
										id: 'thiClientbckButton',
										name: 'thiClientbckButton',
										listeners: {
											'click': function () {
												meController.submitReport();
											}
										}
									}],
									bodyPadding: '0 0 0 0',
									padding:0,
									title:'<span class="font_bold">'+tableObj.tableTitle+'</span>',
									width: '100%',
									html: tabledata
								});
							else
								resultPanelObj.add({
									xtype: 'panel',
									margin: '0 0 10 0',
									layout: {
										columns: 2,
										align: 'center'
									},
									cls: 'datapanel',
									bodyPadding: '0 0 0 0',
									title:'<span class="font_bold">'+tableObj.tableTitle+'</span>',
									width: '100%',
									padding:0,
									html: tabledata
								});
						}
					}
				}
				else{
 					this.disableTools();
					resultPanelObj.show();			
 					resultPanelObj.removeAll();
					resultPanelObj.add({
					xtype: 'container',
					height: 250,
					cls:'containerShadow',
					margin:'5 10 10 10',
					width: '100%',
					html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>'
					});
				}
				initLdgMask.hide();
			}
		});
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{

		var publicJsonData=null;
		publicJsonData = appConstants.publicjsonDataActivity;
		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}



		return value;
	},
	getDecimalAlignFormat:function(value,isAnchor)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLinkDefault"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			value = value.toString();
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
});

