// JavaScript Document

Ext.define('RumJSErrorApp.view.RumReportsForm',{
	extend:'Ext.form.FieldContainer',
	alias:'widget.RumReportsForm',
	collapseMode:'mini',
	id:'RumReportsForm',
	layout:'column',
	defaults:{
		labelAlign:'top',
		 margin:'0 20 10 0',
		labelSeparator:''
	},
	items:[
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 130,
				editable : false,
				id: 'report_category',
				name: 'report_category',
				fieldLabel:'Report For',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},{
				xtype:'scrollcombo',
				width: 90,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Report Type',
				name: 'er_type',
				id: 'er_type',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 150,
				editable : false,
				fieldLabel:'Type',
				name: 'rep_genType',
				id: 'rep_genType',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local'
			},
			
			{
				xtype:'scrollcombo',
				width: 200,
				cls: 'dropdown',
				editable : true,
				fieldLabel:'Report Type',
				name: 'eg_serverSel',
				id: 'eg_serverSel',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
				{
				xtype:'scrollcombo',
				width: 150,
				cls: 'dropdown',
				editable : true,
				fieldLabel:'Report Type',
				name: 'er_compSel',
				id: 'er_compSel',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},			
			{
				xtype:'scrollcombo',
				width: 220,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Component Type',
				name: 'er_compType',
				id: 'er_compType',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:false
			},		
					
			{xtype:'timeline',margin:0},
			{
				xtype:'checkboxfield',
				cls: 'checkbt',
				margin:'20 20 0 0',
				boxLabel: 'Show Legends',
				inputValue: 'true',
				hidden:true,
				id: 'showLegend'
			},
			{
				xtype:'button',
				text: submitValue,
				ui:'newButtonSmall',
				itemId: 'submit',
  				margin:'20 10 10 0'
			},
			{
				xtype:'button',
				text: "Save",
				ui:'newButtonSmall',
				itemId: 'save',
  				margin: "20 10 10 0"
			},
			
		],
		listeners:{
		render:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		show:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		hide:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		}
	},
	toggleSubmitSaveBtn:function(component){

			var mainform=Ext.getCmp('mainform');
			var RumReportsForm=Ext.getCmp('RumReportsForm');
			var hiddenFields=  appConstants.publicjsonDataActivity.hiddenfields;
			 

			if (hiddenFields.fromScheduleModify == "Yes" || hiddenFields.fromFavoriteModify == "Yes") 
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					RumReportsForm.getComponent('submit').hide();
					RumReportsForm.getComponent('save').show();
				//	RumReportsForm.getComponent('submit').hide();
				}
				else
				{
					mainform.getComponent('save').show();
					RumReportsForm.getComponent('submit').hide();
					RumReportsForm.getComponent('save').hide();
					//RumReportsForm.getComponent('submit').hide();
				}
 			}
			else
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					RumReportsForm.getComponent('submit').hide();
					RumReportsForm.getComponent('save').hide();
					RumReportsForm.getComponent('submit').show();
				}
				else
				{
					mainform.getComponent('save').hide();
					RumReportsForm.getComponent('submit').show();
					RumReportsForm.getComponent('save').hide();
					//RumReportsForm.getComponent('submit').hide();
				}
			}
	}
});