Ext.define('RumKPIOverviewApp.controller.RumKPIReportController',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'usertimeline',ref:'usertimeline'},
		{selector: 'RumKPIReportsForm',ref: 'RumKPIReportsForm'},
		{selector: 'egcomponent',ref: 'egcomponent'},
		{selector: 'mainform',ref: 'mainform'},
		{selector: 'reporterdata',ref:'reporterdata'},
 		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({
			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.afterMainRender,
				'boxready':this.refreshReportData
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},			
			'mainform combo[name="select_farm"]':{
				'select': this.zoneOnChange
			},
			'mainform combo[name="er_server"]':{
				'select': this.serverOnChange
			},
			'mainform button[id="InfoexpandSelector"]': {
                'click': this.expandMe
            },
			'mainform button[id="expandSelector1"]': {
                'click': this.expandMe
            },
			'mainform button[id="expandSelector"]': {
                'click': this.expandMe
            },
			'mainform combo[name="er_wrkrGrp"]':{
				'select': this.workerGroupOnChange
			},
			'RumKPIReportsForm combo[name="duration"]':{
				'select': this.RefreshEvent
			},
			'RumKPIReportsForm combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'RumKPIReportsForm button[itemId="submit"]':{
				'click': this.showResult
			},
			'mainform button[itemId="save"]': {
					"click": this.goTo
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'mainform trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			}			
		});
	},
	RefreshEvent:function()
	{
		var me=this;
		var urlForAjax="/final/reporter/ErRumKPIReportJson.jsp";
		initLdgMask.show();
		this.updateQStringActivity();
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				appConstants.publicjsonDataActivity=jsonData;
				me.fillFormFieldsForActivity(jsonData);
				Ext.getCmp('resultPanel').hide();
				initLdgMask.hide();
			}
		});
	},
	Changerep_genType:function(obj)
	{
			appConstants.erGraphType=obj.getValue();
			if(!Ext.isEmpty(appConstants.publicjsonDataActivity))
				this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
	},
	goTo: function (btn) {
 		var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;		
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			this.saveFavorite(btn);
		}
    },
	
	 changeEr_mode: function (combo) {
		var favorite_id= appConstants.publicjsonDataActivity['hiddens']["favorite_id"];
		var from_schModify=appConstants.publicjsonDataActivity['hiddens']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
            duration: 250,
            to: {
                y: -530
            }
        });
		this.showResult();
     },
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
	   appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_server'),appConstants.rawDataForComponents);
    },	
	workerGroupOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var urlForAjax;
		
	},
	zoneOnChange:function(){	
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var urlForAjax="/final/reporter/ErRumKPIReportJson.jsp";		
		var QString="";		
		
		this.updateQStringActivity();
		QString=appConstants.queryStringActivity;
			
		var me=this;
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : QString,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				if(!Ext.isEmpty(jsonText))
				{
					var jsonData=Ext.decode(jsonText);
					me.fillFormFieldsForActivity(jsonData);			
				}
			}
		});	
		appConstants.isLoad=true;
	},
	 expandMe: function (btn) {
		
		var idName="";
		var lblId="";
		var id=btn.getItemId();
		
		if(id=="expandSelector1")
		{
			idName="select_farm";
			lblId="siteLbl";
		}
		else
		{
			idName="er_server";
			lblId="compLbl";
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp(idName),Ext.getCmp(lblId).text,btn);
	},
	serverOnChange:function(){
		
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
	
		var s_server=Ext.getCmp('er_server').getValue();		
		var me=this;
		
		
			initLdgMask.show();
			this.updateQStringActivity();
			var url1="/final/reporter/ErRumKPIReportJson.jsp";
			Ext.Ajax.request(
			{
				url : url1,
				params : appConstants.queryStringActivity+"&changeInfoVal=true",
				scope:this,
				method : 'POST',
				success: function(response){

					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					
					me.fillFormFieldsForActivity(jsonData);
					initLdgMask.hide();
				}
			});
		
	},	
	saveReportAsPDF:function(){
		var saveQString;
		saveQString=appConstants.publicjsonDataActivity.saveQString;
		saveQString+="&printGraph=yes&opt=chart";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			saveQString+="&er_view=PRINT";		
		
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString;
		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		s_qryString=this.getGridColSortParam(s_qryString);
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString;
		saveQString=appConstants.publicjsonDataActivity.saveQString;
		saveQString+="&printGraph=yes&opt=chart";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			saveQString+="&er_view=PRINT";		
		
		var s_qryString =saveQString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryStringActivity;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);

			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}
		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	printReport:function(){

		var s_qryString;
		
		var saveQString=appConstants.publicjsonDataActivity.saveQString;
		s_qryString = "../servlet/com.eg.ErRumKPIServletC?"+saveQString+"printGraph=yes&pdfPrint=yes";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			s_qryString+="&er_view=PRINT";
		s_qryString=this.getGridColSortParam(s_qryString);
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in 
	},
	sendMail:function(){		
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(btn){
		var isValid = this.validateMainForm(false);
	
		if(isValid){
			var s_qryString;
			
				this.updateQStringActivity();				
				s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;
						
			
			var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			if (btn.getItemId()=='save')
				document.location=target+'&showSchWindow=no';
			else
				parent.scheduleWindowFn(target);
		}		
	},
	saveFavorite:function(btn){
		var isValid = this.validateMainForm(false);
		var favorite_id ="";
		
		if(isValid){
			var s_qryString;
		
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			favorite_id = hiddenFields["favorite_id"];
			this.updateQStringActivity();				
			s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";
				
			
			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//+"&FavoriteId="+favorite_id;
			if (btn.getItemId()=='save')
				document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
			else
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		
		var zone=mainForm.findField('select_farm')
		
			if(zone.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'RUM Report',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
			
			
				var server=Ext.getCmp('er_server');
				
				if( server.getValue() == '-1'){
					Ext.MessageBox.show({
					title: 'RUM Report',
					msg: server.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}	
		
		var isSettingsOk = true;
		var reportgen = this.getSettingsFieldValue('reportGeneration');
		
		if ( reportgen!=null && reportgen == 'foreground' ){
			
		}
		else{
			var reportName = this.getSettingsFieldValue('bgReportName');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var server=Ext.getCmp('er_server');
		var isValid = this.validateMainForm(true);		
		if(isValid)
			this.submitReport();
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && reportgen == 'background' ) {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	submitReport:function(){
		initLdgMask.show();
		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
		
 		var reportGeneration= this.getSettingsFieldValue('reportGeneration');
		var reportType='';
		var url;
		var backgroundUrl;
		var Qstring;
		var dataAvailable=false;
		var mainForm =Ext.getCmp('mainform').getForm();		
		
		this.updateQStringActivity();
		Qstring=appConstants.queryStringActivity;
		backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";		
		url="../servlet/com.eg.ErRumKPIServletC"			
 		Qstring+= '&er_RmDispName='+appConstants.er_RmDispName+'&isSubmit=true&responseType=json';	
 		
 		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		resultPanelObj.removeAll();
	
		if(reportGeneration == 'foreground'){
 			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);		
						appConstants.publicjsonDataActivity=jsonData;					
						this.loadJsScriptReportData(jsonData);
				}
			});
		}
		else if(reportGeneration == 'background'){
			resultPanelObj.hide();
			var me=this;
 			var htmlStr = '';
			initLdgMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
 				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td>Error In BackGround Generation</td></tr></table></td></tr></table>';
					}
  					me.getBackGroundPanel().update(htmlStr);
 					me.getBackGroundPanel().show();
					initLdgMask.hide();
				}
			});
		}
	},
	loadJsScriptReportData:function(jsonData)
	{		
		var me=this;
		var dataAvailable=false;
		var resultPanelObj=Ext.getCmp('resultPanel');
		var gridData=jsonData.Results;
		var info_msg="";
		if ( !Ext.isEmpty( gridData ) ){
			var mainColumns=gridData.mainColumns;
			var sub_columns=gridData.sub_columns;	
			var dispColumns=gridData.dispColumns;	
			info_msg=gridData["INFO_MSG"];			
			var title=gridData.gridTitle;
			if(!Ext.isEmpty(mainColumns) || !Ext.isEmpty(mainColumns))
			{
							
				content='<div class="newTable"  style="overflow-y: auto;">' + '<table cellspacing="0" cellpadding="0" border="0" width="100%"><col width="17%"><col width=""><col width="140px">' + '<thead>' + '<tr style="height:30px !important;" >';		
				
				for(var i=0;i<dispColumns.length;i++)
				{
					var colName=dispColumns[i];
					content+='<th style="vertical-align:middle !important;">';
					content+='<div style="margin-left:5px !important;">';
					content+='<div><div align="center" style="font-size:10px !important;">';
					content+=colName;
					content+='</div>'+'</div></div>'+'</th>';
				}
				content+='</tr>' + '</thead>' + '<tbody>' + '<tpl for=".">';
				for(var i=0;i<mainColumns.length;i++)
				{
					var key=mainColumns[i];
					var mainColData=gridData[key];	
					if(!Ext.isEmpty(mainColData))
					{		
						dataAvailable=true;
						var sortValues=gridData[key+'_sort'];	
						
						content += '<tr >' 
						content+='<td  align="left" >';
						content+=key+'</td>';
						content+='<td style="padding:10px">';

						for(var j=0;j<sub_columns.length;j++)
						{
							var sub_key=sub_columns[j];
							var rootjson=mainColData[sub_key];
							var percentValue=rootjson['percent'];	
						
							content+= '<div align="right" style="height:25px;float:left;width:20%;display:inline-block;">';
							content+='<span style="margin-left:2px;">'+sub_key;
							content+='</span></div>';
							
							if(strSkin=='Light')
							{	
								content+='<div style="width:78%;height:25px;float:right" >';
								content+='<div style="border-color:'+rootjson['colorCode']+';border-width:1px; border-style:solid;height:25px;width:'+rootjson['percent']+'% !important;background-color:'+rootjson['colorCode']+' !important;">';
								content+= '<div style="word-wrap:nowrap;white-space:nowrap;float:left;display:inline-block;text-shadow: 0px 0px 2px #999;"><span style="padding:4px;text-transform:lowercase">'+rootjson['value']+'</span></div>';
								content+='</div>';
								content+='</div>';
							}
							else
							{							
								content+='<div style="width:78%;height:25px;float:right" >';
								content+='<div style="border-color:'+rootjson['colorCode']+';border-width:1px; border-style:solid;height:25px;width:'+rootjson['percent']+'% !important;background-color:'+rootjson['colorCode']+' !important;">';
								content+= '<div style="word-wrap:nowrap;white-space:nowrap;float:left;display:inline-block;color:#fff;text-shadow: 0px 0px 2px #000;"><span style="padding:4px;text-transform:lowercase">'+rootjson['value']+'</span></div>';
								content+='</div>';
								content+='</div>';
							}						
						}
						content+='</td>';	
					//	content+='<td align="center" style="vertical-align:middle;background-color:transparent !important;border-width:1px;border-style:solid;" class="x-grid-cell"><div style="float:left;margin-left:15px;margin-right:15px;"   id="fusion'+i+'"></div>' ;
						content+='<td align="center" >' ;
						if(!Ext.isEmpty(sortValues))
						{
							content+='<div style="float:center;margin-right:10px;margin-left:10px;">';
							content+='<table style="border:0px">';
							content+='<tr style="background-color:transparent !important;">';					
							content+='<td  style="background-color:transparent !important;border:0px">'+sortValues['Max']+'  Max';
							content+='</td>';
							content+='</tr>';
							content+='<tr style="background-color:transparent !important;border:0px">';
							content+='<td  style="background-color:transparent !important;border:0px">'+sortValues['Avg']+'  Avg';
							content+='</td>';
							content+='</tr>';
							content+='<tr style="background-color:transparent !important;">';
							content+='<td  style="background-color:transparent !important;border:0px">'+sortValues['Min']+'  Min';
							content+='</td>';
							content+='</tr>';
							content+='</table>';
							content+='</div>' ;		
						}
						content+='</td>';					
						content+='</tr>';	
					}					
				}
				content += '</tpl>' + '</tbody>' + '</table>' + '</div>';					
				
				if(!Ext.isEmpty(info_msg) && dataAvailable)
				{
					content+='<table style="margin-top:5px !important;border:0px;">';
					content+='<tr><td style="width:20px;padding:5px 5px 5px 5px;valign:top;font-weight:bold !important">**</td>';
					content+='<td style="word-wrap:break-word;white-space:wrap;width:100%">'+info_msg;
					content+='</td></tr></table>';					
			
				}
				if(dataAvailable)
				{					
					resultPanelObj.removeAll();
					resultPanelObj.setTitle(title);
					resultPanelObj.add({
					xtype:'panel',
					//ui:'newGraphPanel',
					margin:'0 10 0 10',
					//title:"<span class='font_bold'>"+title+"</span>",
					html:content,	
					});
					resultPanelObj.show();
					resultPanelObj.doLayout();
					
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					//Ext.getCmp("csvTool").setDisabled(true);
					//this.loadChartUrl(gridData);
				}				
			}
		}		
			
		if(!dataAvailable)
		{
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);			
			//Ext.getCmp("csvTool").setDisabled(true);
			
			this.disableTools();
			resultPanelObj.hide();
 			this.getNomeasurepanel().show();			
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
		}
		initLdgMask.hide();	
	},
	loadChartUrl:function(gridData)
	{		
		var dataAvailable=false;
		var mainColumns=gridData.mainColumns;
		var chart_urls=gridData.chart_urls;
		for(var i=0;i<mainColumns.length;i++)
		{
			var key=mainColumns[i];
			var idVal='fusion'+i;
			var url=chart_urls[key+'_chart']
			var xmldata=this.getXmlForUrl(url);
			if(!Ext.isEmpty(xmldata))
			{
				var dataSet=xmldata.DataSet;
				if(!Ext.isEmpty(dataSet))
				{
					dataAvailable=true;
					this.loadLineChart(idVal,dataSet);	
				}
			}
			if(!dataAvailable)
			{
				Ext.get(idVal).update('<table width="100%" height="100%"><tr><td align="center" valign="middle"><img width="150" hieght="120" src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>');
			}
		}
	},
	
	loadLineChart:function(id,dataHm)
	{			
		var value=this.calculateMinValue(dataHm);		
			jQuery("#"+id).sparkline(dataHm, {	
				type: 'bar',
				width: '120',
				barColor: '#3e6abb',
				height:'50',
				barWidth: 12,
				chartRangeMin:value,
				highlightSpotColor:'#d5870b',
				highlightBarColor:'#eed10f',
			});		
			
	},	
	calculateMinValue:function(dataHm)
	{
		var maxRange=0;
		var minRange=0;
		for(var i=0;i<dataHm.length;i++)
		{
			var val=dataHm[i];
			if(minRange>val)
				minRange=val;
			if(maxRange<val)
				maxRange=val;
		}
		if(maxRange==minRange)
			return this.changeMinRangeVal(minRange);
		else
			minRange;
	},
	changeMinRangeVal:function(range)
	{		
		if(range<=0)
			range=-0.1;
		else if(range<=1)
			range=0.05;
		else if(range<=10)
			range=1;
		else if(range<=100)
			range=10;
		else if(range<=1000)
			range=100;
		else if(range<=10000)
			range=1000;
		else if(range<=100000)
			range=10000;
		return range;
	},
	
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					chartAttrib=Ext.decode(jsonText);
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
		}
	},
	weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');

		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQStringActivity:function(){
		var FormParams='';
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		
		
		
		var serverArray=new Array();
		
		var select_farmVal=Ext.getCmp('select_farm').getValue();				
		FormParams+="select_farm="+select_farmVal;		

		FormParams+="&er_reportgenration="+this.getSettingsFieldValue('reportGeneration');
		
		var er_serverVal=Ext.getCmp('er_server').getValue();
		FormParams+="&er_workgroupserver="+er_serverVal;
		FormParams+="&er_server="+er_serverVal;
		
		var durationVal =Ext.getCmp("duration").getValue();

		
		
		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields'))
		{
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}		
			
		if(appConstants.isreportsneedService!="null")
				FormParams+="&isreportsneedService="+appConstants.isreportsneedService;
		if(appConstants.componenttest!="null")
				FormParams+="&componenttest="+appConstants.componenttest;
		if(appConstants.er_rep!="null")
				FormParams+="&er_rep="+appConstants.er_rep;
		FormParams+="&ReportFrom=RUM_Report";
		FormParams+="&s_duration="+durationVal; 	
		
		appConstants.queryStringActivity=FormParams+hiddenfieldQString;
  	},
	
	afterMainRender:function(){
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp("leftCallout").hide();
		var thisController = this;		
		if(appConstants.er_rep!="null")
		{
			var selectFarm=Ext.getCmp("select_farm");
		}		
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonDataActivity.reportTitle);
		this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
		if(!hideBackButton){
			Ext.getCmp('RumKPIReportsForm').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicjsonDataActivity['ID']
			});				
		}
	},
	
	refreshReportData:function(){
		var jsonData;
		jsonData=appConstants.publicjsonDataActivity;		
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
            initLdgMask.show();
			this.loadJsScriptReportData(jsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	fillFormFieldsForActivity:function(jsonData)
	{
		var rep_type="";
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var compSel="er_server";
		var serverSel="select_farm";
		
	
		if(appConstants.isSubmit=="true")
			isSubmitted=appConstants.isSubmit;
		
		var mainForm =Ext.getCmp('mainform').getForm();
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.zoneCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedZone;
			comboObject=mainForm.findField(serverSel);			
			comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);	
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);
		}
		
	
		comboRawData=jsonData.serverCombo;
		if ( !Ext.isEmpty(comboRawData) ){			
			selectedComboOption=jsonData.selectedServer;
			comboObject=Ext.getCmp(compSel);
			appConstants.rawDataForComponents = comboRawData;
			comboObject.setFieldLabel(screenLabels['reporter.common.Component']);
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);			
			else
				comboObject.setValue(comboRawData[0].valueField);			
			comboObject.show();
		}
		
	
		comboRawData=jsonData.durationCombo;
		if ( !Ext.isEmpty(comboRawData) ){
			
			selectedComboOption=jsonData.selectedDuration;
			comboObject=Ext.getCmp("duration");
			appConstants.rawDataForComponents = comboRawData;
			comboObject.setFieldLabel(screenLabels['reporter.common.Duration']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.hide();
		}

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=Ext.getCmp('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);

		

		 updatingAppSettings();		 
		
	},	
	getSettingsFieldValue:function(id)
	{
		var publicJsonData=null;
		publicJsonData = appConstants.publicjsonDataActivity;
		var value='';		
		var item_field = Ext.getCmp(id);
		if(!Ext.isEmpty(item_field))
		{
			value = item_field.getValue();
		}
		
		return value;
	}
});

