// JavaScript Document

Ext.define('RumKPIOverviewApp.view.RumKPIReportsForm',{
	extend:'Ext.form.FieldContainer',
	alias:'widget.RumKPIReportsForm',
	collapseMode:'mini',
	id:'RumKPIReportsForm',
	layout:'column',
	defaults:{
		labelAlign:'top',
		 margin:'0 20 10 0',
		labelSeparator:''
	},
	items:[
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable : true,
				id: 'select_farm',
				name: 'select_farm',
				fieldLabel:'Report For',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 170,
				editable : true,
				id: 'er_server',
				name: 'er_server',
				fieldLabel:'Report For',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},	
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 150,
				editable : false,
				id: 'duration',
				name: 'duration',
				fieldLabel:'Duration',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},			
			{xtype:'reportgeneration', margin: '0 20 5 0'},			
			{
				xtype:'button',
				text: submitValue,
				ui:'newButtonSmall',
				itemId: 'submit',
  				margin:'20 10 10 0'
			},
			{
				xtype:'button',
				text: "Save",
				ui:'newButtonSmall',
				itemId: 'save',
  				margin: "20 10 10 0",
				hidden:true
			},
			
		],
		listeners:{
		render:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		show:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		hide:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		}
	},
	toggleSubmitSaveBtn:function(component){

			var mainform=Ext.getCmp('mainform');
			var RumKPIReportsForm=Ext.getCmp('RumKPIReportsForm');
			var hiddenFields=  appConstants.publicjsonDataActivity.hiddenfields;
			 

			if (hiddenFields.fromScheduleModify == "Yes" || hiddenFields.fromFavoriteModify == "Yes") 
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					RumKPIReportsForm.getComponent('submit').hide();
					RumKPIReportsForm.getComponent('save').show();
				//	RumKPIReportsForm.getComponent('submit').hide();
				}
				else
				{
					mainform.getComponent('save').show();
					RumKPIReportsForm.getComponent('submit').hide();
					RumKPIReportsForm.getComponent('save').hide();
					//RumKPIReportsForm.getComponent('submit').hide();
				}
 			}
			else
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					RumKPIReportsForm.getComponent('submit').hide();
					RumKPIReportsForm.getComponent('save').hide();
					RumKPIReportsForm.getComponent('submit').show();
				}
				else
				{
					mainform.getComponent('save').hide();
					RumKPIReportsForm.getComponent('submit').show();
					RumKPIReportsForm.getComponent('save').hide();
					//RumKPIReportsForm.getComponent('submit').hide();
				}
			}
	}
});