
Ext.define('RumPGPReportApp.controller.PGPReportsController',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'usertimeline',ref:'usertimeline'},
		{selector: 'PGPReportsForm',ref: 'PGPReportsForm'},
		{selector: 'egcomponent',ref: 'egcomponent'},
		{selector: 'mainform',ref: 'mainform'},
		{selector: 'PGPReportsFormSettings',ref: 'PGPReportsFormSettings'},
		{selector: 'reporterdata',ref:'reporterdata'},
 		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({

			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.afterMainRender,
				'boxready':this.refreshReportData
			},
           	'PGPReportsFormSettings':{
				'afterrender':this.loadSettingsElements
            },
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'mainform combo[name="select_farm"]':{
				'select': this.zoneOnChange
			},					
			'PGPReportsFormSettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},
			'PGPReportsFormSettings combo[name="er_timeline"]':{
				//'select': this.timeLineOnChange
			},
			'PGPReportsFormSettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'PGPReportsFormSettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'PGPReportsFormSettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'PGPReportsForm button[itemId="submit"]':{
				'click': this.showResult
			},
			'PGPReportsForm combo[name="er_rum_type"]':{
				'select': this.changeInfoVal
			},
			'mainform button[itemId="save"]': {
					"click": this.goTo
			},'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			
		});
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	changeInfoVal:function()
	{
		var me=this;
		var urlForAjax;
		initLdgMask.show();
				urlForAjax="/final/reporter/ErRumPGPReportJson.jsp";
		
			this.updateQStringActivity();
			Ext.Ajax.request(
			{
				url : urlForAjax,
				params : appConstants.queryStringActivity+"&changeInfoVal=true",
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var screenLabels=jsonData.screenLabels;
					appConstants.publicjsonDataActivity=jsonData;
					me.fillFormFieldsForActivity(jsonData);
					Ext.getCmp('resultPanel').hide();
					initLdgMask.hide();
				}
				});
	},	
	goTo: function (btn) {
 		var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;
		
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			this.saveFavorite(btn);
		}
    },
	 changeEr_mode: function (combo) {
		var favorite_id='';
		var from_schModify='';
	
		favorite_id = appConstants.publicjsonDataActivity['hiddens']["favorite_id"];
		from_schModify = appConstants.publicjsonDataActivity['hiddens']["fromScheduleModify"];
		
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.showResult();
     },
		
	zoneOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var urlForAjax="/final/reporter/ErRumPGPReportJson.jsp";		
		var QString="";		
		this.updateQStringActivity();
		QString=appConstants.queryStringActivity;
		var me=this;
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : QString,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				if(!Ext.isEmpty(jsonText))
				{
					var jsonData=Ext.decode(jsonText);
					me.fillFormFieldsForActivity(jsonData);			
				}
			}
		});	
		appConstants.isLoad=true;
	},	 
	saveReportAsPDF:function(){
		var saveQString;
			saveQString=appConstants.publicjsonDataActivity.saveQString;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				saveQString+="&er_view=PRINT";
		
		
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString;
		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
	  s_qryString=this.getGridColSortParam(s_qryString);
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString;
		saveQString=appConstants.publicjsonDataActivity.saveQString;
		saveQString+="&printGraph=yes&opt=chart";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			saveQString+="&er_view=PRINT";

		var s_qryString = saveQString;
		s_qryString=this.getGridColSortParam(s_qryString);
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryStringActivity;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	getGridColSortParam:function(query)
	{
		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	printReport:function(){

		var s_qryString;
		
		var saveQString=appConstants.publicjsonDataActivity.saveQString;
		s_qryString = "../servlet/com.eg.ErRumPGPServletC?"+saveQString+"printGraph=yes&pdfPrint=yes";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			s_qryString+="&er_view=PRINT";
	  s_qryString=this.getGridColSortParam(s_qryString);
	  parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in 
	},
	sendMail:function(){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(btn){
		var isValid = this.validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'RUM Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}

		if(isValid){
			var s_qryString;
			
				this.updateQStringActivity();
				s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;					
				
			
			var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			if (btn.getItemId()=='save')
				document.location=target+'&showSchWindow=no';
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		
	},
	saveFavorite:function(btn){
		var isValid = this.validateMainForm(false);
		var favorite_id ="";
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'RUM Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		if(isValid){
			var s_qryString;
				
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			favorite_id = hiddenFields["favorite_id"];
			this.updateQStringActivity();				
			s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";
				
			
			
			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (btn.getItemId()=='save')
				document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
			else
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm =null;
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getPGPReportsFormSettings().getForm();
		var zone=mainForm.findField('select_farm')
		if(zone.getValue() == '-1'){
			Ext.MessageBox.show({
				title: 'RUM Report',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false ;
		}
			
		var server=Ext.getCmp('er_server');
				
		if( server.getValue() == '-1'){
			Ext.MessageBox.show({
				title: 'RUM Report',
				msg: server.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}	
		
		var isSettingsOk = true;

		var hiddenFields;
		hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;

		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen = this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var er_usertimeline = '';
		if ( !Ext.isEmpty(hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');


		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){

			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'RUM Report settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = hiddenFields["limitforbg"];

				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else{
			var reportName = this.getSettingsFieldValue(thinclientuserSettingsForm,'bgReportName',isSettingsEnabled,'selectedMinsTo');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	
	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
        var starthr = mainForm.findField('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = mainForm.findField('er_enddate').getValue();
        var endhr = mainForm.findField('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var server=Ext.getCmp('er_server');
		var isValid = this.validateMainForm(true);

		if(isValid)
			this.submitReport();
	},
	validateSettings :function(){
		var isSettingsOk = true;

		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && reportgen == 'background' ) {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
 			this.submitReport();
		}else{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			
				Ext.get("configMod").animate({
					to: {
						"top": 45
					},
					listeners: {
						afteranimate: function () {
							Ext.get("configMod").setStyle("left", "");
						}
					}
				}).show();
			
			var thinclientuserSettingsForm = this.getPGPReportsFormSettings().getForm();
			var reportGenType=thinclientuserSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientuserSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},		
	loadJsScriptReportData:function(jsonData)
	{
		appConstants.publicjsonDataActivity=jsonData;
		var dataAvailable=false;
		var gridData=jsonData.Results;
		var resultPanelObj=Ext.getCmp('resultPanel');
		var panel='';
		var itemsArray = new Array();
		if(!Ext.isEmpty(gridData))
		{
			var title=appConstants.er_RmDispName;
			//var content="";
			var summaryData=gridData.summary_Results;
			var sumary_columns=gridData.summary_Columns;
			var ChartData=gridData.ChartData;
			var summ_title=gridData.summary_Title;
			var diff_days=gridData.diff_days;
			var start_Date=gridData.start_Date;
			var end_Date=gridData.end_Date;
			var server=gridData.server;
			var isGeo=gridData.isGeo;
			var satValue=gridData.satValue;
			var tolValue=gridData.tolValue;
			var frusValue=gridData.frusValue;
			var dummyTxt=" Page Views";
			if(!Ext.isEmpty(isGeo))
				dummyTxt=" hits from :";
			
			var chartAvailable = false;
			var content='';	
			if(!Ext.isEmpty(summaryData) && !Ext.isEmpty(sumary_columns))
			{
				dataAvailable=true;		
				 
				content='<div style="overflow-y:auto;padding-bottom:10px">' + '<table cellspacing="0" cellpadding="0" border="0px" width="100%">' + '<tbody>';
				content+='<tr>';

				content+='<td colspan="3" valign="middle" >';
				content+='<div style="float:left;margin-left:10px;margin-right:10px;margin-bottom:10px">';
							
				for(var i=0;i<sumary_columns.length;i++)
				{
					var val=sumary_columns[i];
					var data=summaryData[val];			
					if(val.indexOf("*")==-1)
					{
						if(diff_days=="true")
						{
							content+='<div style="margin:5px 5px 5px 0px;" class="newFont_normal12">Between <span class="newFont_bold12">'+start_Date+'</span> and <span class="newFont_bold12">'+end_Date+'</span>, '+server+' '+val+' <span class="newFont_bold12">'+data+'</span> '+dummyTxt+'</div></div></td></tr>';

							content+='<tr><td  width="30%" style="vertical-align:top !important" class="newLineRight"><div style="float:left;margin-left:5px;margin-right:10px;">'
							if(Ext.isEmpty(isGeo))
								content+='<div style="margin:10px 0px 10px 10px" class="newFont_normal12">Breakup by User Experience</div>';
						}else
						{
							content+='<div style="margin:5px 5px 5px 0px;" class="newFont_normal12">Since <span class="newFont_bold12">'+start_Date+'</span>, '+server+' '+val+' <span class="newFont_bold12">'+data+'</span> '+dummyTxt+'</div></div></td></tr>';

							content+='<tr ><td   width="30%" style="vertical-align:middle" class="newLineRight"><div style="float:left;margin-left:0px;margin-right:10px;">';
							if(Ext.isEmpty(isGeo))
								content+='<div style="margin:10px 0px 10px 10px" class="newFont_normal12">Breakup by User Experience</div>';
						}
						content+='<ul style="list-style-image:url(/final/images/Light/arrow-bullet-right.png); !important;" class="newFont_normal12">';
					}else				
					{
						val=val.substring(0,val.length-1);
						content+='<li style="margin:10px 0px 10px 25px;list-style-image:url(/final/images/Light/arrow-bullet-right.png); !important;"><span class="newFont_bold12">'+data+'</span> '+val+'</li>';
					}	
				}
				content+='</ul>';				
				content+='</div>';				
				content+='</td>';
				if(Ext.isEmpty(isGeo))
				{
					content+='<td valign="top"  width="45%" class="newLineRight" style="vertical-align:middle"><div style="float:center;" id="fusion"></div>';	
					if(!Ext.isEmpty(frusValue) && !Ext.isEmpty(satValue) && !Ext.isEmpty(tolValue))
					{
						content+='<td valign="middle" align="center"  width="25%">';
						content+='<div class="newTable" style="width:200px;margin-right:10px"><table width="100%" cellspacing="0" cellpadding="0" border="0" >';
						content+='<thead>';
						content+='<tr>';
						content+='<th colspan="2"><div style="text-transform:none" class="newFont_bold12">'+appConstants.userExpTitle+'</div>';
						content+='</th>';
						content+='</tr>';
						content+='</thead>';
						content+='<tbody>';
						content+='<tr style="background-color:transparent !important"><td>'+appConstants.satisfied+'</td><td>'+satValue+' '+appConstants.seconds+'</td></tr>';
						content+='<tr style="background-color:transparent !important"><td>'+appConstants.tolerating+'</td><td>'+tolValue+' '+appConstants.seconds+'</td></tr>';
						content+='<tr style="background-color:transparent !important"><td>'+appConstants.frustrated+'</td><td>'+frusValue+' '+appConstants.seconds+'</td></tr>';				
						content+='</tbody></table></div>';
						content+='</td>';
					}
				}
				content+='</tr>';
				content+='</tbody>';
				content+='</table>';
				content+='</div>';
				/*resultPanelObj.add({
					xtype:'panel',
					ui:'newGraphPanel',
					columnWidth:0.35,
					html:content
				});*/
				/*var panel = Ext.create(Ext.panel.Panel, {
					title:'',
					ui:'newGraphPanel',
					margin:'10 10 10 10',
					items:[{
						xtype:'panel',
						html:content
					}]	
				});	*/
				itemsArray.push({
					xtype:'panel',
					ui:'newGraphPanel',
					margin:'10 10 10 10',
					title:summ_title,
					items:[{
						title:'',
						html:content
					}]
				});

			}	
				var content='';
				var det_title=gridData.details_Title;
				var det_keys=gridData.details_key;
				var details_data=gridData.details;
				var columnname=gridData.Test_Name;	
				var chartkeys=new Array();
				if(!Ext.isEmpty(details_data))
				{					
					var dispTestName=det_title;
					//if(Ext.isEmpty(isGeo))
					//dispTestName+=' - '+columnname
					content='<div>';
					content+='<table width="100%" cellspacing="0" cellpadding="0" border="0">';
					content+='<tr>';
					content+='<td colspan="4"><div style="padding:10px;" class="newFont_bold14">'+dispTestName;
					content+='</div></td>';				
					content+='</tr>';
					for(var i=0;i<det_keys.length;i++)
					{
						var key=det_keys[i];
						var dataObj=details_data[key];
						var data=dataObj.data;
						var urls=dataObj.urlList;
						var columns=dataObj.columns;						
						
						if(!Ext.isEmpty(urls) && !Ext.isEmpty(data))
						{	
							chartkeys.push(key);
							if(!Ext.isEmpty(isGeo))
							{							
								var colStr=gridData[key+"_TestName"];
								columnname=colStr;
								key=key.substring(0,key.lastIndexOf("_"));
							}
							content+='<tr>';
							content+='<td colspan="4"><div style="padding:10px 10px 0px 10px;" class="newFont_bold13">'+key;
							content+='</div></td>';	
							content+='</tr>';
							
							content+='<tr>';
							content+='<td style="padding:5px 10px 10px 10px" colspan="4">';
							content+='<div class="newTable"><table cellspacing="0" cellpadding="0" border="0" width="100%"><col width="250px">' + '<thead>' + '<tr >';		
							
							content+='<th >';
							content+='<div align="center" style="padding:2px">';
							content+=columnname;
							content+='</div></th>';
							for(var j=0;j<columns.length;j++)
							{
								var colName=columns[j];
								colName=colName.substring(0,colName.lastIndexOf(" "));
								content+='<th >';
								content+='<div align="center" style="padding:2px;">';
								content+=colName;
								content+='</div></th>';							
							}
							content+='</tr>' + '</thead>' + '<tbody>' + '<tpl for=".">';
							for(var j=0;j<urls.length;j++)
							{
								var url=urls[j];
								var urlData=data[url];
								var dd_Url=urlData["dd_Url"];							
								content += '<tr>' 
								if(url.indexOf("_ddUrl")>-1)
								{
									url=url.substring(0,url.lastIndexOf("_"));
									content+='<td  style="background-color:transparent !important;padding:5px;vertical-align:middle;" align="left" data-qtip="'+url+'" data-qclass="yellowTip"><span style="text-transform:none">';
									content+= '<a href="javascript:void(0);" onClick="javascript:openInNewWin(\''+dd_Url+'\');" >'+this.truncate(url, 40,'...')+'</a>';
									content+='</span></td>';
								}else
								{
									content+='<td  style="background-color:transparent !important;padding:5px;vertical-align:middle;" align="left" data-qtip="'+url+'" data-qclass="yellowTip"><span style="text-transform:none">';
									content+=this.truncate(url, 40,'...')+'</span></td>';
								}
								for(var k=0;k<columns.length;k++)
								{
									var colName=columns[k];
									var rootjson=urlData[colName];

									var percentValue=rootjson['percent'];

										content+='<td style="padding:5px;background-color:transparent !important;" >';
										content+='<div style="width:100%;height:18px;float:left" >';
										content+='<div style="border-color:'+rootjson['colorCode']+';border-width:1px; border-style:solid;height:18px;width:'+percentValue+'% !important;background-color:'+rootjson['colorCode']+' !important;display:inline-block;">';
									if(strSkin=='Light')
									{
										//content+= '<div style="white-space:nowrap;float:left;display:inline-block;text-shadow: 0px 0px 2px #999;"><span style="padding:4px;text-transform:lowercase">'+rootjson['value']+'</span></div>';
										content+= '<div style="white-space:nowrap;float:left;display:inline-block;"><span style="padding:4px;text-transform:lowercase">'+rootjson['value']+'</span></div>';
									}else
									{
										//content+= '<div style="white-space:nowrap;float:left;display:inline-block;text-shadow: 0px 0px 2px #000;"><span style="padding:4px;text-transform:lowercase">'+rootjson['value']+'</span></div>';
										content+= '<div style="white-space:nowrap;float:left;display:inline-block;"><span style="padding:4px;text-transform:lowercase">'+rootjson['value']+'</span></div>';
									}
										content+='</div>';
										content+='</div>';
										content+='</td>';
								}
								content+='</tr>';
							}						
							content += '</tpl>' + '</tbody>' ;
							content+='</table></div>';
							content+='</td>';
							content+='</tr>';
							

							/*itemsArray.push({
							xtype:'panel',
							ui:'newGraphPanel',
							margin:'10 10 10 10',
							items:[{
								title:'',
								html:content
							}]
						});	 */
						}
					}
							content+='</table>';
							content+='</div>';
							itemsArray.push({
								xtype:'panel',
								ui:'newGraphPanel',
								margin:'10 10 10 10',
								title:'',
								items:[{
									title:'',
									html:content
							}]
						});	 
					
				}
					var content='';
					if(!Ext.isEmpty(isGeo))
					{					
						var chartTitle=gridData.chartTitle;
						var colWidth = 100/chartkeys.length;
						var colWidthStr = '';
						for(var i=0;i<chartkeys.length;i++)
						{
							colWidthStr+='<col width='+colWidth+'%>'
						}
						content='<div class="newTable" style="margin:5px 10px 10px 10px">';
						content+='<table cellspacing="0" cellpadding="0"  width="100%">'+colWidthStr;
						content+= '<tbody>' + '<tpl for=".">';
						content += '<tr style="background-color:transparent !important">' 
						
						for(var i=0;i<chartkeys.length;i++)
						{
							var key=chartkeys[i];
							var chartObj=details_data[key];						
							var id="fusion"+i;
							content+='<td style="vertical-align:middle" class="newLineRight" ><div style="float:center;" id="'+id+'"></div></td>';
							
						}
						
						content+='</tr>';
						content += '</tpl>' + '</tbody>' ;
						content+='</table>';
						content+='</div>';
						itemsArray.push({
							xtype:'panel',
							ui:'newGraphPanel',
							margin:'10 10 10 10',
							title:chartTitle,
							items:[{
								title:'',
								html:content
							}]
						});	
						
					}
				//}
										
				/*content+='</tbody></table>';				
				content+='</div>';*/	

			
				if(dataAvailable)
				{
					resultPanelObj.removeAll();	
					resultPanelObj.add(itemsArray);
					/*resultPanelObj.add({
						xtype:'panel',
						//cls:'datapanel',
						//title:"<span class='font_bold'>"+title+"</span>",
						//margin: '0 10 10 0',	
						
					});*/
					//resultPanelObj.add(panel);
					/*resultPanelObj.add({
						xtype:'panel',
						margin:'10 10 10 10',
						ui:'newGraphPanel',
					});	*/
					//resultPanelObj.add(panels);
					/*resultPanelObj.add({
						xtype:'panel',
						margin:'10 10 10 10',
						ui:'newGraphPanel'
					});*/
					resultPanelObj.show();
					if(Ext.isEmpty(isGeo))
						this.loadLineChart('fusion',ChartData,175,360,isGeo);
					else{
						if(!Ext.isEmpty(chartkeys))
						{
							for(var i=0;i<chartkeys.length;i++)
							{
								var key=chartkeys[i];
								var chartObj=gridData[key+'_ChartData'];
								var id="fusion"+i;
								var containerObj=Ext.get(id);
								this.loadLineChart(id,chartObj,250,400,isGeo);						
							}
						}
					}
					resultPanelObj.doLayout();
				
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					//Ext.getCmp("csvTool").setDisabled(true);
				}
			//}
		}
		if(!dataAvailable)
		{
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);			
			//Ext.getCmp("csvTool").setDisabled(true);
			
			this.disableTools();
			resultPanelObj.hide();
 			this.getNomeasurepanel().show();			
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
		}
		initLdgMask.hide();	
	},
	truncate : function (fullStr, strLen, separator) {
		if (fullStr.length <= strLen) return fullStr;

		separator = separator || '...';

		var sepLen = separator.length,
			charsToShow = strLen - sepLen,
			frontChars = Math.ceil(charsToShow/2),
			backChars = Math.floor(charsToShow/2);

		return fullStr.substr(0, frontChars) + 
			   separator + 
			   fullStr.substr(fullStr.length - backChars);
	},
	loadLineChart:function(id,data,height,width,isGeo)
	{	
		if ( !Ext.isEmpty( data ) && data.hasOwnProperty('XML') )
		{
			var innerHtml=data.innerHtml;
			var chartFor =data.chartFor;
			var chartHight =data.chartHight;
		
			var lineChart = {};
			if(isGeo==null)	
			{				
				lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(id,height,width), lineChart);
				lineChart.setData(data,'<%=currentDateFormat%>','');
				lineChart.drawChart();				
			}else
			{
				var containerObj=Ext.get(id);
				this.updatePieChart(data,'pieColors','urlLinks','pieLabels',containerObj);
			}
			
		}else
		{		
			Ext.get(id).update('<table width="100%" height="100%"><tr><td align="center" valign="middle"><img   width="100%" height="100%" src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>');			
		}
	},
	updatePieChart:function(legendObj,bgColorName,urlLinkName,legendLabelName,containerObj)
	{			
		var genHTML = '<table cellpadding="0" cellspacing="0" border="0" style="margin:5px;border:0px">';
		genHTML += '<tr style="background:transparent">';
		var idd='piegraphdiv';
		if(!Ext.isEmpty(idd))
			idd+='_'+containerObj.id;
		if (!$.isArray(legendObj))
		{
			var pieLabels = legendObj[legendLabelName];
			var pieColors = legendObj[bgColorName];
			var pieLinks =  legendObj[urlLinkName];
			for (var key in pieLabels)
			{
				var legendLabel = pieLabels[key];
				var legendColors = pieColors[key];
				var legendLinks = pieLinks[key];				
				if (!Ext.isEmpty(legendLinks) && legendLinks.indexOf('openInNewWin')>-1)
				{						
					 legendLinks = legendLinks.substring(legendLinks.indexOf("(")+1,legendLinks.length-1);
					 console.log('openinnewwin	'+legendLinks	);
				}
				
				genHTML += '<td style="border:none;padding-right:0px"><div style="background-color:#'+legendColors+';width:8px;height:8px;border-radius:4px;"></div></td>';

				genHTML	+='<td style="border:none" class="font_normal10"><a href="javascript:void(0);" >'+legendLabel+'</a></td>';
				genHTML += '</tr><tr style="background:transparent">';
			}
		}
		else
		{
			 for (var i=0; i <legendObj.length;i++)
			 {
				var bgcolor=legendObj[i][bgColorName];
				if (bgcolor.indexOf('#')<0)
				{
					bgcolor='#'+bgcolor;
				}
				genHTML += '<td style="border:none;padding-right:0px"><div style="background-color:'+bgcolor+';width:8px;height:8px;border-radius:4px;"></div></td>';

				genHTML	+='<td style="border:none" class="font_normal10"><a href="javascript:void(0);" >'+legendObj[i][legendLabelName]+'</a></td>';
				genHTML += '</tr><tr style="background:transparent">';
			 }
		}
		genHTML += '</tr>';
		genHTML += '</table>';
		 
		var content;		
		 
		content='<div align="center"><div id="'+idd+'" height="300px"></div><div>'+genHTML+'</div></div>';
		
		containerObj.update(content);
		
		var lineChart = {};
		lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(idd,highChartPieHeight,highChartPieWidth), lineChart);
		lineChart.setData(legendObj,'<%=currentDateFormat%>','');
		lineChart.drawChart();
				
		
	},
	submitReport:function(){
		initLdgMask.show();
		var url;
		var backgroundUrl;
		var Qstring;
		var dataAvailable=false;
		var mainForm =Ext.getCmp('mainform').getForm();
			if(!isSettingsEnabled)
				this.showConfigDropdown();
		var thinclientuserSettingsForm = this.getPGPReportsFormSettings().getForm();		
			
		this.updateQStringActivity();
		Qstring=appConstants.queryStringActivity;
		backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";		
		url="../servlet/com.eg.ErRumPGPServletC"			
 		Qstring+= '&er_RmDispName='+appConstants.er_RmDispName+'&isSubmit=true&responseType=json';
		
 		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
 		var reportGeneration=Ext.getCmp('reportGeneration').getValue();
		var reportType='';
 		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		resultPanelObj.removeAll();
	
		if(reportGeneration == 'foreground'){
 			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);					
						this.loadJsScriptReportData(jsonData);
				}
			});
		}
		else if(reportGeneration == 'background'){
			resultPanelObj.hide();
			var me=this;

 			var htmlStr = '';
			//myMask = new Ext.LoadMask(Ext.getBody(), {msg : "Background Report Generation is in Progress..."});
		//	myMask.show();
		initLdgMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
 				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td>Error In BackGround Generation</td></tr></table></td></tr></table>';
					}
  					me.getBackGroundPanel().update(htmlStr);
 					me.getBackGroundPanel().show();
					//myMask.hide();
					initLdgMask.hide();
				}
			});
		}

	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	timeLineOnChange:function() {
		var mainForm =Ext.getCmp('mainform').getForm();
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var startDateObj=mainForm.findField('er_stdate');
		var startHrObj=mainForm.findField('er_sthr');
		var endDateObj=mainForm.findField('er_enddate');
		var endHrObj=mainForm.findField('er_endhr');
		var timelineObj=mainForm.findField('er_timeline');
		if(timelineObj.getValue() == 'Any'){
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else{
		timelineObj.suspendEvents(true);
		//this.loadHiddenFields(publicjsonData['hiddenfields']);
		this.updateQStringActivity();
		var url1="";
			
				url1="/final/reporter/ErRumPGPReportJson.jsp";
			
		Ext.Ajax.request(
		{
			url : url1,
			params : appConstants.queryStringActivity,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData;
				var start_hour=jsonData.startHour;
				var end_hour=jsonData.endHour;
				var start_date=jsonData.startDate;
				var end_date=jsonData.endDate;
				startDateObj.setDisabled(true);
				startHrObj.setDisabled(true);
				endDateObj.setDisabled(true);
				endHrObj.setDisabled(true);
				startDateObj.setValue(start_date);
				startHrObj.setValue(start_hour);
				endDateObj.setValue(end_date);
				endHrObj.setValue(end_hour);
			}
		});
		timelineObj.resumeEvents();
		}
	},
	/*weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');


		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},*/
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
		//Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQStringActivity:function(){
		var FormParams='';
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm=null;
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getPGPReportsFormSettings().getForm();
		var serverArray=new Array();
		
		var select_farmVal=Ext.getCmp('select_farm').getValue();				
		FormParams+="select_farm="+select_farmVal;
					
		

		FormParams+="&er_type=data&er_excwe="+this.getSettingsFieldValue(thinclientuserSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')+"&er_reportgenration="+this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		if(Ext.get('showLegend')!=null)
			FormParams=FormParams+"&showLegend="+mainForm.findField('showLegend').getValue();

		FormParams+="&er_priority="+mainForm.findField('er_priority').getValue();
		
		if(appConstants.isGeo=="null")
		{			
			var rum_type_val=Ext.getCmp('er_rum_type').getValue();
			if(rum_type_val!=null && rum_type_val!='undefined'){
				FormParams+="&er_rum_type="+rum_type_val;
			}else{
				FormParams+="&er_rum_type=-1";
			}	
		}else
		{
			FormParams+="&isGeo="+appConstants.isGeo;
		}
		
		FormParams+="&sh_timeinuse="+this.getSettingsFieldValue(thinclientuserSettingsForm,'sh_timeinuse',isSettingsEnabled,'weightedAvg');
	
		
		FormParams+="&group_by="+this.getSettingsFieldValue(thinclientuserSettingsForm,'sh_timeinuse',isSettingsEnabled,'weightedAvg');
		
		var er_serverVal=Ext.getCmp('er_server').getValue();
		FormParams+="&er_workgroupserver="+er_serverVal;
		FormParams+="&er_server="+er_serverVal;
					
		var s_timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var s_minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var s_timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var s_minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		var timperiodParams="&timefrom="+s_timefrom+"&minfrom="+s_minfrom+"&timeto="+s_timeto+"&minto="+s_minto;

		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields'))
		{
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}		
		
		if(appConstants.isreportsneedService!="null")
				FormParams+="&isreportsneedService="+appConstants.isreportsneedService;
		if(appConstants.componenttest!="null")
				FormParams+="&componenttest="+appConstants.componenttest;
		if(appConstants.er_rep!="null")
				FormParams+="&er_rep="+appConstants.er_rep;
				FormParams+="&ReportFrom=RUM_Report";
		 		
		appConstants.queryStringActivity=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
  	},
	
	afterMainRender:function(){
		var thisController = this;		
			if(appConstants.er_rep!="null")
			{
				var selectFarm=Ext.getCmp("select_farm");
				
			}		
		
			if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
				this.getMain().setTitle(appConstants.er_RmDispName);
			else
				this.getMain().setTitle(appConstants.publicjsonDataActivity.reportTitle);
			
			this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
			if(!hideBackButton){
		
			
					Ext.getCmp('PGPReportsForm').add(
					{
						xtype: 'hidden',
						id: 'ID',
						name: 'ID',
						value: appConstants.publicjsonDataActivity['ID']
					});
				
			}
	},
	loadSettingsElements:function(){
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var thisController  =this;
		
		this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndCloseSettings();
			
		});
	},
	
	validateAndCloseSettings : function()
	{
		var isSettingsOk = this.validateSettings();
		if(isSettingsOk)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	
	closeAndSubmitSettings : function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	refreshReportData:function(){
		var jsonData=appConstants.publicjsonDataActivity;		
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
            initLdgMask.show();
				this.showResult();
		}else{
			if(appConstants.isForceSubmit=='true'){
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	fillFormFieldsForActivity:function(jsonData)
	{
		var rep_type="";
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var compSel="";
		var serverSel="";
		if(appConstants.isSubmit=="true")
			isSubmitted=appConstants.isSubmit;
		serverSel="select_farm";
		compSel="er_server";
		var mainForm =Ext.getCmp('mainform').getForm();
		var screenLabels=jsonData.screenLabels;
		
		comboObject=Ext.getCmp("er_rum_type");
		comboObject.hide();
		if(appConstants.isGeo=="null")
		{
			comboRawData=jsonData.er_rum_typeCombo;
			if(!Ext.isEmpty(comboRawData))
			{
				selectedComboOption=jsonData.selecteder_rum_type;
				comboObject.setFieldLabel(screenLabels['reporter.thin.RUM Type']);
				comboObject.getStore().loadRawData(comboRawData);

				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				}
				else{
					comboObject.setValue(comboRawData[0].valueField);
				}				
			}
		}
		comboRawData=jsonData.zoneCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedZone;
			comboObject=mainForm.findField(serverSel);			
			comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);		
			comboObject.getStore().clearFilter(true); 		
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
		}	
		
		rep_type=comboObject.getValue();
		comboRawData=jsonData.serverCombo;
		if ( !Ext.isEmpty(comboRawData) ){			
			selectedComboOption=jsonData.selectedServer;
			comboObject=Ext.getCmp(compSel);
			appConstants.rawDataForComponents = comboRawData;
			comboObject.setFieldLabel(screenLabels['reporter.common.Component']);	
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
			
	
		comboRawData=jsonData.priorityCombo;		
		selectedComboOption=jsonData.selectedPriority;
		comboObject=mainForm.findField('er_priority');
		comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
		if(!Ext.isEmpty(comboRawData))
		{
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		

		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}else{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}

        var start_hour = jsonData.startHour;
        var end_hour = jsonData.endHour;
        var start_date = jsonData.startDate;
        var end_date = jsonData.endDate;
        var startDateObj = mainForm.findField('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = start_date;
        var startHrObj = mainForm.findField('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = start_hour;
        var endDateObj = mainForm.findField('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = end_date;
        var endHrObj = mainForm.findField('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = end_hour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;

		 updatingAppSettings();
		 
		
	},
	fillSettingFieldsForActivity:function(jsonData){
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var thinclientuserSettingsForm = this.getPGPReportsFormSettings().getForm();
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.excludeWeekCombo;
		selectedComboOption=jsonData.excludeWeek;
		comboObject=thinclientuserSettingsForm.findField('er_excwe');		
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
			var exludeWeekEndVal=selectedComboOption;
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			exludeWeekEndVal=comboRawData[0].valueField;
			comboObject.setValue(comboRawData[0].valueField);
		}
		/*if(exludeWeekEndVal=="Yes" || exludeWeekEndVal=="yes")
		{
			var excludeDaysObj=Ext.getCmp('excludeDays');
			excludeDaysObj.show();
			excludeDaysObj.update(jsonData.screenLabels['MappedExcludeDays']);
		}*/

		comboObject=thinclientuserSettingsForm.findField('sh_timeinuse');
		comboObject.hide();
		
	

		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
	},
	showConfigDropdown:function(){
			isSettingsEnabled = true;
		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:569,
			//padding:5,
			//layout:'vbox',
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'385px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px'},
					cls:'containerHeader'
				},
				{
					xtype : 'PGPReportsFormSettings',
					parent:this
				}
			],
			renderTo:'thinclientuser'
			});

	},	
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{

		var publicJsonData=null;
		publicJsonData = appConstants.publicjsonDataActivity;
		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}



		return value;
	}
});

