// JavaScript Document

Ext.define('RumPGPReportApp.view.PGPReportsForm',{
	extend:'Ext.form.FieldContainer',
	alias:'widget.PGPReportsForm',
	collapseMode:'mini',
	id:'PGPReportsForm',
	ui:'newFormPanel',
	layout:'column',
	defaults:{
		labelAlign:'top',
		 margin:'0 20 10 0',
		labelSeparator:''
	},
	items:[
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable : true,
				id: 'select_farm',
				name: 'select_farm',
				fieldLabel:'Report For',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 170,
				editable : true,
				id: 'er_server',
				name: 'er_server',
				fieldLabel:'Report For',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},		
			{
				xtype:'scrollcombo',
				width: 200,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'RUM Type',
				name: 'er_rum_type',
				id: 'er_rum_type',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},				
			{
				xtype:'scrollcombo',
				width: 100,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Show Top',
				name: 'er_priority',
				id: 'er_priority',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},
					
			{xtype:'timeline',margin:0},
			{
				xtype:'checkboxfield',
				cls: 'checkbt',
				margin:'20 20 0 0',
				boxLabel: 'Show Legends',
				inputValue: 'true',
				hidden:true,
				id: 'showLegend'
			},
			{
				xtype:'button',
				text: submitValue,
				ui:'newButtonSmall',
				itemId: 'submit',
  				margin:'20 10 10 0'
			},
			{
				xtype:'button',
				text: saveTxt,
				ui:'newButtonSmall',
				itemId: 'save',
  				margin: "20 10 10 0",
				hidden:true
			},
			
		],
		listeners:{
		render:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		show:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		hide:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		}
	},
	toggleSubmitSaveBtn:function(component){

			var mainform=Ext.getCmp('mainform');
			var PGPReportsForm=Ext.getCmp('PGPReportsForm');
			var hiddenFields=  appConstants.publicjsonDataActivity.hiddenfields;
			
			if (hiddenFields.fromScheduleModify == "Yes" || hiddenFields.fromFavoriteModify == "Yes") 
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					PGPReportsForm.getComponent('submit').hide();
					PGPReportsForm.getComponent('save').show();
				//	PGPReportsForm.getComponent('submit').hide();
				}
				else
				{
					mainform.getComponent('save').show();
					PGPReportsForm.getComponent('submit').hide();
					PGPReportsForm.getComponent('save').hide();
					//PGPReportsForm.getComponent('submit').hide();
				}
 			}
			else
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					PGPReportsForm.getComponent('submit').hide();
					PGPReportsForm.getComponent('save').hide();
					PGPReportsForm.getComponent('submit').show();
				}
				else
				{
					mainform.getComponent('save').hide();
					PGPReportsForm.getComponent('submit').show();
					PGPReportsForm.getComponent('save').hide();
					//PGPReportsForm.getComponent('submit').hide();
				}
			}
	}
});