// JavaScript Document

Ext.define('RumReportsApp.view.RumReportsForm',{
	extend:'Ext.form.FieldContainer',
	alias:'widget.RumReportsForm',
	collapseMode:'mini',
	id:'RumReportsForm',
	layout:'column',
	defaults:{
		labelAlign:'top',
		 margin:'0 20 10 0',
		labelSeparator:''
	},
	items:[
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 130,
				editable : false,
				id: 'report_category',
				name: 'report_category',
				fieldLabel:'Report For',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},
			{
				xtype:'scrollcombo',
				width: 90,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Report Type',
				name: 'er_type',
				id: 'er_type',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 200,
				editable : true,
				fieldLabel:'Site',
				name: 'select_farm',
				id: 'select_farm',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local'
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 180,
				editable : true,
				fieldLabel:'Component',
				name: 'er_server',
				id: 'er_server',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local'
			},
			{
				xtype:'scrollcombo',
				width: 180,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Component Type',
				name: 'er_compType',
				id: 'er_compType',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:false
			},
			
			{
				xtype:'scrollcombo',
				width: 220,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Worker Group',
				name: 'er_wrkrGrp',
				id: 'er_wrkrGrp',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},
			{
				xtype:'scrollcombo',
				fieldLabel:'Graph Type',
				name: 'er_graphType',
				id: 'er_graphType',
				cls: 'dropdown',
				width:130,
				editable:false,
				hidden:true,
				store: Ext.data.Store
				(
					{
						fields: ['displayField','valueField'],
						data: []
					}
				),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
			
			{
				xtype:'scrollcombo',
				width: 250,
				cls: 'dropdown',
				editable : true,
				fieldLabel:'Measure',
				name: 'select_testmes',
				id: 'select_testmes',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
			{
				xtype:'scrollcombo',
				width: 100,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Show Top',
				name: 'er_priority',
				id: 'er_priority',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},{
				xtype:'scrollcombo',
				width: 180,
				cls: 'dropdown',
				editable : true,
				fieldLabel:'Measures',
				name: 'er_sortby',
				id: 'er_sortby',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},
			{
				xtype:'scrollcombo',
				width: 180,
				cls: 'dropdown',
				editable : true,
				fieldLabel:'Application',
				name: 'er_application',
				id: 'er_application',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},		
			{xtype:'timeline',margin:0},
			{
				xtype:'checkboxfield',
				cls: 'checkbt',
				margin:'22 20 0 0',
				boxLabel: 'Show Legends',
				inputValue: 'true',
				hidden:true,
				id: 'showLegend'
			},
			{
				xtype:'button',
				text: submitValue,
				ui:'newButtonSmall',
				itemId: 'submit',
  				margin:'20 10 10 0'
			},
			{
				xtype:'button',
				text: "Save",
				ui:'newButtonSmall',
				itemId: 'save',
  				margin: "20 10 10 0"
			},
			
		],
		listeners:{
		render:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		show:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		hide:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		}
	},
	toggleSubmitSaveBtn:function(component){

			var mainform=Ext.getCmp('mainform');
			var RumReportsForm=Ext.getCmp('RumReportsForm');
			var hiddenFields;
			if(targetType == 'RUM')
			{
				hiddenFields=  appConstants.publicjsonDataActivity.hiddenfields;
			}else{
				hiddenFields=  appConstants.publicjsonDataActivity.hiddenfields;
			} 

			if (hiddenFields.fromScheduleModify == "Yes" || hiddenFields.fromFavoriteModify == "Yes") 
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					RumReportsForm.getComponent('submit').hide();
					RumReportsForm.getComponent('save').show();
				}
				else
				{
					mainform.getComponent('save').show();
					RumReportsForm.getComponent('submit').hide();
					RumReportsForm.getComponent('save').hide();
				}
 			}
			else
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					RumReportsForm.getComponent('submit').hide();
					RumReportsForm.getComponent('save').hide();
					RumReportsForm.getComponent('submit').show();
				}
				else
				{
					mainform.getComponent('save').hide();
					RumReportsForm.getComponent('submit').show();
					RumReportsForm.getComponent('save').hide();
					
				}
			}
	}

});