Ext.define('Sample.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],	
	pdfClicked:false,
	refs:[
		{selector:'main', ref:'main'},
 		{selector:'mainform', ref:'mainform'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'config', ref:'config'},{
			selector : 'nomeasurepanel',
			ref : 'nomeasurepanel'
		},{
			selector : 'backGroundPanel',
			ref : 'backGroundPanel'
		}
 	],
 	init:function()
	{	    
		this.control(
		{
			'main':
			{
 				'boxready':this.mainBoxReady
			},
			'mainform':
			{
				'afterrender':this.loadData
			},
			'main newUtilities':
			{
				'afterrender': this.toggleHideTools
			},			
			'mainform combo[name="eventfor"]':
			{
				'select': this.analysisOnChange		 
			},
			'mainform button[name="submit"]':
			{
				'click': this.formSubmit
			},
			'mainform button[name=save]': {
                'click': this.goTo
            },			
			'mainform combo[name="reportGeneration"]':
			{
				'select': this.selectReportGeneration
			},
			 'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},		
			'newUtilities #saveTool > button ':
			{
				'click':this.saveMe
			},
			'newUtilities #printTool > button ':
			{
				'click': this.printMe
			},
			'newUtilities #mailTool > button ':
			{
				'click': this.sendMail
			},
			'newUtilities #favoriteTool > button ':
			{
				'click': this.favorites
			},
			'newUtilities #scheduleTool > button ':
			{
				'click': this.schedules
			},
			'timeline combo[name="er_mode"]': {
                'select': this.changeEr_mode
            },
			'mainform checkbox[name="severity"]': {
                'change': this.onChangeSeverity
            }
		});
	},
	
	onChangeSeverity: function(obj)
	{
		if (appConstants.isPriorityComboEnabled=='true')
		{
			 if (obj.checked)
			 {
				Ext.getCmp('SeverityCheck').show();
			 }
			 else
			 {
				Ext.getCmp('SeverityCheck').hide();
			 }
		} 
	},
	sendMail: function()
	{
		if (Ext.get('mailtosend') == null)
		{			
				Ext.create('utilities.SendMail').show();
			
		} else {
			Ext.getCmp('mailtosend').show();
		}

		
	},
	toggleForm:function(obj)
	{
 		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},		
	printMe: function()
	{ 
		parent.printWindowFn(appConstants.publicJson['PRINT_URL']); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
  	},
	bookletQuery: function(obj)
	{
		var qryString=appConstants.publicJson['PDF_URL_QUERY_STRING'];
		if(qryString.indexOf('/final/reporter/ErHtmlToSavePdf.jsp?')>-1)
			qryString = qryString.replace('/final/reporter/ErHtmlToSavePdf.jsp?','');
		return qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		this.updateFormQueryString(true,true,true,true,true,true); 
		var bookletquery=appConstants.queryString+"&er_compType="+appConstants.erCompType;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	saveMe:function()
	{
		this.pdfClicked=true;
  		Ext.widget('erutils').savePDF(appConstants.publicJson['PDF_URL_QUERY_STRING']);
 	},
	favorites: function(obj)
	{
 		this.updateFormQueryString(true,true,true,true,true,true);
		var target = '/final/servlet/com.eg.ErFavoriteC?'+appConstants.queryString+'&cmd=client'+"&er_compType="+appConstants.erCompType+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId='+appConstants.publicJson.hiddens.favorite_id;
 	
		if (obj.getId()!='save')	
		{
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
		}
		else
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+appConstants.publicJson.hiddens.favorite_id;
			target+='&showWindow=no'+'&FavoriteId='+appConstants.favorite_id+'&fromFavoriteModify='+appConstants.fromFavoriteModify;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
	},
	schedules: function(obj)
	{
   		this.updateFormQueryString(true,true,true,true,true,true); 
		var target = '/final/reporter/ErSaveSchedule.jsp?'+appConstants.queryString+"&er_compType="+appConstants.erCompType+'&com.eg.CSRF_NONCE='+csrfToken;
		  if (obj.getId()!='save')
		{
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
		}
		else
		{
			//document.location=target+'&showSchWindow=no'
			target+='&showSchWindow=no'+"&schedule_id="+appConstants.schedule_id;//+'&from_schedule='+appConstants.publicJson.hiddens.fromScheduleModify;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
    },
	goTo: function (obj) {
 		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Sample Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}
		if (appConstants.fromScheduleModify != null && appConstants.fromScheduleModify == "Yes")
		{
			 this.schedules(obj);
		}
		if(appConstants.fromFavoriteModify != null && appConstants.fromFavoriteModify == "Yes")
		{
 			this.favorites(obj);
		}
    },
	qLinkEnableCheck:function(compBool,compTypeBool,testBool,severityBool,hoursAlertBool)
	{
		 var comp=Ext.getCmp("comp");
		 var compType=Ext.getCmp("compType");
		 var test=Ext.getCmp("test");
		 var severity=Ext.getCmp("severity");
		
		if (compBool)
			comp.setValue(true);
		else
			comp.setValue(false);
		if (compTypeBool)
			compType.setValue(true);
		else
			compType.setValue(false);
		if (testBool)
			test.setValue(true);
		else
			test.setValue(false);
		if (severityBool)
			severity.setValue(true);
		else
			severity.setValue(false);
		if (hoursAlertBool)
		{
			 var timeline= Ext.getCmp('er_timeline');
			 timeline.setValue('1 hour');
			 timeline.fireEvent('select',timeline);
		}

		this.updateFormQueryString(true,true,true,true,true);
		this.updateAjaxFormData(true);	
	},
	mainBoxReady:function()
	{	
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
		{
			appConstants.er_RmDispName='TOP EVENTS';
			this.getMain().setTitle(appConstants.er_RmDispName);
		}
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			this.formSubmit();
		}
		else if(appConstants.isForceSubmit=='true' )
		{
 				appConstants.isForceSubmit='false';
				this.formSubmit();
 		}
		if(!hideBackButton)	
		{
			Ext.getCmp('main').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicJson['ID']
			});
		}

		/*var fromFavoriteModify =appConstants.publicJson['hiddens']["fromFavoriteModify"]; 
		if(fromFavoriteModify!='Yes'){
			this.enableTools();
			this.showData(resultContainer);
		}*/
		//if(!hideBackButton)
		//	this.loadReportData();
 	/*	if (isSubmit=='true')
		{
			this.loadReportData();
		}
		else
		{
 			
			if (qLink=='alerts_past_week')	//severity checkbox
			{
				//alert('qlink alerts_past_week');		
				this.qLinkEnableCheck(false,false,false,true,false);									 
			}
			else if (qLink=='alerts_by_type')	//compType checkbox,severity checkbox
			{
				//alert('qlink alerts_by_type');
				this.qLinkEnableCheck(false,true,false,true,false);			
			}
			else if (qLink=='hours_alerts')	//test checkbox
			{
				//alert('qlink hours_alerts');
				this.qLinkEnableCheck(false,false,true,false,true);				
			}
			else if (qLink=='top10_components_summary')	//component checkbox
			{
				//alert('qlink top10_components_summary');
				this.qLinkEnableCheck(true,false,false,false,false);			
			}
			else if (qLink=='top10_components_details')	//component checkbox, test checkbox, show details combo=yes
			{
				//alert('qlink top10_components_details');
				this.qLinkEnableCheck(true,false,true,false,false); 				
			}
			else if (qLink=='top10_tests')	//test checkbox
			{
				//alert('qlink top10_tests');
				this.qLinkEnableCheck(false,false,true,false,false);	
			}
			else
			{
				console.log('No Quick Links found');
			}		
		}*/
	},
	showData:function(resultContainer){
		this.enableTools();
 		this.getBackGroundPanel().hide();
		this.getNomeasurepanel().hide();		
		
 		var graphMode =  Ext.getCmp('er_mode').getValue();
 		var wide="105px";

		var reportData=appConstants.publicJson['reportData'];
		var xmlData = appConstants.publicJson['eventsChartXMLData'];
		var eventsChartTitleData = appConstants.publicJson.displayFields['eventsChartTitle'];
		
		
 		if ( !Ext.isEmpty(reportData ) &&  !Ext.isEmpty(xmlData ) )
		{
			resultContainer.add({xtype:'resultpanel'});
			var resultPanelObj=resultContainer.down('panel');
			resultContainer.show();
			Ext.getCmp('panelinsidetoggle').setDisabled(false);
			var fusionChartObj = Ext.getCmp('fusionChart');
			if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			{
					fusionChartObj.setTitle(appConstants.er_RmDispName);
			}
			else
			{
					fusionChartObj.setTitle(eventsChartTitleData);
			}			
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJson.selectionDetails);
			if(appConstants.chartType=='fusionchart')
			{
				if (FusionCharts("chart" )) 
				FusionCharts("chart").dispose();
				var myChart = new FusionCharts('/final/FusionCharts/swf/MSBar'+graphMode+'.swf','chart', "100%", "100%","0","1");
				myChart.setXMLData(xmlData);
				myChart.setTransparent(true);
				myChart.render('MyChart');
			}
			else if(appConstants.chartType=='highchart')
			{			
				var lineChart = {};
				lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('MyChart',reportData.chartHeight-20,reportData.chartWidth+150), lineChart);
				lineChart.setData(reportData,'<%=currentDateFormat%>','');
				lineChart.drawChart();
			}
			var eventsTableTitleData = appConstants.publicJson.displayFields['eventsTableTitle']; 
			var summaryOfEventsObj = Ext.getCmp('summaryOfEvents');
			summaryOfEventsObj.show();
			summaryOfEventsObj.setTitle(eventsTableTitleData);

			var tableHeadings = appConstants.publicJson['tableHeadings'];
			var tableValues = appConstants.publicJson['tableValues'];
			var tableHeaders = appConstants.publicJson['gridHeaders'];
			var tableHeadersUI = appConstants.publicJson['gridHeadersUI'];
		/*	var tableHtml = '<div class="newTable">'
							+'<table cellspacing="0" cellpadding="0" border="0" width="100%">'
							+'<thead>'
							+'<tr>';
			var alertIdx = 0;
			var idx = 0;
			var tableSize=Object.keys(tableHeadings).length;
			if(tableSize==2)
					wide="390px";
			else if(tableSize==3)
					wide="250px";
		for ( var key in tableHeadings )
			{
				if ( key.indexOf('ALERTS') > -1 )
				{
					alertIdx = idx;
				}
				if ( key.indexOf('GRAPH') > -1 )
				{
					tableHtml += '<th width="40px">'
								 +'<div >'+tableHeadings[key]+'</div>'
								 +'</th>';

				}
				else if ( key.indexOf('ALERTS') > -1 )
				{
					tableHtml += '<th  width='+wide+'>'
								 +'<div style="text-align: center;">'+tableHeadings[key]+'</div>'
								 +'</th>';
				}
				else if ( key.indexOf('METRICS') > -1 )
				{
					tableHtml += '<th width="275px">'
								 +'<div>'+tableHeadings[key]+'</div>'
								 +'</th>';
				}
				else if ( key.indexOf('SEVERITY') > -1 )
				{
					tableHtml += '<th width="100px">'
								 +'<div >'+tableHeadings[key]+'</div>'
								 +'</th>';
				}
				else
				{
					tableHtml += '<th>'
								 +'<div>'+tableHeadings[key]+'</div>'
								 +'</th>';
				}
				idx++;
			}
			tableHtml += '</tr>'
						 +'</thead>'
						 +'<tbody >';

			var tableHeadingsCount = appConstants.publicJson['tableHeadingsCount'];
			var chartId = 0;
			//tableValues.sort(this.orderByNameAscending);
			for ( var key in tableValues )
			{
				var data = tableValues[key];
				tableHtml += '<tr>';
				for ( var tmpKey in data )
				{
					var titleText = data[tmpKey];
					if ( tmpKey.indexOf('GRAPH') > -1 )
					{
						titleText = 'GRAPH';
					}
					tableHtml += '<td title="'+titleText+'" >'

					if ( tmpKey.indexOf('GRAPH') > -1 )
					{
						var graphURL = data[tmpKey];
						tableHtml += '<div style="position:relative;height:20px;text-align:center;margin-left:10px"><div class="iconLineChart" onclick="javascript:loadUrlInDrillDown(\''+graphURL+'\');" style="position:absolute;cursor:pointer" ></div></div>'
					}
					else if(tmpKey.indexOf('ALERTS') > -1)
					{
						var value = data[tmpKey];
						if(data[tmpKey]!=null && data[tmpKey].indexOf("(")>-1)
						{
							str = value.substring(0,value.indexOf("("));
							strDecimal = value.substring(value.indexOf("("));
							value='<div style="float:left; text-align:right; width:50%" >'+str.trim()+'&nbsp</div><div style="float:right; text-align:left; width:50%" >'+strDecimal+'</div>';
						}
						else
						{
							value='<div style="float:left; text-align:right; width:50%" >'+value+'</div><div style="float:right; text-align:left; width:50%" >&nbsp</div>';
						} 
						tableHtml += '<div>'+value+'</div>'
					}
					else
					{
						tableHtml += '<div>'+data[tmpKey]+'</div>'
					}
					chartId++;
					tableHtml += '</td>';
				}
				tableHtml += '</tr>';
			}

			tableHtml += '<tr class="x-grid-row">';
			for ( var i = 0; i < tableHeadingsCount; i++ )
			{
				if ( i == 0 )
				{
					var totalLabel = appConstants.publicJson.displayFields['total'];
					tableHtml += '<td><div style="font-weight:bold !important;">'+totalLabel+'</div></td>';
				}
				else if ( i == alertIdx )
				{
					var totalValues = appConstants.publicJson['totalValues'];
					totalValues = '<div style="font-weight: bold !important; float:left; text-align:right; width:50%" >'+totalValues+'</div><div style="float:right; text-align:left; width:50%" >&nbsp</div>';
					tableHtml += '<td><div class="x-grid-cell-inner">'+totalValues+'</div></td>';
				}
				else
				{
					tableHtml += '<td><div class="x-grid-cell-inner"></div></td>';
				}
			}
			tableHtml += '</tr>'
						 +'</tbody>'
						 +'</table>'
						 +'</div>';
			summaryOfEventsObj.update(tableHtml);*/
			var mainColumnsObjArray	=  new Array();
			var colmns=[];
			var sortVal=true;
			var min_Width=140 ;
			if(colmns.length > 5)
				min_Width=190 ;
			for(var key in tableHeaders)
			{
				colmns.push(tableHeaders[key]);
				if(tableHeaders[key] == 'GRAPH'){
					sortVal=false;
					min_Width=50;
				}
				if(tableHeaders[key] == 'METRICS'){
					min_Width=250;
				}
				if(tableHeaders[key] == 'ALERTS' || tableHeaders[key] == 'SEVERITY'){
					min_Width=100;
				}
				mainColumnsObjArray.push({
					text: tableHeadersUI[key],
					dataIndex: tableHeaders[key],
					width:min_Width,
					sortable:sortVal,
					//align:textAlign,
					align:'left',
					doSort: function(state) 
					{
						var ds = this.up('grid').store;

						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);

								if (state=='ASC')
								{
									if(v2 == 'TOTAL')
										v2="zz";

									if(v1 == 'TOTAL')
										v1="zz";

									if(v1 == '')
										v1="zz";
									
									if(v2 == '' )
										v2="zz";
								}
								else
								{
									if(v2 == 'TOTAL')
										v2="00";

									if(v1 == 'TOTAL')
										v1="00";

									if(v2 == '')
										v2="00";

									if(v1 == '')
										v1="00";
								}

								if(field == 'ALERTS' ){
									v1=v1.substring(0,v1.indexOf('('));
									v2=v2.substring(0,v2.indexOf('('));
								}
								
								if(!isNaN(v1) && !isNaN(v2))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10); 
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);

									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;

										v2= isNaN(v2) ? 0 : v2;
									}
								}
								else
								{
									v1=v1.toLowerCase();
									v2=v2.toLowerCase();
								}
								// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					},
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						var val=value;
						if(tableHeaders.length -1  == col && colmns.indexOf('GRAPH') > -1 && value != '') 
						{
							var url=value;
							val='GRAPH';
							metaData.tdCls="iconColumn";
						//	value = '<div style="cursor:pointer" onclick="javascript:loadUrlInDrillDown(\''+url+'\');" ><div class="iconLineChart"></div></div>';

							value='<div style="position:relative;height:16px;align:center"><div class="iconLineChart" onClick="javascript:loadUrlInDrillDown(\''+url+'\');" style="margin:0px;padding:0px;width:16px;height:16px;position:absolute;display:block;cursor:pointer;margin-left: 10px;"></div></div>';
							metaData.tdAttr = 'data-qtip="' + val + '"';
						}
						else if (value.indexOf('~') > -1) 
						{
							var text = value.substring(0, value.indexOf('~'));
							var url = value.substring(value.indexOf('~') + 1);
							value = '<a href="javascript:void(0);" onClick="window.location.href=\'' + url + '\'" class="anchorLinkDefault" >' + text + '</a>';
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+text.trim()+'"';
						}
						else
						{
							value = Ext.getCmp('gridId').getDecimalAlignFormat(value);
							metaData.tdAttr = 'data-qtip="' + val + '"';
						}
						
						return value;
					},
				});
			}
			var storeObj = Ext.create('Ext.data.Store', {
				fields: colmns,
				proxy : {
						type : 'pagingmemory',
						reader : {
							type: 'json', root : 'data', totalProperty : 'total'
						},
						data:tableValues,
					},
				pageSize:tableValues.length,
				autoLoad : true,
				remoteSort : true
			});
			Ext.getCmp('summaryOfEvents').add(
				{
					xtype:'customgrid',
					store:storeObj,
					id:'gridId',
					sortableColumns:true,
					ui:'newGridPanel',
					columns:mainColumnsObjArray,
					margin:'5 10 10 10',
					forceFit: true,
					border:true,
					viewConfig: {
						emptyText: 'No records',
						getRowClass: function(record, rowIndex, rowParams, store){
							if (rowIndex==tableValues.length -1)
								return 'gridBottomRowHighlightBg'; 
						}
					}
				}
			)
			if ( Ext.getCmp('showdetailsCombo').getValue() == 'Yes' )
			{
 				Ext.Ajax.request({
					url: '/final/reporter/ErViewShowAlertJSON.jsp',
					method: 'POST',
					async: false,
					success: function(response)
					{
							var tmpJsonText = response.responseText;
							var tmpJsonData = Ext.decode(tmpJsonText);
							var gridData = tmpJsonData['gridValues'];
							var gridTitles = tmpJsonData['gridTitles'];
							var gridPanelTitle = tmpJsonData['gridTitle'];
							var limitPerPage = tmpJsonData['limitPerPage'];

							if ( !Ext.isEmpty( gridData ) )
							{
								resultPanelObj.add({
									xtype:'panel',
									ui:'newGraphPanel',
									title:gridPanelTitle,
									margin:'10 10 10 10',
									items:[{
										xtype:'eventdetails',
										dataArray: gridData,
										pageLimit: parseInt(limitPerPage)
									}]
								});
								var colHeaderCount = 0;
								for ( var key in gridTitles )
								{
									Ext.getCmp('eventdetailsGrid').columns[colHeaderCount].setText(gridTitles[key]);
									colHeaderCount++;
								}
							}
							else
							{
								resultPanelObj.hide();
								this.getNomeasurepanel().show();
							} 					
					}
				});
			}

		}
		else
		{
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
			this.getNomeasurepanel().doLayout();
			this.getNomeasurepanel().show();
			resultContainer.hide();
		}

		
	},
	orderByNameAscending:function(a, b) {
                if (a.NAME === b.NAME) {
                    return 0;
                } else if (a.NAME > b.NAME) {
                    return 1;
                }
                return -1;
    },
	changeEr_mode: function (combo) {
		var favorite_id = appConstants.publicJson['hiddens']["favorite_id"];
		var from_schModify = appConstants.publicJson['hiddens']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		this.formSubmit();
     },
	enableTools:function()
	{
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		Ext.getCmp("upbutton").setDisabled(false);
  	},		  
	loadReportData:function(){	
 		var reportGeneration=appConstants.publicJson.selectedFields.reportGenSelected;
  		var resultContainer=Ext.getCmp('resultContainer');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
		if(resultContainer.isHidden())
		resultContainer.show();
		resultContainer.removeAll();
 		if(reportGeneration == 'foreground'){
			this.showData(resultContainer);			
		}
		else if(reportGeneration == 'background')
		{ 	
			var resultObj = this.getBackGroundPanel();
			resultObj.removeAll();
			this.getNomeasurepanel().hide();
			var status = appConstants.publicJson['status'];
			var backgroundResponseTextVal = appConstants.publicJson['backgroundResponseText'];
			var backgroundResponseURLVal = appConstants.publicJson['backgroundResponseURL'];
			var backgroundResponseResultVal = appConstants.publicJson['backgroundResponseResult'];
			var genHtml;
			if ( status == 'duplicate' )
			{
				genHtml = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseResultVal+'.</br>'+'<a class="backgroundMsgLink" href='+backgroundResponseURLVal+'>'+ backgroundResponseTextVal + '</a></div></td></tr></table></td></tr></table>';

				//genHtml = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwith outheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin:20px"><b>'+backgroundResponseResultVal+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResponseURLVal+'" >'+backgroundResponseTextVal+'</a></div></div></center>';
			}
			else
			{
				genHtml = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseResultVal+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResponseURLVal +'>'+ backgroundResponseTextVal + '</a></div></td></tr></table></td></tr></table>';

				//genHtml = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithou theader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>'+backgroundResponseResultVal+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResponseURLVal+'" >'+backgroundResponseTextVal+'</a></div></div></center>';
			}	
			resultObj.add({
				xtype: 'panel',
				margin:0,
				header:false,
				bodyPadding:0,
				layout:'fit',
				html: genHtml,
			});
			resultObj.doLayout();
			resultObj.show();
		}
		else
		{
			console.log('No data found for report generation in json');
		}
		
	},
	selectReportGeneration: function(combo)
	{

		
		if (combo.getValue() == 'foreground' )
			Ext.getCmp('bgReportName').hide();
		else
		{
			Ext.getCmp('bgReportName').show();
		}
	},
	formSubmit:function()
    {
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var segserzone_value=Ext.getCmp('seg-ser-zone').getValue();
		var reportFor=Ext.getCmp('eventfor').getValue();
		if (reportFor!='Component'){
			if (segserzone_value != null && segserzone_value == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg :'Please choose '+reportFor,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
		}
		if (!Ext.getCmp("comp").checked && !Ext.getCmp("compType").checked && !Ext.getCmp("severity").checked && !Ext.getCmp("test").checked) {
			Ext.Msg.show({
						title : 'Alert',
						msg :'Please choose Group By Option',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		
		//prakash
		if(!Ext.getCmp("critical").checked && !Ext.getCmp("major").checked && !Ext.getCmp("minor").checked)
		{
			Ext.Msg.show ({
				title:'Alert',
				msg  :'Please choose Priority option',
				buttons:Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			return;
		}
		//
		
		var thisForm = Ext.getCmp("mainform").getForm();
		var stDateTime = thisForm.findField('er_stdate').getValue();
        var tmpStartHour = thisForm.findField('er_sthr').getValue();
        stDateTime.setHours(tmpStartHour);
        var enDateTime = thisForm.findField('er_enddate').getValue();
        var tmpEndHour = thisForm.findField('er_endhr').getValue();
        enDateTime.setHours(tmpEndHour);
        var result = checkDateTime(stDateTime, enDateTime);
        if (!result) {
            return;
        }
		var timeline = thisForm.findField("er_timeline").getValue();
        var reportgen = thisForm.findField("reportGeneration").getValue();
		
        var groupName = thisForm.findField('seg-ser-zone').getValue();
        var eventfor = thisForm.findField('eventfor').getValue();
        var label = thisForm.findField('seg-ser-zone').getFieldLabel();
		if (groupName == '-1' && eventfor != 'Component')
		{			
			return;
		}
		var bgenabled = appConstants.publicJson.hiddens["bgenabled"];
		var limitforbg = appConstants.publicJson.hiddens["limitforbg"];
		var getMaxDaysInMonth = appConstants.publicJson.hiddens["getMaxDaysInMonth"];
		if (bgenabled == 'Yes' || bgenabled == 'yes') {
			var bgtime;
			var getimeline;
			if (timeline != null && (timeline == 'Any' || timeline == 'any')) {
				bgtime = getTimeVal(limitforbg, thisForm,getMaxDaysInMonth);
                getimeline = getTimeVal(timeline, thisForm, getMaxDaysInMonth);

			} else {
				bgtime = getTimeVal(limitforbg, thisForm,getMaxDaysInMonth);
				getimeline = getTimeVal(timeline, thisForm,getMaxDaysInMonth);
			}
			
			var bgprocess = false;
			if (getimeline >bgtime && reportgen == 'foreground') {
				Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn){
					if(btn=="no")
					{
						thisForm.findField("reportGeneration").setValue('background');
						reportgen = 'background';
						Ext.getCmp('bgReportName').show();
						validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true);
					} else {
						this.updateFormQueryString(true,true,true,true,true);
						this.updateAjaxFormData(true);
					}
				},this);
			} else {
				var reportGeneration=Ext.getCmp('reportGeneration').getValue();
				if (reportGeneration != 'foreground')
				{
					var bg_reportname = Ext.getCmp('bgReportName').getValue();
					 var ret = validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true);
					if (!ret) {
						return;
					}
					
				}
				this.updateFormQueryString(true,true,true,true,true);
				this.updateAjaxFormData(true);
			}
		} else {
			var reportGeneration=Ext.getCmp('reportGeneration').getValue();
			if (reportGeneration != 'foreground')
			{
				var bg_reportname = Ext.getCmp('bgReportName').getValue();
				 var ret = validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true);
				if (!ret) {
					return;
				}
				
			}
			this.updateFormQueryString(true,true,true,true,true);
			this.updateAjaxFormData(true);
		}
	},
	getUrl:function(isFormSubmitted)
	{
		var url;
		if (isFormSubmitted)
		{
			appConstants.queryString+='&er_compType='+appConstants.erCompType;
			var reportGeneration=Ext.getCmp('reportGeneration').getValue();
			if (reportGeneration == 'foreground') {
				 url='../servlet/com.eg.ErCtxServerReportC';
				 appConstants.queryString+= '&er_reportgenration='+reportGeneration+'&call=json&isSubmit=true';
 			} else{
				var bg_reportname = Ext.getCmp('bgReportName').getValue();
					bg_reportname=checkFileName(bg_reportname);
				url='../servlet/com.eg.ErStartBackGroundReportC';
				appConstants.queryString+= '&er_reportgenration='+reportGeneration+'&bg_reportname='+bg_reportname +'&isSubmit=true';
  			}
		}		
		else
		 url= '/final/reporter/ErCtxEventReportJSON.jsp';


		return url;
	},
	updateAjaxFormData:function(isFormSubmitted)
    {	
  		var url= this.getUrl(isFormSubmitted);
   		Ext.Ajax.request(
				{
					url : url,
					params:appConstants.queryString,
   					scope:this,
					async: true,
					success: function(response, opts){ 						
 						appConstants.publicJson=Ext.decode(response.responseText);
 						if(isFormSubmitted)							  
							 this.loadReportData();						
						else 						
							this.loadForm();  						
					},
					failure: function(response, opts) {
						  console.log('server-side failure with status code ' + response.status);
					}
				});
   },
	analysisOnChange:function(obj)
	{					  
		Ext.getCmp('resultContainer').hide();
		this.updateFormQueryString(true,false,false,false,true,false);
		this.updateAjaxFormData(false);			
	},
	loadSettings: function()
	{
  		this.loadComboField(false,false,'er_timeline','timeline','','selectedTimeline',appConstants.publicJson);
		this.loadComboField(false,false,'showdetailsCombo','showDetailsCombo','','showDetailsChecked',appConstants.publicJson);
		this.loadComboField(false,false,'reportGeneration','reportGeneration','','reportGenSelected',appConstants.publicJson);
		this.setVal('er_stdate','startDateForDisplay','startdate',appConstants.publicJson);
		this.setVal('er_sthr','startHourForDisplay','selectedStartHour',appConstants.publicJson);
		this.setVal('er_enddate','endDateForDisplay','enddate',appConstants.publicJson);
		this.setVal('er_endhr','endHourForDisplay','selectedEndHour',appConstants.publicJson);
		mgr_stmin=appConstants.publicJson.selectedFields.startmin;
		mgr_enmin=appConstants.publicJson.selectedFields.endmin;

		updatingAppSettings();
 		//this.loadComboField(false,isSetLabel,comboId,comboProperty,comboLabelProperty,comboSelectedProperty,publicJson);
	},
	setVal:function(id,displayProperty,valueProperty,parentJsonProperty)
	{
		var component = Ext.ComponentManager.get(id); 
		component.setValue(parentJsonProperty.selectedFields[displayProperty]);
		component.dataArray =  appConstants.publicJson.selectedFields[valueProperty];	
	},
	loadData:function()
	{	
		var me=this;
		Ext.Ajax.on('beforerequest', function(conn, response, opts) { 
			
			if(!me.pdfClicked)
			{
				me.pdfClicked=false;
				Ext.get(document.body).mask('Loading ...');
			}
		});
		Ext.Ajax.on('requestcomplete', function(conn, response, opts) { 
			Ext.get(document.body).unmask();	
		});
		Ext.Ajax.on('requestexception', function(conn, response, opts) { 
			Ext.get(document.body).unmask(); 
			if (response.timedout) {				  
					alert('ajax timeout exception occured...');  			 
			}
			else if(response.status=401)
			{
				alert('You browser session expired' + response.status); 				 
			}
			else
			{
				alert('server-side failure with status code ' + response.status); 				 
			}
		});
		
 		var fromScheduleModify = appConstants.publicJson['hiddens']["fromScheduleModify"];
		var fromFavoriteModify =appConstants.publicJson['hiddens']["fromFavoriteModify"]; 
		var schedule_id =appConstants.publicJson['hiddens']["schedule_id"]; 
		var favorite_id =appConstants.publicJson['hiddens']["favorite_id"]; 
	
		if ((fromScheduleModify!= null  && fromScheduleModify == "Yes") || (fromFavoriteModify!=null && fromFavoriteModify == "Yes")) {
			appConstants.fromScheduleModify=fromScheduleModify;
			appConstants.fromFavoriteModify=fromFavoriteModify;
			appConstants.schedule_id=schedule_id;
			appConstants.favorite_id=favorite_id;
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		this.loadForm();
		this.loadSettings();
		this.enableCheckBoxGroup();		
	},
	loadForm: function()
	{
    	this.loadComboField(false,false,'eventfor','eventForCombo','','eventForSelected',appConstants.publicJson);
 		var val=Ext.getCmp('eventfor').getValue();
		if (val=='Component')
 			Ext.getCmp('seg-ser-zone').hide();
 		else if (val=='Segment')
			this.loadComboField(false,true,'seg-ser-zone','Segment','Segment','sub_eventSelected',appConstants.publicJson);
		else if (val=='Service')
			this.loadComboField(false,true,'seg-ser-zone','Service','Service','sub_eventSelected',appConstants.publicJson);
		else		
			this.loadComboField(false,true,'seg-ser-zone','Zone','Zone','sub_eventSelected',appConstants.publicJson);
		this.loadComboField(false,true,'subzone','includeSubZonesCombo','reporter.operation.includeSubzones','',appConstants.publicJson);
		 
    },
	enableCheckBoxGroup:function()
	{	 
	   if (appConstants.publicJson.selectedFields.hasOwnProperty('selectedGroupby'))
	   {   
			 var checkVal=appConstants.publicJson.selectedFields.selectedGroupby;			 
			 if (checkVal.indexOf('compName')>-1)
 				 Ext.getCmp('comp').setValue(true);
 			  if (checkVal.indexOf('compType')>-1)
				 Ext.getCmp('compType').setValue(true);
			  if (checkVal.indexOf('testName')>-1)
 				 Ext.getCmp('test').setValue(true);
 			  if (checkVal.indexOf('severity')>-1)
 				 Ext.getCmp('severity').setValue(true);		    
	   }else
			Ext.getCmp('comp').setValue(true);
	},
	toggleHideTools:function(){
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			false, //cvs
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true   //booklet
			);
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		
	},
	loadComboField:function(isMultiSelect,isSetLabel,comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty)
	{ 		 
 		 var component = Ext.ComponentManager.get(comboId);  
 		 if(parentJsonProperty.hasOwnProperty(comboProperty))
		 {		 
 				 var rawData = parentJsonProperty[comboProperty];
				component.getStore().clearFilter(true);
 				component.getStore().loadRawData(rawData);
				 if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
				 {		
 					component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]); 						
				 }
				 else
				 {		 
					component.setValue(rawData[0].valueField);
				 }

				 if (isSetLabel)
				 {
					 if(parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
					 {
						if(!isMultiSelect)
						{  
							component.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
 						}						
					 }
				 }
				 
				 if(component.isHidden())
				 component.show();
 		 }
		 else
		 {
		 		if(!isMultiSelect)
				{  
					if(!component.isHidden())
					component.hide();
				} 						
		 }
 	},	
	showConfigDropdown:function(){ 	
  		Ext.widget('configform');  
 	},	
	updateFormQueryString:function(isErOption,isErSite,isCheckBoxGroup,isHidddens,isSettings,isreportGeneration)
	{
 		var params='';			
		if(isErOption)
		{
		  params+='v_event='+Ext.getCmp('eventfor').getValue();
		  params+='&eventfor='+Ext.getCmp('eventfor').getValue();
		}
		if (isErSite)
		{
			var er_option= Ext.getCmp('eventfor').getValue();
			var er_site=Ext.getCmp('seg-ser-zone').getValue();
			if(er_option=='Zone')
			{
				params+='&subevent='+er_site+'&insubzone='+Ext.getCmp('subzone').getValue();
			}
			else if(er_option=='Segment'||er_option=='Service')
			{
				params+='&subevent='+er_site;
			}			
		}
		if (isCheckBoxGroup)
		{
			 var groupBy='';
			 var comp=Ext.getCmp("comp");
			 var compType=Ext.getCmp("compType");
			 var test=Ext.getCmp("test");
			 var severity=Ext.getCmp("severity");
			 if(comp.checked)
			 groupBy+='#'+comp.inputValue;
			 if(compType.checked)
			 groupBy+='#'+compType.inputValue;
			 if(test.checked)
			 groupBy+='#'+test.inputValue;
			 if(severity.checked)
			 groupBy+='#'+severity.inputValue;
			 groupBy = groupBy.substring(1);	
			 params+='&vw='+encodeURIComponent(groupBy);
 		}	
		if (isHidddens)
		{  			
			if(appConstants.publicJson.hasOwnProperty('hiddens'))
			{
				var hiddenFields = appConstants.publicJson.hiddens;
				for (var hiddenField in hiddenFields)
				{ 					
					params+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}
			}
		}
		if (isSettings)
		{ 			
			params+= "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&er_time=" + Ext.getCmp("er_timeline").getValue()+"&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray+'&showvalue='+Ext.getCmp('showdetailsCombo').getValue()+"&er_mode="+Ext.getCmp('er_mode').getValue()+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		}
		if (isreportGeneration)
		{
			var reportGeneration=Ext.getCmp('reportGeneration').getValue();
			if (reportGeneration == 'foreground') 
			{
 				 appConstants.queryString+= '&er_reportgenration='+reportGeneration+'&call=json&isSubmit=true';
			} 
			else
			{
				var bgreportname=Ext.getCmp('bgReportName').getValue();
					bgreportname=checkFileName(bgreportname);
 				appConstants.queryString+= '&er_reportgenration='+reportGeneration+'&bg_reportname='+bgreportname +'&isSubmit=true';
  			}
		}
		if (Ext.getCmp('severity').checked && appConstants.isPriorityComboEnabled=='true')
		{
			var temp = "";
			if (Ext.getCmp("critical").checked)
			{
				temp = "HIGH#";
			}
			if (Ext.getCmp("major").checked)
			{
				temp += "INTERMEDIATE#";
			}
			if (Ext.getCmp("minor").checked)
			{
				temp += "LOW#";
			}
			if (temp != "")
			{
				temp = temp.substring(0,temp.lastIndexOf("#"));
				params += "&er_priority="+encodeURIComponent(temp);
			} else {
				Ext.getCmp("critical").setValue(true);
				Ext.getCmp("major").setValue(true);
				Ext.getCmp("minor").setValue(true);
			}
		}
		params +="&er_RmDispName="+appConstants.er_RmDispName;

		appConstants.queryString=params;
 	},
});