	Ext.define('Schedules.view.Days_of', {
		extend: 'Ext.form.FieldContainer',
		alias: 'widget.days_of_the_week',
		fieldLabel:'Mail on',
		layout: 'column',
		id:'days_of',
		hidden:true,
		items:[
			{
				xtype: 'textfield',
				cls: 'textbox',
				columnWidth:.80,
				value:'',
				margin:'0 5 0 0',
				maskRe: /[A-Za-z0-9 .,]/,
				readOnly:true,
				id: 'days_of_week',
				name:'days_of_week'
			},
			{
				xtype: 'button',
				iconCls: 'iconOneClickMultiselectExpand',
				tooltip: '<b>Days of week</b>',
				columnWidth:.20,
				style:
				{
					 background: 'none',
					 border: '0px'
				},
				handler:function(obj)
				{
					//appConstants.appObj.getController(appConstants.appController).openOverPopup('DAYS OF WEEK','mailOnTf', daysOfWeekData,true);
					var selectedDaysInfoArray=new Array();
					var ddTxtValue=Ext.getCmp('days_of_week').getValue();
					selectedDaysInfoArray=ddTxtValue.split(",");
					Ext.create('Ext.window.Window',{
						title:'Days of Week',
						width:200,
						id:'builderSubWindow',
						border:false,
						frame:false,
						modal: true,
						ghost: false,
						height:230,
						header:{
							style:{'margin':'0px 10px 0px 10px','padding':'4px 0px 1px 0px'}
						},
						ui:'newPopupWindow withBorderShadow newplainHeader_border',
						buttonAlign:'center',
						padding:'5 10 10 10',
						listeners:
						{
							afterrender: function () {
								Ext.EventManager.onWindowResize(function () {
									var me = this;
									me.center();
								}, this);
							}
						},
						items:[
							{
								xtype: 'multiselect',
								width:'100%',
								height:145,
								layout: 'fit',
								border : 0,
								autoScroll:false,
								scroll:false,
								labelAlign:'left',
								baseCls: 'egmultiselect',
								multiSelect: true,
								id: 'componentsClone',
								name: 'componentsClone',
								store: new Ext.data.Store({
									fields: ['displayField', 'valueField'],
									data: []
								}),
								value: [],
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								listeners:{
									afterrender: function ()
									{
										this.getStore().loadRawData(dayOfWeekData);
										this.setValue(selectedDaysInfoArray);
									}
								},
							}
						],
						buttons:[
							{
								text:'Select',
								id: 'expand',
								ui:'newButtonSmall',
								//cls:'quickMenuWhiteButton',
								name: 'expand',
								handler: function()
								{
									if ( Ext.getCmp('componentsClone').getValue() != '')
									{
										var comboVal= Ext.getCmp('componentsClone').getValue();
										Ext.getCmp('days_of_week').setValue(comboVal);
										this.up('window').destroy();
									}
									else
									{
										 Ext.MessageBox.show({
											title: 'Alert',
											msg: 'Please Choose the Day(s)',
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
										});
										return;
									}
								}
							}
						]
					}).show();
				}
			}
		]
	});