Ext.apply(Ext.form.VTypes, {
	schedule_name_validation: function(value, field)
	{
		var flag = true;
		var scheduleMailreceiveType  = Ext.getCmp("receive_type").getValue();
		var errorMsg=validateTextBoxWithSpecialChars(value,scheduleMailreceiveType,false);
		if(errorMsg!="true")
		{
			field.vtypeText=errorMsg;
			flag = false;
		}
		else if(isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false")
		{
			if(!validateSingleByte(value))
			{
				field.vtypeText=schedule_DBLerror_msg;
				flag = false;
			}
		}
		else if((value.length >200))
		{
			Ext.Msg.show({
			title:'Alert',
			msg: 'Schedule Name should not be exceed 200 characters ',
			buttons: Ext.Msg.OK,
			icon: Ext.Msg.WARNING
			});
			flag = false;
		}
		return flag;
	},
	mail_id_validation: function(value, field)
	{
		var flag = true;
		if(isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false")
		{
			if(!validateSingleByte(value))
			{
				field.vtypeText=mailID_DBLerror_msg;
				flag = false;
			}
		}
		if(isScheduleSave!=null && isScheduleSave!="undefined" && isScheduleSave.toLowerCase()=="false")
		{
			var mailErrorMsg=checkmultiplemailid(value,false);
			if(mailErrorMsg!=true)
			{
				field.vtypeText=_checkmail;
				flag = false;
			}
		}
		//else if(checkmail(value)!=true)
		else if(checkmultiplemailid(value,false)!=true)
		{
			field.vtypeText=_checkmail;
			flag = false;
		}
		return flag;
	},
	mailFrequency_Validation: function(value,field)
	{
		var flag = true;
		if(value.toLowerCase()=="none")
		{
			if(field.id=="print_freq")
			{
				field.vtypeText="Please choose a Print Frequency";
			}
			else
			{
				field.vtypeText="Please choose a Mail Frequency";
			}
			flag=false;
		}
		return flag;
	}
});
Ext.define('Schedules.view.SchedulesForm',{
	extend:'Ext.panel.Panel',
	requires:['utilities.ScrollCombo'],
	alias:'widget.schedulesform',
	listeners:
	{
		afterrender:function()
		{
			Ext.getCmp('mail_onn').hide();
			Ext.getCmp('mail_on').hide();
			Ext.getCmp('schedule_at').hide();
		}
	},
	border:true,
	frame:false,
	margin:((queryString.indexOf('showWindow=yes')>-1 && queryString.indexOf('showSchWindow=no')>-1)?'10':(queryString.indexOf('showSchWindow=no')<0 && queryString.indexOf('showWindow=yes')>-1)?'scheduleFavoriteInner':'10 0 0 10'),
//	margin:'10 0 0 10',
	layout:'column',
	defaults:
	{
		labelAlign:'top',
		margin:'5 10 10 0',
		labelSeparator:'',
		columnWidth:colWidth
	},
	items:[
		{
			xtype:'container',
			id:'radioContainerId',
			columnWidth:1.0,
			items:[
				{
					xtype: 'radiogroup',
					labelSeparator:'',
					labelAlign:'top',
					id:'scheduleTypeId',
					fieldLabel:'Schedule Type',
					labelWidth:80,
					margin:'0 0 0 -3',
					defaults:
					{
						cls:'radiobt',
						noWrap:true,
						margin:'0 10 0 0',
					},
					items: [
						{ boxLabel: 'Regular', name: 'scheduleType', inputValue: 'regular',id: 'regular',width:70,checked: true},
						{ boxLabel: 'Schedule Booklet', name: 'scheduleType', inputValue: 'binder',id: 'binder',width:150,},
					],
					listeners:
					{
						'change' : function()
						{
							if(this.getChecked()[0].getGroupValue()=='regular')
							{
								var bsch_name1= Ext.getCmp('bsch_name1');
								bsch_name1.hide();
								Ext.getCmp('old_bsch_name').hide();
								Ext.getCmp('merge_type').hide();
								Ext.getCmp('mail_freq').show();
								Ext.getCmp('mail_freq').setValue('Daily');
								/*	var weekly =Ext.getCmp('mail_freq').getValue();
									if( weekly == 'Weekly')
									{
										Ext.getCmp('mail_on').show()
										Ext.getCmp('mail_onn').hide()
										Ext.getCmp('days_of').hide()
									}
									else if( weekly == 'Monthly')
									{
										Ext.getCmp('mail_onn').show();
										Ext.getCmp('mail_on').hide();
										Ext.getCmp('days_of').hide();
									}
									else if( weekly == 'Days_of_the_week')
									{
										Ext.getCmp('mail_onn').hide();
										Ext.getCmp('mail_on').hide();
										Ext.getCmp('days_of').show();
									}
									else
									{
										Ext.getCmp('mail_on').hide();
										Ext.getCmp('mail_onn').hide();
										Ext.getCmp('days_of').hide();
									}
*/
								Ext.getCmp('mail_id').show();
								Ext.getCmp('schedule_held_on').show();
								Ext.getCmp('merge_type').hide();
								if(Ext.getCmp('schedule_held_on').getValue() == 'AnyTime')
								{
									Ext.getCmp('schedule_at').show();
								}
								else
								{
									Ext.getCmp('schedule_at').hide();
								}
								if(jsonData.pageParams.ShowScheduleFormat==true)
								{
									Ext.getCmp("scheduleMailFormat").show();
									Ext.getCmp("scheduleMailFormat").setValue(jsonData.pageParams.scheduleMailFormat);
								}
								if(jsonData.pageParams.scheduleMailFormat=='PDF' && (jsonData.isBooklet==undefined || !jsonData.isBooklet))
								{
									Ext.getCmp('receive_type').show();
								}
							}
							else
							{
								Ext.getCmp('old_bsch_name').setValue('0');
								var bsch_name1= Ext.getCmp('bsch_name1');
								bsch_name1.show();
								Ext.getCmp('old_bsch_name').show();
								Ext.getCmp('mail_freq').show();
								Ext.getCmp('mail_freq').setValue('Daily');
								Ext.getCmp('merge_type').show();
								/*	var weekly =Ext.getCmp('mail_freq').getValue();
									if( weekly == 'Weekly')
									{
										Ext.getCmp('mail_on').show()
										Ext.getCmp('mail_onn').hide()
										Ext.getCmp('days_of').hide()
									}
									else if( weekly == 'Monthly')
									{
										Ext.getCmp('mail_onn').show();
										Ext.getCmp('mail_on').hide();
										Ext.getCmp('days_of').hide();
									}
									else if( weekly == 'Days_of_the_week')
									{
										Ext.getCmp('mail_onn').hide();
										Ext.getCmp('mail_on').hide();
										Ext.getCmp('days_of').show();
									}
									else
									{
										Ext.getCmp('mail_on').hide();
										Ext.getCmp('mail_onn').hide();
										Ext.getCmp('days_of').hide();
									}*/
								Ext.getCmp('mail_id').show();
								Ext.getCmp('schedule_held_on').show();
								if(Ext.getCmp('schedule_held_on').getValue() == 'AnyTime')
								{
									Ext.getCmp('schedule_at').show();
								}
								else
								{
									Ext.getCmp('schedule_at').hide();
								}
								if(jsonData.pageParams.ShowScheduleFormat==true)
								{
									Ext.getCmp("scheduleMailFormat").show();
									Ext.getCmp("scheduleMailFormat").setValue(jsonData.pageParams.scheduleMailFormat);
								}
								Ext.getCmp('receive_type').hide();
								Ext.getCmp('receive_type').setValue('Attachment');
							}
						}

					}
				}
			]
		},
		{
			xtype: 'scrollcombo',
			cls: 'dropdown',
			fieldLabel:'Schedule Booklet Name',
			id: 'old_bsch_name',
			name: 'old_bsch_name',
			hidden:true,
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			 store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			listeners:
			{
				'change': function()
				{
					if(this.getValue()!=undefined && this.getValue()=='0')
					{
						var bsch_name1= Ext.getCmp('bsch_name1');
						bsch_name1.show();
						Ext.getCmp('mail_freq').show();
						if(jsonData.pageParams.selectedMailFreq_value!=undefined && jsonData.pageParams.selectedMailFreq_value!='undefined')
							Ext.getCmp('mail_freq').setValue(jsonData.pageParams.selectedMailFreq_value);
						else
							Ext.getCmp('mail_freq').setValue('Daily');
						/*	var weekly =Ext.getCmp('mail_freq').getValue();
							if( weekly == 'Weekly')
							{
								Ext.getCmp('mail_on').show();
								Ext.getCmp('mail_onn').hide();
								Ext.getCmp('days_of').hide();
							}
							else if( weekly == 'Monthly')
							{
								Ext.getCmp('mail_onn').show();
								Ext.getCmp('mail_on').hide();
								Ext.getCmp('days_of').hide();
							}
							else if( weekly == 'Days_of_the_week')
							{
								Ext.getCmp('mail_onn').hide();
								Ext.getCmp('mail_on').hide();
								Ext.getCmp('days_of').show();
							}
							else
							{
								Ext.getCmp('mail_on').hide();
								Ext.getCmp('mail_onn').hide();
								Ext.getCmp('days_of').hide();
							}
*/
						Ext.getCmp('mail_id').show();
						Ext.getCmp('schedule_held_on').show();
						if(Ext.getCmp('schedule_held_on').getValue() == 'AnyTime')
						{
							Ext.getCmp('schedule_at').show();
						}
						else
						{
							Ext.getCmp('schedule_at').hide();
						}
						if(jsonData.isBooklet==undefined || !jsonData.isBooklet)
						{
							Ext.getCmp('receive_type').show();
						}
						if(Ext.getCmp('scheduleTypeId').getChecked()[0].getGroupValue()!='regular')
						{
							Ext.getCmp('merge_type').show();
						}
						if(jsonData.pageParams.ShowScheduleFormat==true)
						{
							Ext.getCmp("scheduleMailFormat").show();
							Ext.getCmp("scheduleMailFormat").setValue(jsonData.pageParams.scheduleMailFormat);
						}
					}
					else if(this.getValue()!=undefined && this.getValue()!='0' && this.getValue()!='None')
					{
						var bsch_name1= Ext.getCmp('bsch_name1');
						bsch_name1.hide();
						Ext.getCmp('mail_freq').hide();
						Ext.getCmp('mail_id').hide();
						Ext.getCmp('schedule_held_on').hide();
						Ext.getCmp('receive_type').hide();
						//Ext.getCmp('receive_type').setValue('Attachment');
					
						Ext.getCmp('mail_on').hide();
						Ext.getCmp('mail_onn').hide();
						Ext.getCmp('days_of').hide();
						Ext.getCmp('schedule_at').hide();


						Ext.getCmp('merge_type').hide();
						Ext.getCmp("scheduleMailFormat").hide();
					}
					else if(this.getValue()!=undefined && this.getValue()=='None')
					{
						var bsch_name1= Ext.getCmp('bsch_name1');
						bsch_name1.hide();
						Ext.getCmp('mail_freq').show();
						Ext.getCmp('mail_id').show();
						Ext.getCmp('schedule_held_on').show();
						if(jsonData.isBooklet==undefined || !jsonData.isBooklet)
						{
							Ext.getCmp('receive_type').show();
						}
					}
				}
			}
		},
		{
			xtype: 'textfield',
			cls: 'textbox',
			margin:'25 10 10 0',
			id: 'bsch_name1',
			name: 'bsch_name1',
			vtype: 'schedule_name_validation',
			msgTarget: 'side',
			hidden:true,
			emptyText:'Booklet Name',
			maxLength:32,
			enforceMaxLength: true
		},
		{
			xtype:'scrollcombo',
			hidden:true,
			id:'merge_type',
			name:'merge_type',
			fieldLabel:'Need to Merge',
			displayField: 'displayField',
			valueField: 'valueField',
			editable:false,
			queryMode: 'local',
			value:'no',
			store:new Ext.data.Store(
			{
				fields: ['displayField','valueField'],
				data: [{'displayField': 'Yes','valueField': 'yes'}, {'displayField': 'No','valueField': 'no'}]
			})

		},
		{
			xtype: 'textfield',
			cls: 'textbox',
			fieldLabel:'Schedule Name',
			id : 'sch_name',
			name : 'sch_name',
			allowBlank: false,
			vtype:'schedule_name_validation',
			msgTarget: 'side',
			//maxLength:32,
			enforceMaxLength: true
		},
		{
			xtype: 'scrollcombo',
			cls: 'dropdown',
			id: 'mail_freq',
			name: 'mail_freq',
			fieldLabel:'Mail',
			editable:false,
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			vtype:'mailFrequency_Validation',
			msgTarget:'side',
			store:new Ext.data.Store(
				{
					fields: ['displayField','valueField'],
					data: []
				}
			),
			listeners:
			{
				'change':function()
				{
					var weekly = this.getValue();
					if( weekly === 'Weekly')
					{
						Ext.getCmp('mail_on').show()
						Ext.getCmp('mail_onn').hide()
						Ext.getCmp('days_of').hide()
					}
					else if( weekly === 'Monthly')
					{
						Ext.getCmp('mail_onn').show();
						Ext.getCmp('mail_on').hide();
						Ext.getCmp('days_of').hide();
					}
					else if( weekly === 'Days_of_the_week')
					{
						Ext.getCmp('mail_onn').hide();
						Ext.getCmp('mail_on').hide();
						Ext.getCmp('days_of').show();
					}
					else
					{
						Ext.getCmp('mail_on').hide();
						Ext.getCmp('mail_onn').hide();
						Ext.getCmp('days_of').hide();
					}
				}
			}
		},
		{
			xtype: 'scrollcombo',
			editable:false,
			cls: 'dropdown',
			labelAlign:'top',
			id : 'mail_on',
			name : 'mail_on',
			fieldLabel:'Mail On',
			displayField: 'displayField',
			valueField: 'valueField',
			editable:false,
			queryMode: 'local',
			store:new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}
				)
		},
		{
			xtype: 'scrollcombo',
			editable:false,
			cls: 'dropdown',
			labelAlign:'top',
			id : 'mail_onn',
			name : 'mail_onn',
			fieldLabel:'Mail On',
			displayField: 'displayField',
			valueField: 'valueField',
			editable:false,
			queryMode: 'local',
			store:new Ext.data.Store({
				fields: ['displayField','valueField'],
				data: []
			})
		},
		{
			xtype: 'days_of_the_week'
		},
		{
			xtype: 'textfield',
			cls: 'textbox',
			fieldLabel:'Mail Id',
			id : 'mail_id',
			name : 'mail_id',
			allowBlank: (isScheduleSave)?true:false,
			afterLabelTextTpl: '<span style="color:red;" class="font_bold11" data-qtip="Required">*</span>',
			vtype:'mail_id_validation',
			msgTarget: 'side',
			maxLength:512,
			enforceMaxLength: true

		},
		{
			xtype: 'scrollcombo',
			hidden:true,
			cls: 'dropdown',
			fieldLabel:'Schedule Format',
			id : 'scheduleMailFormat',
			name : 'scheduleMailFormat',
			displayField: 'displayField',
			valueField: 'valueField',
			editable:false,
			queryMode: 'local',
			store:new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}
				),
			listeners:
			{
				'change' :function(obj)
				{
					var getReceivetype= this.getValue();
					if(getReceivetype=="CSV")
					{
						Ext.getCmp('receive_type').hide();
						Ext.getCmp('receive_type').setValue(jsonData.pageParams.scheduleMailReceive);
					}
					else if(jsonData.isBooklet==undefined || !jsonData.isBooklet)
					{
						Ext.getCmp('receive_type').show();
					}
				}
			}

		},
		{
			xtype:'scrollcombo',
			id:'receive_type',
			name:'receive_type',
			fieldLabel:'Include in Mail as',
			displayField: 'displayField',
			valueField: 'valueField',
			editable:false,
			queryMode: 'local',
			store:new Ext.data.Store(
			{
				fields: ['displayField','valueField'],
				data: []
			})

		},
		{
			xtype: 'scrollcombo',
			editable:false,
			cls: 'dropdown',
			hidden:true,
			id: 'print_freq',
			name: 'print_freq',
			editable:false,
			fieldLabel:'Print',
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			msgTarget:'side',
			store:new Ext.data.Store({
				fields: ['displayField','valueField'],
				data: []
			}),
			listeners:
			{
				'change':function()
				{
					var weekly = this.getValue();
					if( weekly === 'Weekly')
					{
						Ext.getCmp('print_on').show()
					}
					else
					{
						Ext.getCmp('print_on').hide();
					}
				}
			}
		},
		{
			xtype: 'scrollcombo',
			editable:false,
			hidden:true,
			cls: 'dropdown',
			fieldLabel:'Print On',
			labelAlign:'top',
			id : 'print_on',
			name : 'print_on',
			displayField: 'displayField',
			valueField: 'valueField',
			editable:false,
			queryMode: 'local',
			store:new Ext.data.Store({
				fields: ['displayField','valueField'],
				data: []
			})
		},
		{
			xtype: 'scrollcombo',
			editable:false,
			cls: 'dropdown',
			fieldLabel:'Schedule type',
			id : 'schedule_held_on',
			name : 'schedule_held_on',
			displayField: 'displayField',
			valueField: 'valueField',
			editable:false,
			queryMode: 'local',
			store:new Ext.data.Store({
				fields: ['displayField','valueField'],
				data: []
			}),
			listeners:
			{
				'change':function()
				{
					var value = this.getValue();
					if(value == 'AnyTime')
					{
						Ext.getCmp('schedule_at').show();
					}
					else
					{
						Ext.getCmp('schedule_at').hide();
					}
				}
			}
		},
		{
			xtype: 'fieldcontainer',
			id:'schedule_at',
			layout:'column',
			defaults:
			{
				labelSeparator:'',
				labelAlign:'top',
				margin:'0 5 0 0',
			},
			items:[
				{
					fieldLabel: 'HR',
					xtype: 'scrollcombo',
					cls: 'dropdown',
					editable:false,
					id : 'fromHours',
					name : 'fromHours',
					columnWidth:.5,
					displayField: 'displayField',
					valueField: 'valueField',
					editable:false,
					queryMode: 'local',
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
				},
				{
					fieldLabel: 'Mins',
					xtype: 'scrollcombo',
					editable:false,
					cls: 'dropdown',
					id : 'fromMinutes',
					name : 'fromMinutes',
					labelSeparator:'',
					displayField: 'displayField',
					valueField: 'valueField',
					columnWidth:.5,
					margin:'0 5 0 5',
					editable:false,
					queryMode: 'local',
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
				}
			]
		}
	]
});
