Ext.define('SlowLogonReports.controller.SlowLogonReports',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
	views:['Main','ErApplication'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'usertimeline',ref:'usertimeline'},
		{selector: 'thinclientuserform',ref: 'thinclientuserform'},
		{selector: 'egcomponent',ref: 'egcomponent'},
		{selector: 'mainform',ref: 'mainform'},
		{selector: 'thinclientusersettings',ref: 'thinclientusersettings'},
		{selector: 'reporterdata',ref:'reporterdata'},
		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({
			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.afterMainRender,
				'boxready':this.refreshReportData
			},
           	'thinclientusersettings':{
				'afterrender':this.loadSettingsElements
            		},
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'mainform combo[name="select_farm"]':{
				'select': this.zoneOnChange
			},
			'egcomponent multiselectfield[name="er_server"]':{
				'change': this.serverOnChange
			},
			'erapplication multiselectfield[name="er_application"]':{
				'change': this.UserOnChange
			},
			'mainform button[id="expandSelector"]': {
		        	'click': this.expandMe
		        },
			'mainform button[id="er_poolType_expand"]': {
				'click': this.expandMe
			},
			'mainform button[id="expandSelectorUser"]': {
		         	'click': this.expandMe2
		        },
			'geofilter button[id="expandSelectorActivity_geo"]': 
			{
				"click": this.expandMeGeo
			},
 			'mainform combo[name="er_compType"]':{
				'select': this.compTypeOnChange
			},
 			'mainform combo[name="brokeringFrom"]':{
				'select': this.brokeringFromChange
			},
			/*'thinclientusersettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			}, */
			'thinclientusersettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'thinclientusersettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'thinclientusersettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'mainform button[name="submit"]':{
				'click': this.showResult
			},
			'mainform button[name="save"]': {
		                "click": this.goTo
		    	},
			'mainform trigger[id="compSearch"]':
			{
				'change': this.compMultiselect
			},
			'erapplication trigger[id="userSearch"]':
			{
				'change': this.filterMultiselect
			},
			'egdesktoppools trigger[id="er_poolType_Search"]':
			{
				'change': this.filterMultiselect
			},
			'geofilter trigger[id="compSearch_geo"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
                		'click': this.toggleForm
            		},
			'main button[id="bckButton_1"]': {
		                'click': this.backFun
            		},
			'thinclientuserform combo[id="er_option"]':
			{
				'select': this.onSelectAnalysisBy
			},
			'thinclientuserform radiogroup[id=er_showDeliveryGroup]' : {
				'change' : this.showDeliveryGroup
			},
		});
	},
	showDeliveryGroup:function(btn)
	{
		var val=btn.getValue().deliveryGroupValue;
		var er_testTypeVal = '';
		if(val=='Yes')
		{
			Ext.getCmp('optionmultipane').hide();
			Ext.getCmp('er_user').hide();
			Ext.getCmp('er_poolType_container').show();
			
		}
		else
		{
			if (appConstants.isExceedUserLimit )
			{
				Ext.getCmp('er_user').show();
			}
			else
			{
				Ext.getCmp('optionmultipane').show();
			}
			Ext.getCmp('er_poolType_container').hide();

		}
	},
	onSelectAnalysisBy: function (obj) 
	{
		var params="";
		var urlStr="";
		initLdgMask.show();
		this.updateQStringActivity();
		params=appConstants.queryStringActivity;
		urlStr="/final/reporter/ErSlowLogonDetailsReportJson.jsp";
		params+="&onAnalysisChange=true";
		var me=this;
		Ext.Ajax.request({
	            url: urlStr,
	            params: params,
	            method: "POST",
	            success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				if(!Ext.isEmpty(jsonData))
				{
					me.fillFormFieldsForActivity(jsonData);
				}
				if (Ext.getCmp('er_option').getValue()=='Component')
					Ext.getCmp('select_farm').hide();
				else
					Ext.getCmp('select_farm').show();
				Ext.getCmp('resultPanel').hide();
				if(jsonData.isVm != undefined && jsonData.isVm == 'true'){
					if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='yes'){
						if(Ext.getCmp('brokeringFrom') != undefined){
							Ext.getCmp('brokeringFrom').show();
						}
					}
					else if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='No'){
						if(Ext.getCmp('brokeringFrom') != undefined)
							Ext.getCmp('brokeringFrom').hide();
					}
					var brokerngFrm=jsonData.enableBrokeringFor;
					if(Ext.getCmp('brokeringFrom') != undefined)
						Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
				}
				else{
					if(Ext.getCmp('brokeringFrom') != undefined)
						Ext.getCmp('brokeringFrom').hide();
				}
				if(Ext.getCmp('inclReconnect') != undefined){
					if(Ext.getCmp('er_compType').getValue() == 'Citrix_XcXenApp_server')
						Ext.getCmp('inclReconnect').show();
					else
						Ext.getCmp('inclReconnect').hide();
				}
				initLdgMask.hide();
			}
		});
	},

	getFocusToGrid:function()
	{
		if(Ext.getCmp('mainGrid') != undefined)
			Ext.getCmp('mainGrid').focus();
		if(Ext.getCmp('mainGrid2') != undefined)
			Ext.getCmp('mainGrid2').focus();
	},

	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) 
			 this.saveSchedule();
		else
			this.saveFavorite();
	},

	changeEr_mode: function (combo) {
		var favorite_id='';
		var from_schModify='';
		favorite_id = appConstants.publicjsonDataActivity['hiddenfields']["favorite_id"];
		from_schModify = appConstants.publicjsonDataActivity['hiddenfields']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
			duration: 250,
			to: {
				y: -530
			}
		});
		this.submitReport();
	},
	
	filterMultiselect: function (obj) 
	{	
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var compId = obj.getId();
		if(compId=='userSearch')
		{
			compStore = appConstants.rawDataForUsers;
			compName='er_application';
		}
		else if(compId=='compSearch_geo')
		{
			compStore = appConstants.geoFilterCombo;
			compName='er_geoFilter';
		}
		else if(compId=='er_poolType_Search')
		{
			compStore = appConstants.rawDataForPoolType;
			compName='er_poolType';
		}
		obj.toggleTriggger();
	   appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
	},
	
	compMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_server'),appConstants.rawDataForComponents);
	},

	organizeOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
	},

	brokeringFromChange:function(){
		initLdgMask.show();
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var brokeringFrom =Ext.getCmp('brokeringFrom').getValue();
		var urlForAjax="/final/reporter/ErSlowLogonDetailsReportJson.jsp?select_farm="+mainForm.findField("select_farm").getValue()+"&er_comptype="+mainForm.findField("er_compType").getValue()+"&er_brokeringFrom="+brokeringFrom;
		this.updateQStringActivity();
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'GET',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData
				comboRawData=jsonData.serverCombo;
				selectedComboOption=jsonData.selectedServer;
				comboObject=Ext.getCmp('er_server');
				appConstants.rawDataForComponents = comboRawData;
				rawDataForUsers=jsonData.userCombo;
				appConstants.rawDataForUsers=jsonData.userCombo;
				//comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				}
				else{
					comboObject.setValue(comboRawData[0].valueField);
					if(comboRawData[0].valueField!=-1)
						comboObject.setValue(comboRawData[0].valueField);
					else
						comboObject.setValue(comboRawData[1].valueField);
				}
				comboRawData=jsonData.userCombo;
				appConstants.rawDataForUsers=jsonData.userCombo;
				selectedComboOption=jsonData.selectedUser;
				var disableUserCombo = jsonData.disableUserCombo;
				var userTextFieldValue = jsonData.userTextFieldValue;
				if (disableUserCombo != undefined && disableUserCombo=='yes')
					appConstants.isExceedUserLimit = true;
				else
					appConstants.isExceedUserLimit = false;

				//appConstants.isExceedUserLimit = false;
				if (appConstants.isExceedUserLimit ){
						Ext.getCmp('er_user').show();
						Ext.getCmp('er_user').setValue(userTextFieldValue);
						Ext.getCmp('optionmultipane').hide();
				}else{
					appConstants.reportType = false;
					Ext.getCmp('optionmultipane').show();
					Ext.getCmp('er_user').hide();
					comboObject=mainForm.findField('er_application');
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.show();
				}
				Ext.getCmp('serverMultiSelectLbl').show();
				initLdgMask.hide();
			},
			failure: function() {
				initLdgMask.hide();
			}
		});
		
	},

	compTypeOnChange:function(){
		initLdgMask.show();
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var compnt=mainForm.findField("er_compType").getValue();
		if(Ext.getCmp('inclReconnect') != undefined){
			if(compnt == 'Citrix_XcXenApp_server')
				Ext.getCmp('inclReconnect').show();
			else
				Ext.getCmp('inclReconnect').hide();
		}
		var urlForAjax="/final/reporter/ErSlowLogonDetailsReportJson.jsp?select_farm="+mainForm.findField("select_farm").getValue()+"&er_comptype="+mainForm.findField("er_compType").getValue();
		this.updateQStringActivity();
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'GET',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				initLdgMask.hide();
				appConstants.publicjsonDataActivity=jsonData
				comboRawData=jsonData.serverCombo;
				selectedComboOption=jsonData.selectedServer;
				comboObject=Ext.getCmp('er_server');
				appConstants.rawDataForComponents = comboRawData;
				rawDataForUsers=jsonData.userCombo;
				appConstants.rawDataForUsers=jsonData.userCombo;
				comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				}
				else{
					comboObject.setValue(comboRawData[0].valueField);
					if(comboRawData[0].valueField!=-1)
						comboObject.setValue(comboRawData[0].valueField);
					else
						comboObject.setValue(comboRawData[1].valueField);
				}
				comboRawData=jsonData.userCombo;
				appConstants.rawDataForUsers=jsonData.userCombo;
				selectedComboOption=jsonData.selectedUser;
				var disableUserCombo = jsonData.disableUserCombo;
				var userTextFieldValue = jsonData.userTextFieldValue;
				if (disableUserCombo != undefined && disableUserCombo=='yes')
				{
					appConstants.isExceedUserLimit = true;
				} else
					appConstants.isExceedUserLimit = false;
								
				//appConstants.isExceedUserLimit = false;
				if (appConstants.isExceedUserLimit ){
					Ext.getCmp('er_user').show();
					Ext.getCmp('er_user').setValue(userTextFieldValue);
					Ext.getCmp('optionmultipane').hide();
				}else{
					appConstants.reportType = false;
					Ext.getCmp('optionmultipane').show();
					Ext.getCmp('er_user').hide();
					comboObject=mainForm.findField('er_application');
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.show();
				}
				Ext.getCmp('serverMultiSelectLbl').show();
				if(jsonData.isVm != undefined && jsonData.isVm == 'true'){
					if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='yes'){
						if(Ext.getCmp('brokeringFrom') != undefined){
							Ext.getCmp('brokeringFrom').show();
						}
					}
					else if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='No'){
						if(Ext.getCmp('brokeringFrom') != undefined)
							Ext.getCmp('brokeringFrom').hide();
					}
					var brokerngFrm=jsonData.enableBrokeringFor;
					if(Ext.getCmp('brokeringFrom') != undefined)
						Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
				}
				else{
					if(Ext.getCmp('brokeringFrom') != undefined)
						Ext.getCmp('brokeringFrom').hide();
				}
				comboObject=Ext.getCmp('er_showDeliveryGroup');
				selectedComboOption=jsonData.selectedShowDeliveryGroup;
				comboObject.hide();
				if(selectedComboOption!=undefined)
				{
					comboObject.show();
					comboObject.setFieldLabel(screenLabels['reporter.common.Show Delivery Groups']);
					comboObject=Ext.getCmp('deliveryGroupNo');
					if(selectedComboOption=="Yes")
					{
						comboObject=Ext.getCmp('deliveryGroupYes');
					}
					comboObject.setValue(true);
				}
				comboRawData=jsonData.poolTypeCombo;
				if(comboRawData!=undefined)
				{
					appConstants.rawDataForPoolType=jsonData.poolTypeCombo;
					selectedComboOption=jsonData.poolTypeSelected;
					comboObject=mainForm.findField('er_poolType');
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					} else {
						if(comboRawData[0].valueField!=-1)
							comboObject.setValue(comboRawData[0].valueField);
						else
							comboObject.setValue(comboRawData[1].valueField); //added for pool type not auto select
					}
					Ext.getCmp('er_poolType_container').setFieldLabel(jsonData.screenLabels['reporter.thin.poolTypeLabel']);
				}
				if(jsonData.selectedCompType=='Horizon_Pod')
				{
					Ext.getCmp('brokeringFrom').hide();
					Ext.getCmp('optionmultipane').hide();
					Ext.getCmp('er_user').hide();
					Ext.getCmp('er_poolType_container').show();
					Ext.getCmp('er_showDeliveryGroup').hide();
				}
				else
				{
					Ext.getCmp('er_poolType_container').hide();
					Ext.getCmp('er_showDeliveryGroup').show();
				}
				if(jsonData.selectedCompType=='Citrix_XcXenDesktop_Site')
				{
					if(jsonData.selectedShowDeliveryGroup!=undefined && jsonData.selectedShowDeliveryGroup=='Yes')
					{
						Ext.getCmp('optionmultipane').hide();
						Ext.getCmp('er_user').hide();
						Ext.getCmp('er_poolType_container').show();
					}
				}
			},
			failure: function() {
				initLdgMask.hide();
			}
		});
	},
	zoneOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var urlForAjax;
		var QString="";
		urlForAjax="/final/reporter/ErSlowLogonDetailsReportJson.jsp?select_farm="+mainForm.findField("select_farm").getValue();
		QString=appConstants.queryStringActivity;
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : QString,
			scope:this,
			method : 'GET',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData;
				comboRawData=jsonData.compTypeCombo;
				selectedComboOption=jsonData.selectedCompType;
				comboObject=mainForm.findField('er_compType');
				comboObject.getStore().clearFilter(true);
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				}
				else{
					comboObject.setValue(comboRawData[0].valueField);
				}
				if(jsonData.isVm != undefined && jsonData.isVm == 'true'){	
					if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='yes'){
						if(Ext.getCmp('brokeringFrom') != undefined){
							Ext.getCmp('brokeringFrom').show();
						}
					}
					else if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='No'){
						if(Ext.getCmp('brokeringFrom') != undefined)
							Ext.getCmp('brokeringFrom').hide();
					}
					var brokerngFrm=jsonData.enableBrokeringFor;
					if(Ext.getCmp('brokeringFrom') != undefined)
						Ext.getCmp('brokeringFrom').setValue(brokerngFrm);
				}
				else{
					if(Ext.getCmp('brokeringFrom') != undefined)
						Ext.getCmp('brokeringFrom').hide();
				}
				if(Ext.getCmp('inclReconnect') != undefined){
					if(comboObject.getValue() == 'Citrix_XcXenApp_server')
						Ext.getCmp('inclReconnect').show();
					else
						Ext.getCmp('inclReconnect').hide();
				}
				comboRawData=jsonData.serverCombo;
				selectedComboOption=jsonData.selectedServer;
				comboObject=Ext.getCmp('er_server');
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				}
				else{
					comboObject.setValue(comboRawData[0].valueField);
				}
				Ext.getCmp('serverMultiSelectLbl').show();
			}
		});
	},	
	expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		if(btn.id=='er_poolType_expand')
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_poolType'),Ext.getCmp('er_poolType_container').getFieldLabel(),btn);
		}
		else
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'),Ext.getCmp('compLbl').text,btn);
		}
	},
	expandMeGeo:function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_geoFilter'),Ext.getCmp('multiSelectLabel_geo').text,btn);
	},
	UserOnChange:function( obj){
		var componentVal = obj.getValue();
		var all_individual_alert = 'All Users and Individual selection cannot be selected simultaneously';
		if((Ext.Array.contains(componentVal,'--All--')|| Ext.Array.contains(componentVal,'--all--')) && componentVal.length>1)
		{
			Ext.MessageBox.show({
				title: 'Slow Logon Report',
				msg:  all_individual_alert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
	},
	serverOnChange:function( obj, newValue, oldValue, eOpts ){
//		initLdgMask.show();
		if (Ext.isEmpty(newValue))
		{
			return false;
		}
		var componentVal = obj.getValue();
		var all_individual_alert = 'All Components and Individual selection cannot be selected simultaneously';
		if((Ext.Array.contains(componentVal,'All')|| Ext.Array.contains(componentVal,'all')) && componentVal.length>1)
		{
			Ext.MessageBox.show({
				title: 'Slow Logon Report',
				msg:  all_individual_alert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		myMask = new Ext.LoadMask(Ext.getBody(), {msg : "Loading..."});
		myMask.show();

		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		if(!isSettingsEnabled)
		{
			this.showConfigDropdown();
			this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		}
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var s_server=Ext.getCmp('er_server').getValue();
		if(Ext.Array.contains(s_server,'All') && s_server.length>1)
		{
			Ext.MessageBox.show({
			title: 'Alert',
			msg: 'Individual and aggregate Components cannot be selected simultaneously',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		this.updateQStringActivity();
		var brokeringFrom =Ext.getCmp('brokeringFrom').getValue();//+"&er_brokeringFrom="+brokeringFrom
		Ext.Ajax.request(
		{
			url : '/final/reporter/ErSlowLogonDetailsReportJson.jsp',
			params : appConstants.queryStringActivity+"&er_brokeringFrom="+brokeringFrom,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				comboRawData=jsonData.userCombo;
				appConstants.rawDataForUsers=jsonData.userCombo;
				selectedComboOption=jsonData.selectedUser;
				var disableUserCombo = jsonData.disableUserCombo;
				var userTextFieldValue = jsonData.userTextFieldValue;
				if (disableUserCombo != undefined && disableUserCombo=='yes')
				{
					appConstants.isExceedUserLimit = true;
				} else
					appConstants.isExceedUserLimit = false;
								
				if (appConstants.isExceedUserLimit ){
					Ext.getCmp('er_user').show();
					Ext.getCmp('er_user').setValue(userTextFieldValue);
					Ext.getCmp('optionmultipane').hide();
				}else{
					appConstants.reportType = false;
					Ext.getCmp('optionmultipane').show();
					Ext.getCmp('er_user').hide();
				}
				comboObject=mainForm.findField('er_application');
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				} else {
					if(comboRawData[0].valueField!=-1)
						comboObject.setValue(comboRawData[0].valueField);
					else
						comboObject.setValue(comboRawData[1].valueField); //added for components not auto select
				}
				if(s_server!=null && s_server!=undefined && s_server.length>1) {
					comboRawData=jsonData.aggAcrossServer;
					if(!Ext.isEmpty(comboRawData))
					{
						selectedComboOption=jsonData.selectedAggServer;
						comboObject=thinclientuserSettingsForm.findField('er_perserver');
						comboObject.setFieldLabel(jsonData.screenLabels['reporter.thin.Aggregate across servers on']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
				}
				comboRawData=jsonData.poolTypeCombo;
				if(comboRawData!=undefined)
				{
					appConstants.rawDataForPoolType=jsonData.poolTypeCombo;
					selectedComboOption=jsonData.poolTypeSelected;
					comboObject=mainForm.findField('er_poolType');
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					} else {
						if(comboRawData[0].valueField!=-1)
							comboObject.setValue(comboRawData[0].valueField);
						else
							comboObject.setValue(comboRawData[1].valueField); //added for pool type not auto select
					}
					Ext.getCmp('er_poolType_container').setFieldLabel(jsonData.screenLabels['reporter.thin.poolTypeLabel']);
				}
				if(jsonData.selectedCompType=='Horizon_Pod')
				{
					Ext.getCmp('brokeringFrom').hide();
					Ext.getCmp('optionmultipane').hide();
					Ext.getCmp('er_user').hide();
					Ext.getCmp('er_poolType_container').show();
					Ext.getCmp('er_showDeliveryGroup').hide();
				}
				else
				{
					Ext.getCmp('er_poolType_container').hide();
					Ext.getCmp('er_showDeliveryGroup').show();
				}
				obj.setValue(componentVal);
				if(jsonData.selectedCompType=='Citrix_XcXenDesktop_Site')
				{
					if(jsonData.selectedShowDeliveryGroup!=undefined && jsonData.selectedShowDeliveryGroup=='Yes')
					{
						Ext.getCmp('optionmultipane').hide();
						Ext.getCmp('er_user').hide();
						Ext.getCmp('er_poolType_container').show();
					}
				}
			}
		});
		myMask.hide();
	},

	expandMe2: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'),Ext.getCmp('appLbl').text,btn);
	},

	saveReportAsPDF:function()
	{
		var hiddenFieldsTemp   =  appConstants.publicjsonDataActivity;
		var saveQString;
		this.updateQStringActivity();
		saveQString=appConstants.queryStringActivity;
		saveQString+="&printGraph=yes&opt=chart&er_view=PRINT";
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		s_qryString=this.getGridColSortParam(s_qryString);
 		appConstants.erUtils.savePDF(s_qryString);
	},

	bookletQuery: function(obj)
	{
		var saveQString;
		saveQString=appConstants.publicjsonDataActivity.saveQString;
		saveQString+="&printGraph=yes&opt=chart";
		saveQString+="&er_view=PRINT";
		var s_qryString = saveQString;
		return s_qryString;
	},

	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		this.updateQStringActivity();
		bookletquery=appConstants.queryStringActivity;
		return bookletquery;
	},

	bookletPreview:function()
	{
		this.printReport();
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);
			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}
		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},

	printReport:function()
	{
		var s_qryString;
		this.updateQStringActivity();
		s_qryString = "/final/reporter/ErSlowLogonDetailsReportPrint.jsp?"+appConstants.queryStringActivity+'&pdfPrint=yes&pdfprint=yes';
 		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},

	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},

	saveSchedule:function(){
		var isValid = this.validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
			Ext.MessageBox.show({
				title: 'Slow Logon Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid=false;
		}
		if(isValid){
			var s_qryString;			
			this.updateQStringActivity();
			s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;
			var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return
	},

	saveFavorite:function(){
		var isValid = this.validateMainForm(false);
		var favorite_id ="";
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
			Ext.MessageBox.show({
				title: 'Thin Client Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid=false;
		} */
		if(isValid){
			var s_qryString;
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			favorite_id = hiddenFields["favorite_id"];
			this.updateQStringActivity();
			s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";
			var target=s_qryString+"&FavoriteId="+favorite_id+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return;
	},
	
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm =null;
		if(isSettingsEnabled)
		thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var zone=mainForm.findField('select_farm')
		var er_option=mainForm.findField('er_option').getValue();
		var userNameTxt = '';
		if(Ext.getCmp('optionmultipane').isHidden() && !Ext.getCmp('er_user').isHidden())
		{
			var userNameStr = mainForm.findField('er_user').getValue();
			userNameTxt = userNameStr.split(',');
			if((userNameStr.trim().length==0))
			{
				Ext.MessageBox.show({
				title: 'Slow Logon Report',
				msg: 'User value cannot be empty',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if((er_option!=null || er_option!=undefined) && er_option!="Component" )
		{
			if(zone.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Slow Logon Report',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		}
		var compType=mainForm.findField('er_compType');
		if( compType.getValue() == '-1'){
			Ext.MessageBox.show({
			title: 'Slow Logon Report',
			msg: compType.getStore().getAt(0).get('displayField'),
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var server=Ext.getCmp('er_server');
		if( server.getValue() == '-1')
		{
			Ext.MessageBox.show({
				title: 'Slow Logon Report',
				msg: server.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var componentVal = server.getValue();
		var all_individual_alert = 'All Components and Individual selection cannot be selected simultaneously';
		if((Ext.Array.contains(componentVal,'All')|| Ext.Array.contains(componentVal,'all')) && componentVal.length>1)
		{
			Ext.MessageBox.show({
				title: 'Slow Logon Report',
				msg:  all_individual_alert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
			var upperCriticalVal;
			var upperMinorVal;
			var upperMajorVal;
			upperCriticalVal=Ext.getCmp('upperCritical').getValue();
			if(Ext.isEmpty(upperCriticalVal) || upperCriticalVal.length==0)
			{
				Ext.MessageBox.show({
					title: 'Slow Logon settings',
					msg: 'Invalid Critical Value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			upperMajorVal=Ext.getCmp('uppermajor').getValue();
			if(Ext.isEmpty(upperMajorVal) || upperMajorVal.length==0)
			{
				Ext.MessageBox.show({
					title: 'Slow Logon settings',
					msg: 'Invalid Major Value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			upperMinorVal=Ext.getCmp('upperminor').getValue();
			if(Ext.isEmpty(upperMinorVal) || upperMinorVal.length==0)
			{
				Ext.MessageBox.show({
					title: 'Slow Logon settings',
					msg: 'Invalid Minor Value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(upperCriticalVal<=upperMajorVal || upperCriticalVal<=upperMinorVal)
			{
				Ext.MessageBox.show({
					title: 'Slow Logon settings',
					msg: 'Critical Value Should be greater than other values',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(upperMajorVal<=upperMinorVal)
			{
				Ext.MessageBox.show({
					title: 'Slow Logon settings',
					msg: 'Major Value Should be greater than Minor value',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			
			if(Ext.getCmp('er_poolType_container').isVisible())
			{
				var er_poolTypeObj = Ext.getCmp('er_poolType');
				var gpArray = er_poolTypeObj.getValue();
				if (gpArray==undefined || gpArray.length == 0 || gpArray[0] =='-1') 
				{
					Ext.MessageBox.show({
						title: 'User Logon Report',
						msg: 'Please choose valid Desktop pools',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				else if (gpArray.length>1 && gpArray.indexOf('all')>-1)
				{
					Ext.MessageBox.show({
						title: 'User Logon Report',
						msg: 'All Desktop pools and Individual selection cannot be selected simultaneously',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
			else
			{
				var userflag=false;
				var userArray=Ext.getCmp('er_application').getValue();
				if(userArray!=null && userArray!='undefined' && userArray.length>0){
					for(var k=0;userArray.length>k;k++)
					{
						var userVal=userArray[k];
						if(userVal=="-1" || userVal=="Not Applicable")
							userflag=true;
					}
				}
				if(userflag)
				{
					Ext.MessageBox.show({
						title: 'Slow Logon Report',
						msg: 'User not applicable',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				var all_individual_alert = 'All Users and Individual selection cannot be selected simultaneously';
				if((Ext.Array.contains(userArray,'--All--')|| Ext.Array.contains(userArray,'--all--')) && userArray.length>1)
				{
					Ext.MessageBox.show({
						title: 'Slow Logon Report',
						msg:  all_individual_alert,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
				}
				if((userNameTxt.length>1 && userNameTxt.indexOf('*')>-1))
				{
					Ext.MessageBox.show({
					title: 'Slow Logon Report',
					msg: all_individual_alert,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
		var isSettingsOk = true;
		var hiddenFields;
		hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen = this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		if(isSettingsEnabled)
		{
			var upperCriticalVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'upperCritical',isSettingsEnabled,'upperCritical').toString();
			var upperMajorVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'uppermajor',isSettingsEnabled,'uppermajor').toString();
			var upperMinorVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'upperminor',isSettingsEnabled,'upperminor').toString();
			if(!Ext.isEmpty(upperCriticalVal) && upperCriticalVal.indexOf("-")>-1)
			{
				Ext.MessageBox.show({
					title: 'Slow Logon Report Report',
					msg: 'Critacal Value cannot be negative',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(!Ext.isEmpty(upperMajorVal) && upperMajorVal.indexOf("-")>-1)
			{
				Ext.MessageBox.show({
					title: 'Slow Logon Report',
					msg: 'Major Value cannot be negative',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(!Ext.isEmpty(upperMinorVal) && upperMinorVal.indexOf("-")>-1)
			{
				Ext.MessageBox.show({
					title: 'Slow Logon Report',
					msg: 'Minor Value cannot be negative',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var er_usertimeline = '';
		if ( !Ext.isEmpty(hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Slow Logon settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = hiddenFields["limitforbg"];
				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else{
			var reportName = this.getSettingsFieldValue(thinclientuserSettingsForm,'bgReportName',isSettingsEnabled,'selectedMinsTo');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}
	},

	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},

	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
        var starthr = mainForm.findField('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = mainForm.findField('er_enddate').getValue();
        var endhr = mainForm.findField('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var server=Ext.getCmp('er_server');
		var isValid = this.validateMainForm(true);
		if(isValid)
			this.submitReport();
		else
			return;
	},

	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv') ) {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}
		var upperCriticalVal;
		var upperMinorVal;
		var upperMajorVal;
		upperCriticalVal=Ext.getCmp('upperCritical').getValue();
		if(Ext.isEmpty(upperCriticalVal) || upperCriticalVal.length==0)
		{
			Ext.MessageBox.show({
				title: 'User Logon settings',
				msg: 'Invalid Critical Value',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		upperMajorVal=Ext.getCmp('uppermajor').getValue();
		if(Ext.isEmpty(upperMajorVal) || upperMajorVal.length==0)
		{
			Ext.MessageBox.show({
			title: 'User Logon settings',
				msg: 'Invalid Major Value',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		upperMinorVal=Ext.getCmp('upperminor').getValue();
		if(Ext.isEmpty(upperMinorVal) || upperMinorVal.length==0)
		{
			Ext.MessageBox.show({
				title: 'User Logon settings',
				msg: 'Invalid Minor Value',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(upperCriticalVal<=upperMajorVal || upperCriticalVal<=upperMinorVal)
		{
			Ext.MessageBox.show({
				title: 'User Logon settings',
				msg: 'Critical Value Should be greater than other values',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(upperMajorVal<=upperMinorVal)
		{
			Ext.MessageBox.show({
				title: 'User Logon settings',
				msg: 'Major Value Should be greater than Minor value',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var mainForm =Ext.getCmp('mainform').getForm()
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var upperCriticalVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'upperCritical',isSettingsEnabled,'upperCritical').toString();
		var upperMajorVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'uppermajor',isSettingsEnabled,'uppermajor').toString();
		var upperMinorVal = this.getSettingsFieldValue(thinclientuserSettingsForm,'upperminor',isSettingsEnabled,'upperminor').toString();
		if(!Ext.isEmpty(upperCriticalVal) && upperCriticalVal.indexOf("-")>-1)
		{
			Ext.MessageBox.show({
				title: 'User Logon Report Report',
				msg: 'Critacal Value cannot be negative',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(!Ext.isEmpty(upperMajorVal) && upperMajorVal.indexOf("-")>-1)
		{
			Ext.MessageBox.show({
				title: 'User Logon Report',
				msg: 'Major Value cannot be negative',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if(!Ext.isEmpty(upperMinorVal) && upperMinorVal.indexOf("-")>-1)
		{
			Ext.MessageBox.show({
				title: 'User Logon Report',
				msg: 'Minor Value cannot be negative',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		
		var obj = Ext.getCmp('geofilter');
		if (obj!=undefined && !obj.isHidden())
		{
			var compArray = Ext.getCmp("er_geoFilter").getValue();
			if(compArray==undefined || compArray.length==0)
			{
				Ext.MessageBox.show({
					title: 'Thin Client Application',
					msg: 'Please choose '+Ext.getCmp('multiSelectLabel_geo').text,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
			else if(compArray.length>1 && compArray.indexOf('all')>-1)
			{
				Ext.MessageBox.show({
					title: 'Thin Client Application',
					msg: 'All and Individual selection should not be allowed',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		return isSettingsOk;
	},

	showConfirmResult : function(btn){
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			this.submitReport();
		}
		else
		{
			if(!isSettingsEnabled)
			{
				this.showConfigDropdown();
				this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
			}
			var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
			var reportGenType=thinclientuserSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientuserSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},
		
	loadData:function(jsonData){
		var resultObj=Ext.getCmp('resultPanel');
		resultObj.removeAll();
		appConstants.publicjsonDataActivity=jsonData;
		var resultData=jsonData.RESULTS;
		var logonSummary=resultData.LogonSummary;

		var LogonDetail=resultData.LogonSummaryNew.Totallogon;
		var contentfrTotal='<div style="margin:0px 10px 10px 10px;"><table width="100%" border="0px"><tr>';
		for (var key in LogonDetail)
		{
			var logonSummarydata = LogonDetail[key];
			contentfrTotal+='<td align="center" width="33%"><table><tr><td align="right" style="padding-right:5px"><div class="'+logonSummarydata.iconclass+'"></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28">'+logonSummarydata.value+'</td></tr><tr><td style="text-align:center;padding:3px 3px 0px 3px" colspan="2"><span class="newFont_normal13" >'+logonSummarydata.name+'</span></td></tr></table></td>';
		}
		contentfrTotal+='</tr></table></div>';

		var LogonDetail=resultData.LogonSummaryNew.Slowlogon;
		var contentfrSlow='<div style="margin:0px 10px 10px 10px;"><table width="100%" border="0px"><tr>';
		for (var key in LogonDetail)
		{
			var logonSummarydata = LogonDetail[key];
			var vl='';
			var prsntVal='';
			if(logonSummarydata.name != undefined && (logonSummarydata.name == 'Total' || logonSummarydata.name == 'Users')  && logonSummarydata.value != undefined && logonSummarydata.value > 0){
				if(logonSummarydata.name == 'Total')
					vl='"cursor:pointer" onclick="javascript:getFocusToGrid()';
				else if(logonSummarydata.name == 'Users')
					vl='"cursor:pointer" onclick="javascript:openInNewWin(\'/final/reporter/ErSlowLogonDetailsReportDrillDown.jsp?componetKey=LowSessionConsumption\');'
				prsntVal='<div style="background:'+logonSummarydata.percentColor+';padding:5px 4px 3px 4px;margin-left:4px;color:#ffffff;font-family:arial;display:inline-block;text-align:center;line-height:.8em;font-size:12px">'+logonSummarydata.percent+'<span style="font-size:10px">%</span> <br/> <span style="font-size:8px">SLOW</span></div>'
			}
			contentfrSlow+='<td align="center" width="33%"><table style="'+vl+';"><tr><td align="right" style="padding-right:5px"><div class="'+logonSummarydata.iconclass+'"></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28">'+logonSummarydata.value+''+prsntVal+'</td></tr><tr><td style="text-align:center;padding:3px 3px 0px 3px" colspan="2"><span class="newFont_normal13" >'+logonSummarydata.name+'</span></td></tr></table></td>';
		}
		contentfrSlow+='</tr></table></div>';

		var gpBrkdownGraph='<div><table width="100%"><tr>';
		var gpGraph=resultData['GPTimeGraphObj'];
		if(gpGraph != undefined){
			gpBrkdownGraph+='<td id="gpTime" width="55%"></td>';
			var legData=gpGraph['DataSet'];
			if(legData != undefined){
				legData=legData[0].data;
			}
			var legObj="";
			gpBrkdownGraph+='<td valign="middle" width="45%"><div><table>';
			for (var key in legData)
			{
				legObj = legData[key];
				gpBrkdownGraph+='<tr><td valign="middle" style="padding-right: 5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:'+legObj.color+'"></div></td><td>'+legObj.name+'&nbsp;('+legObj.y+')</td></tr>';
			}
			gpBrkdownGraph+='</table></div></td>';
		}
		gpBrkdownGraph+='</tr></table></div>';

		resultObj.add(
		{
			xtype: 'container',
			margin:'0 0 0 0',
			columnWidth : 1.0,
			layout:'column',
			items:[
				{
					xtype: 'panel',
					ui:'newGraphPanel',
					margin:'0 5 0 0',
					columnWidth:.5,
					title:'Logons',
					html:contentfrTotal
				},
				{
					xtype: 'panel',
					ui:'newGraphPanel',
					margin:'0 5 0 5',
					columnWidth:.5,
					title:'Slow Logons',
					html:contentfrSlow
				},
			]
		},
		{
			xtype: 'panel',
			layout:'column',
			columnWidth : 1.0,
			margin:'10 0 0 0',
			items:[
			{
				xtype:'panel',
				ui:'newGraphPanel',
				title:'Logon Performance Distribution',
				margin:'0 5 10 0',
				height:300,
				columnWidth:.5,
				items:[
					{
						xtype: 'container',
						id : 'Logon_Id',
						layout:'column',
						columnWidth : 1.0,
						height:270,
						items:[
						{
							xtype:'container',
							id:'graph_1',
							columnWidth:.6,
							height:270,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=resultData['DistributionGraph'];
									if(activeSessionGraph != undefined){
										var lineChart_1 = {};
										lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('graph_1',250,400), lineChart_1);
										lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
										lineChart_1.drawChart();
									}else
									{
										Ext.get('Logon_Id').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
									}
								}
							}
						},{
							xtype:'container',
							columnWidth:.4,
							id:'legendId_1',
							height:250,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=resultData['DistributionGraph'];
									if(activeSessionGraph != undefined){
										var legData=activeSessionGraph['legendArray'];
										var legObj="";
										var legHtml='<div style="height:270px;display:table-cell;vertical-align:middle;"><table>';
										for (var key in legData)
										{
											legObj = legData[key];
											legHtml+='<tr><td valign="middle" style="padding-right: 5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:'+legObj.color+'"></div></td><td style="line-height:2.2em">'+legObj.name+'</td><td style="padding-left:10px;">'+legObj.percent+'%</td></tr>';
										}
										legHtml+='</table>';
										Ext.get('legendId_1').update(legHtml);
									}
								}
							}
						}],
					}
				]
			},
			{
				xtype:'panel',
				ui:'newGraphPanel',
				title:'Number Of Users Affected by Slow Logons',
				margin:'0 5 10 5',
				height:300,
				columnWidth:.5,
				items:[
				{
					xtype:'container',
					id:'id_2',
					height:270,
					listeners:
					{
						'boxready':function(c)
						{
							var activeSessionGraph=resultData['UsersbySlowLogonGraph'];
							if(activeSessionGraph != undefined){
								var lineChart_1 = {};
								lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('id_2',250,500), lineChart_1);
								lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
								lineChart_1.drawChart();
							}else
							{
								Ext.get('id_2').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
							}
						}
					}
				}]
			},
			{
				xtype:'panel',
				ui:'newGraphPanel',
				title:resultData.StartupDurationTrendGraphTitle,
				margin:'0 5 10 0',
				height:300,
				columnWidth:.5,
				items:[
					{
						xtype:'container',
						id:'id_5',
						height:270,
						listeners:
						{
							'boxready':function(c)
							{
								var activeSessionGraph=resultData['StartupDurationTrendGraph'];
								if(activeSessionGraph != undefined){
									var lineChart_1 = {};
									lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('id_5',270,500), lineChart_1);
									lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
									lineChart_1.drawChart();
								}else
								{
									Ext.get('id_5').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
								}
							}
						}
					}
				]
			},
			{
				xtype:'panel',
				ui:'newGraphPanel',
				title:'Total Logons vs Slow Logons Trend',
				margin:'0 5 10 5',
				height:300,
				columnWidth:.5,
				items:[
					{
						xtype:'container',
						id:'id_3',
						height:270,
						listeners:
						{
							'boxready':function(c)
							{
								var activeSessionGraph=resultData['LogOnTrendNew'];
								if(activeSessionGraph != undefined){
									var lineChart_1 = {};
									lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('id_3',270,500), lineChart_1);
									lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
									lineChart_1.drawChart();
								}else
								{
									Ext.get('id_3').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
								}
							}
						}
					}
				]
			},
			{
				xtype:'panel',
				ui:'newGraphPanel',
				title:resultData.UserswithMaxlogonDurationGraphTitle,
				margin:'0 5 10 0',
				height:300,
				columnWidth:.5,
				items:[
					{
						xtype:'container',
						id:'id_4',
						height:270,
						listeners:
						{
							'boxready':function(c)
							{
								var activeSessionGraph=resultData['UserswithMaxlogonDurationGraph'];
								if(activeSessionGraph != undefined){
									var lineChart_1 = {};
									lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('id_4',270,500), lineChart_1);
									lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
									lineChart_1.drawChart();
								}else
								{
									Ext.get('id_4').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
								}
							}
						}
					}
				]
			},
			{
				xtype:'panel',
				ui:'newGraphPanel',
				title:resultData.logonBreakdownGraphTitle,
				margin:'0 5 10 5',
				height:300,
				columnWidth:.5,
				items:[
					{
						xtype: 'container',
						id : 'avgLogonId',
						layout:'column',
						columnWidth : 1.0,
						height:270,
						items:[
						{
							xtype:'container',
							id:'id_6',
							graphId:'avgLogonId',
							columnWidth:.6,
							height:270,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=resultData['logonBreakdownGraph'];
									var avgSlowLogonDuration=resultData['avgSlowLogonDuration'];
									if(activeSessionGraph != undefined && avgSlowLogonDuration != '0'){
										var lineChart_1 = {};
										lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('id_6',250,400), lineChart_1);
										lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
										lineChart_1.drawChart();
									}else
									{
										//Ext.get('id_6').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><div class="iconNoalarms"><div class="commonErrorMsgText">No Slow Logons found</div></div></div>');
										Ext.get('id_6').update('<table style="width:510px" height="100%"><tr><td align="center" valign="middle"><div class="iconNoalarms" ></div><div class="commonErrorMsgText">No Slow Logons found</div></td></tr></table>');
									}
								}
							}
						},{
							xtype:'container',
							columnWidth:.4,
							id:'legendId',
							height:270,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=resultData['logonBreakdownGraph'];
									var avgSlowLogonDuration=resultData['avgSlowLogonDuration'];
									if(activeSessionGraph != undefined && avgSlowLogonDuration != '0'){
										var legData=activeSessionGraph['legendArray'];
										var legObj="";
										var legHtml='<div style="height:270px;display:table-cell;vertical-align:middle;padding-right:15px;"><table>';
										for (var key in legData)
										{
											legObj = legData[key];
											legHtml+='<tr><td valign="top" style="padding-right: 5px;padding-top: 5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:'+legObj.color+'"></div></td><td>'+legObj.name+'</td><td valign="top" style="padding-left:15px;">'+legObj.val+'</td></tr>';
											if(legObj != undefined && legObj.innerArray != undefined){
												var innerMeasr=legObj.innerArray;
												for(var indx in innerMeasr){
													var legArr=innerMeasr[indx];
													if(legArr != undefined){
														legObj = legData[key];
														legHtml+='<tr><td>&nbsp;</td><td>&nbsp;&nbsp;'+legArr.name+'</td><td valign="top" style="padding-left:15px;">'+legArr.val+'</td></tr>';
													}
												}
											}
										}
										legHtml+='</table>';
										Ext.get('legendId').update(legHtml);
									}
								}
							}
						}],
					}
				]
			}]
		});
		var gpGraph=resultData['GPTimeGraphObj'];
		if(gpGraph != undefined){
			resultObj.add(
			{
				xtype: 'panel',
				layout:'column',
				columnWidth : 1.0,
				items:[
				{
					xtype:'panel',
					ui:'newGraphPanel',
					title:'Client Side Extension Time Breakdown (Secs)',
					margin:'0 5 10 0',
					height:300,
					columnWidth:.5,
					items:[
						{
							xtype: 'container',
							id : 'gp_id',
							layout:'column',
							columnWidth : 1.0,
							height:270,
							items:[
							{
								xtype:'container',
								id:'gpgraph_1',
								columnWidth:.6,
								height:270,
								listeners:
								{
									'boxready':function(c)
									{
										var activeSessionGraph=resultData['GPTimeGraphObj'];
										if(activeSessionGraph != undefined){
											var lineChart_1 = {};
											lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('gpgraph_1',250,400), lineChart_1);
											lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
											lineChart_1.drawChart();
										}else
										{
											Ext.get('gp_id').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
										}
									}
								}
							},{
								xtype:'container',
								columnWidth:.4,
								id:'legendId_2',
								height:250,
								listeners:
								{
									'boxready':function(c)
									{
										var activeSessionGraph=resultData['GPTimeGraphObj'];
										if(activeSessionGraph != undefined){
											var legData=gpGraph['DataSet'];
											if(legData != undefined){
												legData=legData[0].data;
											}
											var legObj="";
											var legHtml='<div style="height:270px;display:table-cell;vertical-align:middle;padding-right: 15px;"><table>';
											for (var key in legData)
											{
												legObj = legData[key];
												legHtml+='<tr><td valign="top" style="padding-right: 5px;padding-top: 5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:'+legObj.color+'"></div></td><td>'+legObj.name+'</td><td valign="top" style="padding-left:15px;">'+legObj.y+'</td></tr>';
											}
											legHtml+='</table>';
											Ext.get('legendId_2').update(legHtml);
										}
									}
								}
							}],
						}
					]
				},
				{
					xtype:'panel',
					ui:'newGraphPanel',
					title:resultData.UserswithMaxGPDuraionGraphTitle,
					margin:'0 5 10 5',
					height:300,
					columnWidth:.5,
					items:[
						{
							xtype:'container',
							id:'gptime_4',
							height:270,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=resultData['MaxGPTimeGraphObj'];
									if(activeSessionGraph != undefined){
										var lineChart_1 = {};
										lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('gptime_4',270,350), lineChart_1);
										lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
										lineChart_1.drawChart();
									}else
									{
										Ext.get('gptime_4').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
									}
								}
							}
						}
					]
				}]
			});
		}

//Grid Starts
		var me=this;
		var activePage=1;
		if(resultData.GridObj != undefined){//For Directory Comp
			var gridColumn=resultData.GridObj.columns;
			var gridData=resultData.GridObj.dataArray;
			var mainColArray=new Array();
			var logonval=0;
			var slowLogonInnerTableDivWidth = Ext.getCmp('thinclientuser').getWidth()-100;
			for (var key in gridColumn)
			{
				mainColumn = gridColumn[key];
				var colWidth=80;
				var colAlgn='center';
				if(mainColumn != undefined && (mainColumn == 'session startup Time' || mainColumn == 'Client ip address' || mainColumn == 'Client name' || mainColumn == 'Client version' || mainColumn == 'Launched via ip address' || mainColumn == 'Controller name' || mainColumn == 'Server'  || mainColumn == 'user Name' )){
					colWidth=120;
					colAlgn='left';
				}
				else if(mainColumn != undefined && mainColumn == 'Logon duration') {
					colWidth=100;
					logonval=key;
				}
				mainColArray.push({
					header:mainColumn,
					sortable: true,
					width:colWidth,
					align:colAlgn,
					dataIndex: mainColumn,
					doSort: function(state) 
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}
								if(!isNaN(v1) && !isNaN(v2))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;
										v2= isNaN(v2) ? 0 : v2;
									}
								}
								else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime();
									v1=new Date(v1).getTime();
								}
								// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					},
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						metaData.tdAttr = 'data-qtip="' + value + '"';
						value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
						return value;
					}
				});
			}
			for(var index in gridData)
			{
				var dataInfo = gridData[index];
				var subTableData = dataInfo.dirtData;
				if(subTableData != undefined){
				var clinetServerData=subTableData.clinetServerData;

				var subTable = '<div style="margin:15px;width:'+slowLogonInnerTableDivWidth+'px;" class="userLogonInnerTableOuter">';
				subTable +='<table width="100%" cellpadding="0" cellspacing="0" border="0px"><tbody><tr><td width="100%" style="padding:10px 0px 10px 0px;"><div class="reporterHtmlFieldsetBody"><div class="reporterLogonFieldsetHeader" nowrap="">'+clinetServerData.title+'</div>';
					var mainHeading=clinetServerData.mainHeader;
				var serverHeader=clinetServerData.serverHeader;
				var clientHeader=clinetServerData.clientHeader;
				var commnData=clinetServerData.commnData;
				var serverData=clinetServerData.serverData;
				var clientData=clinetServerData.clientData;
				subTable +=    '<table width="100%" cellpadding="0" cellspacing="0">';
				if(mainHeading != undefined){
					subTable +=    '<tr><td colspan="3" style="padding:6px;height:30px" align="center"><div class="reporterLogonSessionStartupBox" style="width:350px;height:24px;margin:20px auto 10px  auto;"><table border="0" style="margin:3px auto;"><tbody><tr><td class="reporterLogonSessionStartup">Session Start-up Duration (secs) :</td><td class="reporterLogonSessionStartupValue">'+mainHeading.value+'</td></tr></tbody></table></div></td></tr>';
				}
				subTable+='<tr>';
				subTable+='<td style="padding:0px 5px 20px 20px"><table border="0px" style="width:100%" class="reporterLogonServerStartUpTable"><tbody>';
				if(serverHeader != undefined){
					subTable+='<tr>';
					if(commnData != undefined){
						subTable+='<td valign="middle" rowspan="2"><table border="0px" style="width:150px;float:left;margin-top:7px"><tbody>';
						for(var indx in commnData)
						{
							var cmnDt=commnData[indx];
							subTable+='<tr><td><div class="reporterLoginSessionLabel" style="text-align:center;">'+cmnDt.key+'</div><div class="reporterLoginPopupVal" style="text-align:center;">'+cmnDt.value+'</div></td></tr>';
						}
						subTable+='</tbody></table></td>';
					}
					subTable+='<td  valign="top" class="newLineLeft2" style="padding-left:10px;padding-right:20px"><table border="0px" style="width:100%;float:left" ><tbody><tr><td class="reporterLogonPanelHead" style="text-align:left;width:90%">Server Start-up Duration (secs) </td><td style="align:right;" class="reporterLogonPanelHead"><div style="float:right;width:80px;text-align:right;">'+serverHeader.value+'</div></td></tr></tbody></table></td></tr>';
				}
				subTable+='<tr>';
				if(serverData != undefined){
					subTable+='<td valign="top" style="padding-left:10px;padding-right:0px"><div style="height:150px;overflow:auto;width:100%;padding:right:10px"><table border="0px" style="float:left;" class="reporterLogonPanelBody"><tbody>';
					for(var sindx in serverData)
					{
						var servDt=serverData[sindx];
						subTable+='<tr><td style="width:90%">'+servDt.key+'</td><td style="align:right;"><div class="valueDiv">'+servDt.value+'</div></td></tr>';
					}
					subTable+='</tbody></table></div></td>';
				}
				subTable+='</tr></tbody></table></td>';

				subTable+='<td style="padding:0px 20px 20px 5px"><table border="0" style="width:100%;float:left" class="reporterLogonServerStartUpTable"><tbody>';
				if(clientHeader != undefined)
				{
					subTable+='<tr><td style="padding-left:10px;padding-right:20px"><table width="100%"><tbody><tr><td class="reporterLogonPanelHead" style="text-align:left;width:90%">Client Start-up Duration (secs)</td><td style="align:right;" class="reporterLogonPanelHead"><div style="float:right;width:80px;text-align:right;">'+clientHeader.value+'</div></td></tr></tbody></table></td></tr>';
				}
				subTable+='<tr><td style="padding-left:10px;"><div style="height:150px;overflow:auto;width:100%"><table class="reporterLogonPanelBody" width="100%"><tbody>';
				if(clientData != undefined){
					for(var cindx in clientData)
					{
						var clntDt=clientData[cindx];
						subTable+='<tr><td style="width:80%">'+clntDt.key+'</td><td style="align:right;"><div class="valueDiv">'+clntDt.value+'</div></td></tr>';
					}
				}
				subTable+='</tbody></table></div></td></tr>';
				subTable+='</tbody></table></td>';
				subTable+='</tr></tbody>';
				subTable+='</table>';
				subTable+='</div></td></tr></tbody></table>'


				var gpData=subTableData.gpDatas;
				if(gpData != undefined){
					subTable +=' <div class="userLogonInnerTableOuter bg2" style="position:relative;margin:10px 0px 5px 0px;"><div class="reportLog  onGridColumnHighlightArrow" style="left:100px;top:-10px"></div><p class="font_bold12">Details of client side extensions</p><div style="margin-top:10px;" class="newTable"><table width="100%"><thead><tr>';
					var gpHeading=gpData.gpHeader;
					var gpDataArray=gpData.gpDataArr;
					if(gpHeading != undefined){
						for(var gpindex in gpHeading){
							subTable +='<th>'+gpHeading[gpindex]+'</th>';
						}
					}
					subTable +='</tr></thead><tbody>';
					if(gpDataArray != undefined)
					{
						for(var dataindex in gpDataArray)
						{
							subTable +='<tr>';
							var val=gpDataArray[dataindex];
							for(var hdr in gpHeading)
							{
								var strVal=gpHeading[hdr];
								subTable +='<td>'+val[strVal]+'</td>';
							}
							subTable +='</tr>';
						}
					}
					subTable +='</tbody></table></div></div>';
				}
				subTable +='</div>';
				gridData[index]['app']=subTable;
				}
			}
			var fields=[];
			for(var key in gridData[0])
			{
				fields.push(key);
			}
			fields.push('app');
			var storeObj = Ext.create('Ext.data.Store', {
				fields: fields,
				proxy : {
						type : 'pagingmemory',
						reader : {
							type: 'json', root : 'data', totalProperty : 'total'
						},
					},
				pageSize : resultData.GridObj.gridRowSize,	//gridPageSize is added in ErTracker.jsp
			//	sorters: { property: fields[logonval], direction : 'DESC' },
				autoLoad : true,
				data:gridData,
			});
			var isPagingHidden;
			if (gridData.length<resultData.GridObj.gridRowSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var dataArray=new Array();
			dataArray.push({
				xtype:'panel',
				columnWidth : 1.0,
				ui:'newGraphPanel',
				margin:'0 5 10 0',
				needtoFixColumn:true,
				title:"Slow Logon Details (Secs)",
				items:[{
					xtype:'customgrid',
					store:storeObj,
					sortableColumns:false,
					ui:'newGridPanel noHoverColor headerTextWrap',
					id:'mainGrid',
					margin:'0 10 10 10',
					activePage:1,
					border:true,
					scroll:true,
					autoScroll:true,
					columns:mainColArray,
					bodyPadding:'0 0 0 0',
					plugins: [{
						ptype: 'rowexpander',
						selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
						expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
						expandOnEnter : false,
						collapsible: true,
						animCollapse: false,
						rowBodyTpl: [
							'<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',	
						]
					}],
					viewConfig:
					{
						stripeRows: true,
						getRowClass: function (record, rowIndex, rowParams, store)
						{
							if (record.data.app.length>0)
							{
								return ;
							}
							else
							{
								return 'hidePlus';
							}
						}
					},
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
							me.gridColIndexParam=column.getIndex();
							me.gridColStateParam=column.sortState;
							this.getStore().loadPage(activePage);
						},
						render:function(obj){
							Ext.defer(function() {
							},100);
						}
					},
					dockedItems:[{
						xtype:'pagingtoolbar',
						dock: 'bottom',
						cls:'newPagination',
						displayInfo: true,
						store: storeObj,
						hidden:isPagingHidden,
						displayInfo: true,
						displayMsg: 'Displaying topics {0} - {1} of {2}',
						emptyMsg: "No topics to display",
						listeners: {
							change : function(thisd, params)
							{
								if(!Ext.isEmpty(params) && !isPagingHidden)
								{
									Ext.getCmp('mainGrid').activePage = params.currentPage;
								}
								else
									Ext.getCmp('mainGrid').activePage=1;
							}
						}
					}]
				}]
			});
			resultObj.add(dataArray);
		}


//for new Design in Grid page
		var activePage=1;
		if(resultData.NewGridObj != undefined){ //Xcept Directory Comp
			var gridColumn=resultData.NewGridObj.columns;
			var gridData=resultData.NewGridObj.dataArray;
			var mainColArray=new Array();
			var sortVal=0;
			for (var key in gridColumn)
			{
				mainColumn = gridColumn[key];
				var algn='center';
				if(mainColumn == 'user Name' || mainColumn == 'Server' || mainColumn == 'session startup Time' || mainColumn == 'Client ip address' || mainColumn == 'Client name')
					algn='left';

				if(mainColumn != undefined && mainColumn == 'Session start-up duration' )
					sortVal=key;
				
				mainColArray.push({
					header:mainColumn,
					sortable: true,
					//width:150,
					align:algn,
					dataIndex: mainColumn,
					doSort: function(state) {
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}
								if(!isNaN(v1) && !isNaN(v2))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;
										v2= isNaN(v2) ? 0 : v2;
									}
								}
								else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime();
									v1=new Date(v1).getTime();
								}
								// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					},
					renderer: function(value, metaData, record, row, col, store, gridView)
					{
						metaData.tdAttr = 'data-qtip="' + value + '"';
						value = Ext.getCmp('mainGrid2').getDecimalAlignFormat(value);
						return value;
					}
				});
			}
			for(var index in gridData)
			{
				var dataInfo = gridData[index];
				var subTableData = dataInfo.additionalDatas;
				var subTableDataforVDI = dataInfo.additionalDatasforVDI;
				var gpTableData = dataInfo.GPDetails;
				if(subTableData != undefined){
				var serverData=subTableData.Server;
				var clientData=subTableData.Client;

				var subTable = '<div style="margin:5px;"><table width="100%" border="0px" >';
				subTable +='<tr>';
				if(serverData != undefined){
					subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">Server Start up (secs)</div><div ><table>';
					for(var ind in serverData)
					{
						var sevrData=serverData[ind];
						subTable+='<tr><td>'+sevrData.key+'</td><td>'+sevrData.value+'</td></tr>';
					}
					subTable +='</table></div></div></td>';
				}
				if(clientData != undefined){
					subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">Client Start up (secs)</div><div><table>';
					for(var ind in clientData)
					{
						var clntData=clientData[ind];
						subTable+='<tr><td>'+clntData.key+'</td><td>'+clntData.value+'</td></tr>';
					}
					subTable +='</table></div></div></td>';
				}
				subTable +='</tr>';
				subTable +='</table></div>';
				}
				if(subTableDataforVDI != undefined){
					var logonbreakup=subTableDataforVDI.logonBreakup;
					var gpBreakup=subTableDataforVDI.gpBreakup;
					var subTable = '<div style="margin:5px;"><table width="100%" border="0px" >';
					subTable +='<tr>';
					if(logonbreakup != undefined){
						subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">logon Time Break-up (secs)</div><div style="height:140px;"><table>';
						for(var ind in logonbreakup)
						{
							var sevrData=logonbreakup[ind];
							subTable+='<tr><td>'+sevrData.key+'</td><td>'+sevrData.value+'</td></tr>';
						}
						subTable +='</table></div></div></td>';
					}
					if(gpBreakup != undefined){
						subTable +='<td width="50%"><div style="margin:0px 10px 10px 0px;" class="newPlainTable"><div class="font_bold12">Group policy Time Break-up (secs)</div><div style="height:140px;"><table>';
						for(var ind in gpBreakup)
						{
							var clntData=gpBreakup[ind];
							subTable+='<tr><td>'+clntData.key+'</td><td>'+clntData.value+'</td></tr>';
						}
						subTable +='</table></div></div></td>';
					}
					subTable +='</tr>';
					subTable +='</table></div>';
				}

				if(gpTableData != undefined){
					var gpHeader=gpTableData.Header;
					var gpData=gpTableData.Datas;
					subTable += '<div style="margin:5px;" class="newTable"><div class="font_bold12">Details of client side extensions</div><table width="100%" border="0px" >';
					subTable +='<thead><tr>';
					for(var hdr in gpHeader)
					{
						subTable +='<th>'+gpHeader[hdr]+'</th>';
					}
					subTable +='</tr></thead><tbody>';
					for(var dt in gpData)
					{
						var val=gpData[dt];
						subTable +='<tr>';
						for(var hdr in gpHeader)
						{
							var strVal=gpHeader[hdr];
							subTable +='<td>'+val[strVal]+'</td>';
						}
						subTable +='</tr>';
					}
					subTable +='</tbody></table></div>';
				}
				gridData[index]['app']=subTable;
			}

			var fields=[];
			for(var key in gridData[0])
			{
				fields.push(key);
			}
			fields.push('app');
			var storeObj = Ext.create('Ext.data.Store', {
				fields: fields,
				proxy : {
						type : 'pagingmemory',
						reader : {
							type: 'json', root : 'data', totalProperty : 'total'
						},
					},
				pageSize : resultData.NewGridObj.gridRowSize,	//gridPageSize is added in ErTracker.jsp
				autoLoad : true,
			//	sorters: { property: fields[sortVal], direction : 'DESC' },
				data:gridData,
			});
			var isPagingHidden;
			if (gridData.length<resultData.NewGridObj.gridRowSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var dataArray1=new Array();
			dataArray1.push({
				xtype:'panel',
				ui:'newGraphPanel',
				columnWidth : 1.0,
				margin:'0 5 10 0',
				needtoFixColumn:true,
				title:"Slow Logon Details (Secs)",
				items:[{
					xtype:'customgrid',
					store:storeObj,
					sortableColumns:false,
					ui:'newGridPanel headerTextWrap noHoverColor',
					id:'mainGrid2',
					margin:'0 10 10 10',
					activePage:1,
					border:true,
					scroll:true,
					autoScroll:true,
					columns:mainColArray,
					bodyPadding:'0 0 0 0',
					forceFit:true,
					plugins: [{
						ptype: 'rowexpander',
						selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
						expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
						expandOnEnter : false,
						collapsible: true,
						animCollapse: false,
						rowBodyTpl: [
							'<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',	
						]
					}],
					viewConfig:
					{
						stripeRows: true,
						getRowClass: function (record, rowIndex, rowParams, store)
						{
							if (record.data.app.length>0)
							{
								return ;
							}
							else
							{
								return 'hidePlus';
							}
						}
					},
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
							me.gridColIndexParam=column.getIndex();
							me.gridColStateParam=column.sortState;
							this.getStore().loadPage(activePage);
						},
						render:function(obj){
							Ext.defer(function() {
								//obj.columns[sortIndex].setSortState('DESC', true, false);
							},100);
						}
					},
					dockedItems:[{
						xtype:'pagingtoolbar',
						dock: 'bottom',
						cls:'newPagination',
						displayInfo: true,
						store: storeObj,
						hidden:isPagingHidden,
						displayInfo: true,
						displayMsg: 'Displaying topics {0} - {1} of {2}',
						emptyMsg: "No topics to display",
						listeners: {
							change : function(thisd, params)
							{
								if(!Ext.isEmpty(params) && !isPagingHidden)
								{
									Ext.getCmp('mainGrid2').activePage = params.currentPage;
								}
								else
									Ext.getCmp('mainGrid2').activePage=1;
							}
						}
					}]
				}]
			});
			resultObj.add(dataArray1);
		}
		if(resultData.NewGridObj == undefined && resultData.GridObj == undefined)
		{
			resultObj.add(
			{
				xtype:'panel',
				ui:'newGraphPanel',
				columnWidth : 1.0,
				margin:'0 5 10 0',
				title:"Slow Logon Details (Secs)",
				html:'<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>'
			});
		}
		
		resultObj.show();
		resultObj.doLayout();
		resultObj.doComponentLayout();

		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		
		initLdgMask.hide();
	},
	
	submitReport:function()
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		initLdgMask.show();
		var url;
		var backgroundUrl;
		var Qstring;
		var dataAvailable=false;
		var mainForm =Ext.getCmp('mainform').getForm();
		//
		var userNameTxtEmpty = true;
		if (Ext.getCmp('optionmultipane').isHidden())
		{
			var userArray=Ext.getCmp('er_user').getValue();
			userArray = userArray.split(',');
			if(userArray!=null && userArray!='undefined' && userArray.length>0)
			{
				for(var k=0;userArray.length>k;k++)
				{
					if(userArray[k].trim() != "" && userArray[k].trim().length > 0)
					{
						userNameTxtEmpty = false;
					}
				}
				if( Ext.getCmp('er_user').isHidden())
				{
					userNameTxtEmpty = false;
				}
			}
		}
		if(Ext.getCmp('optionmultipane').isHidden() && userNameTxtEmpty){
			initLdgMask.hide();
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'User field is not empty',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if(!isSettingsEnabled)
		{
			this.showConfigDropdown();
			this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		}
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		this.updateQStringActivity();
		url="../servlet/com.eg.ErSlowLogonDetailsReportC?isSubmit=true&responseType=json";
		backgroundUrl='/final/servlet/com.eg.ErStartBackGroundReportC';
		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
		var backgroundresultsObj=Ext.getCmp('backGroundPanel');
		var reportGeneration=Ext.getCmp('reportGeneration').getValue();
		var reportType='';
		if(reportGeneration == 'foreground')
		{
			backgroundresultsObj.hide();
			Ext.Ajax.request(
			{
				url : url,
				params : Qstring +'&'+ appConstants.queryStringActivity,
				scope:this,
				timout:320000,
				success: function(response){
					var jsonData=Ext.decode(response.responseText);
					var reportData=jsonData;
					var compType = reportData.compType;
					if(compType!=undefined && compType=='Horizon_Pod')
					{
						if (reportData.NO_DATA != undefined && !reportData.NO_DATA)
						{
							this.getNomeasurepanel().hide();
							Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
							var resultPanelObj=Ext.getCmp('resultPanel');
							resultPanelObj.removeAll();
							resultPanelObj.add({
								xtype:'podresultview',
								data:reportData
							});
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("printTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
							resultPanelObj.show();
							initLdgMask.hide();
						}
						else 
						{
							this.disableTools();
							resultObj.hide();
							this.getNomeasurepanel().doLayout();
							this.getNomeasurepanel().show();
							Ext.getCmp("bookletTool").setDisabled(true);
							Ext.getCmp("saveTool").setDisabled(true);
							Ext.getCmp("printTool").setDisabled(true);
							Ext.getCmp("mailTool").setDisabled(true);
						}
					}
					else
					{
						if(jsonData.noDataFound == 'false')
						{
							this.getNomeasurepanel().hide();
							this.loadData(jsonData);
						}
						else
						{
							resultPanelObj.hide();
							this.getNomeasurepanel().doLayout();
							this.getNomeasurepanel().show();

							Ext.getCmp("bookletTool").setDisabled(true);
							Ext.getCmp("saveTool").setDisabled(true);
							Ext.getCmp("printTool").setDisabled(true);
							Ext.getCmp("mailTool").setDisabled(true);
							initLdgMask.hide();
						}
					}
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				}
			});
		}
		else if(reportGeneration == 'background' )
		{
			resultPanelObj.hide();
			this.getNomeasurepanel().hide();
			myMask = new Ext.LoadMask(Ext.getBody(), {msg : "Loading..."});
			myMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			Ext.Ajax.request({
				url : backgroundUrl,
				params : Qstring+"&bg_reportname="+bg_reportname+'&'+ appConstants.queryStringActivity,
				scope : this,
				method : 'POST',
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success')
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							var htmlStr = "";
						
							backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
						}
						else if(backgroundReportStatus== 'duplicate')
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
						}
					}
					else
					{
					
						backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">ErroR In BackGround Generation</div></td></tr></table></td></tr></table>');
					}
					backgroundresultsObj.show();
					myMask.hide();
				}
			});
		}
	},

	reportGenChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
		if(reportGenType== 'background')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(reportGenType== 'background-csv')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},

	/* weekendOnChange:function()
	{
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes')
		{
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},*/

	loadTools : function()
	{
		this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},

	disableTools: function()
	{
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
	},

	updateQStringActivity:function()
	{
		var FormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm=null;
		if(isSettingsEnabled)
			thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		if(Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var componentType = mainForm.findField('er_compType').getValue();
		FormParams="select_farm="+mainForm.findField('select_farm').getValue()
					+"&er_comptype="+mainForm.findField('er_compType').getValue()
					+"&er_brokeringFrom="+mainForm.findField('brokeringFrom').getValue()
					+"&er_inclReconnect="+this.getSettingsFieldValue(thinclientuserSettingsForm,'inclReconnect',isSettingsEnabled,'includeReconnects')
					+"&er_excwe="+this.getSettingsFieldValue(thinclientuserSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')
					+"&er_reportgenration="+this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		FormParams += "&er_componentType="+componentType+'&ervm_type=UserLogon';
		var obj = Ext.getCmp('geofilter');
		if (obj!=undefined && !obj.isHidden())
		{
			var compArray = Ext.getCmp("er_geoFilter").getValue();
			if(!isSettingsEnabled)
			{
				compArray = appConstants.publicjsonDataActivity.selectedgeoFilter;
			}
			if(compArray!=null && compArray!='undefined' && compArray.length>0)
			{
				for(var k=0;compArray.length>k;k++)
				{
					FormParams+="&filterValue="+compArray[k];
				}
			}
			else
			{
				FormParams+="&filterValue=All";
			}
			FormParams+="&searchBasedOn="+Ext.getCmp('geofilter').geoFilterScreachStr;
		}
		if(Ext.get('showLegend')!=null)
			FormParams=FormParams+"&showLegend="+mainForm.findField('showLegend').getValue();
		var serverArray=Ext.getCmp('er_server').getValue();
		if(serverArray!=null && serverArray!='undefined' && serverArray.length>0)
		{
			for(var k=0;serverArray.length>k;k++)
			{
				FormParams+="&er_component="+encodeURIComponent(serverArray[k]);
			}
		}
		
		if(Ext.getCmp('er_poolType_container').isVisible())
		{
			var gpArray = Ext.getCmp('er_poolType').getValue();
			if(gpArray!=undefined)
			{
				for (var k = 0; gpArray.length > k; k++) 
				{
					FormParams += "&er_poolType=" + gpArray[k];
				}
			}
			FormParams+="&er_user=--All--";
		}
		/*else
		{
			var userArray=Ext.getCmp('er_user').getValue();
			if(userArray!=null && userArray!='undefined' && userArray.length>0)
			{
				for(var k=0;userArray.length>k;k++)
				{
					FormParams+="&er_user="+appConstants.erUtils.specialCharEncode(userArray[k]);
				}
			}
		}*/
		if(serverArray ==undefined || serverArray=="-1" ||(serverArray!=null && serverArray!=undefined && serverArray.length>1))
		{
			var er_perserver = this.getSettingsFieldValue(thinclientuserSettingsForm,'er_perserver',isSettingsEnabled,'selectedAggServer')
			if(er_perserver!=null)
				FormParams+="&er_perserver="+er_perserver;
		}
		if (appConstants.isExceedUserLimit)
		{
			var userArray=Ext.getCmp('er_user').getValue();
			userArray = userArray.split(',');
			if(userArray!=null && userArray!='undefined' && userArray.length>0)
			{
				for(var k=0;userArray.length>k;k++)
				{
					if(userArray[k].trim() != "" && userArray[k].trim().length > 0)
					{
						FormParams += "&er_user="+appConstants.erUtils.specialCharEncode(userArray[k]);
					}
				}
			}
		}
		else
		{
			var er_application = Ext.getCmp('er_application').getValue();
			if(er_application!=null && er_application!='undefined' && er_application.length>0)
			{
				for(var k=0;er_application.length>k;k++)
				{
					var tempStr = er_application[k];
					if (tempStr.indexOf("+")> -1)
					{
						tempStr = tempStr.substring(tempStr.indexOf("+")+1);
					}
					//FormParams+="&er_user="+encodeURIComponent(tempStr);
					FormParams+="&er_user="+appConstants.erUtils.specialCharEncode(tempStr);
				}
			}
		}
		FormParams += "&eruserid="+appConstants.userId;

		var s_timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var s_minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var s_timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var s_minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');
		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		var timperiodParams="&timefrom="+s_timefrom+"&minfrom="+s_minfrom+"&timeto="+s_timeto+"&minto="+s_minto;
 		var value=Ext.getCmp("er_option").getValue();	
		if(!Ext.isEmpty(value))
			FormParams+='&er_option='+value;
		if(!Ext.isEmpty(Ext.getCmp('uppermajor')))
		{
			value=Ext.getCmp('uppermajor').getValue();
			if(!Ext.isEmpty(value))
				FormParams+='&uppermajor='+value;
			value=Ext.getCmp('upperminor').getValue();
			if(!Ext.isEmpty(value))
				FormParams+='&upperminor='+value;
			value=Ext.getCmp('upperCritical').getValue();
			if(!Ext.isEmpty(value))
				FormParams+='&upperCritical='+value;
		}
		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields'))
		{
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields)
			{
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		appConstants.queryStringActivity=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
	},

	afterMainRender:function(){
		var thisController = this;
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonDataActivity.reportTitle);
		this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
		if(!hideBackButton)
		{
			Ext.getCmp('thinclientuserform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicjsonDataActivity['ID']
			});
		}
	},

	loadSettingsElements:function(){
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id) && !((appConstants.executeFavorite!="null" && appConstants.executeFavorite=="true") || (appConstants.fromScheduleView!="null" && appConstants.fromScheduleView=="true")))
		{
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp('moreOptionCloseId').show();
		var thisController  =this;
		this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndCloseSettings()
		});
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if(isSettingsOk)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},

	refreshReportData:function(){
		var jsonData;
		jsonData=appConstants.publicjsonDataActivity;
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
            initLdgMask.show();
			this.submitReport();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},

	fillFormFieldsForActivity:function(jsonData)
	{
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		if(jsonData.hasOwnProperty('isSubmit'))
			var isSubmitted=jsonData.isSubmit;
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) 
		{
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
		}
		else
		{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var mainForm =Ext.getCmp('mainform').getForm();
		var screenLabels=jsonData.screenLabels;
		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;
		var startDateObj = mainForm.findField('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = mainForm.findField('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = mainForm.findField('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = mainForm.findField('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = end_hour;
		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
		comboRawData=jsonData.analysisByCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedAnalysisByCombo;
			comboObject=mainForm.findField('er_option');
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption) )
			{
				comboObject.setValue(selectedComboOption);
			}
			else
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		comboRawData=jsonData.zoneCombo;
		selectedComboOption=jsonData.selectedZone;
		comboObject=mainForm.findField('select_farm');
		comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);
 		comboObject.getStore().clearFilter(true);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption))
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData=jsonData.compTypeCombo;
		selectedComboOption=jsonData.selectedCompType;
		comboObject=mainForm.findField('er_compType');
		comboObject.setFieldLabel(screenLabels['reporter.thin.Component Type']);
		comboObject.getStore().clearFilter(true);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption))
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		if(jsonData.isVm != undefined && jsonData.isVm == 'true'){
			if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='yes'){
				if(Ext.getCmp('brokeringFrom') != undefined){
					Ext.getCmp('brokeringFrom').show();
				}
			}
			else if(jsonData.enableBrokering  != undefined && jsonData.enableBrokering =='No'){
				if(Ext.getCmp('brokeringFrom') != undefined)
					Ext.getCmp('brokeringFrom').hide();
			}
			var brokerngFrm=jsonData.enableBrokeringFor;
			if(Ext.getCmp('brokeringFrom') != undefined)
				Ext.getCmp('brokeringFrom').setValue(brokerngFrm);

		}
		appConstants.reportType = false;
		comboRawData=jsonData.userCombo;
		appConstants.rawDataForUsers=jsonData.userCombo;
		selectedComboOption=jsonData.selectedUser;
		var disableUserCombo = jsonData.disableUserCombo;
		var userTextFieldValue = jsonData.userTextFieldValue;
		if (disableUserCombo != undefined && disableUserCombo=='yes')
		{
			appConstants.isExceedUserLimit = true;
		}
		else
			appConstants.isExceedUserLimit = false;
		//appConstants.isExceedUserLimit = false;
		if (appConstants.isExceedUserLimit)
		{
			appConstants.reportType = false;
			Ext.getCmp('er_user').show();
			Ext.getCmp('er_user').setValue(userTextFieldValue);
			Ext.getCmp('optionmultipane').hide();
		}
		else
		{
			appConstants.reportType = false;
			Ext.getCmp('optionmultipane').show();
			Ext.getCmp('er_user').hide();
			comboObject=mainForm.findField('er_application');
			comboObject.getStore().loadRawData(comboRawData);
			if(!Ext.isEmpty(selectedComboOption))
			{
				comboObject.setValue(selectedComboOption);
			}
			else
			{
				if(comboRawData != undefined)
					comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		if(!appConstants.reportType)
		{
			mainForm.findField('er_mode').hide();
			comboRawData=jsonData.serverCombo;
			selectedComboOption=jsonData.selectedServer;
			comboObject=Ext.getCmp('er_server');
			appConstants.rawDataForComponents = comboRawData;
			comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
			comboObject.getStore().loadRawData(comboRawData);
			if(!Ext.isEmpty(selectedComboOption))
			{
				comboObject.setValue(selectedComboOption);
			}
			else
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();

			if(selectedComboOption!=null && selectedComboOption.indexOf("All ")>-1)
			{
				if(Ext.getCmp('er_perserver')!=undefined)
					Ext.getCmp('er_perserver').show();
			}
		}
		else
		{
			comboRawData=jsonData.graphTypeArray;
			selectedComboOption=jsonData.selectedGraphType;
			if(selectedComboOption=='distribution')
			{
				comboRawData=jsonData.measureCombo;
				selectedComboOption=jsonData.selectedMeasure;
				comboObject.show();
			}
			else
			{
				comboRawData=jsonData.userCombo;
				appConstants.rawDataForUsers=jsonData.userCombo;
				selectedComboOption=jsonData.selectedUser;
				comboObject=mainForm.findField('er_application');
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) )
				{
					comboObject.setValue(selectedComboOption);
				}
				else
				{
					comboObject.setValue(comboRawData[0].valueField);
				}
				comboObject.show();
			}
			Ext.getCmp("serverMultiSelectLbl").hide();
		}
		comboObject=Ext.getCmp('er_showDeliveryGroup');
		selectedComboOption=jsonData.selectedShowDeliveryGroup;
		comboObject.hide();
		if(selectedComboOption!=undefined)
		{
			comboObject.show();
			comboObject.setFieldLabel(screenLabels['reporter.common.Show Delivery Groups']);
			comboObject=Ext.getCmp('deliveryGroupNo');
			if(selectedComboOption=="Yes")
			{
				comboObject=Ext.getCmp('deliveryGroupYes');
			}
			comboObject.setValue(true);
		}
		comboRawData=jsonData.poolTypeCombo;
		if(comboRawData!=undefined)
		{
			appConstants.rawDataForPoolType=jsonData.poolTypeCombo;
			selectedComboOption=jsonData.poolTypeSelected;
			comboObject=mainForm.findField('er_poolType');
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			} else {
				if(comboRawData[0].valueField!=-1)
					comboObject.setValue(comboRawData[0].valueField);
				else
					comboObject.setValue(comboRawData[1].valueField); //added for pool type not auto select
			}
			Ext.getCmp('er_poolType_container').setFieldLabel(jsonData.screenLabels['reporter.thin.poolTypeLabel']);
		}
		if(jsonData.selectedCompType=='Horizon_Pod')
		{
			Ext.getCmp('brokeringFrom').hide();
			Ext.getCmp('optionmultipane').hide();
			Ext.getCmp('er_user').hide();
			Ext.getCmp('er_poolType_container').show();
			Ext.getCmp('er_showDeliveryGroup').hide();
		}
		else
		{
			Ext.getCmp('er_poolType_container').hide();
			Ext.getCmp('er_showDeliveryGroup').show();
		}
		if(jsonData.selectedCompType=='Citrix_XcXenDesktop_Site')
		{
			if(jsonData.selectedShowDeliveryGroup!=undefined && jsonData.selectedShowDeliveryGroup=='Yes')
			{
				Ext.getCmp('optionmultipane').hide();
				Ext.getCmp('er_user').hide();
				Ext.getCmp('er_poolType_container').show();
			}
		}

		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if (!Ext.isEmpty(timelineRawData))
		{
			if (!Ext.isEmpty(selectedTimeline))
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		if (appConstants.reportType != true)
		{
			comboRawData=jsonData.userCombo;
			appConstants.rawDataForUsers=jsonData.userCombo;
			selectedComboOption=jsonData.selectedUser;
			comboObject=mainForm.findField('er_application');
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
			{
				comboObject.setValue(selectedComboOption);
			}
			else
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		if (Ext.getCmp('er_option').getValue()=='Component')
			Ext.getCmp('select_farm').hide();
		else
			Ext.getCmp('select_farm').show();
 	},

	fillSettingFieldsForActivity:function(jsonData)
	{
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.excludeWeekCombo;
		selectedComboOption=jsonData.excludeWeek;
		comboObject=thinclientuserSettingsForm.findField('er_excwe');
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		selectedComboOption=jsonData.includeReconnects;
		comboObject=thinclientuserSettingsForm.findField('inclReconnect');
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue("Yes");
		}
		if(Ext.getCmp('inclReconnect') != undefined){
			if(Ext.getCmp('er_compType').getValue() == 'Citrix_XcXenApp_server')
				Ext.getCmp('inclReconnect').show();
			else
				Ext.getCmp('inclReconnect').hide();
		}
		if(!Ext.isEmpty(jsonData.majorValue))
			Ext.getCmp('uppermajor').setValue(jsonData.majorValue);
		
		if(!Ext.isEmpty(jsonData.minorValue))
			Ext.getCmp('upperminor').setValue(jsonData.minorValue);
		if(!Ext.isEmpty(jsonData.criticalValue))
			Ext.getCmp('upperCritical').setValue(jsonData.criticalValue);
		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);
		
		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);

		comboRawData = jsonData.geoFilterCombo;
		if(comboRawData!=undefined)
		{
			appConstants.geoFilterCombo = comboRawData;
			var component = Ext.getCmp("er_geoFilter");
			component.getStore().loadRawData(comboRawData);
			selectedComboOption = jsonData.selectedgeoFilter;
			Ext.getCmp("multiSelectLabel_geo").setText(screenLabels["geoFilterLabel"]);
			if (!Ext.isEmpty(selectedComboOption)) 
			{
				component.setValue(selectedComboOption);
			}
			else 
			{
				component.setValue(comboRawData[0].valueField);
			}
			Ext.getCmp('geofilter').show();
			Ext.getCmp('geofilter').geoFilterScreachStr = jsonData.geoFilterScreachStr;
		}
	},

	showConfigDropdown:function(){
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		id:'configMod',
//		cls:'configMode_popup',
		ui:'settingsWindowContainer',
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'380px'}
			},
			{
				xtype:'container',
				html:tpl.apply(),
				cls:'containerHeader',
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'thinclientusersettings',
				parent:this
			}
		],
		renderTo:'thinclientuser'
		});
	},

	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var publicJsonData=null;
		publicJsonData = appConstants.publicjsonDataActivity;
		var value='';
		if(isEnabled)
		{
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}
		else
		{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}
		return value;
	},

	fromGridDetailData:function(data,usr)
	{  
		Ext.getCmp("bckButton").hide();
		Ext.getCmp("bckButton_1").show();
		initLdgMask.show();
		var me = this;
		var urlStr="/final/reporter/ErSlowLogonDetailsReportJson.jsp";
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		Ext.Ajax.request(
		{ 
			url : urlStr,
			params : data+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				var combObj="";
				if(!Ext.isEmpty(jsonData))
				{
					var comboRawData=jsonData.userCombo;
					combObj=Ext.getCmp('er_application');
					combObj.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(usr))
					{
						combObj.setValue(decodeURIComponent(usr));
					}
					else
					{
						combObj.setValue(comboRawData[0].valueField);
					}
				}
				me.submitReport();
			}
		});
		initLdgMask.hide();
	},

	backFun:function()
	{
		initLdgMask.show();
		var me = this;
		var Qstring='';
		this.updateQStringActivity();
		var urlStr="/final/reporter/ErSlowLogonDetailsReportJson.jsp";
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		Qstring+='&'+ appConstants.queryStringActivity,
		Ext.Ajax.request(
		{ 
			url : urlStr,
			params : Qstring+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				var combObj="";
				if(!Ext.isEmpty(jsonData))
				{
					var comboRawData=jsonData.userCombo;
					combObj=Ext.getCmp('er_application');
					combObj.getStore().loadRawData(comboRawData);
					selectedComboOption=jsonData.selectedUser;
					if (!Ext.isEmpty(appConstants.DummyUsr))
					{
						combObj.setValue(appConstants.DummyUsr);
					}
					else
					{
						combObj.setValue(comboRawData[0].valueField);
					}
				}
				me.submitReport();
			}
		});
		initLdgMask.hide();
	}
});
