Ext.define('SnapShot.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'settings', ref:'settings'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'snapshotsettings', ref:'snapshotsettings'},
		{selector:'reportgeneration', ref:'reportgeneration'},
		{selector:'snapshotmainform', ref:'snapshotmainform'},
		{selector:'selectiondetails', ref:'selectiondetails'},
		{selector:'snapshotsubmitteddata', ref:'snapshotsubmitteddata'},
		{selector:'snapshotsettings', ref:'snapshotsettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector:'backGroundPanel', ref:'backGroundPanel'}
	],
	init:function()
	{
		this.control(
		{
			'main':{
				'boxready': this.defaultLoad
			},
			'main newUtilities':{
				'afterrender': this.hideTools
			},
			'snapshotmainform':{
				'afterrender':this.loadMainElements
			},
			'snapshotsettings':{
				'afterrender':this.loadSettingsElements
			},
			'newUtilities > #saveTool > button':
			{
				'click':this.saveFile
			},
			'newUtilities > #mailTool > button':
			{
				'click':this.sendMail
			},
			'newUtilities > #printTool > button':
			{
				'click':this.print
			},
			'snapshotmainform combo[name="analyzeBy"]':
			{
				'select': this.selectReportTypeCombos
			},
			'snapshotmainform combo[name="compType"]':
			{
				'select': this.selectComponents
			},
			'snapshotmainform combo[name="componentSelectBox"]':
			{
				'select': this.selectTestsForComponent
			},
			'snapshotmainform combo[name="testsSelectBox"]':
			{
				'select': this.selectCompTypeForTest
			},
			'snapshotmainform combo[name="zone"]':
			{
				'select': this.selectZoneComponents
			},
			'snapshotmainform combo[name="segment"]':
			{
				'select': this.selectSegmentComponents
			},
			'snapshotmainform combo[name="service"]':
			{
				'select': this.selectServiceComponents
			},
			'snapshotmainform combo[name="subzone"]':
			{
				'select': this.includeOrExcludeSubzone
			},
			'snapshotsettings combo[name="stateSelectBox"]':
			{
				'select': this.includeOrExcludeStateSelect
			},
			'reportgeneration combo[name="reportGeneration"]':
			{
				'select': this.showBackgroundReport
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateSettings
			},
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'timelinesnapshot combo[name="timeLineCombo"]':
			{
				'select': this.enableTimeline
			},
			'snapshotmainform button[id="submit"]':
			{
				'click': this.beforeFormSubmit
			},
			'snapshotmainform button[name="save"]':
			{
				'click': this.addTo
			},
			'reporttypes combo[id="report_Type"]':
			{
				'select': this.showDetailsRadio
			},
			'newUtilities > #favoriteTool > button' : {
						'click' : this.addTo
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.addTo
			},
			'print' : {
				'afterrender':this.printPageRender
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveDataInCSVFormat
			},
			 'snapshotmainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'snapshotsettings button[id="expandSelector"]':
			{
				'click':this.expandMe
			},
			'snapshotsettings button[id="expandSelector2"]':
			{
				'click':this.expandMe2
			},
			'snapshotmainform textfield[id=filter]' : {
				'change' : this.filterStore
			},
			'snapshotsettings trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			}
		});
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('componentsMultiSelect'),appConstants.rawComponentsDataForMulti);
		
    },
	filterStore: function(obj)
	{
   		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
 		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('componentSelectBox'),appConstants.rawDataForComponents);
	},
	goTopanelinsidetoggle:function()
	{
	  var ornt = Ext.getCmp('snapshotreportform');
        ornt.toggleCollapse(true);
		Ext.getCmp("selectionDetails").show();
		if(ornt.collapsed)
        {
            ornt.removeCls('formOuter');
        }
        else
        {
            ornt.addCls('formOuter');
        }
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateSettings())
		{
			this.beforeFormSubmit();
		}
	},
	validateSettings :  function()
	{
		var snapShotSettingsForm = this.getSnapshotsettings().getForm();

		var reportgen = snapShotSettingsForm.findField('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv'))
		{
			var reportNameObj = snapShotSettingsForm.findField('bgReportName');
			var reportName = reportNameObj.getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				return false;
			}
		}
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('snapshotreportform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	beforeFormSubmit: function()
	{
 		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var startdate = Ext.Date.dateFormat(snapShotReportForm.findField('startdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(snapShotReportForm.findField('enddate').getValue(), mgrDateFormat);
		var startHour =snapShotReportForm.findField('startHour');
		var endHour = snapShotReportForm.findField('endHour');
		var startMins =snapShotReportForm.findField('startMins');
		var endMins = snapShotReportForm.findField('endMins');
		var stDateTime = snapShotReportForm.findField('startdate').getValue();
        var enDateTime = snapShotReportForm.findField('enddate').getValue();
		/*var result = checkDateTime(stDateTime, enDateTime);
        if (!result) {
            return;
        }*/
				//
		var sthr = Ext.getCmp("startHour").getValue();
		var endhr = Ext.getCmp("endHour").getValue();
		var stmin = Ext.getCmp("startMins").getValue();
		var enmin = Ext.getCmp("endMins").getValue();
		var flag = true;
		if (startdate == enddate && sthr == endhr && stmin == enmin )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: _invalidSameTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			flag = false;
		}
		else
		{
			var isValidForm = this.validateForm(true);
			if(isValidForm)
			{
				var fromSchedule = appConstants.publicJsonData['hiddenParams']['fromSchedule'];
				if(!Ext.isEmpty(fromSchedule))
				{
					var getButtonObj = Ext.getCmp('submit');
					this.formSubmit(getButtonObj);
				}
				else
				{
					var getButtonObj = Ext.getCmp('submit');
					this.formSubmit(getButtonObj);
				}
			}
		}
		return flag;
	},
	showResult: function(btn)
	{
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			this.formSubmit(getButtonObj);
		}
		else
		{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			var snapShotSettingsForm = this.getSnapshotsettings().getForm();
			snapShotSettingsForm.findField('reportGeneration').setValue('background');
			var reportNameObj = snapShotSettingsForm.findField('bgReportName');
			reportNameObj.show();
			reportNameObj.focus();
			this.beforeFormSubmit();
		}
	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveFile:function(){

		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var s_qryString = appConstants.printPageUrl;
		var s_qryString="../reporter/ErHtmlToSavePdf.jsp?"+s_qryString+"&isPdf=true";
		//
		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
			if ( ReportForVal == 'Zone' )
		{
			var zoneName = snapShotReportForm.findField('zone').getValue();
			var subzoneCombo = snapShotReportForm.findField('subzone');
			if(!Ext.isEmpty(subzoneCombo))
			{
				s_qryString = s_qryString+"&er_dataZone="+subzoneCombo.getValue();
			}
			if(!Ext.isEmpty(zoneName))
			{
				s_qryString = s_qryString+'&er_option='+encodeURIComponent(zoneName);

			}
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = snapShotReportForm.findField('segment').getValue();
			if(!Ext.isEmpty(segmentName))
			{
				s_qryString = s_qryString+'&er_option='+encodeURIComponent(segmentName);
			}
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = snapShotReportForm.findField('service').getValue();
			if(!Ext.isEmpty(serviceName))
			{
				s_qryString = s_qryString+'&er_option='+encodeURIComponent(serviceName);
			}
		}
		//
		if(appConstants.snapShotType!=null && appConstants.snapShotType == "intersnap")
		{
			var testsSelectBoxVal = snapShotReportForm.findField('testsSelectBox').getValue();
			if(!Ext.isEmpty(testsSelectBoxVal))
			{
				s_qryString = s_qryString+'&er_test='+encodeURIComponent(testsSelectBoxVal);
			}
		}
		//
		
		//
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var s_qryString = appConstants.printPageUrl;
		var s_qryString=s_qryString+"&isPdf=true";
		//
		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
			if ( ReportForVal == 'Zone' )
		{
			var zoneName = snapShotReportForm.findField('zone').getValue();
			var subzoneCombo = snapShotReportForm.findField('subzone');
			if(!Ext.isEmpty(subzoneCombo))
			{
				s_qryString = s_qryString+"&er_dataZone="+subzoneCombo.getValue();
			}
			if(!Ext.isEmpty(zoneName))
			{
				s_qryString = s_qryString+'&er_option='+encodeURIComponent(zoneName);

			}
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = snapShotReportForm.findField('segment').getValue();
			if(!Ext.isEmpty(segmentName))
			{
				s_qryString = s_qryString+'&er_option='+encodeURIComponent(segmentName);
			}
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = snapShotReportForm.findField('service').getValue();
			if(!Ext.isEmpty(serviceName))
			{
				s_qryString = s_qryString+'&er_option='+encodeURIComponent(serviceName);
			}
		}
		//
		if(appConstants.snapShotType!=null && appConstants.snapShotType == "intersnap")
		{
			var testsSelectBoxVal = snapShotReportForm.findField('testsSelectBox').getValue();
			if(!Ext.isEmpty(testsSelectBoxVal))
			{
				s_qryString = s_qryString+'&er_test='+encodeURIComponent(testsSelectBoxVal);
			}
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var snapShotSettingsForm = null;
		if(isSettingsEnabled)
			snapShotSettingsForm = this.getSnapshotsettings().getForm();
		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
		var compTypeVal = snapShotReportForm.findField('compType').getValue();
		var er_timeline = snapShotReportForm.findField('timeLineCombo').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var startdate = Ext.Date.dateFormat(snapShotReportForm.findField('startdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(snapShotReportForm.findField('enddate').getValue(), mgrDateFormat);
		var startHour = snapShotReportForm.findField('startHour').getValue();
		var startMins = snapShotReportForm.findField('startMins').getValue();
		var endHour = snapShotReportForm.findField('endHour').getValue();
		var endMins = snapShotReportForm.findField('endMins').getValue();
		bookletquery +='&er_dataFrom='+ReportForVal+'&er_timeline='+encodeURIComponent(er_timeline);
		if ( ReportForVal == 'Zone' )
		{
			var zoneName = snapShotReportForm.findField('zone').getValue();
			var subzoneCombo = snapShotReportForm.findField('subzone');
			if(!Ext.isEmpty(subzoneCombo))
			{
				bookletquery +="&er_dataZone="+subzoneCombo.getValue();
			}
			if(!Ext.isEmpty(zoneName))
			{
				bookletquery +='&er_option='+encodeURIComponent(zoneName);

			}
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = snapShotReportForm.findField('segment').getValue();
			if(!Ext.isEmpty(segmentName))
			{
				bookletquery +='&er_option='+encodeURIComponent(segmentName);
			}
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = snapShotReportForm.findField('service').getValue();
			if(!Ext.isEmpty(serviceName))
			{
				bookletquery +='&er_option='+encodeURIComponent(serviceName);
			}
		}
		if(!Ext.isEmpty(compTypeVal))
		{
			bookletquery +='&er_componentType='+compTypeVal;
		}
		bookletquery +="&er_gtype="+appConstants.snapShotType+"&rtype="+appConstants.snapShotType;
		if(appConstants.snapShotType!=null && appConstants.snapShotType == "intrasnap")
		{
			var componentSelectBoxVal = snapShotReportForm.findField('componentSelectBox').getValue();
			if(!Ext.isEmpty(componentSelectBoxVal))
			{
				bookletquery +='&er_component='+encodeURIComponent(componentSelectBoxVal);
			}
			var testArr = this.getSettingsFieldValue(snapShotSettingsForm,'testsMultiSelect',isSettingsEnabled,'selectedTests');
				if(typeof testArr=='string'){
					var tmpArr = testArr.split(',');
					testArr = tmpArr;
				}
			var testsQStr = '';
			var testsQStrComma = '';
			if(testArr!=null && (testArr!="" && testArr!="null"))
			{
				for ( var i = 0; i < testArr.length; i++ )
				{
					testsQStr += '&er_test='+encodeURIComponent(testArr[i]);
					testsQStrComma += ','+testArr[i];
				}
			}
			if(testsQStrComma!=null && testsQStrComma.indexOf(",")==0)
			{
				testsQStrComma=testsQStrComma.substr(1,testsQStrComma.length);
			}
			bookletquery +=testsQStr;
		}
		else if(appConstants.snapShotType!=null && appConstants.snapShotType == "intersnap")
		{
			var testsSelectBoxVal = snapShotReportForm.findField('testsSelectBox').getValue();
			if(!Ext.isEmpty(testsSelectBoxVal))
			{
				bookletquery +='&er_test='+encodeURIComponent(testsSelectBoxVal);
			}
			var compArr = this.getSettingsFieldValue(snapShotSettingsForm,'componentsMultiSelect',isSettingsEnabled,'selectedComps');
			if(typeof compArr=='string'){
				var tmpArr = compArr.split(',');
				compArr = tmpArr;
			}
			var compQStrComma = '';
			if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					bookletquery += '&er_component='+encodeURIComponent(compArr[i]);
					compQStrComma += ','+compArr[i];
				}
			}
			if(compQStrComma!=null && compQStrComma.indexOf(",")==0)
			{
				compQStrComma=compQStrComma.substr(1,compQStrComma.length);
			}
			bookletquery +="&selectedComponents="+encodeURIComponent(compQStrComma);
		}
		var reportgen = this.getSettingsFieldValue(snapShotSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var descriptorFilter = this.getSettingsFieldValue(snapShotSettingsForm,'descriptorFilter',isSettingsEnabled,'descriptorSearchValue');
		var prior_type = this.getSettingsFieldValue(snapShotSettingsForm,'stateSelectBox',isSettingsEnabled,'prior_type');
		if(!Ext.isEmpty(descriptorFilter))
		{
			bookletquery +="&er_info_search="+encodeURIComponent(descriptorFilter);
		}
		if(!Ext.isEmpty(prior_type))
		{
			bookletquery +="&prior_type="+encodeURIComponent(prior_type);
		}

		bookletquery +='&enddate='+encodeURIComponent(enddate)+'&startdate='+encodeURIComponent(startdate)+'&starthr='+startHour+'&endhr='+endHour+'&startmin='+startMins+'&endmin='+endMins;
		var hiddenQstr = '';
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		for( var hid in hiddenData)
		{
			hiddenQstr +='&'+hid+'='+hiddenData[hid];
		}
		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			bookletquery +=hiddenQstr;
		}
		if ( reportgen!=null && reportgen == 'background' )
		{
			var reportName =this.getSettingsFieldValue(snapShotSettingsForm,'bgReportName',isSettingsEnabled,'bg_reportname');
			reportName=checkFileName(reportName);
			bookletquery +="&forwardto=ErSnapshotJson&bg_reportname="+reportName+"&er_reportgenration=background";
		}
		else
		{
			bookletquery +="&forwardto=ErSnapshot&er_reportgenration=foreground";
		}
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.print();
	},
	saveDataInCSVFormat  : function()
	{
		window.location='../servlet/com.eg.CSVServlet';

	},
	hideTools:function(){
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //cvs
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true //booklet
			);

		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	printPageRender : function() {
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var s_qryString = "../servlet/com.eg.ErSnapshotC?"+appConstants.printPageUrl+"&pdfPrint=yes";
		var printContentDiv = Ext.get('printContentDiv');
		printContentDiv.set( { src :  s_qryString });
	},
	print:function()
	{
		//var windowPrintFile = Ext.widget('print');
		//windowPrintFile.show();
		var s_qryString = "../servlet/com.eg.ErSnapshotC?"+appConstants.printPageUrl+"&pdfPrint=yes";
		//
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		//
		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
			if ( ReportForVal == 'Zone' )
		{
			var zoneName = snapShotReportForm.findField('zone').getValue();
			var subzoneCombo = snapShotReportForm.findField('subzone');
			if(!Ext.isEmpty(subzoneCombo))
			{
				s_qryString = s_qryString+"&er_dataZone="+subzoneCombo.getValue();
			}
			if(!Ext.isEmpty(zoneName))
			{
				s_qryString = s_qryString+'&er_option='+encodeURIComponent(zoneName);

			}
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = snapShotReportForm.findField('segment').getValue();
			if(!Ext.isEmpty(segmentName))
			{
				s_qryString = s_qryString+'&er_option='+encodeURIComponent(segmentName);
			}
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = snapShotReportForm.findField('service').getValue();
			if(!Ext.isEmpty(serviceName))
			{
				s_qryString = s_qryString+'&er_option='+encodeURIComponent(serviceName);
			}
		}
		//
		if(appConstants.snapShotType!=null && appConstants.snapShotType == "intersnap")
		{
			var testsSelectBoxVal = snapShotReportForm.findField('testsSelectBox').getValue();
			if(!Ext.isEmpty(testsSelectBoxVal))
			{
				s_qryString = s_qryString+'&er_test='+encodeURIComponent(testsSelectBoxVal);
			}
		}
		//
        parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	includeOrExcludeStateSelect:function(obj)
	{
		var a =Ext.getCmp("componentSelectBox").getValue();
		if(obj.getValue()=="All")
		{
		if(a=="All")
		{
			Ext.getCmp("stateSelectBox").setValue(appConstants.publicJsonData['stateJSON'][1].valueField);
		}
		}
	},
	includeOrExcludeSubzone: function()
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var getZoneVal = snapShotReportForm.findField('zone').getValue();
		if ( getZoneVal != '-1' )
		{
			var getCompObj = snapShotReportForm.findField('componentSelectBox');
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompObj);
			this.selectZoneComponents();
		}
		else
		{
			var getCompTypeObj = snapShotReportForm.findField('compType');
			var getCompObj = snapShotReportForm.findField('componentSelectBox');
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompObj);
		}
	},
	addTo :  function(btn, e, val)
	{
		var btnID = btn.getId();
		// by karthikeyan
	/* if (Ext.getCmp('timeLineCombo').getValue() == 'Any')
		{
			Ext.MessageBox.show({
			title : 'Snapshot Reports',
			msg : 'Choosen timeline not allowed',
			buttons : Ext.Msg.OK,
			icon: Ext.MessageBox.WARNING
			});
			return;
		} */
//
//By Gowtham
//---Start-------------
if (btnID != null && (btnID == 'scheduleImg' || btnID == 'favImg')) 
	{
		
		if(!(this.validateForm(false)))
		{
			return;
		}

	} else { 
		if(!(this.validateForm(false)))
		{
			return;
		}
	}
		//--End--
		var formButtonId=btnID;
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var snapShotSettingsForm = null;
		if(isSettingsEnabled)
			snapShotSettingsForm = this.getSnapshotsettings().getForm();
		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
		var compTypeVal = snapShotReportForm.findField('compType').getValue();
		var er_timeline = snapShotReportForm.findField('timeLineCombo').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var startdate = Ext.Date.dateFormat(snapShotReportForm.findField('startdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(snapShotReportForm.findField('enddate').getValue(), mgrDateFormat);
		var startHour = snapShotReportForm.findField('startHour').getValue();
		var startMins = snapShotReportForm.findField('startMins').getValue();
		var endHour = snapShotReportForm.findField('endHour').getValue();
		var endMins = snapShotReportForm.findField('endMins').getValue();
		var paramsForCompChange ='&er_dataFrom='+ReportForVal+'&er_timeline='+encodeURIComponent(er_timeline);
		if ( ReportForVal == 'Zone' )
		{
			var zoneName = snapShotReportForm.findField('zone').getValue();
			var subzoneCombo = snapShotReportForm.findField('subzone');
			if(!Ext.isEmpty(subzoneCombo))
			{
				paramsForCompChange = paramsForCompChange+"&er_dataZone="+subzoneCombo.getValue();
			}
			if(!Ext.isEmpty(zoneName))
			{
				paramsForCompChange = paramsForCompChange+'&er_option='+encodeURIComponent(zoneName);

			}
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = snapShotReportForm.findField('segment').getValue();
			if(!Ext.isEmpty(segmentName))
			{
				paramsForCompChange = paramsForCompChange+'&er_option='+encodeURIComponent(segmentName);
			}
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = snapShotReportForm.findField('service').getValue();
			if(!Ext.isEmpty(serviceName))
			{
				paramsForCompChange = paramsForCompChange+'&er_option='+encodeURIComponent(serviceName);
			}
		}
		if(!Ext.isEmpty(compTypeVal))
		{
			paramsForCompChange=paramsForCompChange+'&er_componentType='+compTypeVal;
		}
		paramsForCompChange = paramsForCompChange+"&er_gtype="+appConstants.snapShotType+"&rtype="+appConstants.snapShotType;
		if(appConstants.snapShotType!=null && appConstants.snapShotType == "intrasnap")
		{
			var componentSelectBoxVal = snapShotReportForm.findField('componentSelectBox').getValue();
			if(!Ext.isEmpty(componentSelectBoxVal))
			{
				paramsForCompChange = paramsForCompChange+'&er_component='+encodeURIComponent(componentSelectBoxVal);
			}
var testArr = this.getSettingsFieldValue(snapShotSettingsForm,'testsMultiSelect',isSettingsEnabled,'selectedTests');
				if(typeof testArr=='string'){
					var tmpArr = testArr.split(',');
					testArr = tmpArr;
				}
			var testsQStr = '';
			var testsQStrComma = '';
			if(testArr!=null && (testArr!="" && testArr!="null"))
			{
				for ( var i = 0; i < testArr.length; i++ )
				{
					testsQStr += '&er_test='+encodeURIComponent(testArr[i]);
					testsQStrComma += ','+testArr[i];
				}
			}
			if(testsQStrComma!=null && testsQStrComma.indexOf(",")==0)
			{
				testsQStrComma=testsQStrComma.substr(1,testsQStrComma.length);
			}
			paramsForCompChange = paramsForCompChange+testsQStr;//+'&selectedTests='+encodeURIComponent(testsQStrComma);
		}
		else if(appConstants.snapShotType!=null && appConstants.snapShotType == "intersnap")
		{
			var testsSelectBoxVal = snapShotReportForm.findField('testsSelectBox').getValue();
			if(!Ext.isEmpty(testsSelectBoxVal))
			{
				paramsForCompChange = paramsForCompChange+'&er_test='+encodeURIComponent(testsSelectBoxVal);
			}
			var compArr = this.getSettingsFieldValue(snapShotSettingsForm,'componentsMultiSelect',isSettingsEnabled,'selectedComps');
			if(typeof compArr=='string'){
				var tmpArr = compArr.split(',');
				compArr = tmpArr;
			}
			var compQStr = '';
			var compQStrComma = '';
			if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					compQStr += '&er_component='+encodeURIComponent(compArr[i]);
					compQStrComma += ','+compArr[i];
				}
			}
			if(compQStrComma!=null && compQStrComma.indexOf(",")==0)
			{
				compQStrComma=compQStrComma.substr(1,compQStrComma.length);
			}
			paramsForCompChange = paramsForCompChange+compQStr+"&selectedComponents="+encodeURIComponent(compQStrComma);
		}
		var reportgen = this.getSettingsFieldValue(snapShotSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var descriptorFilter = this.getSettingsFieldValue(snapShotSettingsForm,'descriptorFilter',isSettingsEnabled,'descriptorSearchValue');
		var prior_type = this.getSettingsFieldValue(snapShotSettingsForm,'stateSelectBox',isSettingsEnabled,'prior_type');
		if(!Ext.isEmpty(descriptorFilter))
		{
			paramsForCompChange = paramsForCompChange+"&er_info_search="+encodeURIComponent(descriptorFilter);
		}
		if(!Ext.isEmpty(prior_type))
		{
			paramsForCompChange = paramsForCompChange+"&prior_type="+encodeURIComponent(prior_type);
		}

		paramsForCompChange = paramsForCompChange+'&enddate='+encodeURIComponent(enddate)+'&startdate='+encodeURIComponent(startdate)+'&starthr='+startHour+'&endhr='+endHour+'&startmin='+startMins+'&endmin='+endMins;
		var hiddenQstr = '';
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		var favorite_id = hiddenData["favorite_id"];
		for( var hid in hiddenData)
		{
			hiddenQstr +='&'+hid+'='+hiddenData[hid];
		}
		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			paramsForCompChange = hiddenQstr+paramsForCompChange;
		}
		if ( reportgen!=null && reportgen == 'background' )
		{
			var reportName =this.getSettingsFieldValue(snapShotSettingsForm,'bgReportName',isSettingsEnabled,'bg_reportname');
			reportName=checkFileName(reportName);
			paramsForCompChange = paramsForCompChange+"&forwardto=ErSnapshotJson&bg_reportname="+reportName+"&er_reportgenration=background";
		}
		else
		{
			paramsForCompChange = paramsForCompChange+"&forwardto=ErSnapshot&er_reportgenration=foreground";
		}
	    	var from_schedule = hiddenData["fromScheduleModify"];
        	if (from_schedule != null && from_schedule == "Yes") {
			btnID = 'scheduleImg';
		}
		var target = "";
		var windowClass;
		var frameId;
		if (btnID != null && btnID == 'scheduleImg') {
			windowClass='scheduleWindow';
			frameId='#schWin1';
			target = "/final/reporter/ErSaveSchedule.jsp?option=snap" + paramsForCompChange+"&com.eg.CSRF_NONCE="+csrfToken;
			if (formButtonId=='save')
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


		} else { //if (btnID != null && btnID == 'favImg') {
			windowClass='favouriteWindow';
			frameId='#favWin1';
			target = "../servlet/com.eg.ErFavoriteC?er_view=GRAPH&option=snap&cmd=client" + paramsForCompChange+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken ;//+"&FavoriteId="+favorite_id;;
			if (formButtonId=='save')
			{
				//document.location=url+'&showWindow=no'+'&FavoriteId='+favorite_id;
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


		}
		//var target = url;
		//Ext.widget(windowClass).show();
		//Ext.select(frameId).set({src :target});
	},
	validateForm : function(flag)
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var snapShotSettingsForm =null;
		if(isSettingsEnabled)
			snapShotSettingsForm = this.getSnapshotsettings().getForm();
		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
		if ( ReportForVal == 'Zone' )
		{
			var zoneName = snapShotReportForm.findField('zone').getValue();
			if(zoneName!=null && zoneName=="-1" || zoneName==""   || zoneName=="NotApplicable")
			{
				Ext.MessageBox.show({
						title: 'Snap Shot Report',
						msg: appConstants.noZoneMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = snapShotReportForm.findField('segment').getValue();
			if(segmentName!=null && segmentName=="-1" || segmentName==""  || segmentName=="NotApplicable")
			{
				Ext.MessageBox.show({
						title: 'Snap Shot Report',
						msg: appConstants.noSegmentMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = snapShotReportForm.findField('service').getValue();
			if(serviceName!=null && serviceName=="-1" || serviceName=="" || serviceName=="NotApplicable")
			{
				Ext.MessageBox.show({
						title: 'Snap Shot Report',
						msg: appConstants.noServiceMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
		}
		
		if((appConstants.snapShotType!=null && appConstants.snapShotType == "intrasnap"))
		{
			var compTypeVal = snapShotReportForm.findField('compType').getValue();
		if(compTypeVal!=null && compTypeVal=="-1" || compTypeVal=="" || compTypeVal=="NotApplicable" || compTypeVal=="Please Choose the ComponentType")
			{
				Ext.MessageBox.show({
						title: 'Snap Shot Report',
						msg: appConstants.compTypeAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
			var componentSelectBoxVal = snapShotReportForm.findField('componentSelectBox').getValue();
			if(componentSelectBoxVal!=null && componentSelectBoxVal=="-1" || componentSelectBoxVal=="" || componentSelectBoxVal=="NotApplicable")
			{
				Ext.MessageBox.show({
						title: 'Snap Shot Report',
						msg: appConstants.componentAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
			var testsArr =this.getSettingsFieldValue(snapShotSettingsForm,'testsMultiSelect',isSettingsEnabled,'selectedTests');
			if(typeof testsArr=='string'){
					var tmpArr = testsArr.split(',');
					testsArr = tmpArr;
			}
			if(testsArr!=null && testsArr=="-1" || testsArr=="" || testsArr=="Not Applicable")
			{
				Ext.MessageBox.show({
							title: 'Snap Shot Report',
							msg: appConstants.testAlertMsg,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
				return false;
			}
		}
		else
		{
			var testsSelectBoxVal = snapShotReportForm.findField('testsSelectBox').getValue();
			
			if(testsSelectBoxVal!=null && testsSelectBoxVal=="-1" || testsSelectBoxVal=="" || testsSelectBoxVal=="NotApplicable" || testsSelectBoxVal=="Please choose a test")
			{
				Ext.MessageBox.show({
						title: 'Snap Shot Report',
						msg: appConstants.testAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
			var compTypeVal = snapShotReportForm.findField('compType').getValue();
			if(compTypeVal!=null && compTypeVal=="-1" || compTypeVal=="" || compTypeVal=="NotApplicable" || compTypeVal=="Please Choose the ComponentType")
			{
				Ext.MessageBox.show({
						title: 'Snap Shot Report',
						msg: appConstants.compTypeAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
			var compArr = this.getSettingsFieldValue(snapShotSettingsForm,'componentsMultiSelect',isSettingsEnabled,'selectedComps');
			if(typeof compArr=='string'){
				var tmpArr = compArr.split(',');
				compArr = tmpArr;
			}
			if(compArr!=null && compArr=="-1" || compArr=="" || compArr=="Not Applicable")
			{
				Ext.MessageBox.show({
							title: 'Snap Shot Report',
							msg: appConstants.componentAlertMsg,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
				return false;
			}
		}
		var reportgen = this.getSettingsFieldValue(snapShotSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var stDate = snapShotReportForm.findField('startdate').getValue();
		var enDate = snapShotReportForm.findField('enddate').getValue();
		stDate.setHours(snapShotReportForm.findField('startHour').getValue());
		enDate.setHours(snapShotReportForm.findField('endHour').getValue());
		var startdate = Ext.Date.dateFormat(snapShotReportForm.findField('startdate').getValue(), mgrDateFormat);
		var enddate = Ext.Date.dateFormat(snapShotReportForm.findField('enddate').getValue(), mgrDateFormat);
		var sthr = Ext.getCmp("startHour").getValue();
		var endhr = Ext.getCmp("endHour").getValue();
		var stmin = Ext.getCmp("startMins").getValue();
		var enmin = Ext.getCmp("endMins").getValue();
		var stDateTime = snapShotReportForm.findField('startdate').getValue();
        var enDateTime = snapShotReportForm.findField('enddate').getValue();

		var er_timeline =snapShotReportForm.findField('timeLineCombo').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		if(er_timeline!=null && er_timeline=="Any")
		{
			if ((stDateTime > enDateTime)||((startdate == enddate) && sthr > endhr)||((startdate == enddate && sthr ==endhr)&& stmin>enmin ))
			{
					Ext.MessageBox.show({
					title: 'Alert',
					msg: _invalidDateTime,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
			}
		}
		var getMaxDaysInMonth = appConstants.publicJsonData['hiddenParams']['getMaxDaysInMonth'];
		var maxDaysInMonth = "";
		if(!Ext.isEmpty(getMaxDaysInMonth))
		{
			maxDaysInMonth = getMaxDaysInMonth;
		}
		var er_usertimeline = "";
		var er_usertimelineObj = appConstants.publicJsonData['hiddenParams']['er_usertimeline'];
		if(!Ext.isEmpty(er_usertimelineObj))
		{
			er_usertimeline = er_usertimelineObj;
		}
		if(er_usertimeline!=null && er_usertimeline!="-1")
		{
			if(!isUserTimelineLimitExceeded(er_usertimeline,maxDaysInMonth,stDate,enDate))
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var isSettingsOk = true;
		/*	var bgenabled = "";
		var bgenabledObj = Ext.getCmp("bgenabled");
		if(bgenabledObj!=null && bgenabledObj!="undefined")
		{
			bgenabled = bgenabledObj.getValue();
		}*/
		/*	if(bgenabled!=null && bgenabled.toLowerCase() =="yes")
		{*/
		if ( reportgen!=null && reportgen == 'foreground' )
		{
			if(flag)
			{
				var limitforbg = appConstants.publicJsonData['hiddenParams']['limitforbg'];

				if(!Ext.isEmpty(limitforbg))
				{
					if(!checkTimeLineForBgLimit(limitforbg,maxDaysInMonth,stDate,enDate))
					{
						var snapShotReportPanel = Ext.getCmp("snapShotReportPanel");
						snapShotReportPanel.removeAll();
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else
		{
				var reportNameObj = snapShotSettingsForm.findField('bgReportName');
				var reportName = reportNameObj.getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					reportNameObj.focus();
					return false;
				}
		}
	//	}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
	//		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
	},
	updateQueryString: function(ctrlObjId)
	{
		var isSubmit = false;
		if(ctrlObjId!=null && ctrlObjId=="submit")
		{
			isSubmit = true;
		}
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var snapShotSettingsForm = null;
		if(isSettingsEnabled)
			snapShotSettingsForm = this.getSnapshotsettings().getForm();

		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
		var compTypeVal = snapShotReportForm.findField('compType').getValue();
		var er_timeline = snapShotReportForm.findField('timeLineCombo').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var reportgen = this.getSettingsFieldValue(snapShotSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var startdate = snapShotReportForm.findField('startdate').dataArray;
		var enddate = snapShotReportForm.findField('enddate').dataArray;
		var startHour =snapShotReportForm.findField('startHour').dataArray;
		var startMins =snapShotReportForm.findField('startMins').dataArray;
		var endHour = snapShotReportForm.findField('endHour').dataArray;
		var endMins = snapShotReportForm.findField('endMins').dataArray;
		var paramsForCompChange ='&er_dataFrom='+ReportForVal+'&er_timeline='+er_timeline;
		if ( ReportForVal == 'Zone' )
		{
			var zoneName = snapShotReportForm.findField('zone').getValue();
			var subzoneCombo = snapShotReportForm.findField('subzone');
			if(!Ext.isEmpty(subzoneCombo))
			{
				paramsForCompChange = paramsForCompChange+"&er_dataZone="+subzoneCombo.getValue();
			}
			if(!Ext.isEmpty(zoneName))
			{
				paramsForCompChange = paramsForCompChange;
			}
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = snapShotReportForm.findField('segment').getValue();
			if(!Ext.isEmpty(segmentName))
			{
				paramsForCompChange = paramsForCompChange;
			}
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = snapShotReportForm.findField('service').getValue();
			if(!Ext.isEmpty(serviceName))
			{
				paramsForCompChange = paramsForCompChange;
			}
		}
		if(isSubmit || (ctrlObjId!=null && ctrlObjId=="compType"))
		{
			if(!Ext.isEmpty(compTypeVal))
			{
				paramsForCompChange=paramsForCompChange+'&er_componentType='+compTypeVal;
			}
			if(appConstants.snapShotType!=null && appConstants.snapShotType=="intrasnap")
			{
				var componentSelectBoxVal = snapShotReportForm.findField('componentSelectBox').getValue();
				if(!Ext.isEmpty(componentSelectBoxVal))
				{
					paramsForCompChange = paramsForCompChange+'&er_component='+componentSelectBoxVal;
				}
			}
		}
		paramsForCompChange = paramsForCompChange+"&er_gtype="+appConstants.snapShotType+"&rtype="+appConstants.snapShotType;
		if(isSubmit)
		{
			if(appConstants.snapShotType!=null && appConstants.snapShotType == "intrasnap")
			{
			var testArr =this.getSettingsFieldValue(snapShotSettingsForm,'testsMultiSelect',isSettingsEnabled,'selectedTests');
			if(typeof testArr=='string'){
					var tmpArr = testArr.split(',');
					testArr = tmpArr;
				}
				var testsQStr = '';
				if(testArr!=null && (testArr!="" && testArr!="null"))
				{
					for ( var i = 0; i < testArr.length; i++ )
					{
						testsQStr += '&er_test='+testArr[i];
					}
				}
				paramsForCompChange = paramsForCompChange+testsQStr;
			}
			else if(appConstants.snapShotType!=null && appConstants.snapShotType == "intersnap")
			{
				var testsSelectBoxVal = snapShotReportForm.findField('testsSelectBox').getValue();
				if(!Ext.isEmpty(testsSelectBoxVal))
				{
					paramsForCompChange = paramsForCompChange+'&er_test='+testsSelectBoxVal;
				}
				var compArr =this.getSettingsFieldValue(snapShotSettingsForm,'componentsMultiSelect',isSettingsEnabled,'selectedComps');
				if(typeof compArr=='string'){
					var tmpArr = compArr.split(',');
					compArr = tmpArr;
				}
				var compQStr = '';
				if(compArr!=null && (compArr!="" && compArr!="null"))
				{
					for ( var i = 0; i < compArr.length; i++ )
					{
						compQStr += '&er_component='+compArr[i];
					}
				}
				paramsForCompChange = paramsForCompChange+compQStr;
			}

			var descriptorFilter = this.getSettingsFieldValue(snapShotSettingsForm,'descriptorFilter',isSettingsEnabled,'descriptorSearchValue');;
			if(!Ext.isEmpty(descriptorFilter))
			{
				paramsForCompChange = paramsForCompChange+"&er_info_search="+descriptorFilter;
			}
			var prior_type  = this.getSettingsFieldValue(snapShotSettingsForm,'stateSelectBox',isSettingsEnabled,'prior_type');
			if(!Ext.isEmpty(prior_type))
			{
				paramsForCompChange = paramsForCompChange+"&prior_type="+prior_type;
			}
			paramsForCompChange = paramsForCompChange+'&isSubmit=true&enddate='+enddate+'&startdate='+startdate+'&starthr='+startHour+'&endhr='+endHour+'&startmin='+startMins+'&endmin='+endMins;

			var hiddenQstr = '';
			var hiddenData = appConstants.publicJsonData['hiddenParams'];
			for( var hid in hiddenData)
			{
				hiddenQstr +='&'+hid+'='+hiddenData[hid];
			}
			if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
			{
				paramsForCompChange = hiddenQstr+paramsForCompChange;
			}
			if ( reportgen!=null && reportgen == 'background' )
			{
				appConstants.selectedReportGen = 'background';
				var reportName =this.getSettingsFieldValue(snapShotSettingsForm,'bgReportName',isSettingsEnabled,'bg_reportname');
				reportName=checkFileName(reportName);
				paramsForCompChange = paramsForCompChange+"&forwardto=ErSnapshotJson&er_stdate="+startdate+"&er_enddate="+enddate+"&bg_reportname="+reportName+"&er_reportgenration=background";
				appConstants.urlForSubmit = "../servlet/com.eg.ErStartBackGroundReportC";
			}
			else if ( reportgen!=null && reportgen == 'background-csv' )
			{
				appConstants.selectedReportGen = 'background';
				var reportName =this.getSettingsFieldValue(snapShotSettingsForm,'bgReportName',isSettingsEnabled,'bg_reportname');
				reportName=checkFileName(reportName);
				paramsForCompChange = paramsForCompChange+"&forwardto=ErSnapshotJson&er_stdate="+startdate+"&er_enddate="+enddate+"&bg_reportname="+reportName+"&er_reportgenration=background";
				appConstants.urlForSubmit = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
			}
			else
			{
				paramsForCompChange = paramsForCompChange+"&responseType=json&forwardto=ErSnapshot&option=snap&er_reportgenration=foreground";
				appConstants.selectedReportGen = 'foreground';
				appConstants.urlForSubmit = "../servlet/com.eg.ErSnapshotC";
			}
		}
		else
		{
			paramsForCompChange = paramsForCompChange+"&userID="+appConstants.userIDVal;
		}
		paramsForCompChange+="&er_RmDispName="+appConstants.er_RmDispName;

		appConstants.queryString = paramsForCompChange;
	},
	loadSnapShotReportData : function(jsonData)
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();

		var snapShotReportPanel = Ext.getCmp("snapShotReportPanel");
		snapShotReportPanel.removeAll();
		var tableTitle='';
		if(appConstants.selectedReportGen!=null &&( appConstants.selectedReportGen == "background" || appConstants.selectedReportGen == "background-csv"))
		{
			loadMask.hide();
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("csvTool").setDisabled(false);

			var bgGroundMsg = jsonData['responseJson']['bgGroundMsg'];
			var status = jsonData['responseJson']['status'];
			var langSupportString = jsonData['responseJson']['langSupportString'];
			var bgReportUrl = jsonData['responseJson']['bgReportUrl'];
			var bgreportlinkMsg = jsonData['responseJson']['bgreportlinkMsg'];

			var htmlStr = "";
			var statusCssClass='iconSuccess';
			if((status != null && status == "duplicate") || (bgGroundMsg!=null && bgGroundMsg == "User background report generationlimit is finished"))
			{
				htmlStr += '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bgreportlinkMsg + '</a></div></td></tr></table></td></tr></table>';
			}
			else
			{
				htmlStr += '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bgreportlinkMsg + '</a></div></td></tr></table></td></tr></table>';
			}

			Ext.getCmp("backGroundPanel").update(htmlStr);
			Ext.getCmp("backGroundPanel").show();
			this.getNomeasurepanel().hide();
			Ext.getCmp('panelinsidetoggle').setDisabled(false);
		}
		else
		{
			var printPageUrlQStr = jsonData.pageParams['printParamQString'];
			appConstants.printPageUrl = printPageUrlQStr;
			var dataAvailable = jsonData.pageParams['dataAvailable'];
			if(dataAvailable!=null && dataAvailable=="true")
			{
				loadMask.hide();
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("csvTool").setDisabled(false);
				var snapShotTableStr = jsonData['snapShotTableStr'];
				var reportTableArr  = jsonData.snapShotDataViewData;
				console.log(reportTableArr)
				if(!Ext.isEmpty(reportTableArr))
				{
					var datStore = new Ext.data.Store({
								fields:[{name : 'tableTitle', type :'string'},{ name : 'measureTable',type : 'array'}],
								//data:reportTableArr,
								// autoLoad: true,
								 proxy: {
									 type: 'ajax',
									 url: '/final/servlet/com.eg.ErSnapshotC?option=snap&fromPagination=true',
									 reader: {
										 type :'json',
										 root: 'result',
										 totalProperty: 'totalCount'
									 }
								 },
								pageSize : 10
								});

					datStore.getProxy().data = reportTableArr;
					datStore.load();
					var addSubmittedReports = Ext.widget('panel',
					{
						bodyPadding:'0',
						//layout:'fit',
						//ui:'newGridPanel',
						frame:false,
						titleAlign:'left',
						dockedItems: [{
							dock: 'bottom',
							xtype : 'pagingtoolbar',
							cls:'pagingtoolbar',
							dock: 'bottom',
							store: datStore,
							displayInfo: false
						}],
						items:[
							{
							xtype:'dataview',
							autoScroll : true,
							height : (Ext.getBody().getViewSize().height-150),
							store: datStore,
							padding:10,
							tpl:new Ext.XTemplate(
						'<tpl for=".">',
						'<div >',
						'<table width="100%">',
						'<tr>',
						'<td>',
						'<div style="padding:5px 0px 10px 0px;margin-bottom:-1px" class="newFont_bold14">{tableTitle}',
						'</div>',
						'<tpl if="xindex===1">',
						'<div class="newTable" style="margin-bottom:10px">',
                        '<tpl else>',
						'<div class="newTable" style="margin-bottom:10px">',
                        '</tpl>',
						'<table cellspacing="0" cellpadding="0" border="0" >',
							'<thead>',
								'<tr>',
									'<th width="3%" style="line-height:0px">',
										'<div style="overflow:visible">&nbsp;</div>',
									'</th>',
									'<th width="27%">',
										'<div style="overflow:visible">'+jsonData.screenLabels["reporter.common.Measure"]+'</div>',
									'</th>',
									'<th width="10%">',
										'<div style="overflow:visible;text-align: center">'+jsonData.screenLabels["reporter.common.Min"]+'</div>',
									'</th>',
									'<th width="10%">',
										'<div style="overflow:visible;text-align: center">'+jsonData.screenLabels["reporter.common.Max"]+'</div>',
									'</th>',
									'<th width="10%">',
										'<div style="overflow:visible;text-align: center">'+jsonData.screenLabels["reporter.common.Avg"]+'</div>',
									'</th>',
									'<th width="14%">',
										'<div style="overflow:visible;text-align: center">'+jsonData.screenLabels["reporter.common.Total Measures"]+'</div>',
									'</th>',
									'<th width="7%">',
										'<div style="overflow:visible;text-align: center">'+jsonData.screenLabels["GOOD"]+'</div>',
									'</th>',
									'<th width="9%">',
										'<div style="overflow:visible;text-align: center">'+jsonData.screenLabels["UNKNOWN"]+'</div>',
									'</th>',
									'<th width="6%">',
										'<div style="overflow:visible;text-align: center">'+jsonData.screenLabels["MEDIUM"]+'</div>',
									'</th>',
									'<th width="6%">',
										'<div style="overflow:visible;text-align: center">'+jsonData.screenLabels["LOW"]+'</div>',
									'</th>',
									'<th width="8%">',
										'<div style="overflow:visible;text-align: center">'+jsonData.screenLabels["HIGH"]+'</div>',
									'</th>',
									'<th width="80px" style="border-right:0px;width:80px !important">',
										'<div style="overflow:visible">&nbsp;</div>',
									'</th>',

								'</tr>',
							'</thead>',
						'<tbody>',
						'<tpl for="measureTable">',
							'<tr>',
								'<td style="width:20px;line-height:0px">',
									'<div style="float:left;postion:relative;"><div style="float:left;postion:relative;"><div  class="{cssClass}"></div></div></div>',
								'</td>',
								'<td style="width:250px">',
									'<div style="float:left;postion:relative;"><div style="float:left">{Measure}</div></div>',
								'</td>',
								'<td style="width:250px">',
									'<div style="text-align: center">{col0}</div>',
								'</td>',
								'<td>',
									'<div style="text-align: center">{col1}</div>',
								'</td>',
								'<td>',
									'<div style="text-align: center">{col2}</div>',
								'</td>',
								'<td>',
									'<div style="text-align: center">{col3}</div>',
								'</td>',
								'<td>',
									'<div style="text-align: center">{col4}</div>',
								'</td>',
								'<td >',
									'<div style="text-align: center">{col8}</div>',
								'</td>',
								'<td>',
									'<div style="text-align: center">{col6}</div>',
								'</td>',
								'<td>',
									'<div style="text-align: center">{col7}</div>',
								'</td>',
								'<td>',
									'<div style="text-align: center">{col5}</div>',
								'</td>',
								'<td style="width:80px !important;line-height:0px">',
									'<tpl if="ddLink != \'NA\'">',

										'<div style="text-align:center;display:inline-flex"><div class="iconLineChart" onClick=\'javascript:loadUrlInDrillDown("{graphLink}");\' style="float:left;margin:0px 5px 0px 5px;cursor:pointer" data-qtip="Graph" data-qclass="yellowTip"></div><div class="iconDiagnosis" onClick=\'javascript:ddWindow("{ddLink}");\'  style="float:left;margin:0px 5px 0px 5px;cursor:pointer" data-qtip="Diagnosis" data-qclass="yellowTip"></div><div class="iconDb" onClick=\'javascript:loadPopup("{dataLink}");\' style="float:left;margin:0px 5px 0px 5px;cursor:pointer" data-qtip="Data" data-qclass="yellowTip"></div></div>',
									'</tpl>',
									'<tpl else if="ddLink == \'NA\'">',
										'<div style="text-align:center;display:inline-flex"><div class="iconLineChart" onClick=\'javascript:loadUrlInDrillDown("{graphLink}");\' style="float:left;margin:0px 5px 0px 5px;cursor:pointer" data-qtip="Graph" data-qclass="yellowTip"></div><div style="float:left;margin:0px 5px 0px 5px;cursor:pointer;width:16px;vertical-align:middle;line-height:1.5em">-</div><div class="iconDb" onClick=\'javascript:loadPopup("{dataLink}");\' style="float:left;margin:0px 5px 0px 5px;cursor:pointer" data-qtip="Data" data-qclass="yellowTip"></div></div>',

									'</tpl>',
								'</td>',

							'</tr>',
						'</tpl>',
						'</tbody>',
						'</table>',
						'</div>',
						'</div></td></tr></table></div>',
						'</tpl>'



								),
							itemSelector: 'div.x-table'
							}]
					 });
							//	snapShotReportPanel.suspendLayout = true;
								snapShotReportPanel.add(addSubmittedReports);
								snapShotReportPanel.suspendLayout = false;
							//	loadMask.hide();
							snapShotReportPanel.show();
					snapShotReportPanel.doLayout();
					datStore=null;
					delete datStore;
					reportTableArr=null;
					delete reportTableArr;
					this.getNomeasurepanel().hide();
					Ext.getCmp('panelinsidetoggle').setDisabled(false);
				}
				else
				{
					snapShotReportPanel.hide();
					this.getNomeasurepanel().show();
					Ext.getCmp("backGroundPanel").hide();
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
				}
			}
			else
			{
				loadMask.hide();
				snapShotReportPanel.hide();
				this.getNomeasurepanel().show();
				Ext.getCmp("backGroundPanel").hide();
				Ext.getCmp('panelinsidetoggle').setDisabled(true);
			}
		}
		jsonData=null;
		delete jsonData;
	},
	formSubmit: function(obj)
	{
		var snapShotReportPanel = Ext.getCmp("snapShotReportPanel");
		var snapShotReportForm=this.getSnapshotmainform().getForm();
		var ctrlObjID="";
		if(obj!=null && obj!="undefined")
		{
			ctrlObjID = obj.getId();
		}
		if(ctrlObjID != null && ctrlObjID=="submit")
		{
			this.updateQueryString(ctrlObjID);
 			loadMask.show();
			Ext.Ajax.request({
				url : appConstants.urlForSubmit,
				params: appConstants.queryString,
				scope : this,
  				method : 'POST',
				success: function(response)
				{
					var resultJson = response.responseText;
					var jsonData=Ext.decode(resultJson);
					this.loadSnapShotReportData(jsonData);
				},
				failure : function(response)
				{
					loadMask.hide();
					snapShotReportPanel.hide();
 					this.getNomeasurepanel().show();
					Ext.getCmp("backGroundPanel").hide();
 				}
			});
		}
		else
		{
			this.updateQueryString(ctrlObjID);
			var snapShotSettingsForm = null;
			if(!isSettingsEnabled)
			{
				this.showConfigDropdown();

			}
			 snapShotSettingsForm = this.getSnapshotsettings().getForm();
			Ext.Ajax.request({
				url : '/final/reporter/ErSnapshotJson.jsp',
				params: appConstants.queryString+"&snapShotUIAction=defaultLoad",
				scope:this,
 				success: function(response)
				{
					var jsonText = response.responseText;
 					var jsonData=Ext.decode(jsonText);

					if(ctrlObjID!=null && ctrlObjID!= 'timeLineCombo')
					{

						var getReportForComboVal = snapShotReportForm.findField('analyzeBy').getValue();
						var compTypeCombo = snapShotReportForm.findField('compType');
						var compTypeComboRawData = jsonData['comptypecombo'];
						if ( getReportForComboVal == 'Zone' )
						{
							var zoneCombo = snapShotReportForm.findField('zone');
							var zoneComboRawData = jsonData['infraTypeJSON'];
							var sub_zone = jsonData['includeZoneOptions'];
							var incZoneLbl=jsonData.screenLabels['reporter.comparison.Include SubZones'];
							var selectedReportLbl=jsonData.screenLabels['selectedReportLbl'];
							var subzoneCombo = snapShotReportForm.findField('subzone');
							if(!Ext.isEmpty(subzoneCombo))
							{
								subzoneCombo.setFieldLabel(incZoneLbl);
								subzoneCombo.setValue(sub_zone[0].valueField);
							}
							else
							{
								subzoneCombo.setValue(sub_zone[0].valueField);
							}
							if ( !Ext.isEmpty(zoneComboRawData) )
							{
								zoneCombo.setFieldLabel(selectedReportLbl);
								zoneCombo.getStore().clearFilter(true); 
								zoneCombo.getStore().loadRawData(zoneComboRawData);
								if(!Ext.isEmpty(jsonData.pageParams.selectedInfraTypeOption) && jsonData.pageParams.selectedInfraTypeOption!="-1")
								{
									zoneCombo.setValue("-1");
								}
								else
								{
									zoneCombo.setValue(zoneComboRawData[0].valueField);
								}
							}
						}
						else if ( getReportForComboVal == 'Segment' )
						{
							var selectedReportLbl=jsonData.screenLabels['selectedReportLbl'];
							var segmentCombo = snapShotReportForm.findField('segment');
							var segmentComboRawData = jsonData['infraTypeJSON'];
							if ( !Ext.isEmpty(segmentComboRawData) )
							{
								segmentCombo.setFieldLabel(selectedReportLbl);
								segmentCombo.getStore().clearFilter(true);
								segmentCombo.getStore().loadRawData(segmentComboRawData);
								if(!Ext.isEmpty(jsonData.pageParams.selectedInfraTypeOption) && jsonData.pageParams.selectedInfraTypeOption!="-1")
								{
									segmentCombo.setValue("-1");
									this.selectSegmentComponents();
								}
								else
								{
									segmentCombo.setValue(segmentComboRawData[0].valueField);
								}
							}
						}
						else if ( getReportForComboVal == 'Service' )
						{
							var selectedReportLbl=jsonData.screenLabels['selectedReportLbl'];
							var serviceCombo = snapShotReportForm.findField('service');
							var serviceComboRawData = jsonData['infraTypeJSON'];
							if ( !Ext.isEmpty(serviceComboRawData) )
							{
								serviceCombo.setFieldLabel(selectedReportLbl);
								serviceCombo.getStore().clearFilter(true);
								serviceCombo.getStore().loadRawData(serviceComboRawData);
								serviceCombo.setValue(jsonData.pageParams.selectedInfraTypeOption);

								if(!Ext.isEmpty(jsonData.pageParams.selectedInfraTypeOption) && jsonData.pageParams.selectedInfraTypeOption!="-1")
								{
									serviceCombo.setValue("-1");
								}
								else
								{
									serviceCombo.setValue(serviceComboRawData[0].valueField);
								}
							}
						}

						var compTypeCombo = snapShotReportForm.findField('compType');
						var compTypeComboRawData = jsonData['compTypeJSON'];
						compTypeCombo.getStore().removeAll();
						compTypeCombo.getStore().clearFilter(true);
						compTypeCombo.getStore().loadRawData(compTypeComboRawData);

						if(Ext.isEmpty(jsonData.pageParams.selectedCompType) && jsonData.pageParams.selectedCompType!="-1")
						{
							compTypeCombo.setValue(jsonData.pageParams.selectedCompType);
						}
						else
						{
							compTypeCombo.setValue(compTypeComboRawData[0].valueField);
						}
						var componentSelectBoxObj = snapShotReportForm.findField('componentSelectBox');

						if(appConstants.snapShotType!=null && appConstants.snapShotType=="intrasnap")
						{
							var componentSelectBoxRawData = jsonData['componentsArray'];
							componentSelectBoxObj.getStore().removeAll();
							componentSelectBoxObj.getStore().clearFilter(true);
							componentSelectBoxObj.getStore().loadRawData(componentSelectBoxRawData);
							appConstants.rawDataForComponents=componentSelectBoxRawData;

							var selectedComponent = jsonData.pageParams['selectedComponent'];
							if(Ext.isEmpty(jsonData.pageParams.selectedComponent) && jsonData.pageParams.selectedComponent!="-1")
							{
								componentSelectBoxObj.setValue(selectedComponent);
							}
							else
							{
								componentSelectBoxObj.setValue(componentSelectBoxRawData[0].valueField);
							}
							var getTestsRawData = jsonData['testsArray'];
							var testsMultiSelectObj = snapShotSettingsForm.findField('testsMultiSelect');
							testsMultiSelectObj.getStore().removeAll();
							testsMultiSelectObj.getStore().clearFilter(true);
							testsMultiSelectObj.getStore().loadRawData(getTestsRawData);

							var selectedTests = jsonData.pageParams['selectedTests'];
							if(selectedTests!=null && (selectedTests!="" && selectedTests!="undefined"))
							{
								testsMultiSelectObj.setValue(selectedTests);
							}
						}
						else if(appConstants.snapShotType!=null && appConstants.snapShotType=="intersnap")
						{
							var testsSelectBoxObj = snapShotReportForm.findField('testsSelectBox');
							var testsSelectBoxRawData = jsonData['testsArray'];
							testsSelectBoxObj.getStore().removeAll();
							testsSelectBoxObj.getStore().loadRawData(testsSelectBoxRawData);

							var selectedTest = jsonData.pageParams['selectedTest'];
							if(selectedTest!=null && (selectedTest!="" && selectedTest!="undefined"))
							{
								testsSelectBoxObj.setValue(selectedTest);
							}
							var getComponentsRawData = jsonData['componentsArray'];
							var componentsMultiSelectObj = snapShotSettingsForm.findField('componentsMultiSelect');
							componentsMultiSelectObj.getStore().removeAll();
							componentsMultiSelectObj.getStore().loadRawData(getComponentsRawData);
							appConstants.rawComponentsDataForMulti=getComponentsRawData;

							var selectedComps = jsonData.pageParams['selectedComps'];
							if(selectedComps!=null && (selectedComps!="" && selectedComps!="undefined"))
							{
								componentSelectBoxObj.setValue(selectedComps);
							}
						}
					}
					var startdateObj = snapShotReportForm.findField('startdate');
					var enddateObj = snapShotReportForm.findField('enddate');
					var startHourObj = snapShotReportForm.findField('startHour');
					var startMinsObj = snapShotReportForm.findField('startMins');
					var endHourObj = snapShotReportForm.findField('endHour');
					var endMinsObj = snapShotReportForm.findField('endMins');

					var stDate = jsonData.pageParams['selectedStartDate'];
					var endDate = jsonData.pageParams['selectedEndDate'];
					var startHr = jsonData.pageParams['selectedFromHr'];
					var startMin = jsonData.pageParams['selectedFromMinutes'];
					var endHr = jsonData.pageParams['selectedToHr'];
					var endMin = jsonData.pageParams['selectedToMinutes'];

					startdateObj.setValue(jsonData.pageParams['startDateForDisplay']);
					enddateObj.setValue(jsonData.pageParams['endDateForDisplay']);
					startHourObj.setValue(jsonData.pageParams['startHourForDisplay']);
					startMinsObj.setValue(jsonData.pageParams['startMinForDisplay']);
					endHourObj.setValue(jsonData.pageParams['endHourForDisplay']);
					endMinsObj.setValue(jsonData.pageParams['endMinForDisplay']);

					if(ctrlObjID!=null && ctrlObjID== 'timeLineCombo')
					{
						var reportgenObj = snapShotSettingsForm.findField('reportGeneration');

						var reportgen = this.getSettingsFieldValue(snapShotSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');

						if(reportgen!=null && reportgen=="foreground")
						{
							var limitforbg = appConstants.publicJsonData['hiddenParams']['limitforbg'];

							if(!Ext.isEmpty(limitforbg))
							{

								var getMaxDaysInMonth = appConstants.publicJsonData['hiddenParams']['getMaxDaysInMonth'];

								var maxDaysInMonth = "0";
								if(!Ext.isEmpty(getMaxDaysInMonth))
								{
									maxDaysInMonth = getMaxDaysInMonth;
								}
								var startdate = snapShotSettingsForm.findField('startdate').getValue();
								var enddate = snapShotSettingsForm.findField('enddate').getValue();
								startdate.setHours(startHr);
								startdate.setMinutes(startMin);
								enddate.setHours(endHr);
								enddate.setMinutes(endMin);
								if(!checkTimeLineForBgLimit(limitforbg,maxDaysInMonth,startdate,enddate))
								{
									var reportNameObj = snapShotSettingsForm.findField('bgReportName');
									reportgenObj.setValue("background");
									reportNameObj.show();
								}
								else
								{
									var reportNameObj = snapShotSettingsForm.findField('bgReportName');
									reportgenObj.setValue("foreground");
									reportNameObj.hide();
								}
							}
						}
					}
				}
			});
		}
	},
	loadMainElements:function()
	{
		this.getSnapshotmainform().loadFields();
		if(appConstants.snapShotType=="intersnap" && appConstants.isForceSubmit!=='null')
		{
			this.selectTestsForComponent(appConstants.publicJsonData.pageParams.selectedComps,true);
		}
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		var from_schedule = hiddenData["fromScheduleModify"];
		var fromFavoriteModify = hiddenData["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes"))
		{
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}
		else
		{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
	},
	loadSettingsElements:function(){
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		var favorite_id = hiddenData["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}

		this.getSnapshotsettings().loadSettingsData();
		var thisController= this;
		Ext.get('closeSettings').on('click',function(){
	 	thisController.validateSettings();
		});
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:564,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'353px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'2px'}
				},
				{
					xtype:'snapshotsettings',
					parent:this
				}
			],
			renderTo:'snapshotdata-body'
			});

	},
	defaultLoad: function()
	{
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
		{
			if(appConstants.er_RmDispName.indexOf('Component') > -1)
			{
			appConstants.er_RmDispName = 'Snapshot Reports - Component';
			}
				else if(appConstants.er_RmDispName.indexOf('Test') > -1)
			{
			appConstants.er_RmDispName = 'Snapshot Reports - Test';
			}

			this.getMain().setTitle(appConstants.er_RmDispName);
		}
		else
		{
			appConstants.er_RmDispName=appConstants.publicJsonData['screenLabels']['pageTitle'];
			this.getMain().setTitle(appConstants.er_RmDispName);
		}

		//this.getSnapshotmainform().loadFields();
		//this.getSnapshotsettings().loadSettingsData();

		var thisController = this;

		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{

            // by karthikeyan
		Ext.getCmp('panelinsidetoggle').setDisabled(false);

		var snapShotReportForm = this.getSnapshotmainform().getForm();
 		var timelineComboVal = snapShotReportForm.findField('timeLineCombo').getValue();
		var startdateObj = snapShotReportForm.findField('startdate');
		var enddateObj = snapShotReportForm.findField('enddate');
		var startHourObj = snapShotReportForm.findField('startHour');
		var endHourObj = snapShotReportForm.findField('endHour');
		var startMinObj = snapShotReportForm.findField('startMins');
		var endMinObj = snapShotReportForm.findField('endMins');

		   if (timelineComboVal == 'Any') {
					enddateObj.setDisabled(false);
					endHourObj.setDisabled(false);
					startHourObj.setDisabled(false);
					startdateObj.setDisabled(false);
					startMinObj.setDisabled(false);
					endMinObj.setDisabled(false);
			}
			//
			//this.loadSnapShotReportData(appConstants.publicJsonData);
			this.beforeFormSubmit();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.beforeFormSubmit();
			}
		}


		if(!hideBackButton){
			Ext.getCmp('snapshotreportform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}

	},
	enableTimeline: function()
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
 		var timelineComboVal = snapShotReportForm.findField('timeLineCombo').getValue();
		var startdateObj = snapShotReportForm.findField('startdate');
		var enddateObj = snapShotReportForm.findField('enddate');
		var startHourObj = snapShotReportForm.findField('startHour');
		var endHourObj = snapShotReportForm.findField('endHour');
		var startMinObj = snapShotReportForm.findField('startMins');
		var endMinObj = snapShotReportForm.findField('endMins');
		if (timelineComboVal == 'Any') {
			enddateObj.setDisabled(false);
			endHourObj.setDisabled(false);
			startHourObj.setDisabled(false);
			startdateObj.setDisabled(false);
			startMinObj.setDisabled(false);
			endMinObj.setDisabled(false);
		} else {
			enddateObj.setDisabled(true);
			endHourObj.setDisabled(true);
			startHourObj.setDisabled(true);
			startdateObj.setDisabled(true);
			startMinObj.setDisabled(true);
			endMinObj.setDisabled(true);
			var timeline = timelineComboVal;
			var strtdt =  startdateObj.getValue();
			var enddt = enddateObj.getValue();
			var strthour = startHourObj.getValue();
			var endhr = endHourObj.getValue();
			strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
			// strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			//enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
			var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";
			var param = "F=getTime&C=id" + no_params;
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params: param,
				scope: this,
				method: 'POST',
				success: function (response) {
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					if (!Ext.isEmpty(jsonData)) {
						var timedata = jsonData.timeline;
						startdateObj.setValue(timedata[6]);
						startdateObj.dataArray = timedata[0];
						enddateObj.setValue(timedata[7]);
						enddateObj.dataArray = timedata[1];
						startHourObj.setValue(timedata[8]);
						startHourObj.dataArray = timedata[2];
						endHourObj.setValue(timedata[9]);
						endHourObj.dataArray = timedata[3];
						startMinObj.setValue(timedata[10])
						startMinObj.dataArray=timedata[4];
						endMinObj.setValue(timedata[11]);
						endMinObj.dataArray=timedata[5];
						/*stmin = timedata[10];
						enmin = timedata[11];
						mgr_stmin = timedata[4];
						mgr_enmin = timedata[5];*/
					}
				}
			});
		}
	},
	showDetailsRadio: function()
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var reportType = snapShotReportForm.findField("report_Type").getValue();
		var showdetailsCombo = snapShotReportForm.findField('showdetailsCombo');
		var chartOptionsCombo = snapShotReportForm.findField('chartOptionsCombo');
		var graphMode = snapShotReportForm.findField('graphMode');
		var graphModeLbl = snapShotReportForm.findField('graphModeLbl');
		if ( reportType == "data" )
		{
			showdetailsCombo.show();
			chartOptionsCombo.hide();
			graphMode.hide();
			graphModeLbl.hide();
		}
		else
		{
			showdetailsCombo.hide();
			chartOptionsCombo.show();
			graphMode.show();
			graphModeLbl.show();
		}
		this.formSubmit(showdetailsCombo);
	},
	showBackgroundReport: function(combo)
	{
		var snapShotSettingsForm = this.getSnapshotsettings().getForm();
		var val = combo.getValue();
		var reportNameObj = snapShotSettingsForm.findField('bgReportName');
		if ( val == 'background' )
		{
			reportNameObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if ( val == 'background-csv' )
		{
			reportNameObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			reportNameObj.hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	selectCompComponents: function()
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var getCompTypeObj = snapShotReportForm.findField('compType');
		this.selectComponents(getCompTypeObj);
	},
	selectZoneComponents: function()
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var getZoneComboObj = snapShotReportForm.findField('zone');
		if ( getZoneComboObj.getValue() != '-1' )
		{
			this.selectComponents(getZoneComboObj);
		}
		else
		{
			var getCompTypeObj = snapShotReportForm.findField('compType');
			var getCompObj = snapShotReportForm.findField('componentSelectBox');
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompObj);
		}
	},
	selectServiceComponents: function()
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var getServiceComboObj = snapShotReportForm.findField('service');
		if ( getServiceComboObj.getValue() != '-1' )
		{
			this.selectComponents(getServiceComboObj);
		}
		else
		{
			var getCompTypeObj = snapShotReportForm.findField('compType');
			var getCompObj = snapShotReportForm.findField('componentSelectBox');
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompObj);
		}
	},
	selectSegmentComponents: function()
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var getSegmentComboObj = snapShotReportForm.findField('segment');
		if ( getSegmentComboObj.getValue() != '-1' )
		{
			this.selectComponents(getSegmentComboObj);
		}
		else
		{
			var getCompTypeObj = snapShotReportForm.findField('compType');
			var getCompObj = snapShotReportForm.findField('componentSelectBox');
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompObj);
		}
	},
	selectReportTypeCombos: function()
	{
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var analyzeByObj=snapShotReportForm.findField('analyzeBy');
		var getComboVal = analyzeByObj.getValue();
		var compTypeCombo = snapShotReportForm.findField('compType');
		var zoneCombo = snapShotReportForm.findField('zone');
		var subzoneRadio = snapShotReportForm.findField('subzone');
		var segmentCombo = snapShotReportForm.findField('segment');
		var serviceCombo = snapShotReportForm.findField('service');


		if ( getComboVal == 'Component' )
		{
			zoneCombo.hide();
			subzoneRadio.hide();
			segmentCombo.hide();
			serviceCombo.hide();

		}
		else if ( getComboVal == 'Zone' )
		{
			zoneCombo.show();
			subzoneRadio.show();
			segmentCombo.hide();
			serviceCombo.hide();
		}
		else if ( getComboVal == 'Segment' )
		{
			zoneCombo.hide();
			subzoneRadio.hide();
			segmentCombo.show();
			serviceCombo.hide();
		}
		else if ( getComboVal == 'Service' )
		{
			zoneCombo.hide();
			subzoneRadio.hide();
			segmentCombo.hide();
			serviceCombo.show();
		}

		this.formSubmit(analyzeByObj);
	},
	selectComponents: function(combo)
	{
		var comboId = combo.getId();
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var snapShotSettingsForm = this.getSnapshotsettings().getForm();
		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
		var paramsForCompChange = '';

		if ( comboId == 'compType' )
		{
			var compTypeVal = combo.getValue();
			paramsForCompChange = 'er_dataFrom='+ReportForVal+'&selectAllElements=true&er_componentType='+compTypeVal;

			if(appConstants.snapShotType!=null && appConstants.snapShotType=="intersnap")
			{
				var testsSelectBox = snapShotReportForm.findField("testsSelectBox");
				if(!Ext.isEmpty(testsSelectBox))
				{
					paramsForCompChange = paramsForCompChange+"&er_test="+testsSelectBox.getValue();
				}
			}

			if ( ReportForVal == 'Zone' )
			{
				var zoneName = snapShotReportForm.findField('zone').getValue();
				var isIncludedSubZone = snapShotReportForm.findField('subzone').getValue();
				paramsForCompChange = paramsForCompChange+'&er_option='+zoneName+'&er_dataZone='+isIncludedSubZone;
			}
			else if ( ReportForVal == 'Segment' )
			{
				var segmentName = snapShotReportForm.findField('segment').getValue();
				paramsForCompChange = paramsForCompChange+'&er_option='+segmentName;
			}
			else if ( ReportForVal == 'Service' )
			{
				var serviceName = snapShotReportForm.findField('service').getValue();
				paramsForCompChange = paramsForCompChange+'&er_option='+serviceName;
			}
			else
			{
				paramsForCompChange=paramsForCompChange+'&er_option=Component';
			}
		}
		else if ( comboId == 'zone' )
		{
			var isIncludedSubZone = snapShotReportForm.findField('subzone').getValue();
			var zoneName = snapShotReportForm.findField('zone').getValue();
			paramsForCompChange = 'er_dataFrom='+ReportForVal+'&er_option='+zoneName+'&er_dataZone='+isIncludedSubZone;
		}
		else if ( comboId == 'segment' )
		{
			var segmentName = snapShotReportForm.findField('segment').getValue();
			paramsForCompChange = 'er_dataFrom='+ReportForVal+'&er_option='+segmentName;
		}
		else if ( comboId == 'service' )
		{
			var serviceName = snapShotReportForm.findField('service').getValue();
			paramsForCompChange = 'er_dataFrom='+ReportForVal+'&er_option='+serviceName;
		}

		paramsForCompChange = paramsForCompChange+"&er_rtype="+appConstants.snapShotType+"&call=json&reporttype=snapshot&er_gtype="+appConstants.snapShotType+"&rtype="+appConstants.snapShotType+"&userID="+appConstants.userIDVal;

		Ext.Ajax.request({
			url : '/final/servlet/com.eg.ErAjaxResponseServlet',
			method: 'post',
//			async:true,
			params: paramsForCompChange,
			scope:this,
		    success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData='';
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					jsonData = Ext.decode(jsonText);
					if ( comboId == 'compType' )
					{
						if(appConstants.snapShotType!=null && appConstants.snapShotType=="intrasnap")
						{
							var getComponentRawData = jsonData[ReportForVal];
							appConstants.rawDataForComponents=getComponentRawData;
							var componentSelectBox = snapShotReportForm.findField('componentSelectBox');
							componentSelectBox.getStore().removeAll();
							componentSelectBox.getStore().clearFilter(true);
							componentSelectBox.getStore().loadRawData(getComponentRawData);
							this.insertTypeAndAll(appConstants.componentAlertMsg, componentSelectBox);
							if(!Ext.isEmpty(getComponentRawData))
								componentSelectBox.setValue("-1");

							var testsMultiSelectObj = snapShotSettingsForm.findField('testsMultiSelect');
							testsMultiSelectObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, testsMultiSelectObj);
						}
						else if(appConstants.snapShotType!=null && appConstants.snapShotType=="intersnap")
						{
							var getComponentRawData = jsonData[ReportForVal];
							var componentsMultiSelectObj = snapShotSettingsForm.findField('componentsMultiSelect');
							componentsMultiSelectObj.getStore().removeAll();
							componentsMultiSelectObj.getStore().loadRawData(getComponentRawData);
							appConstants.rawComponentsDataForMulti=getComponentRawData;
							var selectedOptions=jsonData['selectedOptions'];
							componentsMultiSelectObj.setValue(selectedOptions);
						}

					}
					else if ( comboId == 'zone' )
					{
						if(appConstants.snapShotType!=null && appConstants.snapShotType=="intrasnap")
						{
							var getComponentRawData = jsonData['Zone'];
							var ComponentTypeObj = snapShotReportForm.findField('compType');
							ComponentTypeObj.getStore().removeAll();
							var getScreenLabel = jsonData.screenLabel['Zone'];
							ComponentTypeObj.getStore().clearFilter(true);
							ComponentTypeObj.getStore().loadRawData(getComponentRawData);
							this.insertTypeAndAll(getScreenLabel, ComponentTypeObj);
							if(!Ext.isEmpty(getScreenLabel))
							{
								ComponentTypeObj.setValue("-1");
							}
							else if(!Ext.isEmpty(getComponentRawData))
							{
								ComponentTypeObj.setValue(getComponentRawData[0].valueField);
							}

							var componentSelectBox = snapShotReportForm.findField('componentSelectBox');
							componentSelectBox.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, componentSelectBox);
							componentSelectBox.setValue(appConstants.notApplicable);

							var testsMultiSelectObj = snapShotSettingsForm.findField('testsMultiSelect');
							testsMultiSelectObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, testsMultiSelectObj);

						}
						else if(appConstants.snapShotType!=null && appConstants.snapShotType=="intersnap")
						{
							var getTestsRawData = jsonData['Zone'];
							var testsSelectBoxObj = snapShotReportForm.findField('testsSelectBox');
							testsSelectBoxObj.getStore().removeAll();
							testsSelectBoxObj.getStore().loadRawData(getTestsRawData);
							this.insertTypeAndAll(appConstants.testAlertMsg, testsSelectBoxObj);
							if(!Ext.isEmpty(appConstants.testAlertMsg))
							{
								testsSelectBoxObj.setValue("-1");
							}
							else if(!Ext.isEmpty(getTestsRawData))
							{
								testsSelectBoxObj.setValue(getTestsRawData[0].valueField);
							}

							var ComponentTypeObj = snapShotReportForm.findField('componentSelectBox');
							ComponentTypeObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, ComponentTypeObj);
							ComponentTypeObj.setValue(appConstants.notApplicable);

							var componentsMultiSelectObj = snapShotSettingsForm.findField('componentsMultiSelect');
							componentsMultiSelectObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, componentsMultiSelectObj);
						}

					}
					else if ( comboId == 'service' )
					{
						if(appConstants.snapShotType!=null && appConstants.snapShotType=="intrasnap")
						{
							var getComponentRawData = jsonData['Service'];
							var ComponentTypeObj = snapShotReportForm.findField('compType');
							ComponentTypeObj.getStore().removeAll();
							var getScreenLabel = jsonData.screenLabel['Service'];
							ComponentTypeObj.getStore().clearFilter(true); 
							ComponentTypeObj.getStore().loadRawData(getComponentRawData);
							this.insertTypeAndAll(getScreenLabel, ComponentTypeObj);
							if(!Ext.isEmpty(getScreenLabel))
							{
								ComponentTypeObj.setValue("-1");
							}
							else if(!Ext.isEmpty(getComponentRawData))
							{
								ComponentTypeObj.setValue(getComponentRawData[0].valueField);
							}

							var componentSelectBox = snapShotReportForm.findField('componentSelectBox');
							componentSelectBox.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, componentSelectBox);
							componentSelectBox.setValue(appConstants.notApplicable);

							var testsMultiSelectObj = snapShotSettingsForm.findField('testsMultiSelect');
							testsMultiSelectObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, testsMultiSelectObj);
						}
						else if(appConstants.snapShotType!=null && appConstants.snapShotType=="intersnap")
						{
							var getTestsRawData = jsonData['Service'];
							var testsSelectBoxObj = snapShotReportForm.findField('testsSelectBox');
							testsSelectBoxObj.getStore().removeAll();
							testsSelectBoxObj.getStore().loadRawData(getTestsRawData);
							this.insertTypeAndAll(appConstants.testAlertMsg, testsSelectBoxObj);
							if(!Ext.isEmpty(appConstants.testAlertMsg))
							{
								testsSelectBoxObj.setValue("-1");
							}
							else if(!Ext.isEmpty(getTestsRawData))
							{
								testsSelectBoxObj.setValue(getTestsRawData[0].valueField);
							}

							var ComponentTypeObj = snapShotReportForm.findField('componentSelectBox');
							ComponentTypeObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, ComponentTypeObj);
							ComponentTypeObj.setValue(appConstants.notApplicable);

							var componentsMultiSelectObj = snapShotSettingsForm.findField('componentsMultiSelect');
							componentsMultiSelectObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, componentsMultiSelectObj);
						}
					}
					else if ( comboId == 'segment' )
					{
						if(appConstants.snapShotType!=null && appConstants.snapShotType=="intrasnap")
						{
							var getComponentRawData = jsonData['Segment'];
							var ComponentTypeObj = snapShotReportForm.findField('compType');
							ComponentTypeObj.getStore().removeAll();
							var getScreenLabel = jsonData.screenLabel['Segment'];
							ComponentTypeObj.getStore().clearFilter(true); 
							ComponentTypeObj.getStore().loadRawData(getComponentRawData);
							this.insertTypeAndAll(getScreenLabel, ComponentTypeObj);
							if(!Ext.isEmpty(getScreenLabel))
							{
								ComponentTypeObj.setValue("-1");
							}
							else if(!Ext.isEmpty(getComponentRawData))
							{
								ComponentTypeObj.setValue(getComponentRawData[0].valueField);
							}

							var componentSelectBox = snapShotReportForm.findField('componentSelectBox');
							componentSelectBox.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, componentSelectBox);
							componentSelectBox.setValue(appConstants.notApplicable);

							var testsMultiSelectObj = snapShotSettingsForm.findField('testsMultiSelect');
							testsMultiSelectObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, testsMultiSelectObj);
						}
						else if(appConstants.snapShotType!=null && appConstants.snapShotType=="intersnap")
						{
							var getTestsRawData = jsonData['Segment'];
							var testsSelectBoxObj = snapShotReportForm.findField('testsSelectBox');
							testsSelectBoxObj.getStore().removeAll();
							testsSelectBoxObj.getStore().loadRawData(getTestsRawData);
							this.insertTypeAndAll(appConstants.testAlertMsg, testsSelectBoxObj);
							if(!Ext.isEmpty(appConstants.testAlertMsg))
							{
								testsSelectBoxObj.setValue("-1");
							}
							else if(!Ext.isEmpty(getTestsRawData))
							{
								testsSelectBoxObj.setValue(getTestsRawData[0].valueField);
							}

							var ComponentTypeObj = snapShotReportForm.findField('componentSelectBox');
							ComponentTypeObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, ComponentTypeObj);
							ComponentTypeObj.setValue(appConstants.notApplicable);

							var componentsMultiSelectObj = snapShotSettingsForm.findField('componentsMultiSelect');
							componentsMultiSelectObj.getStore().removeAll();
							this.insertNotApplicable(appConstants.notApplicable, componentsMultiSelectObj);
						}
					}
				}
				else
				{
					if ( comboId == 'compType' )
					{
						var componentsObj = snapShotReportForm.findField('componentSelectBox');
						var siteRawData = jsonData['Component'];
						componentsObj.getStore().clearFilter(true); 
						componentsObj.getStore().loadRawData(siteRawData);
						appConstants.rawDataForComponents=siteRawData;
					}
				}
			} });
	},
	selectCompTypeForTest :  function(combo)
	{
		var comboId = combo.getId();
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
		var paramsForCompChange = '';
		var testsSelectBoxVal = combo.getValue();

		paramsForCompChange = 'er_dataFrom='+ReportForVal+'&er_test='+testsSelectBoxVal;

		if ( ReportForVal == 'Zone' )
		{
			var zoneName = snapShotReportForm.findField('zone').getValue();
			var isIncludedSubZone = snapShotReportForm.findField('subzone').getValue();
			paramsForCompChange = paramsForCompChange+'&er_option='+zoneName+'&er_dataZone='+isIncludedSubZone;
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = snapShotReportForm.findField('segment').getValue();
			paramsForCompChange = paramsForCompChange+'&er_option='+segmentName;
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = snapShotReportForm.findField('service').getValue();
			paramsForCompChange = paramsForCompChange+'&er_option='+serviceName;
		}
		paramsForCompChange = paramsForCompChange+"&er_rtype="+appConstants.snapShotType+"&call=json&reporttype=snapshot&er_gtype="+appConstants.snapShotType+"&rtype="+appConstants.snapShotType+"&userID="+appConstants.userIDVal;

		Ext.Ajax.request({
			url : '/final/servlet/com.eg.ErAjaxResponseServlet',
			method: 'post',
//			async:true,
			params: paramsForCompChange,
			scope:this,
		    success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData='';
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					jsonData = Ext.decode(jsonText);
					var compTypeObj = snapShotReportForm.findField('compType');
					if(!Ext.isEmpty(compTypeObj))
					{
						var getCompTypeRawData = jsonData[ReportForVal];
						var getScreenLabel = jsonData.screenLabel[ReportForVal];
						compTypeObj.getStore().removeAll();
						compTypeObj.getStore().clearFilter(true); 
						compTypeObj.getStore().loadRawData(getCompTypeRawData);
						this.insertTypeAndAll(getScreenLabel, compTypeObj);
						if(!Ext.isEmpty(getScreenLabel))
						{
							compTypeObj.setValue("-1");
						}
						else if(!Ext.isEmpty(getCompTypeRawData))
						{
							compTypeObj.setValue(getCompTypeRawData[0].valueField);
						}
					}
				}

			} });

	},
	selectTestsForComponent : function(combo,loadTestForIntersnap)
	{
		//var comboId = combo.getId();
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var snapShotReportForm = this.getSnapshotmainform().getForm();
		var snapShotSettingsForm = this.getSnapshotsettings().getForm();
		var ReportForVal = snapShotReportForm.findField('analyzeBy').getValue();
		var paramsForCompChange = '';
		var compTypeVal = snapShotReportForm.findField('compType').getValue();
		var componentVal;	
		if(loadTestForIntersnap==true)
		{
			componentVal = combo;
		}
		else
		{
			componentVal = snapShotReportForm.findField(combo.getId()).getValue();	
		}
		paramsForCompChange = 'er_dataFrom='+ReportForVal+'&selectAllElements=true&er_componentType='+compTypeVal+'&er_component='+componentVal;
		if(componentVal=="All")
		{	
			Ext.getCmp("stateSelectBox").setValue(appConstants.publicJsonData['stateJSON'][2].valueField);
		}
		
		if ( ReportForVal == 'Zone' )
		{
			var zoneName = snapShotReportForm.findField('zone').getValue();
			var isIncludedSubZone = snapShotReportForm.findField('subzone').getValue();
			paramsForCompChange = paramsForCompChange+'&er_option='+zoneName+'&er_dataZone='+isIncludedSubZone;
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName =  snapShotReportForm.findField('segment').getValue();
			paramsForCompChange = paramsForCompChange+'&er_option='+segmentName;
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName =  snapShotReportForm.findField('service').getValue();
			paramsForCompChange = paramsForCompChange+'&er_option='+serviceName;
		}
		else
		{
			paramsForCompChange=paramsForCompChange+'&er_option=Component';
		}
		if(loadTestForIntersnap==true)
		{
			paramsForCompChange = paramsForCompChange+"&er_rtype=intrasnap&call=json&reporttype=snapshot&er_gtype=intrasnap&rtype=intrasnap&userID="+appConstants.userIDVal;
		}
		else
		{
			paramsForCompChange = paramsForCompChange+"&er_rtype="+appConstants.snapShotType+"&call=json&reporttype=snapshot&er_gtype="+appConstants.snapShotType+"&rtype="+appConstants.snapShotType+"&userID="+appConstants.userIDVal;
		}
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.ErAjaxResponseServlet',
			method: 'post',
//			async:true,
			params: paramsForCompChange,
			scope:this,
		    success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData='';
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					jsonData = Ext.decode(jsonText);
					var testsMultiSelectBoxObj = snapShotSettingsForm.findField('testsMultiSelect');
					if(!Ext.isEmpty(testsMultiSelectBoxObj))
					{
						var getTestsRawData = jsonData[ReportForVal];
						testsMultiSelectBoxObj.getStore().removeAll();
						testsMultiSelectBoxObj.getStore().loadRawData(getTestsRawData);
						var selectedOptions=jsonData['selectedOptions'];
						testsMultiSelectBoxObj.setValue(selectedOptions);
					}
					if(loadTestForIntersnap==true)
					{
						var testsSelectBox = snapShotReportForm.findField('testsSelectBox');
						var getTestsRawData = jsonData[ReportForVal];
						if(!Ext.isEmpty(testsSelectBox)&&!Ext.isEmpty(getTestsRawData))
						{
							testsSelectBox.getStore().removeAll();
							testsSelectBox.getStore().loadRawData(getTestsRawData);
						}
					}
				}
			} });
	},
	insertTypeAndAll: function( screenLabel ,  loadObj)
	{
		var tmpStore = loadObj.getStore();
		tmpStore.insert(0,{
			'displayField':screenLabel,
			'valueField':'-1'
		});
		if ( tmpStore.getCount() > 2 )
		{
			if(loadObj.getId()!='componentSelectBox'){
				tmpStore.insert( tmpStore.getCount(),{
				'displayField':'All',
				'valueField':'All'
				});
			}
		}
	},
	insertNotApplicable: function( val, loadObj )
	{
		var notApplicableArray=new Array();
		notApplicableArray.push({
			'displayField': val,
			'valueField': val
		});
		if (loadObj.getId() =='componentSelectBox')
		{
			appConstants.rawDataForComponents=notApplicableArray;
		}
		else if (loadObj.getId() =='componentsMultiSelect')
		{
 			appConstants.rawComponentsDataForMulti=notApplicableArray;
		}
		loadObj.getStore().loadRawData(notApplicableArray);		
		if ( loadObj.getId() != 'components' )
		{
			loadObj.setValue(val);
		}
	},
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('testsMultiSelect'),Ext.getCmp('testMultiSelectLbl').fieldLabel,btn);
	},
	expandMe2:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('componentsMultiSelect'),Ext.getCmp('componentsMultiSelectLbl').fieldLabel,btn);
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var value='';
 		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else
			value = appConstants.publicJsonData.pageParams[jsonParam];
 		return value;
	}
});