Ext.define('SnapShot.view.SnapShotMainForm',{
	extend:'Ext.form.Panel',
	alias:'widget.snapshotmainform',
	id:'snapshotreportform',
	collapseMode: 'mini',
 	//cls:'formOuter',
	ui:'newFormPanel',
	layout: 'hbox',
	initComponent: function(){
		this.bodyPadding ='10 10 0 10';
		this.buttonAlign = 'center';
		this.callParent()
	},
	items:[
			{
				xtype:'fieldcontainer',
				layout: 'column',
				defaults:{
					margin:'0 20 10 0',
					labelAlign:'top',
					editable : false,
					labelSeparator:'',
					queryMode : 'local'
				},
				flex:1,
				items:[
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						width: 130,
						fieldLabel:'Report For',
						name: 'analyzeBy',
						id: 'analyzeBy',
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local'
					},
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						width: 180,
						fieldLabel:'Zone',
						id: 'zone',
						name: 'zone',
						listConfig:{
							emptyText:noMatch
						},
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						editable : true,
						hidden:true
					},
					{
						xtype:'scrollcombo',
						fieldLabel:'Include Sub Zone',
						labelStyle:'white-space:nowrap',
						id: 'subzone',
						name:'subzone',
						width:120,
						cls: 'dropdown',
						displayField: 'displayField',
						valueField: 'valueField',
						defaultListConfig: {
								loadingHeight: 70,
								minWidth: 50,
								maxHeight: 300,
								shadow: 'sides'
							},
						queryMode: 'local',
						store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
						hidden : true
					},
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						width: 220,
						fieldLabel:'Segment',
						name: 'segment',
						id: 'segment',
						listConfig:{
							emptyText:noMatch
						},
						editable : true,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						hidden:true
					},
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						width: 220,
						fieldLabel:'Service',
						name: 'service',
						id: 'service',
						editable : true,
						listConfig:{
							emptyText:noMatch
						},
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						hidden:true
					},
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						width: 220,
						fieldLabel:'Tests',
						name: 'testsSelectBox',
						id: 'testsSelectBox',
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						editable : true,
						listConfig:{
							emptyText:noTestMatch
						},
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						hidden : true
					},
					{
						xtype:'scrollcombo',
						width:220,
						cls: 'dropdown',
						fieldLabel:'ComponentType',
						name: 'compType',
						id: 'compType',
						editable : true,
						listConfig:
						{
							emptyText:noComponentTypeMatch
						},
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					/*{
							xtype: 'customtrigger',
							emptyText:'Search',
							fieldLabel:'Filter by',
							editable : true,
							id:'filter',
							hidden:true
					},*/
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						width: 220,
						fieldLabel:'Component',
						name: 'componentSelectBox',
						id: 'componentSelectBox',
						editable : true,
						listConfig:
						{
							emptyText:noComponentMatch
						},
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local'
					},
					{xtype:'timelinesnapshot',margin:0},
					{
						xtype:'button',
						text: submitValue,
						margin: '20 0 0 0',
						ui:'newButtonSmall',
						//cls: 'button20',
						id: 'submit',
						name: 'submit'
					},
					{
						xtype:'button',
						text: "Save",
						ui:'newButtonSmall',
						//cls: "button20",
						id: "save",
						name: "save",
						margin: "20 0 0 0"
					}
					
				]
			},		
			{
				xtype:'button',
				cls:'iconPanelUpArrow',
				id:'panelinsidetoggle',	
				border:false,
				bodyStyle:{'background':'none'},
				hidden:true
			}
			
		],
		
		loadFields: function()
		{
			var snapShotReportForm = this.getForm();
			var incZoneLbl=appConstants.publicJsonData.screenLabels['reporter.comparison.Include SubZones'];
			var submitLbl=appConstants.publicJsonData.screenLabels['submitButtonLbl'];
			var reportLbl=appConstants.publicJsonData.screenLabels['reporter.common.Report For'];
			var selectedReportLbl=appConstants.publicJsonData.pageParams['selectedReportFor'];

			var submitButtonObj = Ext.getCmp("submit");
//			submitButtonObj.setText(submitLbl);
			var selectedReportType = appConstants.publicJsonData.pageParams.selectedReportFor;

			this.setValueWithOptionInList(snapShotReportForm,'analyzeBy',appConstants.publicJsonData['reportForJSON'],reportLbl,selectedReportType);

			var subzoneCombo = snapShotReportForm.findField('subzone');
			if(!Ext.isEmpty(subzoneCombo))
			{
				var selectedSubZone = appConstants.publicJsonData.pageParams['selectedSubZone'];
				if(!Ext.isEmpty(selectedSubZone))
				{
					if(selectedSubZone!=null && selectedSubZone=="yes")
					{
						subzoneCombo.show();
					}
				}
				else
				{
					selectedSubZone = "No";
				}
				this.setValueWithOptionInList(snapShotReportForm,'subzone',appConstants.publicJsonData['includeZoneOptions'],incZoneLbl,selectedSubZone);
			}
			var compTypeLabel = appConstants.publicJsonData.screenLabels['reporter.common.ComponentType'];

			var analyzeByVal = selectedReportType;
			if ( analyzeByVal == 'Zone' )
			{
				var zoneCombo = snapShotReportForm.findField('zone');
				this.setValueWithOptionInList(snapShotReportForm,'zone',appConstants.publicJsonData['infraTypeJSON'],selectedReportLbl,appConstants.publicJsonData.pageParams.selectedInfraTypeOption);
				zoneCombo.show();
				var subzoneCombo = snapShotReportForm.findField('subzone');
				subzoneCombo.show();				
			}
			else if ( analyzeByVal == 'Segment' )
			{
				var segmentCombo = snapShotReportForm.findField('segment');
				this.setValueWithOptionInList(snapShotReportForm,'segment',appConstants.publicJsonData['infraTypeJSON'],selectedReportLbl,appConstants.publicJsonData.pageParams.selectedInfraTypeOption);
				segmentCombo.show();
			}
			else if ( analyzeByVal == 'Service' )
			{
				var serviceCombo = snapShotReportForm.findField('service');
				this.setValueWithOptionInList(snapShotReportForm,'service',appConstants.publicJsonData['infraTypeJSON'],selectedReportLbl,appConstants.publicJsonData.pageParams.selectedInfraTypeOption);
				serviceCombo.show();
			}

			var compTypeCombo = snapShotReportForm.findField('compType');
			this.setValueWithOptionInList(snapShotReportForm,'compType',appConstants.publicJsonData['compTypeJSON'],compTypeLabel,appConstants.publicJsonData.pageParams.selectedCompType);

			var singleComboLbl = appConstants.publicJsonData.screenLabels['singleSelectBoxLabel'];
			var multiSelectBoxLabel = appConstants.publicJsonData.screenLabels['multiSelectBoxLabel'];


			if(appConstants.snapShotType!=null && appConstants.snapShotType=="intrasnap")
			{
				var selectedComponent = appConstants.publicJsonData.pageParams['selectedComponent'];
				var componentsJson = appConstants.publicJsonData['componentsArray'];
				if(selectedComponent==null || selectedComponent=="" || selectedComponent=="undefined")
				{
					if(!Ext.isEmpty(componentsJson))
						selectedComponent = componentsJson[0].valueField;
				}
				this.setValueWithOptionInList(snapShotReportForm,'componentSelectBox',componentsJson,singleComboLbl,selectedComponent);
				appConstants.rawDataForComponents=componentsJson;
				//Ext.getCmp("filter").show();
				var testsSelectBoxObj = snapShotReportForm.findField('testsSelectBox');
				testsSelectBoxObj.hide();

				//this.setValueWithOptionInList(snapShotReportForm,'testsSelectBox',componentsJson,singleComboLbl,selectedComponent);
			}
			else if(appConstants.snapShotType!=null && appConstants.snapShotType=="intersnap")
			{
				var testJson = appConstants.publicJsonData['testsArray'];
				var selectedTests = appConstants.publicJsonData.pageParams['selectedTest'];
				if(selectedTests==null || selectedTests=="" || selectedTests=="undefined")
				{
					if(!Ext.isEmpty(testJson))
						selectedTests = testJson[0].valueField;
				}
				this.setValueWithOptionInList(snapShotReportForm,'testsSelectBox',testJson,singleComboLbl,selectedTests);

				var componentSelectBoxObj = snapShotReportForm.findField('componentSelectBox');
				componentSelectBoxObj.hide();
				//Ext.getCmp("filter").hide();
				
				var testsSelectBoxObj = snapShotReportForm.findField('testsSelectBox');
				testsSelectBoxObj.show();
			}

			var hiddenFields = appConstants.publicJsonData["hiddenParams"];
			var from_schedule = hiddenFields["fromScheduleModify"];
			var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
			if ((from_schedule != null && from_schedule == "Yes")||(fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
				Ext.getCmp("submit").hide();
				Ext.getCmp("save").show();
			}else{
				Ext.getCmp("submit").show();
				Ext.getCmp("save").hide();
			}

			var snapShotSettingsForm=this.getForm();
			var timelineJSONArray = appConstants.publicJsonData['timelineJSON'];
			var timelineLbl=appConstants.publicJsonData.screenLabels['reporter.common.Timeline'];			
			var hrsLbl=appConstants.publicJsonData.screenLabels['reporter.common.Hr'];
			var fromLbl=appConstants.publicJsonData.screenLabels['reporter.common.From'];
			var minsLbl=appConstants.publicJsonData.screenLabels['reporter.common.Min'];
			var toLbl=appConstants.publicJsonData.screenLabels['reporter.common.To'];
			this.setValueWithOptionInList(snapShotSettingsForm,'timeLineCombo',timelineJSONArray,timelineLbl,appConstants.publicJsonData.pageParams.selectedTimeline);

			var startdateObj = snapShotSettingsForm.findField('startdate');
			var enddateObj = snapShotSettingsForm.findField('enddate');
			var startHourObj = snapShotSettingsForm.findField('startHour');
			var startMinsObj = snapShotSettingsForm.findField('startMins');
			var endHourObj = snapShotSettingsForm.findField('endHour');
			var endMinsObj = snapShotSettingsForm.findField('endMins');

			var stDate = appConstants.publicJsonData.pageParams['selectedStartDate'];
			var endDate = appConstants.publicJsonData.pageParams['selectedEndDate'];
			var startHr = appConstants.publicJsonData.pageParams['selectedFromHr'];
			var startMin = appConstants.publicJsonData.pageParams['selectedFromMinutes'];
			var endHr = appConstants.publicJsonData.pageParams['selectedToHr'];
			var endMin = appConstants.publicJsonData.pageParams['selectedToMinutes'];

			

			startdateObj.setValue(appConstants.publicJsonData.pageParams['startDateForDisplay']);
			startdateObj.dataArray=stDate;
			enddateObj.setValue(appConstants.publicJsonData.pageParams['endDateForDisplay']);
			enddateObj.dataArray=endDate;
			startHourObj.setValue(appConstants.publicJsonData.pageParams['startHourForDisplay']);
			startHourObj.dataArray=startHr;
			startMinsObj.setValue(appConstants.publicJsonData.pageParams['startMinForDisplay']);
			startMinsObj.dataArray=startMin;
			endHourObj.setValue(appConstants.publicJsonData.pageParams['endHourForDisplay']);
			endHourObj.dataArray=endHr;
			endMinsObj.setValue(appConstants.publicJsonData.pageParams['endMinForDisplay']);
			endMinsObj.dataArray=endMin;

			updatingAppSettings();

		},
		setValueWithOptionInList : function(form, fieldName,list,label,value){
			var fieldObj = form.findField(fieldName);
			fieldObj.getStore().loadRawData(list);
			if(label!=null)
			{
				fieldObj.setFieldLabel(label);
			}
			fieldObj.suspendEvents(false);
			fieldObj.setValue(value);
			fieldObj.resumeEvents();
		}
})