Ext.define('SnapShot.view.SnapShotSettings',{
	extend:'Ext.form.Panel',
	alias:'widget.snapshotsettings',
	//cls:'configMode_popup_inner',
	id:'snapshotsettings',
	items:[
			{
				xtype:'container',
				layout : 'column',
				defaults:{
					labelSeparator : '',
					labelAlign: 'top',
					margin: '8 20 0 0'
				},
				items :[
						{
							xtype:'fieldcontainer',
							id : 'testMultiSelectLbl',
							name : 'testMultiSelectLbl',
							fieldLabel:'Tests',
							labelSeparator:'',
							labelAlign:'top',
							labelSeparator:'',
							layout:'vbox',
							items:[
								{
									xtype:'container',
									margin: '0 0 0 0',
									layout:'hbox',
									items:[
									{
												xtype: 'multiselectfield',
												id: 'testsMultiSelect',
												name: 'testsMultiSelect',
												autoScroll:false,
												scroll:false,
												width:220,
												height:100,
												store: new Ext.data.Store({
													fields : ['displayField', 'valueField'],
													data : []
												}),
												displayField: 'displayField',
												valueField: 'valueField',
												queryMode: 'local'
											},
									{
										xtype : 'container',
										margin : '5 5 0 5',
										items : [{
													xtype : 'button',
													iconCls : 'iconMultiselectExpand',
													id:'expandSelector',
													listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: testsLabel
																});
															}
														},
													style : {
																background : 'none',
																border : '0px'
															}
												}]
								}
							]
								}
							]
							
						},
						{
							xtype:'fieldcontainer',
							id : 'componentsMultiSelectLbl',
							name : 'componentsMultiSelectLbl',
							fieldLabel:' Components',
							labelSeparator:'',
							labelAlign:'top',
							labelSeparator:'',
							layout:'vbox',
							items:[
									{
										xtype:'container',
										layout:'hbox',
										margin: '0 0 0 0',
										items:[
												{
													xtype: 'container',
													width: 220,
													margin: 0,
													items:[
															{
																xype:'container',
																cls: 'multisearchlist',
																items:[
																	{
																		xtype: 'customtrigger',
																		emptyText:searchCompTxt,
																		id: 'compSearch'
																	}
																]
															},
															{
																xtype: 'multiselectfield',
																id: 'componentsMultiSelect',
																name: 'componentsMultiSelect',
																autoScroll:false,
																scroll:false,
																width:220,
																height:90,
																store: new Ext.data.Store({
																	fields : ['displayField', 'valueField'],
																	data : []
																}),
																displayField: 'displayField',
																valueField: 'valueField',
																queryMode: 'local'
															}
													]
												},
												{
													xtype : 'container',
													margin : '5 5 0 5',
													items : [{
																xtype : 'button',
																iconCls : 'iconMultiselectExpand',
																id:'expandSelector2',
																listeners: {
																		afterrender: function () {
																			Ext.create('Ext.tip.ToolTip', {
																				target: this.id,
																				anchor: 'top',
																				cls: 'yellowTip',
																				trackMouse: true,
																				html: componentsTxt
																			});
																		}
																	},
																style : {
																			background : 'none',
																			border : '0px'
																		}
															}]
												}
									]
								}
							]
						},{
							xtype: 'textfield',
							id: 'descriptorFilter',
							name: 'descriptorFilter',
							value: '',
							fieldLabel:'Descriptor Search',
							cls: 'textbox',
							labelAlign:'top',
							labelSeparator:'',
							width: 220	
						},{
							xtype:'scrollcombo',
							cls: 'dropdown',
							margin: '10px 0px 0px 0px',
							labelSeparator:'',
							width: 220,
							editable : false,
							fieldLabel:'State',
							labelAlign:'top',
							name: 'stateSelectBox',
							id: 'stateSelectBox',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'
						}
					]
				},
				{
					xtype: 'splitter',
					height: 2,
					margin: '10px 0px 10px 0px',
					draggable:false,
					style: {
						'cursor': 'default'
					}
				},				
				{xtype:'reportgeneration', margin: '0 0 0 0'},
				{
					xtype: 'splitter',
					id:'RTMSplitter',
					height: 2,
					margin: '10px 0px 10px 0px',
					draggable:false,
					style: {
						'cursor': 'default'
					}
				},
					{xtype:'timelinesave', margin: '0 0 0 0'}
	],
	loadSettingsData : function()
	{
		var snapShotSettingsForm = this.getForm();	
		var reportGenerationLbl=appConstants.publicJsonData.screenLabels['reporter.consolidated.Report Generation'];
		var reportNameLbl=appConstants.publicJsonData.screenLabels['reporter.consolidated.Report Name'];
		var descSearch=appConstants.publicJsonData.screenLabels['reporter.common.Descriptor Search'];
		var multiSelectBoxLabel = appConstants.publicJsonData.screenLabels['multiSelectBoxLabel'];
		if(appConstants.snapShotType!=null && appConstants.snapShotType=="intrasnap")
		{ 
			var testMultiSelectLbl = Ext.getCmp('testMultiSelectLbl');
			testMultiSelectLbl.show();
			testMultiSelectLbl.setFieldLabel(multiSelectBoxLabel);

			var testJson = appConstants.publicJsonData['testsArray'];

			var selectedTests = appConstants.publicJsonData.pageParams['selectedTests'];
			if(selectedTests==null || selectedTests=="" || selectedTests=="undefined")
			{
				if(!Ext.isEmpty(testJson))
					selectedTests = testJson[0].valueField;
			}
			var componentsMultiSelectLbl =  Ext.getCmp('componentsMultiSelectLbl');
			componentsMultiSelectLbl.hide();

			this.setValueWithOptionInList(snapShotSettingsForm,'testsMultiSelect',testJson,null,selectedTests);
			
		}
		else
		{			
			var testMultiSelectLbl = Ext.getCmp('testMultiSelectLbl');
			testMultiSelectLbl.hide();
			var componentsMultiSelectLbl = Ext.getCmp('componentsMultiSelectLbl');
			componentsMultiSelectLbl.show();
			var selectedComponent = appConstants.publicJsonData.pageParams['selectedComps'];
			var componentsJson = appConstants.publicJsonData['componentsArray'];
			if(selectedComponent==null || selectedComponent=="" || selectedComponent=="undefined")
			{
				if(!Ext.isEmpty(componentsJson))
					selectedComponent = componentsJson[0].valueField;
			}
			this.setValueWithOptionInList(snapShotSettingsForm,'componentsMultiSelect',componentsJson,"",selectedComponent);
			appConstants.rawComponentsDataForMulti=componentsJson;
			componentsMultiSelectLbl.setFieldLabel(multiSelectBoxLabel);
		}

		var descriptorFilterObj = snapShotSettingsForm.findField('descriptorFilter');
		descriptorFilterObj.setFieldLabel(descSearch);

		var statesJson = appConstants.publicJsonData['stateJSON'];
		var prior_type = appConstants.publicJsonData.pageParams['prior_type'];
		if(prior_type==null && prior_type=="" && prior_type=="undefined")
		{
			if(!Ext.isEmpty(statesJson))
				prior_type = statesJson[0].valueField;
		}
		this.setValueWithOptionInList(snapShotSettingsForm,'stateSelectBox',statesJson,appConstants.publicJsonData.screenLabels['reporter.common.State'],prior_type);
		this.setValueWithOptionInList(snapShotSettingsForm,'reportGeneration',appConstants.publicJsonData['repGenOptions'],reportGenerationLbl,appConstants.publicJsonData.pageParams.er_reportgenration);

		var reportNameObj = snapShotSettingsForm.findField('bgReportName');
		reportNameObj.setFieldLabel(reportNameLbl);

		var hrsJSON = appConstants.publicJsonData['hrJSON'];
		var minsJSON = appConstants.publicJsonData['minJSON'];

		

	},
	setValueWithOptionInList : function(form, fieldName,list,label,value){
			var fieldObj = form.findField(fieldName);
			fieldObj.getStore().loadRawData(list);
			if(label!=null)
			{
				fieldObj.setFieldLabel(label);
			}
			form.findField(fieldName).suspendEvents(false);
			form.findField(fieldName).setValue(value);
			form.findField(fieldName).resumeEvents();
		}
});