Ext.define('SnapShot.view.TimeLine',{
	alias:'widget.timelinesnapshot',
	extend:'Ext.form.FieldContainer',
	layout:'column',
	defaults:{
		labelAlign: 'top',
		   margin: '0 20 10 0',
		labelSeparator:''
	},
	items:[
			{
				fieldLabel:timelineLbl,
				xtype:'scrollcombo',
				editable:false,
				id: 'timeLineCombo',
				name: 'timeLineCombo',
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				store: Ext.data.Store(
					{
						fields: ['displayField', 'valueField'],
						data: []
					}
				),				
				width:85,
				cls: 'dropdown'
			},
			{
				xtype: 'datepicker',
				id: 'startdate',
				name: 'startdate',
				fieldLabel:fromLbl,
				format: mgrDateFormat,
				disabled: true,
				listeners : 
				{
					'select' : function(obj)
					{
						var timelineData = Ext.getCmp('timeLineCombo').getValue();
						var startDateData = Ext.getCmp('startdate').getValue();
						var startHourData = Ext.getCmp('startHour').getValue();
						var startMinsData = Ext.getCmp('startMins').getValue();
						var enddateData = Ext.getCmp('enddate').getValue();
						var endHourData = Ext.getCmp('endHour').getValue();
						var endMinsData = Ext.getCmp('endMins').getValue();
						var startDate = Ext.Date.dateFormat(startDateData, mgrDateFormat);
						var endDate = Ext.Date.dateFormat(enddateData, mgrDateFormat);
						var param = 'F=getTime&P0=['+timelineData+']&P1=['+startDate+']&P2=['+endDate+']&P3=['+startHourData+']&P4=['+endHourData+']&P5=['+startMinsData+']&P6=['+endMinsData+']&P7=['+dateFormatForTimeline+']&C=id';
						Ext.Ajax.request({
							url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
							params : param,
							method : 'POST',
							scope : this,
							success : function(response)
							{
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);
								if(!Ext.isEmpty(jsonData))
								{
									var timelneObj = jsonData.timeline;
									Ext.getCmp('startdate').setValue(timelneObj[6]);
									Ext.getCmp('startdate').dataArray = timelneObj[0];
									Ext.getCmp('enddate').setValue(timelneObj[7]);
									Ext.getCmp('enddate').dataArray = timelneObj[1];
									Ext.getCmp('startHour').setValue(timelneObj[8]);
									Ext.getCmp('startHour').dataArray = timelneObj[2];
									Ext.getCmp('endHour').setValue(timelneObj[9]);
									Ext.getCmp('endHour').dataArray = timelneObj[3];
									Ext.getCmp('startMins').setValue(timelneObj[10]);
									Ext.getCmp('startMins').dataArray = timelneObj[4];
									Ext.getCmp('endMins').setValue(timelneObj[11]);
									Ext.getCmp('endMins').dataArray = timelneObj[5];
								}
							}
						});
					}
				}
			},
			{
				xtype:'scrollcombo',
				width:50,
				editable:false,
				 defaultListConfig: {
                                    loadingHeight: 50,
                                    minWidth: 50,
                                    maxHeight: 300,
                                    shadow: 'sides'
                                },
				id: 'startHour',
				name:'startHour',
				store: ['00','01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18','19', '20', '21','22','23'],
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				fieldLabel:hrLbl,
				cls: 'dropdown',
				disabled: true,
				listeners: {
				 'select': function (combo) {
                formated_sdate = Ext.Date.dateFormat(Ext.getCmp("startdate").getValue(),mgrDateFormat);
				
                var dateValue = formated_sdate + " " + combo.getValue() + ":00:00";


                var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                    params: param,
                    scope: this,
                    method: 'POST',
					success: function (response) {
					
						
                        var responseText = response.responseText;
                        responseText = Ext.String.trim(responseText);
						var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                        var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
						
                        if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
                           Ext.getCmp("startHour").dataArray = tim.substring(0, tim.indexOf(":"));
                        } else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
                            Ext.getCmp("startHour").dataArray = tim.substring(0, tim.indexOf(":"));
							
						}
					   
                    }
                });
            }
        }
			},
			{
				xtype:'scrollcombo',
				width:50,
				editable:false,
				 defaultListConfig: {
                                    loadingHeight: 50,
                                    minWidth: 50,
                                    maxHeight: 300,
                                    shadow: 'sides'
                                },
				id: 'startMins',
				name:'startMins',
				store: ['00','01','02','03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59'],
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				fieldLabel:minsLbl,
				cls: 'dropdown',
				disabled: true,
				listeners: {
				 'select': function (combo) {
                formated_sdate = Ext.Date.dateFormat(Ext.getCmp("startdate").getValue(),mgrDateFormat);
				
				  var dateValue = formated_sdate + " " + "00" + ":"+combo.getValue()+":00";


                var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                    params: param,
                    scope: this,
                    method: 'POST',
					success: function (response) {
					
						
                        var responseText = response.responseText;
                        responseText = Ext.String.trim(responseText);
						var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                        var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
						
                        if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
                           Ext.getCmp("startMins").dataArray = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":"));
                        } else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
                            Ext.getCmp("startMins").dataArray = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":"));
							
						}
					   
                    }
                });
            }
        }
			},
			{
				xtype: 'datepicker',
				id: 'enddate',
				name: 'enddate',
				fieldLabel:Tolbl,
				format: mgrDateFormat,
				disabled: true,
				listeners : 
				{
					'select' : function(obj)
					{
						var timelineData = Ext.getCmp('timeLineCombo').getValue();
						var startDateData = Ext.getCmp('startdate').getValue();
						var startHourData = Ext.getCmp('startHour').getValue();
						var startMinsData = Ext.getCmp('startMins').getValue();
						var enddateData = Ext.getCmp('enddate').getValue();
						var endHourData = Ext.getCmp('endHour').getValue();
						var endMinsData = Ext.getCmp('endMins').getValue();
						var startDate = Ext.Date.dateFormat(startDateData, mgrDateFormat);
						var endDate = Ext.Date.dateFormat(enddateData, mgrDateFormat);
						var param = 'F=getTime&P0=['+timelineData+']&P1=['+startDate+']&P2=['+endDate+']&P3=['+startHourData+']&P4=['+endHourData+']&P5=['+startMinsData+']&P6=['+endMinsData+']&P7=['+dateFormatForTimeline+']&C=id';
						Ext.Ajax.request({
							url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
							params : param,
							method : 'POST',
							scope : this,
							success : function(response)
							{
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);
								if(!Ext.isEmpty(jsonData))
								{
									var timelneObj = jsonData.timeline;
									Ext.getCmp('startdate').setValue(timelneObj[6]);
									Ext.getCmp('startdate').dataArray = timelneObj[0];
									Ext.getCmp('enddate').setValue(timelneObj[7]);
									Ext.getCmp('enddate').dataArray = timelneObj[1];
									Ext.getCmp('startHour').setValue(timelneObj[8]);
									Ext.getCmp('startHour').dataArray = timelneObj[2];
									Ext.getCmp('endHour').setValue(timelneObj[9]);
									Ext.getCmp('endHour').dataArray = timelneObj[3];
									Ext.getCmp('startMins').setValue(timelneObj[10]);
									Ext.getCmp('startMins').dataArray = timelneObj[4];
									Ext.getCmp('endMins').setValue(timelneObj[11]);
									Ext.getCmp('endMins').dataArray = timelneObj[5];
								}
							}
						});
					}
				}
			},
			{
				xtype:'scrollcombo',
				width:50,
				
				 defaultListConfig: {
                                    loadingHeight: 50,
                                    minWidth: 50,
                                    maxHeight: 300,
                                    shadow: 'sides'
                                },
				fieldLabel:hrLbl,
				cls: 'dropdown',
				id: 'endHour',
				editable:false,
				name:'endHour',
				store: ['00','01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18','19', '20', '21','22','23'],
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				disabled: true,
				listeners: {
				 'select': function (combo) {
                formated_sdate = Ext.Date.dateFormat(Ext.getCmp("enddate").getValue(),mgrDateFormat);
				
                var dateValue = formated_sdate + " " + combo.getValue() + ":00:00";


                var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                    params: param,
                    scope: this,
                    method: 'POST',
					success: function (response) {
					
						
                        var responseText = response.responseText;
                        responseText = Ext.String.trim(responseText);
						var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                        var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
						
                        if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
                           Ext.getCmp("endHour").dataArray = tim.substring(0, tim.indexOf(":"));
                        } else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
                            Ext.getCmp("endHour").dataArray = tim.substring(0, tim.indexOf(":"));
							
						}
					   
                    }
                });
            }
        }
			},
			{
				xtype:'scrollcombo',
				width:50,
				
				 defaultListConfig: {
                                    loadingHeight: 50,
                                    minWidth: 50,
                                    maxHeight: 300,
                                    shadow: 'sides'
                                },
				fieldLabel:minsLbl,
				cls: 'dropdown',
				id: 'endMins',
				editable:false,
				name:'endMins',
				store: ['00','01','02','03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59'],
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				disabled: true,
				listeners: {
				 'select': function (combo) {
                formated_sdate = Ext.Date.dateFormat(Ext.getCmp("enddate").getValue(),mgrDateFormat);
				
				  var dateValue = formated_sdate + " " + "00" + ":"+combo.getValue()+":00";


                var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                    params: param,
                    scope: this,
                    method: 'POST',
					success: function (response) {
					
						
                        var responseText = response.responseText;
                        responseText = Ext.String.trim(responseText);
						var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                        var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
						
                        if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
                           Ext.getCmp("endMins").dataArray = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":"));
                        } else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
                            Ext.getCmp("endMins").dataArray = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":"));
							
						}
					   
                    }
                });
            }
        }
			}
		]
});