Ext.define('applicationlaunch.controller.ApplicationLaunchController',{
	extend:'Ext.app.Controller',
 	refs:[
 		{selector:'newUtilities',ref:'newUtilities'},
 		{selector:'main',ref:'main'},
 		{selector:'nomeasurepanel',ref:'nomeasurepanel'},
 		{selector:'ReporterSettings',ref:'ReporterSettings'}
 	],
	foregroundJspUrl:'/final/reporter/ErApplicationLaunchCountReportJson.jsp',
	foregroundControllerUrl:'../servlet/com.eg.ErApplicationLaunchCountReportC',
	backgroundControllerUrl:'../servlet/com.eg.ErStartBackGroundReportC',
	isNewFav:false,
	isNewSch:false,
	init:function(){
		this.control({
			'main':{
				'afterrender':this.boxready
			},
			'mainform':{
 				'afterrender':this.loadForm
			},
			'newUtilities':{
				'render':this.loadTools
			},
			'applicationlaunchsettings':{
 				'afterrender':this.loadSettings
			},
			'applicationlaunchform combo[name="er_type"]': {
			  'select': this.onReportChange
			},
			'applicationlaunchform combo[name="select_farm"]': {
			  'select': this.onZoneChange
			},
			'applicationlaunchform combo[name="er_detailsBasedOn"]': {
			  'select': this.onDetailsChange
			},
			'applicationlaunchsettings combo[name="reportGeneration"]':{
				'select': this.onChangeReportGeneration
			},
			'applicationlaunchsettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'applicationlaunchsettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			/* 'applicationlaunchsettings combo[name="er_excwe"]':{
				'select': this.onWeekendChange
			},*/
			'applicationlaunchform combo[name="er_compType"]':{
				'select': this.onComponentTypeChange
			},
			'applicationlaunchform button[name="submit"]':{
				'click': this.showResult
			},
			'egcomponent button[id="compExpand"]':{
				'click': this.expandMe
			},
			'egcomponent multiselect[id="er_component"]':{
				'change': this.onChangeComponent
			},
			'fieldcontainer button[id="vmExpand"]':{
				'click': this.expandMe
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'fieldcontainer trigger[id="vmSearch"]':
			{
				'change': this.filterMultiselect
			},
			'application button[id="appExpand"]':{
				'click': this.expandMe
			},
			'application trigger[id="appSearch"]':
			{
				'change': this.filterMultiselect
			},
			'user button[id="userExpand"]':{
				'click': this.expandMe
			},
			'user trigger[id="userSearch"]':
			{
				'change': this.filterMultiselect
			},
			'adgroup button[id="adgroupExpand"]':{
				'click': this.expandMe
			},
			'adgroup trigger[id="adgroupSearch"]':
			{
				'change': this.filterMultiselect
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'main button[id="excelToolBtn"]':{
					'click':this.saveExcel
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'applicationlaunchform button[name="save"]': {
				'click': this.goTo
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'mainform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'mainform combo[id="er_site"]':
			{
			'select': this.er_siteOnChange
			}
		});
	},
	onChangeComponent: function (obj,newValue,oldValue) {
				if(oldValue==undefined || oldValue=='undefined')
				{
					return;
				}
				var er_option=Ext.getCmp('er_option').getValue();
				var params='er_option='+er_option+'&er_type='+Ext.getCmp('er_type').getValue()+'&er_compType='+Ext.getCmp('er_compType').getValue(); 
								//
				if (Ext.getCmp('er_type').getValue()=='No')
				{
					var compType=Ext.getCmp('er_compType').getValue();
					var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
					if(indexofVmComp>=0)
					{
						if(appConstants.isLaunchByVm)
						{
							params+="&islaunchByVm=true";
						}
					}
				}
				//
				if (er_option=='Zone')
				{
					params+='&select_farm='+Ext.getCmp('select_farm').getValue();
				}
				else if (er_option=='Segment' || er_option=='Segment')
				{
					params+='&er_site='+Ext.getCmp('er_site').getValue();
				}
				var compArray=obj.getValue();
				for (var key in compArray)
				{
					params+='&er_component='+compArray[key];
				}
				this.getAjaxData(this.foregroundJspUrl,params);
				var me=this;
				var task=new Ext.util.DelayedTask(function(){
				me.loadApplications();
					
				});
				task.delay(1000);
				this.loadComboField('er_workerGroup','workerGroupCombo','workerGroupLabel','workerGroupSelected',appConstants.publicJsonData,false,null,true);
				this.loadUsers(); 
		},
		onSelectAnalysisBy: function (obj) {
			var er_option=obj.getValue();
			var params='er_option='+er_option+'&er_type='+Ext.getCmp('er_type').getValue(); 
			this.getAjaxData(this.foregroundJspUrl,params);
			this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
			 
			if (er_option=='Component') 
			{
				Ext.getCmp('select_farm').hide();
				Ext.getCmp('er_site').hide();
			}
			else if(er_option=='Zone')
			{
				Ext.getCmp('select_farm').show();
				Ext.getCmp('er_site').hide();
				this.loadComboField('select_farm','zoneCombo','zoneLabel','zoneSelected',appConstants.publicJsonData,false,null,true);
			}
			else 
			{
				Ext.getCmp('select_farm').hide();
				this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
			}
			if (Ext.getCmp('er_type').getValue()=='No')
			{
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',false);
			}
			this.loadDataForReportChange();
			this.loadApplications();
			this.loadComboField('er_workerGroup','workerGroupCombo','workerGroupLabel','workerGroupSelected',appConstants.publicJsonData,false,null,true);
			this.loadUsers();  
	},
	er_siteOnChange:function(obj) {
		var er_site=obj.getValue(); 
		var params='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+Ext.getCmp('er_site').getValue()+'&er_type='+Ext.getCmp('er_type').getValue();
		this.getAjaxData(this.foregroundJspUrl,params);	
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadDataForReportChange();
		this.loadApplications();
		this.loadComboField('er_workerGroup','workerGroupCombo','workerGroupLabel','workerGroupSelected',appConstants.publicJsonData,false,null,true);
		this.loadUsers();  
	},
		//
	goTo: function (obj) {
 		if (appConstants.frmSchModify == "Yes")
			 this.saveSchedule(obj);
		else
 			this.saveFavorite(obj);
	},
	saveSchedule:function(obj){
 		if(this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
					title: 'Application Launch',
					msg: 'Chosen timeline not allowed',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		//var target="/final/reporter/ErSaveSchedule.jsp?"+this.getQueryString(true,true,true)+"&option=data";
 		if (obj.getId()=='save')
		{
			var target="/final/reporter/ErSaveSchedule.jsp?"+this.getQueryString(true,true,true,true)+"&option=data&com.eg.CSRF_NONCE="+csrfToken;
			if(target!=undefined && target.indexOf("schedule_id")==-1)
				target+='&schedule_id='+appConstants.schedule_id;
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			this.isNewSch = true; //..prakash
			var target="/final/reporter/ErSaveSchedule.jsp?"+this.getQueryString(true,true,true)+"&option=data&com.eg.CSRF_NONCE="+csrfToken;
 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
 	},
	saveFavorite:function(obj){
		var isValid = this.validateMainForm(false);
		/* if(this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any'){
			Ext.MessageBox.show({
				title: 'Application Launch',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
 		} */
		var target="";
		
		//&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
		if (obj.getId()=='save')
		{
			this.isNewFav=false;
			target="/final/reporter/ErSaveFavorite.jsp?"+this.getQueryString(true,true,true,true)+"&er_view=GRAPH&cmd=client&fromFavoriteModify=Yes"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			
		if(target!=undefined && target.indexOf("FavoriteId")==-1)
			target+='&FavoriteId='+appConstants.favorite_id;
			//document.location=target+'&showWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			this.isNewFav=true;
			target="../servlet/com.eg.ErFavoriteC?"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
 	},
	saveReportAsPDF:function(){
 		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString;
		if (Ext.isEmpty(appConstants.erUtils))
 			appConstants.erUtils = Ext.widget("erutils");

		 appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var s_qryString = appConstants.publicJsonData.urlFields.saveQueryString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.getQueryString(true,true,true)+"&option=data";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function(){
	
 		var s_qryString = "/final/reporter/ErApplicationLaunchCountReportPrint.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString+"&er_view=PRINT&pdfPrint=yes";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	saveExcel:function(){
		var s_compType = Ext.getCmp('er_compType').getValue();
		var er_detailsBasedOn=Ext.getCmp('er_detailsBasedOn').getValue();
		var queryString="";
		if (isSettingsEnabled)
		{
			var clientGeoDetails=Ext.getCmp('clientGeoDetails');
			if (!clientGeoDetails.isHidden())
			{
				queryString+='&geoDetails='+clientGeoDetails.getValue().geoDetails;	
			}
		}
		window.location="../servlet/com.eg.ErApplicationLaunchCountReportC?er_csvrequest=yes"+"&er_compType="+s_compType+"&er_detailsBasedOn="+er_detailsBasedOn+queryString;
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	filterMultiselect: function (obj) {
	obj.toggleTriggger();
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (obj.getId()=='compSearch')
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.publicJsonData.combo.componentCombo);
		
		else if (obj.getId()=='appSearch')
		{
			if(Ext.getCmp('applicationpane').fieldLabel == 'User')
				appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_application'),appConstants.publicJsonData.combo.userCombo);
			else
				appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_application'),appConstants.publicJsonData.combo.applicationCombo);
		}
		else if (obj.getId()=='userSearch')
		{
			if(Ext.getCmp('userpane').fieldLabel == 'Applications')
				appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_user'),appConstants.publicJsonData.combo.applicationCombo);
			else
				appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_user'),appConstants.publicJsonData.combo.userCombo);
		}
		else if (obj.getId()=='adgroupSearch')
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_adGroup'),appConstants.publicJsonData.combo.adGroupCombo);
		
		else if (obj.getId()=='vmSearch')
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_vm'),appConstants.publicJsonData.combo.vmOptsJson);
    },
	expandMe:function(btn)
	{
		var er_detailsBasedOn=Ext.getCmp('er_detailsBasedOn').getValue();
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (btn.getId()=='compExpand')
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Components',btn);
		}
		else if (btn.getId()=='vmExpand')
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_vm'),'DESKTOP',btn);
		}
		else if(btn.getId()=='appExpand'){
			if(er_detailsBasedOn != null && er_detailsBasedOn == 'user')
				appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'),'Users',btn);
			else
				appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'),'Applications',btn);
		}

		else if (btn.getId()=='userExpand'){
			if(er_detailsBasedOn != null && er_detailsBasedOn == 'user')
				appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_user'),'Applications',btn);
			else
				appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_user'),'Users',btn);
		}

		else if (btn.getId()=='adgroupExpand')
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_adGroup'),'Ad Group',btn);
 	},
	toggleChildTables:function(id){
		var booleanCls=$('#'+id).hasClass('iconTreeExpand');
 		var str=id.split('_');
 		if (booleanCls)
		{
   			$('#'+id).removeClass("iconTreeExpand");
			$('#'+id).addClass("iconTreeCollapse");
		}
		else
		{
 			$('#'+id).removeClass("iconTreeCollapse");
			$('#'+id).addClass("iconTreeExpand");
		}
		if (str[0]=='data')
		{
 			var toggleid='child_tr'+str[1]+'_';
 			$("#anbu tr[id^="+toggleid+"]").each(function (i, el) {
				if (booleanCls)
				{
 					el.style.display='table-row';
 				}
				else
				{
					el.style.display='none';
				}
			});
  		}
		else if(str[0]=='child')
		{

			if (booleanCls)
			{
				document.getElementById('subChild_tr_'+str[1]+'_'+str[2]).style.display='table-row';
			}
			else
			{
				document.getElementById('subChild_tr_'+str[1]+'_'+str[2]).style.display='none';
 			}
		}
		else
		{
			conosle.log('issue in toggling');
		}
		Ext.getCmp('resultContainer').doLayout();
	},
	loadReportData:function(){
		var resultContainerObj=Ext.getCmp('resultContainer');
		var s_compType = Ext.getCmp('er_compType').getValue();
		var er_detailsBasedOn=Ext.getCmp('er_detailsBasedOn').getValue();
 		var reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		this.hideResults();

			var tmpStartDate = Ext.getCmp('er_stdate').getValue();
			tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
			var tmpEndDate = Ext.getCmp('er_enddate').getValue();
			tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
			var result = checkDateTime(tmpStartDate, tmpEndDate);
			if (!result) {
				return;
			}
 		if(reportGeneration == 'foreground')
		{
			resultContainerObj.removeAll();

			if(appConstants.publicJsonData.hasOwnProperty('graph'))
			{
				if (appConstants.publicJsonData.graph.hasOwnProperty('noMeasures'))
				{
					this.disableTools();
 					this.getNomeasurepanel().show();
				}
				else
				{
					Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
					this.enableTools();
					resultContainerObj.show();
 					var reportData=appConstants.publicJsonData.graph;
 					var durationGraph=appConstants.publicJsonData.durationGraph;
 					var isAppLaunchDuarationColumnEnabled=appConstants.publicJsonData.isAppLaunchDuarationColumnEnabled;
					var content='<table width="100%" height='+(reportData.chartHeight+40)+'>';
					content+='<tr><td class="font_normal12" style="text-align:center;height:30px;">'+' '+'</td></tr>';
					content+='<tr><td align="center" valign="middle"><div id="topgraphdiv" height="100%" style="padding:10px;"></div></td></tr>';
					content+='</table>';
					
					if(appConstants.chartType.toLowerCase()=='fusionchart')
					{
						resultContainerObj.add({
							xtype:'panel',
							ui:'newGraphPanel',
							margin:10,
							listeners:
							{
								boxready:function()
								{
									if (FusionCharts("barchartid" ))
										FusionCharts("barchartid").dispose();
									var chart2 = new FusionCharts(reportData.fusionChartTypeUrl, "barchartid", "80%", reportData.chartHeight, "0", "1");
									chart2.setDataXML(reportData.fusionChartXml);
									chart2.setTransparent(true);
									chart2.render("topgraphdiv");
								}
							}
						});
						resultContainerObj.setTitle(durationGraph.panelTitle);
					}
					else if(er_detailsBasedOn!=null && er_detailsBasedOn!=undefined && er_detailsBasedOn=='application'&& appConstants.chartType.toLowerCase()=='highchart')
					{
						var result='<div style="width:100%"><table width="100%"  class="htmlGraphTable" style="border:0px;background-color:transparent"><col width="50%"><col width="50%"><tr>';
						result+='<td style="padding:0px 5px 10px 10px">';

						result+='<div width="100%" class="graphMainDiv" >';
						result+='<div class="htmlGraphTableHeader">';
						result+=reportData.chartTitle;
						result+='</div>';
						result+='<div id="topgraphdiv1" style="height:330px;width:100% !important;overflow:auto;padding:0px" class="htmlGraphTableBody">';
						result+='</div>';
						result+='</div></td>';
						if(isAppLaunchDuarationColumnEnabled)
						{
							result+='<td style="padding:0px 10px 10px 5px">';
							result+='<div width="100%" class="graphMainDiv">';
							result+='<div class="htmlGraphTableHeader">';
							result+=durationGraph.chartTitle;
							result+='</div>';
							result+='<div id="topgraphdiv2" style="height:330px;width:100%;overflow:auto;padding:0px" class="htmlGraphTableBody">';
							result+='</div>';
							result+='</div></td>';
						}
						result+='</tr></table></div>';
						resultContainerObj.add({
							xtype:'panel',
							columnWidth:1,
							title:durationGraph.panelTitle,
							margin:'0 10 10 10' ,
							ui:'multiGraphPanel',
						    items:[{
								border:false,
								html:result,
								id:'html_content',
							}],
							listeners:
							{
								boxready:function()
								{
									var barChart1 = {};
									barChart1 = jQuery.extend(true, {}, 
									getHighChartsBarInstance('topgraphdiv1',reportData.chartHeight,reportData.chartWidth), barChart1);
									barChart1.setData(reportData,'<%=currentDateFormat%>','');
									barChart1.drawChart();
									if(isAppLaunchDuarationColumnEnabled)
									{
										var barChart2 = {};
										barChart2 = jQuery.extend(true, {}, 
										getHighChartsBarInstance('topgraphdiv2',durationGraph.chartHeight,durationGraph.chartWidth), barChart2);
										barChart2.setData(durationGraph,'<%=currentDateFormat%>','');
										barChart2.drawChart();
									}
									document.getElementById('topgraphdiv1').style.width = "100%";
									if(isAppLaunchDuarationColumnEnabled)
										document.getElementById('topgraphdiv2').style.width = "100%";
								}
							}
						});
						
					//resultContainerObj.setTitle(durationGraph.panelTitle);
					}
					else if(appConstants.chartType.toLowerCase()=='highchart')
					{
						resultContainerObj.add({
							//xtype:'container',
							xtype:'panel',
							ui:'newGraphPanel',
							margin:'0 10 10 10' ,
							title:durationGraph.panelTitle,
							html:content,
							listeners:
							{
								boxready:function()
								{
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('topgraphdiv',reportData.chartHeight,reportData.chartWidth), lineChart);
									lineChart.setData(reportData,'<%=currentDateFormat%>','');
									lineChart.drawChart();
								}
							}
						});
					}
 				}
			}
			else if(appConstants.publicJsonData.hasOwnProperty('data'))
			{
				if (appConstants.publicJsonData.data.hasOwnProperty('noMeasures'))
				{
					this.disableTools();
 					this.getNomeasurepanel().show();
				}
				else
				{
					Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
					var jsondata = appConstants.publicJsonData.data;
					var data=jsondata.table;
					var isAppLaunchDuarationColumnEnabled=jsondata.isAppLaunchDuarationColumnEnabled;
					var launchItemArry=new Array();//..
					var digitalArry=new Array();
					var digitalColWidth=0.3;
					var showAvgLaunchCol=false;
					if (isAppLaunchDuarationColumnEnabled && er_detailsBasedOn!=null && er_detailsBasedOn!=undefined && er_detailsBasedOn=='application')
					{
						showAvgLaunchCol=true;
						digitalColWidth=0.25;
					}					
					var summaryArry=this.getSummaryData(digitalArry,jsondata.TotalUniqueUsers,jsondata.s2,digitalColWidth);
					summaryArry=this.getSummaryData(summaryArry,jsondata.TotalAppLaunches,jsondata.s4,digitalColWidth);
					summaryArry=this.getSummaryData(summaryArry,jsondata.TotalUniqueApplications,jsondata.s5,digitalColWidth);
					if(showAvgLaunchCol)
						summaryArry=this.getSummaryData(summaryArry,jsondata.totalAvgLaunchduration,jsondata.s6,digitalColWidth);
					launchItemArry.push(
					{
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 10 10 10',
						title:'Summary',
						columnWidth:1,
						layout:'column',
						items:summaryArry
					});
					var tableHtml='<div id="anbu" >';
					
					//tableHtml+='<br>';
					/*tableHtml+='<div class="newTable">';
					tableHtml+='<table align="center" valign="middle" width="70%"><col width="80%"><col width="20%">';
					tableHtml+='<thead><tr>';
					tableHtml+='<th colspan="2">';
					tableHtml+=jsondata.s1;
					tableHtml+='</th>';
					tableHtml+='</tr></thead>';
					tableHtml+='<tbody>';
					tableHtml+='<tr>';
					tableHtml+='<td>'+jsondata.s2+'</td>';
					tableHtml+='<td>'+jsondata.TotalUniqueUsers+'</td>';
					tableHtml+='</tr>';
					tableHtml+='<tr>';
					tableHtml+='<td>'+jsondata.s4+'</td>';
					tableHtml+='<td>'+jsondata.TotalAppLaunches+'</td>';
					tableHtml+='</tr>';
					tableHtml+='<tr>';
					tableHtml+='<td>'+jsondata.s5+'</td>';
					tableHtml+='<td>'+jsondata.TotalUniqueApplications+'</td>';
					tableHtml+='</tr>';
					tableHtml+='<tr>';
					tableHtml+='<td>'+jsondata.s6+'</td>';
					tableHtml+='<td>'+jsondata.totalAvgLaunchduration+'</td>';//..
					tableHtml+='</tr>';
					tableHtml+='</tbody>';
					tableHtml+='</table>';
					tableHtml+='</div>';
					tableHtml+='<br/>';*/

					tableHtml+='<div class="newTable">';

					if(showAvgLaunchCol)
					{
						tableHtml+='<table width="100%"><col width="65%"><col width="5%"><col width="20%"><col width="15%">';
					}
					else
						tableHtml+='<table width="100%"><col width="80%"><col width="10%"><col width="10%">';
					tableHtml+='<thead><tr>';
					tableHtml+='<th>';
					tableHtml+=jsondata.c1;
					tableHtml+='</th>';
					tableHtml+='<th style="text-align:center">';
					tableHtml+=jsondata.c2;
					tableHtml+='</th>';
					if(appConstants.publicJsonData.selectedFields.detailsBasedOnSelected=='application')
					{
						if (isAppLaunchDuarationColumnEnabled )
						{
							tableHtml+='<th style="text-align:center">';
							tableHtml+=jsondata.v2;
							tableHtml+='</th>';
						}
						tableHtml+='<th style="text-align:center">';
						tableHtml+=jsondata.s3;
						tableHtml+='</th>';
					}
					tableHtml+='</tr></thead><tbody>';
					for (var key in data)
					{
						var parentRow=data[key];
						for (var tr in parentRow)
						{
							if (tr!='subMenu')
							{
								if(appConstants.publicJsonData.selectedFields.detailsBasedOnSelected=='application')
								{
									var cntObj=parentRow[tr];
									tableHtml+='<tr>';
									tableHtml+='<td>';
									tableHtml+= '<div><div style="cursor:pointer;"><div class="iconTreeExpand" id="data_'+key+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-right:4px">';
									tableHtml+= '</div></div>';
									tableHtml+= '<div style="float:left;">';
									tableHtml+=tr;
									tableHtml+='</div></div>';
									tableHtml+='</td>';
									for (var tf in cntObj)
									{
										tableHtml+='<td>';
										tableHtml+= '<div style="text-align:center">';
										tableHtml+=tf;
										tableHtml+='</div>';
										tableHtml+='</td>';
										if (isAppLaunchDuarationColumnEnabled )
										{
											var overallAvg = cntObj[tf].toString();
											overallAvg=overallAvg.substring(overallAvg.indexOf(",")+1,overallAvg.length)
											tableHtml+='<td>';
											tableHtml+= '<div style="text-align:center">';
											tableHtml+=overallAvg;
											tableHtml+='</div>';
											tableHtml+='</td>';

											var unqUssr = cntObj[tf].toString();
											unqUssr=unqUssr.substring(0,unqUssr.indexOf(","))
											tableHtml+='<td>';
											tableHtml+= '<div style="text-align:center">';
											tableHtml+=unqUssr;
											tableHtml+='</div>';
											tableHtml+='</td>';
										}
										else
										{
											tableHtml+='<td>';
											tableHtml+= '<div style="text-align:center">';
											tableHtml+=cntObj[tf];
											tableHtml+='</div>';
											tableHtml+='</td>';
										}
									}
									tableHtml+='</tr>';
							}
							else
							{
								tableHtml+='<tr>';
								tableHtml+='<td>';
								tableHtml+= '<div><div style="cursor:pointer;"><div class="iconTreeExpand" id="data_'+key+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-right:4px">';
								tableHtml+= '</div></div>';
								tableHtml+= '<div style="float:left;">';
									if (isAppLaunchDuarationColumnEnabled )
								{
									var usr = tr.toString();
									usr = usr.substring(0,usr.indexOf(","));
									tableHtml+=usr;
									tableHtml+='</div></div>';
									tableHtml+='</td>';
								}
								else
								{
									tableHtml+=tr;
									tableHtml+='</div></div>';
									tableHtml+='</td>';
								}
								tableHtml+='<td>';
								tableHtml+= '<div>';
								tableHtml+=parentRow[tr];
								tableHtml+='</div>';
								tableHtml+='</td>';
								//
								
									if (isAppLaunchDuarationColumnEnabled &&  er_detailsBasedOn != null && er_detailsBasedOn=="application")
								{
									var ovrAllAvg = tr.toString();
									ovrAllAvg = ovrAllAvg.substring(ovrAllAvg.indexOf(",")+1,ovrAllAvg.length);
									tableHtml+='<td>';
									tableHtml+= '<div>';
									tableHtml+=ovrAllAvg;
									tableHtml+='</div>';
									tableHtml+='</td>';
								}
								//
								tableHtml+='</tr>';
							}
 						}
							else
							{
								var subMenuArray=parentRow[tr];
								tableHtml+='<tr id="child_tr'+key+'_'+childKey+'" style="display:none;">';
								if (isAppLaunchDuarationColumnEnabled  && er_detailsBasedOn!=null && er_detailsBasedOn!=undefined && er_detailsBasedOn=='application')
								{
									tableHtml+='<td colspan="4">';
								}
								else if (er_detailsBasedOn!=null && er_detailsBasedOn!=undefined && er_detailsBasedOn=='application')
								{
									tableHtml+='<td colspan="3">';
								}
								else
								{
									tableHtml+='<td colspan="2">';
								}
								if (isAppLaunchDuarationColumnEnabled  && er_detailsBasedOn!=null && er_detailsBasedOn!=undefined && er_detailsBasedOn=='application')
								{
									tableHtml+='<div class="newTable" style="margin:10px 10px 10px 10px;"><table width="100%"><col width="65%"><col width="14%"><col width="21%">';
								}
								else
								{
									tableHtml+='<div class="newTable" style="margin:10px 10px 10px;"><table width="100%"><col width="80%"><col width="20%">';
								}
								tableHtml+='<thead><tr>';
								tableHtml+='<th>';
								tableHtml+='<div>';
								tableHtml+=subMenuArray[0].cols[0];
								tableHtml+='</div>';
								tableHtml+='</th>';
								if (isAppLaunchDuarationColumnEnabled  && er_detailsBasedOn != null && er_detailsBasedOn=="application")
								{
									tableHtml+='<th>';
									tableHtml+='<div>';
									tableHtml+=subMenuArray[0].cols[2];
									tableHtml+='</div>';
									tableHtml+='</th>';
									
								}
								tableHtml+='<th>';
								tableHtml+='<div>';
								tableHtml+=subMenuArray[0].cols[1];
								tableHtml+='</div>';
								tableHtml+='</th>';
								tableHtml+='</tr></thead>';
								

								for (var childKey in subMenuArray)
								{
									var childRow=subMenuArray[childKey];
									for (var cr in childRow)
									{
										if (cr=='cols')
											continue;
										if (cr!='children')
										{
											var childUserhead = childRow[cr].toString();
											childUserhead=childUserhead.substring(0,childUserhead.indexOf(","));
											var childAvgLaunchDur = childRow[cr].toString();
											childAvgLaunchDur=childAvgLaunchDur.substring(childAvgLaunchDur.lastIndexOf(",")+1,childAvgLaunchDur.length);
											var childLaunches = childRow[cr].toString();
											childLaunches=childLaunches.substring(childLaunches.indexOf(",")+1,childLaunches.lastIndexOf(","));

											tableHtml+='<tbody><tr>';
											tableHtml+='<td>';
											tableHtml+= '<div style="cursor:pointer;"><div class="iconTreeExpand" id="child_'+key+'_'+childKey+'" onclick="javascript:toggleChildTables(this.id)" style="float:left;margin-right:4px">';
											tableHtml+= '</div></div>';
											tableHtml+= '<div style="float:left;">';
												if (isAppLaunchDuarationColumnEnabled )
												{
													tableHtml+=childUserhead;
													tableHtml+='</div>';
													tableHtml+='</td>';
													tableHtml+='<td>';
													tableHtml+= '<div style="text-align:center;">';
													tableHtml+=childLaunches;
													tableHtml+='</div>';
													tableHtml+='</td>';
													if (er_detailsBasedOn != null && er_detailsBasedOn=="application")
													{
														tableHtml+='<td>';
														tableHtml+= '<div style="text-align:center;">';
														tableHtml+=childAvgLaunchDur;
														tableHtml+='</div>';
														tableHtml+='</td>';
													}
												}
												else
												{
													tableHtml+=cr;
													tableHtml+='</div>';
													tableHtml+='</td>';
													tableHtml+='<td>';
													tableHtml+= '<div style="text-align:center;">';
													tableHtml+=childRow[cr];
													tableHtml+='</div>';
													tableHtml+='</td>';
											}
											//
											tableHtml+='</tr>';
										}
										else
										{
											var subChidObject=childRow[cr];

											var subChidCols=subChidObject.cols;
  											var subChidDat=subChidObject.dat;
											var subChidColsLen=Object.keys(subChidCols).length;

											//prakash
											var subChilsData ='';
											var align='left';
											for(var ii=0;ii<subChidCols.length;ii++)
											{
												subChilsData = subChidCols[ii];
											}
											//
											tableHtml+='<tr style="display:none;" id="subChild_tr_'+key+'_'+childKey+'">';
											if (isAppLaunchDuarationColumnEnabled)
											{
												tableHtml+='<td colspan="3">';
											}
											else if (er_detailsBasedOn!=null && er_detailsBasedOn!=undefined && er_detailsBasedOn=='application')
											{
												tableHtml+='<td colspan="2">';
											}
											else
											{
												tableHtml+='<td colspan="2">';
											}
											tableHtml+='<div class="newTable" style="margin:10px 10px 10px 10px;"><table width="100%">';
											tableHtml+='<thead><tr>';

												for (var subChildCol in subChidCols)
												{
													tableHtml+='<th>';
													tableHtml+='<div>';
													tableHtml+=subChidCols[subChildCol];
													tableHtml+='</div>';
													tableHtml+='</th>';
												}
												tableHtml+='</tr></thead>';

												tableHtml+='<tbody><tr>';
												var count=0;
												for (var subChildRow in subChidDat)
												{
													if (count==subChidColsLen)
													{
														count=0;
														tableHtml+='</tr>';
														tableHtml+='<tr>';
													}
													if(subChilsData!=null && subChilsData == 'LAUNCH DURATION')
													{
														align='center';
													}
													tableHtml+='<td>';
													tableHtml+='<div style="text-align:'+align+'">';
													tableHtml+=subChidDat[subChildRow];
													tableHtml+='</div>';
													tableHtml+='</td>';
													count++;
												}
												tableHtml+='</tr>';
												tableHtml+='</tbody></table></div>';
											tableHtml+='</td>';
											tableHtml+='</tr>';

										}
									}
								}
								tableHtml+='</tbody></table></div>';
								tableHtml+='</td>';
								tableHtml+='</tr>';
							}
 						}
					}
					tableHtml+'</tbody></table>';
					tableHtml+'</div>';

					launchItemArry.push(
					{
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 10 10 10',
						title:'Application Launch',
						items:[{
							xtype:'container',
							margin:'10 10 10 10',
							html:tableHtml
						}]
					});
					
					resultContainerObj.show();
					/*resultContainerObj.add({
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'0 10 10 10',
						title:'Application Launch',
						items:[{
							xtype:'container',
							margin:'10 10 10 10',
							html:tableHtml
						}]
					});*/	
					resultContainerObj.add(launchItemArry);//..
  					this.enableTools();
 				}	//end of else
			}
		}
		else if(reportGeneration == 'background')
		{
			var backGroundPanel=Ext.getCmp('backGroundPanel');
			var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
			if(backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor;//.slice(0, -3);
				//backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
				
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
 			}
			else if(backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor;//.slice(0, -3);
				//backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else
			{
				backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>');
			}
			backGroundPanel.show();
		}
		 else if(reportGeneration == 'background-xls')
			{
			var backGroundPanel=Ext.getCmp('backGroundPanel');
			var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
			if(backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor;//.slice(0, -3);
				//backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
 			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else if(backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor;//.slice(0, -3);
				//backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else
			{
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</div></td></tr></table></td></tr></table>');
			}
			backGroundPanel.show();
		}
		else if(reportGeneration=="background-csv")
		{
			var backGroundPanel=Ext.getCmp('backGroundPanel');
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
				var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success')
						{
							var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
							var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
							var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
							var sub = backgroundAnchor;//.slice(0, -3);
							//backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
						
							backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
						}
						else if(backgroundReportStatus== 'duplicate')
						{
							var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
							var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
							var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
							var sub = backgroundAnchor;//.slice(0, -3);
							//backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
						
							backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
						}
					}
					else
					{
						backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>');
					}
 					backGroundPanel.show();
		}
		//
		else
		{
			console.log('No data found for report generation in json');
		}
 	},
	getSummaryData:function(digitalArry,value,title,containerWidth){
		digitalArry.push(
		{
			xtype:'container',
			align:'center',
			columnWidth:containerWidth,
			margin:'10 0 10 0',
			autoSize: true,
			layout: 
			{
				type: 'table',
				columns:1,
				align:'center',
				tableAttrs: 
				{
					style: 
					{
						align:'center',
						margin:'auto auto',
						//background:styles
					}
				},
				tdAttrs:
				{
					style:
					{
						textAlign:'center'
					}
				}
			},
			defaults: {
				bodyStyle: 'padding:10px 5px 5px 5px',
				align:'center',
			},
			items: [{
				html: '<table align="center" ><tr><td align="right" style="padding-right:5px"><div class="" ></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+value+'</td></tr></table>',
				width:'100%',
				style: 
				{
					textAlign:'center',
					width:'50px'
				}
			},
			{
				html:'<span class="newFont_normal13">'+title+'</span>',
			}]
		});		
		return digitalArry;
	},
	showResult:function(obj){
		var reportGeneration;
		if (isSettingsEnabled)
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
		else
			reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;

		if (reportGeneration == 'foreground' && this.validateMainForm(true)) {
			this.getAjaxDataForSubmit(this.foregroundControllerUrl,this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background-csv'&& this.validateMainForm(true)){
			this.getAjaxDataForSubmit("../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV&isBackgroundCSV=Yes",this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background' && this.validateMainForm(true)){
			this.getAjaxDataForSubmit(this.backgroundControllerUrl,this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background-xls'&& this.validateMainForm(true)){
			this.getAjaxDataForSubmit("../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=XLSX",this.getQueryString(true,true,true));
		}
	},
	/* onWeekendChange:function(obj){
 		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(obj.getValue() == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicJsonData.labelFields.excludeDaysLabel);
		}
		else
			excludeDaysObj.hide();
	}, */
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		Ext.getCmp("excelTool").setDisabled(true);
	},
	enableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		if(Ext.getCmp('er_type').getValue() == 'Yes')
		{
			Ext.getCmp("csvTool").setDisabled(true);
			Ext.getCmp("excelTool").setDisabled(true);
		}
		else
		{
			Ext.getCmp("csvTool").setDisabled(false);
			Ext.getCmp("excelTool").setDisabled(false);
		}

	},
	hideResults:function(){
		Ext.getCmp('resultContainer').hide();
		Ext.getCmp('backGroundPanel').hide();
		this.getNomeasurepanel().hide();
	},
	onChangeReportGeneration:function(obj){
		this.hideResults();
		this.disableTools();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
 		if(obj.getValue()== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-xls'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	onDetailsChange:function(obj){
		this.hideResults();
		var er_detailsBasedOn=Ext.getCmp('er_detailsBasedOn').getValue();
		var appln=Ext.getCmp('appSearch');
		var usr=Ext.getCmp('userSearch');
		if (obj.getValue()=='application')
		{
			this.loadComboField('er_application','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'applicationpane',true);
  			appln.emptyText='Search Applications';
			appln.applyEmptyText();
			appln.show();
  			if(isSettingsEnabled)
			{
				this.loadComboField('er_user','userCombo','userLabel','userSelected',appConstants.publicJsonData,true,'userpane',true);
				usr.emptyText='Search Users';
				usr.applyEmptyText();
				usr.show();
			}
		}
		else
		{
			this.loadComboField('er_application','userCombo','userLabel','userSelected',appConstants.publicJsonData,true,'applicationpane',true);
  			appln.emptyText='Search Users';
			appln.applyEmptyText();
			appln.show();
  			if(isSettingsEnabled)
			{
				this.loadComboField('er_user','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'userpane',true);
				usr.emptyText='Search Applications';
				usr.applyEmptyText();
				usr.show();
			}
		}
		if (Ext.getCmp('er_type').getValue()=='No')
		{
			if(isSettingsEnabled){
				if(er_detailsBasedOn == 'user')
					this.loadComboField('er_groupBy','groupByComboForUser','groupByLabel','groupBySelectedAppln',appConstants.publicJsonData,false,null,true);
				else
					this.loadComboField('er_groupBy','groupByCombo','groupByLabel','groupBySelected',appConstants.publicJsonData,false,null,true);
			}
		}
	},
	onComponentTypeChange:function(obj){
		this.hideResults();
		this.getAjaxData(this.foregroundJspUrl,this.getQueryString(true,false,false));
		var compType=Ext.getCmp('er_compType').getValue();
		var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
		if (Ext.getCmp('er_type').getValue()=='No')
		{
			 if(indexofVmComp>=0 && appConstants.isLaunchByVm)
			{
				this.loadComboField('er_vm','vmOptsJson','','vmSelected',appConstants.publicJsonData,true,'vmpane',false);
				Ext.getCmp('vmpane').show();
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',false);
				Ext.getCmp('componentpane').hide();
			}
			else
			{
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
				Ext.getCmp('vmpane').hide();
				Ext.getCmp('componentpane').show();
			}
			if(isSettingsEnabled){
			if(appConstants.publicJsonData.hiddenFields.showGeoDetails == 'Yes')
				Ext.getCmp('clientGeoDetails').show();
			else
				Ext.getCmp('clientGeoDetails').hide();
			}
		}
		this.loadApplications();
		this.loadComboField('er_workerGroup','workerGroupCombo','workerGroupLabel','workerGroupSelected',appConstants.publicJsonData,false,null,true);
		this.loadUsers();
	},
	onZoneChange:function(obj){
		this.hideResults();
		var params='er_option='+Ext.getCmp('er_option').getValue()+'&select_farm='+Ext.getCmp('select_farm').getValue()+'&er_type='+Ext.getCmp('er_type').getValue();
			if (Ext.getCmp('er_type').getValue()=='No')
						{
							var compType=Ext.getCmp('er_compType').getValue();
							var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
							if(indexofVmComp>=0)
							{
								if(appConstants.isLaunchByVm)
								{
								params+="&islaunchByVm=true";
								}
							}
			}
		this.getAjaxData(this.foregroundJspUrl,params);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		//
		var compType=Ext.getCmp('er_compType').getValue();
		var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
		if (Ext.getCmp('er_type').getValue()=='No')
		{
			 if(indexofVmComp>=0 && appConstants.isLaunchByVm)
			{
				this.loadComboField('er_vm','vmOptsJson','','vmSelected',appConstants.publicJsonData,true,'vmpane',false);
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
				Ext.getCmp('vmpane').show();
				Ext.getCmp('componentpane').hide();
			}
			else
			{
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
				Ext.getCmp('vmpane').hide();
				Ext.getCmp('componentpane').show();
			}
		}
		//
		else
		{
			this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
		}
		this.loadApplications();
		this.loadComboField('er_workerGroup','workerGroupCombo','workerGroupLabel','workerGroupSelected',appConstants.publicJsonData,false,null,true);
		this.loadUsers();
	},
	loadDataForReportChange:function(){
		var er_detailsBasedOn=Ext.getCmp('er_detailsBasedOn').getValue();
		var compType=Ext.getCmp('er_compType').getValue();
		var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
		if (Ext.getCmp('er_type').getValue()=='No')
		{
			 if(indexofVmComp>=0 && appConstants.isLaunchByVm)
			{
				this.loadComboField('er_vm','vmOptsJson','','vmSelected',appConstants.publicJsonData,true,'vmpane',false);
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
				Ext.getCmp('componentpane').hide();
				Ext.getCmp('vmpane').show();
			}
			else
			{
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
				Ext.getCmp('vmpane').hide();
				Ext.getCmp('componentpane').show();
			}
		}
		//
		else
		{
			this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
		}
		if(isSettingsEnabled)
		{
			this.loadComboField('er_top','showCombo','showLabel','showSelected',appConstants.publicJsonData,false,null,true);
			if(er_detailsBasedOn == 'user')
				this.loadComboField('er_groupBy','groupByComboForUser','groupByLabel','groupBySelectedAppln',appConstants.publicJsonData,false,null,true);
			else
				this.loadComboField('er_groupBy','groupByCombo','groupByLabel','groupBySelected',appConstants.publicJsonData,false,null,true);
			this.loadComboField('reportGeneration','reportGenerationCombo','reportGenerationLabel','reportGenerationSelected',appConstants.publicJsonData,false,null,true);

		}
	},
	onReportChange:function(obj){
		this.hideResults();
		var er_option=Ext.getCmp('er_option').getValue();
		var params='er_option='+er_option+'&er_type='+Ext.getCmp('er_type').getValue();
		if(er_option=='Zone')
		{
			params+='&select_farm='+Ext.getCmp('select_farm').getValue();
		}
		else if (er_option =='Segment'|| er_option=='Service')
		{
			params+='&er_site='+Ext.getCmp('er_site').getValue();
		}
		if (Ext.getCmp('er_type').getValue()=='No')
						{
							var compType=Ext.getCmp('er_compType').getValue();
							var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
							if(indexofVmComp>=0)
							{
								if(appConstants.isLaunchByVm)
								{
								params+="&islaunchByVm=true";
								}
							}
			if(isSettingsEnabled){
				if(appConstants.publicJsonData.hiddenFields.showGeoDetails == 'Yes')
					Ext.getCmp('clientGeoDetails').show();
			}
		}
		if (Ext.getCmp('er_type').getValue()=='Yes'){
				Ext.getCmp('vmpane').hide();
				if(isSettingsEnabled)
					Ext.getCmp('clientGeoDetails').hide();
		}

		this.getAjaxData(this.foregroundJspUrl,params);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		if(isSettingsEnabled)
		{
			this.loadComboField('reportGeneration','reportGenerationCombo','Report Generation','reportGenerationSelected',appConstants.publicJsonData,false,null,true);
			var repoGen = Ext.getCmp('reportGeneration').getValue();
			var bgname = Ext.getCmp('bgReportName');
			if(repoGen!=undefined && repoGen=="foreground")
			{
				bgname.hide();
			}
			else
			{
				bgname.show();
			}
		}
		this.loadDataForReportChange();
		this.loadApplications();
	},
	getAjaxData:function(url,query){
		Ext.Ajax.request(
				{
					url : url,
					params : query,
					async:false,
					scope:this,
					success: function(response){
					appConstants.publicJsonData=Ext.decode(response.responseText);
					}
				});
	},
	getAjaxDataForSubmit:function(url,query){
		var me=this;
		Ext.Ajax.request(
				{
					url : url,
					params : query,
 					scope:this,
					success: function(response){
  						appConstants.publicJsonData=Ext.decode(response.responseText);
						me.loadReportData();
 					}
				});
	},
	getQueryString:function(isCompType,isOthers,isSettings){
		getQueryString(isCompType,isOthers,isSettings,false);
	},
	getQueryString:function(isCompType,isOthers,isSettings,forSchSave){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var queryString;
		var timefrom,minfrom,timeto,minto,er_excwe,reportGeneration,bg_reportname,er_top,er_groupBy,er_launchDuration;
		if (isSettingsEnabled)
		{
			timefrom=Ext.getCmp('timefrom').getValue();
			minfrom=Ext.getCmp('minfrom').getValue();
			timeto=Ext.getCmp('timeto').getValue();
			minto=Ext.getCmp('minto').getValue();
			er_excwe=Ext.getCmp('er_excwe').getValue();
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
			bg_reportname = Ext.getCmp('bgReportName').getValue();
			er_top=Ext.getCmp('er_top').getValue();
			er_groupBy=Ext.getCmp('er_groupBy').getValue();
			er_launchDuration=Ext.getCmp('er_launchDuration').getValue();
 		}
		else
		{
			var selectedFields=appConstants.publicJsonData.selectedFields;
			timefrom=selectedFields.selectedTimeFrom;
			minfrom=selectedFields.selectedMinsFrom;
			timeto=selectedFields.selectedTimeTo;
			minto=selectedFields.selectedMinsTo;
			er_excwe=selectedFields.excludeWeekendsSelected;
			reportGeneration=selectedFields.reportGenerationSelected;
			bg_reportname=selectedFields.reportNameSelected;
			er_top=selectedFields.showSelected;
			er_groupBy=selectedFields.groupBySelected;
			er_launchDuration=selectedFields.er_launchDuration;
			
 		}
		var er_option=Ext.getCmp('er_option').getValue();
		queryString='er_type='+Ext.getCmp('er_type').getValue();
		if (er_option=='Zone')
		{
			queryString+='&select_farm='+Ext.getCmp('select_farm').getValue();
		}
		else if (er_option=='Segment'|| er_option=='Service')
		{
			queryString+='&er_site='+Ext.getCmp('er_site').getValue();
		}
		if (isCompType)
			queryString+='&er_compType='+Ext.getCmp('er_compType').getValue()+'&er_option='+Ext.getCmp('er_option').getValue();

		if (isSettings)
		{
 			var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
			var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
			var stHr=Ext.getCmp('er_sthr').dataArray;
		
			queryString+= "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + startDateConverted + "&enddate=" + endDateConverted + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
			
			queryString+="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;

			queryString+="&er_excwe="+er_excwe;
			
 			if (reportGeneration == 'foreground') 
			{
 				queryString+="&er_reportgenration="+reportGeneration+"&isSubmit=true&responseType=json";
			}
			else
			{
				bg_reportname=checkFileName(bg_reportname);
				queryString+="&er_reportgenration="+reportGeneration+"&bg_reportname="+bg_reportname+"&isSubmit=true";
			}
		}
		queryString+='&er_launchDuration='+er_launchDuration;
		if (isOthers)
		{
			var queryArray=new Array();
 			if (Ext.getCmp('er_type').getValue()=='Yes')
				queryString+='&er_top='+er_top;
			else
				queryString+='&er_groupBy='+er_groupBy;

 			/*queryArray=Ext.getCmp('er_component').getValue();
			for (var key in queryArray)
			{
				queryString+="&er_component="+queryArray[key];
			}*/

			var er_detailsBasedOn=Ext.getCmp('er_detailsBasedOn').getValue();
			queryString+='&er_detailsBasedOn='+er_detailsBasedOn;
			if (er_detailsBasedOn=='application')
			{
				queryArray=Ext.getCmp('er_application').getValue();
				for (var key in queryArray)
				{
					queryString+="&er_application="+encodeURIComponent(queryArray[key]);
				}

				if (isSettingsEnabled)
				{
					queryArray=Ext.getCmp('er_user').getValue();
					for (var key in queryArray)
					{
						queryString+="&er_user="+appConstants.erUtils.specialCharEncode(queryArray[key]);
					}
				}
				else
				{
					queryArray=selectedFields.userSelected;
					/*for (var key in queryArray)
					{
						queryString+="&er_user="+queryArray[key];
					}*/
				}
			}
			else
			{
				queryArray=Ext.getCmp('er_application').getValue();
				for (var key in queryArray)
				{
					queryString+="&er_user="+appConstants.erUtils.specialCharEncode(queryArray[key]);
				}

				if (isSettingsEnabled)
				{
					queryArray=Ext.getCmp('er_user').getValue();
					for (var key in queryArray)
					{
						queryString+="&er_application="+encodeURIComponent(queryArray[key]);
					}
				}
				else
				{
					queryArray=selectedFields.applcationSelected;
					/*for (var key in queryArray)
					{
						queryString+="&er_application="+queryArray[key];
					}*/
				}
				//queryString+='&er_application='+Ext.getCmp('er_user').getValue();
				//queryString+='&er_user='+Ext.getCmp('er_application').getValue();
			}
			if (isSettingsEnabled)
			{
				var er_adGroup= Ext.getCmp('er_adGroup');
				if (!er_adGroup.isHidden())
				{
					queryArray=er_adGroup.getValue();
					for (var key in queryArray)
					{
						if(forSchSave)
							queryString+="&er_adGroup="+encodeURIComponent(queryArray[key]);
						else
						queryString+="&er_adGroup="+queryArray[key];
					}
				}
				var clientGeoDetails=Ext.getCmp('clientGeoDetails');
				if (!clientGeoDetails.isHidden())
				{
					queryString+='&geoDetails='+clientGeoDetails.getValue().geoDetails;	
				}
			}
			else
			{
				if (!Ext.isEmpty(selectedFields.adGroupSelected))
				{
					queryArray=selectedFields.adGroupSelected;
					/*for (var key in queryArray)
					{
						queryString+="&er_adGroup="+queryArray[key];
					}*/
				}
			}

			if(appConstants.publicJsonData.hasOwnProperty('hiddenFields'))
			{
				var hiddenFields = appConstants.publicJsonData.hiddenFields;
				for (var hiddenField in hiddenFields)
				{
					if(this.isNewFav!=undefined && this.isNewFav)
						{
							if(hiddenField!=undefined && hiddenField=='ID')
							{
								continue;
							}
							if(hiddenField!=undefined && hiddenField=='FavoriteId')
						{
							continue;
						}
					} 
					else if(this.isNewSch!=undefined && this.isNewSch)  //..prakash for appending backgId with hiddenfields
					{
						if(hiddenField!=undefined && hiddenField=='ID')
							{
								continue;
							}
						}
					queryString+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}
			}
		}
		queryString+="&er_RmDispName="+appConstants.er_RmDispName;
		queryString+="&chartType="+appConstants.chartType;

			var er_vm= Ext.getCmp('er_vm');
				if (!er_vm.isHidden())
				{		
					if (isOthers)
					{
						var queryArray=new Array();
						queryArray=er_vm.getValue();
						for (var key in queryArray)
						{
							var vm=replaceAll(queryArray[key],"#","0eghash0");
							queryString+="&er_vm="+vm;
						}
					}
				}
						if (isOthers)
						{
							var queryArray=new Array();
							
							if (Ext.getCmp('er_type').getValue()=='No')
							 {
								queryArray=Ext.getCmp('er_component').getValue();
								for (var key in queryArray)
								{
									queryString+="&er_component="+queryArray[key];
								}
							 }

							if (Ext.getCmp('er_type').getValue()=='No')
							{
								var compType=Ext.getCmp('er_compType').getValue();
								var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
								if(indexofVmComp>=0)
								{
									queryString+="&isSearchByVmComp=true";
								}
							}
						}
						if (Ext.getCmp('er_type').getValue()=='No')
						{
							var compType=Ext.getCmp('er_compType').getValue();
							var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
							if(indexofVmComp>=0)
							{
								if(appConstants.isLaunchByVm)
								{
									queryString+="&islaunchByVm=true";
								}
							}
						}
			return queryString;
	},

	boxready:function(){
		registerAjaxEvents();	//this method is included in ErTracker.jsp
  		var thisController = this;
		if(!appConstants.hideBackButton){
			Ext.getCmp('mainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		this.getMain().setTitle(appConstants.er_RmDispName);

		if(appConstants.frmFavModify!=undefined && appConstants.frmFavModify=='Yes')
		{
			return;
		}
		if (appConstants.isForceSubmit=="true"){
			this.loadReportData(appConstants.publicjsonData);
		}
		else
		{
			if(appConstants.isSubmit=="true")
			{
				this.loadReportData(appConstants.publicjsonData);
			}
		}
 	},
	loadForm:function(){
		this.loadFormFields();
        var from_schedule = appConstants.frmSchModify;
		var fromFavoriteModify = appConstants.frmFavModify;
		if (from_schedule == "Yes" || fromFavoriteModify == "Yes") {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var date=appConstants.publicJsonData.selectedFields.startDateForDisplay;
		var component=Ext.getCmp('er_stdate');
		component.setValue(date);
		component.dataArray=date;
		date=appConstants.publicJsonData.selectedFields.endDateForDisplay;
		component=Ext.getCmp('er_enddate');
		component.setValue(date);
		component.dataArray=date;
		
		Ext.getCmp('er_sthr').setValue(appConstants.publicJsonData.selectedFields.startHourForDisplay);
		Ext.getCmp('er_endhr').setValue(appConstants.publicJsonData.selectedFields.endHourForDisplay);
		Ext.getCmp('er_sthr').dataArray=appConstants.publicJsonData.selectedFields.startHour;
		Ext.getCmp('er_endhr').dataArray=appConstants.publicJsonData.selectedFields.endHour;
	stmin = appConstants.publicJsonData.selectedFields.startMinForDisplay;
	enmin = appConstants.publicJsonData.selectedFields.endMinForDisplay;
	mgr_stmin=appConstants.publicJsonData.selectedFields.startmin;
	mgr_enmin=appConstants.publicJsonData.selectedFields.endmin;
		//
 	},
	loadFormFields:function()
	{ 		//						  1			 2				3				  4						  5				   6			   7		   	8
	  //this.loadComboField(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectPanelId,isSetLabel);
		this.loadComboField('er_type','reportTypeCombo','reportTypeLabel','reportTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_option','analysisByCombo','','selectedAnalysisByCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('select_farm','zoneCombo','zoneLabel','zoneSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_detailsBasedOn','detailsBasedOnCombo','detailsBasedOnLabel','detailsBasedOnSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_workerGroup','workerGroupCombo','workerGroupLabel','workerGroupSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_timeline','timelineCombo','','selectedTimeline',appConstants.publicJsonData,false,null,false);
		this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
		var compType=Ext.getCmp('er_compType').getValue();
		var indexofVmComp=appConstants.vmComponentListEntry.indexOf(compType);
		if (Ext.getCmp('er_type').getValue()=='No')
		{
			if(indexofVmComp>=0 && appConstants.isLaunchByVm)
			{
				this.loadComboField('er_vm','vmOptsJson','','vmSelected',appConstants.publicJsonData,true,'vmpane',false);
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
				Ext.getCmp('vmpane').show();
				Ext.getCmp('componentpane').hide();
			}
			else
			{
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
				Ext.getCmp('vmpane').hide();
				Ext.getCmp('componentpane').show();
			}
		}
		else
		{
			this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
 		}
		this.loadComboField('er_application','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'applicationpane',true);
		this.loadApplications();
	},
	loadApplications:function(){
		var appln=Ext.getCmp('appSearch');
		if (Ext.getCmp('er_detailsBasedOn').getValue()=='application')
		{
  			this.loadComboField('er_application','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'applicationpane',true);
			appln.emptyText='Search Applications';
			appln.applyEmptyText();
			appln.show();
		}
		else
		{
   			this.loadComboField('er_application','userCombo','userLabel','userSelected',appConstants.publicJsonData,true,'applicationpane',true);
			appln.emptyText='Search Users';
			appln.applyEmptyText();
			appln.show();
		}
	},
	loadUsers:function(){
		if (isSettingsEnabled)
		{
			var usr=Ext.getCmp('userSearch');
			if (Ext.getCmp('er_detailsBasedOn').getValue()=='application')
			{
				this.loadComboField('er_user','userCombo','userLabel','userSelected',appConstants.publicJsonData,true,'userpane',true);
				usr.emptyText='Search Users';
				usr.applyEmptyText();
				usr.show();
			}
			else
			{
				this.loadComboField('er_user','applicationCombo','applicationLabel','applicationSelected',appConstants.publicJsonData,true,'userpane',true);
				usr.emptyText='Search Applications';
				usr.applyEmptyText();
				usr.show();
			}
		}
	},
	loadSettings:function(){
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
		var FavoriteId =hiddenFields["FavoriteId"];
		if(!Ext.isEmpty(FavoriteId)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp('moreOptionCloseId').show();
		this.loadUsers();
 		this.loadComboField('er_adGroup','adGroupCombo','adGroupLabel','adGroupSelected',appConstants.publicJsonData,true,'adgrouppane',true);
		this.loadComboField('er_excwe','excludeWeekendsCombo','excludeWeekendsLabel','excludeWeekendsSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('reportGeneration','reportGenerationCombo','reportGenerationLabel','reportGenerationSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_top','showCombo','showLabel','showSelected',appConstants.publicJsonData,false,null,true);
		var er_detailsBasedOn=Ext.getCmp('er_detailsBasedOn').getValue();
		var selectedFields=appConstants.publicJsonData.selectedFields;
		if(Ext.getCmp('er_launchDuration') != undefined && selectedFields !=undefined)
			Ext.getCmp('er_launchDuration').setValue(selectedFields.er_launchDuration);//..
		if(er_detailsBasedOn == 'user')
			this.loadComboField('er_groupBy','groupByComboForUser','groupByLabel','groupBySelectedAppln',appConstants.publicJsonData,false,null,true);
		else
			this.loadComboField('er_groupBy','groupByCombo','groupByLabel','groupBySelected',appConstants.publicJsonData,false,null,true);

	
		Ext.getCmp('timefrom').setValue(selectedFields.selectedTimeFrom);
 		Ext.getCmp('minfrom').setValue(selectedFields.selectedMinsFrom);
 		Ext.getCmp('timeto').setValue(selectedFields.selectedTimeTo);
 		Ext.getCmp('minto').setValue(selectedFields.selectedMinsTo);
		if(selectedFields.hasOwnProperty('reportNameSelected'))
 			Ext.getCmp('bgReportName').setValue(selectedFields.reportNameSelected);
		selectedFields =null;delete selectedFields;
		if (Ext.getCmp('er_type').getValue()=='No')
		{
			if(appConstants.publicJsonData.hiddenFields.showGeoDetails == 'Yes'){
				Ext.getCmp('clientGeoDetails').show();
				if(appConstants.geoDetails != null && appConstants.geoDetails == 'Yes')
					Ext.getCmp('clientGeoDetails').setValue({geoDetails: 'Yes'});	
			}
			else
				Ext.getCmp('clientGeoDetails').hide();
		}
	},
	showConfigDropdown:function(){
		Ext.widget('configform');
		isSettingsEnabled = true;
 		var thisController = this;
		Ext.get('closeSettings').on('click',function(){
  			thisController.validateAndCloseSettings();
 		});
 	},
	validateAndCloseSettings:function()
	{
		if(this.validateSettings())
		{
  			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectPaneId,isSetLabel)
	{
		 var component = Ext.ComponentManager.get(comboId);
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
			var rawData = parentJsonProperty.combo[comboProperty];
			component.getStore().clearFilter(true); 
			component.getStore().loadRawData(rawData);
		 
			if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
					component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
			else
				component.setValue(rawData[0].valueField);
			if (isSetLabel)
			{
				 if(parentJsonProperty.labelFields.hasOwnProperty(comboLabelProperty))
				 {
					if(!isMultiSelect)
						component.setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
					else
						Ext.ComponentManager.get(multiSelectPaneId).setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
				 }
			}
			if(!isMultiSelect)
			{
				if(component.isHidden())
				component.show();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectPaneId);
				if(m.isHidden())
				m.show();
			}
 		 }
		 else
		 {
			if(!isMultiSelect)
			{
				if(!component.isHidden())
				component.hide();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectPaneId);
				if(!m.isHidden())
				m.hide();
			}
		 }
 	},
	loadTools : function(){
 		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false,false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
 	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getMessageBox:function(title,msg)
	{
	  	 Ext.MessageBox.show({
				title: title,
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
		});
		return false;
	},
	validateMainForm:function(flag){
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var er_usertimeline = hiddenFields.userTimeline;

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		/*var obj=Ext.getCmp('select_farm');
		if(obj.getValue()== '-1'){
				this.getMessageBox('Application launch',obj.getStore().getAt(0).get('displayField'));
				return false;
		}*/
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '-1'){
				this.getMessageBox('Application launch',obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		obj=Ext.getCmp('er_component');
		if(obj.getValue()== '-1' && !obj.isHidden()){
				this.getMessageBox('Application launch',obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		//
		obj=Ext.getCmp('er_application');
		if(obj.getValue()== '-1' && !obj.isHidden()){
				this.getMessageBox('Application launch',obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		//
		if (reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = hiddenFields.limitforbg;
				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						return false;
					}
				}
			}
		}
		else{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}
		return true;
	},
	validateMainFormForFavAndSch:function(){
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var er_usertimeline = hiddenFields.userTimeline;

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var obj=Ext.getCmp('select_farm');
		if(obj.getValue()== '-1'){
				this.getMessageBox('Application launch',obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '-1'){
				this.getMessageBox('Application launch',obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		obj=Ext.getCmp('er_component');
		if(obj.getValue()== '-1' && !obj.isHidden()){
				this.getMessageBox('Application launch',obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		return true;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				this.getAjaxDataForSubmit(this.foregroundControllerUrl,this.getQueryString(true,true,true));
			//this.doUpdate(true,false);
		}			
		else{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			return false;
		}
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-xls' || reportgen == 'background-csv' )){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		return isSettingsOk;
	}
});