Ext.define('ApplicationGraphPopupApp.controller.Main', {
    extend: 'Ext.app.Controller',
    //views: ['Main'],
    refs: [{
            selector: 'timeline',
            ref: 'timeline'
        }, {
            selector: 'newUtilities',
            ref: 'newUtilities'
        },
		{
            selector: 'usergraphpopupmainform',
            ref: 'usergraphpopupmainform'
        }
    ],
    init: function () {
        this.control({
            'main': {
                'boxready': this.defaultLoad
            },
	    'usergraphpopupmainform button[id="submit"]':
	    {
			"click":this.formSubmit
	    },
	    'timeline combo[name="er_mode"]': 
	     {
		'select': this.changeEr_mode
	    },
            
            'newUtilities > #saveTool > button': {
                'click': this.saveFile
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #printTool > button': {
                'click': this.print
            },
            'newUtilities > #dataTool > button': {
                'click': this.showData
            },
	    'newUtilities > #diagnosisTool > button': {
		'click': this.showDD
	    },
        });
    },
    changeEr_mode: function (combo) {
	this.formSubmit();
     },
    showData: function () {
		var windowPrintFile = Ext.widget('popupprint');
		windowPrintFile.setTitle("THIN CLIENT REPORTS - USER");
		windowPrintFile.header=false;
		windowPrintFile.show();
		var measurePopupForm = this.getUsergraphpopupmainform().getForm();
		var s_qryString = dataDrillDownPageUrl;
		s_qryString = s_qryString.replace("option=graph", "option=data");
		s_qryString = s_qryString.replace("option=print", "option=data");
		var printContentDiv = Ext.get('popupPrintContentDiv');
		printContentDiv.set({
			src: s_qryString
		});
	},
	print: function () {
		var windowPrintFile = Ext.widget('popupprint');
		windowPrintFile.setTitle("THIN CLIENT REPORTS - USER");
		windowPrintFile.show();
		var measurePopupForm = this.getUsergraphpopupmainform().getForm();
		var s_qryString = printPageUrl+"&print=Yes";
		//prakash for showLegend
		var legend_temp = Ext.getCmp('showLegend').getValue();
		if(legend_temp!=null && legend_temp!=undefined)
		{
			if(s_qryString.indexOf("&showLegend") == -1)
			{
				s_qryString = s_qryString+'&showLegend='+legend_temp;
			}
		}
		//
		var printContentDiv = Ext.get('popupPrintContentDiv');
		printContentDiv.set({
			src: s_qryString
		});
	},
	sendMail: function () {
		drillDownParams = '&keyPrefix=enlarged&DrillDown=yes';
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveFile: function () {
		var measurePopupForm = this.getUsergraphpopupmainform().getForm();
		var qryString = pdfDrillDownPageUrl;
		var controller = qryString.substring(qryString.indexOf("servlet/com.eg."), qryString.indexOf("?"));
		qryString = qryString.replace(controller, "reporter/ErHtmlToSavePdf.jsp");
		var s_qryString = qryString + "&sample=yes&drillSes=yes&print=Yes&";
		var erUtils = Ext.widget('erutils');
		erUtils.savePDF(s_qryString);
	},
	showDD: function () { 

	 var w =window.open(drillDownddUrl,"DDWindow","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable");
		w.focus(); 
	},
	hideTools: function () {
		if(isDDEnabled!=undefined && isDDEnabled=='true')
		{
			this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //data
			false, //cvs
			false, // fav
			false, // schedule
			true, //daignosis
			false, //togglebutton
			false //close
			);

			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("dataTool").setDisabled(false);
			Ext.getCmp("diagnosisTool").setDisabled(false);
		}
		else
		{
			this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //data
			false, //cvs
			false, // fav
			false, // schedule
			false, //daignosis
			false, //togglebutton
			false //close
			);

			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("dataTool").setDisabled(false);
		}


	},
	validateForm: function () {
		var measurePopupForm = this.getUsergraphpopupmainform().getForm();
		var stDate = measurePopupForm.findField('er_stdate').getValue();
		var enDate = measurePopupForm.findField('er_enddate').getValue();
		stDate.setHours(measurePopupForm.findField('er_sthr').getValue());
		enDate.setHours(measurePopupForm.findField('er_endhr').getValue());
		var er_timeline = measurePopupForm.findField('er_timeline').getValue();
		if (Ext.isEmpty(er_timeline)) {
			er_timeline = '1 day';
		}
		if (er_timeline != null && er_timeline == "Any") {
			if (!checkDateTime(stDate, enDate)) {
				return;
			}
		}
		var getMaxDaysInMonth = publicJsonData['hiddenParams']['getMaxDaysInMonth'];
		var maxDaysInMonth = "";
		if (!Ext.isEmpty(getMaxDaysInMonth)) {
			maxDaysInMonth = getMaxDaysInMonth;
		}
		var er_usertimeline = "";
		var er_usertimelineObj = publicJsonData['hiddenParams']['er_usertimeline'];
		if (!Ext.isEmpty(er_usertimelineObj)) {
			er_usertimeline = er_usertimelineObj;
		}
		if (er_usertimeline != null && er_usertimeline != "-1") {
			if (!isUserTimelineLimitExceeded(er_usertimeline, maxDaysInMonth, stDate, enDate)) {
				return false;
			}
		}
		return true;
	},
	formSubmit : function()
	{
		if (!this.validateForm())
			return;
		var measurePopupForm = this.getUsergraphpopupmainform().getForm();
		var startdateObj = measurePopupForm.findField('er_stdate');
		var enddateObj = measurePopupForm.findField('er_enddate');
		var startHourObj = measurePopupForm.findField('er_sthr');
		var endHourObj =  measurePopupForm.findField('er_endhr');
		var timeLineComboObj = measurePopupForm.findField('er_timeline');
		var graphModeObj = measurePopupForm.findField('er_mode');

		var selectedStDate = Ext.Date.dateFormat(startdateObj.getValue(), mgrDateFormat);
		var selectedEndDate = Ext.Date.dateFormat(enddateObj.getValue(), mgrDateFormat);

		var selStartHr = startHourObj.getValue();
		var selEndHr = endHourObj.getValue();
		var er_timeline = timeLineComboObj.getValue();
		var graphMode = graphModeObj.getValue();
		
		var hiddenFieldQStr = publicJsonData['hiddenQStr'];
		var userID = publicJsonData['userID'];

		var paramsForSubmit = 'er_timeline=' + er_timeline +'&er_enddate='+selectedStDate+'&er_stdate='+selectedEndDate+'&startdate=' + selectedStDate + '&userStartDate='+selectedStDate+'&userEndDate='+selectedEndDate+'&enddate=' + selectedEndDate + '&er_sthr='+selStartHr+'&starthr=' + selStartHr + '&er_endhr='+selEndHr+'&endhr=' + selEndHr + hiddenFieldQStr + '&er_mode=' + graphMode+"&userID="+userID+"&opt=chart&option=Citrix&graphViewtype=timeline";
		loadmask.show();
 		paramsForSubmit+= '&er_RmDispName='+er_RmDispName;

		var url = '/final/servlet/com.eg.ErCtxServerReportC';
		paramsForSubmit += '&screenWidth=' + Ext.getBody().getViewSize().width;

		paramsForSubmit+= '&componentNamee='+componentNme+"&portt="+portt+"&drillDown=yes";
		Ext.Ajax.request(
		{
			url : url,
			params : paramsForSubmit,
			scope: this,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var blockTitle = jsonData.pageParams['imgTitle'];

				var imgrurl = jsonData.pageParams['imgUrl'];

				var submittedData = Ext.getCmp("submittedData");
				submittedData.removeAll();
				submittedData.show();

				printPageUrl = jsonData.pageParams['printPageUrl'];
				dataDrillDownPageUrl = jsonData.pageParams['dataPageUrl'];
				pdfDrillDownPageUrl = jsonData.pageParams['pdfUrl'];
				drillDownddUrl=jsonData.pageParams['ddUrl'];
				isDDEnabled=jsonData.pageParams['isddEnabled'];
				//var htmlStr = '<div><img align="center" src="' + imgrurl + '" width="' + publicJsonData.pageParams['imgWidth'] + '"  height="' + publicJsonData.pageParams['imgHeight'] + '" border="0" /><br><br>'
				var chartType = publicJsonData['chartType'];
				var imageHeight = parseInt(publicJsonData.pageParams['imgHeight']);
				var htmlStr = ''
				chartType='highchart';
				if(chartType!=null && chartType == "highchart"){
					
					htmlStr = '<div id="highChart_0" style="width:'+(publicJsonData.pageParams['imgWidth'])+'px;height:'+(imageHeight+20)+'px">';
				}else
				{
					htmlStr = '<div><img src="' + imgrurl + '" width="' + publicJsonData.pageParams['imgWidth'] + '"  height="' + publicJsonData.pageParams['imgHeight'] + '" border="0" /><br><br>'
				}
				if(chartType!=null && chartType == "highchart"){
//					submittedData.add({xtype:'container',id:'chkVal',height:imageHeight});
					submittedData.add(
						{
							xtype:'container',
							id:'chkVal_GraphPanel',
							height:imageHeight,
							html:'<div id="chkVal" style="width:98%;height:98%;"></div>'
						},
						{
							xtype:'container',
							id:'chkVal_legendPanel',
							margin:'0 0 5 0',
							height:53,
							style: {
								'overflow': 'hidden',
								'padding-right':'10px',
								'padding-bottom':'5px',
							}
						});
				}
				else{
					var addSubmittedReports = submittedData.add({
						xtype: 'panel',
						id: 'noMeasMsgPanel',
						ui:'newGraphPanel',
						title: blockTitle,
						margin:'0 10 10 10',
						//cls: 'dataPanel',
						//layout: 'vbox',
						//width: '100%',
						html: htmlStr
					});
				}
				if(chartType == "highchart"){
					imgrurl=imgrurl+"&chartType=highchart";
//						reportHighStockChart(imgrurl,'highChart_0',publicJsonData.pageParams['imgWidth'],imageHeight-15,null);
						reportHighStockChart(imgrurl,'chkVal',publicJsonData.pageParams['imgWidth'],imageHeight-15,null);
				}
				loadmask.hide();
			}
		});
	},
	defaultLoad: function () {
		var mainForm = this.getUsergraphpopupmainform();
		var measurePopupForm = mainForm.getForm();
    	if(!Ext.isEmpty(measurePopupForm))
		{
			var showLegends = publicJsonData.pageParams['showLegend'];
			if(showLegends!=null && showLegends == 'true')
			{
				Ext.getCmp('showLegend').setValue(true);
			}
			Ext.getCmp('er_checkbox').show();
			var selectionDetailsObj=Ext.getCmp('details');
			var selectionDetailsjson = publicJsonData.selectionDetails;
			var fieldContainerArray=new Array();
			for (var labelName in selectionDetailsjson){
				var htmlstr=selectionDetailsjson[labelName];

				var fieldAdd = {xtype:'container', html:'<span style="margin-right:30px;margin-bottom:13px !important;float:left;margin-top:0px"><span class="formSelectionName">'+labelName+'</span> - <span class="formSelectionValue">'+htmlstr+'</span></span>'}

				fieldContainerArray.push(fieldAdd);
			}
			//selectionDetailsObj.removeAll();
			selectionDetailsObj.add(fieldContainerArray);

			var timelineJSONArray = publicJsonData['timelineJSONArray'];
            var timelineSelectBox = measurePopupForm.findField('er_timeline');
            timelineSelectBox.getStore().loadRawData(timelineJSONArray);
            timelineSelectBox.setFieldLabel(timelineMapping);

            var er_timeline = publicJsonData.pageParams['er_timeline'];

            if (!Ext.isEmpty(er_timeline)) {
                timelineSelectBox.setValue(er_timeline);
            }

            var startdateObj = measurePopupForm.findField('er_stdate');
            startdateObj.setFieldLabel(fromLabelMapping);
            var selectedStDate = publicJsonData.pageParams['selectedStDate'];
            if (!Ext.isEmpty(selectedStDate)) {
                startdateObj.setValue(selectedStDate);
            }

            var enddateObj = measurePopupForm.findField('er_enddate');
            enddateObj.setFieldLabel(toLblMapping);
            var selectedEndDate = publicJsonData.pageParams['selectedEndDate'];
            if (!Ext.isEmpty(selectedEndDate)) {
                enddateObj.setValue(selectedEndDate);
            }

            var selectedStarthour = publicJsonData.pageParams['selectedStarthour'];
            var selectedEndhour = publicJsonData.pageParams['selectedEndhour'];
            var showMinutes = publicJsonData.pageParams['showMinutes'];
            var dpSh         = publicJsonData.pageParams['dpSh'];
            var dpEh         = publicJsonData.pageParams['dpEh'];

            var startHourObj = measurePopupForm.findField('er_sthr');
            startHourObj.dataArray = selectedStarthour;
            startHourObj.setValue(dpSh);
            startHourObj.setFieldLabel(hrLblMapping);
            var endHourObj = measurePopupForm.findField('er_endhr');
            endHourObj.dataArray = selectedEndhour;
            endHourObj.setValue(dpEh);
            endHourObj.setFieldLabel(hrLblMapping);
			var graphModeOptions = publicJsonData['graphModeOptions'];
            var graphModeObj = measurePopupForm.findField('er_mode');
            //var graphModeLbl = Ext.getCmp('graphModeLbl');
            //graphModeObj.getStore().loadRawData(graphModeOptions);
            var selectedGraphMode = publicJsonData.pageParams['selectedGraphMode'];
            graphModeObj.setValue(selectedGraphMode);
			graphModeObj.setFieldLabel(graphLblMapping);
            //graphModeLbl.setText(graphLblMapping);
			var blockTitle = publicJsonData.pageParams['imgTitle'];

			var imgrurl = publicJsonData.pageParams['imgUrl'];

			var submittedData = Ext.getCmp("submittedData");
			submittedData.removeAll();
			submittedData.show();

			printPageUrl = publicJsonData.pageParams['printPageUrl'];
			dataDrillDownPageUrl = publicJsonData.pageParams['dataPageUrl'];
			pdfDrillDownPageUrl = publicJsonData.pageParams['pdfUrl'];
			drillDownddUrl=publicJsonData.pageParams['ddUrl'];
			isDDEnabled=publicJsonData.pageParams['isddEnabled'];
			this.hideTools();
			var chartType = publicJsonData['chartType'];
			var imageHeight = parseInt(publicJsonData.pageParams['imgHeight']);
			var htmlStr = ''
			chartType='highchart';
			if(chartType!=null && chartType == "highchart"){
				
				htmlStr = '<div id="highChart_0" style="width:'+(publicJsonData.pageParams['imgWidth'])+'px;height:'+(imageHeight+20)+'px">';
			}else
			{
				htmlStr = '<div><img src="' + imgrurl + '" width="' + publicJsonData.pageParams['imgWidth'] + '"  height="' + publicJsonData.pageParams['imgHeight'] + '" border="0" /><br><br>'
			}
			//var htmlStr = '<div><img align="center" src="' + imgrurl + '" width="' + publicJsonData.pageParams['imgWidth'] + '"  height="' + publicJsonData.pageParams['imgHeight'] + '" border="0" /><br><br>'
			if(chartType!=null && chartType == "highchart"){
				submittedData.setTitle(blockTitle);
//				submittedData.add({xtype:'container',id:'chkVal',height:imageHeight});
				submittedData.add(
					{
						xtype:'container',
						id:'chkVal_GraphPanel',
						height:imageHeight,
						html:'<div id="chkVal" style="width:98%;height:98%;"></div>'
					},
					{
						xtype:'container',
						id:'chkVal_legendPanel',
						margin:'0 0 5 0',
						height:53,
						style: {
							'overflow': 'hidden',
							'padding-right':'10px',
							'padding-bottom':'5px',
						}
					});
			}
			else{
				var addSubmittedReports = submittedData.add({
					xtype: 'panel',
					id: 'noMeasMsgPanel',
					ui:'newGraphPanel',
					margin:'0 10 10 10',
					title: blockTitle,
					html: htmlStr

				});
			}
			var submitButtonObj = Ext.getCmp("submit");
		//	submitButtonObj.setText(submitLbl);
			submitButtonObj.setText('Run Report');
			if(chartType == "highchart"){
				imgrurl=imgrurl+"&chartType=highchart";
//				reportHighStockChart(imgrurl,'highChart_0',publicJsonData.pageParams['imgWidth'],imageHeight-15,null);
				reportHighStockChart(imgrurl,'chkVal',publicJsonData.pageParams['imgWidth'],imageHeight-15,null);
			}
		}
		loadmask = Ext.get('loadmask');
		loadmask.hide();
	}
});