Ext.define('ApplicationGraphPopupApp.view.PopupPrint',{
	extend:'Ext.window.Window',
	alias:'widget.popupprint',
	modal:true,
	ghost:false,
	id:"popupprint",
	closeAction:'destroy',
	constrain:true,
	title:'',
	header:true,
	width:850,
	height:450,
	autoScroll:true,
	ui:'newPopupWindow',
	layout:{
		type:'fit'
	},
	defaults:{
		margin:'0 0 0 0'
	},
	border:false,
	//	header:false,
	frame:false,
	items:[{
		xtype : "component",
		id:"popupPrintContentDiv",
		autoEl:{
			tag:'iframe',
			frameborder:'0',
			height:'100%',
			border:false,
			src :''
		}
	}],
	listeners:{
		show: function(win) {
			if (this.modal) {
				var doms = Ext.dom.Query.select('.x-mask');
				for (var key in doms)
				{
					this.dom=doms[key];
					if (!Ext.isEmpty(this.dom.offsetParent))
					{
						if (this.dom.offsetParent.tagName=='BODY')
						{
							Ext.fly(this.dom).addCls('windowModal');
						}
					}
				}
			}
		},
		hide:  function(win) {
			if (this.modal) {
				Ext.fly(this.dom).removeCls('windowModal');
			}
		},
		afterrender:function(){
			Ext.EventManager.onWindowResize(function(){
			var me = this;
			me.center();
			},this);
		}
	},
});