Ext.define("thinclientapplicationreports.view.ThinclientApplicationForm", {
    extend: "Ext.form.FieldContainer",
    alias: "widget.thinclientapplicationform",
    collapseMode: "mini",
    id: "thinclientapplicationform",
 	layout: "column",
	defaults: {
		labelAlign: "top",
		margin:'0 20 10 0',
		labelSeparator: ""
	},
    items: [
				{
					xtype: "scrollcombo",
					cls: "dropdown",
					width: 130,
					editable: false,
					id: "report_category",
					name: "report_category",
					fieldLabel: "Report For",
					store: new Ext.data.Store({
						fields: ["displayField", "valueField"],
						data: ["Activity", "Activity"]
					}),
					displayField: "displayField",
					valueField: "valueField",
					queryMode: "local",
					hidden: true
				},
				{
					xtype: "scrollcombo",
					width: 90,
					cls: "dropdown",
					editable: false,
					fieldLabel: "Report Type",
					name: "er_type",
					id: "er_type",
					store: new Ext.data.Store({
						fields: ["displayField", "valueField"],
						data: []
					}),
					displayField: "displayField",
					valueField: "valueField",
					queryMode: "local"
				},
				{
					xtype: "scrollcombo",
					width: 100,
					cls: "dropdown",
					editable: false,
					fieldLabel: "Report By",
					name: "er_option",
					id: "er_option",
					store: new Ext.data.Store({
						fields: ["displayField", "valueField"],
						data: []
					}),
					displayField: "displayField",
					valueField: "valueField",
					queryMode: "local"
				},
				{
					xtype: "scrollcombo",
					cls: "dropdown",
					width: 130,
					editable: true,
					fieldLabel: "Zone",
					name: "select_farm",
					id: "select_farm",
					listConfig:{
							emptyText:noMatch
						},
					store: new Ext.data.Store({
						fields: ["displayField", "valueField"],
						data: []
					}),
					displayField: "displayField",
					valueField: "valueField",
					queryMode: "local"
				},
				{
					xtype: "scrollcombo",
					cls: "dropdown",
					width: 170,
					editable: true,
					fieldLabel: "Segment",
					name: "er_site",
					id: "er_site",
					listConfig:{
							emptyText:noMatch
						},
					store: new Ext.data.Store({
						fields: ["displayField", "valueField"],
						data: []
					}),
					displayField: "displayField",
					valueField: "valueField",
					queryMode: "local",
					hidden: true
				},
				{
					xtype: "scrollcombo",
					width: 220,
					cls: "dropdown",
					editable: true,
					fieldLabel: "Component Type",
					name: "er_compType",
					id: "er_compType",
					listConfig:{
							emptyText:noComponentTypeMatch
						},
					store: new Ext.data.Store({
						fields: ["displayField", "valueField"],
						data: []
					}),
					displayField: "displayField",
					valueField: "valueField",
					queryMode: "local",
					hidden: true
				},
				{
					xtype: "scrollcombo",
					width: 190,
					cls: "dropdown",
					editable: true,
					fieldLabel: "Criteria",
					name: "select_testmes",
					id: "select_testmes",
					listConfig:{
							emptyText:noMeasureMatch
						},
					store: new Ext.data.Store({
						fields: ["displayField", "valueField"],
						data: []
					}),
					displayField: "displayField",
					valueField: "valueField",
					queryMode: "local"
				},
				{
					xtype: "scrollcombo",
					width: 220,
					cls: "dropdown",
					editable: false,
					fieldLabel: "Worker Group",
					name: "er_workgrpname",
					id: "er_workgrpname",
					store: new Ext.data.Store({
						fields: ["displayField", "valueField"],
						data: []
					}),
					displayField: "displayField",
					valueField: "valueField",
					queryMode: "local",
					hidden: true
				},
				{
					xtype: "scrollcombo",
					width: 170,
					cls: "dropdown",
					editable: true,
					listConfig:{
							emptyText:noApplicationMatch
						},
					fieldLabel: "Application",
					name: "er_application_usage",
					id: "er_application_usage",
					store: new Ext.data.Store({
						fields: ["displayField", "valueField"],
						data: []
					}),
					displayField: "displayField",
					valueField: "valueField",
					queryMode: "local",
					hidden: true
				},
				{xtype:'timeline', margin:0},
				{
					xtype:'checkbox',
					cls: 'checkbt',
					margin:'22 20 0 0',
					//boxLabel: 'Show Legends',
					boxLabel:strShowLegend,
					inputValue: 'true',
					id: 'showLegend'
				},
				{
					xtype:'button',
					text: submitValue,
					margin: '20 20 0 0',
					ui:'newButtonSmall',
					id: 'submit',
					name: 'submit'
				},
				{
					xtype:'button',
					text: "Save",
					ui:'newButtonSmall',
					id: "save",
					name: "save",
					margin: '20 20 0 0'
				}
		]
});