
Ext.define("thinclientapplicationreports.controller.ThinclientApplicationReports", {
    extend: "Ext.app.Controller",
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
    views: ["Main"],
    refs: [{
            selector: "main",
            ref: "main"
        }, {
            selector: "newUtilities",
            ref: "newUtilities"
        },
		{
			selector: 'thinclientapplicationform',
			ref: 'thinclientapplicationform'
        },
		{
		  selector: 'egcomponent',
		  ref: 'egcomponent'
        },
		{
		  selector: 'geofilter',
		  ref: 'geofilter'
        },
		{
			selector: 'mainform',
			ref: 'mainform'
        },
		{
		  selector: 'thinclientapplicationsettings',
		  ref: 'thinclientapplicationsettings'
        },
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'} ],
    init: function() {
        this.control({
            "main": {
                "boxready": this.afterMainRender
            },
            "mainform": {
                "afterrender": this.loadFormElements
            },
            "thinclientapplicationsettings": {
                "afterrender": this.loadSettingsElements
            },
            "newUtilities": {
                "afterrender": this.loadTools
            },
            "newUtilities > #printTool > button": {
                "click": this.printReport
            },
            "newUtilities > #saveTool > button": {
                "click": this.saveReportAsPDF
            },
            "newUtilities > #mailTool > button": {
                "click": this.sendMail
            },
            "newUtilities > #csvTool > button": {
                "click": this.saveCsv
            },
            "newUtilities > #favoriteTool > button": {
                "click": this.saveFavorite
            },
            "newUtilities > #scheduleTool > button": {
                "click": this.saveSchedule
            },
			'timeline combo[name="er_mode"]':
			{
			 'select': this.changeEr_mode
			},
            'mainform combo[name="select_farm"]': {
                "select": this.zoneOnChange
            },
            'mainform combo[name="er_type"]': {
                "select": this.reportTypeOnChange
            },
            'mainform multiselect[name="er_server"]': {
                'change': this.serverOnChange
            },
            'mainform button[id="expandAppln"]': {
                "click": this.expandAppln
            },
            'mainform combo[name="er_compType"]': {
                "select": this.compTypeOnChange
            },
            'thinclientapplicationsettings combo[name="er_excwe"]': {
                "select": this.weekendOnChange
            },
            'mainform combo[name="er_timeline"]': {},
            'thinclientapplicationsettings combo[name="reportGeneration"]': {
                "select": this.reportGenChange
            },
			'thinclientapplicationsettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'thinclientapplicationsettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
            'mainform button[name="submit"]': {
                "click": this.showResult
            },
            'mainform button[name="save"]': {
                "click": this.goTo
            },
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
            },
            'mainform button[id="expandSelectorActivity"]': {
                "click": this.expandMe
            },
			'mainform trigger[id="compSearch"]':
			{
			'change': this.filterMultiselect
			},
			'mainform trigger[id="appSearch"]':
			{
			'change': this.filterMultiselect
			},
			'geofilter trigger[id="compSearch_geo"]':
			{
			'change': this.filterMultiselect
			},
			'geofilter button[id="expandSelectorActivity_geo"]': 
			{
				"click": this.expandMeGeo
			},
			'mainform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'mainform combo[id="er_site"]':
			{
			'select': this.er_siteOnChange
			}
        });
    },
	onSelectAnalysisBy: function (obj) 
	{
		var er_option=obj.getValue();
		var params='er_option='+er_option+'&er_type='+Ext.getCmp('er_type').getValue()+'&application_user_details_report=true';
		var urlstr="/final/reporter/ErCtxApplicationReportJson.jsp";
		 Ext.Ajax.request({
            url: urlstr,
            params: params,
             method: "POST",
            success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				var component;
				if (er_option=='Zone')
				{
					Ext.getCmp('er_site').hide();
					component=Ext.getCmp('select_farm');
					component.getStore().loadRawData(jsonData.zoneCombo);
					component.setValue(jsonData.selectedZone);
					component.show();
				
				}
				else if (er_option=='Component') 
				{
					Ext.getCmp('select_farm').hide();
					Ext.getCmp('er_site').hide();
				
 				}
				else 
				{
					Ext.getCmp('select_farm').hide();
					component=Ext.getCmp('er_site');
					component.getStore().loadRawData(jsonData.siteCombo);
					component.setFieldLabel(jsonData.siteComboLabel);
					component.setValue(jsonData.selectedSiteCombo);
					component.show();
				}
				component=Ext.getCmp('er_compType');
				component.getStore().loadRawData(jsonData.componentTypeCombo);
				component.setValue(jsonData.selectedComponentType);
				var er_type=Ext.getCmp('er_type').getValue();
 				if (er_type=='Yes')
				{
					component=Ext.getCmp('select_testmes');
					component.getStore().loadRawData(jsonData.measureCombo);
					component.setValue(jsonData.selectedMeasure);
					component.show();
					Ext.getCmp('egcomponent').hide();
 
				}
				else
				{
					Ext.getCmp('select_testmes').hide();
					component = Ext.getCmp("er_server");
 					component.getStore().loadRawData(jsonData.serverCombo);
					component.setValue(jsonData.selectedServer);
 					component = Ext.getCmp("er_application");
					component.getStore().loadRawData(jsonData.applnCombo);
 					component.setValue(jsonData.selectedAppln);
					Ext.getCmp('egcomponent').show();

				}
				
			}
		 });
	},
	er_siteOnChange: function (obj) {
		var er_site=obj.getValue();
		var params='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+er_site+'&er_type='+Ext.getCmp('er_type').getValue()+'&application_user_details_report=true';
		var urlstr='/final/reporter/ErCtxApplicationReportJson.jsp';
		 Ext.Ajax.request({
            url: urlstr,
            params: params,
            method: "POST",
            success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				var component;
				component=Ext.getCmp('er_compType');
				component.getStore().loadRawData(jsonData.componentTypeCombo);
				component.setValue(jsonData.selectedComponentType);
				var er_type=Ext.getCmp('er_type').getValue();
				
				if (er_type=='Yes')
				{
					component=Ext.getCmp('select_testmes');
					component.getStore().loadRawData(jsonData.measureCombo);
					component.setValue(jsonData.selectedMeasure);
					component.show();
 					Ext.getCmp('egcomponent').hide();
				}
				else
				{
					Ext.getCmp('select_testmes').hide();
					component = Ext.getCmp("er_server");
 					component.getStore().loadRawData(jsonData.serverCombo);
					component.setValue(jsonData.selectedServer);
 					component = Ext.getCmp("er_application");
					component.getStore().loadRawData(jsonData.applnCombo);
					component.setValue(jsonData.selectedAppln);
					Ext.getCmp('egcomponent').show();

				}
				
			}
		});
	},
	filterMultiselect: function (obj) 
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var compId = obj.getId();
		if(compId=='compSearch')
		{
			compStore = appConstants.rawDataForComponents;
			compName='er_server';
		}
		else if(compId=='appSearch')
		{
			compStore = appConstants.rawDataForApplication;
			compName='er_application';
		}
		else if(compId=='compSearch_geo')
		{
			compStore = appConstants.geoFilterCombo;
			compName='er_geoFilter';
		}
		obj.toggleTriggger();
	   appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
    },
	changeEr_mode: function (combo) {
		var from_schModify='';
		var favorite_id='';
		favorite_id=appConstants.publicjsonDataDetails['hiddenfields']["favorite_id"];
		from_schModify=appConstants.publicjsonDataDetails['hiddenfields']["fromScheduleModify"];
		
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
			duration: 250,
			to: {
				y: -530
			}
        });
		this.showResult();
     },
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  '';
			hiddenFields=appConstants.publicjsonDataDetails['hiddenfields'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveFavorite();
		}
    },
	compTypeOnChange: function() {
		console.log('<<<< compTypeOnChange >>>>>>>>>');
        Ext.getCmp("resultPanel").hide();
 		var url;
		var er_option=Ext.getCmp('er_option').getValue();
		var params='er_option='+er_option+'&er_compType='+Ext.getCmp('er_compType').getValue();
 		if (er_option=='Zone')
		{
			params+="&select_farm=" + Ext.getCmp("select_farm").getValue();
		}
		else
		{
			params+="&er_site="+Ext.getCmp("er_site").getValue();
 		}
		
	
			url = "/final/reporter/ErCtxApplicationReportJson.jsp";
			params+='&er_type='+Ext.getCmp('er_type').getValue();

	   Ext.Ajax.request({
            url: url,
            params: params,
            scope: this,
            method: "POST",
            success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataDe=jsonData;
				var mainForm =Ext.getCmp('mainform').getForm();
               
                    if (mainForm.findField("er_type").getValue() == "No")
                    {

                        if (appConstants.publicjsonDataDe.hasOwnProperty('workerGroupCombo'))
                        {
                            comboRawData = appConstants.publicjsonDataDe.workerGroupCombo;
                            selectedComboOption = appConstants.publicjsonDataDe.selectedWorkergroup;
                            comboObject = mainForm.findField("er_workgrpname");
                            comboObject.getStore().loadRawData(comboRawData);
                            if (!Ext.isEmpty(selectedComboOption)) {
                                comboObject.setValue(selectedComboOption);
                            } else {
                                comboObject.setValue(comboRawData[0].valueField);
                            }
                            comboObject.resumeEvents();
                            comboObject.show();
                        }
                        else
                        {
                            comboObject = mainForm.findField("er_workgrpname");
                            comboObject.hide();
                        }
                        comboRawData = appConstants.publicjsonDataDe.serverCombo;
                        selectedComboOption = appConstants.publicjsonDataDe.selectedServer;
						comboObject = Ext.getCmp("er_server");
						comboObject.getStore().loadRawData(comboRawData);
						appConstants.rawDataForComponents = comboRawData;
                         if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }

                        comboRawData = appConstants.publicjsonDataDe.applnCombo;
                        selectedComboOption = appConstants.publicjsonDataDe.selectedAppln;
                        comboObject = Ext.getCmp("er_application");
						appConstants.rawDataForApplication=comboRawData;
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }

						console.log('<< i am comp change >>');
                    }
                    else
                    {
                        if (appConstants.publicjsonDataDe.hasOwnProperty('workerGroupCombo'))
                        {
                            comboRawData = appConstants.publicjsonDataDe.workerGroupCombo;
                            selectedComboOption = appConstants.publicjsonDataDe.selectedWorkergroup;
                            comboObject = mainForm.findField("er_workgrpname");
                            comboObject.getStore().loadRawData(comboRawData);
                            if (!Ext.isEmpty(selectedComboOption)) {
                                comboObject.setValue(selectedComboOption);
                            } else {
                                comboObject.setValue(comboRawData[0].valueField);
                            }
                            comboObject.resumeEvents();
                            comboObject.show();
                        }
                        else
                        {
                            comboObject = mainForm.findField("er_workgrpname");
                            comboObject.hide();
                        }

                        comboRawData = appConstants.publicjsonDataDe.measureCombo;
                        selectedComboOption = appConstants.publicjsonDataDe.selectedMeasure;
                        comboObject = mainForm.findField("select_testmes");
                        //comboObject.setFieldLabel(f["reporter.thin.Measure"]);
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                    }
                
            }
        });
    },
	zoneOnChange: function() {
				console.log('<<<< zoneOnChange >>>>>>>>>');

        Ext.getCmp("resultPanel").hide();
		var mainForm =Ext.getCmp('mainform').getForm();
        var url;
 		var zoneval=mainForm.findField("select_farm").getValue();
 		var er_optionVal=mainForm.findField("er_option").getValue();
		
		if(zoneval!='-1')
		{		

				if (mainForm.findField("er_type").getValue() != null) {
					url = "/final/reporter/ErCtxApplicationReportJson.jsp?select_farm=" + zoneval + "&er_type=" + mainForm.findField("er_type").getValue()+"&er_option="+er_optionVal+'&application_user_details_report=true';
				} else {
					return;
				}
			
			Ext.Ajax.request({
				url: url,
 				scope: this,
				method: "GET",
				success: function(response) {
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicjsonDataDe=jsonData;
					var globalScreenLabel = appConstants.publicjsonDataDe.screenLabels;

				comboRawData = appConstants.publicjsonDataDe.componentTypeCombo;
				selectedComboOption = appConstants.publicjsonDataDe.selectedComponentType;
				comboObject = mainForm.findField("er_compType");
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				var rtype=mainForm.findField('er_type').getValue();
				if(rtype == 'No'){
					comboRawData = appConstants.publicjsonDataDe.serverCombo;
					selectedComboOption = appConstants.publicjsonDataDe.selectedServer;
					comboObject = Ext.getCmp("er_server");
					var objLabel = Ext.getCmp("multiSelectLabel");
					objLabel.setText(globalScreenLabel["reporter.common.Server"]);
					// comboObject.setFieldLabel(globalScreenLabel["reporter.common.Server"]);
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
					 comboRawData = appConstants.publicjsonDataDe.applnCombo;
					 selectedComboOption = appConstants.publicjsonDataDe.selectedAppln;
					comboObject = Ext.getCmp("er_application");
					appConstants.rawDataForApplication=comboRawData;
			   //     comboObject.setFieldLabel(globalScreenLabel["reporter.thin.Application"]);
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
				
				}
			});
		}
	},
	serverOnChange: function(obj,newValue,oldValue) {
		
		if(oldValue==undefined || oldValue=='undefined')
		  return;
	
	var mainForm =Ext.getCmp('mainform').getForm();
	var compArr = Ext.getCmp("er_server").getValue();
	if(mainForm.findField("er_type").getValue() == null || mainForm.findField("er_type").getValue()==undefined)
		return;
	if(compArr==null || compArr=='' || compArr.length==0)
		return;
       var url = "/final/reporter/ErCtxApplicationReportJson.jsp?select_farm=" + Ext.getCmp("select_farm").getValue() + "&er_type=" + Ext.getCmp("er_type").getValue();
       this.servereOnChangeQueryString();
        Ext.Ajax.request({
            url: url,
            params: appConstants.queryString,
            scope: this,
            method: "POST",
            success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
                comboRawData = jsonData.applnCombo;
                selectedComboOption = jsonData.selectedAppln;
                comboObject = Ext.getCmp("er_application");
				appConstants.rawDataForApplication=comboRawData;
                comboObject.getStore().loadRawData(comboRawData);
                if (!Ext.isEmpty(selectedComboOption)) {
                    comboObject.setValue(selectedComboOption);
                } else {
                    comboObject.setValue(comboRawData[0].valueField);
                }
            }
        });

    },
	reportTypeOnChange: function() {
								console.log('<<<< reportTypeOnChange >>>>>>>>>');

         Ext.getCmp("resultPanel").hide();
		var mainForm =Ext.getCmp('mainform').getForm();
        var report_type = mainForm.findField("er_type").getValue();
        var url = "/final/reporter/ErCtxApplicationReportJson.jsp?&er_type=" + mainForm.findField("er_type").getValue() + "&er_compType=" + mainForm.findField("er_compType").getValue();
		
		var er_option=mainForm.findField("er_option").getValue();
		url+="&er_option=" + er_option;
		if (er_option=='Zone')
		{
			url+="&select_farm=" + mainForm.findField("select_farm").getValue();
		}
		else
		{
			url+="&er_site=" + mainForm.findField("er_site").getValue();
		}

        Ext.Ajax.request({
            url: url,
            scope: this,
            method: "GET",
            success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
                var screenLabels = jsonData.screenLabels;
                appConstants.publicjsonDataDetails = jsonData;
                if (report_type == "No") {
                     mainForm.findField("select_testmes").hide();
                    mainForm.findField("er_mode").hide();

                    if (jsonData.hasOwnProperty('componentTypeCombo'))
                    {		
                        comboRawData = jsonData.componentTypeCombo;
                        selectedComboOption = jsonData.selectedComponentType;

                        comboObject = mainForm.findField("er_compType");
                        comboObject.setFieldLabel(screenLabels["reporter.common.Component Type"]);
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                        comboObject.show();
                    }

                    if (jsonData.hasOwnProperty('workerGroupCombo'))
                    {	//alert('workerGroupCombo');
                        comboRawData = jsonData.workerGroupCombo;
                        selectedComboOption = jsonData.selectedWorkergroup;
                        comboObject = mainForm.findField("er_workgrpname");
                        comboObject.setFieldLabel(screenLabels["reporter.thin.Worker Group"]);
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                        comboObject.show();
                    }
                    else
                    {
                        mainForm.findField("er_workgrpname").hide();
                    }

                    comboRawData = jsonData.serverCombo;
                    selectedComboOption = jsonData.selectedServer;
                    comboObject = Ext.getCmp("er_server");
                    var objLabel = Ext.getCmp("multiSelectLabel");
                    objLabel.setText(screenLabels["reporter.common.Server"]);
 					 appConstants.rawDataForComponents=comboRawData;
                    comboObject.getStore().loadRawData(comboRawData);
                    if (!Ext.isEmpty(selectedComboOption)) {
                        comboObject.setValue(selectedComboOption);
                    } else {
                        comboObject.setValue(comboRawData[0].valueField);
                    }
 					
                    comboRawData = jsonData.applnCombo;
                    selectedComboOption = jsonData.selectedAppln;
                    comboObject = Ext.getCmp("er_application");
					appConstants.rawDataForApplication=comboRawData;
              //      comboObject.setFieldLabel(screenLabels["reporter.thin.Application"]);
                    comboObject.getStore().loadRawData(comboRawData);
                    if (!Ext.isEmpty(selectedComboOption)) {
                        comboObject.setValue(selectedComboOption);
                    } else {
                        comboObject.setValue(comboRawData[0].valueField);
                    }
                    comboObject.show();
 					 Ext.getCmp("egcomponent").show();
                 } 
				else 
				{
                     if (jsonData.hasOwnProperty('componentTypeCombo'))
                    {		 
                        comboRawData = jsonData.componentTypeCombo;
                        selectedComboOption = jsonData.selectedComponentType;
                        comboObject = mainForm.findField("er_compType");
                        comboObject.setFieldLabel(screenLabels["reporter.common.Component Type"]);
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                        comboObject.show();
                    }

                    if (jsonData.hasOwnProperty('workerGroupCombo'))
                    {	//alert('workerGroupCombo');
                        comboRawData = jsonData.workerGroupCombo;
                        selectedComboOption = jsonData.selectedWorkergroup;
                        comboObject = mainForm.findField("er_workgrpname");
                        comboObject.setFieldLabel(screenLabels["reporter.thin.Worker Group"]);
                        comboObject.getStore().loadRawData(comboRawData);
                        if (!Ext.isEmpty(selectedComboOption)) {
                            comboObject.setValue(selectedComboOption);
                        } else {
                            comboObject.setValue(comboRawData[0].valueField);
                        }
                        comboObject.show();
                    }
                    else
                    {
                        mainForm.findField("er_workgrpname").hide();
                    }

   		    //Ext.getCmp("multiselectpanel1").hide();
                   Ext.getCmp("egcomponent").hide();
                 //  Ext.getCmp("er_application").hide();
                    mainForm.findField("er_mode").hide();
                    mainForm.findField("select_testmes").show();
                }
            }
        });
     },
		
	LoadFieldsForActivity: function() {
		console.log('<<<<<<<< LoadFieldsForActivity >>>>>>>>>>>>>>');
        var url = "/final/reporter/ErCtxApplicationReportJson.jsp";
		var mainForm =Ext.getCmp('mainform').getForm();
        Ext.Ajax.request({
            url: url,
            scope: this,
            method: "POST",
            success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
                appConstants.publicjsonDataDetails = jsonData;
                this.getMain().setTitle(jsonData.reportTitle);
                this.fillFormFieldsForActivity(jsonData);
                mainForm.findField("er_type").show();
                mainForm.findField("select_testmes").show();
                mainForm.findField("er_mode").show();
		if(Ext.getCmp("er_excwe")!=undefined)
		 	Ext.getCmp("er_excwe").show();
                mainForm.findField("er_type").setValue("Yes");
                mainForm.findField("er_compType").show();
				if (jsonData.hasOwnProperty('workerGroupCombo'))
                {
					mainForm.findField("er_workgrpname").show();
				}
				else
				{
					mainForm.findField("er_workgrpname").hide();
				}
           //     mainForm.findField("componentMultiSelect").show();
           //     Ext.getCmp("er_application").show();
             }
        });
    },
	saveReportAsPDF:function(){
		var saveQString;
			saveQString=appConstants.publicjsonDataDetails.saveQString;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataDetails.selectedreportType == 'No')
				saveQString+="&pageWidthProces=1024&er_view=PRINT";
		
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString;
		var islegendEnabled = false;
		if(Ext.getCmp('showLegend')!=undefined){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
				var setLegendVal = "&showLegend="+islegendEnabled;
				if(s_qryString.indexOf(setLegendVal)==-1){
					if(s_qryString.indexOf("&showLegend=")>-1){
						if(islegendEnabled.toString() =='true'){
							s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
						}else{
							s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
						}
					}else
						s_qryString+=setLegendVal;
				}
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		  s_qryString=this.getGridColSortParam(s_qryString);
		appConstants.erUtils.savePDF(s_qryString);
	},
		getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);

			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}

		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	printReport:function(){
		var s_qryString;

			var saveQString=appConstants.publicjsonDataDetails.saveQString;
			s_qryString = "../servlet/com.eg.ErCtxServerReportC?"+saveQString
				+"printGraph=yes&pdfPrint=yes";
			if(appConstants.publicjsonDataDetails.selectedreportType == 'No')
				s_qryString+="&er_view=PRINT";

		console.log('s_qryString:print:>>>'+s_qryString);
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(){
		var mainForm =Ext.getCmp('mainform').getForm();
		var isValid = this.validateMainForm(false);
		if( isValid && mainForm.findField('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}

		if(isValid){
			var s_qryString;
				this.updateQueryString();
				var rtype=mainForm.findField('er_type').getValue();
				if(rtype == 'Yes'){
					s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryString;
					s_qryString+="&er_server=-1&er_application=-1&er_sortby=-1&showTopusers="+appConstants.publicjsonDataDetails.showTopusers;
				}
				else{
					s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryString+"&showTopusers="+appConstants.publicjsonDataDetails.showTopusers;
				}
			
			
			var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			console.log('schedule::>>'+target);

		if (appConstants.formButtonId=='save')
			document.location=target+'&showSchWindow=no';
		else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


		}
		else
			return
	},
	saveFavorite:function(){
		var isValid = this.validateMainForm(false);

		var mainForm =Ext.getCmp('mainform').getForm();
		/* if(isValid && mainForm.findField('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		if(isValid){
			var s_qryString;

				this.updateQueryString();
				var rtype=mainForm.findField('er_type').getValue();
				if(rtype == 'Yes'){
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryString+"&er_sortby=-1&er_server=-1&er_application=-1&cmd=client";
				}
				else{
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryString+"&cmd=client";
				}
			
			

			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save'){
				
		  
				document.location=target+'&showWindow=no'+'&FavoriteId='+appConstants.favorite_id;
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp





		}
		else
			return;
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
			var reportType=mainForm.findField('er_type').getValue();
			if(reportType == 'No'){
				var server=mainForm.findField('er_server');
				var application=mainForm.findField('er_application');
				if( server.getValue() == '-1'){
					Ext.MessageBox.show({
					title: 'Thin Client Application',
					msg: server.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				var applicationDisplayField=application.getStore().getAt(0).get('displayField');
				if( applicationDisplayField=='Not Applicable'){
					Ext.MessageBox.show({
					title: 'Thin Client Application',
					msg: applicationDisplayField,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
		
		var jsonData;
			jsonData = appConstants.publicjsonDataDetails;
		var isSettingsOk = true;

		var hiddenFields = jsonData['hiddenfields'];

		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen=this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var er_usertimeline = '';
		if ( !Ext.isEmpty( hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);

		var timefrom =this.getSettingsFieldValue(thinclientSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Thin Client Application settings',
				msg:  appConstants.userTimelineErrorMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			var limitforbg = hiddenFields["limitforbg"];

			if(!Ext.isEmpty(limitforbg)){
			if(flag)
			{
				if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
					isSettingsOk = false;
				}
			}
			}
		}
		else{
			var reportName = thinclientSettingsForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}

		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}else
		return false;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
        var starthr = mainForm.findField('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = mainForm.findField('er_enddate').getValue();
        var endhr = mainForm.findField('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var isValid = this.validateMainForm(true);

		if(isValid)
			this.submitReport();		
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && reportgen == 'background' )
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		else if ( reportgen!=null && reportgen == 'background-csv' )
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		var obj = Ext.getCmp('geofilter');
		if (obj!=undefined && !obj.isHidden())
		{
			var compArray = Ext.getCmp("er_geoFilter").getValue();
			if(compArray==undefined || compArray.length==0)
			{
				Ext.MessageBox.show({
					title: 'Thin Client Application',
					msg: 'Please choose '+Ext.getCmp('multiSelectLabel_geo').text,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
			else if(compArray.length>1 && compArray.indexOf('all')>-1)
			{
				Ext.MessageBox.show({
					title: 'Thin Client Application',
					msg: 'All and Individual selection should not be allowed',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			this.submitReport();
		}else{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			var thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
			var reportGenType=thinclientSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					chartAttrib=Ext.decode(jsonText);
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			//alert('chartAttrib---->'+chartAttrib);
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	loadGrid:function(GridArrays)
	{
		console.log('<<< i am load grid >>>>');
		var resultPanelObj=Ext.getCmp('resultPanel');
		var mainForm =Ext.getCmp('mainform').getForm();
		var itemsArray=new Array();
		var me = this;
		if ( !Ext.isEmpty( GridArrays ) ){
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = me.getThinclientapplicationsettings().getForm();
		for(var i in GridArrays)
		{
			var gridDataObj=GridArrays[i];
			var columnDetails=gridDataObj.columns;
			var dataArraytoStore=gridDataObj.dataArray;
			var geoDataArraytoStore=gridDataObj.geoDataArray;
			var geoColumns=gridDataObj.geoColumns;
			var noOfColumns=gridDataObj.TOTAL_COLUMN_COUNT;
			var fieldstoStore =  {};
			var cnt=0;
			var mainColumnsObjArray	=  new Array();
			var gridArray = gridDataObj.tableJson
			if(gridArray==undefined || gridArray.length==0)
			{
				for( var key in columnDetails )
				{
				var mainColumn=key;
				var align='center';
  				if (key=='Application')
				{	 
					align='left';
				}
				if (key=='Component')
				{	 
					align='left';
				}
				if (key=='User Name(s)')
				{	 
					align='left';
				}

			        var flexValue=1;
				fieldstoStore[cnt]=mainColumn;
				mainColumnsObjArray.push({
					header: mainColumn,
					sortable:true,
					dataIndex: cnt,
					align:align,
					flex:flexValue,
					renderer:function(val, meta, record, rowIndex, colIndex, store){
					  val = Ext.getCmp('gridId').getDecimalAlignFormat(val);
					  return '<div style="white-space:normal !important;">'+ val +'</div>';
					},
						doSort: function(state) 
						{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2){
								v1 = v1.get(field);
								v2 = v2.get(field);
								v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
								v1= isNaN(v1) ? 0 : v1;
								v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
								v2= isNaN(v2) ? 0 : v2;
								// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					},
				});
				cnt++;
			}
			var fetchedData = function(){
				this.data = null;
				this.total = 0;
			}

			var isPagingHidden;
			if (dataArraytoStore.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;

			var fields=[];
			var colLen=Object.keys(dataArraytoStore[0]).length;
			if(geoDataArraytoStore!=undefined && geoDataArraytoStore.length>0)
			{
				var columns = '<thead><tr>';
				for(var key in geoColumns)
				{
					columns+='<th style="font-size:10px;border-bottom-width:1px;text-transform:capitalize;">'+geoColumns[key]+'</th>';
				}
				columns+='</tr></thead>';
				for(var key in geoDataArraytoStore)
				{
					var subTable = '<div width="100%" align="center" class="plainTableReporter"><table width="100%" cellpadding="0" cellspacing="0" border="0px">';
					var dataValue = geoDataArraytoStore[key];
					subTable+=columns;
					subTable+='<tbody>';
					for(var dtIndex in dataValue)
					{
						subTable+='<tr>';
						for(var index in geoColumns)
						{
							subTable+='<td style="font-size:10px;">'+dataValue[dtIndex][geoColumns[index]]+'</td>';
						}
						subTable+='</tr>';
					}
					subTable+='</tbody>'
					subTable+='</table>'
					subTable+='</div>'
					dataArraytoStore[key].app=subTable;
				}
			}
			for(var key in dataArraytoStore[0])
			{				
				fields.push(key);
			}
			var storeObj = Ext.create('Ext.data.Store', {
				fields: fields,
				dataArraytoStore:dataArraytoStore,
				proxy : {
					type : 'pagingmemory',
					data:dataArraytoStore,
					reader : {
						type: 'json', root : 'data', totalProperty : 'total'
					},
				},
				pageSize:gridPageSize,	//gridPageSize is added in ErTracker.jsp
				autoLoad : true,
				listeners : {
					beforeload : function(store, operation, eOpts){
						var page = operation.page;
						var limit = operation.limit;
						var dataArraytoStoreLen=this.dataArraytoStore.length;
						var start=(page-1)*limit;
						var totalRec=page*limit;
						fetchedData.data = dataArraytoStore;
						fetchedData.total =dataArraytoStoreLen;
						store.proxy.data = fetchedData;
					}
				}
			});
			var pages;
			var total;
			var activePage=1;
						 
			var groupingFeature = Ext.create('Ext.grid.feature.Grouping',{
				groupHeaderTpl: '{application} ({rows.length} Item{[values.rows.length > 1 ? "s" : ""]})'
			});

		/*	var gridpanel = Ext.widget('customgrid',{
				store:storeObj,
				sortableColumns:true,
				needtoFixColumn:true,
				cls:'gridSkin horizontal-scroll',
				columns:mainColumnsObjArray,
				bodyPadding:'0 0 0 0',
 				scroll:true,
				features: [groupingFeature],
				autoScroll:true,
				popUpData:'no',
				listeners:{
					sortchange:function(ct, column, e, t, eOpts ){
						me.gridColIndexParam=column.getIndex();
						me.gridColStateParam=column.sortState;
						this.getStore().load(); 
					}
				},
				dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'pagingtoolbar',
							dock: 'bottom',
							displayInfo: true,
							cls:'pagingtoolbar',
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{ 
									pages = params.pageCount;
									total = params.total;
									activePage = params.currentPage;
								}
							}
						}]
				});	*/
				//itemsArray.push(gridpanel);
				itemsArray.push({
					xtype:'panel',
					ui:'newGraphPanel',
					margin:'5 10 10 10',
					items:[{
						xtype:'customgrid',
						store:storeObj,
						id:'gridId',
						sortableColumns:true,
						//needtoFixColumn:true,
						//cls:'gridSkin horizontal-scroll',
						columns:mainColumnsObjArray,
						//bodyPadding:'0 0 0 0',
						ui:'newGridPanel',
						margin:'10 10 10 10',
						scroll:true,
						features: [groupingFeature],
						autoScroll:true,
						border:true,
						popUpData:'no',
						listeners:{
							sortchange:function(ct, column, e, t, eOpts ){
								me.gridColIndexParam=column.getIndex();
								me.gridColStateParam=column.sortState;
								this.getStore().load(); 
							}
						},
						plugins: [{
						ptype: 'rowexpander',
						selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
						expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
						expandOnEnter : false,
						collapsible: true,
						animCollapse: false,
						rowBodyTpl: [
							'<div style="padding:10px 10px 10px 0px;display:inline-block;position:relative;width:100%">{app}</div>',	
							]
						}],
						viewConfig:
						{
							stripeRows: true,
							getRowClass: function (record, rowIndex, rowParams, store)
							{
								if (record.data.app !=undefined && record.data.app.length>0)
								{
									return ;
								}
								else
								{
									return 'hidePlus';
								}
							}
						},
						dockedItems:[{
									xtype:'pagingtoolbar',
									cls:'newPagination',
									dock: 'bottom',
									displayInfo: true,
									//cls:'pagingtoolbar',
									store: storeObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying topics {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{ 
											pages = params.pageCount;
											total = params.total;
											activePage = params.currentPage;
										}
									}
								}]
							}]
					});
					itemsArray.push(gridpanel);
				}
				else
				{
					var geoModel = Ext.define('checkBoxDataModel',{
						extend:'Ext.data.Model',
						fields:[
							{name:'tableTitle', type:'string'},
							{name:'measureColumn', type:'auto'},
							{name:'measureTable', type:'auto'}
						]
					});
					var pageSize = 5;
					var datStore = new Ext.data.Store({
						fields:[{name : 'tableTitle', type :'string'},{name : 'measureColumn',type : 'array'},{name : 'measureTable',type : 'array'}],
						//model:geoModel,
						proxy : 
						{
							type : 'pagingmemory',
							reader : 
							{
								type: 'json',
								root : 'data',
								totalProperty :'total'
							}
						},
						pageSize:pageSize,
						data : gridArray,
						autoLoad : true,
					});
					var hidePageing = true;
					if(gridArray.length>pageSize)
					{
						hidePageing = false;
					}
					var xtemplatePanel = Ext.widget('panel',{
						bodyPadding:'0',
						frame:false,
						titleAlign:'left',
						title:'Applications User Details',
						ui:'newGraphPanel',
						margin:'0 10 10 10',
						dockedItems: [{
							dock: 'bottom',
							xtype : 'pagingtoolbar',
							cls:'pagingtoolbar',
							hidden:hidePageing,
							dock: 'bottom',
							store: datStore,
							displayInfo: false
						}],
						items:[
						{
							xtype:'dataview',
							autoScroll : true,
							store: datStore,
							padding:'10 10 0 10',
							tpl:new Ext.XTemplate(
							'<div class="">',
								'<tpl for=".">',
									'<div>',
									'<table width="100%">',
										'<tr>',
											'<td>',
												'<tpl if="xindex===1">',
													'<div class="newTable" style="margin-bottom:10px">',
												'<tpl else>',
													'<div class="newTable"  style="margin-bottom:10px">',
												'</tpl>',
												'<div style="padding:5px 0px 5px 10px;margin-bottom:-1px" class="x-table-border newFont_bold14">{tableTitle}</div>',
												'<table cellspacing="0" cellpadding="0" border="0" width="100%">',
													'<thead>',
													'<tr>',
														'<tpl for="measureColumn">',
														'<th><div style="overflow:visible;text-align:left">{.}</div></th>',
														'</tpl>',
													'</tr>',
													'</thead>',
													'<tbody>',
													'<tpl for="measureTable">',
														'<tr>',
															'<tpl for=".">',
																'<td><div style="text-align: left">{.}</div</td>',
															'</tpl>',
														'</tr>',
													'</tpl>',
													'</tbody>',
												'</table>',
												'</div>',
											'</td>',
										'</tr>',
									'</table></div>',
								'</tpl>',
						'	</div>',
							'<div style="both:clear"></div>'
							),
							itemSelector: 'x-grid-table'
							}]
					});
					itemsArray.push(xtemplatePanel);
				}
			}
		
			resultPanelObj.removeAll();
			resultPanelObj.add(itemsArray);
			resultPanelObj.show();
			resultPanelObj.doLayout();
		}
	},
	loadReportData:function(jsonData){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var me=this;
		var reportData=jsonData.reportData;
		var dataAvailable=false;
			if(jsonData.hasOwnProperty('reportData')){
				var reportType=jsonData.selectedreportType;
				 if(reportType == 'No'){
 					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
 					Ext.getCmp("csvTool").setDisabled(false);
					appConstants.publicGridData=reportData.gridArray;
					this.loadGrid(appConstants.publicGridData);
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
 				}
			}
			else{
				this.disableTools();
				resultPanelObj.hide();
				this.getNomeasurepanel().doLayout();
				this.getNomeasurepanel().show();
			}
		
	},
	submitReport:function(){
		if(!isSettingsEnabled)
			this.showConfigDropdown();
 		var url;
		var backgroundUrl;
		var Qstring;
		var reportGenerted=Ext.getCmp('reportGeneration').getValue();
		var mainForm =Ext.getCmp('mainform').getForm();
			var rtype=mainForm.findField('er_type').getValue();
		
				url="../servlet/com.eg.ErCtxServerReportC?isSubmit=true&responseType=json";
				if(reportGenerted == 'background')
				{
					backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";
				}
				else if (reportGenerted == 'background-csv')
				{
					backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json&isSubmit=true&SaveFormat=CSV";
				}
				appConstants.queryString+="&er_server="+mainForm.findField('er_server').getValue();
			
			this.updateQueryString();
			Qstring=appConstants.queryString;
		
	
		var resultPanelObj=Ext.getCmp('resultPanel');
 		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();

		var reportGeneration=this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var reportType='';
 		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
 	Qstring += '&er_RmDispName='+appConstants.er_RmDispName;
 	Qstring += '&application_user_details_report=true';
	


var groupByComponent = Ext.getCmp('groupByComponent').getValue();

	Qstring += '&group_by_component='+groupByComponent.groupByComponent;

//console.log('Qstring::>>'+Qstring);
//
		if(reportGeneration == 'foreground'){
 			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicjsonDataDetails=jsonData;
					this.loadReportData(jsonData);
				}
			});
		}
		else if(reportGeneration == 'background' || reportGeneration == 'background-csv'){
			resultPanelObj.hide();
 			var htmlStr = '';
			var me=this;
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
				//scope:this,
				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					publicjsonData=jsonData;
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
 						}
						else if(backgroundReportStatus== 'duplicate'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						htmlStr = '<span>ErroR In BackGround Generation</span>';
					}
					me.getBackGroundPanel().update(htmlStr);
 					me.getBackGroundPanel().show();
 				}
			});
		}

	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
		var reportGenType=thinclientSettingsForm.findField('reportGeneration').getValue();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
		if(reportGenType== 'background')
		{
			thinclientSettingsForm.findField('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(reportGenType== 'background-csv')
		{
			thinclientSettingsForm.findField('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	timeLineOnChange:function() {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startDateObj=mainForm.findField('er_stdate');
		var startHrObj=mainForm.findField('er_sthr');
		var endDateObj=mainForm.findField('er_enddate');
		var endHrObj=mainForm.findField('er_endhr');
		var timelineObj=mainForm.findField('er_timeline');
		if(timelineObj.getValue() == 'Any'){
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else{
		timelineObj.suspendEvents(true);
		//this.loadHiddenFields(publicjsonData['hiddenfields']);
		this.updateQueryString();
		Ext.Ajax.request(
		{
			url : '/final/reporter/ErCtxApplicationReportJson.jsp',
			params : appConstants.queryString,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataDetails=jsonData;
				var start_hour=jsonData.startHour;
				var end_hour=jsonData.endHour;
				var start_date=jsonData.startDate;
				var end_date=jsonData.endDate;
				startDateObj.setDisabled(true);
				startHrObj.setDisabled(true);
				endDateObj.setDisabled(true);
				endHrObj.setDisabled(true);
				startDateObj.setValue(start_date);
				startHrObj.setValue(start_hour);
				endDateObj.setValue(end_date);
				endHrObj.setValue(end_hour);
			}
		});
		timelineObj.resumeEvents();
		}
	},
	weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataDetails.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},
	loadTools : function(){
				console.log('<< my -4 >>>');

		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false, true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQueryString:function()
	{
		var FormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();

		var reportType = mainForm.findField('er_type').getValue();
		FormParams="select_farm="+mainForm.findField('select_farm').getValue()
					+"&er_type="+reportType
					+"&er_excwe="+this.getSettingsFieldValue(thinclientSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')
					+"&er_reportgenration="+this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');

			var obj = Ext.getCmp('geofilter');
			if (obj!=undefined && !obj.isHidden())
			{
				var compArray = Ext.getCmp("er_geoFilter").getValue();
				if(!isSettingsEnabled)
				{
					compArray = appConstants.publicjsonDataDetails.selectedgeoFilter;
				}
				if(compArray!=null && compArray!='undefined' && compArray.length>0)
				{
					for(var k=0;compArray.length>k;k++)
					{
						FormParams+="&filterValue="+compArray[k];
					}
				}
				else
				{
					FormParams+="&filterValue=all";
				}
			}
			var erOption=Ext.getCmp('er_option');
			if(erOption!=undefined)
				{
				FormParams+="&er_option="+erOption.getValue();

				 if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
					{
					 var erSite=Ext.getCmp('er_site');
					FormParams+="&er_site="+erSite.getValue();
					}
				}
			//

		if(reportType == 'Yes')
		{
			FormParams+="&select_testmes=" + mainForm.findField("select_testmes").getValue() + "&er_compType=" + mainForm.findField("er_compType").getValue() + "&er_mode=" + mainForm.findField("er_mode").getValue();
		}
		else
		{
			var s_server=mainForm.findField('er_server').getValue();
			var compArray=mainForm.findField('er_server').getValue();
			var appArray=mainForm.findField('er_application').getValue();
			if(compArray!=null && compArray!='undefined' && compArray.length>0){
				for(var k=0;compArray.length>k;k++)
				{
					FormParams+="&er_workgroupserver="+compArray[k];
				}
			}
			if(appArray!=null && appArray!='undefined' && appArray.length>0){
				for(var k=0;appArray.length>k;k++)
				{
					FormParams+="&er_application="+appArray[k];
				}
			}
			FormParams+="&er_compType=" + mainForm.findField("er_compType").getValue() + "&er_sortby=-1";

	//	if(s_server ==undefined || s_server=="-1" || s_server.indexOf("All")>-1)

		if(compArray ==undefined || compArray=="-1" || compArray.indexOf("All")>-1 || compArray.length>0)
		FormParams+="&er_server="+mainForm.findField('er_server').getValue();;

		}

var timefrom =this.getSettingsFieldValue(thinclientSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
var minfrom =this.getSettingsFieldValue(thinclientSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
var timeto =this.getSettingsFieldValue(thinclientSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
var minto =this.getSettingsFieldValue(thinclientSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		var timperiodParams="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;

		if(appConstants.publicjsonDataDetails.hasOwnProperty('hiddenfields')){
			var hiddenFields = appConstants.publicjsonDataDetails.hiddenfields;
			for (var hiddenField in hiddenFields){
				//alert(hiddenField);
				//alert(hiddenFields[hiddenField]);
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}

		var workgroup;
        if (appConstants.publicjsonDataDetails.hasOwnProperty("selectedWorkergroup"))
        {
            workgroup = "&er_workgrpname=" + appConstants.publicjsonDataDetails.selectedWorkergroup;
            appConstants.queryString = FormParams+timelineParams+hiddenfieldQString+timperiodParams + workgroup;
        }
        else
        {
           appConstants.queryString=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
        }

		appConstants.queryString += '&application_user_details_report=true';
	

		if(Ext.getCmp('groupByComponent')!=undefined)
		{
		var groupByComponent = Ext.getCmp('groupByComponent').getValue();
		appConstants.queryString += '&group_by_component='+groupByComponent.groupByComponent;
		}
		appConstants.queryString +='&csvNameByRow='+appConstants.csvNameByRow;


		//alert('appConstants.queryString---->'+appConstants.queryString);
	},
		servereOnChangeQueryString:function(){
		var FormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
		var reportType = mainForm.findField('er_type').getValue();
		FormParams="select_farm="+mainForm.findField('select_farm').getValue()
					+"&er_type="+reportType
					+"&er_excwe="+this.getSettingsFieldValue(thinclientSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')
					+"&er_reportgenration="+this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
			//
			var erOption=Ext.getCmp('er_option');
			if(erOption!=undefined)
				{
				FormParams+="&er_option="+erOption.getValue();
				 if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
					{
					 var erSite=Ext.getCmp('er_site');
					FormParams+="&er_site="+erSite.getValue();
					}
				}
			//
		if(reportType == 'Yes')
		{
			FormParams+="&select_testmes=" + mainForm.findField("select_testmes").getValue() + "&er_compType=" + mainForm.findField("er_compType").getValue() + "&er_mode=" + mainForm.findField("er_mode").getValue();
		}
		else
		{
			var s_server=mainForm.findField('er_server').getValue();
			var compArray=mainForm.findField('er_server').getValue();
			var appArray=mainForm.findField('er_application').getValue();
			if(compArray!=null && compArray!='undefined' && compArray.length>0){
				for(var k=0;compArray.length>k;k++)
				{
					FormParams+="&er_workgroupserver="+compArray[k];
				}
			}
			if(appArray!=null && appArray!='undefined' && appArray.length>0){
				for(var k=0;appArray.length>k;k++)
				{
					FormParams+="&er_application="+appArray[k];
				}
			}
			FormParams+="&er_compType=" + mainForm.findField("er_compType").getValue() + "&er_sortby=-1";
		if(compArray ==undefined || compArray=="-1" || compArray.indexOf("All")>-1 || compArray.length>0)
		FormParams+="&er_server="+mainForm.findField('er_server').getValue();;
		}
		if(appConstants.publicjsonDataDetails.hasOwnProperty('hiddenfields')){
			var hiddenFields = appConstants.publicjsonDataDetails.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		var workgroup;
        if (appConstants.publicjsonDataDetails.hasOwnProperty("selectedWorkergroup"))
        {
            workgroup = "&er_workgrpname=" + appConstants.publicjsonDataDetails.selectedWorkergroup;
            appConstants.queryString = FormParams+hiddenfieldQString + workgroup;
        }
        else
        {
           appConstants.queryString=FormParams+hiddenfieldQString;
        }
		appConstants.queryString += '&application_user_details_report=true';
		if(Ext.getCmp('groupByComponent')!=undefined)
		{
		var groupByComponent = Ext.getCmp('groupByComponent').getValue();
		appConstants.queryString += '&group_by_component='+groupByComponent.groupByComponent;
		}
		appConstants.queryString +='&csvNameByRow='+appConstants.csvNameByRow;
	},
	afterMainRender:function(){
		console.log('<< my -1 >>>');

		var thisController = this;
			this.refreshReportData(appConstants.publicjsonDataDetails);
		
	},
	loadFormElements:function() {
				console.log('<< my -2 >>>');
		Ext.getCmp('showLegend').hide();
		registerAjaxEvents();
		var mainForm =Ext.getCmp('mainform').getForm();
		if(targetType == 'Application User Details')
			Ext.getCmp('showLegend').hide();

			if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
				this.getMain().setTitle(appConstants.er_RmDispName);
			else
				this.getMain().setTitle(appConstants.publicjsonDataDetails.reportTitle);
			this.fillFormFieldsForActivity(appConstants.publicjsonDataDetails);
			//this.refreshReportData(publicjsonDataActivity);
			if(!hideBackButton){
				Ext.getCmp('thinclientapplicationform').add(
					{
						xtype: 'hidden',
						id: 'ID',
						name: 'ID',
						value: appConstants.publicjsonDataDetails['ID']
					}
				);
			}
		
		var report_type = mainForm.findField("er_type").getValue();
		if(targetType == 'Application User Details' || targetType == 'Application Report'){
			if(report_type=='Yes'){
				Ext.getCmp('egcomponent').hide();
			}			else{
				Ext.getCmp('egcomponent').show();
			}
		}
		else
		{
				//Ext.getCmp("multiselectpanel1").hide();
		}

			jsonData = appConstants.publicjsonDataDetails;

		 var screenLabels = jsonData.screenLabels;
		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		
		var er_option=mainForm.findField('er_option');
 		er_option.getStore().loadRawData(jsonData.analysisByCombo);
		if (!Ext.isEmpty(jsonData.selectedAnalysisByCombo))
		{
			er_option.setValue(jsonData.selectedAnalysisByCombo);
		}
		else
		{
			if(jsonData.analysisByCombo!=undefined)
			er_option.setValue(jsonData.analysisByCombo[0].valueField);
		}

		var start_hour = jsonData.startHour;
        var end_hour = jsonData.endHour;
        var start_date = jsonData.startDate;
        var end_date = jsonData.endDate;
        var startDateObj = mainForm.findField('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = start_date;
        var startHrObj = mainForm.findField('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = start_hour;
        var endDateObj = mainForm.findField('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = end_date;
        var endHrObj = mainForm.findField('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = end_hour;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;
	},
	refreshReportData:function(jsonData){
		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
 	 		this.loadReportData(jsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	fillFormFieldsForActivity: function(jsonData) {
		


       	var comboRawData;
		var selectedComboOption;
		var comboObject;
        var isSubmitted="false";
		var mainForm =Ext.getCmp('mainform').getForm();
        if (jsonData.hasOwnProperty("isSubmit")) {
            var isSubmitted = jsonData.isSubmit;
        }
        var hiddenFields = appConstants.publicjsonDataDetails.hiddenfields;
         var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
         if (from_schedule != null && from_schedule == "Yes" || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
            Ext.getCmp("submit").hide();
            Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
        } else {
            Ext.getCmp("submit").show();
            Ext.getCmp("save").hide();
        }

        var screenLabels = jsonData.screenLabels;
        appConstants.globalScreenLabels = jsonData.screenLabels;
		var selectedAnalysisByCombo='';
		if (jsonData.hasOwnProperty('selectedAnalysisByCombo'))
		{
				selectedAnalysisByCombo=jsonData.selectedAnalysisByCombo;
		}
		if(selectedAnalysisByCombo=='Zone')
		{
		Ext.getCmp('er_site').hide();
        comboRawData = jsonData.zoneCombo;
        selectedComboOption = jsonData.selectedZone;
        comboObject = mainForm.findField("select_farm");
        comboObject.setFieldLabel(screenLabels["reporter.consolidated.Zone"]);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
		}

		else if(selectedAnalysisByCombo=='Segment')
			{
				Ext.getCmp('select_farm').hide();
		 comboRawData = jsonData.siteCombo;
        selectedComboOption = jsonData.selectedSiteCombo;
        comboObject = mainForm.findField("er_site");
        comboObject.setFieldLabel('Segment');
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
		comboObject.show();
			}

			else if(selectedAnalysisByCombo=='Service')
			{
					Ext.getCmp('select_farm').hide();
		 comboRawData = jsonData.siteCombo;
        selectedComboOption = jsonData.selectedSiteCombo;
        comboObject = mainForm.findField("er_site");
        comboObject.setFieldLabel('Service');
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
		comboObject.show();
			}
			else if(selectedAnalysisByCombo=='Component')
			{
					Ext.getCmp('select_farm').hide();
					Ext.getCmp('er_site').hide();
			}else{
				if (jsonData.hasOwnProperty('zoneCombo')){
		            comboRawData = jsonData.zoneCombo;
					 var selectedZone = jsonData.selectedZone;
                     comboObject = mainForm.findField("select_farm");
                     comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedZone)) {
						comboObject.setValue(selectedZone);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
						comboObject.show();
				}	
			}
        if (jsonData.hasOwnProperty('componentTypeCombo'))
        {		//alert('componentTypeCombo');
            comboRawData = jsonData.componentTypeCombo;
            selectedComboOption = jsonData.selectedComponentType;
            comboObject = mainForm.findField("er_compType");
            comboObject.setFieldLabel(screenLabels["reporter.common.Component Type"]);
            comboObject.getStore().loadRawData(comboRawData);
            if (!Ext.isEmpty(selectedComboOption)) {
                comboObject.setValue(selectedComboOption);
            } else {
                comboObject.setValue(comboRawData[0].valueField);
            }
            comboObject.show();
        }

        if (jsonData.hasOwnProperty('workerGroupCombo'))
        {	//('workerGroupCombo');
            comboRawData = jsonData.workerGroupCombo;
            selectedComboOption = jsonData.selectedWorkergroup;
            e = mainForm.findField("er_workgrpname");
            e.setFieldLabel(screenLabels["reporter.thin.Worker Group"]);
            e.getStore().loadRawData(comboRawData);
            if (!Ext.isEmpty(selectedComboOption)) {
                e.setValue(selectedComboOption);
            } else {
                e.setValue(comboRawData[0].valueField);
            }
            e.show();
        }
        else
        {
            mainForm.findField("er_workgrpname").hide();
        }



        comboRawData = jsonData.reportTypeCombo;
        selectedComboOption = 'No';
		console.log('<<<<<< comboRawData>>>>>>>>'+comboRawData);
		console.log('<<<<<< selectedComboOption>>>>>>>>'+selectedComboOption);
        comboObject = mainForm.findField("er_type");
        comboObject.setFieldLabel(screenLabels["reporter.thin.Report Type"]);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue('No');
        }
		//
		comboObject.hide();
		//
console.log('<<<<<< i am here 5555 66>>>>>>>>');
        if (selectedComboOption == "No") {
            Ext.getCmp("select_testmes").hide();
            Ext.getCmp("er_mode").hide();


            comboRawData = jsonData.serverCombo;
            selectedComboOption = jsonData.selectedServer;
            comboObject = Ext.getCmp("er_server");
            var objField =Ext.getCmp("egcomponent");
            //var objLabel = Ext.getCmp("multiSelectLabel");
            //objLabel.setText(screenLabels["reporter.common.Server"]);
            // comboObject.setFieldLabel(f["reporter.common.Server"]);
            comboObject.getStore().loadRawData(comboRawData);
            if (!Ext.isEmpty(selectedComboOption)) {
                comboObject.setValue(selectedComboOption);
            } else {
                comboObject.setValue(comboRawData[0].valueField);
            }
            objField.show();
            //comboObject.show();
		//	console.log('<<< selectedComboOption:1: >>>'+selectedComboOption);
 	   if(selectedComboOption!=null && selectedComboOption!='undefined')
	   {
            }
            comboRawData = jsonData.applnCombo;
            selectedComboOption = jsonData.selectedAppln;
            comboObject = Ext.getCmp("er_application");
 	    appConstants.rawDataForApplication=comboRawData;
         //   comboObject.setFieldLabel(screenLabels["reporter.thin.Application"]);
            comboObject.getStore().loadRawData(comboRawData);
            if (!Ext.isEmpty(selectedComboOption)) {
                comboObject.setValue(selectedComboOption);
            } else {
                comboObject.setValue(comboRawData[0].valueField);
            }
//console.log('<<< comboRawData:: >>>'+comboRawData);
				//	console.log('<<< selectedComboOption:: >>>'+selectedComboOption);
			console.log('<<< i am fianl show >>>');
            comboObject.show();
			//	if(mainForm.findField("multiselectpanel1")!=undefined)
		//	mainForm.findField("multiselectpanel1").show();
	
 this.getThinclientapplicationform().doLayout();
				
        } else {
            comboRawData = jsonData.measureCombo;
            selectedComboOption = jsonData.selectedMeasure;
            comboObject = mainForm.findField("select_testmes");
            comboObject.setFieldLabel(screenLabels["reporter.thin.Measure"]);
            comboObject.getStore().loadRawData(comboRawData);
            if (!Ext.isEmpty(selectedComboOption)) {
                comboObject.setValue(selectedComboOption);
            } else {
                comboObject.setValue(comboRawData[0].valueField);
            }
        }
				//
		mainForm.findField("er_option").show();
    },

	loadSettingsElements: function()
	{
		console.log('<< loadSettingsElements >>>>>>');
		var hiddenFields =  '';
		var favorite_id='';

			hiddenFields=appConstants.publicjsonDataDetails['hiddenfields'];
			favorite_id=hiddenFields["favorite_id"];
			if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
			}
		Ext.getCmp('moreOptionCloseId').show();
       	var comboRawData;
		var selectedComboOption;
		var comboObject;
		var thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
			jsonData = appConstants.publicjsonDataDetails;
		var screenLabels=jsonData.screenLabels;

		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;

		 updatingAppSettings();

		if (targetType == 'Application User Details' || targetType == 'Application Report'){
			comboRawData = jsonData.excludeWeekCombo;
			selectedComboOption = jsonData.excludeWeek;
			comboObject = thinclientSettingsForm.findField("er_excwe");
			comboObject.setFieldLabel(screenLabels["reporter.common.Exclude weekends"]);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}

			comboRawData = jsonData.geoFilterCombo;
			if(comboRawData!=undefined)
			{
				appConstants.geoFilterCombo = comboRawData;
				var component = Ext.getCmp("er_geoFilter");
				component.getStore().loadRawData(comboRawData);
				selectedComboOption = jsonData.selectedgeoFilter;
				Ext.getCmp("multiSelectLabel_geo").setText(screenLabels["geoFilterLabel"]);
				if (!Ext.isEmpty(selectedComboOption)) 
				{
					component.setValue(selectedComboOption);
				}
				else 
				{
					component.setValue(comboRawData[0].valueField);
				}
				Ext.getCmp('geofilter').show();
			}
		}



			 var groupComp = thinclientSettingsForm.findField("groupByComponent");
			 	console.log('<<< groupComp >>>'+groupComp);
			 if(groupComp!=undefined && jsonData.group_by_component!=undefined)
				groupComp.setValue({'groupByComponent': jsonData.group_by_component});
			 else
				groupComp.setValue({'groupByComponent':'No'});



		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);

		//this.updateQueryString();
		//if(isSubmitted == 'true')
			//this.showResult();
		var thisController = this;
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndCloseSettings();
		});
		if (targetType == 'Application User Details' || targetType == 'Application Report'){
			thinclientSettingsForm.findField("er_excwe").show();

		// for single server selection-hide the accoss server
		var mainForm =Ext.getCmp('mainform').getForm();
		var compArr = Ext.getCmp("er_server").getValue();
		if(mainForm.findField("er_type").getValue() == null || mainForm.findField("er_type").getValue()==undefined)
		return;
		if(compArr==null || compArr=='' || compArr.length==0)
		return;
		//
		}else {
			thinclientSettingsForm.findField("er_excwe").hide();
		}
	},
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if(isSettingsOk)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px" class="settingsfont">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
			Ext.create('Ext.container.Container',{
				width:600,
				padding:5,
				//layout:'vbox',
				id:'configMod',
				//cls:'configMode_popup',
				ui:'settingsWindowContainer',
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'390px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						style:{'top':'0px','margin':'2px'}
					},
					{
						xtype : 'thinclientapplicationsettings',
						parent:this
					}
				],
				renderTo:'thinclientapplication'
		});
	},
	LoadDrillDownData:function( url){
	var paramsForDrillDown = url.substring(url.indexOf("?")+1);
	var controller = url.substring(0,url.indexOf("?"));
	var resultPanelObj = Ext.getCmp('resultPanel');
	var meController = this;
	console.log(controller+"  np");
	Ext.Ajax.request(
		{
			url : controller,
			params : paramsForDrillDown,
			method :'POST',
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				if(jsonData.hasOwnProperty('DrillDownData')){
					resultPanelObj.removeAll();
					var DrillDownData = jsonData['DrillDownData'];
					var columnDetails = DrillDownData['columnDetails'];
					var dataArray = DrillDownData['dataArray'];
					if(!Ext.isEmpty(dataArray))
					{

						var tabledata = '<div class="x-table" >'
						+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'
							+'<thead>'
								+'<tr class="x-grid-row">';
						for( var k in columnDetails){
									tabledata+='<th class="x-grid-cell">'
										+'<div class="x-grid-cell-inner">'+columnDetails[k]+'</div>'
									+'</th>';
						}
						tabledata+='</tr>'
							+'</thead>'
						+'<tbody>'
						+'<tpl for=".">';
						for(var j in dataArray)
						{
							var realdata=dataArray[j];
							tabledata+='<tr class="x-grid-row">';
							for(var l in realdata){
								tabledata+='<td class=" x-grid-cell x-grid-cell-first">'
									+'<div class="x-grid-cell-inner" >'+realdata[l]+'</div>'
								+'</td>'
							}
							tabledata+='</tr>';
						}
						tabledata+='</tpl>'
						+'</tbody>'
						+'</table>'
						+'</div>';
					}
					resultPanelObj.add({
						xtype:'panel',
						//cls:'datapanel',
 						/*layout:{
							type:'vbox',
							columns:2,
							align:'center'
						},*/
 						title:DrillDownData.title,
						tools:[
						{
							xtype:'button',
							text:backText,
							cls:'backbutton',
							iconCls:'iconBack',
							id:'thiClientbckButton',
							name:'thiClientbckButton',
							listeners:{
								'click':function()
								{
									meController.submitReport();
								}
							}
						}],
						html:tabledata
					});
				}
			}
		});

	},

   expandAppln: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'),Ext.getCmp('appLabel').text,btn);
    },
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'),Ext.getCmp('multiSelectLabel').text,btn);
	},
	expandMeGeo:function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_geoFilter'),Ext.getCmp('multiSelectLabel_geo').text,btn);
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{

		var publicJsonData=null;
			publicJsonData = appConstants.publicjsonDataDetails;

		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}



		return value;
	}
});

