// JavaScript Document
Ext.Loader.setConfig({
	enable:true,
	garbageCollect:true,
	preserveScripts:false,
	disableCaching:false	
});
Ext.Ajax.timeout=ajaxTimeout;
Ext.Ajax.disableCaching=false;
registerAjaxExceptionEvent();
Ext.Loader.setPath('utilities', '../scripts/utilities');
Ext.Loader.setPath('Ext.ux', '../scripts/ux');

var application;

function showDrillDownData(url,row){
	Ext.onReady(function() {
		application.getController("ThinclientSessionReports").showDrillDownDataForUrl(url);
	});
}
function showUniqueUsrLst(){
	application.getController("ThinclientSessionReports").loadUniqueUsrLst();
}
Ext.application({
		name:'thinclientsessionreports',
		requires:['thinclientsessionreports.view.Main','utilities.TimeLineSave'],
		controllers: ['ThinclientSessionReports'],
		appFolder:['../reporter/scripts/ThinclientSessionApp/'],

		launch:function(){
			appConstants.appObj = this;
 			appConstants.appController='thinclientsessionreports.controller.ThinclientSessionReports';
			application = this;
			var defaultUrl = '/final/reporter/ErCtxSessionReportJson.jsp';
		
			var params1 = appConstants.defaultParams;
			if((appConstants.isSubmit!=null && appConstants.isSubmit=="true") || appConstants.executeFavorite == 'true' )
			{
				defaultUrl = '/final/servlet/com.eg.ErCtxServerReportC';
				params1 = 'responseType=json&'+params1;
			}
			Ext.Ajax.request(
			{
				url : defaultUrl,
				params : "thinClientSessionAction=defaultLoad&"+params1,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicJsonData = jsonData;
					Ext.create('Ext.container.Viewport',{
							layout:'fit',
							items:[
								{ 
									xtype:'main'
									
								}
							]
						});
						Ext.get('loadmask').remove();
					}
				});
			}
		
	});