Ext.define('thinclientsessionreports.controller.ThinclientSessionReports',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
	gridColIndexParam:-1,//added for updating sort by option
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector:'thinclientsessionreportsform', ref:'thinclientsessionreportsform'},
		{selector:'thinclientsessionsettings', ref:'thinclientsessionsettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({
			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'boxready':this.afterMainRender
			},
			'thinclientsessionsettings':{
				'afterrender':this.loadSettingsElements
			},
			'thinclientsessionreportsform':{
				'afterrender':this.loadMainElements
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
				 'select': this.changeEr_mode
			},
			'thinclientsessionreportsform combo[name="zoneComboBox"]':{
				'select': this.zoneOnChange
			},
			'thinclientsessionreportsform combo[name="compTypeComboBox"]':{
				'select': this.compTypeOnChange
			},
			'thinclientsessionreportsform combo[name="reportTypeComboBox"]':{
				'select': this.reportTypeOnChange
			},
			/* 'thinclientsessionsettings combo[name="excludeWeekendsComboBox"]':{
				'select': this.weekendOnChange
			}, */
			'thinclientsessionsettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'thinclientsessionsettings combo[name="showDataComboBox"]':{
				'select': this.changeTrend
			},
			'thinclientsessionsettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'thinclientsessionsettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'thinclientsessionreportsform button[name="submit"]':{
				'click': this.showResult
			},
			'thinclientsessionreportsform button[name="save"]': {
				"click": this.goTo
			},
			'thinclientsessionreportsform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'thinclientsessionreportsform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'thinclientsessionreportsform combo[id="er_site"]':
			{
			'select': this.er_siteOnChange
			}
		});
	},
			onSelectAnalysisBy: function (obj) {
				var er_option=obj.getValue();
				var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
				var params1='er_option='+er_option+'&er_type='+Ext.getCmp('reportTypeComboBox').getValue()+'&thinClientSessionAction=zoneOnChange';
				Ext.Ajax.request({
				url: "/final/reporter/ErCtxSessionReportJson.jsp",
				params: params1,
				method: "GET",
				success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				var compTypeCombo;
				compTypeCombo = Ext.getCmp('compTypeComboBox');
				compTypeCombo.getStore().clearFilter(true); 
				compTypeCombo.getStore().loadRawData(jsonData['compTypeJson']);
				compTypeCombo.setValue(jsonData.pageParams['selectedCompType']);
				var er_type=Ext.getCmp('reportTypeComboBox').getValue();
				if(er_type=='Yes')
				{
					var measureCombo = thinClientMainForm.findField('measureComboBox');
					measureCombo.getStore().clearFilter(true); 
					measureCombo.getStore().loadRawData(jsonData['measureOpts']);
					measureCombo.setValue(jsonData.pageParams['selectedMeasure']);
					Ext.getCmp('measureComboBox').show();
				}
				else
				{
					var compCombo = Ext.getCmp('compTypeComboBox').getValue();
					var reportComboBox = Ext.getCmp('reportTypeComboBox').getValue();
					var measureCombos = thinClientMainForm.findField('measureComboBox');
					if(compCombo == 'All Types' && reportTypeCombo == 'Graph')
					{
						measureCombos.getStore().clearFilter(true);
					}

					Ext.getCmp('measureComboBox').hide();
				}
				if (er_option=='Zone')
				{
					Ext.getCmp('er_site').hide();
					var zoneCombo = thinClientMainForm.findField('zoneComboBox');
					zoneCombo.setFieldLabel('Zone');
					zoneCombo.getStore().clearFilter(true);
					zoneCombo.getStore().loadRawData(jsonData['zoneListJson']);
					zoneCombo.setValue(jsonData.pageParams['selectedZone']);
					zoneCombo.show();
				}
				else if(er_option=='Component')
				{
					Ext.getCmp('er_site').hide();
					Ext.getCmp('zoneComboBox').hide();
				}
				else
				{
					Ext.getCmp('zoneComboBox').hide();
					compTypeCombo=Ext.getCmp('er_site');
					compTypeCombo.getStore().clearFilter(true);
					compTypeCombo.getStore().loadRawData(jsonData.siteCombo);
					compTypeCombo.setFieldLabel(jsonData.siteComboLabel);
					compTypeCombo.setValue(jsonData.selectedSiteCombo);
					compTypeCombo.show();
				}
			}
		 });
	},
			er_siteOnChange: function (obj) {
				var er_site=obj.getValue();
				var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
				var params1='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+er_site+'&er_type='+Ext.getCmp('reportTypeComboBox').getValue()+'&thinClientSessionAction=zoneOnChange';
				 Ext.Ajax.request({
					url: "/final/reporter/ErCtxSessionReportJson.jsp",
					params: params1,
					method: "GET",
					success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				var compTypeCombo;
				compTypeCombo = thinClientMainForm.findField('compTypeComboBox');
				compTypeCombo.getStore().clearFilter(true);
				compTypeCombo.getStore().loadRawData(jsonData['compTypeJson']);
				compTypeCombo.setValue(jsonData.pageParams['selectedCompType']);
				var er_type=Ext.getCmp('reportTypeComboBox').getValue();
				if (er_type=='Yes')
				{
					var measureCombo = thinClientMainForm.findField('measureComboBox');
					measureCombo.getStore().loadRawData(jsonData['measureOpts']);
					measureCombo.setValue(jsonData.pageParams['selectedMeasure']);
					Ext.getCmp('measureComboBox').show();
				}
				else
				{
					Ext.getCmp('measureComboBox').hide();
					
				}
			}
		});
	},
		goTo: function(btn){
		appConstants.formButtonId = btn.getId();
		var from_schedule = appConstants.publicJsonData['hiddenParams']["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}else{
			this.saveFavorite();
		}
	},
	 changeEr_mode: function (combo) {
	var favorite_id = appConstants.publicJsonData['hiddenParams']["favorite_id"];
	var from_schModify = appConstants.publicJsonData['hiddenParams']["fromScheduleModify"];
	if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
	{
		return;
	}
		if(Ext.get('configMod')!=null && Ext.get('configMod')!='undefined'){
		Ext.get('configMod').animate({
					duration: 250,
					to: {
						y: -530
					}
				});
		}
		this.showResult();
     },
	zoneOnChange : function(combo)
	{
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var selectedZone = combo.getValue();

		params1 = "&select_farm="+selectedZone+'&er_type='+Ext.getCmp('reportTypeComboBox').getValue();
		Ext.Ajax.request(
		{
			url : '/final/reporter/ErCtxSessionReportJson.jsp',
			params : params1+"&thinClientSessionAction=zoneOnChange",
			scope:this,
			method : 'POST',
			success: function(response){

				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData))
				{
					var compTypeCombo = thinClientMainForm.findField('compTypeComboBox');
					compTypeCombo.getStore().clearFilter(true);
					compTypeCombo.getStore().loadRawData(jsonData['compTypeJson']);
					compTypeCombo.setValue(jsonData.pageParams['selectedCompType']);
					var measureCombo = thinClientMainForm.findField('measureComboBox');
					measureCombo.getStore().clearFilter(true);
					measureCombo.getStore().loadRawData(jsonData['measureOpts']);
					measureCombo.setValue(jsonData.pageParams['selectedMeasure']);
				}
			}
		});
	},
	compTypeOnChange : function(combo)
	{
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var zoneComboBox = thinClientMainForm.findField('zoneComboBox');
		var selectedZone = zoneComboBox.getValue();
		params1 = "&select_farm="+selectedZone+"&er_select_server="+combo.getValue();
		Ext.Ajax.request(
		{
			url : '/final/reporter/ErCtxSessionReportJson.jsp',
			params : params1+"&thinClientSessionAction=compTypeOnChange",
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData))
				{
					var measureCombo = thinClientMainForm.findField('measureComboBox');
					measureCombo.getStore().clearFilter(true);
					measureCombo.getStore().loadRawData(jsonData['measureOpts']);
					measureCombo.setValue(jsonData.pageParams['selectedMeasure']);
				}
			}
		});
	},
	saveReportAsPDF:function()
	{
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var thinClientSettingsForm =null;
		if(isSettingsEnabled)
			thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
		var mainFormParams='';
		var settingsFormParams='';
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var selectedZone =thinClientMainForm.findField('zoneComboBox').getValue();
		var compType = thinClientMainForm.findField('compTypeComboBox').getValue();
		var reportType = thinClientMainForm.findField('reportTypeComboBox').getValue();
		var opt = '';
		var er_mode = thinClientMainForm.findField('er_mode').getValue();
		var startDt = thinClientMainForm.findField('er_stdate').dataArray;
		var endDt = thinClientMainForm.findField('er_enddate').dataArray;
		var timeline = thinClientMainForm.findField("er_timeline").getValue();
		var stHr = thinClientMainForm.findField('er_sthr').dataArray;
		var enHr = thinClientMainForm.findField('er_endhr').dataArray;

	var fromTime =this.getSettingsFieldValue(thinClientSettingsForm,'timefrom',isSettingsEnabled,'selectedFromTime');
	var toTime =this.getSettingsFieldValue(thinClientSettingsForm,'timeto',isSettingsEnabled,'selectedToTime');
	var minfrom =this.getSettingsFieldValue(thinClientSettingsForm,'minfrom',isSettingsEnabled,'selectedFromMin');
	var minto =this.getSettingsFieldValue(thinClientSettingsForm,'minto',isSettingsEnabled,'selectedToMin');

	var trendOption =this.getSettingsFieldValue(thinClientSettingsForm,'showDataComboBox',isSettingsEnabled,'selectedShowDataOption');
	var excludeWeekendOption =this.getSettingsFieldValue(thinClientSettingsForm,'excludeWeekendsComboBox',isSettingsEnabled,'selectedExcludeWeekEndOption');
	var reportGeneration =this.getSettingsFieldValue(thinClientSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var	bckbutton1=	Ext.getCmp('thiClientbckButton')
		if(bckbutton1!=undefined && !bckbutton1.isHidden()){
			mainFormParams+="&er_type=No";
			reportType="No";
		}
		else
			mainFormParams+="&er_type="+encodeURIComponent(reportType);

		if(!Ext.isEmpty(reportType))
		{
			var selectedReportType = reportType;
			if(selectedReportType=="Yes")
			{
				var measure = thinClientMainForm.findField('measureComboBox').getValue();
				mainFormParams = 'select_testmes='+encodeURIComponent(measure);
				opt = 'chart';
			}
			else
			{
				opt = 'data';
			}
		}
		var timperiodParams="&timefrom="+fromTime+"&minfrom="+minfrom+"&timeto="+toTime+"&minto="+minto;
		var userChart = '';
		var iniDate = '';
		var startMin = '';
		var endMin = '';
		var uid = '';
		var select_server1 = '';
		var select_server = '';

		var daychartforHidObj = appConstants.publicJsonData['hiddenParams']['daychartfor'];
		if(reportType == 'No')
		{
			var er_uniqueUserObj = Ext.getCmp('er_uniqueUser');
			if((er_uniqueUserObj!=undefined && er_uniqueUserObj.checked)|| appConstants.publicJsonData['er_uniqueUser'] )
			{
				appConstants.publicJsonData['hiddenParams']['daychartfor'] = 'uniqueuser';
			}
			if((er_uniqueUserObj!=undefined && !er_uniqueUserObj.checked))
			{
				appConstants.publicJsonData['hiddenParams']['daychartfor'] = daychartforHidObj;
			}
		}
		daychartforHidObj = appConstants.publicJsonData['hiddenParams']['daychartfor'];
		
		if(!Ext.isEmpty(daychartforHidObj))
			userChart = daychartforHidObj;

		var iniDateHidObj = appConstants.publicJsonData['hiddenParams']['inidate'];
		if(!Ext.isEmpty(iniDateHidObj))
			iniDate = iniDateHidObj;

		var uidHidObj = appConstants.publicJsonData['hiddenParams']['uid'];
		if(!Ext.isEmpty(uidHidObj))
			uid = uidHidObj;
		var select_server1HidObj = appConstants.publicJsonData['hiddenParams']['select_server1'];
		if(!Ext.isEmpty(select_server1HidObj))
		{
			select_server1 = select_server1HidObj;
			if(!Ext.isEmpty(select_server1))
				select_server1=encodeURIComponent(select_server1);
		}

		var select_serverHidObj = appConstants.publicJsonData['hiddenParams']['select_server'];
		if(!Ext.isEmpty(select_serverHidObj))
		{
			select_server = select_serverHidObj;
			if(!Ext.isEmpty(select_server))
				select_server=encodeURIComponent(select_server);
		}
		mainFormParams=mainFormParams+"&select_farm="+encodeURIComponent(selectedZone)+"&er_select_server="+encodeURIComponent(compType);
			var erOption=Ext.getCmp('er_option');
			if(erOption!=undefined)
			{
				mainFormParams+="&er_option="+erOption.getValue();
				if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
				{
					var erSite=Ext.getCmp('er_site');
					mainFormParams+="&er_site="+erSite.getValue();
				}
			}
		settingsFormParams="&er_excwe="+excludeWeekendOption+"&er_trenddata="+trendOption+"&er_mode="+er_mode+"&er_reportgenration="+reportGeneration;

		var timelineParams="&er_timeline="+thinClientMainForm.findField("er_timeline").getValue()+"&startdate="+encodeURIComponent(startDt)+"&enddate="+encodeURIComponent(endDt)+"&starthr="+stHr+"&endhr="+enHr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var hidParams="&select_server="+select_server+"&select_server1="+select_server1+"&er_rtype=Session&er_gtype=Citrix&er_trgttype="+encodeURIComponent('Session Report')+"&daychartfor="+userChart+"&er_select_comp="+encodeURIComponent(compType)+"&inidate="+encodeURIComponent(iniDate);
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+mainFormParams+settingsFormParams+timelineParams+timperiodParams+hidParams;
		if (opt=="chart")
		{
			s_qryString +="&opt=chart&printGraph=yes&er_view=IMAGE&uid="+uid;
		}
		else if (opt=="data" && userChart=="")
		{
			s_qryString +="&er_view=PRINT&uid="+uid;
		}
		else
		{
			s_qryString +="&er_view=image&uid="+uid;
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		s_qryString=this.getGridColSortParam(s_qryString);
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var thinClientSettingsForm =null;
		if(isSettingsEnabled)
			thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
		var mainFormParams='';
		var settingsFormParams='';
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var selectedZone =thinClientMainForm.findField('zoneComboBox').getValue();
		var compType = thinClientMainForm.findField('compTypeComboBox').getValue();
		var reportType = thinClientMainForm.findField('reportTypeComboBox').getValue();
		var opt = '';
		var er_mode = thinClientMainForm.findField('er_mode').getValue();
		var startDt = thinClientMainForm.findField('er_stdate').dataArray;
		var endDt = thinClientMainForm.findField('er_enddate').dataArray;
		var timeline = thinClientMainForm.findField("er_timeline").getValue();
		var stHr = thinClientMainForm.findField('er_sthr').dataArray;
		var enHr = thinClientMainForm.findField('er_endhr').dataArray;
		var fromTime =this.getSettingsFieldValue(thinClientSettingsForm,'timefrom',isSettingsEnabled,'selectedFromTime');
		var toTime =this.getSettingsFieldValue(thinClientSettingsForm,'timeto',isSettingsEnabled,'selectedToTime');
		var minfrom =this.getSettingsFieldValue(thinClientSettingsForm,'minfrom',isSettingsEnabled,'selectedFromMin');
		var minto =this.getSettingsFieldValue(thinClientSettingsForm,'minto',isSettingsEnabled,'selectedToMin');
		var trendOption =this.getSettingsFieldValue(thinClientSettingsForm,'showDataComboBox',isSettingsEnabled,'selectedShowDataOption');
		var excludeWeekendOption =this.getSettingsFieldValue(thinClientSettingsForm,'excludeWeekendsComboBox',isSettingsEnabled,'selectedExcludeWeekEndOption');
		var reportGeneration =this.getSettingsFieldValue(thinClientSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var	bckbutton1=	Ext.getCmp('thiClientbckButton')
		if(bckbutton1!=undefined && !bckbutton1.isHidden()){
			mainFormParams+="&er_type=No";
			reportType="No";
		}
		else
			mainFormParams+="&er_type="+encodeURIComponent(reportType);
		if(!Ext.isEmpty(reportType))
		{
			var selectedReportType = reportType;
			if(selectedReportType=="Yes")
			{
				var measure = thinClientMainForm.findField('measureComboBox').getValue();
				mainFormParams = 'select_testmes='+encodeURIComponent(measure);
				opt = 'chart';
			}
			else
			{
				opt = 'data';
			}
		}
		var timperiodParams="&timefrom="+fromTime+"&minfrom="+minfrom+"&timeto="+toTime+"&minto="+minto;
		var userChart = '';
		var iniDate = '';
		var startMin = '';
		var endMin = '';
		var uid = '';
		var select_server1 = '';
		var select_server = '';
		var daychartforHidObj = appConstants.publicJsonData['hiddenParams']['daychartfor'];
		if(reportType == 'No')
		{
			var er_uniqueUserObj = Ext.getCmp('er_uniqueUser');
			if((er_uniqueUserObj!=undefined && er_uniqueUserObj.checked)|| appConstants.publicJsonData['er_uniqueUser'] )
			{
				appConstants.publicJsonData['hiddenParams']['daychartfor'] = 'uniqueuser';
			}
			if((er_uniqueUserObj!=undefined && !er_uniqueUserObj.checked))
			{
				appConstants.publicJsonData['hiddenParams']['daychartfor'] = daychartforHidObj;
			}
		}
		daychartforHidObj = appConstants.publicJsonData['hiddenParams']['daychartfor'];
		if(!Ext.isEmpty(daychartforHidObj))
			userChart = daychartforHidObj;
		var iniDateHidObj = appConstants.publicJsonData['hiddenParams']['inidate'];
		if(!Ext.isEmpty(iniDateHidObj))
			iniDate = iniDateHidObj;
		var uidHidObj = appConstants.publicJsonData['hiddenParams']['uid'];
		if(!Ext.isEmpty(uidHidObj))
			uid = uidHidObj;
		var select_server1HidObj = appConstants.publicJsonData['hiddenParams']['select_server1'];
		if(!Ext.isEmpty(select_server1HidObj))
		{
			select_server1 = select_server1HidObj;
			if(!Ext.isEmpty(select_server1))
				select_server1=encodeURIComponent(select_server1);
		}
		var select_serverHidObj = appConstants.publicJsonData['hiddenParams']['select_server'];
		if(!Ext.isEmpty(select_serverHidObj))
		{
			select_server = select_serverHidObj;
			if(!Ext.isEmpty(select_server))
				select_server=encodeURIComponent(select_server);
		}
		mainFormParams=mainFormParams+"&select_farm="+encodeURIComponent(selectedZone)+"&er_select_server="+encodeURIComponent(compType);
						//+"&er_type="+encodeURIComponent(reportType);
			var erOption=Ext.getCmp('er_option');
			if(erOption!=undefined)
			{
				mainFormParams+="&er_option="+erOption.getValue();
				if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
				{
					var erSite=Ext.getCmp('er_site');
					mainFormParams+="&er_site="+erSite.getValue();
				}
			}
		settingsFormParams="&er_excwe="+excludeWeekendOption+"&er_trenddata="+trendOption+"&er_mode="+er_mode+"&er_reportgenration="+reportGeneration;
		var timelineParams="&er_timeline="+thinClientMainForm.findField("er_timeline").getValue()+"&startdate="+encodeURIComponent(startDt)+"&enddate="+encodeURIComponent(endDt)+"&starthr="+stHr+"&endhr="+enHr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var hidParams="&select_server="+select_server+"&select_server1="+select_server1+"&er_rtype=Session&er_gtype=Citrix&er_trgttype="+encodeURIComponent('Session Report')+"&daychartfor="+userChart+"&er_select_comp="+encodeURIComponent(compType)+"&inidate="+encodeURIComponent(iniDate);
		var s_qryString = mainFormParams+settingsFormParams+timelineParams+timperiodParams+hidParams;
		if (opt=="chart")
		{
			s_qryString +="&opt=chart&printGraph=yes&er_view=IMAGE&uid="+uid;
		}
		else if (opt=="data" && userChart=="")
		{
			s_qryString +="&er_view=PRINT&uid="+uid;
		}
		else
		{
			s_qryString +="&er_view=image&uid="+uid;
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		s_qryString=this.getGridColSortParam(s_qryString);
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		this.updateQueryString();
		bookletquery+=queryString+"&option=data";
		var topSession = '';
		var topSessionHidObj = appConstants.publicJsonData['hiddenParams']['topSession'];
		if(!Ext.isEmpty(topSessionHidObj))
		{
			topSession = topSessionHidObj;
			bookletquery+="&topSession="+topSession;
		}
		var target='';
		var topusers = '';
		var topusersHidObj = appConstants.publicJsonData['hiddenParams']['topusers'];
		if(!Ext.isEmpty(topusersHidObj))
		{
			topusers = topusersHidObj;
			bookletquery+="&topusers="+topusers;
		}
		
		if(bookletquery.indexOf("er_rtype")==-1)
		{
			bookletquery+="&er_rtype=Session";
		}
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function()
	{
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var thinClientSettingsForm =null;
		if(isSettingsEnabled)
			thinClientSettingsForm = this.getThinclientsessionsettings().getForm();

		var mainFormParams;
		var settingsFormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var selectedZone =thinClientMainForm.findField('zoneComboBox').getValue();
		var compType = thinClientMainForm.findField('compTypeComboBox').getValue();
		var reportType = thinClientMainForm.findField('reportTypeComboBox').getValue();
		var opt = '';
		var er_mode = thinClientMainForm.findField('er_mode').getValue();
		var startDt = thinClientMainForm.findField('er_stdate').dataArray;
		var endDt = thinClientMainForm.findField('er_enddate').dataArray;
		var timeline = thinClientMainForm.findField("er_timeline").getValue();
		var stHr = thinClientMainForm.findField('er_sthr').dataArray;
		var enHr = thinClientMainForm.findField('er_endhr').dataArray;

var fromTime =this.getSettingsFieldValue(thinClientSettingsForm,'timefrom',isSettingsEnabled,'selectedFromTime');
var toTime =this.getSettingsFieldValue(thinClientSettingsForm,'timeto',isSettingsEnabled,'selectedToTime');
var minfrom =this.getSettingsFieldValue(thinClientSettingsForm,'minfrom',isSettingsEnabled,'selectedFromMin');
var minto =this.getSettingsFieldValue(thinClientSettingsForm,'minto',isSettingsEnabled,'selectedToMin');

var trendOption =this.getSettingsFieldValue(thinClientSettingsForm,'showDataComboBox',isSettingsEnabled,'selectedShowDataOption');
var excludeWeekendOption =this.getSettingsFieldValue(thinClientSettingsForm,'excludeWeekendsComboBox',isSettingsEnabled,'selectedExcludeWeekEndOption');
var reportGeneration =this.getSettingsFieldValue(thinClientSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');

		var userChart = '';
		var iniDate = '';
		var startMin = '';
		var endMin = '';
		var uid = '';
		var select_server1 = '';
		var select_server = '';

		var daychartforHidObj = appConstants.publicJsonData['hiddenParams']['daychartfor'];
		if(reportType == 'No')
		{
			var er_uniqueUserObj = Ext.getCmp('er_uniqueUser');
			if((er_uniqueUserObj!=undefined && er_uniqueUserObj.checked)|| appConstants.publicJsonData['er_uniqueUser'] )
			{
				appConstants.publicJsonData['hiddenParams']['daychartfor'] = 'uniqueuser';
			}
			if((er_uniqueUserObj!=undefined && !er_uniqueUserObj.checked))
			{
				appConstants.publicJsonData['hiddenParams']['daychartfor'] = daychartforHidObj;
			}
		}
		daychartforHidObj = appConstants.publicJsonData['hiddenParams']['daychartfor'];

		if(!Ext.isEmpty(daychartforHidObj))
			userChart = daychartforHidObj;

		var iniDateHidObj = appConstants.publicJsonData['hiddenParams']['inidate'];
		if(!Ext.isEmpty(iniDateHidObj))
			iniDate = iniDateHidObj;

		var uidHidObj = appConstants.publicJsonData['hiddenParams']['uid'];
		if(!Ext.isEmpty(uidHidObj))
			uid = uidHidObj;

		var select_server1HidObj = appConstants.publicJsonData['hiddenParams']['select_server1'];
		if(!Ext.isEmpty(select_server1HidObj))
		{
			select_server1 = select_server1HidObj;
			if(!Ext.isEmpty(select_server1))
				select_server1=encodeURIComponent(select_server1);
		}

		var select_serverHidObj = appConstants.publicJsonData['hiddenParams']['select_server'];
		if(!Ext.isEmpty(select_serverHidObj))
		{
			select_server = select_serverHidObj;
			if(!Ext.isEmpty(select_server))
				select_server=encodeURIComponent(select_server);
		}
		mainFormParams="select_farm="+encodeURIComponent(selectedZone)+"&er_select_server="+encodeURIComponent(compType);
		var bckbutton1=	Ext.getCmp('thiClientbckButton')
		if(bckbutton1!=undefined && !bckbutton1.isHidden()){
					mainFormParams+="&er_type=No";
					reportType="No";
		}
		else
			mainFormParams+="&er_type="+encodeURIComponent(reportType);

			var erOption=Ext.getCmp('er_option');
			if(erOption!=undefined)
			{
				mainFormParams+="&er_option="+erOption.getValue();
				if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
				{
					 var erSite=Ext.getCmp('er_site');
					mainFormParams+="&er_site="+erSite.getValue();
				}
			}
		if(!Ext.isEmpty(reportType))
		{
			var selectedReportType = reportType;
			if(selectedReportType=="Yes")
			{
				var measure = thinClientMainForm.findField('measureComboBox').getValue();
				mainFormParams = mainFormParams+'&select_testmes='+encodeURIComponent(measure);
				opt = 'chart';
			}
			else
			{
				opt = 'data';
			}
		}
		settingsFormParams="&er_excwe="+excludeWeekendOption+"&er_trenddata="+trendOption
							+"&er_mode="+er_mode+"&er_reportgenration="+reportGeneration;
		var timperiodParams="&timefrom="+fromTime+"&minfrom="+minfrom+"&timeto="+toTime+"&minto="+minto;
		var timelineParams="&er_timeline="+timeline+"&startdate="+encodeURIComponent(startDt)+"&enddate="+encodeURIComponent(endDt)+"&starthr="+stHr+"&endhr="+enHr+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var hidParams="&select_server="+select_server+"&select_server1="+select_server1+"&er_rtype=Session&er_gtype=Citrix&er_trgttype="+encodeURIComponent('Session Report')+"&daychartfor="+userChart+"&er_select_comp="+encodeURIComponent(compType)+"&inidate="+encodeURIComponent(iniDate)+"&pdfPrint=yes&isSubmit=true";
		var s_qryString = "../servlet/com.eg.ErCtxServerReportC?"+mainFormParams+settingsFormParams+timelineParams+timperiodParams+hidParams;

		if (opt=="chart")
		{
			s_qryString +="&opt=chart&printGraph=yes&er_view=IMAGE&uid="+uid;
		}
		else if (opt=="data" && userChart=="")
		{
			s_qryString +="&er_view=PRINT&uid="+uid;
		}
		else
		{
			s_qryString +="&er_view=image&uid="+uid;
		}
	  s_qryString=this.getGridColSortParam(s_qryString);
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
		getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');

		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);
			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}

			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}

		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(){
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var isValid = this.validateMainForm(false);
		if( isValid &&Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}
		if(isValid)
		{
			this.updateQueryString();
			var topSession = '';
			var topSessionHidObj = appConstants.publicJsonData['hiddenParams']['topSession'];
			if(!Ext.isEmpty(topSessionHidObj))
			{
				topSession = topSessionHidObj;
			}
			var target='';
			var topusers = '';
			var topusersHidObj = appConstants.publicJsonData['hiddenParams']['topusers'];
			if(!Ext.isEmpty(topusersHidObj))
			{
				topusers = topusersHidObj;
			}
			target="/final/reporter/ErSaveSchedule.jsp?"+queryString+"&option=data&topSession="+topSession+"&topusers="+topusers+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var qrString=target.substr(target.indexOf("?")+1,target.length-1);
				if(qrString!= undefined )
				{
					if(qrString.indexOf("er_rtype")==-1)
					{
					qrString+="&er_rtype=Session";
					}
				}
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
						url:urlNw,
						params:qrString,
						standardSubmit: true,
						method: 'POST'
						});
			}
			else
				 parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
		{
			return
		}
	},
	saveFavorite:function(){
		var isValid = this.validateMainForm(false);
		/*if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		}*/
		if(isValid){
		this.updateQueryString();
		var favorite_id = appConstants.publicJsonData['hiddenParams']["favorite_id"];
		var target="../servlet/com.eg.ErFavoriteC?"+queryString+"&thinClientSessionAction=submit&isSubmit=true&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId="+favorite_id;
		if (appConstants.formButtonId=='save')
		{
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var qrString=target.substr(target.indexOf("?")+1,target.length-1);
				if(qrString!= undefined )
				{
					if(qrString.indexOf("er_rtype")==-1)
					{
						qrString+="&er_rtype=Session";
					}
				}
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
						url:urlNw,
						params:qrString,
						standardSubmit: true,
						method: 'POST'
						});
		}
		else
 			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return;
	},
	validateMainForm:function(flag){
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var selectedZone=thinClientMainForm.findField('zoneComboBox').getValue();
		var selectedCompType = thinClientMainForm.findField('compTypeComboBox').getValue();
		var reportType = thinClientMainForm.findField('reportTypeComboBox').getValue();

		var selectedoption = thinClientMainForm.findField('er_option').getValue();
		if(Ext.isEmpty(selectedoption) || selectedoption=="-1" || selectedoption=="NotApplicable")
		{
			Ext.MessageBox.show({
			title: 'Thin Client Session',
			msg: 'Not Applicable',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false ;
		}
		if(reportType=='Yes')
		{
			var selectedMeasure = thinClientMainForm.findField('measureComboBox').getValue();
			if(Ext.isEmpty(selectedMeasure) || selectedMeasure=="-1" || selectedMeasure=="NotApplicable")
			{
				Ext.MessageBox.show({
				title: 'Thin Client Session',
				msg: appConstants.measureAlertMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		}
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var thinClientSettingsForm =null;
		if(isSettingsEnabled)
			thinClientSettingsForm = this.getThinclientsessionsettings().getForm();

		var isSettingsOk = true;
		var MaxDaysInMonth = appConstants.publicJsonData['hiddenParams']['getMaxDaysInMonth'];
		var reportgen=this.getSettingsFieldValue(thinClientSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var er_usertimeline = '';

		var userTimelineHidObj = appConstants.publicJsonData['hiddenParams']['er_usertimeline'];
		if ( !Ext.isEmpty(userTimelineHidObj) ){
			er_usertimeline = userTimelineHidObj;
		}
		var er_timeline=thinClientMainForm.findField('er_timeline').getValue();
		var stDate = thinClientMainForm.findField('er_stdate').getValue();
		var enDate =  thinClientMainForm.findField('er_enddate').getValue();
		var startHour =  thinClientMainForm.findField('er_sthr').getValue();
		var endHour =  thinClientMainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);

		var timefrom =this.getSettingsFieldValue(thinClientSettingsForm,'timefrom',isSettingsEnabled,'selectedFromTime');
		var timeto =this.getSettingsFieldValue(thinClientSettingsForm,'timeto',isSettingsEnabled,'selectedToTime');
		var minfrom =this.getSettingsFieldValue(thinClientSettingsForm,'minfrom',isSettingsEnabled,'selectedFromMin');
		var minto =this.getSettingsFieldValue(thinClientSettingsForm,'minto',isSettingsEnabled,'selectedToMin');

		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		var usertimelineValid=true;
		if(!Ext.isEmpty(er_usertimeline) && er_usertimeline != '-1'){
			usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Thin Client Session settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' && usertimelineValid ){
			if(flag)
			{
				var limitforbg = appConstants.publicJsonData['hiddenParams']['limitforbg'];

				if(!Ext.isEmpty(limitforbg)){
					var bglimit = limitforbg;
					if(!checkTimeLineForBgLimit(bglimit,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else if(usertimelineValid){
			var reportName = thinClientSettingsForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}
	},
	reportTypeOnChange:function(combo){
		Ext.getCmp('resultPanel').hide();
 		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var val = combo.getValue();
		if(val == 'No')
		{
			thinClientMainForm.findField('er_mode').hide();
			thinClientMainForm.findField('measureComboBox').hide();
			if(Ext.getCmp('er_uniqueUser')!=undefined)
				Ext.getCmp('er_uniqueUser').show();
		}
		else
		{
			thinClientMainForm.findField('er_mode').hide();
			thinClientMainForm.findField('measureComboBox').show();
			if(Ext.getCmp('er_uniqueUser')!=undefined)
				Ext.getCmp('er_uniqueUser').hide();
		}
		var compType = thinClientMainForm.findField('compTypeComboBox').getValue();
		var selectedZone=thinClientMainForm.findField('zoneComboBox').getValue();
		var reportType = thinClientMainForm.findField('reportTypeComboBox').getValue();
		var er_option = thinClientMainForm.findField('er_option').getValue();
		var er_site = thinClientMainForm.findField('er_site').getValue();
		var params='er_option='+er_option+'&er_type='+Ext.getCmp('reportTypeComboBox').getValue()+'&thinClientSessionAction=reportTypeChange';
		
		if (er_option=='Zone')
		{
			params+='&select_farm='+selectedZone;
		}
		else if (er_option!='Zone' && er_option!='Component')
		{
			params+='&er_site='+er_site;
		}
		Ext.Ajax.request(
		{
			url : '/final/reporter/ErCtxSessionReportJson.jsp?&er_type='+reportType,
			params :params,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				if(!Ext.isEmpty(jsonText))
				{
					var jsonData=Ext.decode(jsonText);
					appConstants.repotgene=jsonData;
					var compTypeCombo = thinClientMainForm.findField('compTypeComboBox');
					compTypeCombo.getStore().clearFilter(true);
					compTypeCombo.getStore().loadRawData(jsonData['compTypeJson']);
					compTypeCombo.setValue(jsonData.pageParams['selectedCompType']);
					//prakash
					var measureCombo = thinClientMainForm.findField('measureComboBox');
					measureCombo.getStore().clearFilter(true);
					measureCombo.getStore().loadRawData(jsonData['measureOpts']);
					measureCombo.setValue(jsonData.pageParams['selectedMeasure']);
					//
					if (isSettingsEnabled)
					{
						var reportGenerationCombo = Ext.getCmp('reportGeneration');
						var setRepoGen = jsonData.repGenOptJson[0].valueField;
						reportGenerationCombo.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.consolidated.Report Generation']);
						reportGenerationCombo.getStore().loadRawData(jsonData.repGenOptJson);
						reportGenerationCombo.setValue(setRepoGen);
						var reportNameObj = Ext.getCmp('bgReportName');
						if(setRepoGen!=undefined && setRepoGen!=null && setRepoGen=='foreground')
						{
							reportNameObj.hide();
						}
						else
						{
							reportNameObj.show();
						}
					}
				}
			}
		});
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('thinclientsessionreportsform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
			var isValid = this.validateMainForm(true);
			if(isValid)
			{
				this.submitReport();
			}
			else
			{
				return;
			}
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
		var reportgen=thinClientSettingsForm.findField('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv')) {
			var reportName = thinClientSettingsForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			this.submitReport();
		}
		else{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			var thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
			var reportGenType=thinClientSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinClientSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib=null;
			Ext.Ajax.request({
				url: URL,
				method: 'POST',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						chartAttrib=Ext.decode(jsonText);
					}
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	showDrillDownDataForUrl :  function(urlQStr)
	{
		if(urlQStr!=null && urlQStr.indexOf("?")==-1)
		{
			return;
		}
		var meController = this;
		var mainForm = this.getThinclientsessionreportsform();
		var thinClientMainForm = mainForm.getForm();
		var paramsForDrillDown = urlQStr.substr(urlQStr.indexOf("?")+1);
		var gridContainer=Ext.getCmp('gridContainer');
		//prakash
		var dataContainer=Ext.getCmp('dataContainer');
		//
		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
		initLoadMask.show();
		Ext.Ajax.request(
		{
			url : '../servlet/com.eg.ErCtxServerReportC',
			params : paramsForDrillDown,
			method :'POST',
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				dataContainer.removeAll();
				resultPanelObj.removeAll();
				appConstants.itemsArray =new Array();

				appConstants.isGraphDataAvailable = false;

				var dataAvailable = jsonData['dataAvailable'];
				if(!Ext.isEmpty(dataAvailable) && dataAvailable=="true")
				{
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
 					Ext.getCmp("csvTool").setDisabled(false);
					var mainTabTitle = jsonData['summaryTableTitle'];
					var dataType;
					if(mainTabTitle)
					dataType = jsonData['DataType'];

					if(!Ext.isEmpty(dataType) && dataType=="dayWiseAndUserWiseData")
					{
						gridContainer.removeAll(); //swami
						var dayWiseChartJson = jsonData['dayWiseChartJson'];
						if(!Ext.isEmpty(dayWiseChartJson))
						{
							appConstants.isGraphDataAvailable = true;
							var userTable = jsonData['userTable'];
 							var chartbox={
														xtype:'panel',
  														margin:'0 0 0 10',
 														layout:	 
														{
															type:'hbox',
															align:'stretch'
														},
														items:[
																{
																xtype:'container',
																layout:
																{
																	type:'vbox',
																	align:'stretch',
																},
																items:
																[
																	{
																		//xtype:'panel',
																		xtype:'container',
																		margin:'0 10 10 0',
																		height:70,
																		width:380,
																		ui:'newContainer',
																		//border:true,
																		//title:'Summary',
																		//ui:'newGraphPanel',
																		//frame:false,
																		//margin:10,
 																		//cls:'datapanel',
																		//html:'<div class="x-table"><table class="x-grid-table x-grid-table-resizer"><tr class="x-grid-row"><td class="x-grid-cell"><div style="padding:5px;">Number of named Users</div></td><td class="x-grid-cell" style="pading:5px;"><div style="padding:5px;">'+userTable.userTableValues.length+'</div></td></tr></table>',
																		html:'<table width="100%" height="100%"><tr><td valign="middle" class="newFont_bold14">'+uniqueUserAcessingTxt+'</td><td valign="middle" align="right" style="padding-right:10px" class="newFont_bold30">'+userTable.userTableValues.length+'</td></tr></table>',
 																		//width:750
																	},
																	{
																	xtype:'panel',
																	//border:true,
																	frame:false,
																	width:380,
																	flex:1,
																	margin:'0 10 10 0',
																	data: userTable,
																	//cls:'datapanel',
																	ui:'newGraphPanel',
																	id: 'userWiseData',
																	name : 'userWiseData',
																	//padding:10,
																	//title:'',
																	//width:750
																	}]
																	},
																	{
																	xtype:'panel',
																	data: jsonData,
																	border:true,
																	frame:false,
																	flex:1,
																	ui:'newGraphPanel',
																	//margin:'0 10 10 0',
																	//cls:'datapanel',
																	id: 'dayWiseChart',
																	name : 'dayWiseChart',
																	//width:750,
																	//title:mainTabTitle,
																	tools:[
																	{
																		xtype:'button',
																		text:backText,
																		cls:'backbutton',
																		iconCls:'iconBack',
																		id:'thiClientbckButton',
																		name:'thiClientbckButton',
																		listeners:{
																			'click':function()
																			{
																				meController.submitReport();
																			}
																		}
																	}]
																}
															] };
							appConstants.itemsArray.push(chartbox);
							gridContainer.add(appConstants.itemsArray);
						}
						dataContainer.removeAll(); //swami
						gridContainer.show();
						resultPanelObj.hide();
						gridContainer.doLayout();
						appConstants.publicJsonData['hiddenParams'] = jsonData['hiddenParams'];
					}
					else
					{
						var isDataAvailable = false;
						var gridArr = jsonData['sessionDetailsTableArr'];
						if(!Ext.isEmpty(gridArr))
						{
							var gridDataObj=gridArr[0];
							var columnDetails=gridDataObj.columns;
							var dataArraytoStore=gridDataObj.measureData;
							var viewPortWidth=this.getMain().getWidth();
							var count=0;
							var fieldstoStore =  new Array();
							var mainColumnsObjArray	=  new Array();
							for( var key in columnDetails ){
								var mainColumn=key;
								fieldstoStore.push(mainColumn);
								mainColumnsObjArray.push({
									header: mainColumn,
									sortable:true,
									dataIndex: mainColumn,
									align:'center',
									//flex:1,
									listeners:{
									sortchange:function(ct, column, e, t, eOpts ){
										meController.gridColIndexParam=column.getIndex();
										meController.gridColStateParam=column.sortState;
   									}
								},
								doSort: function(state) {
 											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													v1 = v1.get(field);
													v2 = v2.get(field);

													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;

													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										var dispVal = value['dispVal'];
										var hrefUrl = value['hrefUrl'];
										var dispVal1 =dispVal;

										if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
										{
											dispVal1 = '<a href="'+hrefUrl+'">'+dispVal+'</a>'
										}
										return dispVal1;
									}
								});
							}
							var storeObj = Ext.create('Ext.data.ArrayStore', {
							fields:fieldstoStore,
							data:dataArraytoStore
							});
							var gridpanel = Ext.widget('customgrid',{
								store:storeObj,
 								columns:mainColumnsObjArray,
								ui:'newGridPanel withHeader',
 								bodyPadding:'0 0 0 0',
								//margin : '10 100 10 100',
								//margin:'10 10 10 10',
								forceFit:true,
								border:true,
								title:'<span class="font_bold">'+mainTabTitle+'</span>',
								tools:[
								{
									xtype:'button',
									text:backText,
									cls:'backbutton',
									iconCls:'iconBack',
									id:'thiClientbckButton',
									name:'thiClientbckButton',
									listeners:{
										'click':function()
										{
											meController.submitReport();
										}
									}
								}]
							});
							var gridPanelArray = new Array();
							gridPanelArray.push(gridpanel);
							if(!Ext.isEmpty(gridpanel))
							{
								dataContainer.add({
									xtype:'panel',
									margin:'10',
									padding:'0 10 10 10',
									ui:'newGraphPanel',
									items:gridPanelArray
								});
								dataContainer.show();
								resultPanelObj.hide();
								dataContainer.doLayout();
								isDataAvailable = true;
							}
						}
					}
					if(!appConstants.isGraphDataAvailable && !isDataAvailable)
					{
						dataContainer.hide();
						resultPanelObj.removeAll();
						this.disableTools();
						resultPanelObj.hide();
						this.getNomeasurepanel().show();
					}
				}
				else
				{
					dataContainer.hide();
					resultPanelObj.removeAll();
					this.disableTools();
					resultPanelObj.hide();
					this.getNomeasurepanel().show();
				}
			},
			callback: function()
			{
				var containerObj=Ext.getCmp('dayWiseChart');
				if(!Ext.isEmpty(containerObj))
				{
					var jsonData = containerObj.data;
					var data = jsonData['dayWiseChartJson'];

					var finalHtmlStr = '';
					if(appConstants.isGraphDataAvailable)
					{
						//prakash for new design
						//var tableHtmlStr = "<div class='htmlGraphTable' style='float:left;width:750px;height:300px'><table border='0' bordercolor='red' class='x-grid-table x-grid-table-resizer' align='center' cellspacing='0' cellpadding='2' width='750' height='300' >";
						var tableHtmlStr = "<div class='htmlGraphTable' style='float:left;width:100%;height:100%'><table border='0' bordercolor='red' class='x-grid-table x-grid-table-resizer' align='center' cellspacing='0' cellpadding='2'  height='100%' >";

						tableHtmlStr = tableHtmlStr+"<tr class='x-grid-row'>";
						tableHtmlStr = tableHtmlStr+"<td class='x-grid-cell' align='center' valign='middle' style='height:100%'>";
						//tableHtmlStr = tableHtmlStr+"<div id='dayWiseChartCont' style='position:relative;margin:0px;'></div>";
						tableHtmlStr = tableHtmlStr+"<div id='dayWiseChartCont' style='position:relative;margin:0px;border:0px solid green'></div>";
						tableHtmlStr = tableHtmlStr+"</td>";
						tableHtmlStr = tableHtmlStr+"</tr>";
						tableHtmlStr = tableHtmlStr+"</table></div>";

						containerObj.update(tableHtmlStr);
						if(appConstants.chartType=='fusionchart')
						{
						if (FusionCharts("dayWiseChartObj" ))
							FusionCharts("dayWiseChartObj").dispose();
							var myChart = new FusionCharts(data['swfpath'],'dayWiseChartObj', "100%", "100%","0","1");
							myChart.setXMLData(data['xmlData']);
							myChart.setTransparent(true);
							myChart.render('dayWiseChartCont');
						}
						else
						{
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('dayWiseChartCont',data.chartHeight,data.chartWidth), lineChart);
							lineChart.setData(data,'<%=currentDateFormat%>','');
							lineChart.drawChart();
						}
						appConstants.isGraphDataAvailable = false;
					}
			}
			var userWiseDataContainer=Ext.getCmp('userWiseData');
			if(!Ext.isEmpty(userWiseDataContainer))
			{
				var userTable = userWiseDataContainer.data;

				var userTableValues= userTable['userTableValues'];
				if(!Ext.isEmpty(userTableValues))
				{
					var mainTabTitle = userTable['tableTitle'];
					userWiseDataContainer.setTitle(mainTabTitle);
						//prakash for new design
					var height2 = userWiseDataContainer.getHeight()-65;
					var heights = userWiseDataContainer.getHeight()-125;
						//
					var userTableLength = userTableValues.length;
					//prakash for new design
					//var tableHtmlStr1 = '<div style="text-align:center;" class="newTable"><div class="sessionAnalysisInnerHeader" >'+userTable["subTitle"]+'</div><table class="x-grid-table x-grid-table-resizer">';
					
					var tableHtmlStr1 = '<div class="newTable" style="text-align:center;margin:0px 10px 10px 10px;height:'+height2+'px"><table width="100%" ><thead><tr><th style="text-align:left;height:40px;text-transform:none" class="newFont_bold13">'+userTable["subTitle"]+'</th></tr></thead><tr><td width="100%" style="padding:0px;border:0px"><div style="display:inline-block;overflow:auto;margin-bottom:10px;height:'+heights+'px;width:100%" class="newTable"><table width="100%" ><tbody >';

					/*tableHtmlStr1 = tableHtmlStr1+'<tr>';
					for(var user in userTableValues)
					{
						var userObj = userTableValues[user];
						if(user%2==0)
						{
							tableHtmlStr1 = tableHtmlStr1+'</tr>';
							tableHtmlStr1 = tableHtmlStr1+'<tr>';
						}
						tableHtmlStr1 = tableHtmlStr1+'<td valign="top" align="left" style="width:50%"><div class="ellipsisText">';
						var urlData=userObj["hrefUrl"];
						if(urlData!=null && urlData!='undefined' && urlData!='-')
							tableHtmlStr1 = tableHtmlStr1+'<a href="'+userObj["hrefUrl"]+'"> &nbsp;'+userObj["val"]+'</a>';
						else
							tableHtmlStr1 = tableHtmlStr1+'&nbsp;'+userObj["val"];

					}*/
					var count = 1;
					var tempCount = 0;
					for(var jj=0;jj<userTableValues.length;jj++)
					{
						if(tempCount == 0)
						{
							tableHtmlStr1 = tableHtmlStr1+'<tr>';
						}
						else
						{
							tempCount = 0;
						}
						var userObj = userTableValues[jj];
						tableHtmlStr1 = tableHtmlStr1+'<td valign="top" align="left" style="width:50%"><div class="ellipsisText">';
						var urlData=userObj["hrefUrl"];
						if(urlData!=null && urlData!='undefined' && urlData!='-')
							tableHtmlStr1 = tableHtmlStr1+'<a href="'+userObj["hrefUrl"]+'"> &nbsp;'+userObj["val"]+'</a>';
						else
							tableHtmlStr1 = tableHtmlStr1+'&nbsp;'+userObj["val"];
						tableHtmlStr1 = tableHtmlStr1+'</div></td>';
						tempCount++;
						if(count%2==0)
						{
							tableHtmlStr1 = tableHtmlStr1+'</tr>';
						}
						count++;
					}
						if(userTableValues.length!=0)
						{
							 tableHtmlStr1 = tableHtmlStr1+'<td>&nbsp;</td></tr>';
						}
					
					tableHtmlStr1 = tableHtmlStr1+'</tbody></table></div></td></tr></table></div>';
					//
 					userWiseDataContainer.update(tableHtmlStr1);
				}
				else
				{
					userWiseDataContainer.hide();
				}
			}
			}
		});
		initLoadMask.hide();
	},
	loadThinClientSessionReportData : function(jsonData)
	{
		var resultPanelObj=Ext.getCmp('resultPanel');
		var dataContainer = Ext.getCmp('dataContainer');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
 		var gridContainer=Ext.getCmp('gridContainer');
		initLoadMask.hide();
		var noOfChart=0;
		if(!Ext.isEmpty(jsonData))
		{
			resultPanelObj.removeAll();
			var itemsArray =new Array();
			var isGraphDataAvailable = false;
			var dataAvailable = jsonData['dataAvailable'];
			if(!Ext.isEmpty(dataAvailable) && dataAvailable=="true")
			{
				var reportType = jsonData.pageParams['rtype'];
				var dataType;
				dataType = jsonData['DataType'];
				if(!Ext.isEmpty(reportType) && reportType=="Yes")
				{
					Ext.getCmp('gridContainer').hide();
					dataContainer.hide();
					var chartJsonData = jsonData['chartJsonData'];
					var mainTabTitle = jsonData['graphMainTitle'];
					resultPanelObj.setTitle("<span class='newfont_bold15'>"+mainTabTitle+"</span>");
 					if(!Ext.isEmpty(chartJsonData))
					{
 						for(var graphContentIdx in chartJsonData)
						{
							var jsonObj = chartJsonData[graphContentIdx];
							var url = jsonObj.chartUrl;
							var chartProperties=this.getXmlForUrl(url);
							if (!Ext.isEmpty( chartProperties ) && chartProperties.hasOwnProperty('xmlData') ){
								isGraphDataAvailable = true;
 								var chartbox={
									xtype:'panel',
									//cls:'containerShadow',
									ui:'newGraphPanel',
									flex:0.65,
									//margin:10,
									margin:'0 10 10 10',
									title:chartProperties.chartTitle,
									data: chartProperties,
									id: 'fusion'+noOfChart
								};
								itemsArray.push(chartbox);
								noOfChart++;
							}
							var graphTitle = jsonObj.graphTitle;
							var url1 = jsonObj.chartUrl2;
							var chartProperties1=this.getXmlForUrl(url1);
							if (!Ext.isEmpty( chartProperties1 ) && chartProperties1.hasOwnProperty('xmlData') ){
 								isGraphDataAvailable = true;
								var chartbox={
									xtype:'panel',
									data: chartProperties1,
									//cls:'containerShadow',
									ui:'newGraphPanel',
									flex:1,
									margin:'0 10 10 10',
									//title:graphTitle,
									id: 'fusion'+noOfChart
								};
								itemsArray.push(chartbox);
								noOfChart++;
							}
						}
						resultPanelObj.add(itemsArray);
						resultPanelObj.show();
 						if(isGraphDataAvailable)
						{
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("printTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
							Ext.getCmp("csvTool").setDisabled(true);
							Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selDetailsJson);
						}
					}
				}
				else if(!Ext.isEmpty(dataType) && dataType=="dayWiseAndUserWiseData")
				{
					var meController = this;
					resultPanelObj.removeAll();
					gridContainer.removeAll(); //swami
					appConstants.itemsArray =new Array();
					var dayWiseChartJson = jsonData['dayWiseChartJson'];
					if(!Ext.isEmpty(dayWiseChartJson))
					{
						appConstants.isGraphDataAvailable=true;
						isDataAvailable = true;
						var userTable = jsonData['userTable'];
						var chartbox={
													xtype:'panel',
													margin:'0 0 0 10',
													layout: {
														type: 'hbox',
														align:'stretch',
													},
													items:[
															{
																xtype:'container',
																layout: {
																	type: 'vbox',
																	align:'stretch',
																},
																items:[{
																	xtype:'container',
																	margin:'0 10 10 0',
																	height:70,
																	width:380,
																	ui:'newContainer',
																	html:'<table width="100%" height="100%"><tr><td valign="middle" class="newFont_bold14">Unique Users accessing the farm</td><td valign="middle" align="right" style="padding-right:10px" class="newFont_bold30">'+userTable.userTableValues.length+'</td></tr></table>',
																},{
																	xtype:'panel',
																	frame:false,
																	data: userTable,
																	width:380,
																	flex:1,
																	//cls:'datapanel',
																	ui:'newGraphPanel',
																	margin:'0 10 10 0',
																	id: 'userWiseData',
																	name : 'userWiseData',
																	//title:'dsdsds',
																	//width:750
																}],
															},{
																xtype:'panel',
																data: jsonData,
																border:true,
																frame:false,
																flex:1,
																margin:'0 10 10 0',
																//cls:'datapanel',
																ui:'newGraphPanel',
																id: 'dayWiseChart',
																name : 'dayWiseChart',
																//width:1000,
																title:mainTabTitle,
															}
														] };
						appConstants.itemsArray.push(chartbox);
						gridContainer.add(appConstants.itemsArray);
						if(appConstants.isGraphDataAvailable)
						{
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("printTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
							Ext.getCmp("csvTool").setDisabled(false);
						}
					}
					dataContainer.removeAll(); //swami. this removes anything in the 2nd page new panel.
					gridContainer.show();
					resultPanelObj.hide();
					gridContainer.doLayout();
					 appConstants.publicJsonData['hiddenParams'] = jsonData['hiddenParams'];
					 this.loadDaywiseChart(jsonData);
				}
				else
				{
					gridContainer.hide();
					dataContainer.removeAll();
					var mainTabTitle = jsonData['summaryTableTitle'];
					var htmlStr="";
 					var summaryTableJson = jsonData['summaryTableJson'];
					var cnt=0;
						htmlStr += "<div class='newTable' style='margin:0px 10px 10px 10px'><table border='0' width='100%'>";
						htmlStr = htmlStr+'<tbody>';
						for(var sKey in summaryTableJson)
						{
							var value = summaryTableJson[sKey];
							var dispVal = value['val'];
							var hrefUrl = value['hrefUrl'];
							var dispVal1 =dispVal;
							if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
							{
								if(dispVal!=null && dispVal=="top.gif")
								{
									dispVal='<div class="iconArrowUp"></div>';
								}
								dispVal1 = '<div align="cen ter"><a href="javascript:void(0);" onclick=showDrillDownData("'+hrefUrl+'") >'+dispVal+'</a></div>'
							}
							else if(dispVal !=null && dispVal!='undefined')
								dispVal1=dispVal;
							else
								dispVal1 = "-";
							cnt++;
							htmlStr=htmlStr+"<tr><td><div>"+sKey+"</div></td><td><div>"+dispVal1+'</div></td></tr>';
						}
						htmlStr=htmlStr+"</tbody></table></div>";
					if(cnt!=0)
					{
						dataContainer.add({
							xtype:'container',
							layout:{type:'vbox',align:'center'},
							items:[{
									xtype:'panel',
									//cls:'datapanel',
									ui:'newGraphPanel',
									margin:'5 10 5 10',
									frame:false,
									overflow:scroll,
									border:true,
									width:450,
									height:200,
									title:mainTabTitle,
									html : htmlStr
								}]
						});
					}else{
						var summaryTableJson = jsonData['allTypeUniqueUsrSummary'].split(':');
						var uniqueTblStr ='';
						appConstants.userListStr = jsonData['userListStr'].toString();
						//var uniqueTblStr = "<div class='x-table'><table border='0' class='x-grid-table x-grid-table-resizer'><tbody>";
						uniqueTblStr += "<div class='newTable' style='margin:0px 10px 10px 10px'><table border='0' width='100%'>";
						uniqueTblStr = uniqueTblStr+'<tbody>';
						var uniqueHeaderNme=[sessionCompletedTxt+' ('+numberTxt+')',avgDuration+' ('+minsLbl+')',maximumDurationTxt+' ('+minsLbl+')',uniqueUserTxt];
						var popLinlUu='';
						for(var uu=0;uu<4;uu++){
							  if(uu!=3)
						      uniqueTblStr += "<tr><td><div>"+uniqueHeaderNme[uu]+"</div></td><td><div>"+summaryTableJson[uu]+'</div></td></tr>';
							  else
						      //uniqueTblStr += "<tr><td><div>"+uniqueHeaderNme[uu]+"</div></td><td><div><a href='javascript:void(0);' onclick=showUniqueUsrLst()>"+summaryTableJson[uu]+"</a></div></td></tr>";
						      uniqueTblStr += "<tr><td><div>"+uniqueHeaderNme[uu]+"</div></td><td><div>"+summaryTableJson[uu]+"</div></td></tr>";
						}
						uniqueTblStr +='</tbody></table></div>';
						dataContainer.add({
							xtype:'container',
							layout:{type:'vbox',align:'center'},
							items:[{
									xtype:'panel',
									//cls:'datapanel',
									ui:'newGraphPanel',
									margin:'5 10 5 10',
									frame:false,
									overflow:scroll,
									border:true,
									width:450,
									height:145,
									title:jsonData['summaryTableTitle'],
									html : uniqueTblStr
								}]
						});
					}
					dataContainer.show();
					dataContainer.doLayout();
					var isDataAvailable = false;
					var gridArr = jsonData['sessionDetailsTableArr'];
					if(!Ext.isEmpty(gridArr))
					{
						publicGridData=gridArr; 
						isDataAvailable = this.loadGrid(gridArr,jsonData);
					}
					if(isDataAvailable)
					{
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						Ext.getCmp("csvTool").setDisabled(false);
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selDetailsJson);
					}
					else
					{
						Ext.getCmp("bookletTool").setDisabled(true);
						Ext.getCmp("saveTool").setDisabled(true);
						Ext.getCmp("printTool").setDisabled(true);
						Ext.getCmp("mailTool").setDisabled(true);
						Ext.getCmp("csvTool").setDisabled(true);
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selDetailsJson);
					}
				}
				if(!isGraphDataAvailable && !isDataAvailable)
				{
					gridContainer.hide();
					resultPanelObj.hide();
					dataContainer.hide();
 					this.getNomeasurepanel().show();
				}
			}
			else
			{
				gridContainer.hide();
				resultPanelObj.hide();
				dataContainer.hide();
 				this.getNomeasurepanel().show();
			}
		}
		else
		{
			gridContainer.hide();
			resultPanelObj.hide();
			dataContainer.hide();
			this.getNomeasurepanel().doLayout();
			this.getNomeasurepanel().show();
		}
 		this.loadCharts(isGraphDataAvailable,noOfChart);
	},
	loadCharts : function(isGraphDataAvailable,noOfChart)
	{
 		if(isGraphDataAvailable)
		{
			for ( var i = 0; i < noOfChart; i++ )
			{
				var containerObj=Ext.getCmp('fusion'+i);
				var data = containerObj.data;
   				var reportData=data.reportData;//jsonData['reportData']
				if (Ext.isEmpty(appConstants.erUtils))
				{
					appConstants.erUtils = Ext.widget("erutils");
				}
				if ( !Ext.isEmpty( data ) && data.hasOwnProperty('xmlData') )
				{
					var chartFor =data.chartType;
					if(chartFor =='bar')
					{
						appConstants.erUtils.updateBarChart(appConstants.chartType,null,data.xmlData,data.swfpath,reportData,reportData.chartHeight-20,reportData.chartWidth,containerObj);
					}
					else if(chartFor =='pie')
					{
						appConstants.erUtils.updatePieChart(appConstants.chartType,data.legendListJsonArr,'legendColor','urlLink','legendLabel',null,data.xmlData,data.swfpath,data,containerObj);
					}
					else if(chartFor == 'distributionBarChart')
					{
						appConstants.erUtils.updateBarChart(appConstants.chartType,data.chartTitle,data.xmlData,data.swfpath,data,data.chartHeight,data.chartWidth,containerObj);
					}
				}
				else
				{
					containerObj.update('<div><img src="/final/reporter/images/nographformeasure.gif" width="100%" /></div>');
				}
			}
 		}
	},
	loadDaywiseChart : function(jsonData)
	{
			var containerObj=Ext.getCmp('dayWiseChart');
			if(!Ext.isEmpty(containerObj))
			{
				var jsonData = containerObj.data;
				var data = jsonData['dayWiseChartJson'];

				var finalHtmlStr = '';
				if(appConstants.isGraphDataAvailable)
				{
					var tableHtmlStr = "<div class='htmlGraphTable' style='float:left;width:100%;height:100%'><table border='0' bordercolor='red' class='x-grid-table x-grid-table-resizer' align='center' cellspacing='0' cellpadding='2'  height='100%' >";
					tableHtmlStr = tableHtmlStr+"<tr class='x-grid-row'>";
					tableHtmlStr = tableHtmlStr+"<td class='x-grid-cell' align='center' valign='middle' style='height:100%'>";
					tableHtmlStr = tableHtmlStr+"<div id='dayWiseChartCont' style='position:relative;margin:0px;border:0px solid green'></div>";
					tableHtmlStr = tableHtmlStr+"</td>";
					tableHtmlStr = tableHtmlStr+"</tr>";
					tableHtmlStr = tableHtmlStr+"</table></div>";

					containerObj.update(tableHtmlStr);
					if(appConstants.chartType=='fusionchart')
					{
					if (FusionCharts("dayWiseChartObj" ))
						FusionCharts("dayWiseChartObj").dispose();
						var myChart = new FusionCharts(data['swfpath'],'dayWiseChartObj', "100%", "100%","0","1");
						myChart.setXMLData(data['xmlData']);
						myChart.setTransparent(true);
						myChart.render('dayWiseChartCont');
					}
					else
					{
						var lineChart = {};
						lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('dayWiseChartCont',data.chartHeight,data.chartWidth), lineChart);
						lineChart.setData(data,'<%=currentDateFormat%>','');
						lineChart.drawChart();
					}
					appConstants.isGraphDataAvailable = false;
				}
		}
		var userWiseDataContainer=Ext.getCmp('userWiseData');
		if(!Ext.isEmpty(userWiseDataContainer))
		{
			var userTable = userWiseDataContainer.data;

			var userTableValues= userTable['userTableValues'];
			if(!Ext.isEmpty(userTableValues))
			{
				var mainTabTitle = userTable['tableTitle'];
				//prakash
				var mainTabTitles_1='';
				var mainTabTitles = '';
				if(mainTabTitle!=null && mainTabTitle.indexOf("-") > -1)
				{
					mainTabTitles_1 = mainTabTitle.substr(0,mainTabTitle.indexOf("-"));
					mainTabTitles = mainTabTitle.substr(mainTabTitle.indexOf("-")+1, mainTabTitle.length)
					//userWiseDataContainer.setTitle('<div style="line-height:1.5em">'+mainTabTitles_1+'</div>'+mainTabTitles);
					//userWiseDataContainer.setTitle('<div style="line-height:1.5em">'+mainTabTitles_1+' <br/><span class="newFont_normal12">'+mainTabTitles+'</span></div>');
				}  
				else
				{
					 userWiseDataContainer.setTitle('<div style="line-height:1.5em">'+mainTabTitle+'</div>');
				}
				//
				var contHeight2 = userWiseDataContainer.getHeight()-65;
				var contHeight = userWiseDataContainer.getHeight()-125;
				//userWiseDataContainer.setTitle('<div style="line-height:1.5em">'+mainTabTitle+' <br/><span class="newFont_normal12" >XD713-SVR-VDA1:1494:Citrix XenApp 7.x</span></div>');
				var userTableLength = userTableValues.length;
				var tableHtmlStr1 = '<div class="newTable" style="text-align:center;margin:0px 10px 10px 10px;height:'+contHeight2+'px"><table width="100%" ><thead><tr><th style="text-align:left;height:40px;text-transform:none" class="newFont_bold13">'+userTable["subTitle"]+'</th></tr></thead><tr><td width="100%" style="padding:0px;border:0px"><div style="display:inline-block;overflow:auto;margin-bottom:10px;height:'+contHeight+'px;width:100%" class="newTable"><table width="100%" ><tbody>';
				
				var count = 1;
				var loopCount = 0;
				for(var ii=0;ii<userTableValues.length;ii++)
				{
					if(loopCount==0)
					{
						tableHtmlStr1 = tableHtmlStr1+'<tr>';
					}
					else
					{
						loopCount = 0;
					}
					var userObj = userTableValues[ii];
					tableHtmlStr1 = tableHtmlStr1+'<td valign="top" align="left" style="width:50%"><div class="ellipsisText">';
					var urlData=userObj["hrefUrl"];
					
					if(urlData!=null && urlData!='undefined' && urlData!='-')
						tableHtmlStr1 = tableHtmlStr1+'<a href="'+userObj["hrefUrl"]+'">&nbsp;'+userObj["val"]+'</a>';
					else
						tableHtmlStr1 = tableHtmlStr1+'&nbsp;'+userObj["val"];
					tableHtmlStr1 = tableHtmlStr1+'</div></td>';
					
					loopCount++;

					if(count%2==0)
					{
					  tableHtmlStr1 = tableHtmlStr1+'</tr>';
					}
					count++;
				}
				if(userTableValues.length%2!=0)
				{
					tableHtmlStr1 = tableHtmlStr1+'<td>&nbsp;</td></tr>';
				}
				
				tableHtmlStr1 = tableHtmlStr1+'</tbody></table></div></td></tr></table></div>';
				userWiseDataContainer.update(tableHtmlStr1);
			}
			else
			{
				userWiseDataContainer.hide();
			}
		}
	},
	submitReport:function(){
		initLoadMask.show();
		var thinClientSettingsForm =null;
		if(isSettingsEnabled)
			thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
 		var reportGeneration=this.getSettingsFieldValue(thinClientSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		appConstants.publicJsonData['hiddenParams']['daychartfor'] = '';
		var val = Ext.getCmp('reportTypeComboBox').getValue();
		if(val == 'No')
		{
			var er_uniqueUserObj = Ext.getCmp('er_uniqueUser');
			if((er_uniqueUserObj!=undefined && er_uniqueUserObj.checked)|| appConstants.publicJsonData['er_uniqueUser'] )
			{
				appConstants.publicJsonData['hiddenParams']['daychartfor'] = 'uniqueuser';
			}
			if((er_uniqueUserObj!=undefined && !er_uniqueUserObj.checked))
			{
				appConstants.publicJsonData['hiddenParams']['daychartfor'] = '';
			}
		}
 		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		if(reportGeneration == 'foreground'){
 			this.updateQueryString();
			Ext.Ajax.request(
			{
				url : '../servlet/com.eg.ErCtxServerReportC?isSubmit=true',
				params : queryString+"&responseType=json&thinClientSessionAction=submit",
				method :'POST',
				scope:this,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData=Ext.decode(jsonText);
						this.loadThinClientSessionReportData(jsonData);
					}
				}
			});
		}
		else if(reportGeneration == 'background'){
			Ext.getCmp('gridContainer').hide();
			Ext.getCmp('dataContainer').hide(); //swami. hides the grids used in the first page
			this.updateQueryString();
			resultPanelObj.hide();
			initLoadMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url : '../servlet/com.eg.ErStartBackGroundReportC',
				scope:this,
				params : queryString+"&bg_reportname="+bg_reportname+"&isSubmit=true&responseType=json&thinClientSessionAction=showBackgroundReportResult",
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					this.loadBgReportData(jsonData);
				}
			});
			//initLoadMask.hide();
		}
		else if(reportGeneration == 'background-csv'){
			Ext.getCmp('gridContainer').hide();
			Ext.getCmp('dataContainer').hide(); //swami. hides the grids used in the first page
			this.updateQueryString();
			resultPanelObj.hide();
			initLoadMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url : "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV",
				scope:this,
				params : queryString+"&bg_reportname="+bg_reportname+"&isSubmit=true&responseType=json&thinClientSessionAction=showBackgroundReportResult",
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					this.loadBgReportData(jsonData);
				}
			});
			//initLoadMask.hide();
		}
	},
	loadBgReportData : function(jsonData)
	{
 		var htmlStr = '';
		var backgroundReportStatus=jsonData.pageParams['backgroundReportStatus'];
		Ext.getCmp('gridContainer').hide();
		Ext.getCmp('resultPanel').hide();
		if(backgroundReportStatus!= 'undefined')
		{
			var bgroundResponseTxt=jsonData.pageParams['langSupportMsg'];
			var bgroundReportsURL=jsonData.pageParams['bgrdUrl'];
			var backgroundAnchor=jsonData.screenLabels['linkMsg'];
			//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+backgroundAnchor+'</a></div></div></center>';
			
			if(backgroundReportStatus!=null && backgroundReportStatus=='success')
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
		
			else if(backgroundReportStatus!=null && backgroundReportStatus=='duplicate')
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
		}
		else
		{
			//htmlStr = '<span>Error In BackGround Generation</span>';
			htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</a></div></td></tr></table></td></tr></table>';
		}
		this.getBackGroundPanel().update(htmlStr);
 		this.getBackGroundPanel().show();
		initLoadMask.hide();
	},
	loadGrid:function(GridArrays,jsonData){
		var isDataAvailable = false;
 		var dataContainer=Ext.getCmp('dataContainer');
		var datagridItemsArr=new Array();
		var me = this;
		if ( !Ext.isEmpty( GridArrays ) ){
			for(var i in GridArrays){
				var gridDataObj=GridArrays[i];
				var columnDetails=gridDataObj.columns;
				var dataArraytoStore=gridDataObj.measureData;
				var noOfColumns=gridDataObj.TOTAL_COLUMN_COUNT;
				var singleColumnCount=gridDataObj.SINGLE_SUBCOLUMN_COUNT;
				var viewPortWidth=this.getMain().getWidth();
				var COLUMN_MIN_WIDTH=35;
				var SINGLE_COLUMN_WIDTH=50;
				var SERVER_MIN_WIDTH=160;
				var count=0;
				var mutipleColumns=noOfColumns-singleColumnCount;
				var widthNeeded=150+(mutipleColumns*COLUMN_MIN_WIDTH)+(singleColumnCount*SINGLE_COLUMN_WIDTH);

				var units=gridDataObj.unitForMeasure;
				var fieldstoStore =  new Array();
				var mainColumnsObjArray	=  new Array();
				var eachWidth=0;
				if(viewPortWidth>widthNeeded){
					eachWidth=(viewPortWidth-(SERVER_MIN_WIDTH))/noOfColumns;
				}
				else{
					eachWidth=COLUMN_MIN_WIDTH;
				}
				for( var key in columnDetails ){
					var mainColumn=key;
					var subColumns=new Array();
					var subColObjArray=new Array();
					subColumns=columnDetails[key];
					if(subColumns!=undefined && !Ext.isEmpty(subColumns)){
						var subColumnCount=subColumns.length;
						var adujstedWidth=eachWidth;
						if(subColumnCount == 1){
							if(eachWidth<SINGLE_COLUMN_WIDTH)
							adujstedWidth=SINGLE_COLUMN_WIDTH;
						}
						else if(subColumnCount>1)
						{
							if(eachWidth<SINGLE_COLUMN_WIDTH)
							{
								adujstedWidth=SINGLE_COLUMN_WIDTH;
							}

							adujstedWidth = adujstedWidth / subColumnCount;
						}
						for(var j in subColumns)
						{
							var tmp=subColumns[j];
							fieldstoStore.push(mainColumn+"_"+tmp);
							var unit=units[mainColumn];
							var header=tmp
							if (!Ext.isEmpty(unit))
							{
								header+=" ("+unit+")";
							}
							subColObjArray.push({
								header: header,
								sortable:true,
								dataIndex: mainColumn+"_"+tmp,
								align:'center',
								width:adujstedWidth,
								listeners:{
									sortchange:function(ct, column, e, t, eOpts ){
										thisController.gridColIndexParam=column.getIndex();
										thisController.gridColStateParam=column.sortState;
   									}
								},
								doSort: function(state) {
 											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													v1 = v1.get(field);
													v2 = v2.get(field);

													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;

													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									var dispVal = value['dispVal'];
									if(!Ext.isEmpty(dispVal))
									{
										var hrefUrl = value['hrefUrl'];
										value =dispVal;
										if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
										{
											if(dispVal!=null && dispVal=="top.gif")
											{
												this.sortable=false;
 												dispVal='<div class="iconArrowUp"></div>';
											}
											value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onclick=showDrillDownData("'+encodeURI(hrefUrl)+'") >'+dispVal+'</a></div>'
										}
										if(dispVal.indexOf('div')==-1)
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
									}
									else
									{
										metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									}
									return value;
								}
							});
						}
						var measureColumns = new Array();
						var s_unit=units[mainColumn];
						var measureColumnName="&nbsp;";
						if(!Ext.isEmpty(s_unit))
						{
							measureColumnName=" ("+units[mainColumn]+")";
						}
 						mainColumnsObjArray.push(
						{
							header: mainColumn,
							columns: subColObjArray,
							locked:false,
						});
					}
					else
					{
						if(count==0){
							fieldstoStore.push(mainColumn);
							mainColumnsObjArray.push({
								header: mainColumn,
								sortable:true,
								locked:true,
								minWidth:SERVER_MIN_WIDTH,
								dataIndex: mainColumn,
								align:'left',
								flex:1,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									var dispVal = value['dispVal'];
									if(!Ext.isEmpty(dispVal))
									{
										var hrefUrl = value['hrefUrl'];
										value =dispVal;
										if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
										{
											if(dispVal!=null && dispVal=="top.gif")
											{
												this.sortable=false;
												dispVal='<div class="iconArrowUp"></div>';
											}
											value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onclick=showDrillDownData("'+encodeURI(hrefUrl)+'") >'+dispVal+'</a></div>'
										}
										if(dispVal.indexOf('div')==-1)
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
									}
									else
									{
										metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									}
									return value;
								}
							});
						}
						else{
							fieldstoStore.push(mainColumn);
							subColObjArray.push({
									header: '&nbsp',
									sortable:true,
									dataIndex: mainColumn,
									align:'center',
									width:eachWidth,
									listeners:{
									sortchange:function(ct, column, e, t, eOpts ){
										thisController.gridColIndexParam=column.getIndex();
										thisController.gridColStateParam=column.sortState;
   									}
								},
								doSort: function(state) {
 											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													v1 = v1.get(field);
													v2 = v2.get(field);
													if(v1['dispVal']!=undefined)
														v1=v1['dispVal'];
													if(v2['dispVal']!=undefined)
														v2=v2['dispVal'];
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;

													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										var dispVal = value['dispVal'];
										if(!Ext.isEmpty(dispVal))
										{
											var hrefUrl = value['hrefUrl'];
											value =dispVal;
											if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
											{
												if(dispVal!=null && dispVal=="top.gif")
												{
													this.sortable=false;
													dispVal='<div class="iconArrowUp"></div>';
												}
												value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onclick=showDrillDownData("'+encodeURI(hrefUrl)+'") >'+dispVal+'</a></div>'
											}
											if(dispVal.indexOf('div')==-1)
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
										}
										else
										{
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
										}
											return value;
									}
								});
  							mainColumnsObjArray.push(
							{
								header: mainColumn,
								locked:false,
								columns: subColObjArray
							});
						}
					}
					count++;
				}
				var isPagingHidden;
				gridPageSize=15;
				if (dataArraytoStore.length<gridPageSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				if(!Ext.isEmpty(dataArraytoStore))
				{
					var thisController=this;
					var storeObj = Ext.create('Ext.data.ArrayStore', {
					fields:fieldstoStore,
							proxy : {
						type : 'pagingmemory',
						reader : {
							type: 'array', root : 'data', totalProperty : 'total'
						},
						data:dataArraytoStore,
					},
						data:dataArraytoStore,
						remoteSort : true,
						autoLoad : true,
						pageSize:gridPageSize,
						sorters: { property: fieldstoStore[0], direction : 'ASC' }// vengat
					});

					datagridItemsArr.push(
						{
							xtype:'panel',
							ui:'newGraphPanel',
							margin:'10 10 10 10',
							title:gridDataObj.tableTitle,
							items:[
								{
									xtype:'customgrid',
									store:storeObj,
									columns:mainColumnsObjArray,
									needtoFixColumn:true,
									id:'gridId'+i,
									//cls:'gridSkin horizontal-scroll',
									ui:'newGridPanel',
									frame:false,
									border:true,
									margin:'5 10 10 10',
									padding:0,
									//title:'<span class="font_bold">'+gridDataObj.tableTitle+'</span>',
									listeners:{
										sortchange:function(ct, column, e, t, eOpts ){
											thisController.gridColIndexParam=column.getIndex();
											thisController.gridColStateParam=column.sortState;
										},
										render:function(obj){
											/*Ext.defer(function() {
											obj.columns[0].setSortState("ASC",true,true);
											},100);*/
										}
									},
									dockedItems:[{
										xtype:'pagingtoolbar',
										cls:'newPagination',
										dock: 'bottom',
										displayInfo: true,
										store: storeObj,
										hidden:isPagingHidden,
										displayInfo: true,
										displayMsg: 'Displaying topics {0} - {1} of {2}',
										emptyMsg: "No topics to display",
										listeners: {
											change : function(thisd, params)
											{   
												if(!Ext.isEmpty(params))
													activePage = params.currentPage;
												else
													activePage=1;
											}
										}
									}]
								}
							]
						}	
					);
				}
			}
			Ext.getCmp("csvTool").setDisabled(false);
			if(!Ext.isEmpty(datagridItemsArr))
			{
				dataContainer.add(datagridItemsArr);
				dataContainer.show();
				dataContainer.doLayout();
				var compType = Ext.getCmp('compTypeComboBox').getValue();
				if (compType!="All Types")
				{
					isDataAvailable=this.noMeasureForData(jsonData);
				}
				else
				{
					isDataAvailable = true;
				}
				
			}
		}
		return isDataAvailable;
	},
	noMeasureForData:function(jsonData)
	{
		isDataAvailable= false;
		var summaryTableJson = jsonData['summaryTableJson'];
		if (!Ext.isEmpty(summaryTableJson) && jsonData.hasOwnProperty('summaryTableJson'))
		{
			for(var sKey in summaryTableJson)
			{
				var value = summaryTableJson[sKey];
				
				var dispVal = value['val'];
				var hrefUrl = value['hrefUrl'];
				var dispVal1 =dispVal;
				if((dispVal=="-" && hrefUrl=="-") || (value==undefined && dispVal==undefined && hrefUrl==undefined))
				{
					isDataAvailable=false;
				}
				else
				{
					isDataAvailable=true;
				}
			}
		}
		return isDataAvailable;
	},
	reportGenChange:function(){
		var thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
  		this.disableTools();
		var reportGenType=thinClientSettingsForm.findField('reportGeneration').getValue();
		if(reportGenType== 'background'){
			thinClientSettingsForm.findField('bgReportName').setValue("");
			thinClientSettingsForm.findField('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else if(reportGenType== 'background-csv'){
			thinClientSettingsForm.findField('bgReportName').setValue("");
			thinClientSettingsForm.findField('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}

		else{
			thinClientSettingsForm.findField('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
		Ext.getCmp('resultPanel').hide();
		Ext.getCmp('gridContainer').hide();
	},
	changeTrend:function(combo) {
		this.disableTools();
		var thinClientSettingsForm =null;
		if(isSettingsEnabled)
			thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var startDateObj=thinClientMainForm.findField('er_stdate');
		var startHrObj=thinClientMainForm.findField('er_sthr');
		var endDateObj=thinClientMainForm.findField('er_enddate');
		var endHrObj=thinClientMainForm.findField('er_endhr');
		var timelineObj=thinClientMainForm.findField('er_timeline');
		var me = this;
		if(timelineObj.getValue() == 'Any'){
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else{
			startDateObj.setDisabled(true);
			startHrObj.setDisabled(true);
			endDateObj.setDisabled(true);
			endHrObj.setDisabled(true);
		timelineObj.suspendEvents(true);
		}
		var showDataOption = 'No';
		var showDataComboVal =this.getSettingsFieldValue(thinClientSettingsForm,'showDataComboBox',isSettingsEnabled,'selectedShowDataOption');
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + showDataComboVal + "]";
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param1,
						scope : this,
						async : true,
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							var comboVal=jsonData.combo;
							var timelineRawData = jsonData.combo;
							var timelineCombo = Ext.getCmp('er_timeline');
							timelineCombo.getStore().removeAll();
							timelineCombo.getStore().loadRawData(jsonData.combo);
							var flag=false;
							for(var i = 0; i < comboVal.length; i++)
							{
							  if(comboVal[i].valueField == er_timeline)
							  {
								flag=true;
							  }
							}
							if(flag)
								timelineCombo.setValue(er_timeline);
							else
								timelineCombo.setValue("1 day");
						}
					});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal = appConstants.publicJsonData['hiddenParams']["inidate"];
			
			var param_val = "";  
		if (showDataComboVal == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js
			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
				});
		}
		timelineObj.resumeEvents();
	},
	/* weekendOnChange:function(){
		var thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
		var weekendvalue=thinClientSettingsForm.findField('excludeWeekendsComboBox').getValue();
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
		}
		else
		{
			excludeDaysObj.hide();
		}
	}, */
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQueryString:function(){
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var thinClientSettingsForm =null;
		if(isSettingsEnabled)
			thinClientSettingsForm = this.getThinclientsessionsettings().getForm();

		var mainFormParams;
		var settingsFormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var selectedZone =thinClientMainForm.findField('zoneComboBox').getValue();
		var compType = thinClientMainForm.findField('compTypeComboBox').getValue();
		if((appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true') && appConstants.analysisby != null && appConstants.analysisby == 'ComponentType')
			compType = appConstants.analysis;

		var reportType = thinClientMainForm.findField('reportTypeComboBox').getValue();
		var er_mode =  thinClientMainForm.findField('er_mode').getValue();
		var startDt =  thinClientMainForm.findField('er_stdate').dataArray;
		var endDt =  thinClientMainForm.findField('er_enddate').dataArray
		var timeline =  thinClientMainForm.findField("er_timeline").getValue();
		var stHr = thinClientMainForm.findField('er_sthr').dataArray;
		var enHr = thinClientMainForm.findField('er_endhr').dataArray;
		var opt = '';

		var fromTime =this.getSettingsFieldValue(thinClientSettingsForm,'timefrom',isSettingsEnabled,'selectedFromTime');
		var toTime =this.getSettingsFieldValue(thinClientSettingsForm,'timeto',isSettingsEnabled,'selectedToTime');
		var minfrom =this.getSettingsFieldValue(thinClientSettingsForm,'minfrom',isSettingsEnabled,'selectedFromMin');
		var minto =this.getSettingsFieldValue(thinClientSettingsForm,'minto',isSettingsEnabled,'selectedToMin');

		var trendOption =this.getSettingsFieldValue(thinClientSettingsForm,'showDataComboBox',isSettingsEnabled,'selectedShowDataOption');
		var excludeWeekendOption =this.getSettingsFieldValue(thinClientSettingsForm,'excludeWeekendsComboBox',isSettingsEnabled,'selectedExcludeWeekEndOption');
		var reportGeneration =this.getSettingsFieldValue(thinClientSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
		mainFormParams="select_farm="+selectedZone+"&er_select_server="+compType+"&er_type="+reportType;
		
			var erOption=Ext.getCmp('er_option');
			if(erOption!=undefined)
			{
				mainFormParams+="&er_option="+erOption.getValue();
				if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
				{
					var erSite=Ext.getCmp('er_site');
					mainFormParams+="&er_site="+erSite.getValue();
				}
			}
		if(!Ext.isEmpty(reportType))
		{
			var selectedReportType = reportType;
			if(selectedReportType=="Yes")
			{
				var measure = thinClientMainForm.findField('measureComboBox').getValue();
				mainFormParams = mainFormParams+'&select_testmes='+measure;
				opt = 'chart';
			}
			else
			{
				opt = 'data';
			}
		}
		settingsFormParams="&er_excwe="+excludeWeekendOption+"&er_trenddata="+trendOption+"&er_mode="+er_mode+"&er_reportgenration="+reportGeneration+'&opt='+opt;
		var timelineParams="&er_timeline="+timeline+"&startdate="+startDt+"&enddate="+endDt+"&starthr="+stHr+"&endhr="+enHr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;;
		var timperiodParams="&timefrom="+fromTime+"&minfrom="+minfrom+"&timeto="+toTime+"&minto="+minto;
		var hiddenQstr = '';
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		for( var hid in hiddenData)
		{
			hiddenQstr +='&'+hid+'='+hiddenData[hid];
		}
		queryString=mainFormParams+settingsFormParams+timelineParams+hiddenQstr+timperiodParams;
		if(reportGeneration!=null && (reportGeneration=="background" || reportGeneration=="background-csv"))
		{
			queryString = queryString+"&forwardto=ErCtxSessionReportJson";
		}
		else
		{
			queryString = queryString+"&forwardto=ErCtxSessionReport";
		}
		if(Ext.getCmp('er_uniqueUser')!=undefined)
			queryString = queryString+"&er_uniqueUser="+(Ext.getCmp('er_uniqueUser').checked);
		queryString = queryString+"&select_compType="+encodeURIComponent(compType);
		//by karthikeyan
		queryString+= '&er_RmDispName='+appConstants.er_RmDispName;
	},
	loadMainElements:function()
	{
		var thinClientMainForm = this.getThinclientsessionreportsform().getForm();
		var selectedReportType = appConstants.publicJsonData.pageParams['selectedReportType'];

		var reportTypeCombo = thinClientMainForm.findField('reportTypeComboBox');
		reportTypeCombo.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.common.Report Type']);
		reportTypeCombo.getStore().loadRawData(appConstants.publicJsonData['repTypeJson']);
		reportTypeCombo.setValue(selectedReportType);
		
		var reportTypeCombo = thinClientMainForm.findField('er_option');
		reportTypeCombo.getStore().loadRawData(appConstants.publicJsonData['analysisByCombo']);
		var selectedAnalysis=appConstants.publicJsonData.selectedAnalysisByCombo;
		if (selectedAnalysis!=null && selectedAnalysis!='' && selectedAnalysis!='undefined' && selectedAnalysis!=undefined)
		{
			reportTypeCombo.setValue(appConstants.publicJsonData.selectedAnalysisByCombo);
		}
		else
		{
			reportTypeCombo.setValue("-1");
		}
		var zoneCombo = thinClientMainForm.findField('zoneComboBox');
		zoneCombo.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.thin.Zone']);
		zoneCombo.getStore().clearFilter(true);
		zoneCombo.getStore().loadRawData(appConstants.publicJsonData['zoneListJson']);
		var selectedZone=appConstants.publicJsonData.pageParams['selectedZone'];
		if (selectedZone!=null && selectedZone!='' && selectedZone!='undefined' && selectedZone!=undefined)
		{
			zoneCombo.setValue(appConstants.publicJsonData.pageParams['selectedZone']);
		}
		else
		{
			zoneCombo.setValue("-1");
		}
		var compTypeCombo= Ext.getCmp('compTypeComboBox');
		compTypeCombo.getStore().clearFilter(true);
		compTypeCombo.getStore().loadRawData(appConstants.publicJsonData['compTypeJson']);
		if((appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true') && appConstants.analysisby != null && appConstants.analysisby == 'ComponentType')
			compTypeCombo.setValue(appConstants.analysis);
		else
			compTypeCombo.setValue(appConstants.publicJsonData.pageParams['selectedCompType']);

		var measureCombo = thinClientMainForm.findField('measureComboBox');
		measureCombo.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.thin.Criteria']);
		measureCombo.getStore().clearFilter(true);
		measureCombo.getStore().loadRawData(appConstants.publicJsonData['measureOpts']);
		measureCombo.setValue(appConstants.publicJsonData.pageParams['selectedMeasure']);
		if(!Ext.isEmpty(selectedReportType) && selectedReportType=="Yes")
		{
			measureCombo.show();
		}
		else
		{
			measureCombo.hide();
		}
		var hiddenParams = appConstants.publicJsonData["hiddenParams"];
        	var from_schedule = hiddenParams["fromScheduleModify"];
        	var fromFavoriteModify = hiddenParams["fromFavoriteModify"];
        	if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}

		var selectedAnalysisByCombo='';
		if (appConstants.publicJsonData.hasOwnProperty('selectedAnalysisByCombo'))
		{
			selectedAnalysisByCombo=appConstants.publicJsonData.selectedAnalysisByCombo;
		}
		var mainForm=thinClientMainForm;
		if(selectedAnalysisByCombo=='Zone')
		{
			Ext.getCmp('er_site').hide();
			comboRawData = appConstants.publicJsonData.zoneListJson;
			selectedComboOption = appConstants.publicJsonData.pageParams.selectedZone;
			comboObject = mainForm.findField("zoneComboBox");
			comboObject.setFieldLabel('Zone');
			comboObject.getStore().clearFilter(true);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		else if(selectedAnalysisByCombo=='Segment')
		{
			Ext.getCmp('zoneComboBox').hide();
			 comboRawData = appConstants.publicJsonData.siteCombo;
			selectedComboOption = appConstants.publicJsonData.pageParams.selectedSiteCombo;
			comboObject = mainForm.findField("er_site");
			comboObject.setFieldLabel('Segment');
			comboObject.getStore().clearFilter(true);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		else if(selectedAnalysisByCombo=='Service')
		{
			Ext.getCmp('zoneComboBox').hide();
			comboRawData = appConstants.publicJsonData.siteCombo;
			selectedComboOption = appConstants.publicJsonData.pageParams.selectedSiteCombo;
			comboObject = mainForm.findField("er_site");
			comboObject.setFieldLabel('Service');
			comboObject.getStore().clearFilter(true);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		else if(selectedAnalysisByCombo=='Component')
		{
			Ext.getCmp('zoneComboBox').hide();
			Ext.getCmp('er_site').hide();
		}
		var er_type=Ext.getCmp('reportTypeComboBox').getValue();
		if(er_type=='Yes')
		{
			var measureCombo = mainForm.findField('measureComboBox');
			measureCombo.getStore().clearFilter(true);
			measureCombo.getStore().loadRawData(appConstants.publicJsonData['measureOpts']);
			measureCombo.setValue(appConstants.publicJsonData.pageParams['selectedMeasure']);
			Ext.getCmp('measureComboBox').show();
		}
		else
		{
			Ext.getCmp('measureComboBox').hide();
		}
		if (appConstants.publicJsonData.pageParams['selectedShowDataOption']=='Yes')
		{
			isTrend=true;
		}
		var timelineCombo = thinClientMainForm.findField('er_timeline');
		timelineCombo.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.common.Timeline']);
		timelineCombo.getStore().loadRawData(appConstants.publicJsonData['timelineJSONArray']);
		timelineCombo.setValue(appConstants.publicJsonData.pageParams['selectedTimeline']);

		var startDateObj = thinClientMainForm.findField('er_stdate');
		startDateObj.setValue(appConstants.publicJsonData.pageParams['startDateForDisplay']);
		startDateObj.dataArray = appConstants.publicJsonData.pageParams['startDate'];
		var startHrObj = thinClientMainForm.findField('er_sthr');
		startHrObj.setValue(appConstants.publicJsonData.pageParams['startHourForDisplay']);
		startHrObj.dataArray = appConstants.publicJsonData.pageParams['startHour'];
		var endDateObj = thinClientMainForm.findField('er_enddate');
		endDateObj.setValue(appConstants.publicJsonData.pageParams['endDateForDisplay']);
		endDateObj.dataArray = appConstants.publicJsonData.pageParams['endDate'];
		var endHrObj = thinClientMainForm.findField('er_endhr');
		endHrObj.setValue(appConstants.publicJsonData.pageParams['endHourForDisplay']);
		endHrObj.dataArray =appConstants.publicJsonData.pageParams['endHour'];
		stmin = appConstants.publicJsonData.pageParams['startMinForDisplay']
		enmin = appConstants.publicJsonData.pageParams['endMinForDisplay']
        mgr_stmin = appConstants.publicJsonData.pageParams['startmin'];
        mgr_enmin = appConstants.publicJsonData.pageParams['endmin'];
	
		var graphModeCombo =  thinClientMainForm.findField('er_mode');
		graphModeCombo.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.common.Graph']);
		graphModeCombo.setValue(appConstants.publicJsonData.pageParams['graphmode']);

		if(!Ext.isEmpty(selectedReportType) && selectedReportType=="Yes")
		{
			graphModeCombo.show();
		}
		else
		{
			graphModeCombo.hide();
		}
		updateAppSettings();
	},
	loadSettingsElements:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var favorite_id = appConstants.publicJsonData['hiddenParams']["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
		var selectedReportType = appConstants.publicJsonData.pageParams['selectedReportType'];
		var val = Ext.getCmp('reportTypeComboBox').getValue();
		if(val == 'No')
		{
			if(Ext.getCmp('er_uniqueUser')!=undefined)
				Ext.getCmp('er_uniqueUser').show();
		}
		else
		{
			if(Ext.getCmp('er_uniqueUser')!=undefined)
				Ext.getCmp('er_uniqueUser').hide();
		}
		var showDataCombo = thinClientSettingsForm.findField('showDataComboBox');
		showDataCombo.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.common.Show Data']);
		showDataCombo.getStore().loadRawData(appConstants.publicJsonData['showDataOptJson']);
		showDataCombo.setValue(appConstants.publicJsonData.pageParams['selectedShowDataOption']);
		var trendenablee=appConstants.publicJsonData.hiddenParams['trendenable'];
		if(trendenablee == 'false'){
			Ext.getCmp('showDataComboBox').hide();
		}
		else
		{
			Ext.getCmp('showDataComboBox').show();
		}
		var excludeWeekendsCombo = thinClientSettingsForm.findField('excludeWeekendsComboBox');
		excludeWeekendsCombo.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.common.Exclude weekends']);
		excludeWeekendsCombo.getStore().loadRawData(appConstants.publicJsonData['excludeWeekDaysOpt']);
		excludeWeekendsCombo.setValue(appConstants.publicJsonData.pageParams['selectedExcludeWeekEndOption']);

		//var excludeDaysObj=Ext.getCmp('excludeDays');
		//excludeDaysObj.update(appConstants.publicJsonData.screenLabels['reporter.common.Excludes']);

		var fromTimeLbl=Ext.getCmp('fromTimeLbl');
		fromTimeLbl.setText(appConstants.publicJsonData.screenLabels['reporter.common.From']);
		var fromHrsLbl=Ext.getCmp('fromHrsLbl');
		fromHrsLbl.setText(appConstants.publicJsonData.screenLabels['reporter.common.Hrs']);
		var fromMinsLbl=Ext.getCmp('fromMinsLbl');
		fromMinsLbl.setText(appConstants.publicJsonData.screenLabels['reporter.common.Mins']);
		var toTimeLbl=Ext.getCmp('toTimeLbl');
		toTimeLbl.setText(appConstants.publicJsonData.screenLabels['reporter.common.To']);
		var toHrsLbl=Ext.getCmp('toHrsLbl');
		toHrsLbl.setText(appConstants.publicJsonData.screenLabels['reporter.common.Hrs']);
		var toMinsLbl=Ext.getCmp('toMinsLbl');
		toMinsLbl.setText(appConstants.publicJsonData.screenLabels['reporter.common.Mins']);

		var timefrom = thinClientSettingsForm.findField('timefrom');
		timefrom.setValue(appConstants.publicJsonData.pageParams['selectedFromTime']);
		var minfrom = thinClientSettingsForm.findField('minfrom');
		minfrom.setValue(appConstants.publicJsonData.pageParams['selectedFromMin']);
		var timeto = thinClientSettingsForm.findField('timeto');
		timeto.setValue(appConstants.publicJsonData.pageParams['selectedToTime']);
		var minto = thinClientSettingsForm.findField('minto');
		minto.setValue(appConstants.publicJsonData.pageParams['selectedToMin']);

		stmin = appConstants.publicJsonData.pageParams['startMinForDisplay'];
		enmin = appConstants.publicJsonData.pageParams['endMinForDisplay'];

		updatingAppSettings();
		var repoGen="";
		if (!Ext.isEmpty(appConstants.repotgene) && appConstants.repotgene!=undefined && appConstants.repotgene!='undefined')
		{
			repoGen=appConstants.repotgene;
		}
		else
		{
			repoGen=appConstants.publicJsonData;
		}
		var reportGenerationCombo = thinClientSettingsForm.findField('reportGeneration');
		reportGenerationCombo.setFieldLabel(appConstants.publicJsonData.screenLabels['reporter.consolidated.Report Generation']);
		reportGenerationCombo.getStore().loadRawData(repoGen['repGenOptJson']);
		reportGenerationCombo.setValue(repoGen['reportGeneration']);
		Ext.getCmp('er_uniqueUser').setValue(repoGen['er_uniqueUser']);

		var thisController = this;
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			   thisController.validateAndCloseSettings();
		});
	},
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if(isSettingsOk)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.submitReport();
		}
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype:'thinclientsessionsettings',
					parent:this
				}
			],
			renderTo:'thinclientsession-innerCt'
			});
	} ,
	afterMainRender:function(){
		var thisController = this;

		var thinClientSettingsForm ="";
		if(isSettingsEnabled)
			thinClientSettingsForm = this.getThinclientsessionsettings().getForm();
		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			var reportGeneration =this.getSettingsFieldValue(thinClientSettingsForm,'reportGeneration',isSettingsEnabled,'er_reportgenration');
			if(reportGeneration == 'foreground'){
				dataType = appConstants.publicJsonData['DataType'];
				if(!Ext.isEmpty(dataType) && dataType=="dayWiseAndUserWiseData")
				{
					this.loadThinClientSessionReportData(appConstants.publicJsonData);
				}else
					this.showResult();
			}
			else
			{
				this.loadBgReportData(appConstants.publicJsonData);
			}
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				this.showResult();
				appConstants.isForceSubmit='false';
			}
		}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		if(!hideBackButton){
			Ext.getCmp('thinclientsessionreportsform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		initLoadMask.hide();

		if(appConstants.fromDailyMailer || appConstants.fromDailyMailer == 'true')
			this.showResult();
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}
		else
			value = appConstants.publicJsonData.pageParams[jsonParam];

		return value;
	},
	loadUniqueUsrLst: function () {
         var userNames = appConstants.userListStr.split(',');
         
		 var usertableHtml = '<div style="text-align:center;" class="x-table"><div class="sessionAnalysisInnerHeader" >User</div><table class="x-grid-table x-grid-table-resizer">';
             usertableHtml = usertableHtml+'<tr class="x-grid-row">';
					for(var uNme=0;uNme<userNames.length;uNme++)
					{
						if(uNme%4==0)
						{
							usertableHtml = usertableHtml+'</tr>';
							usertableHtml = usertableHtml+'<tr class="x-grid-row">';
						}
						usertableHtml = usertableHtml+'<td valign="top" class="x-grid-cell"><div class="x-grid-cell-inner">';
						usertableHtml = usertableHtml+'&nbsp;'+userNames[uNme];

						
					}
					usertableHtml = usertableHtml+'</div></tr>';
					usertableHtml = usertableHtml+'</table></div>';
            
			var graphpopup=Ext.widget('uniqueUserPopup');
			graphpopup.add({
				xtype: 'outerPanel',
				cls:'outerpanel',
				margin: 0,
				frame:false,
				hidden: false,
				layout: {type:'vbox',align:'stretch'},
				tools: [{xtype: 'uniqueUserPopupTools'}],
				items: [{
					xtype:'panel',
					border:true,
					frame:false,
					cls:'datapanel',
					id: 'drillDownResultPanel',
					name : 'drillDownResultPanel',
					title:'Unique user list',
					width:750,
					html: usertableHtml
							  }
						]
					});
			graphpopup.show();
	}
});