
Ext.define('thinclientuserreports.controller.ThinclientUserReports',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'usertimeline',ref:'usertimeline'},
		{selector: 'thinclientuserform',ref: 'thinclientuserform'},
		{selector: 'egcomponent',ref: 'egcomponent'},
		{selector: 'mainform',ref: 'mainform'},
		{selector: 'thinclientusersettings',ref: 'thinclientusersettings'},
		{selector: 'reporterdata',ref:'reporterdata'},
 		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({

			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.afterMainRender,
				'boxready':this.refreshReportData
			},
           	'thinclientusersettings':{
				'afterrender':this.loadSettingsElements
            		},
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'mainform combo[name="select_farm"]':{
				'select': this.zoneOnChange
			},
			'mainform combo[name="report_category"]':{
				'select': this.reportCatChange
			},
			'mainform combo[name="er_type"]':{
				'select': this.reportTypeOnChange
			},
			'mainform combo[name="er_graphType"]':{
				'select': this.graphTypeOnChange
			},
			'mainform multiselect[name="er_server"]':{
				'change': this.serverOnChange
			},
			'mainform button[id="expandSelector"]': {
                'click': this.expandMe
            },
			'mainform combo[name="er_compType"]':{
				'select': this.compTypeOnChange
			},
			'mainform combo[name="er_wrkrGrp"]':{
				'select': this.workerGroupOnChange
			},
			/* 'thinclientusersettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			}, */
			'thinclientusersettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'thinclientusersettings combo[id="ShowResourceDetails"]':
			{
				'select': this.changeResourceDetails
			},

			'thinclientusersettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'thinclientusersettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'thinclientusersettings radiogroup[id="adGroupFns"]':{
				'change': this.adGroupChange
			},
			'thinclientusersettings radiogroup[id="clientIpRadio"]':{
				'change': this.onShowDetailsClientVersion
			},
			'mainform button[itemId="submit"]':{
				'click': this.showResult
			},
			'mainform button[itemId="save"]': {
					"click": this.goTo
			},
			'mainform combo[name="er_organize"]':{
				'select': this.organizeOnChange
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'mainform trigger[id="compSearch"]':{
				'change': this.filterMultiselect
			},
			'mainform combo[name="er_application"]':{
				'select': this.applicationOnChange
			},
			'main button[id="bckButtonForDrillDown"]':{
				'click': this.loadDrillDownBack
			},
			'mainform combo[id="er_option"]':
			{
				'select': this.onSelectAnalysisBy
			},
			'mainform combo[id="er_organize"]':
			{
				'select': this.onOraganizeBy
			},
			'mainform radiogroup[id="aggregateValue"]':
			{
				'change': this.onShowDetails
			},
			'adgroup button[id="adgroupExpand"]':{
				'click': this.expandMe
			},
			'adgroup trigger[id="adgroupSearch"]':
			{
				'change': this.filterMultiselect
			},
			'adgroup multiselect[id="er_adGroup"]':
			{
				'change': this.selectGroup
			},
			'aduserinfo button[id="adUserExpand"]':{
				'click': this.expandMe
			},
			'aduserinfo trigger[id="aduserSearch"]':
			{
				'change': this.filterMultiselect
			},
			'egdesktoppools button[id="er_poolType_expand"]':{
				'click': this.expandMe
			},
			'egdesktoppools trigger[id="er_poolType_Search"]':
			{
				'change': this.filterMultiselect
			},
			'aduserinfo multiselect[id="er_aduser"]':
			{
				'change': this.selectAdGroupUsers
			}

		});
	},
	onOraganizeBy:function()
	{		
		if(targetType == 'User Session Report')
		{
			if(isSettingsEnabled)	
			{
				var clientIpRadio=Ext.getCmp("clientIpRadio");
				var objVal=Ext.getCmp("er_organize").getValue();
				if(objVal=='User')
				{
					//
					var adgrouppane =Ext.getCmp('adgrouppane');
						if(adgrouppane!=undefined)
							adgrouppane.hide();
						var aduserinfopane =Ext.getCmp('aduserinfopane');
						if(aduserinfopane!=undefined)
							aduserinfopane.hide();

						var adGroupFns =Ext.getCmp('adGroupFns');
						if(adGroupFns!=undefined)
							adGroupFns.hide();

					if(appConstants.userState!=undefined && appConstants.userState=='dropdown')
						Ext.getCmp('er_application').show();
					else if(appConstants.userState!=undefined && appConstants.userState=='textbox')
						Ext.getCmp('er_application_text_box').show();

					//
					Ext.getCmp("aggregateValue").show();
					if(appConstants.publicjsonDataUsage!=null && appConstants.publicjsonDataUsage!=undefined && appConstants.publicjsonDataUsage!='undefined')
					{
						if (appConstants.publicjsonDataUsage.hasOwnProperty("clientDetailsCompType"))
						{
							if(clientIpRadio!=undefined)
								clientIpRadio.show();
						}
						else
						{
							if(clientIpRadio!=undefined)
								clientIpRadio.hide();
						}						
					}
				}else
				{
						//
						var adgrouppane =Ext.getCmp('adgrouppane');
						if(adgrouppane!=undefined)
							adgrouppane.show();
						var aduserinfopane =Ext.getCmp('aduserinfopane');
						if(aduserinfopane!=undefined)
							aduserinfopane.show();

						var adGroupFns =Ext.getCmp('adGroupFns');
						if(adGroupFns!=undefined)
							adGroupFns.show();

				var application=Ext.getCmp('er_application');
				var application_text=Ext.getCmp('er_application_text_box');
				appConstants.userState;



				 if(appConstants.userState!=undefined && appConstants.userState=='dropdown')
					{
						Ext.getCmp('er_application').hide();

					}
				else if(appConstants.userState!=undefined && appConstants.userState=='textbox')
					{
						Ext.getCmp('er_application_text_box').hide();
					}

				else if( application.isVisible())
				{
					appConstants.userState='dropdown';
					Ext.getCmp('er_application').hide();
				}

				else if(application_text.isVisible())
				{
					appConstants.userState='textbox';
					Ext.getCmp('er_application_text_box').hide();
				}
				//
					Ext.getCmp("aggregateValue").hide();
					if(adGroupFns!=undefined ){
						var adGroupFnsVal=adGroupFns.getValue().adGroupByValue;
						if(adGroupFnsVal == 'Details')
						{
							if(appConstants.publicjsonDataUsage!=null && appConstants.publicjsonDataUsage!=undefined && appConstants.publicjsonDataUsage!='undefined')
							{
								if (appConstants.publicjsonDataUsage.hasOwnProperty("clientDetailsCompType"))
								{
									if(clientIpRadio!=undefined)
										clientIpRadio.show();
								}
								else
								{
									if(clientIpRadio!=undefined)
										clientIpRadio.hide();
								}						
							}
						}else
						{
							if(clientIpRadio!=undefined)
								clientIpRadio.hide();
						}	
					}
				}
			}
			else
			{


				var objVal=Ext.getCmp("er_organize").getValue();
				var agv=Ext.getCmp("aggregateValue");

				var clientIpRadio=Ext.getCmp("clientIpRadio");

				var adgrouppane=Ext.getCmp("adgrouppane");
				var aduserinfopane=Ext.getCmp("aduserinfopane");
				var adGroupFns=Ext.getCmp("adGroupFns");

				if(objVal=='User')
				{

					if(adgrouppane!=undefined)
						adgrouppane.hide();

					if(aduserinfopane!=undefined)
						aduserinfopane.hide();

					if(adGroupFns!=undefined)
						adGroupFns.hide();


					if(appConstants.userState!=undefined && appConstants.userState=='dropdown')
						Ext.getCmp('er_application').show();
					else if(appConstants.userState!=undefined && appConstants.userState=='textbox')
						Ext.getCmp('er_application_text_box').show();

					//

					if(agv!=undefined)
						agv.show();

					if(appConstants.publicjsonDataUsage!=null && appConstants.publicjsonDataUsage!=undefined && appConstants.publicjsonDataUsage!='undefined')
					{
						if (appConstants.publicjsonDataUsage.hasOwnProperty("clientDetailsCompType"))
						{
							if(clientIpRadio!=undefined)
								clientIpRadio.show();
						}
						else
						{
							if(clientIpRadio!=undefined)
								clientIpRadio.hide();
						}						
					}
					
				}
				else
				{
					if(adgrouppane!=undefined)
						adgrouppane.show();

					if(aduserinfopane!=undefined)
						aduserinfopane.show();

					if(adGroupFns!=undefined)
						adGroupFns.show();

				//
				var application=Ext.getCmp('er_application');
				var application_text=Ext.getCmp('er_application_text_box');
				appConstants.userState;



				 if(appConstants.userState!=undefined && appConstants.userState=='dropdown')
					{
						Ext.getCmp('er_application').hide();

					}
				else if(appConstants.userState!=undefined && appConstants.userState=='textbox')
					{
						Ext.getCmp('er_application_text_box').hide();
					}
				else if( application.isVisible())
				{
					appConstants.userState='dropdown';
					Ext.getCmp('er_application').hide();
				}

				else if(application_text.isVisible())
				{
					appConstants.userState='textbox';
					Ext.getCmp('er_application_text_box').hide();
				}

					if(agv!=undefined)
						agv.hide();

					if(clientIpRadio!=undefined)
					clientIpRadio.hide();
				}

			}

		}
	},
				selectGroup:function( thisObj, newValue, oldValue, eOpts )
	{

		if(oldValue==undefined || oldValue=='undefined')
		return;


		if ( newValue == '-1' || newValue == '' )
		{
			return;
		}
		else
		{

		var er_adGroup = Ext.getCmp('er_adGroup');

		var param='';
		if(er_adGroup!=undefined){
			var queryArray=er_adGroup.getValue();

			if(!this.multiSelectAllvalidation(er_adGroup.getValue(),"All"))
			{
				Ext.MessageBox.show({
				title: 'ALERT',
				msg: 'All and Individual Groups cannot be selected simultaneously!',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			for (var key in queryArray)
			{
			param+="&er_adGroup="+encodeURIComponent(queryArray[key]);
			}
		}
		initLdgMask.show();

		Ext.Ajax.request({
				url: '/final/reporter/ErCtxUserReportJson.jsp',
				params: param,
				method: 'POST',
				scope: this,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{

						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						appConstants.AdData=jsonData;
						var adUserCombo = Ext.getCmp('er_aduser');
						var adGroupUserComboData = jsonData['adGroupUserCombo'];
						var selectedAdGroupUser = jsonData['selectedAdGroupUser'];
						if ( !Ext.isEmpty( adGroupUserComboData ) )
						{
							adUserCombo.suspendEvents(true);
							adUserCombo.getStore().loadRawData(adGroupUserComboData);
							if ( !Ext.isEmpty(selectedAdGroupUser) ){
								adUserCombo.setValue(selectedAdGroupUser);
							}
							else{
								 var value=adGroupUserComboData[0].valueField;
									if(adGroupUserComboData.length>1)
										value=adGroupUserComboData[1].valueField;
										adUserCombo.setValue(value);
								}
							}

					}
					initLdgMask.hide();
				},
				failure: function()
				{
					initLdgMask.hide();
				}
		})
		//
		}
	},
	selectAdGroupUsers:function( thisObj, newValue, oldValue, eOpts )
	{
		if(oldValue==undefined || oldValue=='undefined')
		return;

		if ( newValue == '-1' || newValue == '' )
		{
			return;
		}
		else
		{

		var er_aduser = Ext.getCmp('er_aduser');

		if(er_aduser!=undefined){
			//
			if(!this.multiSelectAllvalidation(er_aduser.getValue(),"All"))
			{
				Ext.MessageBox.show({
				title: 'ALERT',
				msg: 'All and Individual Users cannot be selected simultaneously!',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			//
		 }
		}
	},
	onShowDetailsClientVersion:function()
	{
		var clientIpRadio=Ext.getCmp('clientIpRadio');
		if(clientIpRadio != undefined && clientIpRadio.getValue().clientIp=='Yes' && !isVm)
		{
			if(wildcardSearch)
				Ext.getCmp('wildcardSearch').show();
		}
		else
		{
			if(wildcardSearch)
				Ext.getCmp('wildcardSearch').hide();
		}

	},
	onShowDetails:function()
	{		

			var clientIpRadio=Ext.getCmp('clientIpRadio');

			var objVal=Ext.getCmp("er_organize").getValue();
				if(objVal!=undefined &&(objVal!='User'))
				{
					if(clientIpRadio!=undefined){
					Ext.getCmp('clientIpRadio').hide();
					return;
					}
				}
		var value=Ext.getCmp('aggregateValue').getValue();
		if(!Ext.isEmpty(value))
		{		
			if(value.groupByValue=='Details')
			{				
			 if(appConstants.publicjsonDataUsage!=null && appConstants.publicjsonDataUsage!=undefined && appConstants.publicjsonDataUsage!='undefined')
			 {
				if (appConstants.publicjsonDataUsage.hasOwnProperty("clientDetailsCompType"))
				{
					if(clientIpRadio!=undefined)
					{
						Ext.getCmp('clientIpRadio').show();
						var clientIpVal=Ext.getCmp('clientIpRadio').getValue().clientIp;
						if(clientIpVal != undefined && clientIpVal=='Yes')
						{
							if(wildcardSearch)
								Ext.getCmp('wildcardSearch').show();
						}
						else
						{
							if(wildcardSearch)
								Ext.getCmp('wildcardSearch').hide();
						}
					}
				}
				else
				{
					if(clientIpRadio!=undefined)
					 Ext.getCmp('clientIpRadio').hide();
					if(wildcardSearch)
						Ext.getCmp('wildcardSearch').hide();
				}	
			 }
			 else
			  {
				 if(clientIpRadio!=undefined)
				  Ext.getCmp('clientIpRadio').hide();
				 if(wildcardSearch)
					Ext.getCmp('wildcardSearch').hide();
			  }
			}
			else
			{
				if(clientIpRadio!=undefined)
				{
				clientIpRadio.setValue({clientIp: 'No'});
				Ext.getCmp('clientIpRadio').hide();
				}
				if(wildcardSearch)
					Ext.getCmp('wildcardSearch').hide();
			}
		}
	},
	onSelectAnalysisBy: function (obj) {
		var params="";
 		
		var reportCat=Ext.getCmp('report_category').getValue();
		var urlStr="";
		initLdgMask.show();
		if(targetType == 'User Session Report')
		{		
			this.updateQStringUsage(false);
			params=appConstants.queryStringUsage;
			urlStr="/final/reporter/ErCtxUserReportJson.jsp";
		}else
		{
			this.updateQStringActivity();
			params=appConstants.queryStringActivity;
			if(targetType == 'User Channel Report')
				urlStr="/final/reporter/ErCtxChannelReportJson.jsp";
			else
				urlStr="/final/reporter/ErCtxUserActivityReportJson.jsp";
		}
		params+="&onAnalysisChange=true";
		var me=this;
		
		 Ext.Ajax.request({
            url: urlStr,
            params: params,
            method: "POST",
            success: function(response) {
				var jsonData=Ext.decode(response.responseText);

				if(!Ext.isEmpty(jsonData))
				{
					if(targetType == 'User Session Report')
					{
						me.fillFormFieldsForUsage(jsonData);
					}else
					{
						me.fillFormFieldsForActivity(jsonData);
					}
					if (Ext.getCmp('er_option').getValue()=='Component')
							Ext.getCmp('select_farm').hide();
						else
							Ext.getCmp('select_farm').show();
				}
				Ext.getCmp('resultPanel').hide();
				initLdgMask.hide();
			}
		});
	},
	goTo: function (btn) {
 		var reportCat=Ext.getCmp('report_category').getValue();
		var hiddenFields;
		if(reportCat == 'user_usage')
			hiddenFields =  appConstants.publicjsonDataUsage.hiddenfields;
		else
			 hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveFavorite(btn);
		}
    },
	applicationOnChange : function() {
		var me=this;
		var mainForm =Ext.getCmp('mainform').getForm();
		var userSelected = Ext.getCmp("er_application").getValue();
		if (userSelected == '-- All --')
		{
			appConstants.isAllUserSelected = 'true';
			if(appConstants.isAdDiscoverEnabled == "true" && appConstants.isAllUserSelected == 'true'){
			var comboRawData=appConstants.publicjsonDataUsage.organizeCombo;
			var selectedComboOption=appConstants.publicjsonDataUsage.selectedOrganizeby;
			var comboObject=mainForm.findField('er_organize');
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			//if(jsonData.selectedUser == '--All--'){
					comboObject.show();
					me.onOraganizeBy();
			}
		} else {
			mainForm.findField('er_organize').hide();
			mainForm.findField('er_priority').setValue("ALL");
			//Ext.getCmp('adgrouppane').hide();
			var adgrouppane =Ext.getCmp('adgrouppane');
			if(adgrouppane!=undefined)
				adgrouppane.hide();
			//
			var aduserinfopane =Ext.getCmp('aduserinfopane');
			if(aduserinfopane!=undefined)
				aduserinfopane.hide();
			var adGroupFns =Ext.getCmp('adGroupFns');
			if(adGroupFns!=undefined)
				adGroupFns.hide();
			//
		}
	},
	 changeEr_mode: function (combo) {
		var favorite_id='';
		var from_schModify='';
		var reportCat=Ext.getCmp('report_category').getValue();

		if(reportCat == 'user_usage')
		{
			favorite_id = appConstants.publicjsonDataUsage['hiddens']["favorite_id"];
			from_schModify = appConstants.publicjsonDataUsage['hiddens']["fromScheduleModify"];
		}else{
			favorite_id = appConstants.publicjsonDataActivity['hiddens']["favorite_id"];
			from_schModify = appConstants.publicjsonDataActivity['hiddens']["fromScheduleModify"];
		}

		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.showResult();
     },
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();

	  // appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_server'),appConstants.rawDataForComponents);
	  	 if (obj.getId()=='compSearch')
				appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_server'),appConstants.rawDataForComponents);

	     else if (obj.getId()=='er_poolType_Search')
				appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_poolType'),appConstants.rawDataForPoolType);
	     else if (obj.getId()=='adgroupSearch')
				appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_adGroup'),appConstants.publicjsonDataUsage.adGroupCombo);
			
			else if (obj.getId()=='aduserSearch')
			 {
				if(appConstants.AdData!=undefined)
				 {
				appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_aduser'),appConstants.AdData.adGroupUserCombo);
				 }
				else
				{
				appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_aduser'),appConstants.publicjsonDataUsage.adGroupUserCombo);
				 }
		 
			}
    },
	organizeOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
	},
	compTypeOnChange:function(obj){
		initLdgMask.show();
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportCat=mainForm.findField('report_category').getValue();
		var urlForAjax;
		if(reportCat == 'user_usage'){
			urlForAjax="/final/reporter/ErCtxUserReportJson.jsp";
						//
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();

			//
			this.updateQStringUsage(false);
			Ext.Ajax.request(
			{
				url : '/final/reporter/ErCtxUserReportJson.jsp',
				params : appConstants.queryStringUsage+"&triggeredfrom=CompType",
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicjsonDataUsage=jsonData;
					if(!jsonData.hasVMs && jsonData.isVm && needDesktopSearch)
					{
						Ext.getCmp('er_server_text_box').setValue(jsonData.er_guestname);
						Ext.getCmp('er_server_text_box').show();
					}
					else
					{
						Ext.getCmp('er_server_text_box').hide();
					}
					
					var screenLabels=jsonData.screenLabels;
					/*var enableOragnizeCombo=jsonData.enableOragnizeCombo;
					if(enableOragnizeCombo=='true')
						Ext.getCmp('er_organize').show();
					else
						Ext.getCmp('er_organize').hide();*/
					comboRawData=jsonData.WorkerGroupArray;
					selectedComboOption=jsonData.selectedWorkerGroup;
					comboObject=mainForm.findField('er_wrkrGrp');
					comboObject.setFieldLabel(screenLabels['reporter.thin.Worker Group']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					if(comboRawData.length>1 || comboRawData[0].valueField != 'notapplicable'){
						comboObject.show();
					}else{
						comboObject.hide();
					}
					comboRawData=jsonData.ComponentServerArray;
					selectedComboOption=jsonData.selectedComps;
					comboObject=Ext.getCmp('er_server');
					appConstants.rawDataForComponents = comboRawData;
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboRawData=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					comboObject=mainForm.findField('er_application');

					var showFromRawData=jsonData.showFromCombo;
					var selectedshowFrom=jsonData.selectedShowFromCombo;
					var showFromObj=mainForm.findField('showFrom');
					//showFromObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
					showFromObj.getStore().loadRawData(showFromRawData);
					if (!Ext.isEmpty(showFromRawData) )
					{
						if ( !Ext.isEmpty(selectedshowFrom) )
						{
							showFromObj.setValue(selectedshowFrom);
						}
						else
						{
							showFromObj.setValue(showFromRawData[0].valueField);
						}
					}
					if(jsonData.isVm)
					{
						isVm = true;
						if(wildcardSearch)
							Ext.getCmp('wildcardSearch').hide();
						var resourceDetails = Ext.getCmp('ShowResourceDetails');
						if((resourceDetails!=undefined && resourceDetails=='No')||appConstants.publicjsonDataUsage.er_showResourceUsage=='No' || appConstants.menuForVM=='true')
						{
							Ext.getCmp('showFrom').hide();
						}
						else
						{
							Ext.getCmp('showFrom').show();
						}
					}
					else
					{
						if(wildcardSearch)
							Ext.getCmp('wildcardSearch').show();
						isVm = false;
						Ext.getCmp('showFrom').hide();
					}
//
				if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined'){
					Ext.getCmp('er_application_text_box').hide();
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						var value=comboRawData[0].valueField;
						if(comboRawData.length>1)
							value=comboRawData[1].valueField;
						comboObject.setValue(value);
					}
					comboObject.show();
				}
				else
				{
					Ext.getCmp("aggregateValue").show();
						Ext.getCmp('er_application').hide();
						var textBoxObject=	mainForm.findField('er_application_text_box');
						textBoxObject.show();
				}

				var comboObject=mainForm.findField('er_organize');
				if(comboObject!=undefined)
				{
				var val=mainForm.findField('er_organize').getValue();

				if(val!=undefined && val!=null && (val=='AD'))
					{
					var adGroupFns=thinclientuserSettingsForm.findField('adGroupFns');
							if(adGroupFns!=undefined && adGroupFns.isVisible())
									{

										 if(appConstants.userState!=undefined && appConstants.userState=='dropdown')
											{
												Ext.getCmp('er_application').hide();
											}
										else if(appConstants.userState!=undefined && appConstants.userState=='textbox')
											{
												Ext.getCmp('er_application_text_box').hide();
											}
								}
					}
				}
						initLdgMask.hide();
				}
			});
		}else
		{
			if (targetType == "User Activity Report")
				urlForAjax="/final/reporter/ErCtxUserActivityReportJson.jsp?select_farm="+encodeURIComponent(mainForm.findField("select_farm").getValue())+"&er_comptype="+mainForm.findField("er_compType").getValue();
			else
				urlForAjax="/final/reporter/ErCtxChannelReportJson.jsp?select_farm="+encodeURIComponent(mainForm.findField("select_farm").getValue())+"&er_comptype="+mainForm.findField("er_compType").getValue();
			this.updateQStringActivity();
			Ext.Ajax.request(
			{
				url : urlForAjax,
				params : appConstants.queryStringActivity,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var screenLabels=jsonData.screenLabels;
					appConstants.publicjsonDataActivity=jsonData;
					if(isSettingsEnabled){
						var enableDesktop = jsonData.enableDesktop;
						if(enableDesktop=="true")
						{
							Ext.getCmp("dsktp_searchTxt").show();
							Ext.getCmp("dsktp_searchSpl").show();
						
						}else
						{
							Ext.getCmp("dsktp_searchTxt").hide();
							Ext.getCmp("dsktp_searchSpl").hide();
						}
					}
					if(mainForm.findField('er_type').getValue() == 'No')
					{
						comboRawData=jsonData.serverCombo;
						selectedComboOption=jsonData.selectedServer;
						comboObject=Ext.getCmp('er_server');
						appConstants.rawDataForComponents = comboRawData;
						comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
							if(comboRawData[0].valueField!=-1)
								comboObject.setValue(comboRawData[0].valueField);
							//else
								//comboObject.setValue(comboRawData[1].valueField);
							}
							//
							var s_sort=jsonData.sortbycombo;
							if(!Ext.isEmpty(s_sort))
							{
								var selected_s_sort=jsonData.selectedSortbyCombo;
								comboObject=mainForm.findField('er_sortby');
								comboObject.getStore().loadRawData(s_sort);
								if ( !Ext.isEmpty(selected_s_sort) ){
									comboObject.setValue(selected_s_sort);
								}
								else{
									comboObject.setValue(s_sort[0].valueField);
								}
							}
							//
						comboRawData=jsonData.userCombo;
						selectedComboOption=jsonData.selectedUser;
						comboObject=mainForm.findField('er_application');
				if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
					{
						Ext.getCmp('er_application_text_box').hide();
						comboObject.setFieldLabel(screenLabels['reporter.thin.User']);
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						} else {
							if(comboRawData[0].valueField!=-1)
								comboObject.setValue(comboRawData[0].valueField);
							else
							{
								var value=comboRawData[0].valueField;
								if(comboRawData.length>1)
									value=comboRawData[1].valueField;
								comboObject.setValue(value);
							}//added for components not auto select when change component type
						}
						comboObject.show();

					}
				else
					{
						Ext.getCmp('er_application').hide();
					var textBoxObject=	mainForm.findField('er_application_text_box');
						textBoxObject.show();
						Ext.getCmp("aggregateValue").hide();
					}

							Ext.getCmp('serverMultiSelectLbl').show();
					}
					else
					{
						if(!isSettingsEnabled)
							this.showConfigDropdown();
					var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
					var graphval=jsonData.selectedGraphType;
					comboRawData = jsonData.graphTypeArray;
					selectedComboOption = jsonData.selectedGraphType;
					comboObject = mainForm.findField("er_graphType");
					comboObject.setFieldLabel(screenLabels["reporter.thin.Graph Type"]);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
							comboObject.show();
						if (graphval == "timeline") {
				                        comboRawData = jsonData.aggbasedOn;
				                        selectedComboOption = jsonData.selectedAgg;
				                        comboObject = thinclientuserSettingsForm.findField("er_perserver");
				                        comboObject.setFieldLabel(screenLabels["reporter.thin.Aggregate across servers"]);
				                        comboObject.getStore().loadRawData(comboRawData);
				                        if (!Ext.isEmpty(selectedComboOption)) {
				                            comboObject.setValue(selectedComboOption);
				                        } else {
				                            comboObject.setValue(comboRawData[0].valueField);
				                        }
				                        comboObject.show();
				                        comboRawData = jsonData.userCombo;
				                        selectedComboOption = jsonData.selectedUser;
				                        comboObject = mainForm.findField("er_application");
								if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
									{
										Ext.getCmp('er_application_text_box').hide();
				                        comboObject.setFieldLabel(screenLabels["reporter.thin.User"]);
										comboObject.getStore().clearFilter(true); 
				                        comboObject.getStore().loadRawData(comboRawData);
				                        if (!Ext.isEmpty(selectedComboOption)) {
				                            comboObject.setValue(selectedComboOption);
				                        } else {
								var value=comboRawData[0].valueField;
								if(comboRawData.length>1)
									value=comboRawData[1].valueField;
								comboObject.setValue(value);
							}
										comboObject.show();
									}
										
								else
									{
									Ext.getCmp('er_application').hide();
									var textBoxObject=	mainForm.findField('er_application_text_box');
									textBoxObject.show();
									Ext.getCmp("aggregateValue").hide();
									}

					}else{
						if(Ext.getCmp("er_perserver")!=undefined)
							Ext.getCmp('er_perserver').hide();
						Ext.getCmp('er_application').hide();
						comboRawData = jsonData.measureCombo;
						selectedComboOption = jsonData.selectedMeasure;
						comboObject = mainForm.findField("select_testmes");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Criteria"]);
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							if (comboRawData.length > 1 && comboRawData[0].valueField != "notapplicable") {
								comboObject.setValue(comboRawData[1].valueField);
							}else{
								var value=comboRawData[0].valueField;
								if(comboRawData.length>1)
									value=comboRawData[1].valueField;
								comboObject.setValue(value);
							}
						}
						comboObject.show();
					}
					}
						initLdgMask.hide();
				}
			});
		}
	},
	workerGroupOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportCat=mainForm.findField('report_category').getValue();
		var urlForAjax;
		if(reportCat == 'user_usage'){
			urlForAjax="/final/reporter/ErCtxUserReportJson.jsp";
			this.updateQStringUsage(false);
			Ext.Ajax.request(
			{
				url : '/final/reporter/ErCtxUserReportJson.jsp',
				params : appConstants.queryStringUsage,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicjsonDataUsage=jsonData;
					var screenLabels=jsonData.screenLabels;
					/*var enableOragnizeCombo=jsonData.enableOragnizeCombo;
					if(enableOragnizeCombo=='true')
						Ext.getCmp('er_organize').show();
					else
						Ext.getCmp('er_organize').hide();*/
					comboRawData=jsonData.ComponentServerArray;
					selectedComboOption=jsonData.selectedComps;
					comboObject=Ext.getCmp('er_server');
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboRawData=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					comboObject=mainForm.findField('er_application');
				if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
				{
					Ext.getCmp('er_application_text_box').hide();
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						var value=comboRawData[0].valueField;
						if(comboRawData.length>1)
							value=comboRawData[1].valueField;
						comboObject.setValue(value);
					}
					comboObject.show();
				}
				else
				{
						Ext.getCmp('er_application').hide();
						var textBoxObject=	mainForm.findField('er_application_text_box');
						textBoxObject.show();
						Ext.getCmp("aggregateValue").show();
				}

				}
			});
		}
	},
	zoneOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportCat=mainForm.findField('report_category').getValue();
		var urlForAjax;
		var QString="";
		if(reportCat == 'user_usage'){
			urlForAjax="/final/reporter/ErCtxUserReportJson.jsp";
			this.updateQStringUsage(false);
			QString=appConstants.queryStringUsage;
		}
		else if(reportCat == 'user_Channel'){

			if(mainForm.findField('er_type').getValue() == 'No')
			{
				urlForAjax="/final/reporter/ErCtxChannelReportJson.jsp?select_farm="+encodeURIComponent(mainForm.findField("select_farm").getValue())+"&er_type="+mainForm.findField("er_type").getValue();
			}
			else{
				urlForAjax="/final/reporter/ErCtxChannelReportJson.jsp";
				this.updateQStringActivity();
				QString=appConstants.queryStringActivity;
			}
 		}
		else{

			if(mainForm.findField('er_type').getValue() == 'No')
			{
				urlForAjax="/final/reporter/ErCtxUserActivityReportJson.jsp?select_farm="+encodeURIComponent(mainForm.findField("select_farm").getValue())+"&er_type="+mainForm.findField("er_type").getValue();
			}
			else{
				urlForAjax="/final/reporter/ErCtxUserActivityReportJson.jsp";
				this.updateQStringActivity();
				QString=appConstants.queryStringActivity;
			}
 		}
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : QString,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				if(reportCat == 'user_usage'){
					appConstants.publicjsonDataUsage=jsonData;
					/*var enableOragnizeCombo=jsonData.enableOragnizeCombo;
					if(enableOragnizeCombo=='true')
						Ext.getCmp('er_organize').show();
					else
						Ext.getCmp('er_organize').hide();*/

//					comboRawData=jsonData.compTypeCombo;
//					if(!Ext.isEmpty(comboRawData))
//					{
//						selectedComboOption=jsonData.selectedCompType;
//						comboObject=mainForm.findField('er_compType');
//						comboObject.getStore().clearFilter(true);
//						comboObject.getStore().loadRawData(comboRawData);
//						if ( !Ext.isEmpty(selectedComboOption) ){
//							comboObject.setValue(selectedComboOption);
//						}
//						else{
//							comboObject.setValue(comboRawData[0].valueField);
//						}
//					}
						if(!jsonData.hasVMs && jsonData.isVm && needDesktopSearch)
						{
							Ext.getCmp('er_server_text_box').setValue(jsonData.er_guestname);
							Ext.getCmp('er_server_text_box').show();
						}
						else
						{
							Ext.getCmp('er_server_text_box').hide();
						}
					comboRawData=jsonData.ComponentServerArray;
					if(!Ext.isEmpty(comboRawData))
					{
						selectedComboOption=jsonData.selectedComps;
						comboObject=Ext.getCmp('er_server');
						appConstants.rawDataForComponents = comboRawData;
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
					}
					comboRawData=jsonData.compTypeCombo;
					if(!Ext.isEmpty(comboRawData))
					{
						selectedComboOption=jsonData.selectedCompType;
						comboObject=mainForm.findField('er_compType');
						comboObject.getStore().clearFilter(true);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
					}
					comboRawData=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					comboObject=mainForm.findField('er_application');
					if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
					{
						Ext.getCmp('er_application_text_box').hide();
						comboObject.getStore().clearFilter(true);
						comboObject.getStore().loadRawData(comboRawData);
						
						if(appConstants.isForceSubmit!='true')
						{
							if ( !Ext.isEmpty(selectedComboOption) ){
								comboObject.setValue(selectedComboOption);
							}
							else{
							var value=comboRawData[0].valueField;
								if(comboRawData.length>1)
									value=comboRawData[1].valueField;
								comboObject.setValue(value);
							}
						
						}else {
							comboObject.setValue(comboRawData[1].valueField);
							appConstants.isForceSubmit='false';
						}
						comboObject.show();
					}
					else
					{
						Ext.getCmp('er_application').hide();
						var textBoxObject=	mainForm.findField('er_application_text_box');
						textBoxObject.show();
						Ext.getCmp("aggregateValue").show();
					}
					Ext.getCmp("aggregateValue").show();

				}
				else{
					appConstants.publicjsonDataActivity=jsonData;
					
					if(isSettingsEnabled){
						var enableDesktop = jsonData.enableDesktop;
						if(enableDesktop=="true")
						{
							Ext.getCmp("dsktp_searchTxt").show();
							Ext.getCmp("dsktp_searchSpl").show();
						
						}else
						{
							Ext.getCmp("dsktp_searchTxt").hide();
							Ext.getCmp("dsktp_searchSpl").hide();
						}
					}
					comboRawData=jsonData.compTypeCombo;
					selectedComboOption=jsonData.selectedCompType;
					comboObject=mainForm.findField('er_compType');
					comboObject.getStore().clearFilter(true);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					if(mainForm.findField('er_type').getValue() == 'No'){
						comboRawData=jsonData.serverCombo;
						selectedComboOption=jsonData.selectedServer;
						appConstants.rawDataForComponents = jsonData.serverCombo;
						comboObject=Ext.getCmp('er_server');
						//comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						var s_sort=jsonData.sortbycombo;
						if(!Ext.isEmpty(s_sort))
						{
							var selected_s_sort=jsonData.selectedSortbyCombo;
							comboObject=mainForm.findField('er_sortby');
							comboObject.getStore().loadRawData(s_sort);
							if ( !Ext.isEmpty(selected_s_sort) ){
								comboObject.setValue(selected_s_sort);
							}
							else{
								comboObject.setValue(s_sort[0].valueField);
							}
						}
						comboRawData=jsonData.userCombo;
						selectedComboOption=jsonData.selectedUser;
						comboObject=mainForm.findField('er_application');
						if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
						{
							Ext.getCmp('er_application_text_box').hide();
							comboObject.setFieldLabel(screenLabels['reporter.thin.User']);
							comboObject.getStore().clearFilter(true);
							comboObject.getStore().loadRawData(comboRawData);
							if ( !Ext.isEmpty(selectedComboOption) ){
								comboObject.setValue(selectedComboOption);
							}
							else{
								var value=comboRawData[0].valueField;
								if(comboRawData.length>1)
									value=comboRawData[1].valueField;
								comboObject.setValue(value);
							}
							comboObject.show();
						}
									
						else
						{
							Ext.getCmp('er_application').hide();
							var textBoxObject=	mainForm.findField('er_application_text_box');
							textBoxObject.show();
							//Ext.getCmp("aggregateValue").show();
						}

						Ext.getCmp('serverMultiSelectLbl').show();
						if(!jsonData.hasVMs && jsonData.isVm && needDesktopSearch)
						{
							Ext.getCmp('er_server_text_box').setValue(jsonData.er_guestname);
							Ext.getCmp('er_server_text_box').show();
						}
						else
						{
							Ext.getCmp('er_server_text_box').hide();
						}

					}
					if(mainForm.findField('er_type').getValue() == 'Yes' && mainForm.findField("er_graphType").getValue()=="distribution")
					{
						comboRawData = jsonData.measureCombo;
						selectedComboOption = jsonData.selectedMeasure;
						comboObject = mainForm.findField("select_testmes");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Criteria"]);
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
					}
				}
			}
		});
	},
	 expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		if (btn.getId()=='expandSelector')
		  appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'),Ext.getCmp('compLbl').text,btn);

		else if (btn.getId()=='adgroupExpand')
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_adGroup'),'Ad Group',btn);

		else if (btn.getId()=='adUserExpand')
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_aduser'),'Ad Users',btn);
		else if (btn.getId()=='er_poolType_expand')
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_poolType'),Ext.getCmp('er_poolType_container').getFieldLabel(),btn);
	},
	serverOnChange:function(obj, newValue, oldValue, eOpts){
		if(oldValue==undefined || oldValue=='undefined')
			return;
		var me=this;
		var comboObject;
		var comboRawData;
		if(Ext.isEmpty(newValue))
			return;

		var mainForm =Ext.getCmp('mainform').getForm();
		var s_server=Ext.getCmp('er_server').getValue();
		var s_repType=mainForm.findField('er_type').getValue();
		if(s_repType!=null && s_repType!=undefined && s_repType=='No')
		{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
			this.updateQStringActivity(obj);
			var url="";
			if (targetType == "User Channel Report")
				url = '/final/reporter/ErCtxChannelReportJson.jsp';
			else
				url='/final/reporter/ErCtxUserActivityReportJson.jsp';
			Ext.Ajax.request(
			{
				url : url,
				params : appConstants.queryStringActivity,
				scope: this,
				method : 'POST',
				success: function(response){

				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				comboRawData=jsonData.userCombo;
				selectedComboOption=jsonData.selectedUser;
				comboObject=mainForm.findField('er_application');
				if(Ext.isEmpty(jsonData.sortbycombo))
				{
					Ext.getCmp('er_sortby').hide();
				}else{					
					Ext.getCmp('er_sortby').getStore().loadRawData(jsonData.sortbycombo);
					Ext.getCmp('er_sortby').setValue(jsonData.selectedSortbyCombo);				
					Ext.getCmp('er_sortby').show();
				}
				if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
				{
					Ext.getCmp('er_application_text_box').hide();
					comboObject.setFieldLabel(jsonData.screenLabels['reporter.thin.User']);
					comboObject.getStore().clearFilter(true);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					} else {
						if(comboRawData[0].valueField!=-1)
							comboObject.setValue(comboRawData[0].valueField);
						else
							comboObject.setValue(comboRawData[1].valueField); //added for components not auto select
					}
					comboObject.show();
				}
				else
				{
						Ext.getCmp('er_application').hide();
						var textBoxObject=	mainForm.findField('er_application_text_box');
						textBoxObject.show();
						//Ext.getCmp("aggregateValue").show();
				}

					if(s_server!=null && s_server!=undefined && s_server.length>1) {
						comboRawData=jsonData.aggAcrossServer;
						selectedComboOption=jsonData.selectedAggServer;
						comboObject=thinclientuserSettingsForm.findField('er_perserver');
						comboObject.setFieldLabel(jsonData.screenLabels['reporter.thin.Aggregate across servers on']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
					else
					{
						comboObject=thinclientuserSettingsForm.findField('er_perserver');
						comboObject.hide();
					}

					


				}
			});
		}else{
			if(Ext.getCmp("er_perserver")!=undefined)
				Ext.getCmp('er_perserver').hide();
						 url = "/final/reporter/ErCtxUserReportJson.jsp";
						 this.updateQStringUsage(true);
						Ext.Ajax.request(
						{		 
							url: url,
							params: appConstants.queryStringUsage,
							method: "POST",
							success: function(response) {
								var jsonData=Ext.decode(response.responseText);
								appConstants.publicjsonDataUsage=jsonData;
								comboRawData=jsonData.userCombo;
								selectedComboOption=jsonData.selectedUser;
								comboObject=mainForm.findField('er_application');
								appConstants.isAdDiscoverEnabled=jsonData.isAdDiscoverEnabled;
								if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
								{
									Ext.getCmp('er_application_text_box').hide();
									comboObject.getStore().clearFilter(true); 
									comboObject.getStore().loadRawData(comboRawData);
									if ( !Ext.isEmpty(selectedComboOption) ){
										comboObject.setValue(selectedComboOption);
									} else {
										if(comboRawData[0].valueField!=-1)
											comboObject.setValue(comboRawData[0].valueField);
										else
										{
											var value=comboRawData[0].valueField;
											if(comboRawData.length>1)
												value=comboRawData[1].valueField;
											comboObject.setValue(value);
										}//added for components not auto select when change component type
									}
									comboObject.show();
								}
								else
								{
									Ext.getCmp('er_application').hide();
									var textBoxObject=	mainForm.findField('er_application_text_box');
									textBoxObject.show();
									Ext.getCmp("aggregateValue").show();
								}
								var ucmbo;
								var value='';
								if(jsonData!=null && jsonData!=undefined && jsonData!='undefined')
								{
									ucmbo=jsonData.userCombo;
									if(ucmbo!=null && ucmbo!=undefined && ucmbo!='undefined')
									{
									var value=ucmbo[0].valueField;
									if(ucmbo.length>1)
										value=ucmbo[1].valueField;
										var selectedComboOptionn = jsonData.selectedUser;
											if (!Ext.isEmpty(selectedComboOptionn)) {
												value=selectedComboOptionn;
											}
									}
									else
									{
										// for user text box 
										value='-- All --';
									}
								}
								if (value!=undefined && value == '-- All --')
								{
									appConstants.isAllUserSelected = 'true';
									if(appConstants.isAdDiscoverEnabled == "true" && appConstants.isAllUserSelected == 'true'){
									comboRawData=jsonData.organizeCombo;
									var selectedComboOption=jsonData.selectedOrganizeby;
									comboObject=mainForm.findField('er_organize');
									comboObject.getStore().loadRawData(comboRawData);
									if ( !Ext.isEmpty(selectedComboOption) ){
										comboObject.setValue(selectedComboOption);
									}
									else{
										comboObject.setValue(comboRawData[0].valueField);
									}
											comboObject.show();
											me.onOraganizeBy();
									}
								} else {
									mainForm.findField('er_organize').hide();
									mainForm.findField('er_priority').setValue("ALL");

									var adgrouppane =Ext.getCmp('adgrouppane');
									if(adgrouppane!=undefined)
										adgrouppane.hide();
									//
									var aduserinfopane =Ext.getCmp('aduserinfopane');
									if(aduserinfopane!=undefined)
										aduserinfopane.hide();

									var adGroupFns =Ext.getCmp('adGroupFns');
									if(adGroupFns!=undefined)
										adGroupFns.hide();
									//
								}
								comboRawData=jsonData.poolTypeCombo;
								console.log('comboRawData  ',comboRawData);
								if(comboRawData!=undefined)
								{
									appConstants.rawDataForPoolType=jsonData.poolTypeCombo;
									selectedComboOption=jsonData.poolTypeSelected;
									comboObject=mainForm.findField('er_poolType');
									comboObject.getStore().loadRawData(comboRawData);
									if ( !Ext.isEmpty(selectedComboOption) ){
										comboObject.setValue(selectedComboOption);
									} else {
										if(comboRawData[0].valueField!=-1)
											comboObject.setValue(comboRawData[0].valueField);
										else
											comboObject.setValue(comboRawData[1].valueField); //added for pool type not auto select
									}
									Ext.getCmp('er_poolType_container').setFieldLabel(jsonData.screenLabels['reporter.thin.poolTypeLabel']);
									Ext.getCmp('er_poolType_container').show();
									Ext.getCmp('er_application').hide();
								}
								else
								{
									Ext.getCmp('er_poolType_container').hide();
									comboRawData=jsonData.userCombo;
									if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
									{
										Ext.getCmp('er_application_text_box').hide();
										Ext.getCmp('er_application').show();
									}
								}
									
								if(isSettingsEnabled)					
									me.onShowDetails();					
							}	
						});
		}	
	},
	graphTypeOnChange:function(obj){
		var val=obj.getValue();
		Ext.getCmp('er_application_text_box').hide();
		if(val=='timeline')
		{
			Ext.getCmp('showLegend').show();
		}
		else
		{
			Ext.getCmp('showLegend').show();
		}

		Ext.getCmp('resultPanel').hide();
		var url="";
		if (targetType == "User Channel Report")
			url = '/final/reporter/ErCtxChannelReportJson.jsp';
		else
			url = '/final/reporter/ErCtxUserActivityReportJson.jsp';

		this.updateQStringActivity();
		Ext.Ajax.request(
		{
			//url : '/final/reporter/ErCtxUserActivityReportJson.jsp',
			url : url,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				if(!isSettingsEnabled)
					this.showConfigDropdown();
				var mainForm =Ext.getCmp('mainform').getForm();
				var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
				if(val == 'timeline'){
					Ext.getCmp('select_testmes').hide();
					appConstants.publicjsonDataActivity=jsonData;
					comboRawData=jsonData.aggbasedOn;
					selectedComboOption=jsonData.selectedAgg;
					comboObject=thinclientuserSettingsForm.findField('er_perserver');
					comboObject.setFieldLabel(screenLabels['reporter.thin.Aggregate across servers']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.show();
					comboRawData=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					comboObject=mainForm.findField('er_application');
					comboObject.setFieldLabel(screenLabels['reporter.thin.User']);
					comboObject.getStore().clearFilter(true);
					comboObject.getStore().loadRawData(comboRawData);
 					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						var value=comboRawData[0].valueField;
						if(comboRawData.length>1)
							value=comboRawData[1].valueField;
						comboObject.setValue(value);
					}
					comboObject.show();
				}else{
					mainForm.findField('select_testmes').setFieldLabel(screenLabels['reporter.thin.Criteria']);
					Ext.getCmp('select_testmes').show();
					//
						comboRawData = jsonData.measureCombo;
						selectedComboOption = jsonData.selectedMeasure;
						comboObject = mainForm.findField("select_testmes");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Criteria"]);
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
					//
					Ext.getCmp('showLegend').hide();
					if(Ext.getCmp("er_perserver")!=undefined)
						Ext.getCmp('er_perserver').hide();
					Ext.getCmp('er_application').hide();
				}
			}
		});
	},
	reportTypeOnChange:function(obj){
		initLdgMask.show();
		Ext.getCmp('resultPanel').hide();
		Ext.getCmp('showLegend').hide();
		var val=obj.getValue();
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
        this.updateQStringActivity();
		var url="";
		if (targetType == "User Channel Report")
			url = "/final/reporter/ErCtxChannelReportJson.jsp?select_farm="+encodeURIComponent(mainForm.findField("select_farm").getValue())+"&er_type="+mainForm.findField("er_type").getValue();
		else
			url = "/final/reporter/ErCtxUserActivityReportJson.jsp?select_farm="+encodeURIComponent(mainForm.findField("select_farm").getValue())+"&er_type="+mainForm.findField("er_type").getValue();
		if(val == 'Yes'){
			url+="&graphViewtype="+mainForm.findField('er_graphType').getValue();
			Ext.getCmp('er_application_text_box').hide();
       		}else{
			url += "&er_comptype=" + mainForm.findField('er_compType').getValue();
		}
		Ext.Ajax.request(
		{
			url : url,
            params: appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				appConstants.publicjsonDataActivity=jsonData;
				//
					var reportGenCombo=jsonData.reportGenerationCombo;
					var selreportGeneration=reportGenCombo[0].valueField;
					var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
					reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
					reportGen.getStore().loadRawData(reportGenCombo);
					reportGen.setValue(selreportGeneration);
					var reportNameObj = Ext.getCmp('bgReportName');
					if(selreportGeneration!=undefined && selreportGeneration!=null && selreportGeneration=='foreground')
					{
						reportNameObj.hide();
					}
					else
					{
						reportNameObj.show();
					}
				//
				if(val == 'No'){
					mainForm.findField("select_testmes").hide();
					mainForm.findField('er_mode').hide();
					mainForm.findField('er_graphType').hide();
					comboRawData=jsonData.serverCombo;
					selectedComboOption=jsonData.selectedServer;
					comboObject=Ext.getCmp('er_server');
					multiServerObject=Ext.getCmp('expandSelector');
					appConstants.rawDataForComponents = comboRawData;
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					multiServerObject.show();
					comboObject.show();

					if(selectedComboOption !=null  && selectedComboOption.indexOf("All ")>-1)
						thinclientuserSettingsForm.findField('er_perserver').show();

					comboRawData=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					comboObject=mainForm.findField('er_application');
				if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
				{
					Ext.getCmp('er_application_text_box').hide();
					comboObject.setFieldLabel(screenLabels['reporter.thin.User']);
					comboObject.getStore().clearFilter(true);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
					var value=comboRawData[0].valueField;
						if(comboRawData.length>1)
							value=comboRawData[1].valueField;
						comboObject.setValue(value);
					}
					comboObject.show();
				
				   	var s_sort=jsonData.sortbycombo;
				
					var selected_s_sort=jsonData.selectedSortbyCombo;
				
					comboObject=mainForm.findField('er_sortby');
					
 					comboObject.getStore().loadRawData(s_sort);
                 		 if(s_sort!=null && s_sort!=undefined && s_sort!='undefined')
				{

					 
					if ( !Ext.isEmpty(selected_s_sort) ){
						comboObject.setValue(selected_s_sort);
					}
					else{
						comboObject.setValue(s_sort[0].valueField);
					}

				}


							Ext.getCmp('er_sortby').show();
							comboObject.show();
				}
				else
				{
						Ext.getCmp('er_application').hide();
						var textBoxObject=	mainForm.findField('er_application_text_box');
						textBoxObject.show();
						//Ext.getCmp("aggregateValue").show();
				}

					Ext.getCmp('serverMultiSelectLbl').show();
					comboRawData=jsonData.priorityCombo;
					selectedComboOption=jsonData.selectedPriority;
					comboObject=mainForm.findField('er_priority');
					comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[2].valueField);
					}
					comboObject.show();
				}
				else{
					Ext.getCmp('serverMultiSelectLbl').hide();
					mainForm.findField('er_priority').hide();
					mainForm.findField('er_application').hide();
					thinclientuserSettingsForm.findField('er_perserver').hide();
					mainForm.findField('er_mode').hide();
					Ext.getCmp('er_sortby').hide();
					mainForm.findField('er_graphType').show();
					mainForm.findField('select_testmes').show();


					var graphval=jsonData.selectedGraphType;
				//	if(graphval == 'timeline'){
					comboRawData = jsonData.graphTypeArray;
					selectedComboOption = jsonData.selectedGraphType;
					comboObject = mainForm.findField("er_graphType");
					comboObject.setFieldLabel(screenLabels["reporter.thin.Graph Type"]);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
							comboObject.show();
							

					if (graphval == "timeline") 
					{
						
						comboObject = mainForm.findField("select_testmes");
						comboObject.hide();
							comboRawData = jsonData.aggbasedOn;
							selectedComboOption = jsonData.selectedAgg;
							comboObject = thinclientuserSettingsForm.findField("er_perserver");
							comboObject.setFieldLabel(screenLabels["reporter.thin.Aggregate across servers"]);
							comboObject.getStore().loadRawData(comboRawData);
							if (!Ext.isEmpty(selectedComboOption)) {
								comboObject.setValue(selectedComboOption);
							} else {
								comboObject.setValue(comboRawData[0].valueField);
							}
							comboObject.show();
							comboRawData = jsonData.userCombo;
							selectedComboOption = jsonData.selectedUser;
							comboObject = mainForm.findField("er_application");
					if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
						{
							Ext.getCmp('er_application_text_box').hide();
							comboObject.setFieldLabel(screenLabels["reporter.thin.User"]);
							comboObject.getStore().clearFilter(true);
							comboObject.getStore().loadRawData(comboRawData);
							if (!Ext.isEmpty(selectedComboOption)) {
								comboObject.setValue(selectedComboOption);
							} else {
								var value=comboRawData[0].valueField;
								if(comboRawData.length>1)
									value=comboRawData[1].valueField;
								comboObject.setValue(value);
							}
							comboObject.show();
						}
					else
					{
						Ext.getCmp('er_application').hide();
						var textBoxObject=	mainForm.findField('er_application_text_box');
						textBoxObject.show();
							Ext.getCmp("aggregateValue").show();
					}

							Ext.getCmp('serverMultiSelectLbl').show();
					}else{
						thinclientuserSettingsForm.findField('er_perserver').hide();
						mainForm.findField('er_application').hide();
					}
					if(mainForm.findField('er_type').getValue() == 'Yes' && mainForm.findField("er_graphType").getValue()=="distribution")
					{
						comboRawData = jsonData.measureCombo;
						selectedComboOption = jsonData.selectedMeasure;
						comboObject = mainForm.findField("select_testmes");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Criteria"]);
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
					}
				}
				initLdgMask.hide();
			}
		});
	},

	reportCatChange:function(obj){
		initLdgMask.show();
		var value =obj.getValue();
		if(value == 'user_usage'){
			this.LoadFieldsForUsage();
		}
		else{
			this.LoadFieldsForActivity();
		}
				Ext.getCmp('resultPanel').hide();
	},
	LoadFieldsForActivity:function(){
		var url = "/final/reporter/ErCtxUserActivityReportJson.jsp";
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData;
				this.getMain().setTitle(jsonData.reportTitle);
				this.fillFormFieldsForActivity(jsonData);
				var mainForm =Ext.getCmp('mainform').getForm();
				mainForm.findField("er_type").show();
				mainForm.findField("select_testmes").show();
				mainForm.findField("er_compType").show();
				//Ext.getCmp("er_type").setValue("Yes");
				mainForm.findField("er_mode").show();
				if(Ext.getCmp("sh_timeinuse")!=undefined)
					Ext.getCmp("sh_timeinuse").show();
				mainForm.findField('er_wrkrGrp').hide();
				mainForm.findField("er_application").hide();
				mainForm.findField("er_organize").hide();
				initLdgMask.hide();
			}
		});
	},
	LoadFieldsForUsage:function(){
		var url = "/final/reporter/ErCtxUserReportJson.jsp";
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				appConstants.isAdDiscoverEnabled=appConstants.publicjsonDataUsage.isAdDiscoverEnabled;
				this.getMain().setTitle(jsonData.reportTitle);
				this.fillFormFieldsForUsage(jsonData);
			}
		});
	},
	fillFormFieldsForUsage:function(jsonData){
		var mainForm =Ext.getCmp('mainform').getForm();
		mainForm.findField("er_type").hide();
		mainForm.findField("select_testmes").hide();
		mainForm.findField("er_mode").hide();
		mainForm.findField("er_graphType").hide();
	//	mainForm.findField("er_server").hide;
		mainForm.findField("er_compType").show();
		mainForm.findField("er_application").show();

		mainForm.findField('er_wrkrGrp').show();
		var hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
        	var from_schedule = hiddenFields["fromScheduleModify"];
        	if (from_schedule != null && from_schedule == "Yes") {
			//Ext.getCmp("submit").hide();
			//Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}/*else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}*/
		var screenLabels=jsonData.screenLabels;

		var comboRawData;
		var selectedComboOption;
		var comboObject;
		//var enableOragnizeCombo=jsonData.enableOragnizeCombo;

		comboRawData=jsonData.reportForCombo;
		selectedComboOption=jsonData.reportFor;
		comboObject=mainForm.findField('report_category');
		comboObject.setFieldLabel(screenLabels['reporter.common.Report For']);
		comboObject.getStore().loadRawData(comboRawData);

		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		
		comboRawData=jsonData.analysisByCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedAnalysisByCombo;
			comboObject=mainForm.findField('er_option');
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		
		comboObject=Ext.getCmp('groupByDetails');
		if(!Ext.isEmpty(selectedComboOption))
		{
			if(selectedComboOption=="Summary")
				comboObject=Ext.getCmp('groupBySummary');
		}
		comboObject.setValue(true);
		comboRawData=jsonData.zoneCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedZone;
			comboObject=mainForm.findField('select_farm');
			comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);
			comboObject.getStore().clearFilter(true);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		comboRawData=jsonData.compTypeCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedCompType;
			comboObject=mainForm.findField('er_compType');
			comboObject.setFieldLabel(screenLabels['reporter.common.Component Type']);
			comboObject.getStore().clearFilter(true);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			if(!jsonData.hasVMs && jsonData.isVm && needDesktopSearch)
			{
				Ext.getCmp('er_server_text_box').setValue(jsonData.er_guestname);
				Ext.getCmp('er_server_text_box').show();
			}
			else
			{
				Ext.getCmp('er_server_text_box').hide();
			}
		}

		var showFromRawData=jsonData.showFromCombo;
		var selectedshowFrom=jsonData.selectedShowFromCombo;
		var showFromObj=mainForm.findField('showFrom');
		//showFromObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		showFromObj.getStore().loadRawData(showFromRawData);
		if (!Ext.isEmpty(showFromRawData) )
		{
			if ( !Ext.isEmpty(selectedshowFrom) )
			{
				showFromObj.setValue(selectedshowFrom);
			}
			else
			{
				showFromObj.setValue(showFromRawData[0].valueField);
			}
		}
		if(jsonData.isVm)
		{
			if(jsonData.hasVMs)
			{
				Ext.getCmp('compLbl').setText(vm_desktopTxt);
			}
			isVm = true;
			var resourceDetails = Ext.getCmp('ShowResourceDetails');
			if((resourceDetails!=undefined && resourceDetails=='No')||appConstants.publicjsonDataUsage.er_showResourceUsage=='No' || appConstants.menuForVM=='true')
			{
				Ext.getCmp('showFrom').hide();
			}
			else
			{
				Ext.getCmp('showFrom').show();
			}
		}
		else
		{
			isVm = false;
			Ext.getCmp('showFrom').hide();
		}

		comboRawData=jsonData.WorkerGroupArray;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedWorkerGroup;
			comboObject=mainForm.findField('er_wrkrGrp');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Worker Group']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			if(comboRawData.length>1 && comboRawData[0].valueField != 'notapplicable')
				comboObject.show();
			else
				comboObject.hide();
		}
		
		comboRawData=jsonData.userCombo;
		selectedComboOption=jsonData.selectedUser;
		comboObject=mainForm.findField('er_application');
		if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
		{
			Ext.getCmp('er_application_text_box').hide();
			comboObject.setFieldLabel(screenLabels['reporter.common.User']);
			comboObject.getStore().clearFilter(true);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
				if (selectedComboOption.indexOf('All')>-1)
				{
					appConstants.isAllUserSelected='true';
				}
			}
			else{
				var value=comboRawData[0].valueField;
				if(comboRawData.length>1)
					value=comboRawData[1].valueField;
				comboObject.setValue(value);
			}
			comboObject.show();
			Ext.getCmp("aggregateValue").show();
		}
		else
		{
			Ext.getCmp('er_application').hide();
			var textBoxObject=	mainForm.findField('er_application_text_box');
			if(selectedComboOption!=undefined && selectedComboOption!=null)
				textBoxObject.setValue(selectedComboOption);
			textBoxObject.show();
			Ext.getCmp("aggregateValue").show();
		}

//
		appConstants.isAdDiscoverEnabled=jsonData.isAdDiscoverEnabled;
		var ucmbo;
		var value='';
		if(jsonData!=null && jsonData!=undefined && jsonData!='undefined')
		{
			ucmbo=jsonData.userCombo;
			if(ucmbo!=null && ucmbo!=undefined && ucmbo!='undefined')
				{
					var value=ucmbo[0].valueField;
						if(ucmbo.length>1)
							value=ucmbo[1].valueField;
							var selectedComboOptionn = jsonData.selectedUser;
								if (!Ext.isEmpty(selectedComboOptionn)) {
										value=selectedComboOptionn;
										}
								}
								else
								{
										// for user text box 
									value='-- All --';
								}
		}

		//
		if (value!=undefined && value == '-- All --')
		{
			appConstants.isAllUserSelected = 'true';
		if(appConstants.isAdDiscoverEnabled == "true" && appConstants.isAllUserSelected == 'true'){
			comboRawData=jsonData.organizeCombo;
			selectedComboOption=jsonData.selectedOrganizeby;
			comboObject=mainForm.findField('er_organize');
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			//if(jsonData.selectedUser == '--All--'){
					comboObject.show();
					this.onOraganizeBy();
			}
		}
		if(wildcardSearch)
		{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			if(jsonData.isVm)
			{
				Ext.getCmp('wildcardSearch').setValue('*');
				Ext.getCmp('wildcardSearch').hide();
			}
			else
			{
				Ext.getCmp('wildcardSearch').show();
				if(jsonData.selectedClientVersion != undefined)
					Ext.getCmp('wildcardSearch').setValue(jsonData.selectedClientVersion);
				else
					Ext.getCmp('wildcardSearch').setValue('*');
			}
		}
		comboRawData=jsonData.ComponentServerArray;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedComps;

			comboObject=Ext.getCmp('er_server');
			//Ext.getCmp('serverMultiSelectLbl').show();
			//multiServerObject=Ext.getCmp('expandSelector');
			Ext.getCmp('compLbl').setText(screenLabels['reporter.thin.Components']);
			appConstants.rawDataForComponents = comboRawData;
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		//comboObject.show();
		//multiServerObject.show();
		}
		comboRawData=jsonData.poolTypeCombo;
		if(comboRawData!=undefined)
		{
			appConstants.rawDataForPoolType=jsonData.poolTypeCombo;
			selectedComboOption=jsonData.poolTypeSelected;
			comboObject=mainForm.findField('er_poolType');
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			} else {
				if(comboRawData[0].valueField!=-1)
					comboObject.setValue(comboRawData[0].valueField);
				else
					comboObject.setValue(comboRawData[1].valueField); //added for pool type not auto select
			}
			Ext.getCmp('er_poolType_container').setFieldLabel(jsonData.screenLabels['reporter.thin.poolTypeLabel']);
			Ext.getCmp('er_poolType_container').show();
			Ext.getCmp('er_application').hide();
			Ext.getCmp('er_application_text_box').hide();
		}
		else
		{
			Ext.getCmp('er_poolType_container').hide();
			comboRawData=jsonData.userCombo;
			if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
			{
				Ext.getCmp('er_application_text_box').hide();
				Ext.getCmp('er_application').show();
			}
		}
		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}

        var start_hour = jsonData.startHour;
        var end_hour = jsonData.endHour;
        var start_date = jsonData.startDate;
        var end_date = jsonData.endDate;
        var startDateObj = mainForm.findField('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = start_date;
        var startHrObj = mainForm.findField('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = start_hour;
        var endDateObj = mainForm.findField('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = end_date;
        var endHrObj = mainForm.findField('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = end_hour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;

		if (Ext.getCmp('er_option').getValue()=='Component') 						
			Ext.getCmp('select_farm').hide();
		else
			Ext.getCmp('select_farm').show();
		
			
			var er_aggregateVaalue = hiddenFields["er_aggregateVaalue"];
			if ( !Ext.isEmpty(er_aggregateVaalue) ){
				var aggregateValueRadio=Ext.getCmp('aggregateValue');
				aggregateValueRadio.setValue({groupByValue: er_aggregateVaalue});
			}
		 updatingAppSettings();

		initLdgMask.hide();

	},
	fillSettingFieldsForUsage:function(jsonData){
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var screenLabels=jsonData.screenLabels;
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		thinclientuserSettingsForm.findField("sh_timeinuse").hide();
		thinclientuserSettingsForm.findField("er_perserver").hide();
		var hiddenFields = jsonData.hiddenfields;
		var clientIp = hiddenFields["clientIp"];
		if ( !Ext.isEmpty(clientIp) ){
			var clientIpRadio=Ext.getCmp('clientIpRadio');
				if(clientIp=='Yes')
				clientIpRadio.setValue({clientIp: 'Yes'});
				else if(clientIp=='No')
				clientIpRadio.setValue({clientIp: 'No'});
		}
		comboRawData=jsonData.excludeWeekCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.excludeWeek;
			comboObject=thinclientuserSettingsForm.findField('er_excwe');
			comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
			var adGroupComboData=jsonData.adGroupCombo;
			var selectedAdGroup=jsonData.selectedAdGroup;
			var adGroupLabel=jsonData.adGroupLabel;
		if(!Ext.isEmpty(adGroupComboData)){
			var er_adGroup=thinclientuserSettingsForm.findField('er_adGroup');
			er_adGroup.getStore().loadRawData(adGroupComboData);
 			if ( !Ext.isEmpty(selectedAdGroup) ){
				er_adGroup.setValue(selectedAdGroup);
			}
			else{
				 var value=adGroupComboData[0].valueField;
					if(adGroupComboData.length>1)
						value=adGroupComboData[1].valueField;
						er_adGroup.setValue(value);
				}
		    }
			var adGroupUserComboData=jsonData.adGroupUserCombo;
			var selectedAdGroupUser=jsonData.selectedAdGroupUser;
			var adGroupLabel=jsonData.adGroupLabel;
		if(!Ext.isEmpty(adGroupUserComboData)){
			var er_aduser=thinclientuserSettingsForm.findField('er_aduser');
			er_aduser.getStore().loadRawData(adGroupUserComboData);
 			if ( !Ext.isEmpty(selectedAdGroupUser) ){
				er_aduser.setValue(selectedAdGroupUser);
			}
			else{
				 var value=adGroupUserComboData[0].valueField;
					if(adGroupUserComboData.length>1)
						value=adGroupUserComboData[1].valueField;
						er_aduser.setValue(value);
				}
		    }
				var selectedAdGroupFns=jsonData.selectedAdGroupFns;


				if(selectedAdGroupFns!=undefined && selectedAdGroupFns!=null && selectedAdGroupFns=='Details'){
					var adGroupFns=Ext.getCmp('adGroupFns');
						if ( !Ext.isEmpty(adGroupFns) )
								adGroupFns.setValue({adGroupByValue: 'Details'});	
					
				}
				else
				{
						var adGroupFns=Ext.getCmp('adGroupFns');
						if ( !Ext.isEmpty(adGroupFns) )
								adGroupFns.setValue({adGroupByValue: 'Summary'});
				}
		
	},
	saveReportAsPDF:function(){
		var saveQString;
		var reportFor = Ext.getCmp('report_category').getValue();
		if(reportFor == 'user_activity' || reportFor == 'user_Channel'){
			saveQString=appConstants.publicjsonDataActivity.saveQString;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				saveQString+="&er_view=PRINT";
		}
		else if(appConstants.report_for == 'user_usage'){
			saveQString=appConstants.publicjsonDataUsage.saveQString;
			saveQString+="&er_view=PRINT";
			}

		else{
				saveQString=appConstants.publicjsonDataUsage.saveQString;
				saveQString+="&er_view=PRINT";
			}
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString;
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		s_qryString=this.getGridColSortParam(s_qryString);
		if(appConstants.fromOverviewReport =='true' && targetType == 'User Session Report'){
			s_qryString = "../reporter/ErHtmlToSavePdf.jsp?&index=0&pdf=yes&drillSes=yes&er_Duration="+appConstants.er_durationValue;
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');

		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);

			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}

			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}

		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	bookletQuery: function(obj)
	{
		var saveQString;
		var reportFor = Ext.getCmp('report_category').getValue();
		if(reportFor == 'user_activity' || reportFor == 'user_Channel'){
			saveQString=appConstants.publicjsonDataActivity.saveQString;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				saveQString+="&er_view=PRINT";
		}
		else if(appConstants.report_for == 'user_usage'){
			saveQString=appConstants.publicjsonDataUsage.saveQString;
			saveQString+="&er_view=PRINT";
			}
		else{
				saveQString=appConstants.publicjsonDataUsage.saveQString;
				saveQString+="&er_view=PRINT";
			}
		var s_qryString = saveQString;
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}
					else
					{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		s_qryString=this.getGridColSortParam(s_qryString);
		if(appConstants.fromOverviewReport =='true' && targetType == 'User Session Report')
			s_qryString = "/final/reporter/ErUsersessionReportPrint.jsp?&er_view=PRINT&index=0&er_Duration="+appConstants.er_durationValue;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var report_cat = Ext.getCmp('report_category').getValue();
		if(report_cat == 'user_activity' || report_cat == 'user_Channel'){
			this.updateQStringActivity(true);
			var rtype=Ext.getCmp('er_type').getValue();
			if(rtype == 'Yes'){
				bookletquery=appConstants.queryStringActivity;
				bookletquery+="&er_server=-1&er_application=-1&er_sortby=-1";
			}
			else{
				bookletquery=appConstants.queryStringActivity;
			}
		}
		else if(report_cat == 'user_usage'){
			this.updateQStringUsage(false);
			bookletquery=appConstants.queryStringUsage;
		}
		if(appConstants.fromOverviewReport =='true' && targetType == 'User Session Report')
			bookletquery = "/final/reporter/ErUsersessionReportPrint.jsp?&er_view=PRINT&index=0&er_Duration="+appConstants.er_durationValue;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	printReport:function(){

		var s_qryString;
		var reportFor = Ext.getCmp('report_category').getValue();
		if(reportFor == 'user_activity' || reportFor == 'user_Channel'){
			var saveQString=appConstants.publicjsonDataActivity.saveQString;
			s_qryString = "../servlet/com.eg.ErCtxServerReportC?"+saveQString
				+"&printGraph=yes&pdfPrint=yes";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				s_qryString+="&er_view=PRINT";
			//Ext.widget('print',{title:appConstants.publicjsonDataActivity.reportTitle}).show();


		}
		else if(reportFor == 'user_usage'){
			var saveQString=appConstants.publicjsonDataUsage.saveQString;
			//s_qryString = "/final/reporter/ErAppUsageReportPrint.jsp?"+saveQString+"&pdfPrint=yes&isChartRequest=true&er_width=450&er_height=250&er_option=graph";
			s_qryString = "../servlet/com.eg.ErCtxServerReportC?"+saveQString
				+"&printGraph=yes&pdfPrint=yes&er_view=PRINT";
		//Ext.widget('print',{title:appConstants.publicjsonDataUsage.reportTitle}).show();

		}
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		s_qryString=this.getGridColSortParam(s_qryString);
		if(appConstants.fromOverviewReport =='true' && targetType == 'User Session Report')
			s_qryString = "/final/reporter/ErUsersessionReportPrint.jsp?&er_view=PRINT&index=0&pdfPrint=yes&er_Duration="+appConstants.er_durationValue;
		if (appConstants.menuForVM=='true')
		{
			printWindowFn(s_qryString);
		}
		else
		{
			 parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		/*var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
				src :s_qryString
			});*/

			/* printWindow.on('show',function(){
       // var s_qryString = "YOUR QUERY"  //query string to load the popup
        var printContentDiv = parent.Ext.select('#printContentDiv1');  // id of the popup window
                    printContentDiv.set({
                        src: s_qryString
                    });
           });
         printWindow.show();*/
	},
	sendMail:function(){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		if(appConstants.fromOverviewReport =='true' && targetType == 'User Session Report'){
			drillDownParams = '&DrillDown=yes';
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(btn){
		var report_cat = Ext.getCmp('report_category').getValue();
		var schedule_id ="";
		var isValid = this.validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Thin Client Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}
		if(isValid){
			var target='';
			if(report_cat == 'user_activity' || report_cat == 'user_Channel'){
				this.updateQStringActivity(true);
				var rtype=Ext.getCmp('er_type').getValue();
				var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
				schedule_id = hiddenFields["schedule_id"];
				if(rtype == 'Yes'){
					target="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity+"&com.eg.CSRF_NONCE="+csrfToken;
					target+="&er_server=-1&er_application=-1&er_sortby=-1";
				}
				else{
					target="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity+"&com.eg.CSRF_NONCE="+csrfToken;
				}
			}
			else if(report_cat == 'user_usage'){
				this.updateQStringUsage(false);
				target="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringUsage+"&com.eg.CSRF_NONCE="+csrfToken;
			}
			if (appConstants.menuForVM=='true')
			{
				target+='&menuForVM=true';
			}
			if (btn.getItemId()=='save')
			{
				if((Ext.isEmpty(schedule_id) || schedule_id=="null" || schedule_id=="undefined" || schedule_id==undefined) && appConstants.schedule_id!="null")
				{
					schedule_id=appConstants.schedule_id;
				}
				//document.location=target+'&showSchWindow=no';
				target+='&showSchWindow=no&schedule_id='+schedule_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
						});
			}
			else
			{
				if (appConstants.menuForVM=='true')
				{
					scheduleWindowFn(target);
				}
				else
				{
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
				}
			}
		}
		
	},
	saveFavorite:function(btn){
		var isValid = this.validateMainForm(false);
		var favorite_id ="";
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Thin Client Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		if(isValid){
			var s_qryString;
			var report_cat = Ext.getCmp('report_category').getValue();

			if(report_cat == 'user_activity' || report_cat == 'user_Channel'){
				var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
				favorite_id = hiddenFields["favorite_id"];
				this.updateQStringActivity();
				var rtype=Ext.getCmp('er_type').getValue();
				if(rtype == 'Yes'){
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&er_sortby=-1&er_server=-1&er_application=-1&cmd=client";

				}
				else{
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";
				}
			}
			else if(report_cat == 'user_usage'){
				var hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
				favorite_id = hiddenFields["favorite_id"];
				this.updateQStringUsage(false);
				s_qryString="../servlet/com.eg.ErFavoriteC?"+appConstants.queryStringUsage+"&er_view=GRAPH&cmd=client";
			}
			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//+"&FavoriteId="+favorite_id;
			if (appConstants.menuForVM=='true')
			{
				target+='&menuForVM=true';
			}
			if (btn.getItemId()=='save')
			{
				if((Ext.isEmpty(favorite_id) || favorite_id=="null" || favorite_id=="undefined" || favorite_id==undefined) && appConstants.favorite_id!="null")
				{
					favorite_id=appConstants.favorite_id;
				}
				//document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
						});
			}
			else
			{
 				if (appConstants.menuForVM=='true')
				{ 
					favouriteWindowFn(target);
				}
				else
				{
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
				} 
			}
		}
		
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm =null;
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var zone=mainForm.findField('select_farm')
		var reporFor=mainForm.findField('report_category').getValue();
		var reportType=mainForm.findField('er_type').getValue();
		var er_option=mainForm.findField('er_option').getValue();
		if((er_option!=null || er_option!=undefined) && er_option!="Component" )
		{
			if(zone.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Thin Client User',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		}
		if(reporFor == 'user_activity' || reporFor == 'user_Channel'){
			var compType=mainForm.findField('er_compType');
				if( compType.getValue() == '-1'){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: compType.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			if(reportType == 'No'){				
				var server=Ext.getCmp('er_server');
				var application=mainForm.findField('er_application');
				var application_text=mainForm.findField('er_application_text_box');
				if( server.getValue() == '-1'){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: server.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if( application.isVisible()&& application.getValue() == 'Not Applicable'){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: application.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(application_text.isVisible()&& application_text.getValue().length<=0){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: ' User can\'t be empty',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}else{
				if(mainForm.findField("er_graphType").getValue()=="distribution")
				{
				var er_measure=mainForm.findField('select_testmes');
				if(er_measure.getValue()=='-1'){
				Ext.MessageBox.show({
				title:'Thin Client User',
				msg:'Please Choose Criteria',
				buttons:Ext.MessageBox.OK,
				icon:Ext.MessageBox.WARNING
				});
				return false;
					}
				}
			}
		}
		else
		{
				var compType=mainForm.findField('er_compType');
		//		var component=mainForm.findField('er_component');
				var application=mainForm.findField('er_application');
				var application_text=mainForm.findField('er_application_text_box');
				var erServer = Ext.getCmp('er_server');
		     
				if( compType.getValue() == '-1'){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: compType.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if( erServer.isVisible() && erServer.getValue() == '-1'){
					Ext.MessageBox.show({
					title: 'Alert',
					msg: erServer.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(appConstants.isForceSubmit!='true')
				{

		
			
				if(application.isVisible()&& application.getValue() == '-1'){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: application.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
					}
	        		}
				if(application_text.isVisible()&& application_text.getValue().length<=0){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: ' User can\'t be empty',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
		}
		var isSettingsOk = true;

		var hiddenFields;
		if (targetType == "User Session Report")
			hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
		else
			hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;

		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen = this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var er_usertimeline = '';
		if ( !Ext.isEmpty(hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');


		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){

			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Thin Client User settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			if(appConstants.isFromDrillDown ==null || appConstants.isFromDrillDown=='null'|| appConstants.isFromDrillDown==undefined || appConstants.isFromDrillDown=='undefined' || !appConstants.isFromDrillDown)
			{
				if(flag)
				{
					var limitforbg = hiddenFields["limitforbg"];

					if(!Ext.isEmpty(limitforbg)){
						if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
							Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
							isSettingsOk = false;
						}
					}
				}
			}
			
		}
		else{
			var reportName = this.getSettingsFieldValue(thinclientuserSettingsForm,'bgReportName',isSettingsEnabled,'selectedMinsTo');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;

		/*if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}*/
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
        var starthr = mainForm.findField('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = mainForm.findField('er_enddate').getValue();
        var endhr = mainForm.findField('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var server=Ext.getCmp('er_server');
		var application=mainForm.findField('er_application');
		var isValid = this.validateMainForm(true);

		if(isValid)
			this.submitReport();
	},
	validateSettings :function(){
		var isSettingsOk = true;

		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && reportgen == 'background' ) {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
 			this.submitReport();
		}else{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
			var reportGenType=thinclientuserSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientuserSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					chartAttrib=Ext.decode(jsonText);
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	loadGrid:function(GridData)
	{
		appConstants.queryStringActivityForUserDetails=appConstants.queryStringActivity;
		var me=this;
		var resultPanelObj=Ext.getCmp('resultPanel');
		var itemsArray=new Array();
		if (!Ext.isEmpty( GridData ))
		{
			var gridDataObj=GridData;
			var columnDetails=gridDataObj.columns;
			var colLength=0;
			if(columnDetails != undefined)
				colLength=Object.keys(columnDetails).length;
			var dataArraytoStore=gridDataObj.dataArray;
			var noOfColumns=gridDataObj.TOTAL_COLUMN_COUNT;
			var singleColumnCount=gridDataObj.SINGLE_SUBCOLUMN_COUNT;
			var viewPortWidth=this.getMain().getWidth();
			var COLUMN_MIN_WIDTH=55;
			var SINGLE_COLUMN_WIDTH=80;
			var SERVER_MIN_WIDTH=120;
			var count=0;
			noOfColumns++;// ADDED FOR HEALTH COLUMN;
			var mutipleColumns=noOfColumns-singleColumnCount;
			var widthNeeded=150+(mutipleColumns*COLUMN_MIN_WIDTH)+(singleColumnCount*SINGLE_COLUMN_WIDTH);

			var fieldstoStore =  {};
			var cnt=0;
			var mainColumnsObjArray	=  new Array();
			var eachWidth=0;
			if(viewPortWidth>widthNeeded){
				eachWidth=(viewPortWidth-(SERVER_MIN_WIDTH))/noOfColumns;
			}
			else
			{
				eachWidth=COLUMN_MIN_WIDTH;
			}
			for( var key in columnDetails )
			{
				var mainColumn=key;
				var subColumns=new Array();
				var subColObjArray=new Array();
				subColumns=columnDetails[key];
				if(subColumns!=undefined && !Ext.isEmpty(subColumns))
				{
					var subColumnCount=subColumns.length;
					var adujstedWidth=eachWidth;
					if(subColumnCount == 1)
					{
						if(eachWidth<SINGLE_COLUMN_WIDTH)
							adujstedWidth=SINGLE_COLUMN_WIDTH;
					}
					for(var j in subColumns)
					{
						var tmp=subColumns[j];
						fieldstoStore[cnt]=mainColumn+"_"+tmp;
						subColObjArray.push({
							header: tmp,
							sortable:true,
							dataIndex:cnt,
							align:'center',
							minWidth:adujstedWidth,
							doSort: function(state)
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1!=undefined && v1.indexOf('~')>-1)
										{
											v1 = v1.substring(0,v1.indexOf('~'));
										}
										if(v2!=undefined && v2.indexOf('~')>-1)
										{
											v2 = v2.substring(0,v2.indexOf('~'));
										}

										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime(); 
											v1=new Date(v1).getTime(); 
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								if(value!=undefined && value.indexOf('$')>-1)
								{
									metaData.tdCls = value.substring(value.indexOf('$')+1);
									value = value.substring(0,value.indexOf('$'));
								}
								if(value!=undefined && value.indexOf('~')>-1)
								{
									var text = value.substring( 0, value.indexOf('~') );
									var url = value.substring( value.indexOf('~') + 1 );
									var toolVal = text;
									if(text!=null && text=="top.gif")
									{
										text='<img src="/final/reporter/images/top.gif">';
										toolVal = 'Details';
									}
									value = '<a href="javascript:void(0);" onClick="javascript:openInNewWin(\''+url+'\');" >'+text+'</a>';
									metaData.tdAttr = 'data-qtip="' + toolVal + '"';
								}
								else
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
									value = me.getDecimalAlignFormat(value);
								}
								return value;
							}
						});
						cnt++;
					}
					mainColumnsObjArray.push(
					{
						header: mainColumn,
						columns: subColObjArray,
					});
					if(colLength > 10){
						mainColumnsObjArray[mainColumnsObjArray.length-1].locked = false;
					}
				}
				else
				{
					var enableLock=true;
					if(colLength <= 8)
						enableLock=false;
					if(count==0)
					{
						var min_Width=eachWidth;
						if(mainColumn == "")
							min_Width=40;
						fieldstoStore[cnt]=mainColumn;
						mainColumnsObjArray.push({
							header: mainColumn,
							sortable:true,
							needModify:'no',
							maxWidth:min_Width,
							dataIndex: cnt,
							align:'left',
							flex:1,
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1!=undefined && v1.indexOf('~')>-1)
										{
											v1 = v1.substring(0,v1.indexOf('~'));
										}
										if(v2!=undefined && v2.indexOf('~')>-1)
										{
											v2 = v2.substring(0,v2.indexOf('~'));
										}
										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime(); 
											v1=new Date(v1).getTime(); 
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								var toolotipVal=value;
								if(value.indexOf('~')>-1)
								{
									var text = value.substring( 0, value.indexOf('~') );
									var url = value.substring( value.indexOf('~') + 1 );
									metaData.tdAttr = 'style="width:40px;"';
									if(text!=null && text=="top.gif")
									{
										toolotipVal="Details";
										text='<img src="/final/reporter/images/top.gif">';
										metaData.tdAttr = 'data-qtip="' + toolotipVal + '"';
									}
									if(text!=null && text=="ss")
									{
										toolotipVal="Graph";
										text='<img src="/final/images/spacer.gif" class="iconLineChart">';
										metaData.tdAttr = 'data-qtip="' + toolotipVal + '"';
									}
									value = '<a href="javascript:void(0);" onClick="window.location.href=\''+url+'\'" >'+text+'</a>';
								}
								else
									metaData.tdAttr = 'data-qtip="' + value + '"';
								return value;
							}
						});
						if(colLength > 10){
							mainColumnsObjArray[mainColumnsObjArray.length-1].locked = true;
						}
						cnt++;
					}
					else
					{
						fieldstoStore[cnt]=mainColumn;
						
						mainColumnsObjArray.push(
						{
							header: mainColumn,
							//columns: subColObjArray,
							sortable:true,
							minWidth:SERVER_MIN_WIDTH,
							dataIndex: cnt,
							align:'left',
							//flex:1,
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1!=undefined && v1.indexOf('~')>-1)
										{
											v1 = v1.substring(0,v1.indexOf('~'));
										}
										if(v2!=undefined && v2.indexOf('~')>-1)
										{
											v2 = v2.substring(0,v2.indexOf('~'));
										}
										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime();
											v1=new Date(v1).getTime();
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								if(value.indexOf('~')>-1)
								{
									var text = value.substring( 0, value.indexOf('~') );
									var url = value.substring( value.indexOf('~') + 1 );
									var toolVal = text;
									if(text!=null && text=="top.gif")
									{
										text='<img src="/final/reporter/images/top.gif">';
										toolVal = 'Details';
									}
									value = '<a href="javascript:void(0);" onClick="javascript:openInNewWin(\''+url+'\');" >'+text+'</a>';
									metaData.tdAttr = 'data-qtip="' + toolVal + '"';
								}
								else
									metaData.tdAttr = 'data-qtip="' + value + '"';
								
								return value;
							}
						});
						cnt++;
						if(colLength > 10){
							mainColumnsObjArray[mainColumnsObjArray.length-1].locked = true;
						}
					}
				}
				count++;
			}
			var fetchedData = function(){
				this.data = null;
				this.total = 0;
			}
			var rowspan=false;
			
 			if (isSettingsEnabled)
			{
				var er_perserverObj=Ext.getCmp('er_perserver');
				if(er_perserverObj.getValue()=='No')
					rowspan=true;
			}
			else
			{
				if (publicGridData['selectedAggServer']=='No')
					rowspan=true;
			}

			var isPagingHidden;
			if (dataArraytoStore.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			
			var fields=[];
			var colLen=Object.keys(dataArraytoStore[0]).length;
		
			for(var key in dataArraytoStore[0])
			{				
				fields.push(key);
			}
			
			var storeObj = Ext.create('Ext.data.Store', {
				fields: fields,
				proxy : {
						type : 'pagingmemory',
						reader : {
							type: 'json', root : 'data', totalProperty : 'total'
						},
						
						data:dataArraytoStore,
					},
				sorters: { property: fields[1], direction : 'ASC' },
				pageSize:gridPageSize,	//gridPageSize is added in ErTracker.jsp
				autoLoad : true,
			});
			if(GridData.haveSummary)
			{
				var summaryObj = GridData.summaryObj;
				var highlightedBlock = GridData.highlightedBlock;
				var digitalArry=new Array();
				for(var summaryTitle in summaryObj)
				{
					var styles = '';
					if(highlightedBlock!=undefined && highlightedBlock==summaryTitle)
					{
						styles = '#d3d3d3';
					}
					digitalArry.push({
						xtype:'container',
						align:'center',
						columnWidth:0.2,
						margin:'10 0 10 0',
						autoSize: true,
						layout: 
						{
							type: 'table',
							columns:1,
							align:'center',
							tableAttrs: 
							{
								style: 
								{
									align:'center',
									margin:'auto auto',
									background:styles
								}
							},
							tdAttrs:
							{
								style:
								{
									textAlign:'center'
								}
							}
						},
						defaults: {
							bodyStyle: 'padding:10px 5px 5px 5px',
							align:'center',
						},
						items: [{
							html: '<table align="center" ><tr><td align="right" style="padding-right:5px"><div class="" ></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+summaryObj[summaryTitle]+'</td></tr></table>',
							width:'100%',
							style: 
							{
								textAlign:'center',
								width:'50px'
							}
						},
						{
							html:'<span class="newFont_normal13">'+summaryTitle+'</span>',
						}]
					});
				}
				itemsArray.push({
					xtype:'panel',
					ui:'newGraphPanel',
					margin:'10 10 10 10',
					title:'Summary',
					columnWidth:1,
					layout:'column',
					items:digitalArry
				});

			}
			var activePage=1;
			itemsArray.push({
				xtype:'panel',
				ui:'newGraphPanel',
				margin:'10 10 10 10',
				title:gridDataObj.gridTitle,
				items:[{
					xtype:'customgrid',
					store:storeObj,
					sortableColumns:true,
					needtoFixColumn:true,
					ui:'newGridPanel',
					id:'vengat',
					columns:mainColumnsObjArray,
					rowspan:rowspan,
					border:true,
					margin:'5 10 10 10',
					forceFit: true,
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
							me.gridColIndexParam=column.getIndex();
							me.gridColStateParam=column.sortState;
							 this.getStore().loadPage(activePage);
						},
						render:function(obj)
						{
							// by karthikeyan - for user activity data-selected measure sort icon
							var combobox=Ext.getCmp('er_sortby');
							var v = combobox.getValue();
							var record = combobox.findRecord(combobox.valueField || combobox.displayField, v);
							var index = combobox.store.indexOf(record)+1;
	//
						 /* Ext.defer(function() {
							  if(!Ext.isEmpty(obj.columns[index].items.items[0]))
								obj.columns[index].items.items[0].setSortState("ASC",true,true);
							},100);*/
						}
					},
					dockedItems:[{
						xtype:'pagingtoolbar',
						cls:'newPagination',
						dock: 'bottom',
						displayInfo: true,
						store: storeObj,
						hidden:isPagingHidden,
						displayInfo: true,
						displayMsg: 'Displaying topics {0} - {1} of {2}',
						emptyMsg: "No topics to display",
						listeners: {
							change : function(thisd, params)
							{   
								if(!Ext.isEmpty(params))
									activePage = params.currentPage;
								else
									activePage=1;
							}
						}
					}]
					
				}]
			});

			Ext.getCmp("csvTool").setDisabled(false);

			resultPanelObj.removeAll();
			resultPanelObj.add(itemsArray);
			resultPanelObj.show();

		}
	},
	loadUsageGridandTable: function(resultData){
		var me=this;
		var resultPanelObj=Ext.getCmp('resultPanel');
		var compType=Ext.getCmp('er_compType').getValue();
		var itemsArray=new Array();
		var isVmComp=resultData.isVmComponent;
		var isDetailsEnabled=resultData.includeDetails;
		if ( !Ext.isEmpty( resultData ) ){
			var dataArray =resultData['summarytableData'];
			var showApp = appConstants.publicjsonDataUsage.ShowAppNames;
			var tabledata ='';
			var dataPresent = false;
 			if(!Ext.isEmpty(dataArray))
			{
				var totalCount = 0;
				for(var j in dataArray)
				{
					totalCount++;
				}
				var defaultWidth = '100%';
				if(totalCount <= 3)
					defaultWidth = '50%';
				tabledata = '<div class="newTable" style="margin:0px 10px 10px 10px" align="center">'
				+'<table cellspacing="0" cellpadding="0" border="0" width="'+defaultWidth+'%">'
				+'<tbody>';
				var cntt=0;
				var y =0;
				for(var j in dataArray)
				{
					dataPresent = true;
					if(cntt == 0)
						tabledata+='<tr>';
					var realdata=dataArray[j];
					var dispVal1 =realdata;
					if(realdata.hasOwnProperty('hrefUrl'))
					{
						var dispVal = realdata['dispVal'];
						var hrefUrl = realdata['hrefUrl'];
						if(dispVal!=null && dispVal=="top.gif")
						{
							dispVal='iconArrowUp';
						}
						//dispVal1 = '<a href="javascript:void(0);" onclick=showTable("event","'+encodeURI(hrefUrl)+'","1") >'+dispVal+'</a>'
						dispVal1 = '<div align="left"><a href="javascript:void(0);" onClick="javascript:showDrillDownData(\''+hrefUrl+'\');" ><div class="'+dispVal+'"></div></a></div>';
						//dispVal1 = '<div align="left"><a href="javascript:void(0);" onClick="javascript:showDrillDownData(\''+value+'\');" ><div class="'+dispVal+'"></div></a></div>';

					}

					tabledata+='<td>'
						+'<div>'+j+'</div>'
					+'</td><td>'
						+'<div>'+dispVal1+'</div>'
					+'</td>';
					cntt++;
					if(cntt == 2)
					{
						tabledata+='</tr>';
						cntt=0;
					}
					if(totalCount <= 3)
					{
						tabledata+='</tr>';
						cntt=0;
					}
					y++;
				}
				if(y % 2 !=0 && totalCount>3)
					tabledata+='<td></td><td></td></tr>';
				tabledata+= '</tbody></table></div>';
				var dynMargn ='10px 10px 10px 10px';
				if(y == 1){
					dynMargn ='10px 250px 10px 250px';
				}
				if(dataPresent)
				{
					itemsArray.push({
						xtype: 'panel',
						ui:'newGraphPanel',
						border:false,
						padding:0,
						bodyPadding:0,
						margin:dynMargn,
						title:resultData.summary_title,
						html: tabledata
					});
				}
				
			}

			var gridDataObj=resultData['measureGrid'];
			// here enable the force fit for show resource details option as NO
			var isForceFit=false;
			var showResourceDetailsComp=Ext.getCmp("ShowResourceDetails");
			var aggregateValue=Ext.getCmp("aggregateValue").getValue().groupByValue;
			var showResourceDetails;
				if(showResourceDetailsComp!=undefined)
				{
				showResourceDetails=showResourceDetailsComp.getValue();
				 if(showResourceDetails!=undefined && showResourceDetails=='No')
					{
					 isForceFit=true;
					}
				}
				if(showResourceDetails == undefined || showResourceDetails == 'undefined')
				{
					showResourceDetails=appConstants.publicjsonDataUsage.er_showResourceUsage
				}
			if (gridDataObj.hasOwnProperty('groupField'))
			{
 				var fieldsToStore = gridDataObj.fieldStore;
				var mainColumnArray = new Array();
				var mainColumn;
				var gridColumn = gridDataObj.gridDisplayColumns;
				var units=gridDataObj.units;
				if(gridColumn.length>7)
					isForceFit = false;
				for (var key in gridColumn)
				{
					if (gridColumn[key] instanceof Object)
					{
						var subColumnObj=gridColumn[key];
						var subColumnArray = new Array();
						for (var k in subColumnObj)
						{
 								//fieldsToStore.push(mainColumn);
								mainColumn = k;
								var subColumnJsonArray=subColumnObj[k];
								var mainColumnWithUnit=units[mainColumn];
						
								for (var m in subColumnJsonArray)
								{
									if (!Ext.isEmpty(mainColumnWithUnit))
										mainColumnWithUnit=subColumnJsonArray[m]+' ( '+mainColumnWithUnit+' ) ';
									else
										mainColumnWithUnit=mainColumn;

 									subColumnArray.push({
										header: mainColumnWithUnit,
										sortable: true,
										align:'center',
										dataIndex: k+'_'+subColumnJsonArray[m],
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											if(value.indexOf('~')>-1)
											{
												var text = value.substring( 0, value.indexOf('~') );
												var url = value.substring( value.indexOf('~') + 1 );
												if(text!=null && text=="top.gif")
												{
													text='<img src="/final/reporter/images/top.gif">';
												}
												value = '<a href="javascript:void(0);" onClick="javascript:loadUrlInDrillDown(\''+url+'\');" >'+text+'</a>';
											}
											return value;
										},
										doSort: function(state) 
										{
 											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2)
												{
												
													if(v1.raw!=undefined && v1.raw.User!=undefined && v1.raw.User=='Summary')
														return;
													if(v2.raw!=undefined &&v2.raw.User!=undefined && v2.raw.User=='Summary')
														return;

													v1 = v1.get(field);
													v2 = v2.get(field);
													if(v1!=undefined && v1.indexOf('~')>-1)
													{
														v1 = v1.substring(0,v1.indexOf('~'));
													}
													if(v2!=undefined && v2.indexOf('~')>-1)
													{
														v2 = v2.substring(0,v2.indexOf('~'));
													}
												
													if(!isNaN(v1) && !isNaN(v2))
													{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
														v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
														if (state=='ASC')
														{
															v1= isNaN(v1) ? 999999 : v1;
															v2= isNaN(v2) ? 999999 : v2;
														}
														else
														{
													v1= isNaN(v1) ? 0 : v1;

													v2= isNaN(v2) ? 0 : v2;
														}
													}
													else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
													{
														v2=new Date(v2).getTime(); 
														v1=new Date(v1).getTime(); 
													}
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
													}
											});
								}

									});
								}

								mainColumnArray.push({
									header: mainColumn,
									sortable: true,
									columns:subColumnArray
								});
						}
					}
					else
					{

						mainColumn = gridColumn[key];
						var mainColumnWithUnit=units[mainColumn];
						if (!Ext.isEmpty(mainColumnWithUnit))
							mainColumnWithUnit=mainColumn+'<div>'+mainColumnWithUnit+'</div>';
						else
							mainColumnWithUnit=mainColumn;
						//fieldsToStore.push(mainColumn);
						mainColumnArray.push({
							header: mainColumnWithUnit,
							sortable: true,
							dataIndex: mainColumn,
							align:'center',
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								if(value.indexOf('~')>-1)
								{
									var text = value.substring( 0, value.indexOf('~') );
									var url = value.substring( value.indexOf('~') + 1 );
  									if(text == "DD")
									{
										metaData.tdCls = 'iconColumn';
										text='<img src="/final/images/spacer.gif" class="iconDiagnosis" />';
										value = '<a href="javascript:void(0);" onClick="javascript:openDDWin(\''+url+'\');" >'+text+'</a>';
									}
									else
									{
										if(text!=null && text=="top.gif")
										{
											metaData.tdCls = 'iconColumn';
											text='<img src="/final/reporter/images/top.gif">';
										}
  										value = '<a href="javascript:void(0);" onClick="javascript:loadUrlInDrillDown(\''+url+'\');" >'+text+'</a>';
									}
								}
								return value;
							},
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{

										if(v1.raw!=undefined && v1.raw.User!=undefined && v1.raw.User=='Summary')
											return;
										if(v2.raw!=undefined &&v2.raw.User!=undefined && v2.raw.User=='Summary')
											return;
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1!=undefined && v1.indexOf('~')>-1)
										{
											v1 = v1.substring(0,v1.indexOf('~'));
										}
										if(v2!=undefined && v2.indexOf('~')>-1)
										{
											v2 = v2.substring(0,v2.indexOf('~'));
										}

										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10); 
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;

												v2= isNaN(v2) ? 0 : v2;
											}
										}
										else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime(); 
											v1=new Date(v1).getTime(); 
										}
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
													}
											});
								}
						});
					}
				}


					var storeObj = Ext.create('Ext.data.ArrayStore', {
						fields:fieldsToStore,
						data:gridDataObj.dataRowArray,
						groupField: gridDataObj.groupField,
						proxy: {
							type: 'memory',
							reader: {
								type: 'json'
 							}
						}
					});

					
					  itemsArray.push({
						  xtype:'panel',
						  ui:'newGraphPanel',
						  margin:'10 10 10 10',
						  title:gridDataObj.gridTitleNew,
						  items:[{
							xtype:'customgrid',
							store:storeObj,
							ui:'newGridPanel',
							sortableColumns:true,
							needtoFixColumn:true,
							border:true,
							forceFit: isForceFit,
							//cls:'gridSkin horizontal-scroll',
							columnLines: true,
							columns:mainColumnArray,
							margin:'5 10 10 10',
							//title:'<span class="font_bold">'+gridDataObj.gridTitleNew+'</span>',
							viewConfig: {
								forceFit: true
							},
							features: [
										{
											ftype: 'grouping',
											//groupHeaderTpl: '{name} ({rows.length})',
											groupHeaderTpl: Ext.create('Ext.XTemplate',
											'{name} ',
											'({rows:this.formatName})',
											{
												formatName: function(rows) {
														if(appConstants.selectedAdGroupFns!=undefined && appConstants.selectedAdGroupFns=='Details')
														{
															return rows.length;
														}
														else if((appConstants.selectdUserForAdGroupTable!=undefined && appConstants.selectdUserForAdGroupTable=='-- All --')||(gridDataObj.gridTitle!=undefined && gridDataObj.gridTitle.indexOf('*')>-1))
													{
														if(rows.length>1)
															return rows.length-1;
														else
															return rows.length;
													}
													else
													return rows.length;
												}
											}),
											startCollapsed: false // start all groups collapsed
										}
							],
							listeners:{
								sortchange:function(ct, column, e, t, eOpts ){
									me.gridColIndexParam=column.getIndex();
									me.gridColStateParam=column.sortState;
								}
								,
							render:function(obj){
								Ext.defer(function() {
									var col=obj.columns[1].items.items[0];
									if (!Ext.isEmpty(col))
									{
										col.setSortState("DESC",true,true);
									}
									else
									{
										col=obj.columns[0];
										col.setSortState("ASC",true,true);
									}
								},100);
							}
							}
						  }]
					});
					//itemsArray.push(gridpanel);
			}
			else if(showResourceDetails!=undefined && showResourceDetails=='No')
			{
			
				var columnDetails=gridDataObj.columns;
				var dataArraytoStore=gridDataObj.dataArray;
				var units=gridDataObj.units;
				var noOfColumns=gridDataObj.TOTAL_COLUMN_COUNT;
				var singleColumnCount=gridDataObj.SINGLE_SUBCOLUMN_COUNT;
				var viewPortWidth=this.getMain().getWidth();
				var COLUMN_MIN_WIDTH=55;
				var SINGLE_COLUMN_WIDTH=120;
				var SERVER_MIN_WIDTH=120;
				var count=0;
				var mutipleColumns=noOfColumns-singleColumnCount;
				var widthNeeded=SERVER_MIN_WIDTH+(mutipleColumns*COLUMN_MIN_WIDTH)+(singleColumnCount*SINGLE_COLUMN_WIDTH);

				var fieldstoStore =  {};
				var cnt=0;
				var mainColumnsObjArray	=  new Array();
				var eachWidth=0;
				if(viewPortWidth>widthNeeded){
					eachWidth=(viewPortWidth-(SERVER_MIN_WIDTH))/noOfColumns;
				}
				else{
					eachWidth=COLUMN_MIN_WIDTH;
				}

					for( var key in columnDetails ){
						var mainColumn=key;
						var subColumns=new Array();
						var subColObjArray=new Array();
						subColumns=columnDetails[key];
 						if(!Ext.isEmpty(subColumns))
						{
							var subColumnCount=subColumns.length;
							var adujstedWidth=eachWidth;
							if(subColumnCount == 1){
								if(eachWidth<SINGLE_COLUMN_WIDTH)
								adujstedWidth=SINGLE_COLUMN_WIDTH;
							}
							for(var j in subColumns)
							{
								var tmp=subColumns[j];
								fieldstoStore[cnt]=mainColumn+"_"+tmp;
								var s_unit=units[mainColumn];
								if(s_unit!=undefined && s_unit!='-')
									s_unit=" ("+s_unit+")";
								else
									s_unit='&nbsp';
								var measureColumnName=" ("+units[mainColumn]+")";
								adujstedWidth=140;
								subColObjArray.push({
									header: tmp+s_unit,
									sortable:true,
									dataIndex: cnt,
									align:'center',
									width:adujstedWidth,
									//width:125,
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{												
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(v1!=undefined && v1.indexOf('~')>-1)
												{
													v1 = v1.substring(0,v1.indexOf('~'));
												}
												if(v2!=undefined && v2.indexOf('~')>-1)
												{
													v2 = v2.substring(0,v2.indexOf('~'));
												}

												if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
														v1= isNaN(v1) ? 0 : v1;
														v2= isNaN(v2) ? 0 : v2;
													}
												}
												else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
													}
												});
										}
 								
								});
								cnt++
							}
							var measureColumns = new Array();
							var s_unit=units[mainColumn];
							var measureColumnName=" ("+units[mainColumn]+")";

							/*measureColumns.push({
								header : '&nbsp',
								columns: subColObjArray,
							});*/

							mainColumnsObjArray.push(
							{
								header: mainColumn,
								locked:false,
								columns: subColObjArray
							});
							
						}
						else{

								var align='center';
 								if (mainColumn=='User' || mainColumn==' Session Start Time' || mainColumn=='Logout / Disconnect Time' ||  mainColumn=='Server')
								{
									align='left';
								}
								var adujstedWidth=eachWidth;
								if(eachWidth<SINGLE_COLUMN_WIDTH)
								adujstedWidth=SINGLE_COLUMN_WIDTH;
							fieldstoStore[cnt]=mainColumn;
								var enableLock=false;
								var needModify='yes';
									if(mainColumn=='User')
									{
										enableLock=true;
										adujstedWidth=115;
									}else
										adujstedWidth=140;
									if(mainColumn=='')
									{
										needModify='no';
										enableLock=true;
										adujstedWidth=50;
									}
								var measureColumns = new Array();
								var s_unit=units[mainColumn];
								var needToHide=false;
									var measureColumnName=" ("+units[mainColumn]+")";
									if(Ext.isEmpty(mainColumn)){
										if(!isDetailsEnabled){
										//if(!(compType == 'Citrix_XcXenApp_server' || compType == 'Terminal_server' || compType == 'Citrix_server')){
											needToHide=true;
										}
									}
									/*measureColumns.push({
										header : measureColumnName,
										columns: subColObjArray,
									});*/
								mainColumnsObjArray.push(
								{
									header: mainColumn,
									dataIndex: cnt,
									locked:enableLock,
									needModify:needModify,
									hidden:needToHide,
									width:adujstedWidth,
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										var toolotipVal=value;
											if(value.indexOf('~')>-1)
											{
												var text = value.substring( 0, value.indexOf('~') );
												var orgText = text;
												if(text!=null && text=="top.gif")
												{
													text='iconArrowUp';
												}
												if(text == "DD")
												{
													if(showApp!=null && showApp == "Yes")
													{
														var appName = value.substring( value.indexOf('~') + 1 );
														if(appName!=null && appName!="-")
														{
															text = "<ul>";
															var aValue = appName.split(',');
															for (var v = 0; v < aValue.length; v++) {
																text += "<li style='height:20px;'><div style='float:left;'>"+aValue[v]+"</div></li>";
															}
															text += "</ul>";
														}
													}else
													{
														metaData.tdCls = 'iconColumn';
														text='<div align="center"><div class="iconDiagnosis"></div></div>';
													}
												}
												if(text == "Details")
												{

													metaData.tdCls = 'iconColumn';
													text='<div align="center"><div class="iconReportDetails"></div></div>';
												}
												var url = value.substring( value.indexOf('~') + 1 );
												if(orgText == "DD")
												{
													toolotipVal="DD";
													if(showApp!=null && showApp == "Yes")
														value = text;
													else
														value = '<div align="center"><a href="javascript:void(0);" class="anchorLinkDefault" onClick="javascript:openDDWin(\''+url+'\')">'+text+'</a></div>';
												}
												else if(orgText == "iconArrowUp" || orgText=="top.gif")
												{
													toolotipVal="Graph";
													value = '<div align="center"><a href="javascript:void(0);" onClick="window.location.href=\''+url+'\'" ><div class="iconReportDetails"></div></a></div>';
												}
												else if(orgText == "Details")
												{
													toolotipVal="Details";
													value = '<div align="center"><a href="javascript:void(0);" class="anchorLinkDefault" onClick="javascript:loadUsersSessionView(\''+record.data.indx+'\')">'+text+'</a></div>';
												}
												else
													value = '<div align="left"><a href="javascript:void(0);" class="anchorLinkDefault" onClick="window.location.href=\''+url+'\'" >'+text+'</a></div>';
											}
											metaData.tdAttr = 'data-qtip="' + toolotipVal + '"';
											return value;
										}
								});
								cnt++;
							}
						count++;
					}
				
 				/*var fetchedData = function(){
					this.data = null;
					this.total = 0;
				}*/
				var colSize=40;
				if(aggregateValue != null && aggregateValue == 'Summary')
					colSize=160;
				var isPagingHidden;
				gridPageSize=15;
				if (dataArraytoStore.length<gridPageSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				
				var fields=[];
				var colLen=Object.keys(dataArraytoStore[0]).length;
			
				for(var key in dataArraytoStore[0])
				{				
					fields.push(key);
				}
				var storeObj = Ext.create('Ext.data.Store', {
					fields: fields,
					proxy : {
							type : 'pagingmemory',
							reader : {
								type: 'json', root : 'data', totalProperty : 'total'
							},
							data:dataArraytoStore,
						},
					remoteSort : true,
					//sorters: { property: fields[1], direction : 'ASC' },
					pageSize:gridPageSize,	//gridPageSize is added in ErTracker.jsp
					autoLoad : true,			
					
				});
				var activePage=1;
				
			itemsArray.push({
				xtype:'panel',
				ui:'newGraphPanel',
				margin:'10 10 10 10',
				title:gridDataObj.gridTitle,
				items:[{
					xtype:'customgrid',
					store:storeObj,
					sortableColumns:true,
					needtoFixColumn:true,
					forceFit:true,
					border:true,
					ui:'newGridPanel',
					//cls:'gridSkin horizontal-scroll',
					columns:mainColumnsObjArray, 
 					padding:0,
					margin:'5 10 10 10',
					//title:'<span class="font_bold">'+gridDataObj.gridTitle+'</span>',
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
							me.gridColIndexParam=column.getIndex();
							me.gridColStateParam=column.sortState;
							 this.getStore().loadPage(activePage);
						}
						,
						render:function(obj){
  							Ext.defer(function() {
								//obj.columns[0].setWidth(colSize);
								//obj.columns[1].setSortState("DESC",true,true);
							},100);
						}
				  },
				  dockedItems:[{
						xtype:'pagingtoolbar',
						cls:'newPagination',
						dock: 'bottom',
						displayInfo: true,
						store: storeObj,
						hidden:isPagingHidden,
						displayInfo: true,
						displayMsg: 'Displaying topics {0} - {1} of {2}',
						emptyMsg: "No topics to display",
						listeners: {
							change : function(thisd, params)
							{   
								if(!Ext.isEmpty(params))
									activePage = params.currentPage;
								else
									activePage=1;
							}
						}
					}]
				}]
			});
			}
			else
			{
				var columnDetails=gridDataObj.columns;
				var dataArraytoStore=gridDataObj.dataArray;
				var units=gridDataObj.units;
				var noOfColumns=gridDataObj.TOTAL_COLUMN_COUNT;
				var singleColumnCount=gridDataObj.SINGLE_SUBCOLUMN_COUNT;
				var viewPortWidth=this.getMain().getWidth();
				var COLUMN_MIN_WIDTH=55;
				var SINGLE_COLUMN_WIDTH=120;
				var SERVER_MIN_WIDTH=120;
				var count=0;
				var mutipleColumns=noOfColumns-singleColumnCount;
				var widthNeeded=SERVER_MIN_WIDTH+(mutipleColumns*COLUMN_MIN_WIDTH)+(singleColumnCount*SINGLE_COLUMN_WIDTH);

				var fieldstoStore =  {};
				var cnt=0;
				var mainColumnsObjArray	=  new Array();
				var eachWidth=0;
				if(viewPortWidth>widthNeeded){
					eachWidth=(viewPortWidth-(SERVER_MIN_WIDTH))/noOfColumns;
				}
				else
				{
					eachWidth=COLUMN_MIN_WIDTH;
				}

				for( var key in columnDetails )
				{
					var mainColumn=key;
					var subColumns=new Array();
					var subColObjArray=new Array();
					subColumns=columnDetails[key];
					if(!Ext.isEmpty(subColumns))
					{
						var subColumnCount=subColumns.length;
						var adujstedWidth=eachWidth;
						if(subColumnCount == 1){
							if(eachWidth<SINGLE_COLUMN_WIDTH)
							adujstedWidth=SINGLE_COLUMN_WIDTH;
						}
						for(var j in subColumns)
						{
							var tmp=subColumns[j];
							fieldstoStore[cnt]=mainColumn+"_"+tmp;
							var s_unit=units[mainColumn];
							if(s_unit!=undefined)
								s_unit=" ("+s_unit+")";
							else
								s_unit='&nbsp';
							var measureColumnName=" ("+units[mainColumn]+")";
							adujstedWidth=140;
							subColObjArray.push({
								header: tmp+s_unit,
								sortable:true,
								dataIndex: cnt,
								align:'center',
								width:adujstedWidth,
								//width:125,
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(v1!=undefined && v1.indexOf('~')>-1)
												{
													v1 = v1.substring(0,v1.indexOf('~'));
												}
												if(v2!=undefined && v2.indexOf('~')>-1)
												{
													v2 = v2.substring(0,v2.indexOf('~'));
												}
												if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
												{
													var tmp = v1.substring(0, v1.lastIndexOf(' '));

													var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
													var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
													v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
												}
												if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
												{
													var tmp = v2.substring(0, v2.lastIndexOf(' '));
													var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
													var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
													v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
												}
												if(!isNaN(v1) && !isNaN(v2))
												{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
												v1= isNaN(v1) ? 0 : v1;

												v2= isNaN(v2) ? 0 : v2;
													}
												}
												else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
									},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									var toolotipVal=value;
									if(value != undefined && value.indexOf('~')>-1)
									{
										var text = value.substring( 0, value.indexOf('~') );
										var url = value.substring( value.indexOf('~') + 1 );
										var anchorCls = 'class="anchorLinkDefault"';
										if(text!=null && text=="top.gif")
										{
											anchorCls = '';
											toolotipVal="Graph";
											text='<img src="/final/reporter/images/top.gif">';
										}
										else
										{
											toolotipVal = text;
										}
										value = '<a href="javascript:void(0);" onClick="javascript:loadUrlInDrillDown(\''+url+'\');" >'+Ext.getCmp('girdTable_1').getDecimalAlignFormat(text,true)+'</a>';
									}
									else
									{
										value = Ext.getCmp('girdTable_1').getDecimalAlignFormat(value);
									}
									metaData.tdAttr = 'data-qtip="' + toolotipVal + '"';
									return value;
								}
							});
							cnt++
						}
						var measureColumns = new Array();
						var s_unit=units[mainColumn];
						var measureColumnName=" ("+units[mainColumn]+")";

						/*measureColumns.push({
							header : '&nbsp',
							columns: subColObjArray,
						});*/

						mainColumnsObjArray.push(
						{
							header: mainColumn,
							locked:false,
							columns: subColObjArray
						});
						
					}
					else{

							var align='center';
							if (mainColumn=='User' || mainColumn==' Session Start Time' || mainColumn=='Logout / Disconnect Time' ||  mainColumn=='Server')
							{
								align='left';
							}
							var adujstedWidth=eachWidth;
							if(eachWidth<SINGLE_COLUMN_WIDTH)
								adujstedWidth=SINGLE_COLUMN_WIDTH;
							fieldstoStore[cnt]=mainColumn;
								if(cnt==1)
								{
									adujstedWidth=115;
								}else if(cnt==0)
									adujstedWidth=90;
								if(cnt==0 && Ext.getCmp("aggregateValue").getValue().groupByValue=='Details')
									adujstedWidth=70;
								var needToHide=false;
								var enableLock=false;
								var ApplicationsIndex;
								var moreDetailscnt;
								if(mainColumn=='Applications')
								{
									needToHide=true;
									ApplicationsIndex=cnt;
								}
								if(mainColumn=='More Details')
								{
									needToHide=true;
									moreDetailscnt=cnt;
								}
								if(mainColumn == '' || mainColumn == 'User')
									enableLock=true;
								var needModify = 'yes';
								if(mainColumn == '')
									needModify='no';
								mainColumnsObjArray.push({
									header: mainColumn,
									sortable:true,
									dataIndex: cnt,
									align:align,
									locked:enableLock,
									hidden:needToHide,
									needModify:needModify,
									width:adujstedWidth,
									doSort: function(state)
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(v1!=undefined && v1.indexOf('~')>-1)
												{
													v1 = v1.substring(0,v1.indexOf('~'));
												}
												if(v2!=undefined && v2.indexOf('~')>-1)
												{
													v2 = v2.substring(0,v2.indexOf('~'));
												}

												if(!isNaN(v1) && !isNaN(v2))
												{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
												v1= isNaN(v1) ? 0 : v1;

												v2= isNaN(v2) ? 0 : v2;
													}
												}
												else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
									},
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										var toolotipVal=value;
										if(value.indexOf('~')>-1)
										{
											var text = value.substring( 0, value.indexOf('~') );
											var orgText = text;
											if(text!=null && text=="top.gif")
											{
												text='iconArrowUp';
											}
											if(text == "DD")
											{
												if(showApp!=null && showApp == "Yes")
												{
													var appName = value.substring( value.indexOf('~') + 1 );
													if(appName!=null && appName!="-")
													{
														text = "<ul>";
														var aValue = appName.split(',');
														for (var v = 0; v < aValue.length; v++) {
															text += "<li style='height:20px;'><div style='float:left;'>"+aValue[v]+"</div></li>";
														}
														text += "</ul>";
													}
												}else
												{
													text='<div align="center"><div class="iconDiagnosis"></div></div>';
												}
											}
											if(text == "Details")
											{
												text='<div align="center"><div class="iconReportDetails"></div></div>';
											}
											var url = value.substring( value.indexOf('~') + 1 );
											if(orgText == "DD")
											{
												toolotipVal="DD";
												if(showApp!=null && showApp == "Yes")
													value = text;
												else
													value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:openDDWin(\''+url+'\')">'+text+'</a></div>';
											}
											else if(orgText == "iconArrowUp" || orgText=="top.gif")
											{
												toolotipVal="Graph";
												value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="window.location.href=\''+url+'\'" ><div class="iconArrowUp"></div></a></div>';
											}
											else if(orgText == "Details")
											{
												toolotipVal="Details";
												value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:loadUsersSessionView(\''+record.data.indx+'\')">'+text+'</a></div>';
											}
											else
											{
												toolotipVal=text;
												value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="window.location.href=\''+url+'\'" >'+text+'</a></div>';
											}
											if(col==0)
											{
												var ApplicationsVal = record.data[ApplicationsIndex];
												var moreDetailsVal = record.data[moreDetailscnt];
								//				if(!(compType == 'Citrix_XcXenApp_server' || compType == 'Terminal_server' || compType == 'Citrix_server')){
												if(!isDetailsEnabled ){
													value="";
													if(moreDetailsVal!=undefined && moreDetailsVal!='undefined')
													{
														var AppText=moreDetailsVal.substring(0,moreDetailsVal.indexOf('~'));
														var AppUrl = moreDetailsVal.substring( moreDetailsVal.indexOf('~') + 1);
														value = '<table ><tr><td><div align="center"><a href="javascript:void(0);" onClick="window.location.href=\''+AppUrl+'\'" ><div class="iconArrowUp"></div></a></div></td></tr></table>';
													}
												}
												if(ApplicationsVal!=undefined && ApplicationsVal!='undefined')
												{
													var AppText=ApplicationsVal.substring( 0,ApplicationsVal.indexOf('~'));
													var AppUrl = ApplicationsVal.substring( ApplicationsVal.indexOf('~') + 1 );
													if(AppText != null && AppText =="DD")
													{
													if(showApp!=null && showApp == "Yes")
													{
														var appName = ApplicationsVal.substring( ApplicationsVal.indexOf('~') + 1 );
														if(appName!=null && appName!="-")
														{
															AppText = "<ul>";
															var aValue = appName.split(',');
															for (var v = 0; v < aValue.length; v++) {
																AppText += "<li style='height:20px;'><div style='float:left;'>"+aValue[v]+"</div></li>";
															}
															AppText += "</ul>";
														}
													}
													else
													{
														AppText='<div align="center"><div class="iconDiagnosis"></div></div>';
													}
													ApplicationsVal = '<div align="center"><a href="javascript:void(0);" onClick="javascript:openDDWin(\''+AppUrl+'\')">'+AppText+'</a></div>';
													}
													else
														ApplicationsVal = '<div align="center">-</div>';
													if(isVmComp){
														var detVal ="";
														if(moreDetailsVal!=undefined && moreDetailsVal!='undefined')
														{
															var AppUrl = moreDetailsVal.substring( moreDetailsVal.indexOf('~') + 1);
															detVal = '<table ><tr><td><div align="center"><a href="javascript:void(0);" onClick="window.location.href=\''+AppUrl+'\'" ><div class="iconArrowUp"></div></a></div></td></tr></table>';
														}
														value='<table width="75px" style="width:50px"><tr><td width="25px">'+value+'</td><td width="25px">'+detVal+'</td><td width="25px">'+ApplicationsVal+'</td></tr></table>';
													}else{
														value='<table width="50px" style="width:50px"><tr><td width="25px">'+value+'</td><td width="25px">'+ApplicationsVal+'</td></tr></table>';
													}
													metaData.tdCls="iconColumn";
												}else if(moreDetailsVal != undefined && moreDetailsVal!='undefined' && isDetailsEnabled){
													if(isVmComp){
														var detVal ="";
														if(moreDetailsVal!=undefined && moreDetailsVal!='undefined')
														{
															var AppUrl = moreDetailsVal.substring( moreDetailsVal.indexOf('~') + 1);
															detVal = '<table ><tr><td><div align="center"><a href="javascript:void(0);" onClick="window.location.href=\''+AppUrl+'\'" ><div class="iconArrowUp"></div></a></div></td></tr></table>';
														}
														value='<table width="50px" style="width:50px"><tr><td width="25px">'+value+'</td><td width="25px">'+detVal+'</td></tr></table>';
													}
												}
											}
										}
										metaData.tdAttr = 'data-qtip="' + toolotipVal + '"';
										return value;
									}
							});
							var measureColumns = new Array();
							var s_unit=units[mainColumn];
							var measureColumnName=" ("+units[mainColumn]+")";
							cnt++;
						
					}
					count++;
				}
				
 				/*var fetchedData = function(){
					this.data = null;
					this.total = 0;
				}*/
				var isPagingHidden;
				gridPageSize=15;
				if (dataArraytoStore.length<gridPageSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				
				var fields=[];
				var colLen=Object.keys(dataArraytoStore[0]).length;
			
				for(var key in dataArraytoStore[0])
				{				
					fields.push(key);
				}
				var colWidth=80;
				var comptype=appConstants.publicjsonDataUsage.selectedCompType;
				if(comptype != null && comptype == 'Xen_desktop_server'){
					colWidth=40;
				}
				if(aggregateValue!= null && aggregateValue == 'Summary'){
					colWidth=170;
				}
				var storeObj = Ext.create('Ext.data.Store', {
					fields: fields,
					proxy : {
							type : 'pagingmemory',
							reader : {
								type: 'json', root : 'data', totalProperty : 'total'
							},
							data:dataArraytoStore,
						},
					pageSize:gridPageSize,	//gridPageSize is added in ErTracker.jsp
					autoLoad : true,			
					remoteSort : true,
					sorters: { property: fields[1], direction : 'ASC' }// vengat
					
				});
				var activePage=1;
			itemsArray.push({
				xtype:'panel',
				ui:'newGraphPanel',
				margin:'10 10 10 10',
				title: gridDataObj.gridTitle,
				items:[{
					xtype:'customgrid',
					store:storeObj,
					ui:'newGridPanel',
					sortableColumns:true,
					needtoFixColumn:true,
					border:true,
					id:'girdTable_1',
					columns:mainColumnsObjArray, 
					margin:'0 10 10 10',
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
							me.gridColIndexParam=column.getIndex();
							me.gridColStateParam=column.sortState;
							 this.getStore().loadPage(activePage);
						}
						,
						render:function(obj){
  							Ext.defer(function() {
								//obj.columns[1].setSortState("DESC",true,true);
								//obj.columns[0].setWidth(colWidth);
							},100);
						}
				  },
				  dockedItems:[{
						xtype:'pagingtoolbar',
						dock: 'bottom',
						cls:'newPagination',
						displayInfo: true,
						store: storeObj,
						hidden:isPagingHidden,
						displayInfo: true,
						displayMsg: 'Displaying topics {0} - {1} of {2}',
						emptyMsg: "No topics to display",
						listeners: {
							change : function(thisd, params)
							{   
								if(!Ext.isEmpty(params))
									activePage = params.currentPage;
								else
									activePage=1;
							}
						}
					}]
				}]
			})
			}

			var disconnectTableData =resultData['disconnectUserTable'];
			if(!Ext.isEmpty(disconnectTableData) && disconnectTableData['columnDetails'].length>0)
			{
				var columnDetails=disconnectTableData['columnDetails'];
				var dataArray=disconnectTableData['tableData'];
				var tabledata = '<div class="x-table" >'
				+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'
					+'<thead>'
						+'<tr class="x-grid-row">';
				for( var k in columnDetails){
							tabledata+='<th class=" x-grid-cell">'
								+'<div class="x-grid-cell-inner">'+columnDetails[k]+'</div>'
							+'</th>';
				}
				tabledata+='</tr>'
					+'</thead>'
				+'<tbody>'
				+'<tpl for=".">';
				for(var j in dataArray)
				{
					var realdata=dataArray[j];
					tabledata+='<tr class="x-grid-row">';
					for(var l in realdata){
						tabledata+='<td style="text-align:center" class=" x-grid-cell x-grid-cell-first">'
							+'<div class="x-grid-cell-inner" >'+realdata[l]+'</div>'
						+'</td>'
					}
					tabledata+='</tr>';
				}
				tabledata+='</tpl>'
				+'</tbody>'
				+'</table>'
				+'</div>';
				itemsArray.push({
								xtype: 'panel',
 								margin:'5 10 10 10',
								/*layout: {
									columns: 2,
									align: 'center'
								},*/
								cls: 'datapanel',
								bodyPadding: '0 0 0 0',
								title:'<span class="font_bold">'+ disconnectTableData.title+'</span>',
								padding:0,
								html: tabledata
				});
			}

			Ext.getCmp("csvTool").setDisabled(false);

			resultPanelObj.removeAll();
 			resultPanelObj.add(itemsArray);
			resultPanelObj.show();
 		}
	},
	loadReportData:function(jsonData)
	{
		var itemsArray=new Array();
		var me=this;
		var reportFor = Ext.getCmp('report_category').getValue();
 		var dataAvailable=false;
		var resultPanelObj=Ext.getCmp('resultPanel');
		if(jsonData.hasOwnProperty('reportData'))
		{
			var reportData=jsonData.reportData;
			var compType = reportData.compType;
			var dataAvail = reportData.NO_DATA;
			if(compType!=undefined && compType=='Horizon_Pod')
			{
				if(dataAvail==undefined || dataAvail=='Yes')
				{
					this.disableTools();
					resultPanelObj.hide();
					this.getNomeasurepanel().show();
					initLdgMask.hide();
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
					return;
				}
			}
			Ext.getCmp('panelinsidetoggle').setDisabled(false);
			if(reportFor == 'user_activity'){
				resultPanelObj.removeAll();
				appConstants.publicjsonDataActivity=jsonData;
				var chartType=jsonData['chartType'];
				reportType=jsonData.selectedreportType;
					if(reportType=='Yes'){
 						var chartUrlArray =new Array();
						chartUrlArray=reportData.chartUrls;
						noOfchart=chartUrlArray.length;
						var graphType = jsonData.selectedGraphType;
						Ext.getCmp("csvTool").setDisabled(true);
						if(graphType == 'distribution'){
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("printTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
 
							for(var i=0;noOfchart>i;i++){
								var url = chartUrlArray[i];
								var chartProperties=this.getXmlForUrl(url);
								if (!Ext.isEmpty( chartProperties ) && chartProperties.hasOwnProperty('XML') ){
									dataAvailable=true;
									var margin;
									var flex;
									if (i==0)
									{
										margin='0 10 10 10';
										flex=0.65;
									}
									else
									{
										margin='0 10 10 0'
										flex=1;
									}
									var chartbox={
													//xtype:'container',
													xtype:'panel',
													ui:'newGraphPanel',
													data: chartProperties,
													flex:flex, 
													title:chartProperties.chartTitle,
													margin:margin,
													header:{
														style:{
															'padding':'10px 5px 5px 10px'
														}
													},
 													//cls:'containerShadow',
													id: 'fusion'+i
											};
									itemsArray.push(chartbox);
								}
							}
							if(dataAvailable)
							{
									resultPanelObj.add({
										xtype:'panel',
										//title:"<span class='font_bold'>"+reportData.title+"</span>",
										title:reportData.title,
										margin:'10 10 10 10',
										//cls:'datapanel',
										ui:'multiGraphPanel',
										layout:{type:'hbox',align:'stretch'},
										height:400,
										columnWidth:1.0,
										items:itemsArray
									});
									resultPanelObj.show();
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									} 
 									for ( var i = 0; i < noOfchart; i++ )
									{
										var containerObj=Ext.getCmp('fusion'+i);
										var data = containerObj.data;

										if ( !Ext.isEmpty( data ) && data.hasOwnProperty('XML') )
										{
											var innerHtml=data.innerHtml;
											var chartFor =data.chartFor;
											var chartHight =data.chartHight;

											if(chartFor =='Top')
											{
												appConstants.erUtils.updateBarChart(appConstants.chartType,'',data.XML,data.swfpath,data,data.chartHeight-20,data.chartWidth,containerObj);
                     						}
											else if(chartFor =='distribution')
											{
												appConstants.erUtils.updatePieChart(appConstants.chartType,data,'pieColors','urlLinks','pieLabels','',data.XML,data.swfpath,data,containerObj);
												//	PieDrillDownURLs=data.UrlForDrillDown;
											} 
										}
										else
										{
											containerObj.update('<div><img src="/final/reporter/images/nographformeasure.gif" width="100%" /></div>');
										}
									}
									Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
 								initLdgMask.hide();
							}
							else{
								this.disableTools();
								resultPanelObj.hide();
 								this.getNomeasurepanel().show();
								initLdgMask.hide();
								Ext.getCmp('panelinsidetoggle').setDisabled(true);
							}
						}
						else if(graphType == 'timeline'){

						
							var isShowLegend = jsonData.showLegend;
						
							Ext.getCmp('showLegend').show();
							var showLegendChkBox = Ext.getCmp('showLegend');
							showLegendChkBox.setValue(isShowLegend)
						

							var resultPanelObj=Ext.getCmp('resultPanel');
							itemsArray= new Array();
							resultPanelObj.removeAll();
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("printTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
							Ext.getCmp("upbutton").setDisabled(false);
							var highChartUrls = new Array();
							var highChartdrilldwonUrls = new Array();
							var highChartIds = new Array();

							var chartURLs = new Array();
							var domArray = new Array();
							//var content='<div  style="width:100%"><table width="100%" border="0" class="htmlTable"><col width="50%"><col width="50%"><tr>';//<col width="50%"><col width="50%">
							var content='<div  style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';//<col width="50%"><col width="50%">
							var col=0;
							for(var i=0;noOfchart>i;i++)
							{
								var evenLastTd=false;
								var DefaultHeight = 300;
								var chartObj = chartUrlArray[i];
								var url = chartObj.queryString;
								var chartHeight = parseInt(chartObj.chartHeight);
								var chartWidth = parseInt(chartObj.chartWidth);
								var chartQstring = chartObj.drillDownQstring;
								var drillQString = chartObj.drillDownQstring1;
								var chartTitle = chartObj.chartTitle;
							
								var ddQString = chartObj.ddQstring;
								var isddEnabled = chartObj.isddEnabled;
								var drillDownQstring = drillQString+"&option=Citrix&drillDown=yes";
								var  dpSh   =  Ext.getCmp("er_sthr").getValue() ;
                                                                var  dpEh   =  Ext.getCmp("er_endhr").getValue();
								if (DefaultHeight < chartHeight)
									DefaultHeight = chartHeight;
								var highChartDrillDownUrl=drillDownQstring += "&calculatedHeight=" + DefaultHeight+'&dpSh='+dpSh+'&dpEh='+dpEh;;
								chartURLs.push(url);
								if (col==2)
								{
									col=0;
									content+='</tr>';
									content+='<tr>';
								}
								if(i == 0){
									if (noOfchart>2)
									{
										content+='<td style="padding:0px 5px 5px 10px">';
										//content+='<td style="padding:0px 5px 10px 10px">';
									}
									else if(noOfchart==2)
									{
										content+='<td style="padding:10px 5px 10px 10px">';
										//content+='<td style="padding:0px 10px 10px 10px">';
									}
									else
									{
										content+='<td style="padding:10px 10px 10px 10px">';
										//content+='<td style="padding:0px 10px 10px 10px">';
									}
								}
								else if(i == 1){
									if (noOfchart>2)
									{
										content+='<td style="padding:0px 10px 5px 5px">';
										//content+='<td style="padding:0px 10px 10px 5px">';
									}
									else
									{
										content+='<td style="padding:10px 10px 10px 5px">';
										//content+='<td style="padding:0px 10px 10px 5px">';
									}
								}
								else if((i%2) == 0){
									if (i==noOfchart-1)
									{
										evenLastTd=true;
										content+='<td style="padding:5px 5px 10px 10px">';
										//content+='<td style="padding:0px 5px 10px 10px">';
									}
									else if (i==noOfchart-2)
									{
										content+='<td style="padding:5px 5px 5px 10px">';
										//content+='<td style="padding:0px 5px 5px 10px">';
									}
									else{
										content+='<td style="padding:5px 5px 5px 10px">';
										//content+='<td style="padding:5px 5px 0px 10px">';
									}
								}
								else if((i%2) != 0){
									if (i==noOfchart-1)
									{
										content+='<td style="padding:5px 10px 5px 5px">';
										//content+='<td style="padding:0px 10px 5px 5px">';
									}
									else{
										content+='<td style="padding:5px 10px 5px 5px">';
										//content+='<td style="padding:5px 10px 0px 5px">';
									}
								}
								content+='<div width="100%" class="graphMainDiv">';

								//content+='<div class="htmlGraphTableHeader"><div style="float:left;">';
								content+='<div class="htmlGraphTableHeader"><div style="float:left;width:75%" class="infoText" data-qtip="'+chartTitle+'">';
								content+=chartTitle;
								content+='</div>';

								content+='<div style="float:right;margin:3px 0px 4px 5px;">';
								content+='<div style="float:right;cursor:pointer;margin:0px 0px 0px 5px;" class="iconMaximize" onclick="javascript:loadUrlInDrillDown(\''+highChartDrillDownUrl+'\');"></div>';
								content+='<div style="float:right;cursor:pointer;margin:0px 5px 0px 5px;" class="iconCsv" onclick="javascript:loadCSVWindow(\''+chartQstring+'&option=CSV'+'\');"></div>';
								content+='<div style="float:right;cursor:pointer;margin:0px 5px 0px 5px;" class="iconData" onclick="javascript:loadDataWindow(\''+chartQstring+'&option=data'+'\');"></div>';
								if(appConstants.isFromDrillDown!=null && appConstants.isFromDrillDown!='null'&& appConstants.isFromDrillDown!=undefined && appConstants.isFromDrillDown!='undefined' && appConstants.isFromDrillDown)
								{
								if(isddEnabled!=undefined && isddEnabled=='true')
									content+='<div style="float:right;cursor:pointer;margin:0px 5px 0px 5px;" class="iconDiagnosis" onclick="javascript:openDDWindow(\''+ddQString+'\');"></div>';
								}
								
								content+='</div></div>';
								content+='<div class="headerBottomBorder" style="padding:0px;margin:0px"></div>';


								var dom='img_'+i;
								domArray.push(dom);

								//content+='<div id="'+dom+'" class="htmlTableBody">'; 
								content+='<div id="'+dom+'" style="height:225px;width:100%;" class="htmlGraphTableBody showDiv">'; 
								if(chartType != "highchart")
								{
									content+='<img src="'+url+'"></img>';
								} 
								content+='</div>';
								content+='<div style="height:60px;margin-right: 10px;" id="commonLeg_'+dom+'" class="showDiv commonLeg">';
								content+='<div id="'+dom+'_legend" style="height:55px;width:100%;overflow:hidden;display:inline-block; vertical-align: middle;" class="showDiv">';
								content+='</div></div>';
								content+='</div></td>';
								if (evenLastTd)
								{
									content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
								}
								col++;
							}
							if (col==2)
							{
								content+='</tr>';
							}
							content+='</table></div>';
							resultPanelObj.removeAll();
							resultPanelObj.add({
									xtype: 'panel',
									title: reportData.title,
									//cls: 'datapanel',
									/*header:{
										cls:'networkheader'
									},*/
									ui:'multiGraphPanel',
									cls:'newChk',
									margin:'10 10 10 10',
									columnWidth:1.0,
									html:content,
									listeners:{
										resize:function(panel, width, height){
											$('.graphMainDiv').each(function(el){
												if(domArray.length>1){
														$(this).width((width-32)/2);
													}
											});
										},
										boxready:function(){
											var islegendEnabled = Ext.getCmp('showLegend').getValue();
											if(islegendEnabled == "false" || islegendEnabled==false){
												var elms = document.getElementsByClassName("commonLeg");
												for(var i = 0; i < elms.length; i++) {
													var chkkk=elms[i].id;
													var tmp_div=document.getElementById(chkkk);
													if(tmp_div != null && tmp_div != undefined)
														tmp_div.className=tmp_div.className.replace('showDiv', 'hideDiv');
												}
											}
										}
									}
							});
							resultPanelObj.show();
							resultPanelObj.doLayout();
							if(chartType == "highchart"){
								for( var key in chartURLs){
									//reportHighStockChart(highChartUrls[l],highChartIds[l],300,900,highChartdrilldwonUrls[l]);
									reportHighStockChart(chartURLs[key]+"&chartType="+chartType,domArray[key],'','','');
								}
							}
							Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
							initLdgMask.hide();
					}
				}
				else if(reportType == 'No'){

					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);

					publicGridData=reportData.GridObj;
					this.loadGrid(publicGridData);
 					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					initLdgMask.hide();
				}
			}
			else if(reportFor == 'user_usage'){
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("upbutton").setDisabled(false);
				appConstants.publicjsonDataUsage=jsonData;
				appConstants.selectdUserForAdGroupTable=jsonData.selectedUser;
				appConstants.selectedAdGroupFns=jsonData.selectedAdGroupFns;
				if(compType!=undefined && compType=='Horizon_Pod')
				{
					resultPanelObj.removeAll();
					resultPanelObj.add({
						xtype:'podresultview',
						data:reportData
					});
					resultPanelObj.show();
					Ext.getCmp("csvTool").setDisabled(false);
				}
				else
				{
					this.loadUsageGridandTable(reportData);
				}
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				initLdgMask.hide();
			}			
		}
		else{
 			this.disableTools();
			resultPanelObj.hide();
			this.getNomeasurepanel().show();
			initLdgMask.hide();
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
		}
	},
	submitReport:function(){
		initLdgMask.show();
		var url;
		var backgroundUrl;
		var csvbackgroundUrl;
		var Qstring;
		var dataAvailable=false;
		var mainForm =Ext.getCmp('mainform').getForm();
			if(!isSettingsEnabled)
				this.showConfigDropdown();
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var reportFor = mainForm.findField('report_category').getValue();
		appConstants.report_for=reportFor;
		if(reportFor == 'user_activity' || reportFor == 'user_Channel'){
			var rtype=mainForm.findField('er_type').getValue();
			var graphType=mainForm.findField('er_graphType').getValue()
			if(rtype == 'Yes'){
					if(graphType=='timeline')
						Ext.getCmp('showLegend').show();
					var er_appvalue=Ext.getCmp('er_application').getValue();
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}
					er_appvalue = appConstants.erUtils.specialCharEncode(er_appvalue);
				//	alert(er_appvalue)
					if(er_appvalue=="Not Applicable" || er_appvalue=="null" || er_appvalue==null)
						er_appvalue="-1";
					
					if(graphType=='distribution'){
							er_appvalue="-1";
					}
				
			//	url="../servlet/com.eg.ErCtxServerReportC?isSubmit=true&er_server=-1&er_sortby=-1&responseType=json"
						if(appConstants.isFromDrillDown ==null || appConstants.isFromDrillDown=='null'|| appConstants.isFromDrillDown==undefined || appConstants.isFromDrillDown=='undefined' || !appConstants.isFromDrillDown)
				{
					url="../servlet/com.eg.ErCtxServerReportC?isSubmit=true&er_server=-1&er_sortby=-1&responseType=json"+"&er_application="+er_appvalue+"&main_search=true";
				}
				else
				{
					url="../servlet/com.eg.ErCtxServerReportC?isSubmit=true&er_server=-1&er_sortby=-1&responseType=json"+"&er_application="+er_appvalue;

				}

				backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&er_server=-1&er_sortby=-1&responseType=json"
			}
			else{
				Ext.getCmp('showLegend').hide();
				url="../servlet/com.eg.ErCtxServerReportC?isSubmit=true&responseType=json";
				backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";
				csvbackgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
			}
			this.updateQStringActivity();
			Qstring=appConstants.queryStringActivity;
		}
		else{
			this.updateQStringUsage(false);
			Qstring=appConstants.queryStringUsage;
			var er_server_text_box=Ext.getCmp('er_server_text_box');
			if(!Ext.isEmpty(er_server_text_box) && er_server_text_box.isVisible())
			{
				Qstring+= '&er_guestname='+er_server_text_box.getValue();
			}
			url="../servlet/com.eg.ErCtxServerReportC?isSubmit=true&responseType=json";
			backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";
			csvbackgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
		}

 		Qstring+= '&er_RmDispName='+appConstants.er_RmDispName;
		
		if (appConstants.menuForVM=='true')
		{
			Qstring+='&menuForVM=true';
		}
 		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
 		var reportGeneration=Ext.getCmp('reportGeneration').getValue();
		var reportType='';
 		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		if(reportGeneration == 'foreground'){
 			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					initLdgMask.hide();
					var jsonText = response.responseText;
					if(jsonText!=undefined)
					{
						var jsonData=Ext.decode(jsonText);
						this.loadReportData(jsonData);
					}
				}
			});
		}
		else if(reportGeneration == 'background'){
			resultPanelObj.hide();
			var me=this;

 			var htmlStr = '';
			initLdgMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
 				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
						
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
						
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						//htmlStr = '<span>ErroR In BackGround Generation</span>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">ErroR In BackGround Generation </a></div></td></tr></table></td></tr></table>';
					}
  					me.getBackGroundPanel().update(htmlStr);
 					me.getBackGroundPanel().show();
					initLdgMask.hide();
				}
			});
		}
			else if(reportGeneration == 'background-csv'){
			resultPanelObj.hide();
			var me=this;

 			var htmlStr = '';
			initLdgMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :csvbackgroundUrl,
 				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
						
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
						
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						//htmlStr = '<span>ErroR In BackGround Generation</span>';
					
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">ErroR In BackGround Generation </a></div></td></tr></table></td></tr></table>';
					}
  					me.getBackGroundPanel().update(htmlStr);
 					me.getBackGroundPanel().show();
					initLdgMask.hide();
				}
			});
		}

	},
	adGroupChange:function(){
		var clientIpRadio=Ext.getCmp("clientIpRadio");
		var adGroupFns =Ext.getCmp('adGroupFns');
		if(adGroupFns != undefined){
			var adGroupFnsVal=adGroupFns.getValue().adGroupByValue;
			if(adGroupFnsVal == 'Details')
			{
				if(clientIpRadio!=undefined)
					clientIpRadio.show();
			}
			else
			{
				if(clientIpRadio!=undefined)
					clientIpRadio.hide();
			}
		}
	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(reportGenType== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	
	changeResourceDetails:function(obj)
	{
		var resourceVal = Ext.getCmp("ShowResourceDetails").getValue();
		if(resourceVal!=undefined && resourceVal=='Yes' && isVm && appConstants.menuForVM!='true')
		{
			Ext.getCmp('showFrom').show();
		}
		else
		{
			Ext.getCmp('showFrom').hide();
		}
	},
	/* weekendOnChange:function(){
		var reportCat=Ext.getCmp('report_category').getValue();
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');


		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			if(reportCat == 'user_usage')
				excludeDaysObj.update(appConstants.publicjsonDataUsage.screenLabels['MappedExcludeDays']);
			else
				excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	}, */
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQStringActivity:function(obj,flag){
		var FormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm=null;
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getThinclientusersettings().getForm();

		var reportType = mainForm.findField('er_type').getValue();
		var componentType = mainForm.findField('er_compType').getValue();

		FormParams="select_farm="+encodeURIComponent(mainForm.findField('select_farm').getValue())
					+"&er_comptype="+mainForm.findField('er_compType').getValue()
					+"&er_type="+reportType
					+"&er_excwe="+this.getSettingsFieldValue(thinclientuserSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')
					+"&er_reportgenration="+this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
				if(Ext.get('showLegend')!=null)
					FormParams=FormParams+"&showLegend="+mainForm.findField('showLegend').getValue();
		var showFrom = mainForm.findField('showFrom');
		if(showFrom.isVisible() || appConstants.menuForVM=='true')
		{
			FormParams+='&showFrom='+showFrom.getValue();
		}
		if(reportType == 'Yes')
		{
			var sel_GraphType = mainForm.findField('er_graphType').getValue();
			FormParams+="&graphViewtype="+sel_GraphType+"&select_testmes="+mainForm.findField('select_testmes').getValue()
						+"&er_mode="+mainForm.findField('er_mode').getValue()
						+"&sh_timeinuse=No";
			if(sel_GraphType=='timeline' || reportType=='No' ){
//				FormParams+="&er_user="+mainForm.findField('er_application').getValue();
				var application=mainForm.findField('er_application');
				/*var er_application_text_box=mainForm.findField('er_application_text_box');
				if(er_application_text_box.isHidden())
				{
					//FormParams+="&er_application="+encodeURIComponent(mainForm.findField('er_application').getValue())
					FormParams+="&er_application="+mainForm.findField('er_application').getValue();
				}
				else
				{
					//FormParams+="&er_tuser="+encodeURIComponent(mainForm.findField('er_application_text_box').getValue())
					FormParams+="&er_application="+mainForm.findField('er_application_text_box').getValue();
				}*/
				var er_perserver = this.getSettingsFieldValue(thinclientuserSettingsForm,'er_perserver',isSettingsEnabled,'selectedAggServer')
				if(er_perserver!=null)
					FormParams+="&er_perserver="+er_perserver;
			}else if(sel_GraphType=='distribution'){
				FormParams+="&er_perserver=Yes";
			}
		}
		else
		{
			var serverArray=Ext.getCmp('er_server').getValue();
			if(serverArray!=null && serverArray!='undefined' && serverArray.length>0){
				for(var k=0;serverArray.length>k;k++)
				{
					FormParams+="&er_workgroupserver="+serverArray[k];
					FormParams+="&er_server="+serverArray[k];
				}
			}			
			
			var er_sortby=Ext.getCmp('er_sortby').getValue();
			var combobox=Ext.getCmp('er_sortby');
			var v = combobox.getValue();
			var record = combobox.findRecord(combobox.valueField || combobox.displayField, v);
			var index = combobox.store.indexOf(record)+1;
			FormParams+="&er_sortby="+er_sortby+"&er_sort_index="+index;
							
 	
			//FormParams+="&er_server="+Ext.getCmp('er_server').getValue();
						
			FormParams+="&er_priority="+mainForm.findField('er_priority').getValue()+"&sh_timeinuse="+this.getSettingsFieldValue(thinclientuserSettingsForm,'sh_timeinuse',isSettingsEnabled,'weightedAvg');
			if(serverArray ==undefined || serverArray=="-1" ||(serverArray!=null && serverArray!=undefined && serverArray.length>1)){
				var er_perserver = this.getSettingsFieldValue(thinclientuserSettingsForm,'er_perserver',isSettingsEnabled,'selectedAggServer')
				if(er_perserver!=null)
					FormParams+="&er_perserver="+er_perserver;
			}
		}
		if(isSettingsEnabled)
		{
			var dsktp_searchTxt=Ext.getCmp("dsktp_searchTxt");
			if(dsktp_searchTxt.isVisible())
			{
				FormParams+="&dsktp_searchTxt="+dsktp_searchTxt.getValue();
			}
		}

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var s_timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var s_minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var s_timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var s_minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		var timperiodParams="&timefrom="+s_timefrom+"&minfrom="+s_minfrom+"&timeto="+s_timeto+"&minto="+s_minto;
		
		var applicationTemp = Ext.getCmp('er_application').getValue();
		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields')){
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields){
				if(flag)
				{
					if(hiddenField!="schedule_id")
						hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}else
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}		
		var er_application_text_box=mainForm.findField('er_application_text_box');
		if(er_application_text_box.isHidden())
		{
			//FormParams+="&er_application="+encodeURIComponent(mainForm.findField('er_application').getValue())
			if(!Ext.getCmp('er_application').isHidden())
			{
    		//FormParams+="&er_application="+encodeURIComponent(Ext.getCmp('er_application').getValue());
    		FormParams+="&er_application="+appConstants.erUtils.specialCharEncode(Ext.getCmp('er_application').getValue());
			}
			else
				FormParams+="&er_application="+appConstants.erUtils.specialCharEncode(appConstants.er_application);
		}
		else
		{
			//FormParams+="&er_tuser="+encodeURIComponent(mainForm.findField('er_application_text_box').getValue())
			FormParams+="&er_tapplication="+encodeURIComponent(er_application_text_box.getValue());
		}
 		
		var er_option=Ext.getCmp("er_option").getValue();	
		FormParams+='&er_option='+er_option;
		
		appConstants.queryStringActivity=FormParams+timelineParams+hiddenfieldQString+timperiodParams;

		if(appConstants.isFromDrillDown!=null && appConstants.isFromDrillDown!='null'&& appConstants.isFromDrillDown!=undefined && appConstants.isFromDrillDown!='undefined' && appConstants.isFromDrillDown)
		{
			//appConstants.queryStringActivity+='&select_testmes='+appConstants.select_testmes+"&isFromDrillDown=true&er_perserver=Yes";
			  appConstants.queryStringActivity+='&select_testmes='+appConstants.select_testmes+"&isFromDrillDown=true&user_name="+appConstants.erUtils.specialCharEncode(Ext.getCmp('er_application').getValue())+"&er_test="+appConstants.us_er_test;

		}
  	},
	updateQStringUsage:function(isDisableTImeline){
		var FormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var compArray=new Array();
		var mainForm =Ext.getCmp('mainform').getForm();

		var thinclientuserSettingsForm=null;
		//
			if(!isSettingsEnabled)
				this.showConfigDropdown();
		//
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getThinclientusersettings().getForm();

	var application=mainForm.findField('er_application');
	var application_text=mainForm.findField('er_application_text_box');
		FormParams="select_farm="+encodeURIComponent(mainForm.findField('select_farm').getValue())
					+"&er_compType="+mainForm.findField('er_compType').getValue()
					+"&er_excwe="+this.getSettingsFieldValue(thinclientuserSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')
					+"&er_reportgenration="+this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
				var showFrom = mainForm.findField('showFrom');
				if (Ext.isEmpty(appConstants.erUtils))
				{
					appConstants.erUtils = Ext.widget("erutils");
				}
				if(showFrom.isVisible() || appConstants.menuForVM=='true')
				{
					FormParams+='&showFrom='+showFrom.getValue();
				}
				if(application.isVisible())
				{
					FormParams+="&er_user="+appConstants.erUtils.specialCharEncode(Ext.getCmp('er_application').getValue());
				}
				else if(application_text.isVisible())
				{
					FormParams+="&er_tuser="+encodeURIComponent(Ext.getCmp('er_application_text_box').getValue());
				}
				else if(appConstants.userState!=undefined && appConstants.userState=='textbox')
				{
					FormParams+="&er_tuser="+encodeURIComponent("*")
				}
				else if(appConstants.userState!=undefined && appConstants.userState=='dropdown')
				{
					FormParams+="&er_user="+encodeURIComponent("-- All --")
				}

				if(Ext.getCmp('er_wrkrGrp').getValue()!='notapplicable'){
					FormParams+="&er_workgrpname="+Ext.getCmp('er_wrkrGrp').getValue();
				}
			if(Ext.getCmp('er_poolType_container').isVisible())
			{
				var gpArray = Ext.getCmp('er_poolType').getValue();
				if(gpArray!=undefined)
				{
					for (var k = 0; gpArray.length > k; k++) 
					{
						FormParams += "&er_poolType=" + gpArray[k];
					}
				}
			}
			var serverArray=Ext.getCmp('er_server').getValue();
			if(serverArray!=null && serverArray!='undefined' && serverArray.length>0){
				for(var k=0;serverArray.length>k;k++)
				{
					FormParams+="&er_componentserver="+serverArray[k];
				}
			}

			if(serverArray!=null && serverArray!='undefined' && serverArray.length>0){
				for(var k=0;serverArray.length>k;k++)
				{
					FormParams+="&select_server1="+serverArray[k];
				}
			}
		//var enableOragnizeCombo=appConstants.publicjsonDataUsage.enableOragnizeCombo;
		if(appConstants.isAdDiscoverEnabled)
			FormParams+="&er_organize="+mainForm.findField('er_organize').getValue();

		var s_timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var s_minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var s_timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var s_minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		var timelineParams = "";
		if(!isDisableTImeline)
			timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		var timperiodParams="&timefrom="+s_timefrom+"&minfrom="+s_minfrom+"&timeto="+s_timeto+"&minto="+s_minto;

		if(appConstants.publicjsonDataUsage.hasOwnProperty('hiddenfields')){
			var hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
			for (var hiddenField in hiddenFields){
				if(hiddenField!=null && hiddenField=='clientIp' && (Ext.getCmp('clientIpRadio').getValue.clientIp!=null || Ext.getCmp('clientIpRadio').getValue.clientIp!='undefined') && !Ext.getCmp('clientIpRadio').isHidden())
				{
					continue;
				}
				else
				{
					hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}
			}
		}
		
				var er_adGroup= Ext.getCmp('er_adGroup');
				var adgrouppane=Ext.getCmp('adgrouppane');
				var adGroupForPrint="";
				if (adgrouppane!=undefined && !adgrouppane.isHidden())
				{
					if(er_adGroup!=undefined){
					var queryArray=er_adGroup.getValue();
						for (var key in queryArray)
						{
							FormParams+="&er_adGroup="+encodeURIComponent(queryArray[key]);
							adGroupForPrint+=queryArray[key];
							
						}
					}
				}

				if(adGroupForPrint.length>0)
				{
					if(adGroupForPrint.length>20)
						adGroupForPrint = adGroupForPrint.substring(0,19)+'...';
					FormParams+="&adGroupForPrint="+encodeURIComponent(adGroupForPrint);

				}
				var er_aduser= Ext.getCmp('er_aduser');
				var aduserinfopane=Ext.getCmp('aduserinfopane');
				if (aduserinfopane!=undefined && !aduserinfopane.isHidden())
				{
					if(er_aduser!=undefined){
					var queryArray=er_aduser.getValue();
						for (var key in queryArray)
						{
							FormParams+="&er_aduser="+encodeURIComponent(queryArray[key]);
							
						}
					}
				}
			var adGroupFns=Ext.getCmp('adGroupFns');
			if(!Ext.isEmpty(adGroupFns))
		{
				if (adGroupFns!=undefined && !adGroupFns.isHidden())
					FormParams+='&adGroupFns='+adGroupFns.getValue().adGroupByValue;
		}
		//

		if(application.isVisible())
		{
			var objVal=Ext.getCmp("er_organize").getValue();
			if(objVal=='AD')
			{
					Ext.getCmp("aggregateValue").hide();
			}else
			{
				var value=Ext.getCmp('aggregateValue').getValue();
				if(!Ext.isEmpty(value))
					FormParams+='&er_aggregateValue='+value.groupByValue;				
			}
		}else
		{
			var value=Ext.getCmp('aggregateValue').getValue();
			if(!Ext.isEmpty(value))
				FormParams+='&er_aggregateValue='+value.groupByValue;
		}
		
		var er_option=Ext.getCmp("er_option").getValue();	
		FormParams+='&er_option='+er_option;
 		if(isSettingsEnabled)
		{
			var clientIpRadio=Ext.getCmp('clientIpRadio');
			if (!clientIpRadio.isHidden() && (clientIpRadio!=null || clientIpRadio!='undefined' || clientIpRadio!='undefined'))
			{
				FormParams+='&clientIp='+clientIpRadio.getValue().clientIp;
			}
		}
		
		var showResourceDetails =this.getSettingsFieldValue(thinclientuserSettingsForm,'ShowResourceDetails',isSettingsEnabled,'ShowResourceDetails');
		FormParams+='&er_showResourceUsage='+showResourceDetails;
		if(wildcardSearch && !isVm)
		{
			var clientIpRadio=Ext.getCmp('clientIpRadio');
			if (!clientIpRadio.isHidden() && clientIpRadio.getValue().clientIp=='Yes')
				FormParams+='&client_Version='+Ext.getCmp('wildcardSearch').getValue();//.. common to user session detail report.
		}
	 
		appConstants.queryStringUsage=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
	},
	afterMainRender:function(){
		var thisController = this;
		if(targetType == 'User Session Report'){
			if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
				this.getMain().setTitle(appConstants.er_RmDispName);
			else
				this.getMain().setTitle(appConstants.publicjsonDataUsage.reportTitle);
			this.fillFormFieldsForUsage(appConstants.publicjsonDataUsage);
			//this.refreshReportData(appConstants.publicjsonDataUsage);
			if(!hideBackButton){
				Ext.getCmp('thinclientuserform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonDataUsage['ID']
				});
			}
		}
		else{
			if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
				this.getMain().setTitle(appConstants.er_RmDispName);
			else
				this.getMain().setTitle(appConstants.publicjsonDataActivity.reportTitle);
			this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
			//this.refreshReportData(appConstants.publicjsonDataActivity);
			if(!hideBackButton){
				Ext.getCmp('thinclientuserform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonDataActivity['ID']
				});
			}
		}
	},
	loadSettingsElements:function(){
		var reportCat=Ext.getCmp('report_category').getValue();
		if(reportCat == 'user_usage')
		{
			var hiddenFields =  appConstants.publicjsonDataUsage.hiddenfields;
			var favorite_id = hiddenFields["favorite_id"];
			if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		}else{
			var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;
			var favorite_id = hiddenFields["favorite_id"];
			if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		}
		Ext.getCmp('moreOptionCloseId').show();

		var thisController  =this;
		if(targetType == 'User Session Report'){
			this.fillSettingFieldsForUsage(appConstants.publicjsonDataUsage);
			Ext.getCmp('ShowResourceDetails').show();
			var clientIpRadio=Ext.getCmp("clientIpRadio");
		
					 if(appConstants.publicjsonDataUsage!=null && appConstants.publicjsonDataUsage!=undefined && appConstants.publicjsonDataUsage!='undefined')
					 {
						if (appConstants.publicjsonDataUsage.hasOwnProperty("clientDetailsCompType"))
						{
							if(clientIpRadio!=undefined)
								clientIpRadio.show();
						}
						else
						{
							if(clientIpRadio!=undefined)
								clientIpRadio.hide();
						}	
					 }
					 else
					  {
						 if(clientIpRadio!=undefined)
							clientIpRadio.hide();
					  }
				
				
			
				   if(appConstants.publicjsonDataUsage!=null && appConstants.publicjsonDataUsage!=undefined && appConstants.publicjsonDataUsage!='undefined')
				 {
					if(appConstants.publicjsonDataUsage.hasOwnProperty('er_showResourceUsage'))
					{

						var er_showResourceUsage=appConstants.publicjsonDataUsage.er_showResourceUsage;
						var showResourceDetailsComp=Ext.getCmp("ShowResourceDetails");
						if(showResourceDetailsComp!=undefined){
						if(er_showResourceUsage!=undefined)
						{
							if(er_showResourceUsage=='Yes')
								Ext.getCmp('ShowResourceDetails').setValue('Yes');
							else if(er_showResourceUsage=='No')
							{
								Ext.getCmp('ShowResourceDetails').setValue('No');
							}
						}
						}
					}
				 }
			var objVal=Ext.getCmp("er_organize");
			if(objVal!=undefined){
				objVal=objVal.getValue();
				if(objVal==null|| objVal=='User')
				{
					var adgrouppane =Ext.getCmp('adgrouppane');
					if(adgrouppane!=undefined)
						adgrouppane.hide();

					var aduserinfopane =Ext.getCmp('aduserinfopane');
					if(aduserinfopane!=undefined)
						aduserinfopane.hide();

					var adGroupFns =Ext.getCmp('adGroupFns');
					if(adGroupFns!=undefined){
						Ext.getCmp('adGroupFnsSpl').hide();
						adGroupFns.hide();
					}
					var value=Ext.getCmp('aggregateValue').getValue();
					if(!Ext.isEmpty(value))
					{	
						if(value.groupByValue=='Details')
						{
							if(clientIpRadio!=undefined)
							clientIpRadio.show();
						}
						else{
							if(clientIpRadio!=undefined)
								clientIpRadio.hide();
						}
					}
				}
				else
				{
					var adgrouppane =Ext.getCmp('adgrouppane');
					if(adgrouppane!=undefined)
						adgrouppane.show();
					var aduserinfopane =Ext.getCmp('aduserinfopane');
					if(aduserinfopane!=undefined)
						aduserinfopane.show();

					var adGroupFns =Ext.getCmp('adGroupFns');
					if(adGroupFns!=undefined){
						Ext.getCmp('adGroupFnsSpl').show();
						adGroupFns.show();
					}
					var adGroupFnsVal=adGroupFns.getValue().adGroupByValue;
					if(adGroupFnsVal != undefined && adGroupFnsVal == 'Details')
					{
						if(clientIpRadio!=undefined)
							clientIpRadio.show();
					}
					else{
						if(clientIpRadio!=undefined)
							clientIpRadio.hide();
				}
			}
			}
		}else{
			this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
			Ext.getCmp('ShowResourceDetails').hide();
			var adgrouppane =Ext.getCmp('adgrouppane');
				if(adgrouppane!=undefined)
					adgrouppane.hide();
			//
			var aduserinfopane =Ext.getCmp('aduserinfopane');
				if(aduserinfopane!=undefined)
					aduserinfopane.hide();


			var adGroupFns =Ext.getCmp('adGroupFns');
				if(adGroupFns!=undefined)
					adGroupFns.hide();
			//
		}
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndCloseSettings();
		});
		if(appConstants.fromOverviewReport =='true' && targetType == 'User Session Report'){
			if(Ext.getCmp('ShowResourceDetails') != undefined)
				Ext.getCmp('ShowResourceDetails').hide()
			if(Ext.getCmp('clientIpRadio') != undefined)
				Ext.getCmp('clientIpRadio').hide()
		}
	},
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		if(isSettingsOk)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	refreshReportData:function()
	{
		if(appConstants.isFromDrillDown!=null && appConstants.isFromDrillDown!='null'&& appConstants.isFromDrillDown!=undefined && appConstants.isFromDrillDown!='undefined' && appConstants.isFromDrillDown)
		{
			this.loadDrillDown();
			return;
		}
		var jsonData;
		if(targetType == 'User Session Report')
		{
			jsonData=appConstants.publicjsonDataUsage;
			var mainForm =Ext.getCmp('mainform').getForm();
			var zone=mainForm.findField('select_farm').getValue();
			if(jsonData.hasOwnProperty('er_showResourceUsage'))
			{
				var er_showResourceUsage=jsonData.er_showResourceUsage;
				var showResourceDetailsComp=Ext.getCmp("ShowResourceDetails");
				if(showResourceDetailsComp!=undefined){
					if(er_showResourceUsage!=undefined)
					{
						if(er_showResourceUsage=='Yes')
							Ext.getCmp('ShowResourceDetails').setValue('Yes');

						else if(er_showResourceUsage=='No')
							Ext.getCmp('ShowResourceDetails').setValue('No');
					}
				}
			}
			if(zone=='-1')
			{
				comboRawData=jsonData.zoneCombo;
				selectedComboOption=jsonData.selectedZone;
				comboObject=mainForm.findField('select_farm');
				//comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				}
				else{
					var value;
					if(comboRawData.length>1)
						value=comboRawData[1];
					else
						value=comboRawData[0];
					comboObject.setValue(value.valueField);
				}
			}
		}
		else
		{
			jsonData=appConstants.publicjsonDataActivity;
		}
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			target='/final/reporter/ErSessionAppView.jsp?index=0&fromOverviewReportDrilldown=true&er_Duration='+appConstants.er_durationValue;
			if(appConstants.fromOverviewReport =='true' && targetType == 'User Session Report'){
//				loadUsersSessionView(0)
//				window.open('/final/reporter/ErSessionAppView.jsp?index=0')
				if(Ext.getCmp('mainform') != undefined)
					Ext.getCmp('mainform').hide();
				if(Ext.getCmp('ShowResourceDetails') != undefined)
					Ext.getCmp('ShowResourceDetails').hide();
				if(Ext.getCmp('clientIpRadio') != undefined)
					Ext.getCmp('clientIpRadio').hide();

				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("csvTool").setDisabled(true);
				Ext.getCmp("favoriteTool").setDisabled(true);
				Ext.getCmp("scheduleTool").setDisabled(true);

				this.updateQStringUsage(false);

				var xtraresltPnl=Ext.getCmp('resultPanel');
				if(xtraresltPnl != undefined){
					xtraresltPnl.removeAll();
					xtraresltPnl.show();
					xtraresltPnl.add({
						xtype:'container',
						id:'dsfsdf',
						height:Ext.getBody().getViewSize().height-70,
						columnWidth:1,
						layout:'column',
						items:
						[{
							xtype: "component",
							autoEl:
							{
								tag: 'iframe',
								frameborder: '0',
								//height: '100%',
								height:Ext.getBody().getViewSize().height - 90,
								width: '100%',
								src: target
							},
							listeners:
							{
								load:
								{
									fn: function()
									{
										this.parent().unmask();
									}
								}
							}
						},{
							xtype:'button',
							text:'<span style="color:#30a1da;"><u>Show All Server Details</u></span>',
							height:20,
							margin:'5 20 10 0',
							style:{
								'float':'right',
								color:'blue',
								background:'none',
								border:'none',
							},
							listeners:{
								'click':function(){
									var trgtUrl='/final/reporter/ErThinClientUserReport.jsp?fro=true&enableBack=true&isSubmit=true';
									var application=Ext.getCmp('er_application');
									if(application.isVisible())
									{
										trgtUrl+="&er_user="+encodeURIComponent("-- All --");
									}else{
										trgtUrl+="&er_tuser="+encodeURIComponent("*");
									}
									trgtUrl+='&'+appConstants.queryStringUsage;
									window.location.href =trgtUrl;
								}
							}
						}]
					});
				}
			}else{
				initLdgMask.show();
				this.loadReportData(jsonData);
			}
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				
			
				this.showResult();
			}
		}
	},
	fillFormFieldsForActivity:function(jsonData)
	{
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		if(jsonData.hasOwnProperty('isSubmit'))
			var isSubmitted=jsonData.isSubmit;

			/*var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			var from_schedule = hiddenFields["fromScheduleModify"];
			var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
			if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
				Ext.getCmp("submit").hide();
				Ext.getCmp("save").show();
				Ext.getCmp("favoriteTool").setDisabled(true);
				Ext.getCmp("scheduleTool").setDisabled(true);
			}else{
				Ext.getCmp("submit").show();
				Ext.getCmp("save").hide();
			}*/
		//select_farm,
		var mainForm =Ext.getCmp('mainform').getForm();
		var screenLabels=jsonData.screenLabels;
		
		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}

        var start_hour = jsonData.startHour;
        var end_hour = jsonData.endHour;
        var start_date = jsonData.startDate;
        var end_date = jsonData.endDate;
        var startDateObj = mainForm.findField('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = start_date;
        var startHrObj = mainForm.findField('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = start_hour;
        var endDateObj = mainForm.findField('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = end_date;
        var endHrObj = mainForm.findField('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = end_hour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;

		 
		comboRawData=jsonData.analysisByCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedAnalysisByCombo;
			comboObject=mainForm.findField('er_option');
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}

		comboRawData=jsonData.zoneCombo;
		selectedComboOption=jsonData.selectedZone;
		comboObject=mainForm.findField('select_farm');
		comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);
		comboObject.getStore().loadRawData(comboRawData);

		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData=jsonData.compTypeCombo;
		selectedComboOption=jsonData.selectedCompType;
		comboObject=mainForm.findField('er_compType');
		comboObject.setFieldLabel(screenLabels['reporter.thin.Component Type']);
		comboObject.getStore().clearFilter(true);
		comboObject.getStore().loadRawData(comboRawData);

		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}

		var showFromRawData=jsonData.showFromCombo;
		var selectedshowFrom=jsonData.selectedShowFromCombo;
		var showFromObj=mainForm.findField('showFrom');
		//showFromObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		showFromObj.getStore().loadRawData(showFromRawData);
		if (!Ext.isEmpty(showFromRawData) )
		{
			if ( !Ext.isEmpty(selectedshowFrom) )
			{
				showFromObj.setValue(selectedshowFrom);
			}
			else
			{
				showFromObj.setValue(showFromRawData[0].valueField);
			}
		}
		if(jsonData.isVm)
		{
			isVm = true;
			var resourceDetails = Ext.getCmp('ShowResourceDetails');
			if((resourceDetails!=undefined && resourceDetails=='No')||appConstants.publicjsonDataUsage.er_showResourceUsage=='No' || appConstants.menuForVM=='true')
			{
				Ext.getCmp('showFrom').hide();
			}
			else
			{
				Ext.getCmp('showFrom').show();
			}
		}
		else
		{
			isVm = false;
			Ext.getCmp('showFrom').hide();
		}

		comboRawData=jsonData.reportForCombo;
		selectedComboOption=jsonData.reportFor;
		comboObject=mainForm.findField('report_category');
		comboObject.setFieldLabel(screenLabels['reporter.common.Report For']);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData=jsonData.reportTypeCombo;
		selectedComboOption=jsonData.selectedreportType;
		comboObject=mainForm.findField('er_type');
		comboObject.setFieldLabel(screenLabels['reporter.thin.Report Type']);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}

		if(selectedComboOption == 'No'){
			// For Loading Based on Measure Combo
			var s_sort=jsonData.sortbycombo;
			if(!Ext.isEmpty(s_sort))
			{				
				var selected_s_sort=jsonData.selectedSortbyCombo;				
				comboObject=mainForm.findField('er_sortby');
				comboObject.getStore().loadRawData(s_sort);
          				 
				if ( !Ext.isEmpty(selected_s_sort) ){
					comboObject.setValue(selected_s_sort);
				}
				else{
					comboObject.setValue(s_sort[0].valueField);
				}
				comboObject.show();
			}
			//
			mainForm.findField("select_testmes").hide();
			mainForm.findField('er_mode').hide();
			comboRawData=jsonData.serverCombo;
			selectedComboOption=jsonData.selectedServer;
			comboObject=Ext.getCmp('er_server');
			appConstants.rawDataForComponents = comboRawData;
			comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();



			//

				if(!isSettingsEnabled)
					this.showConfigDropdown();
				var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();

					if(selectedComboOption!=null && selectedComboOption!=undefined && selectedComboOption.length>1) {
						comboRawData=jsonData.aggAcrossServer;
						selectedComboOption=jsonData.selectedAggServer;
						comboObject=thinclientuserSettingsForm.findField('er_perserver');
						if(comboObject!=undefined)
						{
						comboObject.setFieldLabel(jsonData.screenLabels['reporter.thin.Aggregate across servers on']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
						}
					}
					else
					{
						comboObject=thinclientuserSettingsForm.findField('er_perserver');
						if(comboObject!=undefined)
						{
						comboObject.hide();
						}
					}

			//

			comboRawData=jsonData.userCombo;
			selectedComboOption=jsonData.selectedUser;
			comboObject=mainForm.findField('er_application');
	if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
		{
			Ext.getCmp('er_application_text_box').hide();
			comboObject.setFieldLabel(screenLabels['reporter.thin.User']);
			comboObject.getStore().clearFilter(true);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				var value=comboRawData[0].valueField;
				if(comboRawData.length>1)
					value=comboRawData[1].valueField;
				comboObject.setValue(value);
			}
			comboObject.show();
		}
		else
		{
				Ext.getCmp('er_application').hide();
				var textBoxObject=	mainForm.findField('er_application_text_box');
				textBoxObject.show();
		}
		comboRawData=jsonData.priorityCombo;
		selectedComboOption=jsonData.selectedPriority;
		comboObject=mainForm.findField('er_priority');
		comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[2].valueField);
		}
		comboObject.show();
		}
		else{
			comboRawData=jsonData.graphTypeArray;
			selectedComboOption=jsonData.selectedGraphType;
			comboObject=mainForm.findField('er_graphType');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Graph Type']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
			if(selectedComboOption=='distribution'){
				comboRawData=jsonData.measureCombo;
				selectedComboOption=jsonData.selectedMeasure;
				comboObject=mainForm.findField('select_testmes');
				comboObject.setFieldLabel(screenLabels['reporter.thin.Criteria']);
				comboObject.getStore().clearFilter(true);
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				}
				else{
					var value=comboRawData[0].valueField;
					if(comboRawData.length>1)
						value=comboRawData[1].valueField;
					comboObject.setValue(value);
				}
				comboObject.show();
			}else
			{
				mainForm.findField("select_testmes").hide();

				comboRawData=jsonData.userCombo;
				selectedComboOption=jsonData.selectedUser;
				comboObject=mainForm.findField('er_application');
		if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
			{
				Ext.getCmp('er_application_text_box').hide();
				comboObject.setFieldLabel(screenLabels['reporter.thin.User']);
				comboObject.getStore().clearFilter(true);
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				}
				else{
					var value=comboRawData[0].valueField;
					if(comboRawData.length>1)
						value=comboRawData[1].valueField;
					comboObject.setValue(value);
				}
				comboObject.show();
			}
			else
			{
					Ext.getCmp('er_application').hide();
					var textBoxObject=	mainForm.findField('er_application_text_box');
					textBoxObject.show();
			}


			}
			Ext.getCmp("serverMultiSelectLbl").hide();
			//Ext.getCmp('expandSelector').hide();
		}
		updatingAppSettings();
		
		if (Ext.getCmp('er_option').getValue()=='Component') 						
			Ext.getCmp('select_farm').hide();
		else
			Ext.getCmp('select_farm').show();

		if( Ext.getCmp('showLegend') != undefined)
		{
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
				  Ext.getCmp('showLegend').setValue(true);
		}
	},
	fillSettingFieldsForActivity:function(jsonData){
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
		var reportFor = Ext.getCmp('report_category').getValue();
		if(reportFor == 'user_activity' || reportFor == 'user_Channel'){
			var rtype=Ext.getCmp('er_type').getValue();
			var enableDesktop = jsonData.enableDesktop;
			var dsktp_searchTxt = jsonData.dsktp_searchTxt;
			if(enableDesktop=="true")
			{
				Ext.getCmp("dsktp_searchTxt").show();
				Ext.getCmp("dsktp_searchSpl").show();
				if(!Ext.isEmpty(dsktp_searchTxt))
					Ext.getCmp("dsktp_searchTxt").setValue(dsktp_searchTxt);
				
			}
			
		}
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.excludeWeekCombo;
		selectedComboOption=jsonData.excludeWeek;
		comboObject=thinclientuserSettingsForm.findField('er_excwe');
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}

		comboRawData=jsonData.weightedAvgCombo;
		selectedComboOption=jsonData.weightedAvg;
		comboObject=thinclientuserSettingsForm.findField('sh_timeinuse');
		comboObject.setFieldLabel(screenLabels['reporter.comparison.Weighted Average']);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}

		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
	},
	showConfigDropdown:function(){
			isSettingsEnabled = true;
		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'thinclientusersettings',
					parent:this
				}
			],
			renderTo:'thinclientuser'
			});

	},
	LoadDrillDownData:function( url){
		initLdgMask.show();
		var meController = this;
		var paramsForDrillDown = url.substring(url.indexOf("?")+1);
		var controller = url.substring(0,url.indexOf("?"));
		var resultPanelObj = Ext.getCmp('resultPanel');
		Ext.Ajax.request(
		{
			url : controller,
			params : paramsForDrillDown+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				if(jsonData.hasOwnProperty('drillDownData')){
					resultPanelObj.removeAll();
					var DrillDownData = jsonData['drillDownData'];
					for(var k in DrillDownData){
						var tableObj =DrillDownData[k];
						var columnDetails = tableObj['columns'];
						var dataArray = tableObj['data'];

						if(!Ext.isEmpty(dataArray))
						{

							var tabledata = '<div class="newTable" style="margin:0px 10px 10px 10px">'
							+'<table cellspacing="0" cellpadding="0" border="0" width="100%">'
								+'<thead>'
									+'<tr>';
									var colAlign='left';   	//prakash
							for( var k in columnDetails){
									   if(k==columnDetails.length-1)   	//prakash
										   colAlign='center'; 			//prakash
										tabledata+='<th>'
											+'<div align="'+colAlign+'">'+columnDetails[k]+'</div>'
										+'</th>';
							}
							tabledata+='</tr>'
								+'</thead>'
							+'<tbody>'
							+'<tpl for=".">';
							for(var j in dataArray)
							{
								var realdata=dataArray[j];
								tabledata+='<tr>';
								for(var l in realdata){
									//prakash
									var realsData = realdata[l];  
									var align='left';
									if(l==columnDetails.length-1)
									{
										align='center';
									}
									//
									tabledata+='<td>'
										+'<div style="text-align:'+align+'">'+this.getDecimalAlignFormat(realdata[l])+'</div>'
									+'</td>'
								}
								tabledata+='</tr>';
							}
							tabledata+='</tpl>'+'</tbody>'+'</table>' +'</div>';
							if (k == 1)
								resultPanelObj.add({
									xtype: 'panel',
									ui:'newGraphPanel',
									title:tableObj.tableTitle,
									margin:'10 10 5 10',
									layout: {
										columns: 2,
										align: 'center'
									},
									//cls: 'datapanel',
									tools: [
									{
										xtype: 'button',
										text:backText,
										//cls: 'backbutton',
										margin:'0 5 0 0',
										cls:'backbutton',
										iconCls: 'iconBack',
										id: 'thiClientbckButton',
										name: 'thiClientbckButton',
										listeners: {
											'click': function () {
												meController.submitReport();
											}
										}
									}],
									//bodyPadding: '0 0 0 0',
									//padding:0,
									//title:'<span class="font_bold">'+tableObj.tableTitle+'</span>',
 									html: tabledata
								});
							else
								resultPanelObj.add({
									xtype: 'panel',
									ui:'newGraphPanel',
									margin:'10 10 10 10',
									layout: {
										columns: 2,
										align: 'center'
									},
									//cls: 'datapanel',
									//bodyPadding: '0 0 0 0',
									title:tableObj.tableTitle,
 									//padding:0,
									html: tabledata
								});
						}
					}
				}
				else{
 					this.disableTools();
					resultPanelObj.show();			
 					resultPanelObj.removeAll();
					resultPanelObj.add({
					xtype: 'container',
					height: 250,
					cls:'containerShadow',
					margin:'5 10 10 10',
 					html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>'
					});
				}
				initLdgMask.hide();
			}
		});
	},	   
	//prakash
	getDecimalAlignFormat:function(value)
	{
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	},
	//
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{

		var publicJsonData=null;
		if (targetType == "User Session Report")
			publicJsonData = appConstants.publicjsonDataUsage;
		else
			publicJsonData = appConstants.publicjsonDataActivity;

		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}



		return value;
	},
	loadDrillDown:function(){
		var mainForm =Ext.getCmp('mainform').getForm();
		mainForm.findField("er_graphType").setValue("timeline");
		mainForm.findField("er_compType").setValue(appConstants.us_er_comptype);
		mainForm.findField("select_farm").setValue(appConstants.us_select_farm);
		mainForm.findField('showFrom').setValue(appConstants.us_showFrom);
		mainForm.findField('er_timeline').setValue(appConstants.us_er_timeline);
		mainForm.findField("er_compType").setReadOnly(true);
		mainForm.findField("er_graphType").setReadOnly(true);
		mainForm.findField("select_farm").setReadOnly(true);
		mainForm.findField("er_type").setReadOnly(true);
		var appln=appConstants.us_user_name;
		if(appln.includes("|slash|"))
			appln=appln.replace("|slash|", "\\");
		this.graphTypeOnChangeTemp(mainForm.findField("er_graphType"),appln);
		this.showResult();
	},
		graphTypeOnChangeTemp:function(obj,userName){
		var val=obj.getValue();
		Ext.getCmp('er_application_text_box').hide();
		if(val=='timeline')
		{
			Ext.getCmp('showLegend').show();
		}
		else
		{
			Ext.getCmp('showLegend').show();
		}

		Ext.getCmp('resultPanel').hide();
		this.updateQStringActivity();
		var url;
		if (targetType == "User Activity Report")
			url='/final/reporter/ErCtxUserActivityReportJson.jsp';
		else
			url='/final/reporter/ErCtxChannelReportJson.jsp';
		Ext.Ajax.request(
		{
			//url : '/final/reporter/ErCtxUserActivityReportJson.jsp',
			url : url,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			async:false,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				if(!isSettingsEnabled)
					this.showConfigDropdown();
				var mainForm =Ext.getCmp('mainform').getForm();
				var thinclientuserSettingsForm = this.getThinclientusersettings().getForm();
				if(val == 'timeline'){
					Ext.getCmp('select_testmes').hide();
					appConstants.publicjsonDataActivity=jsonData;
					comboRawData=jsonData.aggbasedOn;
					selectedComboOption=jsonData.selectedAgg;
					comboObject=thinclientuserSettingsForm.findField('er_perserver');
					comboObject.setFieldLabel(screenLabels['reporter.thin.Aggregate across servers']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.show();
					comboRawData=jsonData.userCombo;
					comboObject=mainForm.findField('er_application');
					comboObject.setFieldLabel(screenLabels['reporter.thin.User']);
					comboObject.getStore().clearFilter(true);
					comboObject.getStore().loadRawData(comboRawData);
					comboObject.setValue(userName);
					comboObject.show();
				}
			}
		});
	},
	loadDrillDownBack:function(){
		appConstants.isFromDrillDown=false;
		drillDownBackButton=true;
		Ext.getCmp('select_testmes').show();
		Ext.getCmp('er_application').hide();
		Ext.getCmp('bckButtonForDrillDown').hide()
		Ext.getCmp('showLegend').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		mainForm.findField("er_graphType").setValue("distribution");
		mainForm.findField("er_compType").setReadOnly(false);
		mainForm.findField("er_graphType").setReadOnly(false);
		mainForm.findField("select_farm").setReadOnly(false);
		mainForm.findField("er_type").setReadOnly(false);
	
		Ext.Ajax.request(
		{
			url : '/final/servlet/com.eg.ErCtxServerReportC?isFromDrillDownBack=true',
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				 initLdgMask.show();
				this.loadReportData(jsonData);
		
		}

		});
	}
,
multiSelectAllvalidation:function(combo,allValue)
	{
		var flag=true;
		//For descriptor all and individual desc selection validation
		var hasAll=false;
		if(combo!=null && combo!='undefined' && combo.length>0){
			for(var k=0;combo.length>k;k++)
			{
				if(combo[k]==allValue)
					hasAll=true;
				
			}
		}
		if(hasAll && combo.length>1)
		{			
			flag=false;
		}
		return flag;
	}

});

